# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbClusterArgs', 'DbCluster']

@pulumi.input_type
class DbClusterArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[str],
                 db_cluster_class: pulumi.Input[str],
                 db_cluster_network_type: pulumi.Input[str],
                 db_cluster_version: pulumi.Input[str],
                 db_node_group_count: pulumi.Input[int],
                 db_node_storage: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 storage_type: pulumi.Input[str],
                 db_cluster_access_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]] = None,
                 db_cluster_description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 used_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DbCluster resource.
        :param pulumi.Input[str] category: The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        :param pulumi.Input[str] db_cluster_class: The DBCluster class. According to the category, db_cluster_class has two value ranges:
               * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
               * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        :param pulumi.Input[str] db_cluster_network_type: The DBCluster network type. Valid values: `vpc`.
        :param pulumi.Input[str] db_cluster_version: The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        :param pulumi.Input[int] db_node_group_count: The db node group count. The number should between 1 and 48.
        :param pulumi.Input[str] db_node_storage: The db node storage.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[str] storage_type: Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        :param pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]] db_cluster_access_white_lists: The db cluster access white list. See `db_cluster_access_white_list` below.
        :param pulumi.Input[str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[str] encryption_key: Key management service KMS key ID.
        :param pulumi.Input[str] encryption_type: Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        :param pulumi.Input[str] maintain_time: The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        :param pulumi.Input[str] period: Pre-paid cluster of the pay-as-you-go cycle. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        :param pulumi.Input[str] used_time: The used time of DBCluster.
        :param pulumi.Input[str] vpc_id: The id of the VPC.
        :param pulumi.Input[str] vswitch_id: The vswitch id of DBCluster.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "db_cluster_class", db_cluster_class)
        pulumi.set(__self__, "db_cluster_network_type", db_cluster_network_type)
        pulumi.set(__self__, "db_cluster_version", db_cluster_version)
        pulumi.set(__self__, "db_node_group_count", db_node_group_count)
        pulumi.set(__self__, "db_node_storage", db_node_storage)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "storage_type", storage_type)
        if db_cluster_access_white_lists is not None:
            pulumi.set(__self__, "db_cluster_access_white_lists", db_cluster_access_white_lists)
        if db_cluster_description is not None:
            pulumi.set(__self__, "db_cluster_description", db_cluster_description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Input[str]:
        """
        The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[str]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> pulumi.Input[str]:
        """
        The DBCluster class. According to the category, db_cluster_class has two value ranges:
        * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
        * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        """
        return pulumi.get(self, "db_cluster_class")

    @db_cluster_class.setter
    def db_cluster_class(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_cluster_class", value)

    @property
    @pulumi.getter(name="dbClusterNetworkType")
    def db_cluster_network_type(self) -> pulumi.Input[str]:
        """
        The DBCluster network type. Valid values: `vpc`.
        """
        return pulumi.get(self, "db_cluster_network_type")

    @db_cluster_network_type.setter
    def db_cluster_network_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_cluster_network_type", value)

    @property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> pulumi.Input[str]:
        """
        The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        """
        return pulumi.get(self, "db_cluster_version")

    @db_cluster_version.setter
    def db_cluster_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_cluster_version", value)

    @property
    @pulumi.getter(name="dbNodeGroupCount")
    def db_node_group_count(self) -> pulumi.Input[int]:
        """
        The db node group count. The number should between 1 and 48.
        """
        return pulumi.get(self, "db_node_group_count")

    @db_node_group_count.setter
    def db_node_group_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "db_node_group_count", value)

    @property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> pulumi.Input[str]:
        """
        The db node storage.
        """
        return pulumi.get(self, "db_node_storage")

    @db_node_storage.setter
    def db_node_storage(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_node_storage", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[str]:
        """
        Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="dbClusterAccessWhiteLists")
    def db_cluster_access_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]]:
        """
        The db cluster access white list. See `db_cluster_access_white_list` below.
        """
        return pulumi.get(self, "db_cluster_access_white_lists")

    @db_cluster_access_white_lists.setter
    def db_cluster_access_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]]):
        pulumi.set(self, "db_cluster_access_white_lists", value)

    @property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> Optional[pulumi.Input[str]]:
        """
        The DBCluster description.
        """
        return pulumi.get(self, "db_cluster_description")

    @db_cluster_description.setter
    def db_cluster_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_description", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[str]]:
        """
        Key management service KMS key ID.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[str]]:
        """
        Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[str]]:
        """
        The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_time", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        Pre-paid cluster of the pay-as-you-go cycle. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[str]]:
        """
        The used time of DBCluster.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "used_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vswitch id of DBCluster.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _DbClusterState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 db_cluster_access_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]] = None,
                 db_cluster_class: Optional[pulumi.Input[str]] = None,
                 db_cluster_description: Optional[pulumi.Input[str]] = None,
                 db_cluster_network_type: Optional[pulumi.Input[str]] = None,
                 db_cluster_version: Optional[pulumi.Input[str]] = None,
                 db_node_group_count: Optional[pulumi.Input[int]] = None,
                 db_node_storage: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 used_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DbCluster resources.
        :param pulumi.Input[str] category: The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        :param pulumi.Input[str] connection_string: (Available since v1.196.0) - The connection string of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]] db_cluster_access_white_lists: The db cluster access white list. See `db_cluster_access_white_list` below.
        :param pulumi.Input[str] db_cluster_class: The DBCluster class. According to the category, db_cluster_class has two value ranges:
               * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
               * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        :param pulumi.Input[str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[str] db_cluster_network_type: The DBCluster network type. Valid values: `vpc`.
        :param pulumi.Input[str] db_cluster_version: The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        :param pulumi.Input[int] db_node_group_count: The db node group count. The number should between 1 and 48.
        :param pulumi.Input[str] db_node_storage: The db node storage.
        :param pulumi.Input[str] encryption_key: Key management service KMS key ID.
        :param pulumi.Input[str] encryption_type: Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        :param pulumi.Input[str] maintain_time: The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[str] period: Pre-paid cluster of the pay-as-you-go cycle. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] port: (Available since v1.196.0) The connection port of the cluster.
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        :param pulumi.Input[str] storage_type: Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        :param pulumi.Input[str] used_time: The used time of DBCluster.
        :param pulumi.Input[str] vpc_id: The id of the VPC.
        :param pulumi.Input[str] vswitch_id: The vswitch id of DBCluster.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if db_cluster_access_white_lists is not None:
            pulumi.set(__self__, "db_cluster_access_white_lists", db_cluster_access_white_lists)
        if db_cluster_class is not None:
            pulumi.set(__self__, "db_cluster_class", db_cluster_class)
        if db_cluster_description is not None:
            pulumi.set(__self__, "db_cluster_description", db_cluster_description)
        if db_cluster_network_type is not None:
            pulumi.set(__self__, "db_cluster_network_type", db_cluster_network_type)
        if db_cluster_version is not None:
            pulumi.set(__self__, "db_cluster_version", db_cluster_version)
        if db_node_group_count is not None:
            pulumi.set(__self__, "db_node_group_count", db_node_group_count)
        if db_node_storage is not None:
            pulumi.set(__self__, "db_node_storage", db_node_storage)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        (Available since v1.196.0) - The connection string of the cluster.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="dbClusterAccessWhiteLists")
    def db_cluster_access_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]]:
        """
        The db cluster access white list. See `db_cluster_access_white_list` below.
        """
        return pulumi.get(self, "db_cluster_access_white_lists")

    @db_cluster_access_white_lists.setter
    def db_cluster_access_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]]):
        pulumi.set(self, "db_cluster_access_white_lists", value)

    @property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> Optional[pulumi.Input[str]]:
        """
        The DBCluster class. According to the category, db_cluster_class has two value ranges:
        * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
        * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        """
        return pulumi.get(self, "db_cluster_class")

    @db_cluster_class.setter
    def db_cluster_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_class", value)

    @property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> Optional[pulumi.Input[str]]:
        """
        The DBCluster description.
        """
        return pulumi.get(self, "db_cluster_description")

    @db_cluster_description.setter
    def db_cluster_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_description", value)

    @property
    @pulumi.getter(name="dbClusterNetworkType")
    def db_cluster_network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The DBCluster network type. Valid values: `vpc`.
        """
        return pulumi.get(self, "db_cluster_network_type")

    @db_cluster_network_type.setter
    def db_cluster_network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_network_type", value)

    @property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> Optional[pulumi.Input[str]]:
        """
        The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        """
        return pulumi.get(self, "db_cluster_version")

    @db_cluster_version.setter
    def db_cluster_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_version", value)

    @property
    @pulumi.getter(name="dbNodeGroupCount")
    def db_node_group_count(self) -> Optional[pulumi.Input[int]]:
        """
        The db node group count. The number should between 1 and 48.
        """
        return pulumi.get(self, "db_node_group_count")

    @db_node_group_count.setter
    def db_node_group_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_group_count", value)

    @property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> Optional[pulumi.Input[str]]:
        """
        The db node storage.
        """
        return pulumi.get(self, "db_node_storage")

    @db_node_storage.setter
    def db_node_storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_node_storage", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[str]]:
        """
        Key management service KMS key ID.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[str]]:
        """
        Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[str]]:
        """
        The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_time", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        Pre-paid cluster of the pay-as-you-go cycle. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        (Available since v1.196.0) The connection port of the cluster.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[str]]:
        """
        The used time of DBCluster.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "used_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vswitch id of DBCluster.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class DbCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 db_cluster_access_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbClusterDbClusterAccessWhiteListArgs']]]]] = None,
                 db_cluster_class: Optional[pulumi.Input[str]] = None,
                 db_cluster_description: Optional[pulumi.Input[str]] = None,
                 db_cluster_network_type: Optional[pulumi.Input[str]] = None,
                 db_cluster_version: Optional[pulumi.Input[str]] = None,
                 db_node_group_count: Optional[pulumi.Input[int]] = None,
                 db_node_storage: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 used_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Click House DBCluster resource.

        For information about Click House DBCluster and how to use it, see [What is DBCluster](https://www.alibabacloud.com/help/zh/clickhouse/latest/api-clickhouse-2019-11-11-createdbinstance).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_regions = alicloud.clickhouse.get_regions(current=True)
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_regions.regions[0].zone_ids[0].zone_id)
        default_db_cluster = alicloud.clickhouse.DbCluster("defaultDbCluster",
            db_cluster_version="22.8.5.29",
            category="Basic",
            db_cluster_class="S8",
            db_cluster_network_type="vpc",
            db_node_group_count=1,
            payment_type="PayAsYouGo",
            db_node_storage="500",
            storage_type="cloud_essd",
            vswitch_id=default_switch.id,
            vpc_id=default_network.id)
        ```

        ## Import

        Click House DBCluster can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:clickhouse/dbCluster:DbCluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbClusterDbClusterAccessWhiteListArgs']]]] db_cluster_access_white_lists: The db cluster access white list. See `db_cluster_access_white_list` below.
        :param pulumi.Input[str] db_cluster_class: The DBCluster class. According to the category, db_cluster_class has two value ranges:
               * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
               * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        :param pulumi.Input[str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[str] db_cluster_network_type: The DBCluster network type. Valid values: `vpc`.
        :param pulumi.Input[str] db_cluster_version: The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        :param pulumi.Input[int] db_node_group_count: The db node group count. The number should between 1 and 48.
        :param pulumi.Input[str] db_node_storage: The db node storage.
        :param pulumi.Input[str] encryption_key: Key management service KMS key ID.
        :param pulumi.Input[str] encryption_type: Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        :param pulumi.Input[str] maintain_time: The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[str] period: Pre-paid cluster of the pay-as-you-go cycle. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        :param pulumi.Input[str] storage_type: Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        :param pulumi.Input[str] used_time: The used time of DBCluster.
        :param pulumi.Input[str] vpc_id: The id of the VPC.
        :param pulumi.Input[str] vswitch_id: The vswitch id of DBCluster.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Click House DBCluster resource.

        For information about Click House DBCluster and how to use it, see [What is DBCluster](https://www.alibabacloud.com/help/zh/clickhouse/latest/api-clickhouse-2019-11-11-createdbinstance).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_regions = alicloud.clickhouse.get_regions(current=True)
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_regions.regions[0].zone_ids[0].zone_id)
        default_db_cluster = alicloud.clickhouse.DbCluster("defaultDbCluster",
            db_cluster_version="22.8.5.29",
            category="Basic",
            db_cluster_class="S8",
            db_cluster_network_type="vpc",
            db_node_group_count=1,
            payment_type="PayAsYouGo",
            db_node_storage="500",
            storage_type="cloud_essd",
            vswitch_id=default_switch.id,
            vpc_id=default_network.id)
        ```

        ## Import

        Click House DBCluster can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:clickhouse/dbCluster:DbCluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DbClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 db_cluster_access_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbClusterDbClusterAccessWhiteListArgs']]]]] = None,
                 db_cluster_class: Optional[pulumi.Input[str]] = None,
                 db_cluster_description: Optional[pulumi.Input[str]] = None,
                 db_cluster_network_type: Optional[pulumi.Input[str]] = None,
                 db_cluster_version: Optional[pulumi.Input[str]] = None,
                 db_node_group_count: Optional[pulumi.Input[int]] = None,
                 db_node_storage: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 used_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbClusterArgs.__new__(DbClusterArgs)

            if category is None and not opts.urn:
                raise TypeError("Missing required property 'category'")
            __props__.__dict__["category"] = category
            __props__.__dict__["db_cluster_access_white_lists"] = db_cluster_access_white_lists
            if db_cluster_class is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_class'")
            __props__.__dict__["db_cluster_class"] = db_cluster_class
            __props__.__dict__["db_cluster_description"] = db_cluster_description
            if db_cluster_network_type is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_network_type'")
            __props__.__dict__["db_cluster_network_type"] = db_cluster_network_type
            if db_cluster_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_version'")
            __props__.__dict__["db_cluster_version"] = db_cluster_version
            if db_node_group_count is None and not opts.urn:
                raise TypeError("Missing required property 'db_node_group_count'")
            __props__.__dict__["db_node_group_count"] = db_node_group_count
            if db_node_storage is None and not opts.urn:
                raise TypeError("Missing required property 'db_node_storage'")
            __props__.__dict__["db_node_storage"] = db_node_storage
            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["encryption_type"] = encryption_type
            __props__.__dict__["maintain_time"] = maintain_time
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["status"] = status
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["used_time"] = used_time
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["port"] = None
        super(DbCluster, __self__).__init__(
            'alicloud:clickhouse/dbCluster:DbCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[str]] = None,
            connection_string: Optional[pulumi.Input[str]] = None,
            db_cluster_access_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbClusterDbClusterAccessWhiteListArgs']]]]] = None,
            db_cluster_class: Optional[pulumi.Input[str]] = None,
            db_cluster_description: Optional[pulumi.Input[str]] = None,
            db_cluster_network_type: Optional[pulumi.Input[str]] = None,
            db_cluster_version: Optional[pulumi.Input[str]] = None,
            db_node_group_count: Optional[pulumi.Input[int]] = None,
            db_node_storage: Optional[pulumi.Input[str]] = None,
            encryption_key: Optional[pulumi.Input[str]] = None,
            encryption_type: Optional[pulumi.Input[str]] = None,
            maintain_time: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_type: Optional[pulumi.Input[str]] = None,
            used_time: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'DbCluster':
        """
        Get an existing DbCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        :param pulumi.Input[str] connection_string: (Available since v1.196.0) - The connection string of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbClusterDbClusterAccessWhiteListArgs']]]] db_cluster_access_white_lists: The db cluster access white list. See `db_cluster_access_white_list` below.
        :param pulumi.Input[str] db_cluster_class: The DBCluster class. According to the category, db_cluster_class has two value ranges:
               * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
               * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        :param pulumi.Input[str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[str] db_cluster_network_type: The DBCluster network type. Valid values: `vpc`.
        :param pulumi.Input[str] db_cluster_version: The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        :param pulumi.Input[int] db_node_group_count: The db node group count. The number should between 1 and 48.
        :param pulumi.Input[str] db_node_storage: The db node storage.
        :param pulumi.Input[str] encryption_key: Key management service KMS key ID.
        :param pulumi.Input[str] encryption_type: Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        :param pulumi.Input[str] maintain_time: The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[str] period: Pre-paid cluster of the pay-as-you-go cycle. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] port: (Available since v1.196.0) The connection port of the cluster.
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        :param pulumi.Input[str] storage_type: Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        :param pulumi.Input[str] used_time: The used time of DBCluster.
        :param pulumi.Input[str] vpc_id: The id of the VPC.
        :param pulumi.Input[str] vswitch_id: The vswitch id of DBCluster.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbClusterState.__new__(_DbClusterState)

        __props__.__dict__["category"] = category
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["db_cluster_access_white_lists"] = db_cluster_access_white_lists
        __props__.__dict__["db_cluster_class"] = db_cluster_class
        __props__.__dict__["db_cluster_description"] = db_cluster_description
        __props__.__dict__["db_cluster_network_type"] = db_cluster_network_type
        __props__.__dict__["db_cluster_version"] = db_cluster_version
        __props__.__dict__["db_node_group_count"] = db_node_group_count
        __props__.__dict__["db_node_storage"] = db_node_storage
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["encryption_type"] = encryption_type
        __props__.__dict__["maintain_time"] = maintain_time
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["port"] = port
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["used_time"] = used_time
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return DbCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[str]:
        """
        The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[str]:
        """
        (Available since v1.196.0) - The connection string of the cluster.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="dbClusterAccessWhiteLists")
    def db_cluster_access_white_lists(self) -> pulumi.Output[Optional[Sequence['outputs.DbClusterDbClusterAccessWhiteList']]]:
        """
        The db cluster access white list. See `db_cluster_access_white_list` below.
        """
        return pulumi.get(self, "db_cluster_access_white_lists")

    @property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> pulumi.Output[str]:
        """
        The DBCluster class. According to the category, db_cluster_class has two value ranges:
        * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
        * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        """
        return pulumi.get(self, "db_cluster_class")

    @property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> pulumi.Output[str]:
        """
        The DBCluster description.
        """
        return pulumi.get(self, "db_cluster_description")

    @property
    @pulumi.getter(name="dbClusterNetworkType")
    def db_cluster_network_type(self) -> pulumi.Output[str]:
        """
        The DBCluster network type. Valid values: `vpc`.
        """
        return pulumi.get(self, "db_cluster_network_type")

    @property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> pulumi.Output[str]:
        """
        The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        """
        return pulumi.get(self, "db_cluster_version")

    @property
    @pulumi.getter(name="dbNodeGroupCount")
    def db_node_group_count(self) -> pulumi.Output[int]:
        """
        The db node group count. The number should between 1 and 48.
        """
        return pulumi.get(self, "db_node_group_count")

    @property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> pulumi.Output[str]:
        """
        The db node storage.
        """
        return pulumi.get(self, "db_node_storage")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[Optional[str]]:
        """
        Key management service KMS key ID.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Output[Optional[str]]:
        """
        Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> pulumi.Output[str]:
        """
        The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        """
        return pulumi.get(self, "maintain_time")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[str]]:
        """
        Pre-paid cluster of the pay-as-you-go cycle. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[str]:
        """
        (Available since v1.196.0) The connection port of the cluster.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[str]:
        """
        Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> pulumi.Output[Optional[str]]:
        """
        The used time of DBCluster.
        """
        return pulumi.get(self, "used_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        The vswitch id of DBCluster.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

