# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccountsResult',
    'AwaitableGetAccountsResult',
    'get_accounts',
    'get_accounts_output',
]

@pulumi.output_type
class GetAccountsResult:
    """
    A collection of values returned by getAccounts.
    """
    def __init__(__self__, accounts=None, db_cluster_id=None, id=None, ids=None, name_regex=None, names=None, output_file=None, status=None):
        if accounts and not isinstance(accounts, list):
            raise TypeError("Expected argument 'accounts' to be a list")
        pulumi.set(__self__, "accounts", accounts)
        if db_cluster_id and not isinstance(db_cluster_id, str):
            raise TypeError("Expected argument 'db_cluster_id' to be a str")
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def accounts(self) -> Sequence['outputs.GetAccountsAccountResult']:
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> str:
        return pulumi.get(self, "db_cluster_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetAccountsResult(GetAccountsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountsResult(
            accounts=self.accounts,
            db_cluster_id=self.db_cluster_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status)


def get_accounts(db_cluster_id: Optional[str] = None,
                 ids: Optional[Sequence[str]] = None,
                 name_regex: Optional[str] = None,
                 output_file: Optional[str] = None,
                 status: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountsResult:
    """
    This data source provides the Click House Accounts of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.134.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "testaccountname"
    pwd = config.get("pwd")
    if pwd is None:
        pwd = "Tf-testpwd"
    default_db_cluster = alicloud.clickhouse.DbCluster("defaultDbCluster",
        db_cluster_version="20.3.10.75",
        category="Basic",
        db_cluster_class="S8",
        db_cluster_network_type="vpc",
        db_cluster_description=name,
        db_node_group_count=1,
        payment_type="PayAsYouGo",
        db_node_storage="500",
        storage_type="cloud_essd",
        vswitch_id="your_vswitch_id")
    default_account = alicloud.clickhouse.Account("defaultAccount",
        db_cluster_id=default_db_cluster.id,
        account_description="your_description",
        account_name=name,
        account_password=pwd)
    default_accounts = alicloud.clickhouse.get_accounts_output(ids=[default_account.id],
        db_cluster_id=default_db_cluster.id)
    pulumi.export("accountId", default_accounts.ids[0])
    ```


    :param str db_cluster_id: The DBCluster id.
    :param Sequence[str] ids: A list of Account IDs. Its element value is same as Account Name.
    :param str name_regex: A regex string to filter results by Account name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the resource.
    """
    __args__ = dict()
    __args__['dbClusterId'] = db_cluster_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:clickhouse/getAccounts:getAccounts', __args__, opts=opts, typ=GetAccountsResult).value

    return AwaitableGetAccountsResult(
        accounts=pulumi.get(__ret__, 'accounts'),
        db_cluster_id=pulumi.get(__ret__, 'db_cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_accounts)
def get_accounts_output(db_cluster_id: Optional[pulumi.Input[str]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[str]]] = None,
                        status: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccountsResult]:
    """
    This data source provides the Click House Accounts of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.134.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "testaccountname"
    pwd = config.get("pwd")
    if pwd is None:
        pwd = "Tf-testpwd"
    default_db_cluster = alicloud.clickhouse.DbCluster("defaultDbCluster",
        db_cluster_version="20.3.10.75",
        category="Basic",
        db_cluster_class="S8",
        db_cluster_network_type="vpc",
        db_cluster_description=name,
        db_node_group_count=1,
        payment_type="PayAsYouGo",
        db_node_storage="500",
        storage_type="cloud_essd",
        vswitch_id="your_vswitch_id")
    default_account = alicloud.clickhouse.Account("defaultAccount",
        db_cluster_id=default_db_cluster.id,
        account_description="your_description",
        account_name=name,
        account_password=pwd)
    default_accounts = alicloud.clickhouse.get_accounts_output(ids=[default_account.id],
        db_cluster_id=default_db_cluster.id)
    pulumi.export("accountId", default_accounts.ids[0])
    ```


    :param str db_cluster_id: The DBCluster id.
    :param Sequence[str] ids: A list of Account IDs. Its element value is same as Account Name.
    :param str name_regex: A regex string to filter results by Account name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the resource.
    """
    ...
