# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NetworkAttachmentArgs', 'NetworkAttachment']

@pulumi.input_type
class NetworkAttachmentArgs:
    def __init__(__self__, *,
                 ccn_id: pulumi.Input[str],
                 sag_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a NetworkAttachment resource.
        :param pulumi.Input[str] ccn_id: The ID of the CCN instance.
        :param pulumi.Input[str] sag_id: The ID of the Smart Access Gateway instance.
        """
        pulumi.set(__self__, "ccn_id", ccn_id)
        pulumi.set(__self__, "sag_id", sag_id)

    @property
    @pulumi.getter(name="ccnId")
    def ccn_id(self) -> pulumi.Input[str]:
        """
        The ID of the CCN instance.
        """
        return pulumi.get(self, "ccn_id")

    @ccn_id.setter
    def ccn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ccn_id", value)

    @property
    @pulumi.getter(name="sagId")
    def sag_id(self) -> pulumi.Input[str]:
        """
        The ID of the Smart Access Gateway instance.
        """
        return pulumi.get(self, "sag_id")

    @sag_id.setter
    def sag_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sag_id", value)


@pulumi.input_type
class _NetworkAttachmentState:
    def __init__(__self__, *,
                 ccn_id: Optional[pulumi.Input[str]] = None,
                 sag_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NetworkAttachment resources.
        :param pulumi.Input[str] ccn_id: The ID of the CCN instance.
        :param pulumi.Input[str] sag_id: The ID of the Smart Access Gateway instance.
        """
        if ccn_id is not None:
            pulumi.set(__self__, "ccn_id", ccn_id)
        if sag_id is not None:
            pulumi.set(__self__, "sag_id", sag_id)

    @property
    @pulumi.getter(name="ccnId")
    def ccn_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the CCN instance.
        """
        return pulumi.get(self, "ccn_id")

    @ccn_id.setter
    def ccn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ccn_id", value)

    @property
    @pulumi.getter(name="sagId")
    def sag_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Smart Access Gateway instance.
        """
        return pulumi.get(self, "sag_id")

    @sag_id.setter
    def sag_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sag_id", value)


class NetworkAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ccn_id: Optional[pulumi.Input[str]] = None,
                 sag_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloud Connect Network Attachment resource. This topic describes how to associate a Smart Access Gateway (SAG) instance with a network instance. You must associate an SAG instance with a network instance if you want to connect the SAG to Alibaba Cloud. You can connect an SAG to Alibaba Cloud through a leased line, the Internet, or the active and standby links.

        For information about Cloud Connect Network Attachment and how to use it, see [What is Cloud Connect Network Attachment](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/bindsmartaccessgateway).

        > **NOTE:** Available since v1.64.0.

        > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-2`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        sag_id = config.get("sagId")
        if sag_id is None:
            sag_id = "sag-9bifkf***"
        default_network = alicloud.cloudconnect.Network("defaultNetwork",
            description=name,
            cidr_block="192.168.0.0/24",
            is_default=True)
        default_network_attachment = alicloud.cloudconnect.NetworkAttachment("defaultNetworkAttachment",
            ccn_id=default_network.id,
            sag_id=sag_id)
        ```

        ## Import

        The Cloud Connect Network Attachment can be imported using the instance_id, e.g.

        ```sh
         $ pulumi import alicloud:cloudconnect/networkAttachment:NetworkAttachment example ccn-abc123456:sag-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ccn_id: The ID of the CCN instance.
        :param pulumi.Input[str] sag_id: The ID of the Smart Access Gateway instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Connect Network Attachment resource. This topic describes how to associate a Smart Access Gateway (SAG) instance with a network instance. You must associate an SAG instance with a network instance if you want to connect the SAG to Alibaba Cloud. You can connect an SAG to Alibaba Cloud through a leased line, the Internet, or the active and standby links.

        For information about Cloud Connect Network Attachment and how to use it, see [What is Cloud Connect Network Attachment](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/bindsmartaccessgateway).

        > **NOTE:** Available since v1.64.0.

        > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-2`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        sag_id = config.get("sagId")
        if sag_id is None:
            sag_id = "sag-9bifkf***"
        default_network = alicloud.cloudconnect.Network("defaultNetwork",
            description=name,
            cidr_block="192.168.0.0/24",
            is_default=True)
        default_network_attachment = alicloud.cloudconnect.NetworkAttachment("defaultNetworkAttachment",
            ccn_id=default_network.id,
            sag_id=sag_id)
        ```

        ## Import

        The Cloud Connect Network Attachment can be imported using the instance_id, e.g.

        ```sh
         $ pulumi import alicloud:cloudconnect/networkAttachment:NetworkAttachment example ccn-abc123456:sag-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param NetworkAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ccn_id: Optional[pulumi.Input[str]] = None,
                 sag_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAttachmentArgs.__new__(NetworkAttachmentArgs)

            if ccn_id is None and not opts.urn:
                raise TypeError("Missing required property 'ccn_id'")
            __props__.__dict__["ccn_id"] = ccn_id
            if sag_id is None and not opts.urn:
                raise TypeError("Missing required property 'sag_id'")
            __props__.__dict__["sag_id"] = sag_id
        super(NetworkAttachment, __self__).__init__(
            'alicloud:cloudconnect/networkAttachment:NetworkAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ccn_id: Optional[pulumi.Input[str]] = None,
            sag_id: Optional[pulumi.Input[str]] = None) -> 'NetworkAttachment':
        """
        Get an existing NetworkAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ccn_id: The ID of the CCN instance.
        :param pulumi.Input[str] sag_id: The ID of the Smart Access Gateway instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAttachmentState.__new__(_NetworkAttachmentState)

        __props__.__dict__["ccn_id"] = ccn_id
        __props__.__dict__["sag_id"] = sag_id
        return NetworkAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ccnId")
    def ccn_id(self) -> pulumi.Output[str]:
        """
        The ID of the CCN instance.
        """
        return pulumi.get(self, "ccn_id")

    @property
    @pulumi.getter(name="sagId")
    def sag_id(self) -> pulumi.Output[str]:
        """
        The ID of the Smart Access Gateway instance.
        """
        return pulumi.get(self, "sag_id")

