# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ControlPolicyArgs', 'ControlPolicy']

@pulumi.input_type
class ControlPolicyArgs:
    def __init__(__self__, *,
                 acl_action: pulumi.Input[str],
                 application_name: pulumi.Input[str],
                 description: pulumi.Input[str],
                 destination: pulumi.Input[str],
                 destination_type: pulumi.Input[str],
                 direction: pulumi.Input[str],
                 proto: pulumi.Input[str],
                 source: pulumi.Input[str],
                 source_type: pulumi.Input[str],
                 dest_port: Optional[pulumi.Input[str]] = None,
                 dest_port_group: Optional[pulumi.Input[str]] = None,
                 dest_port_type: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 release: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ControlPolicy resource.
        :param pulumi.Input[str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[str] application_name: The application type that the access control policy supports.If `direction` is `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
        :param pulumi.Input[str] description: The description of the access control policy.
        :param pulumi.Input[str] destination: The destination address defined in the access control policy.
        :param pulumi.Input[str] destination_type: DestinationType. Valid values: If Direction is `in`, the valid values are `net`, `group`. If `direction` is `out`, the valid values are `net`, `group`, `domain`, `location`.
        :param pulumi.Input[str] direction: Direction. Valid values: `in`, `out`.
        :param pulumi.Input[str] proto: Proto. Valid values: ` TCP`, ` UDP`, `ANY`, `ICMP`.
        :param pulumi.Input[str] source: Source.
        :param pulumi.Input[str] source_type: SourceType. Valid values: If `direction` is `in`, the valid values are `net`, `group`, `location`. If `direction` is `out`, the valid values are `net`, `group`.
        :param pulumi.Input[str] dest_port: The destination port defined in the access control policy.
        :param pulumi.Input[str] dest_port_group: The destination port address book defined in the access control policy.
        :param pulumi.Input[str] dest_port_type: The destination port type defined in the access control policy. Valid values: `group`, `port`.
        :param pulumi.Input[str] ip_version: The ip version.
        :param pulumi.Input[str] lang: DestPortGroupPorts. Valid values: `en`, `zh`.
        :param pulumi.Input[str] release: Specifies whether the access control policy is enabled. By default, an access control policy is enabled after it is created. Valid values: `true`, `false`.
        :param pulumi.Input[str] source_ip: The source ip.
        """
        pulumi.set(__self__, "acl_action", acl_action)
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "proto", proto)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_type", source_type)
        if dest_port is not None:
            pulumi.set(__self__, "dest_port", dest_port)
        if dest_port_group is not None:
            pulumi.set(__self__, "dest_port_group", dest_port_group)
        if dest_port_type is not None:
            pulumi.set(__self__, "dest_port_type", dest_port_type)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if release is not None:
            pulumi.set(__self__, "release", release)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)

    @property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> pulumi.Input[str]:
        """
        The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        """
        return pulumi.get(self, "acl_action")

    @acl_action.setter
    def acl_action(self, value: pulumi.Input[str]):
        pulumi.set(self, "acl_action", value)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Input[str]:
        """
        The application type that the access control policy supports.If `direction` is `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_name", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the access control policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        The destination address defined in the access control policy.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Input[str]:
        """
        DestinationType. Valid values: If Direction is `in`, the valid values are `net`, `group`. If `direction` is `out`, the valid values are `net`, `group`, `domain`, `location`.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_type", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[str]:
        """
        Direction. Valid values: `in`, `out`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def proto(self) -> pulumi.Input[str]:
        """
        Proto. Valid values: ` TCP`, ` UDP`, `ANY`, `ICMP`.
        """
        return pulumi.get(self, "proto")

    @proto.setter
    def proto(self, value: pulumi.Input[str]):
        pulumi.set(self, "proto", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        Source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[str]:
        """
        SourceType. Valid values: If `direction` is `in`, the valid values are `net`, `group`, `location`. If `direction` is `out`, the valid values are `net`, `group`.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[pulumi.Input[str]]:
        """
        The destination port defined in the access control policy.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dest_port", value)

    @property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> Optional[pulumi.Input[str]]:
        """
        The destination port address book defined in the access control policy.
        """
        return pulumi.get(self, "dest_port_group")

    @dest_port_group.setter
    def dest_port_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dest_port_group", value)

    @property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> Optional[pulumi.Input[str]]:
        """
        The destination port type defined in the access control policy. Valid values: `group`, `port`.
        """
        return pulumi.get(self, "dest_port_type")

    @dest_port_type.setter
    def dest_port_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dest_port_type", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The ip version.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[str]]:
        """
        DestPortGroupPorts. Valid values: `en`, `zh`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lang", value)

    @property
    @pulumi.getter
    def release(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the access control policy is enabled. By default, an access control policy is enabled after it is created. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "release")

    @release.setter
    def release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release", value)

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The source ip.
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ip", value)


@pulumi.input_type
class _ControlPolicyState:
    def __init__(__self__, *,
                 acl_action: Optional[pulumi.Input[str]] = None,
                 acl_uuid: Optional[pulumi.Input[str]] = None,
                 application_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dest_port: Optional[pulumi.Input[str]] = None,
                 dest_port_group: Optional[pulumi.Input[str]] = None,
                 dest_port_type: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 destination_type: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 proto: Optional[pulumi.Input[str]] = None,
                 release: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ControlPolicy resources.
        :param pulumi.Input[str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[str] acl_uuid: (Available in v1.148.0+) The unique ID of the access control policy.
        :param pulumi.Input[str] application_name: The application type that the access control policy supports.If `direction` is `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
        :param pulumi.Input[str] description: The description of the access control policy.
        :param pulumi.Input[str] dest_port: The destination port defined in the access control policy.
        :param pulumi.Input[str] dest_port_group: The destination port address book defined in the access control policy.
        :param pulumi.Input[str] dest_port_type: The destination port type defined in the access control policy. Valid values: `group`, `port`.
        :param pulumi.Input[str] destination: The destination address defined in the access control policy.
        :param pulumi.Input[str] destination_type: DestinationType. Valid values: If Direction is `in`, the valid values are `net`, `group`. If `direction` is `out`, the valid values are `net`, `group`, `domain`, `location`.
        :param pulumi.Input[str] direction: Direction. Valid values: `in`, `out`.
        :param pulumi.Input[str] ip_version: The ip version.
        :param pulumi.Input[str] lang: DestPortGroupPorts. Valid values: `en`, `zh`.
        :param pulumi.Input[str] proto: Proto. Valid values: ` TCP`, ` UDP`, `ANY`, `ICMP`.
        :param pulumi.Input[str] release: Specifies whether the access control policy is enabled. By default, an access control policy is enabled after it is created. Valid values: `true`, `false`.
        :param pulumi.Input[str] source: Source.
        :param pulumi.Input[str] source_ip: The source ip.
        :param pulumi.Input[str] source_type: SourceType. Valid values: If `direction` is `in`, the valid values are `net`, `group`, `location`. If `direction` is `out`, the valid values are `net`, `group`.
        """
        if acl_action is not None:
            pulumi.set(__self__, "acl_action", acl_action)
        if acl_uuid is not None:
            pulumi.set(__self__, "acl_uuid", acl_uuid)
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dest_port is not None:
            pulumi.set(__self__, "dest_port", dest_port)
        if dest_port_group is not None:
            pulumi.set(__self__, "dest_port_group", dest_port_group)
        if dest_port_type is not None:
            pulumi.set(__self__, "dest_port_type", dest_port_type)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if proto is not None:
            pulumi.set(__self__, "proto", proto)
        if release is not None:
            pulumi.set(__self__, "release", release)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> Optional[pulumi.Input[str]]:
        """
        The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        """
        return pulumi.get(self, "acl_action")

    @acl_action.setter
    def acl_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_action", value)

    @property
    @pulumi.getter(name="aclUuid")
    def acl_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        (Available in v1.148.0+) The unique ID of the access control policy.
        """
        return pulumi.get(self, "acl_uuid")

    @acl_uuid.setter
    def acl_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_uuid", value)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[pulumi.Input[str]]:
        """
        The application type that the access control policy supports.If `direction` is `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the access control policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[pulumi.Input[str]]:
        """
        The destination port defined in the access control policy.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dest_port", value)

    @property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> Optional[pulumi.Input[str]]:
        """
        The destination port address book defined in the access control policy.
        """
        return pulumi.get(self, "dest_port_group")

    @dest_port_group.setter
    def dest_port_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dest_port_group", value)

    @property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> Optional[pulumi.Input[str]]:
        """
        The destination port type defined in the access control policy. Valid values: `group`, `port`.
        """
        return pulumi.get(self, "dest_port_type")

    @dest_port_type.setter
    def dest_port_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dest_port_type", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        The destination address defined in the access control policy.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[str]]:
        """
        DestinationType. Valid values: If Direction is `in`, the valid values are `net`, `group`. If `direction` is `out`, the valid values are `net`, `group`, `domain`, `location`.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_type", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[str]]:
        """
        Direction. Valid values: `in`, `out`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The ip version.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[str]]:
        """
        DestPortGroupPorts. Valid values: `en`, `zh`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lang", value)

    @property
    @pulumi.getter
    def proto(self) -> Optional[pulumi.Input[str]]:
        """
        Proto. Valid values: ` TCP`, ` UDP`, `ANY`, `ICMP`.
        """
        return pulumi.get(self, "proto")

    @proto.setter
    def proto(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proto", value)

    @property
    @pulumi.getter
    def release(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the access control policy is enabled. By default, an access control policy is enabled after it is created. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "release")

    @release.setter
    def release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The source ip.
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ip", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        """
        SourceType. Valid values: If `direction` is `in`, the valid values are `net`, `group`, `location`. If `direction` is `out`, the valid values are `net`, `group`.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)


class ControlPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_action: Optional[pulumi.Input[str]] = None,
                 application_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dest_port: Optional[pulumi.Input[str]] = None,
                 dest_port_group: Optional[pulumi.Input[str]] = None,
                 dest_port_type: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 destination_type: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 proto: Optional[pulumi.Input[str]] = None,
                 release: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloud Firewall Control Policy resource.

        For information about Cloud Firewall Control Policy and how to use it, see [What is Control Policy](https://www.alibabacloud.com/help/doc-detail/138867.htm).

        > **NOTE:** Available in v1.129.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.cloudfirewall.ControlPolicy("example",
            acl_action="accept",
            application_name="ANY",
            description="example",
            destination="100.1.1.0/24",
            destination_type="net",
            direction="out",
            proto="ANY",
            source="1.2.3.0/24",
            source_type="net")
        ```

        ## Import

        Cloud Firewall Control Policy can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cloudfirewall/controlPolicy:ControlPolicy example <acl_uuid>:<direction>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[str] application_name: The application type that the access control policy supports.If `direction` is `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
        :param pulumi.Input[str] description: The description of the access control policy.
        :param pulumi.Input[str] dest_port: The destination port defined in the access control policy.
        :param pulumi.Input[str] dest_port_group: The destination port address book defined in the access control policy.
        :param pulumi.Input[str] dest_port_type: The destination port type defined in the access control policy. Valid values: `group`, `port`.
        :param pulumi.Input[str] destination: The destination address defined in the access control policy.
        :param pulumi.Input[str] destination_type: DestinationType. Valid values: If Direction is `in`, the valid values are `net`, `group`. If `direction` is `out`, the valid values are `net`, `group`, `domain`, `location`.
        :param pulumi.Input[str] direction: Direction. Valid values: `in`, `out`.
        :param pulumi.Input[str] ip_version: The ip version.
        :param pulumi.Input[str] lang: DestPortGroupPorts. Valid values: `en`, `zh`.
        :param pulumi.Input[str] proto: Proto. Valid values: ` TCP`, ` UDP`, `ANY`, `ICMP`.
        :param pulumi.Input[str] release: Specifies whether the access control policy is enabled. By default, an access control policy is enabled after it is created. Valid values: `true`, `false`.
        :param pulumi.Input[str] source: Source.
        :param pulumi.Input[str] source_ip: The source ip.
        :param pulumi.Input[str] source_type: SourceType. Valid values: If `direction` is `in`, the valid values are `net`, `group`, `location`. If `direction` is `out`, the valid values are `net`, `group`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ControlPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Firewall Control Policy resource.

        For information about Cloud Firewall Control Policy and how to use it, see [What is Control Policy](https://www.alibabacloud.com/help/doc-detail/138867.htm).

        > **NOTE:** Available in v1.129.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.cloudfirewall.ControlPolicy("example",
            acl_action="accept",
            application_name="ANY",
            description="example",
            destination="100.1.1.0/24",
            destination_type="net",
            direction="out",
            proto="ANY",
            source="1.2.3.0/24",
            source_type="net")
        ```

        ## Import

        Cloud Firewall Control Policy can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cloudfirewall/controlPolicy:ControlPolicy example <acl_uuid>:<direction>
        ```

        :param str resource_name: The name of the resource.
        :param ControlPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ControlPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_action: Optional[pulumi.Input[str]] = None,
                 application_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dest_port: Optional[pulumi.Input[str]] = None,
                 dest_port_group: Optional[pulumi.Input[str]] = None,
                 dest_port_type: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 destination_type: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 proto: Optional[pulumi.Input[str]] = None,
                 release: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ControlPolicyArgs.__new__(ControlPolicyArgs)

            if acl_action is None and not opts.urn:
                raise TypeError("Missing required property 'acl_action'")
            __props__.__dict__["acl_action"] = acl_action
            if application_name is None and not opts.urn:
                raise TypeError("Missing required property 'application_name'")
            __props__.__dict__["application_name"] = application_name
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["dest_port"] = dest_port
            __props__.__dict__["dest_port_group"] = dest_port_group
            __props__.__dict__["dest_port_type"] = dest_port_type
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            if destination_type is None and not opts.urn:
                raise TypeError("Missing required property 'destination_type'")
            __props__.__dict__["destination_type"] = destination_type
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["lang"] = lang
            if proto is None and not opts.urn:
                raise TypeError("Missing required property 'proto'")
            __props__.__dict__["proto"] = proto
            __props__.__dict__["release"] = release
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["source_ip"] = source_ip
            if source_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_type'")
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["acl_uuid"] = None
        super(ControlPolicy, __self__).__init__(
            'alicloud:cloudfirewall/controlPolicy:ControlPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_action: Optional[pulumi.Input[str]] = None,
            acl_uuid: Optional[pulumi.Input[str]] = None,
            application_name: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dest_port: Optional[pulumi.Input[str]] = None,
            dest_port_group: Optional[pulumi.Input[str]] = None,
            dest_port_type: Optional[pulumi.Input[str]] = None,
            destination: Optional[pulumi.Input[str]] = None,
            destination_type: Optional[pulumi.Input[str]] = None,
            direction: Optional[pulumi.Input[str]] = None,
            ip_version: Optional[pulumi.Input[str]] = None,
            lang: Optional[pulumi.Input[str]] = None,
            proto: Optional[pulumi.Input[str]] = None,
            release: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            source_ip: Optional[pulumi.Input[str]] = None,
            source_type: Optional[pulumi.Input[str]] = None) -> 'ControlPolicy':
        """
        Get an existing ControlPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[str] acl_uuid: (Available in v1.148.0+) The unique ID of the access control policy.
        :param pulumi.Input[str] application_name: The application type that the access control policy supports.If `direction` is `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
        :param pulumi.Input[str] description: The description of the access control policy.
        :param pulumi.Input[str] dest_port: The destination port defined in the access control policy.
        :param pulumi.Input[str] dest_port_group: The destination port address book defined in the access control policy.
        :param pulumi.Input[str] dest_port_type: The destination port type defined in the access control policy. Valid values: `group`, `port`.
        :param pulumi.Input[str] destination: The destination address defined in the access control policy.
        :param pulumi.Input[str] destination_type: DestinationType. Valid values: If Direction is `in`, the valid values are `net`, `group`. If `direction` is `out`, the valid values are `net`, `group`, `domain`, `location`.
        :param pulumi.Input[str] direction: Direction. Valid values: `in`, `out`.
        :param pulumi.Input[str] ip_version: The ip version.
        :param pulumi.Input[str] lang: DestPortGroupPorts. Valid values: `en`, `zh`.
        :param pulumi.Input[str] proto: Proto. Valid values: ` TCP`, ` UDP`, `ANY`, `ICMP`.
        :param pulumi.Input[str] release: Specifies whether the access control policy is enabled. By default, an access control policy is enabled after it is created. Valid values: `true`, `false`.
        :param pulumi.Input[str] source: Source.
        :param pulumi.Input[str] source_ip: The source ip.
        :param pulumi.Input[str] source_type: SourceType. Valid values: If `direction` is `in`, the valid values are `net`, `group`, `location`. If `direction` is `out`, the valid values are `net`, `group`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ControlPolicyState.__new__(_ControlPolicyState)

        __props__.__dict__["acl_action"] = acl_action
        __props__.__dict__["acl_uuid"] = acl_uuid
        __props__.__dict__["application_name"] = application_name
        __props__.__dict__["description"] = description
        __props__.__dict__["dest_port"] = dest_port
        __props__.__dict__["dest_port_group"] = dest_port_group
        __props__.__dict__["dest_port_type"] = dest_port_type
        __props__.__dict__["destination"] = destination
        __props__.__dict__["destination_type"] = destination_type
        __props__.__dict__["direction"] = direction
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["lang"] = lang
        __props__.__dict__["proto"] = proto
        __props__.__dict__["release"] = release
        __props__.__dict__["source"] = source
        __props__.__dict__["source_ip"] = source_ip
        __props__.__dict__["source_type"] = source_type
        return ControlPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> pulumi.Output[str]:
        """
        The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        """
        return pulumi.get(self, "acl_action")

    @property
    @pulumi.getter(name="aclUuid")
    def acl_uuid(self) -> pulumi.Output[str]:
        """
        (Available in v1.148.0+) The unique ID of the access control policy.
        """
        return pulumi.get(self, "acl_uuid")

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Output[str]:
        """
        The application type that the access control policy supports.If `direction` is `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the access control policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> pulumi.Output[str]:
        """
        The destination port defined in the access control policy.
        """
        return pulumi.get(self, "dest_port")

    @property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> pulumi.Output[str]:
        """
        The destination port address book defined in the access control policy.
        """
        return pulumi.get(self, "dest_port_group")

    @property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> pulumi.Output[str]:
        """
        The destination port type defined in the access control policy. Valid values: `group`, `port`.
        """
        return pulumi.get(self, "dest_port_type")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[str]:
        """
        The destination address defined in the access control policy.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Output[str]:
        """
        DestinationType. Valid values: If Direction is `in`, the valid values are `net`, `group`. If `direction` is `out`, the valid values are `net`, `group`, `domain`, `location`.
        """
        return pulumi.get(self, "destination_type")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[str]:
        """
        Direction. Valid values: `in`, `out`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[str]]:
        """
        The ip version.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[str]]:
        """
        DestPortGroupPorts. Valid values: `en`, `zh`.
        """
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter
    def proto(self) -> pulumi.Output[str]:
        """
        Proto. Valid values: ` TCP`, ` UDP`, `ANY`, `ICMP`.
        """
        return pulumi.get(self, "proto")

    @property
    @pulumi.getter
    def release(self) -> pulumi.Output[str]:
        """
        Specifies whether the access control policy is enabled. By default, an access control policy is enabled after it is created. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "release")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        Source.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> pulumi.Output[str]:
        """
        The source ip.
        """
        return pulumi.get(self, "source_ip")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[str]:
        """
        SourceType. Valid values: If `direction` is `in`, the valid values are `net`, `group`, `location`. If `direction` is `out`, the valid values are `net`, `group`.
        """
        return pulumi.get(self, "source_type")

