# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcFirewallCensResult',
    'AwaitableGetVpcFirewallCensResult',
    'get_vpc_firewall_cens',
    'get_vpc_firewall_cens_output',
]

@pulumi.output_type
class GetVpcFirewallCensResult:
    """
    A collection of values returned by getVpcFirewallCens.
    """
    def __init__(__self__, cen_id=None, cens=None, id=None, ids=None, lang=None, member_uid=None, network_instance_id=None, output_file=None, page_number=None, page_size=None, status=None, vpc_firewall_id=None, vpc_firewall_name=None):
        if cen_id and not isinstance(cen_id, str):
            raise TypeError("Expected argument 'cen_id' to be a str")
        pulumi.set(__self__, "cen_id", cen_id)
        if cens and not isinstance(cens, list):
            raise TypeError("Expected argument 'cens' to be a list")
        pulumi.set(__self__, "cens", cens)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if lang and not isinstance(lang, str):
            raise TypeError("Expected argument 'lang' to be a str")
        pulumi.set(__self__, "lang", lang)
        if member_uid and not isinstance(member_uid, str):
            raise TypeError("Expected argument 'member_uid' to be a str")
        pulumi.set(__self__, "member_uid", member_uid)
        if network_instance_id and not isinstance(network_instance_id, str):
            raise TypeError("Expected argument 'network_instance_id' to be a str")
        pulumi.set(__self__, "network_instance_id", network_instance_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpc_firewall_id and not isinstance(vpc_firewall_id, str):
            raise TypeError("Expected argument 'vpc_firewall_id' to be a str")
        pulumi.set(__self__, "vpc_firewall_id", vpc_firewall_id)
        if vpc_firewall_name and not isinstance(vpc_firewall_name, str):
            raise TypeError("Expected argument 'vpc_firewall_name' to be a str")
        pulumi.set(__self__, "vpc_firewall_name", vpc_firewall_name)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter
    def cens(self) -> Sequence['outputs.GetVpcFirewallCensCenResult']:
        """
        A list of Vpc Firewall Cen Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "cens")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list of Vpc Firewall Cen IDs.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def lang(self) -> Optional[str]:
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> Optional[str]:
        """
        The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
        """
        return pulumi.get(self, "member_uid")

    @property
    @pulumi.getter(name="networkInstanceId")
    def network_instance_id(self) -> Optional[str]:
        """
        The ID of the VPC instance that created the VPC firewall.
        """
        return pulumi.get(self, "network_instance_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[int]:
        return pulumi.get(self, "page_number")

    @property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[int]:
        return pulumi.get(self, "page_size")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Firewall switch status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> Optional[str]:
        """
        VPC firewall ID
        """
        return pulumi.get(self, "vpc_firewall_id")

    @property
    @pulumi.getter(name="vpcFirewallName")
    def vpc_firewall_name(self) -> Optional[str]:
        """
        The name of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_name")


class AwaitableGetVpcFirewallCensResult(GetVpcFirewallCensResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcFirewallCensResult(
            cen_id=self.cen_id,
            cens=self.cens,
            id=self.id,
            ids=self.ids,
            lang=self.lang,
            member_uid=self.member_uid,
            network_instance_id=self.network_instance_id,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            status=self.status,
            vpc_firewall_id=self.vpc_firewall_id,
            vpc_firewall_name=self.vpc_firewall_name)


def get_vpc_firewall_cens(cen_id: Optional[str] = None,
                          ids: Optional[Sequence[str]] = None,
                          lang: Optional[str] = None,
                          member_uid: Optional[str] = None,
                          network_instance_id: Optional[str] = None,
                          output_file: Optional[str] = None,
                          page_number: Optional[int] = None,
                          page_size: Optional[int] = None,
                          status: Optional[str] = None,
                          vpc_firewall_id: Optional[str] = None,
                          vpc_firewall_name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcFirewallCensResult:
    """
    This data source provides Cloud Firewall Vpc Firewall Cen available to the user.[What is Vpc Firewall Cen](https://www.alibabacloud.com/help/en/cloud-firewall/latest/describevpcfirewallcenlist)

    > **NOTE:** Available in 1.194.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cloudfirewall.get_vpc_firewall_cens(ids=[alicloud_cloud_firewall_vpc_firewall_cen["default"]["id"]],
        cen_id="cen-cjok7uyb5w2b27573v",
        member_uid="1415189284827022",
        status="closed",
        vpc_firewall_name="tf-test")
    pulumi.export("alicloudCloudFirewallVpcFirewallCenExampleId", default.cens[0].id)
    ```


    :param str cen_id: The ID of the CEN instance.
    :param Sequence[str] ids: A list of Vpc Firewall Cen IDs.
    :param str lang: The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
    :param str member_uid: The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
    :param str network_instance_id: The ID of the VPC instance that created the VPC firewall.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: Firewall switch status
    :param str vpc_firewall_id: VPC firewall ID
    :param str vpc_firewall_name: The name of the VPC firewall instance.
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['ids'] = ids
    __args__['lang'] = lang
    __args__['memberUid'] = member_uid
    __args__['networkInstanceId'] = network_instance_id
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    __args__['vpcFirewallId'] = vpc_firewall_id
    __args__['vpcFirewallName'] = vpc_firewall_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudfirewall/getVpcFirewallCens:getVpcFirewallCens', __args__, opts=opts, typ=GetVpcFirewallCensResult).value

    return AwaitableGetVpcFirewallCensResult(
        cen_id=pulumi.get(__ret__, 'cen_id'),
        cens=pulumi.get(__ret__, 'cens'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        lang=pulumi.get(__ret__, 'lang'),
        member_uid=pulumi.get(__ret__, 'member_uid'),
        network_instance_id=pulumi.get(__ret__, 'network_instance_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        status=pulumi.get(__ret__, 'status'),
        vpc_firewall_id=pulumi.get(__ret__, 'vpc_firewall_id'),
        vpc_firewall_name=pulumi.get(__ret__, 'vpc_firewall_name'))


@_utilities.lift_output_func(get_vpc_firewall_cens)
def get_vpc_firewall_cens_output(cen_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 lang: Optional[pulumi.Input[Optional[str]]] = None,
                                 member_uid: Optional[pulumi.Input[Optional[str]]] = None,
                                 network_instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                 page_number: Optional[pulumi.Input[Optional[int]]] = None,
                                 page_size: Optional[pulumi.Input[Optional[int]]] = None,
                                 status: Optional[pulumi.Input[Optional[str]]] = None,
                                 vpc_firewall_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 vpc_firewall_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVpcFirewallCensResult]:
    """
    This data source provides Cloud Firewall Vpc Firewall Cen available to the user.[What is Vpc Firewall Cen](https://www.alibabacloud.com/help/en/cloud-firewall/latest/describevpcfirewallcenlist)

    > **NOTE:** Available in 1.194.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cloudfirewall.get_vpc_firewall_cens(ids=[alicloud_cloud_firewall_vpc_firewall_cen["default"]["id"]],
        cen_id="cen-cjok7uyb5w2b27573v",
        member_uid="1415189284827022",
        status="closed",
        vpc_firewall_name="tf-test")
    pulumi.export("alicloudCloudFirewallVpcFirewallCenExampleId", default.cens[0].id)
    ```


    :param str cen_id: The ID of the CEN instance.
    :param Sequence[str] ids: A list of Vpc Firewall Cen IDs.
    :param str lang: The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
    :param str member_uid: The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
    :param str network_instance_id: The ID of the VPC instance that created the VPC firewall.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: Firewall switch status
    :param str vpc_firewall_id: VPC firewall ID
    :param str vpc_firewall_name: The name of the VPC firewall instance.
    """
    ...
