# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 band_width: pulumi.Input[int],
                 cfw_log: pulumi.Input[bool],
                 ip_number: pulumi.Input[int],
                 payment_type: pulumi.Input[str],
                 period: pulumi.Input[int],
                 spec: pulumi.Input[str],
                 account_number: Optional[pulumi.Input[int]] = None,
                 cfw_account: Optional[pulumi.Input[bool]] = None,
                 cfw_log_storage: Optional[pulumi.Input[int]] = None,
                 fw_vpc_number: Optional[pulumi.Input[int]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 logistics: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renewal_duration: Optional[pulumi.Input[int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[str]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[int] band_width: Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        :param pulumi.Input[bool] cfw_log: Whether to use log audit. Valid values: `true`, `false`.
        :param pulumi.Input[int] ip_number: The number of public IPs that can be protected. Valid values: 20 to 4000.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[int] period: The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available in 1.204.1+.
        :param pulumi.Input[str] spec: Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        :param pulumi.Input[int] account_number: The number of multi account. It will be ignored when `cfw_account = false`.
        :param pulumi.Input[bool] cfw_account: Whether to use multi-account. Valid values: `true`, `false`.
        :param pulumi.Input[int] cfw_log_storage: The log storage capacity. It will be ignored when `cfw_log = false`.
        :param pulumi.Input[int] fw_vpc_number: The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        :param pulumi.Input[int] instance_count: The number of assets.
        :param pulumi.Input[str] logistics: The logistics.
        :param pulumi.Input[str] modify_type: The type of modification. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute an update operation.
        :param pulumi.Input[int] renew_period: Automatic renewal period. Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.
        :param pulumi.Input[int] renewal_duration: Auto-Renewal Duration. It is required under the condition that renewal_status is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
        :param pulumi.Input[str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] renewal_status: Whether to renew an instance automatically or not. Default to "ManualRenewal".
        """
        pulumi.set(__self__, "band_width", band_width)
        pulumi.set(__self__, "cfw_log", cfw_log)
        pulumi.set(__self__, "ip_number", ip_number)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "spec", spec)
        if account_number is not None:
            pulumi.set(__self__, "account_number", account_number)
        if cfw_account is not None:
            pulumi.set(__self__, "cfw_account", cfw_account)
        if cfw_log_storage is not None:
            pulumi.set(__self__, "cfw_log_storage", cfw_log_storage)
        if fw_vpc_number is not None:
            pulumi.set(__self__, "fw_vpc_number", fw_vpc_number)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if logistics is not None:
            pulumi.set(__self__, "logistics", logistics)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if renew_period is not None:
            warnings.warn("""Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""", DeprecationWarning)
            pulumi.log.warn("""renew_period is deprecated: Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""")
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_duration is not None:
            pulumi.set(__self__, "renewal_duration", renewal_duration)
        if renewal_duration_unit is not None:
            pulumi.set(__self__, "renewal_duration_unit", renewal_duration_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)

    @property
    @pulumi.getter(name="bandWidth")
    def band_width(self) -> pulumi.Input[int]:
        """
        Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        """
        return pulumi.get(self, "band_width")

    @band_width.setter
    def band_width(self, value: pulumi.Input[int]):
        pulumi.set(self, "band_width", value)

    @property
    @pulumi.getter(name="cfwLog")
    def cfw_log(self) -> pulumi.Input[bool]:
        """
        Whether to use log audit. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "cfw_log")

    @cfw_log.setter
    def cfw_log(self, value: pulumi.Input[bool]):
        pulumi.set(self, "cfw_log", value)

    @property
    @pulumi.getter(name="ipNumber")
    def ip_number(self) -> pulumi.Input[int]:
        """
        The number of public IPs that can be protected. Valid values: 20 to 4000.
        """
        return pulumi.get(self, "ip_number")

    @ip_number.setter
    def ip_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "ip_number", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The payment type of the resource. Valid values: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[int]:
        """
        The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available in 1.204.1+.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[int]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input[str]:
        """
        Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input[str]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of multi account. It will be ignored when `cfw_account = false`.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_number", value)

    @property
    @pulumi.getter(name="cfwAccount")
    def cfw_account(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use multi-account. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "cfw_account")

    @cfw_account.setter
    def cfw_account(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cfw_account", value)

    @property
    @pulumi.getter(name="cfwLogStorage")
    def cfw_log_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The log storage capacity. It will be ignored when `cfw_log = false`.
        """
        return pulumi.get(self, "cfw_log_storage")

    @cfw_log_storage.setter
    def cfw_log_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cfw_log_storage", value)

    @property
    @pulumi.getter(name="fwVpcNumber")
    def fw_vpc_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        """
        return pulumi.get(self, "fw_vpc_number")

    @fw_vpc_number.setter
    def fw_vpc_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fw_vpc_number", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of assets.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter
    def logistics(self) -> Optional[pulumi.Input[str]]:
        """
        The logistics.
        """
        return pulumi.get(self, "logistics")

    @logistics.setter
    def logistics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logistics", value)

    @property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of modification. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute an update operation.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_type", value)

    @property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Automatic renewal period. Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.
        """
        warnings.warn("""Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""", DeprecationWarning)
        pulumi.log.warn("""renew_period is deprecated: Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""")

        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renew_period", value)

    @property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-Renewal Duration. It is required under the condition that renewal_status is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
        """
        return pulumi.get(self, "renewal_duration")

    @renewal_duration.setter
    def renewal_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renewal_duration", value)

    @property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @renewal_duration_unit.setter
    def renewal_duration_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_duration_unit", value)

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to renew an instance automatically or not. Default to "ManualRenewal".
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_status", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 account_number: Optional[pulumi.Input[int]] = None,
                 band_width: Optional[pulumi.Input[int]] = None,
                 cfw_account: Optional[pulumi.Input[bool]] = None,
                 cfw_log: Optional[pulumi.Input[bool]] = None,
                 cfw_log_storage: Optional[pulumi.Input[int]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 fw_vpc_number: Optional[pulumi.Input[int]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 ip_number: Optional[pulumi.Input[int]] = None,
                 logistics: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 release_time: Optional[pulumi.Input[str]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renewal_duration: Optional[pulumi.Input[int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[str]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[int] account_number: The number of multi account. It will be ignored when `cfw_account = false`.
        :param pulumi.Input[int] band_width: Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        :param pulumi.Input[bool] cfw_account: Whether to use multi-account. Valid values: `true`, `false`.
        :param pulumi.Input[bool] cfw_log: Whether to use log audit. Valid values: `true`, `false`.
        :param pulumi.Input[int] cfw_log_storage: The log storage capacity. It will be ignored when `cfw_log = false`.
        :param pulumi.Input[str] create_time: The creation time.
        :param pulumi.Input[str] end_time: The end time.
        :param pulumi.Input[int] fw_vpc_number: The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        :param pulumi.Input[int] instance_count: The number of assets.
        :param pulumi.Input[int] ip_number: The number of public IPs that can be protected. Valid values: 20 to 4000.
        :param pulumi.Input[str] logistics: The logistics.
        :param pulumi.Input[str] modify_type: The type of modification. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute an update operation.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[int] period: The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available in 1.204.1+.
        :param pulumi.Input[str] release_time: The release time.
        :param pulumi.Input[int] renew_period: Automatic renewal period. Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.
        :param pulumi.Input[int] renewal_duration: Auto-Renewal Duration. It is required under the condition that renewal_status is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
        :param pulumi.Input[str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] renewal_status: Whether to renew an instance automatically or not. Default to "ManualRenewal".
        :param pulumi.Input[str] spec: Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        :param pulumi.Input[str] status: The status of Instance.
        """
        if account_number is not None:
            pulumi.set(__self__, "account_number", account_number)
        if band_width is not None:
            pulumi.set(__self__, "band_width", band_width)
        if cfw_account is not None:
            pulumi.set(__self__, "cfw_account", cfw_account)
        if cfw_log is not None:
            pulumi.set(__self__, "cfw_log", cfw_log)
        if cfw_log_storage is not None:
            pulumi.set(__self__, "cfw_log_storage", cfw_log_storage)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if fw_vpc_number is not None:
            pulumi.set(__self__, "fw_vpc_number", fw_vpc_number)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if ip_number is not None:
            pulumi.set(__self__, "ip_number", ip_number)
        if logistics is not None:
            pulumi.set(__self__, "logistics", logistics)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if release_time is not None:
            pulumi.set(__self__, "release_time", release_time)
        if renew_period is not None:
            warnings.warn("""Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""", DeprecationWarning)
            pulumi.log.warn("""renew_period is deprecated: Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""")
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_duration is not None:
            pulumi.set(__self__, "renewal_duration", renewal_duration)
        if renewal_duration_unit is not None:
            pulumi.set(__self__, "renewal_duration_unit", renewal_duration_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of multi account. It will be ignored when `cfw_account = false`.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_number", value)

    @property
    @pulumi.getter(name="bandWidth")
    def band_width(self) -> Optional[pulumi.Input[int]]:
        """
        Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        """
        return pulumi.get(self, "band_width")

    @band_width.setter
    def band_width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "band_width", value)

    @property
    @pulumi.getter(name="cfwAccount")
    def cfw_account(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use multi-account. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "cfw_account")

    @cfw_account.setter
    def cfw_account(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cfw_account", value)

    @property
    @pulumi.getter(name="cfwLog")
    def cfw_log(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use log audit. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "cfw_log")

    @cfw_log.setter
    def cfw_log(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cfw_log", value)

    @property
    @pulumi.getter(name="cfwLogStorage")
    def cfw_log_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The log storage capacity. It will be ignored when `cfw_log = false`.
        """
        return pulumi.get(self, "cfw_log_storage")

    @cfw_log_storage.setter
    def cfw_log_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cfw_log_storage", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The end time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="fwVpcNumber")
    def fw_vpc_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        """
        return pulumi.get(self, "fw_vpc_number")

    @fw_vpc_number.setter
    def fw_vpc_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fw_vpc_number", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of assets.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="ipNumber")
    def ip_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of public IPs that can be protected. Valid values: 20 to 4000.
        """
        return pulumi.get(self, "ip_number")

    @ip_number.setter
    def ip_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_number", value)

    @property
    @pulumi.getter
    def logistics(self) -> Optional[pulumi.Input[str]]:
        """
        The logistics.
        """
        return pulumi.get(self, "logistics")

    @logistics.setter
    def logistics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logistics", value)

    @property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of modification. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute an update operation.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_type", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource. Valid values: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available in 1.204.1+.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="releaseTime")
    def release_time(self) -> Optional[pulumi.Input[str]]:
        """
        The release time.
        """
        return pulumi.get(self, "release_time")

    @release_time.setter
    def release_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_time", value)

    @property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Automatic renewal period. Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.
        """
        warnings.warn("""Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""", DeprecationWarning)
        pulumi.log.warn("""renew_period is deprecated: Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""")

        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renew_period", value)

    @property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-Renewal Duration. It is required under the condition that renewal_status is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
        """
        return pulumi.get(self, "renewal_duration")

    @renewal_duration.setter
    def renewal_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renewal_duration", value)

    @property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @renewal_duration_unit.setter
    def renewal_duration_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_duration_unit", value)

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to renew an instance automatically or not. Default to "ManualRenewal".
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_status", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[str]]:
        """
        Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of Instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_number: Optional[pulumi.Input[int]] = None,
                 band_width: Optional[pulumi.Input[int]] = None,
                 cfw_account: Optional[pulumi.Input[bool]] = None,
                 cfw_log: Optional[pulumi.Input[bool]] = None,
                 cfw_log_storage: Optional[pulumi.Input[int]] = None,
                 fw_vpc_number: Optional[pulumi.Input[int]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 ip_number: Optional[pulumi.Input[int]] = None,
                 logistics: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renewal_duration: Optional[pulumi.Input[int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[str]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloud Firewall Instance resource.

        For information about Cloud Firewall Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/product/90174.htm).

        > **NOTE:** Available since v1.139.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.cloudfirewall.Instance("example",
            band_width=10,
            cfw_log=True,
            cfw_log_storage=1000,
            ip_number=20,
            payment_type="Subscription",
            period=1,
            spec="premium_version")
        ```

        ## Import

        Cloud Firewall Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cloudfirewall/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] account_number: The number of multi account. It will be ignored when `cfw_account = false`.
        :param pulumi.Input[int] band_width: Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        :param pulumi.Input[bool] cfw_account: Whether to use multi-account. Valid values: `true`, `false`.
        :param pulumi.Input[bool] cfw_log: Whether to use log audit. Valid values: `true`, `false`.
        :param pulumi.Input[int] cfw_log_storage: The log storage capacity. It will be ignored when `cfw_log = false`.
        :param pulumi.Input[int] fw_vpc_number: The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        :param pulumi.Input[int] instance_count: The number of assets.
        :param pulumi.Input[int] ip_number: The number of public IPs that can be protected. Valid values: 20 to 4000.
        :param pulumi.Input[str] logistics: The logistics.
        :param pulumi.Input[str] modify_type: The type of modification. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute an update operation.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[int] period: The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available in 1.204.1+.
        :param pulumi.Input[int] renew_period: Automatic renewal period. Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.
        :param pulumi.Input[int] renewal_duration: Auto-Renewal Duration. It is required under the condition that renewal_status is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
        :param pulumi.Input[str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] renewal_status: Whether to renew an instance automatically or not. Default to "ManualRenewal".
        :param pulumi.Input[str] spec: Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Firewall Instance resource.

        For information about Cloud Firewall Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/product/90174.htm).

        > **NOTE:** Available since v1.139.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.cloudfirewall.Instance("example",
            band_width=10,
            cfw_log=True,
            cfw_log_storage=1000,
            ip_number=20,
            payment_type="Subscription",
            period=1,
            spec="premium_version")
        ```

        ## Import

        Cloud Firewall Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cloudfirewall/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_number: Optional[pulumi.Input[int]] = None,
                 band_width: Optional[pulumi.Input[int]] = None,
                 cfw_account: Optional[pulumi.Input[bool]] = None,
                 cfw_log: Optional[pulumi.Input[bool]] = None,
                 cfw_log_storage: Optional[pulumi.Input[int]] = None,
                 fw_vpc_number: Optional[pulumi.Input[int]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 ip_number: Optional[pulumi.Input[int]] = None,
                 logistics: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renewal_duration: Optional[pulumi.Input[int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[str]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["account_number"] = account_number
            if band_width is None and not opts.urn:
                raise TypeError("Missing required property 'band_width'")
            __props__.__dict__["band_width"] = band_width
            __props__.__dict__["cfw_account"] = cfw_account
            if cfw_log is None and not opts.urn:
                raise TypeError("Missing required property 'cfw_log'")
            __props__.__dict__["cfw_log"] = cfw_log
            __props__.__dict__["cfw_log_storage"] = cfw_log_storage
            __props__.__dict__["fw_vpc_number"] = fw_vpc_number
            __props__.__dict__["instance_count"] = instance_count
            if ip_number is None and not opts.urn:
                raise TypeError("Missing required property 'ip_number'")
            __props__.__dict__["ip_number"] = ip_number
            __props__.__dict__["logistics"] = logistics
            __props__.__dict__["modify_type"] = modify_type
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            __props__.__dict__["renew_period"] = renew_period
            __props__.__dict__["renewal_duration"] = renewal_duration
            __props__.__dict__["renewal_duration_unit"] = renewal_duration_unit
            __props__.__dict__["renewal_status"] = renewal_status
            if spec is None and not opts.urn:
                raise TypeError("Missing required property 'spec'")
            __props__.__dict__["spec"] = spec
            __props__.__dict__["create_time"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["release_time"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:cloudfirewall/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_number: Optional[pulumi.Input[int]] = None,
            band_width: Optional[pulumi.Input[int]] = None,
            cfw_account: Optional[pulumi.Input[bool]] = None,
            cfw_log: Optional[pulumi.Input[bool]] = None,
            cfw_log_storage: Optional[pulumi.Input[int]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            end_time: Optional[pulumi.Input[str]] = None,
            fw_vpc_number: Optional[pulumi.Input[int]] = None,
            instance_count: Optional[pulumi.Input[int]] = None,
            ip_number: Optional[pulumi.Input[int]] = None,
            logistics: Optional[pulumi.Input[str]] = None,
            modify_type: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            release_time: Optional[pulumi.Input[str]] = None,
            renew_period: Optional[pulumi.Input[int]] = None,
            renewal_duration: Optional[pulumi.Input[int]] = None,
            renewal_duration_unit: Optional[pulumi.Input[str]] = None,
            renewal_status: Optional[pulumi.Input[str]] = None,
            spec: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] account_number: The number of multi account. It will be ignored when `cfw_account = false`.
        :param pulumi.Input[int] band_width: Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        :param pulumi.Input[bool] cfw_account: Whether to use multi-account. Valid values: `true`, `false`.
        :param pulumi.Input[bool] cfw_log: Whether to use log audit. Valid values: `true`, `false`.
        :param pulumi.Input[int] cfw_log_storage: The log storage capacity. It will be ignored when `cfw_log = false`.
        :param pulumi.Input[str] create_time: The creation time.
        :param pulumi.Input[str] end_time: The end time.
        :param pulumi.Input[int] fw_vpc_number: The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        :param pulumi.Input[int] instance_count: The number of assets.
        :param pulumi.Input[int] ip_number: The number of public IPs that can be protected. Valid values: 20 to 4000.
        :param pulumi.Input[str] logistics: The logistics.
        :param pulumi.Input[str] modify_type: The type of modification. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute an update operation.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[int] period: The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available in 1.204.1+.
        :param pulumi.Input[str] release_time: The release time.
        :param pulumi.Input[int] renew_period: Automatic renewal period. Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.
        :param pulumi.Input[int] renewal_duration: Auto-Renewal Duration. It is required under the condition that renewal_status is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
        :param pulumi.Input[str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] renewal_status: Whether to renew an instance automatically or not. Default to "ManualRenewal".
        :param pulumi.Input[str] spec: Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        :param pulumi.Input[str] status: The status of Instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["account_number"] = account_number
        __props__.__dict__["band_width"] = band_width
        __props__.__dict__["cfw_account"] = cfw_account
        __props__.__dict__["cfw_log"] = cfw_log
        __props__.__dict__["cfw_log_storage"] = cfw_log_storage
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["fw_vpc_number"] = fw_vpc_number
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["ip_number"] = ip_number
        __props__.__dict__["logistics"] = logistics
        __props__.__dict__["modify_type"] = modify_type
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["release_time"] = release_time
        __props__.__dict__["renew_period"] = renew_period
        __props__.__dict__["renewal_duration"] = renewal_duration
        __props__.__dict__["renewal_duration_unit"] = renewal_duration_unit
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["spec"] = spec
        __props__.__dict__["status"] = status
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> pulumi.Output[Optional[int]]:
        """
        The number of multi account. It will be ignored when `cfw_account = false`.
        """
        return pulumi.get(self, "account_number")

    @property
    @pulumi.getter(name="bandWidth")
    def band_width(self) -> pulumi.Output[int]:
        """
        Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        """
        return pulumi.get(self, "band_width")

    @property
    @pulumi.getter(name="cfwAccount")
    def cfw_account(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to use multi-account. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "cfw_account")

    @property
    @pulumi.getter(name="cfwLog")
    def cfw_log(self) -> pulumi.Output[bool]:
        """
        Whether to use log audit. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "cfw_log")

    @property
    @pulumi.getter(name="cfwLogStorage")
    def cfw_log_storage(self) -> pulumi.Output[Optional[int]]:
        """
        The log storage capacity. It will be ignored when `cfw_log = false`.
        """
        return pulumi.get(self, "cfw_log_storage")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[str]:
        """
        The end time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="fwVpcNumber")
    def fw_vpc_number(self) -> pulumi.Output[Optional[int]]:
        """
        The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        """
        return pulumi.get(self, "fw_vpc_number")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[Optional[int]]:
        """
        The number of assets.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="ipNumber")
    def ip_number(self) -> pulumi.Output[int]:
        """
        The number of public IPs that can be protected. Valid values: 20 to 4000.
        """
        return pulumi.get(self, "ip_number")

    @property
    @pulumi.getter
    def logistics(self) -> pulumi.Output[Optional[str]]:
        """
        The logistics.
        """
        return pulumi.get(self, "logistics")

    @property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of modification. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute an update operation.
        """
        return pulumi.get(self, "modify_type")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type of the resource. Valid values: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[int]:
        """
        The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available in 1.204.1+.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="releaseTime")
    def release_time(self) -> pulumi.Output[str]:
        """
        The release time.
        """
        return pulumi.get(self, "release_time")

    @property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> pulumi.Output[int]:
        """
        Automatic renewal period. Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.
        """
        warnings.warn("""Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""", DeprecationWarning)
        pulumi.log.warn("""renew_period is deprecated: Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""")

        return pulumi.get(self, "renew_period")

    @property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> pulumi.Output[int]:
        """
        Auto-Renewal Duration. It is required under the condition that renewal_status is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
        """
        return pulumi.get(self, "renewal_duration")

    @property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[str]:
        """
        Whether to renew an instance automatically or not. Default to "ManualRenewal".
        """
        return pulumi.get(self, "renewal_status")

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Output[str]:
        """
        Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of Instance.
        """
        return pulumi.get(self, "status")

