# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AccessConfigurationPermissionPolicy',
    'DirectorySamlIdentityProviderConfiguration',
    'GetAccessAssignmentsAssignmentResult',
    'GetAccessConfigurationsConfigurationResult',
    'GetAccessConfigurationsConfigurationPermissionPolicyResult',
    'GetDirectoriesDirectoryResult',
    'GetDirectoriesDirectorySamlIdentityProviderConfigurationResult',
    'GetDirectoriesDirectoryTaskResult',
    'GetGroupsGroupResult',
    'GetScimServerCredentialsCredentialResult',
    'GetUsersUserResult',
    'GetUsersUserMfaDeviceResult',
]

@pulumi.output_type
class AccessConfigurationPermissionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permissionPolicyName":
            suggest = "permission_policy_name"
        elif key == "permissionPolicyType":
            suggest = "permission_policy_type"
        elif key == "permissionPolicyDocument":
            suggest = "permission_policy_document"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessConfigurationPermissionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessConfigurationPermissionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessConfigurationPermissionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission_policy_name: str,
                 permission_policy_type: str,
                 permission_policy_document: Optional[str] = None):
        """
        :param str permission_policy_name: The Policy Name of policy. The name of the resource.
        :param str permission_policy_type: The Policy Type of policy. Valid values: `System`, `Inline`.
        :param str permission_policy_document: The Content of Policy.
        """
        pulumi.set(__self__, "permission_policy_name", permission_policy_name)
        pulumi.set(__self__, "permission_policy_type", permission_policy_type)
        if permission_policy_document is not None:
            pulumi.set(__self__, "permission_policy_document", permission_policy_document)

    @property
    @pulumi.getter(name="permissionPolicyName")
    def permission_policy_name(self) -> str:
        """
        The Policy Name of policy. The name of the resource.
        """
        return pulumi.get(self, "permission_policy_name")

    @property
    @pulumi.getter(name="permissionPolicyType")
    def permission_policy_type(self) -> str:
        """
        The Policy Type of policy. Valid values: `System`, `Inline`.
        """
        return pulumi.get(self, "permission_policy_type")

    @property
    @pulumi.getter(name="permissionPolicyDocument")
    def permission_policy_document(self) -> Optional[str]:
        """
        The Content of Policy.
        """
        return pulumi.get(self, "permission_policy_document")


@pulumi.output_type
class DirectorySamlIdentityProviderConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encodedMetadataDocument":
            suggest = "encoded_metadata_document"
        elif key == "ssoStatus":
            suggest = "sso_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectorySamlIdentityProviderConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectorySamlIdentityProviderConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectorySamlIdentityProviderConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoded_metadata_document: Optional[str] = None,
                 sso_status: Optional[str] = None):
        """
        :param str encoded_metadata_document: Base64 encoded IdP metadata document. **NOTE:** If the IdP Metadata has been uploaded, no update will be made if this parameter is not specified, otherwise the update will be made according to the parameter content. If IdP Metadata has not been uploaded, and the parameter `sso_status` is `Enabled`, this parameter must be provided. If the IdP Metadata has not been uploaded, and the parameter `sso_status` is `Disabled`, this parameter can be omitted, and the IdP Metadata will remain empty.
        :param str sso_status: SAML SSO login enabled status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        """
        if encoded_metadata_document is not None:
            pulumi.set(__self__, "encoded_metadata_document", encoded_metadata_document)
        if sso_status is not None:
            pulumi.set(__self__, "sso_status", sso_status)

    @property
    @pulumi.getter(name="encodedMetadataDocument")
    def encoded_metadata_document(self) -> Optional[str]:
        """
        Base64 encoded IdP metadata document. **NOTE:** If the IdP Metadata has been uploaded, no update will be made if this parameter is not specified, otherwise the update will be made according to the parameter content. If IdP Metadata has not been uploaded, and the parameter `sso_status` is `Enabled`, this parameter must be provided. If the IdP Metadata has not been uploaded, and the parameter `sso_status` is `Disabled`, this parameter can be omitted, and the IdP Metadata will remain empty.
        """
        return pulumi.get(self, "encoded_metadata_document")

    @property
    @pulumi.getter(name="ssoStatus")
    def sso_status(self) -> Optional[str]:
        """
        SAML SSO login enabled status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        """
        return pulumi.get(self, "sso_status")


@pulumi.output_type
class GetAccessAssignmentsAssignmentResult(dict):
    def __init__(__self__, *,
                 access_configuration_id: str,
                 access_configuration_name: str,
                 directory_id: str,
                 id: str,
                 principal_id: str,
                 principal_name: str,
                 principal_type: str,
                 target_id: str,
                 target_name: str,
                 target_path_name: str,
                 target_type: str):
        """
        :param str access_configuration_id: Access configuration ID.
        :param str access_configuration_name: The name of the access configuration.
        :param str directory_id: Directory ID.
        :param str id: The ID of the Access Assignment.
        :param str principal_id: The ID of the access assignment.
        :param str principal_name: Cloud SSO identity name.
        :param str principal_type: Create the identity type of the access assignment, which can be a user or a user group.
        :param str target_id: The ID of the target to create the resource range.
        :param str target_name: Task target name.
        :param str target_path_name: The path name of the task target in the resource directory.
        :param str target_type: The type of the resource range target to be accessed. Only a single RD primary account or member account can be specified in the first phase.
        """
        pulumi.set(__self__, "access_configuration_id", access_configuration_id)
        pulumi.set(__self__, "access_configuration_name", access_configuration_name)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_name", principal_name)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_name", target_name)
        pulumi.set(__self__, "target_path_name", target_path_name)
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="accessConfigurationId")
    def access_configuration_id(self) -> str:
        """
        Access configuration ID.
        """
        return pulumi.get(self, "access_configuration_id")

    @property
    @pulumi.getter(name="accessConfigurationName")
    def access_configuration_name(self) -> str:
        """
        The name of the access configuration.
        """
        return pulumi.get(self, "access_configuration_name")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> str:
        """
        Directory ID.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Access Assignment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The ID of the access assignment.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> str:
        """
        Cloud SSO identity name.
        """
        return pulumi.get(self, "principal_name")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> str:
        """
        Create the identity type of the access assignment, which can be a user or a user group.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The ID of the target to create the resource range.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> str:
        """
        Task target name.
        """
        return pulumi.get(self, "target_name")

    @property
    @pulumi.getter(name="targetPathName")
    def target_path_name(self) -> str:
        """
        The path name of the task target in the resource directory.
        """
        return pulumi.get(self, "target_path_name")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> str:
        """
        The type of the resource range target to be accessed. Only a single RD primary account or member account can be specified in the first phase.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetAccessConfigurationsConfigurationResult(dict):
    def __init__(__self__, *,
                 access_configuration_id: str,
                 access_configuration_name: str,
                 create_time: str,
                 description: str,
                 directory_id: str,
                 id: str,
                 permission_policies: Sequence['outputs.GetAccessConfigurationsConfigurationPermissionPolicyResult'],
                 relay_state: str,
                 session_duration: int,
                 status_notifications: Sequence[str]):
        """
        :param str access_configuration_id: The AccessConfigurationId of the Access Configuration.
        :param str access_configuration_name: The AccessConfigurationName of the Access Configuration.
        :param str create_time: The Created Time of the Directory.
        :param str description: The Description of the Directory.
        :param str directory_id: The ID of the Directory.
        :param str id: The ID of the Access Configuration.
        :param Sequence['GetAccessConfigurationsConfigurationPermissionPolicyArgs'] permission_policies: The Policy List.
        :param str relay_state: The RelayState of the Access Configuration.
        :param int session_duration: The SessionDuration of the Access Configuration.
        :param Sequence[str] status_notifications: The StatusNotifications of the Access Configuration.
        """
        pulumi.set(__self__, "access_configuration_id", access_configuration_id)
        pulumi.set(__self__, "access_configuration_name", access_configuration_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "permission_policies", permission_policies)
        pulumi.set(__self__, "relay_state", relay_state)
        pulumi.set(__self__, "session_duration", session_duration)
        pulumi.set(__self__, "status_notifications", status_notifications)

    @property
    @pulumi.getter(name="accessConfigurationId")
    def access_configuration_id(self) -> str:
        """
        The AccessConfigurationId of the Access Configuration.
        """
        return pulumi.get(self, "access_configuration_id")

    @property
    @pulumi.getter(name="accessConfigurationName")
    def access_configuration_name(self) -> str:
        """
        The AccessConfigurationName of the Access Configuration.
        """
        return pulumi.get(self, "access_configuration_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The Created Time of the Directory.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The Description of the Directory.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> str:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Access Configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="permissionPolicies")
    def permission_policies(self) -> Sequence['outputs.GetAccessConfigurationsConfigurationPermissionPolicyResult']:
        """
        The Policy List.
        """
        return pulumi.get(self, "permission_policies")

    @property
    @pulumi.getter(name="relayState")
    def relay_state(self) -> str:
        """
        The RelayState of the Access Configuration.
        """
        return pulumi.get(self, "relay_state")

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> int:
        """
        The SessionDuration of the Access Configuration.
        """
        return pulumi.get(self, "session_duration")

    @property
    @pulumi.getter(name="statusNotifications")
    def status_notifications(self) -> Sequence[str]:
        """
        The StatusNotifications of the Access Configuration.
        """
        return pulumi.get(self, "status_notifications")


@pulumi.output_type
class GetAccessConfigurationsConfigurationPermissionPolicyResult(dict):
    def __init__(__self__, *,
                 add_time: str,
                 permission_policy_document: str,
                 permission_policy_name: str,
                 permission_policy_type: str):
        """
        :param str add_time: The Creation time of policy.
        :param str permission_policy_document: The Content of Policy.
        :param str permission_policy_name: The Policy Name of policy.
        :param str permission_policy_type: The Policy Type of policy. Valid values: `System`, `Inline`.
        """
        pulumi.set(__self__, "add_time", add_time)
        pulumi.set(__self__, "permission_policy_document", permission_policy_document)
        pulumi.set(__self__, "permission_policy_name", permission_policy_name)
        pulumi.set(__self__, "permission_policy_type", permission_policy_type)

    @property
    @pulumi.getter(name="addTime")
    def add_time(self) -> str:
        """
        The Creation time of policy.
        """
        return pulumi.get(self, "add_time")

    @property
    @pulumi.getter(name="permissionPolicyDocument")
    def permission_policy_document(self) -> str:
        """
        The Content of Policy.
        """
        return pulumi.get(self, "permission_policy_document")

    @property
    @pulumi.getter(name="permissionPolicyName")
    def permission_policy_name(self) -> str:
        """
        The Policy Name of policy.
        """
        return pulumi.get(self, "permission_policy_name")

    @property
    @pulumi.getter(name="permissionPolicyType")
    def permission_policy_type(self) -> str:
        """
        The Policy Type of policy. Valid values: `System`, `Inline`.
        """
        return pulumi.get(self, "permission_policy_type")


@pulumi.output_type
class GetDirectoriesDirectoryResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 directory_id: str,
                 directory_name: str,
                 id: str,
                 mfa_authentication_status: str,
                 region: str,
                 saml_identity_provider_configurations: Sequence['outputs.GetDirectoriesDirectorySamlIdentityProviderConfigurationResult'],
                 scim_synchronization_status: str,
                 tasks: Sequence['outputs.GetDirectoriesDirectoryTaskResult']):
        """
        :param str create_time: Saml identifies the creation time of the provider configuration.
        :param str directory_id: The DirectoryId of the CloudSSO directory.
        :param str directory_name: The name of the CloudSSO directory.
        :param str id: The ID of the Directory.
        :param str mfa_authentication_status: The mfa authentication status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        :param str region: The Region of the CloudSSO directory.
        :param Sequence['GetDirectoriesDirectorySamlIdentityProviderConfigurationArgs'] saml_identity_provider_configurations: The saml identity provider configuration.
        :param str scim_synchronization_status: The scim synchronization status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        :param Sequence['GetDirectoriesDirectoryTaskArgs'] tasks: Asynchronous Task Information Array.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "directory_name", directory_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mfa_authentication_status", mfa_authentication_status)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "saml_identity_provider_configurations", saml_identity_provider_configurations)
        pulumi.set(__self__, "scim_synchronization_status", scim_synchronization_status)
        pulumi.set(__self__, "tasks", tasks)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Saml identifies the creation time of the provider configuration.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> str:
        """
        The DirectoryId of the CloudSSO directory.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> str:
        """
        The name of the CloudSSO directory.
        """
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mfaAuthenticationStatus")
    def mfa_authentication_status(self) -> str:
        """
        The mfa authentication status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        """
        return pulumi.get(self, "mfa_authentication_status")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The Region of the CloudSSO directory.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="samlIdentityProviderConfigurations")
    def saml_identity_provider_configurations(self) -> Sequence['outputs.GetDirectoriesDirectorySamlIdentityProviderConfigurationResult']:
        """
        The saml identity provider configuration.
        """
        return pulumi.get(self, "saml_identity_provider_configurations")

    @property
    @pulumi.getter(name="scimSynchronizationStatus")
    def scim_synchronization_status(self) -> str:
        """
        The scim synchronization status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        """
        return pulumi.get(self, "scim_synchronization_status")

    @property
    @pulumi.getter
    def tasks(self) -> Sequence['outputs.GetDirectoriesDirectoryTaskResult']:
        """
        Asynchronous Task Information Array.
        """
        return pulumi.get(self, "tasks")


@pulumi.output_type
class GetDirectoriesDirectorySamlIdentityProviderConfigurationResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 encoded_metadata_document: str,
                 entity_id: str,
                 login_url: str,
                 sso_status: str):
        """
        :param str create_time: Saml identifies the creation time of the provider configuration.
        :param str encoded_metadata_document: Base64 encoded IdP metadata document.
        :param str entity_id: SAML IdPEntityID.
        :param str login_url: SAML IdP http-post Binding address.
        :param str sso_status: SAML SSO login enabled status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "encoded_metadata_document", encoded_metadata_document)
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "login_url", login_url)
        pulumi.set(__self__, "sso_status", sso_status)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Saml identifies the creation time of the provider configuration.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="encodedMetadataDocument")
    def encoded_metadata_document(self) -> str:
        """
        Base64 encoded IdP metadata document.
        """
        return pulumi.get(self, "encoded_metadata_document")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> str:
        """
        SAML IdPEntityID.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="loginUrl")
    def login_url(self) -> str:
        """
        SAML IdP http-post Binding address.
        """
        return pulumi.get(self, "login_url")

    @property
    @pulumi.getter(name="ssoStatus")
    def sso_status(self) -> str:
        """
        SAML SSO login enabled status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        """
        return pulumi.get(self, "sso_status")


@pulumi.output_type
class GetDirectoriesDirectoryTaskResult(dict):
    def __init__(__self__, *,
                 access_configuration_id: str,
                 access_configuration_name: str,
                 end_time: str,
                 failure_reason: str,
                 principal_id: str,
                 principal_name: str,
                 principal_type: str,
                 start_time: str,
                 status: str,
                 target_id: str,
                 target_name: str,
                 target_path: str,
                 target_type: str,
                 task_id: str,
                 task_type: str):
        """
        :param str access_configuration_id: The ID of Access Configuration.
        :param str access_configuration_name: The Name of Access Configuration.
        :param str end_time: The End Time of Task.
        :param str failure_reason: the Reason for the Failure of  the task.
        :param str principal_id: The ID of Cloud SSO Identity.
        :param str principal_name: The Name of Cloud SSO Identity.
        :param str principal_type: The Type of Cloud SSO Identity.
        :param str start_time: The Start Time of Task.
        :param str status: The Task Status.
        :param str target_id: The Id of deploy target.
        :param str target_name: The Name of Deploy Target.
        :param str target_path: The Path in RD of Deploy Target.
        :param str target_type: The Type of Deploy Target.
        :param str task_id: The ID of the Task.
        :param str task_type: The Type of the Task.
        """
        pulumi.set(__self__, "access_configuration_id", access_configuration_id)
        pulumi.set(__self__, "access_configuration_name", access_configuration_name)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "failure_reason", failure_reason)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_name", principal_name)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_name", target_name)
        pulumi.set(__self__, "target_path", target_path)
        pulumi.set(__self__, "target_type", target_type)
        pulumi.set(__self__, "task_id", task_id)
        pulumi.set(__self__, "task_type", task_type)

    @property
    @pulumi.getter(name="accessConfigurationId")
    def access_configuration_id(self) -> str:
        """
        The ID of Access Configuration.
        """
        return pulumi.get(self, "access_configuration_id")

    @property
    @pulumi.getter(name="accessConfigurationName")
    def access_configuration_name(self) -> str:
        """
        The Name of Access Configuration.
        """
        return pulumi.get(self, "access_configuration_name")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The End Time of Task.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> str:
        """
        the Reason for the Failure of  the task.
        """
        return pulumi.get(self, "failure_reason")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The ID of Cloud SSO Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> str:
        """
        The Name of Cloud SSO Identity.
        """
        return pulumi.get(self, "principal_name")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> str:
        """
        The Type of Cloud SSO Identity.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The Start Time of Task.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The Task Status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The Id of deploy target.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> str:
        """
        The Name of Deploy Target.
        """
        return pulumi.get(self, "target_name")

    @property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> str:
        """
        The Path in RD of Deploy Target.
        """
        return pulumi.get(self, "target_path")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> str:
        """
        The Type of Deploy Target.
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> str:
        """
        The ID of the Task.
        """
        return pulumi.get(self, "task_id")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        The Type of the Task.
        """
        return pulumi.get(self, "task_type")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 directory_id: str,
                 group_id: str,
                 group_name: str,
                 id: str,
                 provision_type: str):
        """
        :param str create_time: The Created Time of the Directory.
        :param str description: The Description of the Directory.
        :param str directory_id: The ID of the Directory.
        :param str group_id: The Group ID of the group.
        :param str group_name: The Name of the group.
        :param str id: The ID of the Group.
        :param str provision_type: The Provision Type of the Group. Valid values: `Manual`, `Synchronized`.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "provision_type", provision_type)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The Created Time of the Directory.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The Description of the Directory.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> str:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The Group ID of the group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        The Name of the group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisionType")
    def provision_type(self) -> str:
        """
        The Provision Type of the Group. Valid values: `Manual`, `Synchronized`.
        """
        return pulumi.get(self, "provision_type")


@pulumi.output_type
class GetScimServerCredentialsCredentialResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 credential_id: str,
                 credential_secret: str,
                 credential_type: str,
                 directory_id: str,
                 expire_time: str,
                 id: str,
                 status: str):
        """
        :param str create_time: The CreateTime of the resource.
        :param str credential_id: The CredentialId of the resource.
        :param str credential_secret: The CredentialSecret of the resource.
        :param str credential_type: The CredentialType of the resource.
        :param str directory_id: The ID of the Directory.
        :param str expire_time: The ExpireTime of the resource.
        :param str id: The ID of the SCIM Server Credential.
        :param str status: The Status of the resource. Valid values: `Disabled`, `Enabled`.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "credential_id", credential_id)
        pulumi.set(__self__, "credential_secret", credential_secret)
        pulumi.set(__self__, "credential_type", credential_type)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The CreateTime of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> str:
        """
        The CredentialId of the resource.
        """
        return pulumi.get(self, "credential_id")

    @property
    @pulumi.getter(name="credentialSecret")
    def credential_secret(self) -> str:
        """
        The CredentialSecret of the resource.
        """
        return pulumi.get(self, "credential_secret")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        The CredentialType of the resource.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> str:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The ExpireTime of the resource.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the SCIM Server Credential.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The Status of the resource. Valid values: `Disabled`, `Enabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 directory_id: str,
                 display_name: str,
                 email: str,
                 first_name: str,
                 id: str,
                 last_name: str,
                 mfa_devices: Sequence['outputs.GetUsersUserMfaDeviceResult'],
                 provision_type: str,
                 status: str,
                 user_id: str,
                 user_name: str):
        """
        :param str create_time: The create time of the user.
        :param str description: The description of user.
        :param str directory_id: The ID of the Directory.
        :param str display_name: The display name of user.
        :param str email: The User's Contact Email Address.
        :param str first_name: The first name of user.
        :param str id: The ID of the User.
        :param str last_name: The last name of user.
        :param Sequence['GetUsersUserMfaDeviceArgs'] mfa_devices: The List of MFA Device for User.
        :param str provision_type: ProvisionType.
        :param str status: User status. Valid values: `Enabled` and `Disabled`.
        :param str user_id: The User ID of the group.
        :param str user_name: The name of user.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "mfa_devices", mfa_devices)
        pulumi.set(__self__, "provision_type", provision_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The create time of the user.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> str:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The User's Contact Email Address.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        The first name of user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the User.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        The last name of user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="mfaDevices")
    def mfa_devices(self) -> Sequence['outputs.GetUsersUserMfaDeviceResult']:
        """
        The List of MFA Device for User.
        """
        return pulumi.get(self, "mfa_devices")

    @property
    @pulumi.getter(name="provisionType")
    def provision_type(self) -> str:
        """
        ProvisionType.
        """
        return pulumi.get(self, "provision_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        User status. Valid values: `Enabled` and `Disabled`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The User ID of the group.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        The name of user.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetUsersUserMfaDeviceResult(dict):
    def __init__(__self__, *,
                 device_id: str,
                 device_name: str,
                 device_type: str,
                 effective_time: str):
        """
        :param str device_id: The MFA Device ID.
        :param str device_name: The MFA Device Name.
        :param str device_type: The MFA Device Type.
        :param str effective_time: The Effective Time of MFA Device.
        """
        pulumi.set(__self__, "device_id", device_id)
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "device_type", device_type)
        pulumi.set(__self__, "effective_time", effective_time)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> str:
        """
        The MFA Device ID.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        The MFA Device Name.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> str:
        """
        The MFA Device Type.
        """
        return pulumi.get(self, "device_type")

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> str:
        """
        The Effective Time of MFA Device.
        """
        return pulumi.get(self, "effective_time")


