# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 gateway_name: pulumi.Input[str],
                 location: pulumi.Input[str],
                 storage_bundle_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 gateway_class: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 public_network_bandwidth: Optional[pulumi.Input[int]] = None,
                 reason_detail: Optional[pulumi.Input[str]] = None,
                 reason_type: Optional[pulumi.Input[str]] = None,
                 release_after_expiration: Optional[pulumi.Input[bool]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[str] gateway_name: the name of gateway.
        :param pulumi.Input[str] location: gateway location. the valid values: `Cloud`, `On_Premise`.
        :param pulumi.Input[str] storage_bundle_id: storage bundle id.
        :param pulumi.Input[str] type: gateway type. the valid values: `Type`, `Iscsi`.
        :param pulumi.Input[str] description: the description of gateway.
        :param pulumi.Input[str] gateway_class: the gateway class. the valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`
        :param pulumi.Input[str] payment_type: The Payment type of gateway. The valid value: `PayAsYouGo`.
        :param pulumi.Input[int] public_network_bandwidth: The public network bandwidth of gateway. Valid values between `5` and `200`. Defaults to `5`.
        :param pulumi.Input[str] reason_detail: The reason detail of gateway.
        :param pulumi.Input[str] reason_type: The reason type when user deletes the gateway.
        :param pulumi.Input[bool] release_after_expiration: Whether to release the gateway due to expiration.
        :param pulumi.Input[str] vswitch_id: The vswitch id of gateway.
        """
        pulumi.set(__self__, "gateway_name", gateway_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "storage_bundle_id", storage_bundle_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateway_class is not None:
            pulumi.set(__self__, "gateway_class", gateway_class)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if public_network_bandwidth is not None:
            pulumi.set(__self__, "public_network_bandwidth", public_network_bandwidth)
        if reason_detail is not None:
            pulumi.set(__self__, "reason_detail", reason_detail)
        if reason_type is not None:
            pulumi.set(__self__, "reason_type", reason_type)
        if release_after_expiration is not None:
            pulumi.set(__self__, "release_after_expiration", release_after_expiration)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Input[str]:
        """
        the name of gateway.
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        gateway location. the valid values: `Cloud`, `On_Premise`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="storageBundleId")
    def storage_bundle_id(self) -> pulumi.Input[str]:
        """
        storage bundle id.
        """
        return pulumi.get(self, "storage_bundle_id")

    @storage_bundle_id.setter
    def storage_bundle_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_bundle_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        gateway type. the valid values: `Type`, `Iscsi`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        the description of gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gatewayClass")
    def gateway_class(self) -> Optional[pulumi.Input[str]]:
        """
        the gateway class. the valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`
        """
        return pulumi.get(self, "gateway_class")

    @gateway_class.setter
    def gateway_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_class", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Payment type of gateway. The valid value: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="publicNetworkBandwidth")
    def public_network_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The public network bandwidth of gateway. Valid values between `5` and `200`. Defaults to `5`.
        """
        return pulumi.get(self, "public_network_bandwidth")

    @public_network_bandwidth.setter
    def public_network_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "public_network_bandwidth", value)

    @property
    @pulumi.getter(name="reasonDetail")
    def reason_detail(self) -> Optional[pulumi.Input[str]]:
        """
        The reason detail of gateway.
        """
        return pulumi.get(self, "reason_detail")

    @reason_detail.setter
    def reason_detail(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason_detail", value)

    @property
    @pulumi.getter(name="reasonType")
    def reason_type(self) -> Optional[pulumi.Input[str]]:
        """
        The reason type when user deletes the gateway.
        """
        return pulumi.get(self, "reason_type")

    @reason_type.setter
    def reason_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason_type", value)

    @property
    @pulumi.getter(name="releaseAfterExpiration")
    def release_after_expiration(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to release the gateway due to expiration.
        """
        return pulumi.get(self, "release_after_expiration")

    @release_after_expiration.setter
    def release_after_expiration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "release_after_expiration", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vswitch id of gateway.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 gateway_class: Optional[pulumi.Input[str]] = None,
                 gateway_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 public_network_bandwidth: Optional[pulumi.Input[int]] = None,
                 reason_detail: Optional[pulumi.Input[str]] = None,
                 reason_type: Optional[pulumi.Input[str]] = None,
                 release_after_expiration: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_bundle_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input[str] description: the description of gateway.
        :param pulumi.Input[str] gateway_class: the gateway class. the valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`
        :param pulumi.Input[str] gateway_name: the name of gateway.
        :param pulumi.Input[str] location: gateway location. the valid values: `Cloud`, `On_Premise`.
        :param pulumi.Input[str] payment_type: The Payment type of gateway. The valid value: `PayAsYouGo`.
        :param pulumi.Input[int] public_network_bandwidth: The public network bandwidth of gateway. Valid values between `5` and `200`. Defaults to `5`.
        :param pulumi.Input[str] reason_detail: The reason detail of gateway.
        :param pulumi.Input[str] reason_type: The reason type when user deletes the gateway.
        :param pulumi.Input[bool] release_after_expiration: Whether to release the gateway due to expiration.
        :param pulumi.Input[str] status: gateway status.
        :param pulumi.Input[str] storage_bundle_id: storage bundle id.
        :param pulumi.Input[str] type: gateway type. the valid values: `Type`, `Iscsi`.
        :param pulumi.Input[str] vswitch_id: The vswitch id of gateway.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateway_class is not None:
            pulumi.set(__self__, "gateway_class", gateway_class)
        if gateway_name is not None:
            pulumi.set(__self__, "gateway_name", gateway_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if public_network_bandwidth is not None:
            pulumi.set(__self__, "public_network_bandwidth", public_network_bandwidth)
        if reason_detail is not None:
            pulumi.set(__self__, "reason_detail", reason_detail)
        if reason_type is not None:
            pulumi.set(__self__, "reason_type", reason_type)
        if release_after_expiration is not None:
            pulumi.set(__self__, "release_after_expiration", release_after_expiration)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_bundle_id is not None:
            pulumi.set(__self__, "storage_bundle_id", storage_bundle_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        the description of gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gatewayClass")
    def gateway_class(self) -> Optional[pulumi.Input[str]]:
        """
        the gateway class. the valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`
        """
        return pulumi.get(self, "gateway_class")

    @gateway_class.setter
    def gateway_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_class", value)

    @property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        the name of gateway.
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        gateway location. the valid values: `Cloud`, `On_Premise`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Payment type of gateway. The valid value: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="publicNetworkBandwidth")
    def public_network_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The public network bandwidth of gateway. Valid values between `5` and `200`. Defaults to `5`.
        """
        return pulumi.get(self, "public_network_bandwidth")

    @public_network_bandwidth.setter
    def public_network_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "public_network_bandwidth", value)

    @property
    @pulumi.getter(name="reasonDetail")
    def reason_detail(self) -> Optional[pulumi.Input[str]]:
        """
        The reason detail of gateway.
        """
        return pulumi.get(self, "reason_detail")

    @reason_detail.setter
    def reason_detail(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason_detail", value)

    @property
    @pulumi.getter(name="reasonType")
    def reason_type(self) -> Optional[pulumi.Input[str]]:
        """
        The reason type when user deletes the gateway.
        """
        return pulumi.get(self, "reason_type")

    @reason_type.setter
    def reason_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason_type", value)

    @property
    @pulumi.getter(name="releaseAfterExpiration")
    def release_after_expiration(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to release the gateway due to expiration.
        """
        return pulumi.get(self, "release_after_expiration")

    @release_after_expiration.setter
    def release_after_expiration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "release_after_expiration", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        gateway status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageBundleId")
    def storage_bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        storage bundle id.
        """
        return pulumi.get(self, "storage_bundle_id")

    @storage_bundle_id.setter
    def storage_bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_bundle_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        gateway type. the valid values: `Type`, `Iscsi`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vswitch id of gateway.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)


class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gateway_class: Optional[pulumi.Input[str]] = None,
                 gateway_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 public_network_bandwidth: Optional[pulumi.Input[int]] = None,
                 reason_detail: Optional[pulumi.Input[str]] = None,
                 reason_type: Optional[pulumi.Input[str]] = None,
                 release_after_expiration: Optional[pulumi.Input[bool]] = None,
                 storage_bundle_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloud Storage Gateway: Gateway resource.

        For information about Cloud Storage Gateway Gateway and how to use it, see [What is Gateway](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/deploygateway).

        > **NOTE:** Available since v1.132.0.

        ## Import

        Cloud Storage Gateway Gateway can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cloudstoragegateway/gateway:Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: the description of gateway.
        :param pulumi.Input[str] gateway_class: the gateway class. the valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`
        :param pulumi.Input[str] gateway_name: the name of gateway.
        :param pulumi.Input[str] location: gateway location. the valid values: `Cloud`, `On_Premise`.
        :param pulumi.Input[str] payment_type: The Payment type of gateway. The valid value: `PayAsYouGo`.
        :param pulumi.Input[int] public_network_bandwidth: The public network bandwidth of gateway. Valid values between `5` and `200`. Defaults to `5`.
        :param pulumi.Input[str] reason_detail: The reason detail of gateway.
        :param pulumi.Input[str] reason_type: The reason type when user deletes the gateway.
        :param pulumi.Input[bool] release_after_expiration: Whether to release the gateway due to expiration.
        :param pulumi.Input[str] storage_bundle_id: storage bundle id.
        :param pulumi.Input[str] type: gateway type. the valid values: `Type`, `Iscsi`.
        :param pulumi.Input[str] vswitch_id: The vswitch id of gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Storage Gateway: Gateway resource.

        For information about Cloud Storage Gateway Gateway and how to use it, see [What is Gateway](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/deploygateway).

        > **NOTE:** Available since v1.132.0.

        ## Import

        Cloud Storage Gateway Gateway can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cloudstoragegateway/gateway:Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gateway_class: Optional[pulumi.Input[str]] = None,
                 gateway_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 public_network_bandwidth: Optional[pulumi.Input[int]] = None,
                 reason_detail: Optional[pulumi.Input[str]] = None,
                 reason_type: Optional[pulumi.Input[str]] = None,
                 release_after_expiration: Optional[pulumi.Input[bool]] = None,
                 storage_bundle_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["gateway_class"] = gateway_class
            if gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_name'")
            __props__.__dict__["gateway_name"] = gateway_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["public_network_bandwidth"] = public_network_bandwidth
            __props__.__dict__["reason_detail"] = reason_detail
            __props__.__dict__["reason_type"] = reason_type
            __props__.__dict__["release_after_expiration"] = release_after_expiration
            if storage_bundle_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_bundle_id'")
            __props__.__dict__["storage_bundle_id"] = storage_bundle_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["status"] = None
        super(Gateway, __self__).__init__(
            'alicloud:cloudstoragegateway/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            gateway_class: Optional[pulumi.Input[str]] = None,
            gateway_name: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            public_network_bandwidth: Optional[pulumi.Input[int]] = None,
            reason_detail: Optional[pulumi.Input[str]] = None,
            reason_type: Optional[pulumi.Input[str]] = None,
            release_after_expiration: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_bundle_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: the description of gateway.
        :param pulumi.Input[str] gateway_class: the gateway class. the valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`
        :param pulumi.Input[str] gateway_name: the name of gateway.
        :param pulumi.Input[str] location: gateway location. the valid values: `Cloud`, `On_Premise`.
        :param pulumi.Input[str] payment_type: The Payment type of gateway. The valid value: `PayAsYouGo`.
        :param pulumi.Input[int] public_network_bandwidth: The public network bandwidth of gateway. Valid values between `5` and `200`. Defaults to `5`.
        :param pulumi.Input[str] reason_detail: The reason detail of gateway.
        :param pulumi.Input[str] reason_type: The reason type when user deletes the gateway.
        :param pulumi.Input[bool] release_after_expiration: Whether to release the gateway due to expiration.
        :param pulumi.Input[str] status: gateway status.
        :param pulumi.Input[str] storage_bundle_id: storage bundle id.
        :param pulumi.Input[str] type: gateway type. the valid values: `Type`, `Iscsi`.
        :param pulumi.Input[str] vswitch_id: The vswitch id of gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["description"] = description
        __props__.__dict__["gateway_class"] = gateway_class
        __props__.__dict__["gateway_name"] = gateway_name
        __props__.__dict__["location"] = location
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["public_network_bandwidth"] = public_network_bandwidth
        __props__.__dict__["reason_detail"] = reason_detail
        __props__.__dict__["reason_type"] = reason_type
        __props__.__dict__["release_after_expiration"] = release_after_expiration
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_bundle_id"] = storage_bundle_id
        __props__.__dict__["type"] = type
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        the description of gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="gatewayClass")
    def gateway_class(self) -> pulumi.Output[Optional[str]]:
        """
        the gateway class. the valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`
        """
        return pulumi.get(self, "gateway_class")

    @property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Output[str]:
        """
        the name of gateway.
        """
        return pulumi.get(self, "gateway_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        gateway location. the valid values: `Cloud`, `On_Premise`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[Optional[str]]:
        """
        The Payment type of gateway. The valid value: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="publicNetworkBandwidth")
    def public_network_bandwidth(self) -> pulumi.Output[int]:
        """
        The public network bandwidth of gateway. Valid values between `5` and `200`. Defaults to `5`.
        """
        return pulumi.get(self, "public_network_bandwidth")

    @property
    @pulumi.getter(name="reasonDetail")
    def reason_detail(self) -> pulumi.Output[Optional[str]]:
        """
        The reason detail of gateway.
        """
        return pulumi.get(self, "reason_detail")

    @property
    @pulumi.getter(name="reasonType")
    def reason_type(self) -> pulumi.Output[Optional[str]]:
        """
        The reason type when user deletes the gateway.
        """
        return pulumi.get(self, "reason_type")

    @property
    @pulumi.getter(name="releaseAfterExpiration")
    def release_after_expiration(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to release the gateway due to expiration.
        """
        return pulumi.get(self, "release_after_expiration")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        gateway status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageBundleId")
    def storage_bundle_id(self) -> pulumi.Output[str]:
        """
        storage bundle id.
        """
        return pulumi.get(self, "storage_bundle_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        gateway type. the valid values: `Type`, `Iscsi`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        The vswitch id of gateway.
        """
        return pulumi.get(self, "vswitch_id")

