# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetGatewayCacheDisksResult',
    'AwaitableGetGatewayCacheDisksResult',
    'get_gateway_cache_disks',
    'get_gateway_cache_disks_output',
]

@pulumi.output_type
class GetGatewayCacheDisksResult:
    """
    A collection of values returned by getGatewayCacheDisks.
    """
    def __init__(__self__, disks=None, gateway_id=None, id=None, ids=None, output_file=None, status=None):
        if disks and not isinstance(disks, list):
            raise TypeError("Expected argument 'disks' to be a list")
        pulumi.set(__self__, "disks", disks)
        if gateway_id and not isinstance(gateway_id, str):
            raise TypeError("Expected argument 'gateway_id' to be a str")
        pulumi.set(__self__, "gateway_id", gateway_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, int):
            raise TypeError("Expected argument 'status' to be a int")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetGatewayCacheDisksDiskResult']:
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> str:
        return pulumi.get(self, "gateway_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def status(self) -> Optional[int]:
        return pulumi.get(self, "status")


class AwaitableGetGatewayCacheDisksResult(GetGatewayCacheDisksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayCacheDisksResult(
            disks=self.disks,
            gateway_id=self.gateway_id,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            status=self.status)


def get_gateway_cache_disks(gateway_id: Optional[str] = None,
                            ids: Optional[Sequence[str]] = None,
                            output_file: Optional[str] = None,
                            status: Optional[int] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayCacheDisksResult:
    """
    This data source provides the Cloud Storage Gateway Gateway Cache Disks of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.144.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cloudstoragegateway.get_gateway_cache_disks(gateway_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("cloudStorageGatewayGatewayCacheDiskId1", ids.disks[0].id)
    status = alicloud.cloudstoragegateway.get_gateway_cache_disks(gateway_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ],
        status=0)
    pulumi.export("cloudStorageGatewayGatewayCacheDiskId2", status.disks[0].id)
    ```


    :param str gateway_id: The ID of the gateway.
    :param Sequence[str] ids: A list of Gateway Cache Disk IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param int status: The status of the resource.
    """
    __args__ = dict()
    __args__['gatewayId'] = gateway_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudstoragegateway/getGatewayCacheDisks:getGatewayCacheDisks', __args__, opts=opts, typ=GetGatewayCacheDisksResult).value

    return AwaitableGetGatewayCacheDisksResult(
        disks=pulumi.get(__ret__, 'disks'),
        gateway_id=pulumi.get(__ret__, 'gateway_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_gateway_cache_disks)
def get_gateway_cache_disks_output(gateway_id: Optional[pulumi.Input[str]] = None,
                                   ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                   output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                   status: Optional[pulumi.Input[Optional[int]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGatewayCacheDisksResult]:
    """
    This data source provides the Cloud Storage Gateway Gateway Cache Disks of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.144.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cloudstoragegateway.get_gateway_cache_disks(gateway_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("cloudStorageGatewayGatewayCacheDiskId1", ids.disks[0].id)
    status = alicloud.cloudstoragegateway.get_gateway_cache_disks(gateway_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ],
        status=0)
    pulumi.export("cloudStorageGatewayGatewayCacheDiskId2", status.disks[0].id)
    ```


    :param str gateway_id: The ID of the gateway.
    :param Sequence[str] ids: A list of Gateway Cache Disk IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param int status: The status of the resource.
    """
    ...
