# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlarmArgs', 'Alarm']

@pulumi.input_type
class AlarmArgs:
    def __init__(__self__, *,
                 contact_groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 metric: pulumi.Input[str],
                 project: pulumi.Input[str],
                 dimensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 effective_interval: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 end_time: Optional[pulumi.Input[int]] = None,
                 escalations_critical: Optional[pulumi.Input['AlarmEscalationsCriticalArgs']] = None,
                 escalations_info: Optional[pulumi.Input['AlarmEscalationsInfoArgs']] = None,
                 escalations_warn: Optional[pulumi.Input['AlarmEscalationsWarnArgs']] = None,
                 metric_dimensions: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 prometheuses: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]] = None,
                 silence_time: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[int]] = None,
                 statistics: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 threshold: Optional[pulumi.Input[str]] = None,
                 triggered_count: Optional[pulumi.Input[int]] = None,
                 webhook: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Alarm resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_groups: List contact groups of the alarm rule, which must have been created on the console.
        :param pulumi.Input[str] metric: Name of the monitoring metrics corresponding to a project, such as "CPUUtilization" and "networkin_rate". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[str] project: Monitor project name, such as "acs_ecs_dashboard" and "acs_rds_dashboard". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
               **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        :param pulumi.Input[Mapping[str, Any]] dimensions: Field `dimensions` has been deprecated from version 1.95.0. Use `metric_dimensions` instead.
        :param pulumi.Input[str] effective_interval: The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default to "00:00-23:59".
        :param pulumi.Input[bool] enabled: Whether to enable alarm rule. Default to true.
        :param pulumi.Input[int] end_time: It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        :param pulumi.Input['AlarmEscalationsCriticalArgs'] escalations_critical: A configuration of critical alarm. See `escalations_critical` below.
        :param pulumi.Input['AlarmEscalationsInfoArgs'] escalations_info: A configuration of critical info. See `escalations_info` below.
        :param pulumi.Input['AlarmEscalationsWarnArgs'] escalations_warn: A configuration of critical warn. See `escalations_warn` below.
        :param pulumi.Input[str] metric_dimensions: Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[str] name: The alarm rule name.
        :param pulumi.Input[str] operator: It has been deprecated from provider version 1.94.0 and 'escalations_critical.comparison_operator' instead.
        :param pulumi.Input[int] period: Index query cycle, which must be consistent with that defined for metrics. Default to 300, in seconds.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]] prometheuses: The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        :param pulumi.Input[int] silence_time: Notification silence period in the alarm state, in seconds. Valid value range: [300, 86400]. Default to 86400
        :param pulumi.Input[int] start_time: It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        :param pulumi.Input[str] statistics: It has been deprecated from provider version 1.94.0 and 'escalations_critical.statistics' instead.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               
               > **NOTE:** Each resource supports the creation of one of the following three levels.
        :param pulumi.Input[str] threshold: It has been deprecated from provider version 1.94.0 and 'escalations_critical.threshold' instead.
        :param pulumi.Input[int] triggered_count: It has been deprecated from provider version 1.94.0 and 'escalations_critical.times' instead.
        :param pulumi.Input[str] webhook: The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        pulumi.set(__self__, "contact_groups", contact_groups)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "project", project)
        if dimensions is not None:
            warnings.warn("""Field 'dimensions' has been deprecated from version 1.173.0. Use 'metric_dimensions' instead.""", DeprecationWarning)
            pulumi.log.warn("""dimensions is deprecated: Field 'dimensions' has been deprecated from version 1.173.0. Use 'metric_dimensions' instead.""")
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if effective_interval is not None:
            pulumi.set(__self__, "effective_interval", effective_interval)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if end_time is not None:
            warnings.warn("""Field 'end_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""", DeprecationWarning)
            pulumi.log.warn("""end_time is deprecated: Field 'end_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""")
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if escalations_critical is not None:
            pulumi.set(__self__, "escalations_critical", escalations_critical)
        if escalations_info is not None:
            pulumi.set(__self__, "escalations_info", escalations_info)
        if escalations_warn is not None:
            pulumi.set(__self__, "escalations_warn", escalations_warn)
        if metric_dimensions is not None:
            pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operator is not None:
            warnings.warn("""Field 'operator' has been deprecated from provider version 1.94.0. New field 'escalations_critical.comparison_operator' instead.""", DeprecationWarning)
            pulumi.log.warn("""operator is deprecated: Field 'operator' has been deprecated from provider version 1.94.0. New field 'escalations_critical.comparison_operator' instead.""")
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if prometheuses is not None:
            pulumi.set(__self__, "prometheuses", prometheuses)
        if silence_time is not None:
            pulumi.set(__self__, "silence_time", silence_time)
        if start_time is not None:
            warnings.warn("""Field 'start_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""", DeprecationWarning)
            pulumi.log.warn("""start_time is deprecated: Field 'start_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""")
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if statistics is not None:
            warnings.warn("""Field 'statistics' has been deprecated from provider version 1.94.0. New field 'escalations_critical.statistics' instead.""", DeprecationWarning)
            pulumi.log.warn("""statistics is deprecated: Field 'statistics' has been deprecated from provider version 1.94.0. New field 'escalations_critical.statistics' instead.""")
        if statistics is not None:
            pulumi.set(__self__, "statistics", statistics)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threshold is not None:
            warnings.warn("""Field 'threshold' has been deprecated from provider version 1.94.0. New field 'escalations_critical.threshold' instead.""", DeprecationWarning)
            pulumi.log.warn("""threshold is deprecated: Field 'threshold' has been deprecated from provider version 1.94.0. New field 'escalations_critical.threshold' instead.""")
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if triggered_count is not None:
            warnings.warn("""Field 'triggered_count' has been deprecated from provider version 1.94.0. New field 'escalations_critical.times' instead.""", DeprecationWarning)
            pulumi.log.warn("""triggered_count is deprecated: Field 'triggered_count' has been deprecated from provider version 1.94.0. New field 'escalations_critical.times' instead.""")
        if triggered_count is not None:
            pulumi.set(__self__, "triggered_count", triggered_count)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List contact groups of the alarm rule, which must have been created on the console.
        """
        return pulumi.get(self, "contact_groups")

    @contact_groups.setter
    def contact_groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "contact_groups", value)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input[str]:
        """
        Name of the monitoring metrics corresponding to a project, such as "CPUUtilization" and "networkin_rate". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Monitor project name, such as "acs_ecs_dashboard" and "acs_rds_dashboard". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Field `dimensions` has been deprecated from version 1.95.0. Use `metric_dimensions` instead.
        """
        warnings.warn("""Field 'dimensions' has been deprecated from version 1.173.0. Use 'metric_dimensions' instead.""", DeprecationWarning)
        pulumi.log.warn("""dimensions is deprecated: Field 'dimensions' has been deprecated from version 1.173.0. Use 'metric_dimensions' instead.""")

        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="effectiveInterval")
    def effective_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default to "00:00-23:59".
        """
        return pulumi.get(self, "effective_interval")

    @effective_interval.setter
    def effective_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_interval", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable alarm rule. Default to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[int]]:
        """
        It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        """
        warnings.warn("""Field 'end_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""", DeprecationWarning)
        pulumi.log.warn("""end_time is deprecated: Field 'end_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""")

        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="escalationsCritical")
    def escalations_critical(self) -> Optional[pulumi.Input['AlarmEscalationsCriticalArgs']]:
        """
        A configuration of critical alarm. See `escalations_critical` below.
        """
        return pulumi.get(self, "escalations_critical")

    @escalations_critical.setter
    def escalations_critical(self, value: Optional[pulumi.Input['AlarmEscalationsCriticalArgs']]):
        pulumi.set(self, "escalations_critical", value)

    @property
    @pulumi.getter(name="escalationsInfo")
    def escalations_info(self) -> Optional[pulumi.Input['AlarmEscalationsInfoArgs']]:
        """
        A configuration of critical info. See `escalations_info` below.
        """
        return pulumi.get(self, "escalations_info")

    @escalations_info.setter
    def escalations_info(self, value: Optional[pulumi.Input['AlarmEscalationsInfoArgs']]):
        pulumi.set(self, "escalations_info", value)

    @property
    @pulumi.getter(name="escalationsWarn")
    def escalations_warn(self) -> Optional[pulumi.Input['AlarmEscalationsWarnArgs']]:
        """
        A configuration of critical warn. See `escalations_warn` below.
        """
        return pulumi.get(self, "escalations_warn")

    @escalations_warn.setter
    def escalations_warn(self, value: Optional[pulumi.Input['AlarmEscalationsWarnArgs']]):
        pulumi.set(self, "escalations_warn", value)

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Optional[pulumi.Input[str]]:
        """
        Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric_dimensions")

    @metric_dimensions.setter
    def metric_dimensions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_dimensions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The alarm rule name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.comparison_operator' instead.
        """
        warnings.warn("""Field 'operator' has been deprecated from provider version 1.94.0. New field 'escalations_critical.comparison_operator' instead.""", DeprecationWarning)
        pulumi.log.warn("""operator is deprecated: Field 'operator' has been deprecated from provider version 1.94.0. New field 'escalations_critical.comparison_operator' instead.""")

        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Index query cycle, which must be consistent with that defined for metrics. Default to 300, in seconds.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def prometheuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]]:
        """
        The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        """
        return pulumi.get(self, "prometheuses")

    @prometheuses.setter
    def prometheuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]]):
        pulumi.set(self, "prometheuses", value)

    @property
    @pulumi.getter(name="silenceTime")
    def silence_time(self) -> Optional[pulumi.Input[int]]:
        """
        Notification silence period in the alarm state, in seconds. Valid value range: [300, 86400]. Default to 86400
        """
        return pulumi.get(self, "silence_time")

    @silence_time.setter
    def silence_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "silence_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[int]]:
        """
        It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        """
        warnings.warn("""Field 'start_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""", DeprecationWarning)
        pulumi.log.warn("""start_time is deprecated: Field 'start_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""")

        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def statistics(self) -> Optional[pulumi.Input[str]]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.statistics' instead.
        """
        warnings.warn("""Field 'statistics' has been deprecated from provider version 1.94.0. New field 'escalations_critical.statistics' instead.""", DeprecationWarning)
        pulumi.log.warn("""statistics is deprecated: Field 'statistics' has been deprecated from provider version 1.94.0. New field 'escalations_critical.statistics' instead.""")

        return pulumi.get(self, "statistics")

    @statistics.setter
    def statistics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statistics", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.

        > **NOTE:** Each resource supports the creation of one of the following three levels.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[str]]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.threshold' instead.
        """
        warnings.warn("""Field 'threshold' has been deprecated from provider version 1.94.0. New field 'escalations_critical.threshold' instead.""", DeprecationWarning)
        pulumi.log.warn("""threshold is deprecated: Field 'threshold' has been deprecated from provider version 1.94.0. New field 'escalations_critical.threshold' instead.""")

        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="triggeredCount")
    def triggered_count(self) -> Optional[pulumi.Input[int]]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.times' instead.
        """
        warnings.warn("""Field 'triggered_count' has been deprecated from provider version 1.94.0. New field 'escalations_critical.times' instead.""", DeprecationWarning)
        pulumi.log.warn("""triggered_count is deprecated: Field 'triggered_count' has been deprecated from provider version 1.94.0. New field 'escalations_critical.times' instead.""")

        return pulumi.get(self, "triggered_count")

    @triggered_count.setter
    def triggered_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "triggered_count", value)

    @property
    @pulumi.getter
    def webhook(self) -> Optional[pulumi.Input[str]]:
        """
        The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook", value)


@pulumi.input_type
class _AlarmState:
    def __init__(__self__, *,
                 contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 effective_interval: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 end_time: Optional[pulumi.Input[int]] = None,
                 escalations_critical: Optional[pulumi.Input['AlarmEscalationsCriticalArgs']] = None,
                 escalations_info: Optional[pulumi.Input['AlarmEscalationsInfoArgs']] = None,
                 escalations_warn: Optional[pulumi.Input['AlarmEscalationsWarnArgs']] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 metric_dimensions: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 prometheuses: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]] = None,
                 silence_time: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[int]] = None,
                 statistics: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 threshold: Optional[pulumi.Input[str]] = None,
                 triggered_count: Optional[pulumi.Input[int]] = None,
                 webhook: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Alarm resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_groups: List contact groups of the alarm rule, which must have been created on the console.
        :param pulumi.Input[Mapping[str, Any]] dimensions: Field `dimensions` has been deprecated from version 1.95.0. Use `metric_dimensions` instead.
        :param pulumi.Input[str] effective_interval: The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default to "00:00-23:59".
        :param pulumi.Input[bool] enabled: Whether to enable alarm rule. Default to true.
        :param pulumi.Input[int] end_time: It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        :param pulumi.Input['AlarmEscalationsCriticalArgs'] escalations_critical: A configuration of critical alarm. See `escalations_critical` below.
        :param pulumi.Input['AlarmEscalationsInfoArgs'] escalations_info: A configuration of critical info. See `escalations_info` below.
        :param pulumi.Input['AlarmEscalationsWarnArgs'] escalations_warn: A configuration of critical warn. See `escalations_warn` below.
        :param pulumi.Input[str] metric: Name of the monitoring metrics corresponding to a project, such as "CPUUtilization" and "networkin_rate". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[str] metric_dimensions: Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[str] name: The alarm rule name.
        :param pulumi.Input[str] operator: It has been deprecated from provider version 1.94.0 and 'escalations_critical.comparison_operator' instead.
        :param pulumi.Input[int] period: Index query cycle, which must be consistent with that defined for metrics. Default to 300, in seconds.
        :param pulumi.Input[str] project: Monitor project name, such as "acs_ecs_dashboard" and "acs_rds_dashboard". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
               **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]] prometheuses: The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        :param pulumi.Input[int] silence_time: Notification silence period in the alarm state, in seconds. Valid value range: [300, 86400]. Default to 86400
        :param pulumi.Input[int] start_time: It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        :param pulumi.Input[str] statistics: It has been deprecated from provider version 1.94.0 and 'escalations_critical.statistics' instead.
        :param pulumi.Input[str] status: The current alarm rule status.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               
               > **NOTE:** Each resource supports the creation of one of the following three levels.
        :param pulumi.Input[str] threshold: It has been deprecated from provider version 1.94.0 and 'escalations_critical.threshold' instead.
        :param pulumi.Input[int] triggered_count: It has been deprecated from provider version 1.94.0 and 'escalations_critical.times' instead.
        :param pulumi.Input[str] webhook: The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        if contact_groups is not None:
            pulumi.set(__self__, "contact_groups", contact_groups)
        if dimensions is not None:
            warnings.warn("""Field 'dimensions' has been deprecated from version 1.173.0. Use 'metric_dimensions' instead.""", DeprecationWarning)
            pulumi.log.warn("""dimensions is deprecated: Field 'dimensions' has been deprecated from version 1.173.0. Use 'metric_dimensions' instead.""")
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if effective_interval is not None:
            pulumi.set(__self__, "effective_interval", effective_interval)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if end_time is not None:
            warnings.warn("""Field 'end_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""", DeprecationWarning)
            pulumi.log.warn("""end_time is deprecated: Field 'end_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""")
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if escalations_critical is not None:
            pulumi.set(__self__, "escalations_critical", escalations_critical)
        if escalations_info is not None:
            pulumi.set(__self__, "escalations_info", escalations_info)
        if escalations_warn is not None:
            pulumi.set(__self__, "escalations_warn", escalations_warn)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if metric_dimensions is not None:
            pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operator is not None:
            warnings.warn("""Field 'operator' has been deprecated from provider version 1.94.0. New field 'escalations_critical.comparison_operator' instead.""", DeprecationWarning)
            pulumi.log.warn("""operator is deprecated: Field 'operator' has been deprecated from provider version 1.94.0. New field 'escalations_critical.comparison_operator' instead.""")
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if prometheuses is not None:
            pulumi.set(__self__, "prometheuses", prometheuses)
        if silence_time is not None:
            pulumi.set(__self__, "silence_time", silence_time)
        if start_time is not None:
            warnings.warn("""Field 'start_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""", DeprecationWarning)
            pulumi.log.warn("""start_time is deprecated: Field 'start_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""")
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if statistics is not None:
            warnings.warn("""Field 'statistics' has been deprecated from provider version 1.94.0. New field 'escalations_critical.statistics' instead.""", DeprecationWarning)
            pulumi.log.warn("""statistics is deprecated: Field 'statistics' has been deprecated from provider version 1.94.0. New field 'escalations_critical.statistics' instead.""")
        if statistics is not None:
            pulumi.set(__self__, "statistics", statistics)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threshold is not None:
            warnings.warn("""Field 'threshold' has been deprecated from provider version 1.94.0. New field 'escalations_critical.threshold' instead.""", DeprecationWarning)
            pulumi.log.warn("""threshold is deprecated: Field 'threshold' has been deprecated from provider version 1.94.0. New field 'escalations_critical.threshold' instead.""")
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if triggered_count is not None:
            warnings.warn("""Field 'triggered_count' has been deprecated from provider version 1.94.0. New field 'escalations_critical.times' instead.""", DeprecationWarning)
            pulumi.log.warn("""triggered_count is deprecated: Field 'triggered_count' has been deprecated from provider version 1.94.0. New field 'escalations_critical.times' instead.""")
        if triggered_count is not None:
            pulumi.set(__self__, "triggered_count", triggered_count)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List contact groups of the alarm rule, which must have been created on the console.
        """
        return pulumi.get(self, "contact_groups")

    @contact_groups.setter
    def contact_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contact_groups", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Field `dimensions` has been deprecated from version 1.95.0. Use `metric_dimensions` instead.
        """
        warnings.warn("""Field 'dimensions' has been deprecated from version 1.173.0. Use 'metric_dimensions' instead.""", DeprecationWarning)
        pulumi.log.warn("""dimensions is deprecated: Field 'dimensions' has been deprecated from version 1.173.0. Use 'metric_dimensions' instead.""")

        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="effectiveInterval")
    def effective_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default to "00:00-23:59".
        """
        return pulumi.get(self, "effective_interval")

    @effective_interval.setter
    def effective_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_interval", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable alarm rule. Default to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[int]]:
        """
        It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        """
        warnings.warn("""Field 'end_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""", DeprecationWarning)
        pulumi.log.warn("""end_time is deprecated: Field 'end_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""")

        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="escalationsCritical")
    def escalations_critical(self) -> Optional[pulumi.Input['AlarmEscalationsCriticalArgs']]:
        """
        A configuration of critical alarm. See `escalations_critical` below.
        """
        return pulumi.get(self, "escalations_critical")

    @escalations_critical.setter
    def escalations_critical(self, value: Optional[pulumi.Input['AlarmEscalationsCriticalArgs']]):
        pulumi.set(self, "escalations_critical", value)

    @property
    @pulumi.getter(name="escalationsInfo")
    def escalations_info(self) -> Optional[pulumi.Input['AlarmEscalationsInfoArgs']]:
        """
        A configuration of critical info. See `escalations_info` below.
        """
        return pulumi.get(self, "escalations_info")

    @escalations_info.setter
    def escalations_info(self, value: Optional[pulumi.Input['AlarmEscalationsInfoArgs']]):
        pulumi.set(self, "escalations_info", value)

    @property
    @pulumi.getter(name="escalationsWarn")
    def escalations_warn(self) -> Optional[pulumi.Input['AlarmEscalationsWarnArgs']]:
        """
        A configuration of critical warn. See `escalations_warn` below.
        """
        return pulumi.get(self, "escalations_warn")

    @escalations_warn.setter
    def escalations_warn(self, value: Optional[pulumi.Input['AlarmEscalationsWarnArgs']]):
        pulumi.set(self, "escalations_warn", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the monitoring metrics corresponding to a project, such as "CPUUtilization" and "networkin_rate". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Optional[pulumi.Input[str]]:
        """
        Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric_dimensions")

    @metric_dimensions.setter
    def metric_dimensions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_dimensions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The alarm rule name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.comparison_operator' instead.
        """
        warnings.warn("""Field 'operator' has been deprecated from provider version 1.94.0. New field 'escalations_critical.comparison_operator' instead.""", DeprecationWarning)
        pulumi.log.warn("""operator is deprecated: Field 'operator' has been deprecated from provider version 1.94.0. New field 'escalations_critical.comparison_operator' instead.""")

        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Index query cycle, which must be consistent with that defined for metrics. Default to 300, in seconds.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Monitor project name, such as "acs_ecs_dashboard" and "acs_rds_dashboard". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def prometheuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]]:
        """
        The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        """
        return pulumi.get(self, "prometheuses")

    @prometheuses.setter
    def prometheuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]]):
        pulumi.set(self, "prometheuses", value)

    @property
    @pulumi.getter(name="silenceTime")
    def silence_time(self) -> Optional[pulumi.Input[int]]:
        """
        Notification silence period in the alarm state, in seconds. Valid value range: [300, 86400]. Default to 86400
        """
        return pulumi.get(self, "silence_time")

    @silence_time.setter
    def silence_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "silence_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[int]]:
        """
        It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        """
        warnings.warn("""Field 'start_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""", DeprecationWarning)
        pulumi.log.warn("""start_time is deprecated: Field 'start_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""")

        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def statistics(self) -> Optional[pulumi.Input[str]]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.statistics' instead.
        """
        warnings.warn("""Field 'statistics' has been deprecated from provider version 1.94.0. New field 'escalations_critical.statistics' instead.""", DeprecationWarning)
        pulumi.log.warn("""statistics is deprecated: Field 'statistics' has been deprecated from provider version 1.94.0. New field 'escalations_critical.statistics' instead.""")

        return pulumi.get(self, "statistics")

    @statistics.setter
    def statistics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statistics", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current alarm rule status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.

        > **NOTE:** Each resource supports the creation of one of the following three levels.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[str]]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.threshold' instead.
        """
        warnings.warn("""Field 'threshold' has been deprecated from provider version 1.94.0. New field 'escalations_critical.threshold' instead.""", DeprecationWarning)
        pulumi.log.warn("""threshold is deprecated: Field 'threshold' has been deprecated from provider version 1.94.0. New field 'escalations_critical.threshold' instead.""")

        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="triggeredCount")
    def triggered_count(self) -> Optional[pulumi.Input[int]]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.times' instead.
        """
        warnings.warn("""Field 'triggered_count' has been deprecated from provider version 1.94.0. New field 'escalations_critical.times' instead.""", DeprecationWarning)
        pulumi.log.warn("""triggered_count is deprecated: Field 'triggered_count' has been deprecated from provider version 1.94.0. New field 'escalations_critical.times' instead.""")

        return pulumi.get(self, "triggered_count")

    @triggered_count.setter
    def triggered_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "triggered_count", value)

    @property
    @pulumi.getter
    def webhook(self) -> Optional[pulumi.Input[str]]:
        """
        The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook", value)


class Alarm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 effective_interval: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 end_time: Optional[pulumi.Input[int]] = None,
                 escalations_critical: Optional[pulumi.Input[pulumi.InputType['AlarmEscalationsCriticalArgs']]] = None,
                 escalations_info: Optional[pulumi.Input[pulumi.InputType['AlarmEscalationsInfoArgs']]] = None,
                 escalations_warn: Optional[pulumi.Input[pulumi.InputType['AlarmEscalationsWarnArgs']]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 metric_dimensions: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 prometheuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmPrometheusArgs']]]]] = None,
                 silence_time: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[int]] = None,
                 statistics: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 threshold: Optional[pulumi.Input[str]] = None,
                 triggered_count: Optional[pulumi.Input[int]] = None,
                 webhook: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides a alarm rule resource and it can be used to monitor several cloud services according different metrics.
        Details for [What is alarm](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putresourcemetricrule).

        > **NOTE:** Available since v1.9.1.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            owners="system")
        default_zones = alicloud.get_zones(available_resource_creation="Instance")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("defaultInstance",
            availability_zone=default_zones.zones[0].id,
            instance_name=name,
            image_id=default_images.images[0].id,
            instance_type=default_instance_types.instance_types[0].id,
            security_groups=[default_security_group.id],
            vswitch_id=default_switch.id)
        default_alarm_contact_group = alicloud.cms.AlarmContactGroup("defaultAlarmContactGroup", alarm_contact_group_name=name)
        default_alarm = alicloud.cms.Alarm("defaultAlarm",
            project="acs_ecs_dashboard",
            metric="disk_writebytes",
            metric_dimensions=default_instance.id.apply(lambda id: f"[{{\\"instanceId\\":\\"{id}\\",\\"device\\":\\"/dev/vda1\\"}}]"),
            escalations_critical=alicloud.cms.AlarmEscalationsCriticalArgs(
                statistics="Average",
                comparison_operator="<=",
                threshold="35",
                times=2,
            ),
            period=900,
            contact_groups=[default_alarm_contact_group.alarm_contact_group_name],
            effective_interval="06:00-20:00")
        ```

        ## Import

        Alarm rule can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cms/alarm:Alarm alarm abc12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_groups: List contact groups of the alarm rule, which must have been created on the console.
        :param pulumi.Input[Mapping[str, Any]] dimensions: Field `dimensions` has been deprecated from version 1.95.0. Use `metric_dimensions` instead.
        :param pulumi.Input[str] effective_interval: The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default to "00:00-23:59".
        :param pulumi.Input[bool] enabled: Whether to enable alarm rule. Default to true.
        :param pulumi.Input[int] end_time: It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        :param pulumi.Input[pulumi.InputType['AlarmEscalationsCriticalArgs']] escalations_critical: A configuration of critical alarm. See `escalations_critical` below.
        :param pulumi.Input[pulumi.InputType['AlarmEscalationsInfoArgs']] escalations_info: A configuration of critical info. See `escalations_info` below.
        :param pulumi.Input[pulumi.InputType['AlarmEscalationsWarnArgs']] escalations_warn: A configuration of critical warn. See `escalations_warn` below.
        :param pulumi.Input[str] metric: Name of the monitoring metrics corresponding to a project, such as "CPUUtilization" and "networkin_rate". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[str] metric_dimensions: Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[str] name: The alarm rule name.
        :param pulumi.Input[str] operator: It has been deprecated from provider version 1.94.0 and 'escalations_critical.comparison_operator' instead.
        :param pulumi.Input[int] period: Index query cycle, which must be consistent with that defined for metrics. Default to 300, in seconds.
        :param pulumi.Input[str] project: Monitor project name, such as "acs_ecs_dashboard" and "acs_rds_dashboard". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
               **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmPrometheusArgs']]]] prometheuses: The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        :param pulumi.Input[int] silence_time: Notification silence period in the alarm state, in seconds. Valid value range: [300, 86400]. Default to 86400
        :param pulumi.Input[int] start_time: It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        :param pulumi.Input[str] statistics: It has been deprecated from provider version 1.94.0 and 'escalations_critical.statistics' instead.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               
               > **NOTE:** Each resource supports the creation of one of the following three levels.
        :param pulumi.Input[str] threshold: It has been deprecated from provider version 1.94.0 and 'escalations_critical.threshold' instead.
        :param pulumi.Input[int] triggered_count: It has been deprecated from provider version 1.94.0 and 'escalations_critical.times' instead.
        :param pulumi.Input[str] webhook: The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides a alarm rule resource and it can be used to monitor several cloud services according different metrics.
        Details for [What is alarm](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putresourcemetricrule).

        > **NOTE:** Available since v1.9.1.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            owners="system")
        default_zones = alicloud.get_zones(available_resource_creation="Instance")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("defaultInstance",
            availability_zone=default_zones.zones[0].id,
            instance_name=name,
            image_id=default_images.images[0].id,
            instance_type=default_instance_types.instance_types[0].id,
            security_groups=[default_security_group.id],
            vswitch_id=default_switch.id)
        default_alarm_contact_group = alicloud.cms.AlarmContactGroup("defaultAlarmContactGroup", alarm_contact_group_name=name)
        default_alarm = alicloud.cms.Alarm("defaultAlarm",
            project="acs_ecs_dashboard",
            metric="disk_writebytes",
            metric_dimensions=default_instance.id.apply(lambda id: f"[{{\\"instanceId\\":\\"{id}\\",\\"device\\":\\"/dev/vda1\\"}}]"),
            escalations_critical=alicloud.cms.AlarmEscalationsCriticalArgs(
                statistics="Average",
                comparison_operator="<=",
                threshold="35",
                times=2,
            ),
            period=900,
            contact_groups=[default_alarm_contact_group.alarm_contact_group_name],
            effective_interval="06:00-20:00")
        ```

        ## Import

        Alarm rule can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cms/alarm:Alarm alarm abc12345
        ```

        :param str resource_name: The name of the resource.
        :param AlarmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 effective_interval: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 end_time: Optional[pulumi.Input[int]] = None,
                 escalations_critical: Optional[pulumi.Input[pulumi.InputType['AlarmEscalationsCriticalArgs']]] = None,
                 escalations_info: Optional[pulumi.Input[pulumi.InputType['AlarmEscalationsInfoArgs']]] = None,
                 escalations_warn: Optional[pulumi.Input[pulumi.InputType['AlarmEscalationsWarnArgs']]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 metric_dimensions: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 prometheuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmPrometheusArgs']]]]] = None,
                 silence_time: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[int]] = None,
                 statistics: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 threshold: Optional[pulumi.Input[str]] = None,
                 triggered_count: Optional[pulumi.Input[int]] = None,
                 webhook: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmArgs.__new__(AlarmArgs)

            if contact_groups is None and not opts.urn:
                raise TypeError("Missing required property 'contact_groups'")
            __props__.__dict__["contact_groups"] = contact_groups
            __props__.__dict__["dimensions"] = dimensions
            __props__.__dict__["effective_interval"] = effective_interval
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["escalations_critical"] = escalations_critical
            __props__.__dict__["escalations_info"] = escalations_info
            __props__.__dict__["escalations_warn"] = escalations_warn
            if metric is None and not opts.urn:
                raise TypeError("Missing required property 'metric'")
            __props__.__dict__["metric"] = metric
            __props__.__dict__["metric_dimensions"] = metric_dimensions
            __props__.__dict__["name"] = name
            __props__.__dict__["operator"] = operator
            __props__.__dict__["period"] = period
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["prometheuses"] = prometheuses
            __props__.__dict__["silence_time"] = silence_time
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["statistics"] = statistics
            __props__.__dict__["tags"] = tags
            __props__.__dict__["threshold"] = threshold
            __props__.__dict__["triggered_count"] = triggered_count
            __props__.__dict__["webhook"] = webhook
            __props__.__dict__["status"] = None
        super(Alarm, __self__).__init__(
            'alicloud:cms/alarm:Alarm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            dimensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            effective_interval: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            end_time: Optional[pulumi.Input[int]] = None,
            escalations_critical: Optional[pulumi.Input[pulumi.InputType['AlarmEscalationsCriticalArgs']]] = None,
            escalations_info: Optional[pulumi.Input[pulumi.InputType['AlarmEscalationsInfoArgs']]] = None,
            escalations_warn: Optional[pulumi.Input[pulumi.InputType['AlarmEscalationsWarnArgs']]] = None,
            metric: Optional[pulumi.Input[str]] = None,
            metric_dimensions: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            operator: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            prometheuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmPrometheusArgs']]]]] = None,
            silence_time: Optional[pulumi.Input[int]] = None,
            start_time: Optional[pulumi.Input[int]] = None,
            statistics: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            threshold: Optional[pulumi.Input[str]] = None,
            triggered_count: Optional[pulumi.Input[int]] = None,
            webhook: Optional[pulumi.Input[str]] = None) -> 'Alarm':
        """
        Get an existing Alarm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_groups: List contact groups of the alarm rule, which must have been created on the console.
        :param pulumi.Input[Mapping[str, Any]] dimensions: Field `dimensions` has been deprecated from version 1.95.0. Use `metric_dimensions` instead.
        :param pulumi.Input[str] effective_interval: The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default to "00:00-23:59".
        :param pulumi.Input[bool] enabled: Whether to enable alarm rule. Default to true.
        :param pulumi.Input[int] end_time: It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        :param pulumi.Input[pulumi.InputType['AlarmEscalationsCriticalArgs']] escalations_critical: A configuration of critical alarm. See `escalations_critical` below.
        :param pulumi.Input[pulumi.InputType['AlarmEscalationsInfoArgs']] escalations_info: A configuration of critical info. See `escalations_info` below.
        :param pulumi.Input[pulumi.InputType['AlarmEscalationsWarnArgs']] escalations_warn: A configuration of critical warn. See `escalations_warn` below.
        :param pulumi.Input[str] metric: Name of the monitoring metrics corresponding to a project, such as "CPUUtilization" and "networkin_rate". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[str] metric_dimensions: Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[str] name: The alarm rule name.
        :param pulumi.Input[str] operator: It has been deprecated from provider version 1.94.0 and 'escalations_critical.comparison_operator' instead.
        :param pulumi.Input[int] period: Index query cycle, which must be consistent with that defined for metrics. Default to 300, in seconds.
        :param pulumi.Input[str] project: Monitor project name, such as "acs_ecs_dashboard" and "acs_rds_dashboard". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
               **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmPrometheusArgs']]]] prometheuses: The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        :param pulumi.Input[int] silence_time: Notification silence period in the alarm state, in seconds. Valid value range: [300, 86400]. Default to 86400
        :param pulumi.Input[int] start_time: It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        :param pulumi.Input[str] statistics: It has been deprecated from provider version 1.94.0 and 'escalations_critical.statistics' instead.
        :param pulumi.Input[str] status: The current alarm rule status.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               
               > **NOTE:** Each resource supports the creation of one of the following three levels.
        :param pulumi.Input[str] threshold: It has been deprecated from provider version 1.94.0 and 'escalations_critical.threshold' instead.
        :param pulumi.Input[int] triggered_count: It has been deprecated from provider version 1.94.0 and 'escalations_critical.times' instead.
        :param pulumi.Input[str] webhook: The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmState.__new__(_AlarmState)

        __props__.__dict__["contact_groups"] = contact_groups
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["effective_interval"] = effective_interval
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["escalations_critical"] = escalations_critical
        __props__.__dict__["escalations_info"] = escalations_info
        __props__.__dict__["escalations_warn"] = escalations_warn
        __props__.__dict__["metric"] = metric
        __props__.__dict__["metric_dimensions"] = metric_dimensions
        __props__.__dict__["name"] = name
        __props__.__dict__["operator"] = operator
        __props__.__dict__["period"] = period
        __props__.__dict__["project"] = project
        __props__.__dict__["prometheuses"] = prometheuses
        __props__.__dict__["silence_time"] = silence_time
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["statistics"] = statistics
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["threshold"] = threshold
        __props__.__dict__["triggered_count"] = triggered_count
        __props__.__dict__["webhook"] = webhook
        return Alarm(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        List contact groups of the alarm rule, which must have been created on the console.
        """
        return pulumi.get(self, "contact_groups")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Field `dimensions` has been deprecated from version 1.95.0. Use `metric_dimensions` instead.
        """
        warnings.warn("""Field 'dimensions' has been deprecated from version 1.173.0. Use 'metric_dimensions' instead.""", DeprecationWarning)
        pulumi.log.warn("""dimensions is deprecated: Field 'dimensions' has been deprecated from version 1.173.0. Use 'metric_dimensions' instead.""")

        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="effectiveInterval")
    def effective_interval(self) -> pulumi.Output[Optional[str]]:
        """
        The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default to "00:00-23:59".
        """
        return pulumi.get(self, "effective_interval")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable alarm rule. Default to true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[int]]:
        """
        It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        """
        warnings.warn("""Field 'end_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""", DeprecationWarning)
        pulumi.log.warn("""end_time is deprecated: Field 'end_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""")

        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="escalationsCritical")
    def escalations_critical(self) -> pulumi.Output[Optional['outputs.AlarmEscalationsCritical']]:
        """
        A configuration of critical alarm. See `escalations_critical` below.
        """
        return pulumi.get(self, "escalations_critical")

    @property
    @pulumi.getter(name="escalationsInfo")
    def escalations_info(self) -> pulumi.Output[Optional['outputs.AlarmEscalationsInfo']]:
        """
        A configuration of critical info. See `escalations_info` below.
        """
        return pulumi.get(self, "escalations_info")

    @property
    @pulumi.getter(name="escalationsWarn")
    def escalations_warn(self) -> pulumi.Output[Optional['outputs.AlarmEscalationsWarn']]:
        """
        A configuration of critical warn. See `escalations_warn` below.
        """
        return pulumi.get(self, "escalations_warn")

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Output[str]:
        """
        Name of the monitoring metrics corresponding to a project, such as "CPUUtilization" and "networkin_rate". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> pulumi.Output[str]:
        """
        Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric_dimensions")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The alarm rule name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Output[str]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.comparison_operator' instead.
        """
        warnings.warn("""Field 'operator' has been deprecated from provider version 1.94.0. New field 'escalations_critical.comparison_operator' instead.""", DeprecationWarning)
        pulumi.log.warn("""operator is deprecated: Field 'operator' has been deprecated from provider version 1.94.0. New field 'escalations_critical.comparison_operator' instead.""")

        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Index query cycle, which must be consistent with that defined for metrics. Default to 300, in seconds.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Monitor project name, such as "acs_ecs_dashboard" and "acs_rds_dashboard". For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def prometheuses(self) -> pulumi.Output[Optional[Sequence['outputs.AlarmPrometheus']]]:
        """
        The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        """
        return pulumi.get(self, "prometheuses")

    @property
    @pulumi.getter(name="silenceTime")
    def silence_time(self) -> pulumi.Output[Optional[int]]:
        """
        Notification silence period in the alarm state, in seconds. Valid value range: [300, 86400]. Default to 86400
        """
        return pulumi.get(self, "silence_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[int]]:
        """
        It has been deprecated from provider version 1.50.0 and 'effective_interval' instead.
        """
        warnings.warn("""Field 'start_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""", DeprecationWarning)
        pulumi.log.warn("""start_time is deprecated: Field 'start_time' has been deprecated from provider version 1.50.0. New field 'effective_interval' instead.""")

        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def statistics(self) -> pulumi.Output[str]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.statistics' instead.
        """
        warnings.warn("""Field 'statistics' has been deprecated from provider version 1.94.0. New field 'escalations_critical.statistics' instead.""", DeprecationWarning)
        pulumi.log.warn("""statistics is deprecated: Field 'statistics' has been deprecated from provider version 1.94.0. New field 'escalations_critical.statistics' instead.""")

        return pulumi.get(self, "statistics")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current alarm rule status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.

        > **NOTE:** Each resource supports the creation of one of the following three levels.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[str]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.threshold' instead.
        """
        warnings.warn("""Field 'threshold' has been deprecated from provider version 1.94.0. New field 'escalations_critical.threshold' instead.""", DeprecationWarning)
        pulumi.log.warn("""threshold is deprecated: Field 'threshold' has been deprecated from provider version 1.94.0. New field 'escalations_critical.threshold' instead.""")

        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="triggeredCount")
    def triggered_count(self) -> pulumi.Output[int]:
        """
        It has been deprecated from provider version 1.94.0 and 'escalations_critical.times' instead.
        """
        warnings.warn("""Field 'triggered_count' has been deprecated from provider version 1.94.0. New field 'escalations_critical.times' instead.""", DeprecationWarning)
        pulumi.log.warn("""triggered_count is deprecated: Field 'triggered_count' has been deprecated from provider version 1.94.0. New field 'escalations_critical.times' instead.""")

        return pulumi.get(self, "triggered_count")

    @property
    @pulumi.getter
    def webhook(self) -> pulumi.Output[Optional[str]]:
        """
        The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        return pulumi.get(self, "webhook")

