# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupMetricRuleArgs', 'GroupMetricRule']

@pulumi.input_type
class GroupMetricRuleArgs:
    def __init__(__self__, *,
                 escalations: pulumi.Input['GroupMetricRuleEscalationsArgs'],
                 group_id: pulumi.Input[str],
                 group_metric_rule_name: pulumi.Input[str],
                 metric_name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 rule_id: pulumi.Input[str],
                 category: Optional[pulumi.Input[str]] = None,
                 contact_groups: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[str]] = None,
                 effective_interval: Optional[pulumi.Input[str]] = None,
                 email_subject: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 no_effective_interval: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 silence_time: Optional[pulumi.Input[int]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['GroupMetricRuleTargetArgs']]]] = None,
                 webhook: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GroupMetricRule resource.
        :param pulumi.Input['GroupMetricRuleEscalationsArgs'] escalations: Alarm level. See `escalations` below.
        :param pulumi.Input[str] group_id: The ID of the application group.
        :param pulumi.Input[str] group_metric_rule_name: The name of the alert rule.
        :param pulumi.Input[str] metric_name: The name of the metric.
        :param pulumi.Input[str] namespace: The namespace of the service.
        :param pulumi.Input[str] rule_id: The ID of the alert rule.
        :param pulumi.Input[str] category: The abbreviation of the service name.
        :param pulumi.Input[str] contact_groups: Alarm contact group.
        :param pulumi.Input[str] dimensions: The dimensions that specify the resources to be associated with the alert rule.
        :param pulumi.Input[str] effective_interval: The time period during which the alert rule is effective.
        :param pulumi.Input[str] email_subject: The subject of the alert notification email.
        :param pulumi.Input[str] interval: The interval at which Cloud Monitor checks whether the alert rule is triggered. Unit: seconds.
        :param pulumi.Input[str] no_effective_interval: The time period during which the alert rule is ineffective.
        :param pulumi.Input[int] period: The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
        :param pulumi.Input[int] silence_time: The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
        :param pulumi.Input[Sequence[pulumi.Input['GroupMetricRuleTargetArgs']]] targets: The information about the resource for which alerts are triggered. See `targets` below.
        :param pulumi.Input[str] webhook: The callback URL.
        """
        pulumi.set(__self__, "escalations", escalations)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_metric_rule_name", group_metric_rule_name)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "rule_id", rule_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if contact_groups is not None:
            pulumi.set(__self__, "contact_groups", contact_groups)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if effective_interval is not None:
            pulumi.set(__self__, "effective_interval", effective_interval)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if no_effective_interval is not None:
            pulumi.set(__self__, "no_effective_interval", no_effective_interval)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if silence_time is not None:
            pulumi.set(__self__, "silence_time", silence_time)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter
    def escalations(self) -> pulumi.Input['GroupMetricRuleEscalationsArgs']:
        """
        Alarm level. See `escalations` below.
        """
        return pulumi.get(self, "escalations")

    @escalations.setter
    def escalations(self, value: pulumi.Input['GroupMetricRuleEscalationsArgs']):
        pulumi.set(self, "escalations", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        The ID of the application group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="groupMetricRuleName")
    def group_metric_rule_name(self) -> pulumi.Input[str]:
        """
        The name of the alert rule.
        """
        return pulumi.get(self, "group_metric_rule_name")

    @group_metric_rule_name.setter
    def group_metric_rule_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_metric_rule_name", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The namespace of the service.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[str]:
        """
        The ID of the alert rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The abbreviation of the service name.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Alarm contact group.
        """
        return pulumi.get(self, "contact_groups")

    @contact_groups.setter
    def contact_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contact_groups", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[str]]:
        """
        The dimensions that specify the resources to be associated with the alert rule.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="effectiveInterval")
    def effective_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The time period during which the alert rule is effective.
        """
        return pulumi.get(self, "effective_interval")

    @effective_interval.setter
    def effective_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_interval", value)

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[pulumi.Input[str]]:
        """
        The subject of the alert notification email.
        """
        return pulumi.get(self, "email_subject")

    @email_subject.setter
    def email_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_subject", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        The interval at which Cloud Monitor checks whether the alert rule is triggered. Unit: seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="noEffectiveInterval")
    def no_effective_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The time period during which the alert rule is ineffective.
        """
        return pulumi.get(self, "no_effective_interval")

    @no_effective_interval.setter
    def no_effective_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "no_effective_interval", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="silenceTime")
    def silence_time(self) -> Optional[pulumi.Input[int]]:
        """
        The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
        """
        return pulumi.get(self, "silence_time")

    @silence_time.setter
    def silence_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "silence_time", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupMetricRuleTargetArgs']]]]:
        """
        The information about the resource for which alerts are triggered. See `targets` below.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupMetricRuleTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter
    def webhook(self) -> Optional[pulumi.Input[str]]:
        """
        The callback URL.
        """
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook", value)


@pulumi.input_type
class _GroupMetricRuleState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 contact_groups: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[str]] = None,
                 effective_interval: Optional[pulumi.Input[str]] = None,
                 email_subject: Optional[pulumi.Input[str]] = None,
                 escalations: Optional[pulumi.Input['GroupMetricRuleEscalationsArgs']] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 group_metric_rule_name: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 no_effective_interval: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 silence_time: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['GroupMetricRuleTargetArgs']]]] = None,
                 webhook: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GroupMetricRule resources.
        :param pulumi.Input[str] category: The abbreviation of the service name.
        :param pulumi.Input[str] contact_groups: Alarm contact group.
        :param pulumi.Input[str] dimensions: The dimensions that specify the resources to be associated with the alert rule.
        :param pulumi.Input[str] effective_interval: The time period during which the alert rule is effective.
        :param pulumi.Input[str] email_subject: The subject of the alert notification email.
        :param pulumi.Input['GroupMetricRuleEscalationsArgs'] escalations: Alarm level. See `escalations` below.
        :param pulumi.Input[str] group_id: The ID of the application group.
        :param pulumi.Input[str] group_metric_rule_name: The name of the alert rule.
        :param pulumi.Input[str] interval: The interval at which Cloud Monitor checks whether the alert rule is triggered. Unit: seconds.
        :param pulumi.Input[str] metric_name: The name of the metric.
        :param pulumi.Input[str] namespace: The namespace of the service.
        :param pulumi.Input[str] no_effective_interval: The time period during which the alert rule is ineffective.
        :param pulumi.Input[int] period: The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
        :param pulumi.Input[str] rule_id: The ID of the alert rule.
        :param pulumi.Input[int] silence_time: The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
        :param pulumi.Input[str] status: The status of Group Metric Rule.
        :param pulumi.Input[Sequence[pulumi.Input['GroupMetricRuleTargetArgs']]] targets: The information about the resource for which alerts are triggered. See `targets` below.
        :param pulumi.Input[str] webhook: The callback URL.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if contact_groups is not None:
            pulumi.set(__self__, "contact_groups", contact_groups)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if effective_interval is not None:
            pulumi.set(__self__, "effective_interval", effective_interval)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)
        if escalations is not None:
            pulumi.set(__self__, "escalations", escalations)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if group_metric_rule_name is not None:
            pulumi.set(__self__, "group_metric_rule_name", group_metric_rule_name)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if no_effective_interval is not None:
            pulumi.set(__self__, "no_effective_interval", no_effective_interval)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if silence_time is not None:
            pulumi.set(__self__, "silence_time", silence_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The abbreviation of the service name.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Alarm contact group.
        """
        return pulumi.get(self, "contact_groups")

    @contact_groups.setter
    def contact_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contact_groups", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[str]]:
        """
        The dimensions that specify the resources to be associated with the alert rule.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="effectiveInterval")
    def effective_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The time period during which the alert rule is effective.
        """
        return pulumi.get(self, "effective_interval")

    @effective_interval.setter
    def effective_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_interval", value)

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[pulumi.Input[str]]:
        """
        The subject of the alert notification email.
        """
        return pulumi.get(self, "email_subject")

    @email_subject.setter
    def email_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_subject", value)

    @property
    @pulumi.getter
    def escalations(self) -> Optional[pulumi.Input['GroupMetricRuleEscalationsArgs']]:
        """
        Alarm level. See `escalations` below.
        """
        return pulumi.get(self, "escalations")

    @escalations.setter
    def escalations(self, value: Optional[pulumi.Input['GroupMetricRuleEscalationsArgs']]):
        pulumi.set(self, "escalations", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the application group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="groupMetricRuleName")
    def group_metric_rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the alert rule.
        """
        return pulumi.get(self, "group_metric_rule_name")

    @group_metric_rule_name.setter
    def group_metric_rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_metric_rule_name", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        The interval at which Cloud Monitor checks whether the alert rule is triggered. Unit: seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace of the service.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="noEffectiveInterval")
    def no_effective_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The time period during which the alert rule is ineffective.
        """
        return pulumi.get(self, "no_effective_interval")

    @no_effective_interval.setter
    def no_effective_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "no_effective_interval", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the alert rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="silenceTime")
    def silence_time(self) -> Optional[pulumi.Input[int]]:
        """
        The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
        """
        return pulumi.get(self, "silence_time")

    @silence_time.setter
    def silence_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "silence_time", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of Group Metric Rule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupMetricRuleTargetArgs']]]]:
        """
        The information about the resource for which alerts are triggered. See `targets` below.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupMetricRuleTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter
    def webhook(self) -> Optional[pulumi.Input[str]]:
        """
        The callback URL.
        """
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook", value)


class GroupMetricRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 contact_groups: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[str]] = None,
                 effective_interval: Optional[pulumi.Input[str]] = None,
                 email_subject: Optional[pulumi.Input[str]] = None,
                 escalations: Optional[pulumi.Input[pulumi.InputType['GroupMetricRuleEscalationsArgs']]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 group_metric_rule_name: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 no_effective_interval: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 silence_time: Optional[pulumi.Input[int]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupMetricRuleTargetArgs']]]]] = None,
                 webhook: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloud Monitor Service Group Metric Rule resource.

        For information about Cloud Monitor Service Group Metric Rule and how to use it, see [What is Group Metric Rule](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putgroupmetricrule).

        > **NOTE:** Available since v1.104.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_alarm_contact_group = alicloud.cms.AlarmContactGroup("defaultAlarmContactGroup",
            alarm_contact_group_name=name,
            describe=name)
        default_monitor_group = alicloud.cms.MonitorGroup("defaultMonitorGroup",
            monitor_group_name=name,
            contact_groups=[default_alarm_contact_group.id])
        this = alicloud.cms.GroupMetricRule("this",
            group_id=default_monitor_group.id,
            group_metric_rule_name=name,
            category="ecs",
            metric_name="cpu_total",
            namespace="acs_ecs_dashboard",
            rule_id=name,
            period=60,
            interval="3600",
            silence_time=85800,
            no_effective_interval="00:00-05:30",
            webhook="http://www.aliyun.com",
            escalations=alicloud.cms.GroupMetricRuleEscalationsArgs(
                warn=alicloud.cms.GroupMetricRuleEscalationsWarnArgs(
                    comparison_operator="GreaterThanOrEqualToThreshold",
                    statistics="Average",
                    threshold="90",
                    times=3,
                ),
                info=alicloud.cms.GroupMetricRuleEscalationsInfoArgs(
                    comparison_operator="LessThanLastWeek",
                    statistics="Average",
                    threshold="90",
                    times=5,
                ),
            ))
        ```

        ## Import

        Cloud Monitor Service Group Metric Rule can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cms/groupMetricRule:GroupMetricRule example <rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: The abbreviation of the service name.
        :param pulumi.Input[str] contact_groups: Alarm contact group.
        :param pulumi.Input[str] dimensions: The dimensions that specify the resources to be associated with the alert rule.
        :param pulumi.Input[str] effective_interval: The time period during which the alert rule is effective.
        :param pulumi.Input[str] email_subject: The subject of the alert notification email.
        :param pulumi.Input[pulumi.InputType['GroupMetricRuleEscalationsArgs']] escalations: Alarm level. See `escalations` below.
        :param pulumi.Input[str] group_id: The ID of the application group.
        :param pulumi.Input[str] group_metric_rule_name: The name of the alert rule.
        :param pulumi.Input[str] interval: The interval at which Cloud Monitor checks whether the alert rule is triggered. Unit: seconds.
        :param pulumi.Input[str] metric_name: The name of the metric.
        :param pulumi.Input[str] namespace: The namespace of the service.
        :param pulumi.Input[str] no_effective_interval: The time period during which the alert rule is ineffective.
        :param pulumi.Input[int] period: The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
        :param pulumi.Input[str] rule_id: The ID of the alert rule.
        :param pulumi.Input[int] silence_time: The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupMetricRuleTargetArgs']]]] targets: The information about the resource for which alerts are triggered. See `targets` below.
        :param pulumi.Input[str] webhook: The callback URL.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupMetricRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Monitor Service Group Metric Rule resource.

        For information about Cloud Monitor Service Group Metric Rule and how to use it, see [What is Group Metric Rule](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putgroupmetricrule).

        > **NOTE:** Available since v1.104.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_alarm_contact_group = alicloud.cms.AlarmContactGroup("defaultAlarmContactGroup",
            alarm_contact_group_name=name,
            describe=name)
        default_monitor_group = alicloud.cms.MonitorGroup("defaultMonitorGroup",
            monitor_group_name=name,
            contact_groups=[default_alarm_contact_group.id])
        this = alicloud.cms.GroupMetricRule("this",
            group_id=default_monitor_group.id,
            group_metric_rule_name=name,
            category="ecs",
            metric_name="cpu_total",
            namespace="acs_ecs_dashboard",
            rule_id=name,
            period=60,
            interval="3600",
            silence_time=85800,
            no_effective_interval="00:00-05:30",
            webhook="http://www.aliyun.com",
            escalations=alicloud.cms.GroupMetricRuleEscalationsArgs(
                warn=alicloud.cms.GroupMetricRuleEscalationsWarnArgs(
                    comparison_operator="GreaterThanOrEqualToThreshold",
                    statistics="Average",
                    threshold="90",
                    times=3,
                ),
                info=alicloud.cms.GroupMetricRuleEscalationsInfoArgs(
                    comparison_operator="LessThanLastWeek",
                    statistics="Average",
                    threshold="90",
                    times=5,
                ),
            ))
        ```

        ## Import

        Cloud Monitor Service Group Metric Rule can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cms/groupMetricRule:GroupMetricRule example <rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param GroupMetricRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupMetricRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 contact_groups: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[str]] = None,
                 effective_interval: Optional[pulumi.Input[str]] = None,
                 email_subject: Optional[pulumi.Input[str]] = None,
                 escalations: Optional[pulumi.Input[pulumi.InputType['GroupMetricRuleEscalationsArgs']]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 group_metric_rule_name: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 no_effective_interval: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 silence_time: Optional[pulumi.Input[int]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupMetricRuleTargetArgs']]]]] = None,
                 webhook: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupMetricRuleArgs.__new__(GroupMetricRuleArgs)

            __props__.__dict__["category"] = category
            __props__.__dict__["contact_groups"] = contact_groups
            __props__.__dict__["dimensions"] = dimensions
            __props__.__dict__["effective_interval"] = effective_interval
            __props__.__dict__["email_subject"] = email_subject
            if escalations is None and not opts.urn:
                raise TypeError("Missing required property 'escalations'")
            __props__.__dict__["escalations"] = escalations
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if group_metric_rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_metric_rule_name'")
            __props__.__dict__["group_metric_rule_name"] = group_metric_rule_name
            __props__.__dict__["interval"] = interval
            if metric_name is None and not opts.urn:
                raise TypeError("Missing required property 'metric_name'")
            __props__.__dict__["metric_name"] = metric_name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["no_effective_interval"] = no_effective_interval
            __props__.__dict__["period"] = period
            if rule_id is None and not opts.urn:
                raise TypeError("Missing required property 'rule_id'")
            __props__.__dict__["rule_id"] = rule_id
            __props__.__dict__["silence_time"] = silence_time
            __props__.__dict__["targets"] = targets
            __props__.__dict__["webhook"] = webhook
            __props__.__dict__["status"] = None
        super(GroupMetricRule, __self__).__init__(
            'alicloud:cms/groupMetricRule:GroupMetricRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[str]] = None,
            contact_groups: Optional[pulumi.Input[str]] = None,
            dimensions: Optional[pulumi.Input[str]] = None,
            effective_interval: Optional[pulumi.Input[str]] = None,
            email_subject: Optional[pulumi.Input[str]] = None,
            escalations: Optional[pulumi.Input[pulumi.InputType['GroupMetricRuleEscalationsArgs']]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            group_metric_rule_name: Optional[pulumi.Input[str]] = None,
            interval: Optional[pulumi.Input[str]] = None,
            metric_name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            no_effective_interval: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            rule_id: Optional[pulumi.Input[str]] = None,
            silence_time: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupMetricRuleTargetArgs']]]]] = None,
            webhook: Optional[pulumi.Input[str]] = None) -> 'GroupMetricRule':
        """
        Get an existing GroupMetricRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: The abbreviation of the service name.
        :param pulumi.Input[str] contact_groups: Alarm contact group.
        :param pulumi.Input[str] dimensions: The dimensions that specify the resources to be associated with the alert rule.
        :param pulumi.Input[str] effective_interval: The time period during which the alert rule is effective.
        :param pulumi.Input[str] email_subject: The subject of the alert notification email.
        :param pulumi.Input[pulumi.InputType['GroupMetricRuleEscalationsArgs']] escalations: Alarm level. See `escalations` below.
        :param pulumi.Input[str] group_id: The ID of the application group.
        :param pulumi.Input[str] group_metric_rule_name: The name of the alert rule.
        :param pulumi.Input[str] interval: The interval at which Cloud Monitor checks whether the alert rule is triggered. Unit: seconds.
        :param pulumi.Input[str] metric_name: The name of the metric.
        :param pulumi.Input[str] namespace: The namespace of the service.
        :param pulumi.Input[str] no_effective_interval: The time period during which the alert rule is ineffective.
        :param pulumi.Input[int] period: The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
        :param pulumi.Input[str] rule_id: The ID of the alert rule.
        :param pulumi.Input[int] silence_time: The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
        :param pulumi.Input[str] status: The status of Group Metric Rule.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupMetricRuleTargetArgs']]]] targets: The information about the resource for which alerts are triggered. See `targets` below.
        :param pulumi.Input[str] webhook: The callback URL.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupMetricRuleState.__new__(_GroupMetricRuleState)

        __props__.__dict__["category"] = category
        __props__.__dict__["contact_groups"] = contact_groups
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["effective_interval"] = effective_interval
        __props__.__dict__["email_subject"] = email_subject
        __props__.__dict__["escalations"] = escalations
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["group_metric_rule_name"] = group_metric_rule_name
        __props__.__dict__["interval"] = interval
        __props__.__dict__["metric_name"] = metric_name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["no_effective_interval"] = no_effective_interval
        __props__.__dict__["period"] = period
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["silence_time"] = silence_time
        __props__.__dict__["status"] = status
        __props__.__dict__["targets"] = targets
        __props__.__dict__["webhook"] = webhook
        return GroupMetricRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[Optional[str]]:
        """
        The abbreviation of the service name.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> pulumi.Output[str]:
        """
        Alarm contact group.
        """
        return pulumi.get(self, "contact_groups")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[str]:
        """
        The dimensions that specify the resources to be associated with the alert rule.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="effectiveInterval")
    def effective_interval(self) -> pulumi.Output[Optional[str]]:
        """
        The time period during which the alert rule is effective.
        """
        return pulumi.get(self, "effective_interval")

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> pulumi.Output[str]:
        """
        The subject of the alert notification email.
        """
        return pulumi.get(self, "email_subject")

    @property
    @pulumi.getter
    def escalations(self) -> pulumi.Output['outputs.GroupMetricRuleEscalations']:
        """
        Alarm level. See `escalations` below.
        """
        return pulumi.get(self, "escalations")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        The ID of the application group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupMetricRuleName")
    def group_metric_rule_name(self) -> pulumi.Output[str]:
        """
        The name of the alert rule.
        """
        return pulumi.get(self, "group_metric_rule_name")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[str]]:
        """
        The interval at which Cloud Monitor checks whether the alert rule is triggered. Unit: seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[str]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The namespace of the service.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="noEffectiveInterval")
    def no_effective_interval(self) -> pulumi.Output[Optional[str]]:
        """
        The time period during which the alert rule is ineffective.
        """
        return pulumi.get(self, "no_effective_interval")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[int]:
        """
        The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[str]:
        """
        The ID of the alert rule.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="silenceTime")
    def silence_time(self) -> pulumi.Output[int]:
        """
        The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
        """
        return pulumi.get(self, "silence_time")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of Group Metric Rule.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Sequence['outputs.GroupMetricRuleTarget']]:
        """
        The information about the resource for which alerts are triggered. See `targets` below.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter
    def webhook(self) -> pulumi.Output[Optional[str]]:
        """
        The callback URL.
        """
        return pulumi.get(self, "webhook")

