# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ChainChainConfig',
    'ChainChainConfigNode',
    'ChainChainConfigNodeNodeConfig',
    'ChainChainConfigNodeNodeConfigDenyPolicy',
    'ChainChainConfigRouter',
    'ChainChainConfigRouterFrom',
    'ChainChainConfigRouterTo',
    'RepoDomainList',
    'GetChainsChainResult',
    'GetChainsChainChainConfigResult',
    'GetChainsChainChainConfigNodeResult',
    'GetChainsChainChainConfigNodeNodeConfigResult',
    'GetChainsChainChainConfigNodeNodeConfigDenyPolicyResult',
    'GetChainsChainChainConfigRouterResult',
    'GetChainsChainChainConfigRouterFromResult',
    'GetChainsChainChainConfigRouterToResult',
    'GetChartNamespacesNamespaceResult',
    'GetChartRepositoriesRepositoryResult',
    'GetEndpointAclPoliciesPolicyResult',
    'GetNamespacesNamespaceResult',
    'GetReposRepoResult',
    'GetReposRepoDomainListResult',
    'GetReposRepoTagResult',
    'GetVpcEndpointLinkedVpcsVpcEndpointLinkedVpcResult',
]

@pulumi.output_type
class ChainChainConfig(dict):
    def __init__(__self__, *,
                 nodes: Optional[Sequence['outputs.ChainChainConfigNode']] = None,
                 routers: Optional[Sequence['outputs.ChainChainConfigRouter']] = None):
        """
        :param Sequence['ChainChainConfigNodeArgs'] nodes: Each node in the delivery chain. See `nodes` below.
               
               > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
        :param Sequence['ChainChainConfigRouterArgs'] routers: Execution sequence relationship between delivery chain nodes. See `routers` below.
        """
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if routers is not None:
            pulumi.set(__self__, "routers", routers)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence['outputs.ChainChainConfigNode']]:
        """
        Each node in the delivery chain. See `nodes` below.

        > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def routers(self) -> Optional[Sequence['outputs.ChainChainConfigRouter']]:
        """
        Execution sequence relationship between delivery chain nodes. See `routers` below.
        """
        return pulumi.get(self, "routers")


@pulumi.output_type
class ChainChainConfigNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeConfigs":
            suggest = "node_configs"
        elif key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChainChainConfigNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChainChainConfigNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChainChainConfigNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[bool] = None,
                 node_configs: Optional[Sequence['outputs.ChainChainConfigNodeNodeConfig']] = None,
                 node_name: Optional[str] = None):
        """
        :param bool enable: Whether to enable the delivery chain node. Valid values: `true`, `false`.
        :param Sequence['ChainChainConfigNodeNodeConfigArgs'] node_configs: The configuration of delivery chain node. See `node_config` below.
        :param str node_name: The name of delivery chain node.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if node_configs is not None:
            pulumi.set(__self__, "node_configs", node_configs)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Whether to enable the delivery chain node. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Optional[Sequence['outputs.ChainChainConfigNodeNodeConfig']]:
        """
        The configuration of delivery chain node. See `node_config` below.
        """
        return pulumi.get(self, "node_configs")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        The name of delivery chain node.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class ChainChainConfigNodeNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "denyPolicies":
            suggest = "deny_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChainChainConfigNodeNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChainChainConfigNodeNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChainChainConfigNodeNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deny_policies: Optional[Sequence['outputs.ChainChainConfigNodeNodeConfigDenyPolicy']] = None):
        """
        :param Sequence['ChainChainConfigNodeNodeConfigDenyPolicyArgs'] deny_policies: Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
        """
        if deny_policies is not None:
            pulumi.set(__self__, "deny_policies", deny_policies)

    @property
    @pulumi.getter(name="denyPolicies")
    def deny_policies(self) -> Optional[Sequence['outputs.ChainChainConfigNodeNodeConfigDenyPolicy']]:
        """
        Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
        """
        return pulumi.get(self, "deny_policies")


@pulumi.output_type
class ChainChainConfigNodeNodeConfigDenyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issueCount":
            suggest = "issue_count"
        elif key == "issueLevel":
            suggest = "issue_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChainChainConfigNodeNodeConfigDenyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChainChainConfigNodeNodeConfigDenyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChainChainConfigNodeNodeConfigDenyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 issue_count: Optional[str] = None,
                 issue_level: Optional[str] = None,
                 logic: Optional[str] = None):
        """
        :param str action: The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
        :param str issue_count: The count of scanning vulnerabilities that triggers blocking.
        :param str issue_level: The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
        :param str logic: The logic of trigger blocking. Valid values: `AND`, `OR`.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if issue_count is not None:
            pulumi.set(__self__, "issue_count", issue_count)
        if issue_level is not None:
            pulumi.set(__self__, "issue_level", issue_level)
        if logic is not None:
            pulumi.set(__self__, "logic", logic)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="issueCount")
    def issue_count(self) -> Optional[str]:
        """
        The count of scanning vulnerabilities that triggers blocking.
        """
        return pulumi.get(self, "issue_count")

    @property
    @pulumi.getter(name="issueLevel")
    def issue_level(self) -> Optional[str]:
        """
        The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
        """
        return pulumi.get(self, "issue_level")

    @property
    @pulumi.getter
    def logic(self) -> Optional[str]:
        """
        The logic of trigger blocking. Valid values: `AND`, `OR`.
        """
        return pulumi.get(self, "logic")


@pulumi.output_type
class ChainChainConfigRouter(dict):
    def __init__(__self__, *,
                 froms: Optional[Sequence['outputs.ChainChainConfigRouterFrom']] = None,
                 tos: Optional[Sequence['outputs.ChainChainConfigRouterTo']] = None):
        """
        :param Sequence['ChainChainConfigRouterFromArgs'] froms: Source node. See `from` below.
        :param Sequence['ChainChainConfigRouterToArgs'] tos: Destination node. See `to` below.
        """
        if froms is not None:
            pulumi.set(__self__, "froms", froms)
        if tos is not None:
            pulumi.set(__self__, "tos", tos)

    @property
    @pulumi.getter
    def froms(self) -> Optional[Sequence['outputs.ChainChainConfigRouterFrom']]:
        """
        Source node. See `from` below.
        """
        return pulumi.get(self, "froms")

    @property
    @pulumi.getter
    def tos(self) -> Optional[Sequence['outputs.ChainChainConfigRouterTo']]:
        """
        Destination node. See `to` below.
        """
        return pulumi.get(self, "tos")


@pulumi.output_type
class ChainChainConfigRouterFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChainChainConfigRouterFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChainChainConfigRouterFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChainChainConfigRouterFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_name: Optional[str] = None):
        """
        :param str node_name: The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class ChainChainConfigRouterTo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChainChainConfigRouterTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChainChainConfigRouterTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChainChainConfigRouterTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_name: Optional[str] = None):
        """
        :param str node_name: The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class RepoDomainList(dict):
    def __init__(__self__, *,
                 internal: Optional[str] = None,
                 public: Optional[str] = None,
                 vpc: Optional[str] = None):
        """
        :param str internal: Domain of internal endpoint, only in some regions.
        :param str public: Domain of public endpoint.
        :param str vpc: Domain of vpc endpoint.
        """
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def internal(self) -> Optional[str]:
        """
        Domain of internal endpoint, only in some regions.
        """
        return pulumi.get(self, "internal")

    @property
    @pulumi.getter
    def public(self) -> Optional[str]:
        """
        Domain of public endpoint.
        """
        return pulumi.get(self, "public")

    @property
    @pulumi.getter
    def vpc(self) -> Optional[str]:
        """
        Domain of vpc endpoint.
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class GetChainsChainResult(dict):
    def __init__(__self__, *,
                 chain_configs: Sequence['outputs.GetChainsChainChainConfigResult'],
                 chain_id: str,
                 chain_name: str,
                 create_time: str,
                 description: str,
                 id: str,
                 instance_id: str,
                 modified_time: str,
                 scope_id: str,
                 scope_type: str):
        """
        :param Sequence['GetChainsChainChainConfigArgs'] chain_configs: The configuration of delivery chain.
        :param str chain_id: The ID of delivery chain.
        :param str chain_name: The name of delivery chain.
        :param str create_time: The creation time of delivery chain.
        :param str description: The description of delivery chain.
        :param str id: The resource ID of the delivery chain. The value formats as `<instance_id>:<chain_id>`.
        :param str instance_id: The ID of CR Enterprise Edition instance.
        :param str modified_time: The modification time of delivery chain description.
        :param str scope_id: Delivery chain scope ID.
        :param str scope_type: Delivery chain scope type.
        """
        pulumi.set(__self__, "chain_configs", chain_configs)
        pulumi.set(__self__, "chain_id", chain_id)
        pulumi.set(__self__, "chain_name", chain_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "scope_id", scope_id)
        pulumi.set(__self__, "scope_type", scope_type)

    @property
    @pulumi.getter(name="chainConfigs")
    def chain_configs(self) -> Sequence['outputs.GetChainsChainChainConfigResult']:
        """
        The configuration of delivery chain.
        """
        return pulumi.get(self, "chain_configs")

    @property
    @pulumi.getter(name="chainId")
    def chain_id(self) -> str:
        """
        The ID of delivery chain.
        """
        return pulumi.get(self, "chain_id")

    @property
    @pulumi.getter(name="chainName")
    def chain_name(self) -> str:
        """
        The name of delivery chain.
        """
        return pulumi.get(self, "chain_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of delivery chain.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of delivery chain.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource ID of the delivery chain. The value formats as `<instance_id>:<chain_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of CR Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        The modification time of delivery chain description.
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter(name="scopeId")
    def scope_id(self) -> str:
        """
        Delivery chain scope ID.
        """
        return pulumi.get(self, "scope_id")

    @property
    @pulumi.getter(name="scopeType")
    def scope_type(self) -> str:
        """
        Delivery chain scope type.
        """
        return pulumi.get(self, "scope_type")


@pulumi.output_type
class GetChainsChainChainConfigResult(dict):
    def __init__(__self__, *,
                 nodes: Sequence['outputs.GetChainsChainChainConfigNodeResult'],
                 routers: Sequence['outputs.GetChainsChainChainConfigRouterResult']):
        """
        :param Sequence['GetChainsChainChainConfigNodeArgs'] nodes: Each node in the delivery chain.
        :param Sequence['GetChainsChainChainConfigRouterArgs'] routers: Execution sequence relationship between delivery chain nodes.
        """
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "routers", routers)

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetChainsChainChainConfigNodeResult']:
        """
        Each node in the delivery chain.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def routers(self) -> Sequence['outputs.GetChainsChainChainConfigRouterResult']:
        """
        Execution sequence relationship between delivery chain nodes.
        """
        return pulumi.get(self, "routers")


@pulumi.output_type
class GetChainsChainChainConfigNodeResult(dict):
    def __init__(__self__, *,
                 enable: bool,
                 node_configs: Sequence['outputs.GetChainsChainChainConfigNodeNodeConfigResult'],
                 node_name: str):
        """
        :param bool enable: Whether to enable the delivery chain node. Valid values: `true`, `false`.
        :param Sequence['GetChainsChainChainConfigNodeNodeConfigArgs'] node_configs: The configuration of delivery chain node.
        :param str node_name: The name of delivery chain node.
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "node_configs", node_configs)
        pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        Whether to enable the delivery chain node. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Sequence['outputs.GetChainsChainChainConfigNodeNodeConfigResult']:
        """
        The configuration of delivery chain node.
        """
        return pulumi.get(self, "node_configs")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> str:
        """
        The name of delivery chain node.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class GetChainsChainChainConfigNodeNodeConfigResult(dict):
    def __init__(__self__, *,
                 deny_policies: Sequence['outputs.GetChainsChainChainConfigNodeNodeConfigDenyPolicyResult']):
        """
        :param Sequence['GetChainsChainChainConfigNodeNodeConfigDenyPolicyArgs'] deny_policies: Blocking rules for scanning nodes in delivery chain nodes. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
        """
        pulumi.set(__self__, "deny_policies", deny_policies)

    @property
    @pulumi.getter(name="denyPolicies")
    def deny_policies(self) -> Sequence['outputs.GetChainsChainChainConfigNodeNodeConfigDenyPolicyResult']:
        """
        Blocking rules for scanning nodes in delivery chain nodes. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
        """
        return pulumi.get(self, "deny_policies")


@pulumi.output_type
class GetChainsChainChainConfigNodeNodeConfigDenyPolicyResult(dict):
    def __init__(__self__, *,
                 issue_count: str,
                 issue_level: str,
                 logic: str,
                 action: Optional[str] = None):
        """
        :param str issue_count: The count of scanning vulnerabilities that triggers blocking.
        :param str issue_level: The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
        :param str logic: The logic of trigger blocking. Valid values: `AND`, `OR`.
        :param str action: The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
        """
        pulumi.set(__self__, "issue_count", issue_count)
        pulumi.set(__self__, "issue_level", issue_level)
        pulumi.set(__self__, "logic", logic)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="issueCount")
    def issue_count(self) -> str:
        """
        The count of scanning vulnerabilities that triggers blocking.
        """
        return pulumi.get(self, "issue_count")

    @property
    @pulumi.getter(name="issueLevel")
    def issue_level(self) -> str:
        """
        The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
        """
        return pulumi.get(self, "issue_level")

    @property
    @pulumi.getter
    def logic(self) -> str:
        """
        The logic of trigger blocking. Valid values: `AND`, `OR`.
        """
        return pulumi.get(self, "logic")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class GetChainsChainChainConfigRouterResult(dict):
    def __init__(__self__, *,
                 froms: Sequence['outputs.GetChainsChainChainConfigRouterFromResult'],
                 tos: Sequence['outputs.GetChainsChainChainConfigRouterToResult']):
        """
        :param Sequence['GetChainsChainChainConfigRouterFromArgs'] froms: Source node.
        :param Sequence['GetChainsChainChainConfigRouterToArgs'] tos: Destination node.
        """
        pulumi.set(__self__, "froms", froms)
        pulumi.set(__self__, "tos", tos)

    @property
    @pulumi.getter
    def froms(self) -> Sequence['outputs.GetChainsChainChainConfigRouterFromResult']:
        """
        Source node.
        """
        return pulumi.get(self, "froms")

    @property
    @pulumi.getter
    def tos(self) -> Sequence['outputs.GetChainsChainChainConfigRouterToResult']:
        """
        Destination node.
        """
        return pulumi.get(self, "tos")


@pulumi.output_type
class GetChainsChainChainConfigRouterFromResult(dict):
    def __init__(__self__, *,
                 node_name: str):
        """
        :param str node_name: The name of delivery chain node.
        """
        pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> str:
        """
        The name of delivery chain node.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class GetChainsChainChainConfigRouterToResult(dict):
    def __init__(__self__, *,
                 node_name: str):
        """
        :param str node_name: The name of delivery chain node.
        """
        pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> str:
        """
        The name of delivery chain node.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class GetChartNamespacesNamespaceResult(dict):
    def __init__(__self__, *,
                 auto_create_repo: bool,
                 chart_namespace_id: str,
                 default_repo_type: str,
                 id: str,
                 instance_id: str,
                 namespace_name: str):
        """
        :param bool auto_create_repo: Indicates whether a repository is automatically created when an image is pushed to the namespace.
        :param str chart_namespace_id: The ID of the namespace.
        :param str default_repo_type: The default repository type. Valid values: `PUBLIC`,`PRIVATE`.
        :param str id: The ID of the Chart Namespace.
        :param str instance_id: The ID of the namespace.
        :param str namespace_name: The name of the namespace.
        """
        pulumi.set(__self__, "auto_create_repo", auto_create_repo)
        pulumi.set(__self__, "chart_namespace_id", chart_namespace_id)
        pulumi.set(__self__, "default_repo_type", default_repo_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "namespace_name", namespace_name)

    @property
    @pulumi.getter(name="autoCreateRepo")
    def auto_create_repo(self) -> bool:
        """
        Indicates whether a repository is automatically created when an image is pushed to the namespace.
        """
        return pulumi.get(self, "auto_create_repo")

    @property
    @pulumi.getter(name="chartNamespaceId")
    def chart_namespace_id(self) -> str:
        """
        The ID of the namespace.
        """
        return pulumi.get(self, "chart_namespace_id")

    @property
    @pulumi.getter(name="defaultRepoType")
    def default_repo_type(self) -> str:
        """
        The default repository type. Valid values: `PUBLIC`,`PRIVATE`.
        """
        return pulumi.get(self, "default_repo_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Chart Namespace.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the namespace.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> str:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "namespace_name")


@pulumi.output_type
class GetChartRepositoriesRepositoryResult(dict):
    def __init__(__self__, *,
                 chart_repository_id: str,
                 create_time: str,
                 id: str,
                 instance_id: str,
                 repo_name: str,
                 repo_namespace_name: str,
                 repo_type: str,
                 summary: str):
        """
        :param str chart_repository_id: The first ID of the resource.
        :param str create_time: The creation time of the resource.
        :param str id: The ID of the Chart Repository.
        :param str instance_id: The ID of the Container Registry instance.
        :param str repo_name: The name of the repository.
        :param str repo_namespace_name: The namespace to which the repository belongs.
        :param str repo_type: The type of the repository. Valid values: `PUBLIC`,`PRIVATE`.
        :param str summary: The summary about the repository.
        """
        pulumi.set(__self__, "chart_repository_id", chart_repository_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "repo_namespace_name", repo_namespace_name)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter(name="chartRepositoryId")
    def chart_repository_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "chart_repository_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Chart Repository.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the Container Registry instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        The name of the repository.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter(name="repoNamespaceName")
    def repo_namespace_name(self) -> str:
        """
        The namespace to which the repository belongs.
        """
        return pulumi.get(self, "repo_namespace_name")

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> str:
        """
        The type of the repository. Valid values: `PUBLIC`,`PRIVATE`.
        """
        return pulumi.get(self, "repo_type")

    @property
    @pulumi.getter
    def summary(self) -> str:
        """
        The summary about the repository.
        """
        return pulumi.get(self, "summary")


@pulumi.output_type
class GetEndpointAclPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 description: str,
                 endpoint_type: str,
                 entry: str,
                 id: str,
                 instance_id: str):
        """
        :param str description: The description of the entry.
        :param str endpoint_type: The type of endpoint.
        :param str entry: The IP segment that allowed to access.
        :param str id: The ID of the Endpoint Acl Policy.
        :param str instance_id: The ID of the CR Instance.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "entry", entry)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the entry.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The type of endpoint.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter
    def entry(self) -> str:
        """
        The IP segment that allowed to access.
        """
        return pulumi.get(self, "entry")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Endpoint Acl Policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the CR Instance.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class GetNamespacesNamespaceResult(dict):
    def __init__(__self__, *,
                 auto_create: bool,
                 default_visibility: str,
                 name: str):
        """
        :param bool auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param str default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param str name: Name of Container Registry namespace.
        """
        pulumi.set(__self__, "auto_create", auto_create)
        pulumi.set(__self__, "default_visibility", default_visibility)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> bool:
        """
        Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        """
        return pulumi.get(self, "auto_create")

    @property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> str:
        """
        `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        """
        return pulumi.get(self, "default_visibility")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of Container Registry namespace.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetReposRepoResult(dict):
    def __init__(__self__, *,
                 domain_list: 'outputs.GetReposRepoDomainListResult',
                 name: str,
                 namespace: str,
                 repo_type: str,
                 summary: str,
                 tags: Sequence['outputs.GetReposRepoTagResult']):
        """
        :param 'GetReposRepoDomainListArgs' domain_list: The repository domain list.
        :param str name: Name of container registry namespace.
        :param str namespace: Name of container registry namespace where the repositories are located in.
        :param str repo_type: `PUBLIC` or `PRIVATE`, repository's visibility.
        :param str summary: The repository general information.
        :param Sequence['GetReposRepoTagArgs'] tags: A list of image tags belong to this repository. Each contains several attributes, see `Block Tag`.
        """
        pulumi.set(__self__, "domain_list", domain_list)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "summary", summary)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="domainList")
    def domain_list(self) -> 'outputs.GetReposRepoDomainListResult':
        """
        The repository domain list.
        """
        return pulumi.get(self, "domain_list")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of container registry namespace.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Name of container registry namespace where the repositories are located in.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> str:
        """
        `PUBLIC` or `PRIVATE`, repository's visibility.
        """
        return pulumi.get(self, "repo_type")

    @property
    @pulumi.getter
    def summary(self) -> str:
        """
        The repository general information.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetReposRepoTagResult']:
        """
        A list of image tags belong to this repository. Each contains several attributes, see `Block Tag`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetReposRepoDomainListResult(dict):
    def __init__(__self__, *,
                 internal: str,
                 public: str,
                 vpc: str):
        """
        :param str internal: Domain of internal endpoint, only in some regions.
        :param str public: Domain of public endpoint.
        :param str vpc: Domain of vpc endpoint.
        """
        pulumi.set(__self__, "internal", internal)
        pulumi.set(__self__, "public", public)
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def internal(self) -> str:
        """
        Domain of internal endpoint, only in some regions.
        """
        return pulumi.get(self, "internal")

    @property
    @pulumi.getter
    def public(self) -> str:
        """
        Domain of public endpoint.
        """
        return pulumi.get(self, "public")

    @property
    @pulumi.getter
    def vpc(self) -> str:
        """
        Domain of vpc endpoint.
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class GetReposRepoTagResult(dict):
    def __init__(__self__, *,
                 digest: str,
                 image_create: int,
                 image_id: str,
                 image_size: int,
                 image_update: int,
                 status: str,
                 tag: str):
        """
        :param str digest: Digest of this image.
        :param int image_create: Create time of this image, unix time in nanoseconds.
        :param str image_id: Id of this image.
        :param int image_size: Status of this image, in bytes.
        :param int image_update: Last update time of this image, unix time in nanoseconds.
        :param str status: Status of this image.
        :param str tag: Tag of this image.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "image_create", image_create)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_size", image_size)
        pulumi.set(__self__, "image_update", image_update)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def digest(self) -> str:
        """
        Digest of this image.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="imageCreate")
    def image_create(self) -> int:
        """
        Create time of this image, unix time in nanoseconds.
        """
        return pulumi.get(self, "image_create")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        Id of this image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> int:
        """
        Status of this image, in bytes.
        """
        return pulumi.get(self, "image_size")

    @property
    @pulumi.getter(name="imageUpdate")
    def image_update(self) -> int:
        """
        Last update time of this image, unix time in nanoseconds.
        """
        return pulumi.get(self, "image_update")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of this image.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Tag of this image.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetVpcEndpointLinkedVpcsVpcEndpointLinkedVpcResult(dict):
    def __init__(__self__, *,
                 default_access: bool,
                 id: str,
                 instance_id: str,
                 ip: str,
                 module_name: str,
                 status: str,
                 vpc_id: str,
                 vswitch_id: str):
        """
        :param bool default_access: Indicates whether the default policy is used to access the instance.
        :param str id: The ID of the Vpc Endpoint Linked Vpc. It formats as `<instance_id>:<vpc_id>:<vswitch_id>:<module_name>`.
        :param str instance_id: The ID of the instance.
        :param str ip: IP address.
        :param str module_name: The name of the module that you want to access. Valid Values:
        :param str status: The status of the Vpc Endpoint Linked Vpc. Valid Values: `CREATING`, `RUNNING`.
        :param str vpc_id: The ID of the VPC.
        :param str vswitch_id: The ID of the vSwitch.
        """
        pulumi.set(__self__, "default_access", default_access)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "module_name", module_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="defaultAccess")
    def default_access(self) -> bool:
        """
        Indicates whether the default policy is used to access the instance.
        """
        return pulumi.get(self, "default_access")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Vpc Endpoint Linked Vpc. It formats as `<instance_id>:<vpc_id>:<vswitch_id>:<module_name>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        IP address.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> str:
        """
        The name of the module that you want to access. Valid Values:
        """
        return pulumi.get(self, "module_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Vpc Endpoint Linked Vpc. Valid Values: `CREATING`, `RUNNING`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")


