# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VpcEndpointLinkedVpcArgs', 'VpcEndpointLinkedVpc']

@pulumi.input_type
class VpcEndpointLinkedVpcArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 module_name: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 vswitch_id: pulumi.Input[str],
                 enable_create_dns_record_in_pvzt: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a VpcEndpointLinkedVpc resource.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] module_name: The name of the module that you want to access. Valid Values:
        :param pulumi.Input[str] vpc_id: The ID of the VPC.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[bool] enable_create_dns_record_in_pvzt: Specifies whether to automatically create an Alibaba Cloud DNS PrivateZone record. Valid Values:
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "module_name", module_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if enable_create_dns_record_in_pvzt is not None:
            pulumi.set(__self__, "enable_create_dns_record_in_pvzt", enable_create_dns_record_in_pvzt)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> pulumi.Input[str]:
        """
        The name of the module that you want to access. Valid Values:
        """
        return pulumi.get(self, "module_name")

    @module_name.setter
    def module_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "module_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="enableCreateDnsRecordInPvzt")
    def enable_create_dns_record_in_pvzt(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically create an Alibaba Cloud DNS PrivateZone record. Valid Values:
        """
        return pulumi.get(self, "enable_create_dns_record_in_pvzt")

    @enable_create_dns_record_in_pvzt.setter
    def enable_create_dns_record_in_pvzt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_create_dns_record_in_pvzt", value)


@pulumi.input_type
class _VpcEndpointLinkedVpcState:
    def __init__(__self__, *,
                 enable_create_dns_record_in_pvzt: Optional[pulumi.Input[bool]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 module_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VpcEndpointLinkedVpc resources.
        :param pulumi.Input[bool] enable_create_dns_record_in_pvzt: Specifies whether to automatically create an Alibaba Cloud DNS PrivateZone record. Valid Values:
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] module_name: The name of the module that you want to access. Valid Values:
        :param pulumi.Input[str] status: The status of the Vpc Endpoint Linked Vpc.
        :param pulumi.Input[str] vpc_id: The ID of the VPC.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch.
        """
        if enable_create_dns_record_in_pvzt is not None:
            pulumi.set(__self__, "enable_create_dns_record_in_pvzt", enable_create_dns_record_in_pvzt)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if module_name is not None:
            pulumi.set(__self__, "module_name", module_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="enableCreateDnsRecordInPvzt")
    def enable_create_dns_record_in_pvzt(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically create an Alibaba Cloud DNS PrivateZone record. Valid Values:
        """
        return pulumi.get(self, "enable_create_dns_record_in_pvzt")

    @enable_create_dns_record_in_pvzt.setter
    def enable_create_dns_record_in_pvzt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_create_dns_record_in_pvzt", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the module that you want to access. Valid Values:
        """
        return pulumi.get(self, "module_name")

    @module_name.setter
    def module_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "module_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Vpc Endpoint Linked Vpc.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)


class VpcEndpointLinkedVpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_create_dns_record_in_pvzt: Optional[pulumi.Input[bool]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 module_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a CR Vpc Endpoint Linked Vpc resource.

        For information about CR Vpc Endpoint Linked Vpc and how to use it, see [What is Vpc Endpoint Linked Vpc](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createinstancevpcendpointlinkedvpc).

        > **NOTE:** Available since v1.199.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("defaultRegistryEnterpriseInstance",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=name)
        default_vpc_endpoint_linked_vpc = alicloud.cr.VpcEndpointLinkedVpc("defaultVpcEndpointLinkedVpc",
            instance_id=default_registry_enterprise_instance.id,
            vpc_id=default_network.id,
            vswitch_id=default_switch.id,
            module_name="Registry",
            enable_create_dns_record_in_pvzt=True)
        ```

        ## Import

        CR Vpc Endpoint Linked Vpc can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cr/vpcEndpointLinkedVpc:VpcEndpointLinkedVpc example <instance_id>:<vpc_id>:<vswitch_id>:<module_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_create_dns_record_in_pvzt: Specifies whether to automatically create an Alibaba Cloud DNS PrivateZone record. Valid Values:
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] module_name: The name of the module that you want to access. Valid Values:
        :param pulumi.Input[str] vpc_id: The ID of the VPC.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcEndpointLinkedVpcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CR Vpc Endpoint Linked Vpc resource.

        For information about CR Vpc Endpoint Linked Vpc and how to use it, see [What is Vpc Endpoint Linked Vpc](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createinstancevpcendpointlinkedvpc).

        > **NOTE:** Available since v1.199.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("defaultRegistryEnterpriseInstance",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=name)
        default_vpc_endpoint_linked_vpc = alicloud.cr.VpcEndpointLinkedVpc("defaultVpcEndpointLinkedVpc",
            instance_id=default_registry_enterprise_instance.id,
            vpc_id=default_network.id,
            vswitch_id=default_switch.id,
            module_name="Registry",
            enable_create_dns_record_in_pvzt=True)
        ```

        ## Import

        CR Vpc Endpoint Linked Vpc can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cr/vpcEndpointLinkedVpc:VpcEndpointLinkedVpc example <instance_id>:<vpc_id>:<vswitch_id>:<module_name>
        ```

        :param str resource_name: The name of the resource.
        :param VpcEndpointLinkedVpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointLinkedVpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_create_dns_record_in_pvzt: Optional[pulumi.Input[bool]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 module_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointLinkedVpcArgs.__new__(VpcEndpointLinkedVpcArgs)

            __props__.__dict__["enable_create_dns_record_in_pvzt"] = enable_create_dns_record_in_pvzt
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if module_name is None and not opts.urn:
                raise TypeError("Missing required property 'module_name'")
            __props__.__dict__["module_name"] = module_name
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["status"] = None
        super(VpcEndpointLinkedVpc, __self__).__init__(
            'alicloud:cr/vpcEndpointLinkedVpc:VpcEndpointLinkedVpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_create_dns_record_in_pvzt: Optional[pulumi.Input[bool]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            module_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None) -> 'VpcEndpointLinkedVpc':
        """
        Get an existing VpcEndpointLinkedVpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_create_dns_record_in_pvzt: Specifies whether to automatically create an Alibaba Cloud DNS PrivateZone record. Valid Values:
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] module_name: The name of the module that you want to access. Valid Values:
        :param pulumi.Input[str] status: The status of the Vpc Endpoint Linked Vpc.
        :param pulumi.Input[str] vpc_id: The ID of the VPC.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcEndpointLinkedVpcState.__new__(_VpcEndpointLinkedVpcState)

        __props__.__dict__["enable_create_dns_record_in_pvzt"] = enable_create_dns_record_in_pvzt
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["module_name"] = module_name
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return VpcEndpointLinkedVpc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableCreateDnsRecordInPvzt")
    def enable_create_dns_record_in_pvzt(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to automatically create an Alibaba Cloud DNS PrivateZone record. Valid Values:
        """
        return pulumi.get(self, "enable_create_dns_record_in_pvzt")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> pulumi.Output[str]:
        """
        The name of the module that you want to access. Valid Values:
        """
        return pulumi.get(self, "module_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Vpc Endpoint Linked Vpc.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

