# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EdgeKubernetesArgs', 'EdgeKubernetes']

@pulumi.input_type
class EdgeKubernetesArgs:
    def __init__(__self__, *,
                 worker_instance_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 worker_number: pulumi.Input[int],
                 worker_vswitch_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kube_config: Optional[pulumi.Input[str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime: Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 worker_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]] = None,
                 worker_disk_category: Optional[pulumi.Input[str]] = None,
                 worker_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 worker_disk_size: Optional[pulumi.Input[int]] = None,
                 worker_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 worker_instance_charge_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EdgeKubernetes resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_instance_types: The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        :param pulumi.Input[int] worker_number: The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_vswitch_ids: The vswitches used by workers.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[str] availability_zone: The ID of availability zone.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
               
               *Removed params*
        :param pulumi.Input[str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard edge clusters.
               * ack.pro.small : Professional edge clusters.
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] force_update: Default false, when you want to change `vpc_id`, you have to set this field to true, then the cluster will be recreated.
        :param pulumi.Input[bool] install_cloud_monitor: Install cloud monitor agent on ECS. default: `true`.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] kube_config: The path of kube config, like `~/.kube/config`.
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
               ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Worker params*
        :param pulumi.Input['EdgeKubernetesLogConfigArgs'] log_config: A list of one element containing information about the associated log store. See `log_config` below.
        :param pulumi.Input[str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input['EdgeKubernetesRuntimeArgs'] runtime: The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). Detailed below.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work node.
        :param pulumi.Input[str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        :param pulumi.Input[str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]] worker_data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        :param pulumi.Input[str] worker_disk_category: The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        :param pulumi.Input[str] worker_disk_performance_level: Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[int] worker_disk_size: The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        :param pulumi.Input[str] worker_disk_snapshot_policy_id: Worker node system disk auto snapshot policy.
               
               *Computed params*
               
               You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        :param pulumi.Input[str] worker_instance_charge_type: Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        """
        pulumi.set(__self__, "worker_instance_types", worker_instance_types)
        pulumi.set(__self__, "worker_number", worker_number)
        pulumi.set(__self__, "worker_vswitch_ids", worker_vswitch_ids)
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if install_cloud_monitor is not None:
            pulumi.set(__self__, "install_cloud_monitor", install_cloud_monitor)
        if is_enterprise_security_group is not None:
            pulumi.set(__self__, "is_enterprise_security_group", is_enterprise_security_group)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kube_config is not None:
            warnings.warn("""Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource 'alicloud_cs_cluster_credential' manage your cluster's kube config.""", DeprecationWarning)
            pulumi.log.warn("""kube_config is deprecated: Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource 'alicloud_cs_cluster_credential' manage your cluster's kube config.""")
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if log_config is not None:
            warnings.warn("""Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""log_config is deprecated: Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""")
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if node_cidr_mask is not None:
            pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if proxy_mode is not None:
            pulumi.set(__self__, "proxy_mode", proxy_mode)
        if rds_instances is not None:
            pulumi.set(__self__, "rds_instances", rds_instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if slb_internet_enabled is not None:
            pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if worker_data_disks is not None:
            pulumi.set(__self__, "worker_data_disks", worker_data_disks)
        if worker_disk_category is not None:
            pulumi.set(__self__, "worker_disk_category", worker_disk_category)
        if worker_disk_performance_level is not None:
            pulumi.set(__self__, "worker_disk_performance_level", worker_disk_performance_level)
        if worker_disk_size is not None:
            pulumi.set(__self__, "worker_disk_size", worker_disk_size)
        if worker_disk_snapshot_policy_id is not None:
            pulumi.set(__self__, "worker_disk_snapshot_policy_id", worker_disk_snapshot_policy_id)
        if worker_instance_charge_type is not None:
            pulumi.set(__self__, "worker_instance_charge_type", worker_instance_charge_type)

    @property
    @pulumi.getter(name="workerInstanceTypes")
    def worker_instance_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        """
        return pulumi.get(self, "worker_instance_types")

    @worker_instance_types.setter
    def worker_instance_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "worker_instance_types", value)

    @property
    @pulumi.getter(name="workerNumber")
    def worker_number(self) -> pulumi.Input[int]:
        """
        The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        """
        return pulumi.get(self, "worker_number")

    @worker_number.setter
    def worker_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "worker_number", value)

    @property
    @pulumi.getter(name="workerVswitchIds")
    def worker_vswitch_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The vswitches used by workers.
        """
        return pulumi.get(self, "worker_vswitch_ids")

    @worker_vswitch_ids.setter
    def worker_vswitch_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "worker_vswitch_ids", value)

    @property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]]:
        """
        The addon you want to install in cluster. See `addons` below.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="clusterCaCert")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Standard edge clusters.
        * ack.pro.small : Professional edge clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_spec", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Default false, when you want to change `vpc_id`, you have to set this field to true, then the cluster will be recreated.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_update", value)

    @property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> Optional[pulumi.Input[bool]]:
        """
        Install cloud monitor agent on ECS. default: `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @install_cloud_monitor.setter
    def install_cloud_monitor(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_cloud_monitor", value)

    @property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @is_enterprise_security_group.setter
    def is_enterprise_security_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enterprise_security_group", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> Optional[pulumi.Input[str]]:
        """
        The path of kube config, like `~/.kube/config`.
        """
        warnings.warn("""Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource 'alicloud_cs_cluster_credential' manage your cluster's kube config.""", DeprecationWarning)
        pulumi.log.warn("""kube_config is deprecated: Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource 'alicloud_cs_cluster_credential' manage your cluster's kube config.""")

        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kube_config", value)

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.

        *Worker params*
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']]:
        """
        A list of one element containing information about the associated log store. See `log_config` below.
        """
        warnings.warn("""Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""", DeprecationWarning)
        pulumi.log.warn("""log_config is deprecated: Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""")

        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> Optional[pulumi.Input[int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @node_cidr_mask.setter
    def node_cidr_mask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_cidr_mask", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_cidr", value)

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @proxy_mode.setter
    def proxy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_mode", value)

    @property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @rds_instances.setter
    def rds_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rds_instances", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retain_resources", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']]:
        """
        The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). Detailed below.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @slb_internet_enabled.setter
    def slb_internet_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "slb_internet_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work node.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="workerDataDisks")
    def worker_data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]]:
        """
        The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        """
        return pulumi.get(self, "worker_data_disks")

    @worker_data_disks.setter
    def worker_data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]]):
        pulumi.set(self, "worker_data_disks", value)

    @property
    @pulumi.getter(name="workerDiskCategory")
    def worker_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "worker_disk_category")

    @worker_disk_category.setter
    def worker_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_disk_category", value)

    @property
    @pulumi.getter(name="workerDiskPerformanceLevel")
    def worker_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "worker_disk_performance_level")

    @worker_disk_performance_level.setter
    def worker_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_disk_performance_level", value)

    @property
    @pulumi.getter(name="workerDiskSize")
    def worker_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        """
        return pulumi.get(self, "worker_disk_size")

    @worker_disk_size.setter
    def worker_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "worker_disk_size", value)

    @property
    @pulumi.getter(name="workerDiskSnapshotPolicyId")
    def worker_disk_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Worker node system disk auto snapshot policy.

        *Computed params*

        You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        """
        return pulumi.get(self, "worker_disk_snapshot_policy_id")

    @worker_disk_snapshot_policy_id.setter
    def worker_disk_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_disk_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="workerInstanceChargeType")
    def worker_instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        """
        return pulumi.get(self, "worker_instance_charge_type")

    @worker_instance_charge_type.setter
    def worker_instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_instance_charge_type", value)


@pulumi.input_type
class _EdgeKubernetesState:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 certificate_authority: Optional[pulumi.Input['EdgeKubernetesCertificateAuthorityArgs']] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 connections: Optional[pulumi.Input['EdgeKubernetesConnectionsArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kube_config: Optional[pulumi.Input[str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime: Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_internet: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 slb_intranet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 worker_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]] = None,
                 worker_disk_category: Optional[pulumi.Input[str]] = None,
                 worker_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 worker_disk_size: Optional[pulumi.Input[int]] = None,
                 worker_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 worker_instance_charge_type: Optional[pulumi.Input[str]] = None,
                 worker_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 worker_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerNodeArgs']]]] = None,
                 worker_number: Optional[pulumi.Input[int]] = None,
                 worker_ram_role_name: Optional[pulumi.Input[str]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering EdgeKubernetes resources.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[str] availability_zone: The ID of availability zone.
        :param pulumi.Input['EdgeKubernetesCertificateAuthorityArgs'] certificate_authority: Nested attribute containing certificate authority data for your cluster.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
               
               *Removed params*
        :param pulumi.Input[str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard edge clusters.
               * ack.pro.small : Professional edge clusters.
        :param pulumi.Input['EdgeKubernetesConnectionsArgs'] connections: Map of kubernetes cluster connection information.
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] force_update: Default false, when you want to change `vpc_id`, you have to set this field to true, then the cluster will be recreated.
        :param pulumi.Input[bool] install_cloud_monitor: Install cloud monitor agent on ECS. default: `true`.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] kube_config: The path of kube config, like `~/.kube/config`.
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
               ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Worker params*
        :param pulumi.Input['EdgeKubernetesLogConfigArgs'] log_config: A list of one element containing information about the associated log store. See `log_config` below.
        :param pulumi.Input[str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[str] nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input['EdgeKubernetesRuntimeArgs'] runtime: The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). Detailed below.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[str] slb_internet: The public ip of load balancer.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
        :param pulumi.Input[str] slb_intranet: The ID of private load balancer where the current cluster master node is located.
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work node.
        :param pulumi.Input[str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        :param pulumi.Input[str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        :param pulumi.Input[str] vpc_id: The ID of VPC where the current cluster is located.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]] worker_data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        :param pulumi.Input[str] worker_disk_category: The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        :param pulumi.Input[str] worker_disk_performance_level: Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[int] worker_disk_size: The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        :param pulumi.Input[str] worker_disk_snapshot_policy_id: Worker node system disk auto snapshot policy.
               
               *Computed params*
               
               You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        :param pulumi.Input[str] worker_instance_charge_type: Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_instance_types: The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerNodeArgs']]] worker_nodes: List of cluster worker nodes.
        :param pulumi.Input[int] worker_number: The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        :param pulumi.Input[str] worker_ram_role_name: The RamRole Name attached to worker node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_vswitch_ids: The vswitches used by workers.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if install_cloud_monitor is not None:
            pulumi.set(__self__, "install_cloud_monitor", install_cloud_monitor)
        if is_enterprise_security_group is not None:
            pulumi.set(__self__, "is_enterprise_security_group", is_enterprise_security_group)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kube_config is not None:
            warnings.warn("""Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource 'alicloud_cs_cluster_credential' manage your cluster's kube config.""", DeprecationWarning)
            pulumi.log.warn("""kube_config is deprecated: Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource 'alicloud_cs_cluster_credential' manage your cluster's kube config.""")
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if log_config is not None:
            warnings.warn("""Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""log_config is deprecated: Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""")
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if node_cidr_mask is not None:
            pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if proxy_mode is not None:
            pulumi.set(__self__, "proxy_mode", proxy_mode)
        if rds_instances is not None:
            pulumi.set(__self__, "rds_instances", rds_instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if slb_internet is not None:
            pulumi.set(__self__, "slb_internet", slb_internet)
        if slb_internet_enabled is not None:
            pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        if slb_intranet is not None:
            pulumi.set(__self__, "slb_intranet", slb_intranet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if worker_data_disks is not None:
            pulumi.set(__self__, "worker_data_disks", worker_data_disks)
        if worker_disk_category is not None:
            pulumi.set(__self__, "worker_disk_category", worker_disk_category)
        if worker_disk_performance_level is not None:
            pulumi.set(__self__, "worker_disk_performance_level", worker_disk_performance_level)
        if worker_disk_size is not None:
            pulumi.set(__self__, "worker_disk_size", worker_disk_size)
        if worker_disk_snapshot_policy_id is not None:
            pulumi.set(__self__, "worker_disk_snapshot_policy_id", worker_disk_snapshot_policy_id)
        if worker_instance_charge_type is not None:
            pulumi.set(__self__, "worker_instance_charge_type", worker_instance_charge_type)
        if worker_instance_types is not None:
            pulumi.set(__self__, "worker_instance_types", worker_instance_types)
        if worker_nodes is not None:
            pulumi.set(__self__, "worker_nodes", worker_nodes)
        if worker_number is not None:
            pulumi.set(__self__, "worker_number", worker_number)
        if worker_ram_role_name is not None:
            pulumi.set(__self__, "worker_ram_role_name", worker_ram_role_name)
        if worker_vswitch_ids is not None:
            pulumi.set(__self__, "worker_vswitch_ids", worker_vswitch_ids)

    @property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]]:
        """
        The addon you want to install in cluster. See `addons` below.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input['EdgeKubernetesCertificateAuthorityArgs']]:
        """
        Nested attribute containing certificate authority data for your cluster.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input['EdgeKubernetesCertificateAuthorityArgs']]):
        pulumi.set(self, "certificate_authority", value)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="clusterCaCert")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Standard edge clusters.
        * ack.pro.small : Professional edge clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_spec", value)

    @property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input['EdgeKubernetesConnectionsArgs']]:
        """
        Map of kubernetes cluster connection information.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input['EdgeKubernetesConnectionsArgs']]):
        pulumi.set(self, "connections", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Default false, when you want to change `vpc_id`, you have to set this field to true, then the cluster will be recreated.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_update", value)

    @property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> Optional[pulumi.Input[bool]]:
        """
        Install cloud monitor agent on ECS. default: `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @install_cloud_monitor.setter
    def install_cloud_monitor(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_cloud_monitor", value)

    @property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @is_enterprise_security_group.setter
    def is_enterprise_security_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enterprise_security_group", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> Optional[pulumi.Input[str]]:
        """
        The path of kube config, like `~/.kube/config`.
        """
        warnings.warn("""Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource 'alicloud_cs_cluster_credential' manage your cluster's kube config.""", DeprecationWarning)
        pulumi.log.warn("""kube_config is deprecated: Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource 'alicloud_cs_cluster_credential' manage your cluster's kube config.""")

        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kube_config", value)

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.

        *Worker params*
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']]:
        """
        A list of one element containing information about the associated log store. See `log_config` below.
        """
        warnings.warn("""Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""", DeprecationWarning)
        pulumi.log.warn("""log_config is deprecated: Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""")

        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> Optional[pulumi.Input[int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @node_cidr_mask.setter
    def node_cidr_mask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_cidr_mask", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_cidr", value)

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @proxy_mode.setter
    def proxy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_mode", value)

    @property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @rds_instances.setter
    def rds_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rds_instances", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retain_resources", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']]:
        """
        The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). Detailed below.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="slbInternet")
    def slb_internet(self) -> Optional[pulumi.Input[str]]:
        """
        The public ip of load balancer.
        """
        return pulumi.get(self, "slb_internet")

    @slb_internet.setter
    def slb_internet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slb_internet", value)

    @property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @slb_internet_enabled.setter
    def slb_internet_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "slb_internet_enabled", value)

    @property
    @pulumi.getter(name="slbIntranet")
    def slb_intranet(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of private load balancer where the current cluster master node is located.
        """
        return pulumi.get(self, "slb_intranet")

    @slb_intranet.setter
    def slb_intranet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slb_intranet", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work node.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="workerDataDisks")
    def worker_data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]]:
        """
        The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        """
        return pulumi.get(self, "worker_data_disks")

    @worker_data_disks.setter
    def worker_data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]]):
        pulumi.set(self, "worker_data_disks", value)

    @property
    @pulumi.getter(name="workerDiskCategory")
    def worker_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "worker_disk_category")

    @worker_disk_category.setter
    def worker_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_disk_category", value)

    @property
    @pulumi.getter(name="workerDiskPerformanceLevel")
    def worker_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "worker_disk_performance_level")

    @worker_disk_performance_level.setter
    def worker_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_disk_performance_level", value)

    @property
    @pulumi.getter(name="workerDiskSize")
    def worker_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        """
        return pulumi.get(self, "worker_disk_size")

    @worker_disk_size.setter
    def worker_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "worker_disk_size", value)

    @property
    @pulumi.getter(name="workerDiskSnapshotPolicyId")
    def worker_disk_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Worker node system disk auto snapshot policy.

        *Computed params*

        You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        """
        return pulumi.get(self, "worker_disk_snapshot_policy_id")

    @worker_disk_snapshot_policy_id.setter
    def worker_disk_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_disk_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="workerInstanceChargeType")
    def worker_instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        """
        return pulumi.get(self, "worker_instance_charge_type")

    @worker_instance_charge_type.setter
    def worker_instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_instance_charge_type", value)

    @property
    @pulumi.getter(name="workerInstanceTypes")
    def worker_instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        """
        return pulumi.get(self, "worker_instance_types")

    @worker_instance_types.setter
    def worker_instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "worker_instance_types", value)

    @property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerNodeArgs']]]]:
        """
        List of cluster worker nodes.
        """
        return pulumi.get(self, "worker_nodes")

    @worker_nodes.setter
    def worker_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerNodeArgs']]]]):
        pulumi.set(self, "worker_nodes", value)

    @property
    @pulumi.getter(name="workerNumber")
    def worker_number(self) -> Optional[pulumi.Input[int]]:
        """
        The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        """
        return pulumi.get(self, "worker_number")

    @worker_number.setter
    def worker_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "worker_number", value)

    @property
    @pulumi.getter(name="workerRamRoleName")
    def worker_ram_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The RamRole Name attached to worker node.
        """
        return pulumi.get(self, "worker_ram_role_name")

    @worker_ram_role_name.setter
    def worker_ram_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_ram_role_name", value)

    @property
    @pulumi.getter(name="workerVswitchIds")
    def worker_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The vswitches used by workers.
        """
        return pulumi.get(self, "worker_vswitch_ids")

    @worker_vswitch_ids.setter
    def worker_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "worker_vswitch_ids", value)


class EdgeKubernetes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesAddonArgs']]]]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kube_config: Optional[pulumi.Input[str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['EdgeKubernetesLogConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime: Optional[pulumi.Input[pulumi.InputType['EdgeKubernetesRuntimeArgs']]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 worker_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesWorkerDataDiskArgs']]]]] = None,
                 worker_disk_category: Optional[pulumi.Input[str]] = None,
                 worker_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 worker_disk_size: Optional[pulumi.Input[int]] = None,
                 worker_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 worker_instance_charge_type: Optional[pulumi.Input[str]] = None,
                 worker_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 worker_number: Optional[pulumi.Input[int]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource will help you to manage a Edge Kubernetes Cluster in Alibaba Cloud Kubernetes Service, see [What is edge kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-an-ack-edge-cluster).

        > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.

        > **NOTE:** The provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** The provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.

        > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** Available since v1.103.0.

        > **NOTE:** From version 1.185.0+, support new fields `cluster_spec`, `runtime` and `load_balancer_spec`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Master")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_edge_kubernetes = alicloud.cs.EdgeKubernetes("defaultEdgeKubernetes",
            worker_vswitch_ids=[default_switch.id],
            worker_instance_types=[default_instance_types.instance_types[0].id],
            version="1.20.11-aliyunedge.1",
            worker_number=1,
            password="Test12345",
            pod_cidr="10.99.0.0/16",
            service_cidr="172.16.0.0/16",
            worker_instance_charge_type="PostPaid",
            new_nat_gateway=True,
            node_cidr_mask=24,
            install_cloud_monitor=True,
            slb_internet_enabled=True,
            is_enterprise_security_group=True,
            worker_data_disks=[alicloud.cs.EdgeKubernetesWorkerDataDiskArgs(
                category="cloud_ssd",
                size="200",
                encrypted="false",
            )])
        ```

        You could create a professional kubernetes edge cluster now.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Master")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_edge_kubernetes = alicloud.cs.EdgeKubernetes("defaultEdgeKubernetes",
            worker_vswitch_ids=[default_switch.id],
            worker_instance_types=[default_instance_types.instance_types[0].id],
            version="1.20.11-aliyunedge.1",
            cluster_spec="ack.pro.small",
            worker_number=1,
            password="Test12345",
            pod_cidr="10.99.0.0/16",
            service_cidr="172.16.0.0/16",
            worker_instance_charge_type="PostPaid",
            new_nat_gateway=True,
            node_cidr_mask=24,
            load_balancer_spec="slb.s2.small",
            install_cloud_monitor=True,
            slb_internet_enabled=True,
            is_enterprise_security_group=True,
            addons=[alicloud.cs.EdgeKubernetesAddonArgs(
                name="alibaba-log-controller",
                config="{\\"IngressDashboardEnabled\\":\\"false\\"}",
            )],
            worker_data_disks=[alicloud.cs.EdgeKubernetesWorkerDataDiskArgs(
                category="cloud_ssd",
                size="200",
                encrypted="false",
            )],
            runtime=alicloud.cs.EdgeKubernetesRuntimeArgs(
                name="containerd",
                version="1.5.10",
            ))
        ```

        ## Import

        Kubernetes edge cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
         $ pulumi import alicloud:cs/edgeKubernetes:EdgeKubernetes main cluster-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesAddonArgs']]]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[str] availability_zone: The ID of availability zone.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
               
               *Removed params*
        :param pulumi.Input[str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard edge clusters.
               * ack.pro.small : Professional edge clusters.
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] force_update: Default false, when you want to change `vpc_id`, you have to set this field to true, then the cluster will be recreated.
        :param pulumi.Input[bool] install_cloud_monitor: Install cloud monitor agent on ECS. default: `true`.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] kube_config: The path of kube config, like `~/.kube/config`.
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
               ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Worker params*
        :param pulumi.Input[pulumi.InputType['EdgeKubernetesLogConfigArgs']] log_config: A list of one element containing information about the associated log store. See `log_config` below.
        :param pulumi.Input[str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[pulumi.InputType['EdgeKubernetesRuntimeArgs']] runtime: The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). Detailed below.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work node.
        :param pulumi.Input[str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        :param pulumi.Input[str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesWorkerDataDiskArgs']]]] worker_data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        :param pulumi.Input[str] worker_disk_category: The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        :param pulumi.Input[str] worker_disk_performance_level: Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[int] worker_disk_size: The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        :param pulumi.Input[str] worker_disk_snapshot_policy_id: Worker node system disk auto snapshot policy.
               
               *Computed params*
               
               You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        :param pulumi.Input[str] worker_instance_charge_type: Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_instance_types: The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        :param pulumi.Input[int] worker_number: The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_vswitch_ids: The vswitches used by workers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeKubernetesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource will help you to manage a Edge Kubernetes Cluster in Alibaba Cloud Kubernetes Service, see [What is edge kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-an-ack-edge-cluster).

        > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.

        > **NOTE:** The provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** The provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.

        > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** Available since v1.103.0.

        > **NOTE:** From version 1.185.0+, support new fields `cluster_spec`, `runtime` and `load_balancer_spec`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Master")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_edge_kubernetes = alicloud.cs.EdgeKubernetes("defaultEdgeKubernetes",
            worker_vswitch_ids=[default_switch.id],
            worker_instance_types=[default_instance_types.instance_types[0].id],
            version="1.20.11-aliyunedge.1",
            worker_number=1,
            password="Test12345",
            pod_cidr="10.99.0.0/16",
            service_cidr="172.16.0.0/16",
            worker_instance_charge_type="PostPaid",
            new_nat_gateway=True,
            node_cidr_mask=24,
            install_cloud_monitor=True,
            slb_internet_enabled=True,
            is_enterprise_security_group=True,
            worker_data_disks=[alicloud.cs.EdgeKubernetesWorkerDataDiskArgs(
                category="cloud_ssd",
                size="200",
                encrypted="false",
            )])
        ```

        You could create a professional kubernetes edge cluster now.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Master")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_edge_kubernetes = alicloud.cs.EdgeKubernetes("defaultEdgeKubernetes",
            worker_vswitch_ids=[default_switch.id],
            worker_instance_types=[default_instance_types.instance_types[0].id],
            version="1.20.11-aliyunedge.1",
            cluster_spec="ack.pro.small",
            worker_number=1,
            password="Test12345",
            pod_cidr="10.99.0.0/16",
            service_cidr="172.16.0.0/16",
            worker_instance_charge_type="PostPaid",
            new_nat_gateway=True,
            node_cidr_mask=24,
            load_balancer_spec="slb.s2.small",
            install_cloud_monitor=True,
            slb_internet_enabled=True,
            is_enterprise_security_group=True,
            addons=[alicloud.cs.EdgeKubernetesAddonArgs(
                name="alibaba-log-controller",
                config="{\\"IngressDashboardEnabled\\":\\"false\\"}",
            )],
            worker_data_disks=[alicloud.cs.EdgeKubernetesWorkerDataDiskArgs(
                category="cloud_ssd",
                size="200",
                encrypted="false",
            )],
            runtime=alicloud.cs.EdgeKubernetesRuntimeArgs(
                name="containerd",
                version="1.5.10",
            ))
        ```

        ## Import

        Kubernetes edge cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
         $ pulumi import alicloud:cs/edgeKubernetes:EdgeKubernetes main cluster-id
        ```

        :param str resource_name: The name of the resource.
        :param EdgeKubernetesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeKubernetesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesAddonArgs']]]]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kube_config: Optional[pulumi.Input[str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['EdgeKubernetesLogConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime: Optional[pulumi.Input[pulumi.InputType['EdgeKubernetesRuntimeArgs']]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 worker_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesWorkerDataDiskArgs']]]]] = None,
                 worker_disk_category: Optional[pulumi.Input[str]] = None,
                 worker_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 worker_disk_size: Optional[pulumi.Input[int]] = None,
                 worker_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 worker_instance_charge_type: Optional[pulumi.Input[str]] = None,
                 worker_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 worker_number: Optional[pulumi.Input[int]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeKubernetesArgs.__new__(EdgeKubernetesArgs)

            __props__.__dict__["addons"] = addons
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["client_cert"] = client_cert
            __props__.__dict__["client_key"] = client_key
            __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
            __props__.__dict__["cluster_spec"] = cluster_spec
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["force_update"] = force_update
            __props__.__dict__["install_cloud_monitor"] = install_cloud_monitor
            __props__.__dict__["is_enterprise_security_group"] = is_enterprise_security_group
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["kube_config"] = kube_config
            __props__.__dict__["load_balancer_spec"] = load_balancer_spec
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["new_nat_gateway"] = new_nat_gateway
            __props__.__dict__["node_cidr_mask"] = node_cidr_mask
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["pod_cidr"] = pod_cidr
            __props__.__dict__["proxy_mode"] = proxy_mode
            __props__.__dict__["rds_instances"] = rds_instances
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["retain_resources"] = retain_resources
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["service_cidr"] = service_cidr
            __props__.__dict__["slb_internet_enabled"] = slb_internet_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["version"] = version
            __props__.__dict__["worker_data_disks"] = worker_data_disks
            __props__.__dict__["worker_disk_category"] = worker_disk_category
            __props__.__dict__["worker_disk_performance_level"] = worker_disk_performance_level
            __props__.__dict__["worker_disk_size"] = worker_disk_size
            __props__.__dict__["worker_disk_snapshot_policy_id"] = worker_disk_snapshot_policy_id
            __props__.__dict__["worker_instance_charge_type"] = worker_instance_charge_type
            if worker_instance_types is None and not opts.urn:
                raise TypeError("Missing required property 'worker_instance_types'")
            __props__.__dict__["worker_instance_types"] = worker_instance_types
            if worker_number is None and not opts.urn:
                raise TypeError("Missing required property 'worker_number'")
            __props__.__dict__["worker_number"] = worker_number
            if worker_vswitch_ids is None and not opts.urn:
                raise TypeError("Missing required property 'worker_vswitch_ids'")
            __props__.__dict__["worker_vswitch_ids"] = worker_vswitch_ids
            __props__.__dict__["certificate_authority"] = None
            __props__.__dict__["connections"] = None
            __props__.__dict__["nat_gateway_id"] = None
            __props__.__dict__["slb_internet"] = None
            __props__.__dict__["slb_intranet"] = None
            __props__.__dict__["vpc_id"] = None
            __props__.__dict__["worker_nodes"] = None
            __props__.__dict__["worker_ram_role_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EdgeKubernetes, __self__).__init__(
            'alicloud:cs/edgeKubernetes:EdgeKubernetes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addons: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesAddonArgs']]]]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            certificate_authority: Optional[pulumi.Input[pulumi.InputType['EdgeKubernetesCertificateAuthorityArgs']]] = None,
            client_cert: Optional[pulumi.Input[str]] = None,
            client_key: Optional[pulumi.Input[str]] = None,
            cluster_ca_cert: Optional[pulumi.Input[str]] = None,
            cluster_spec: Optional[pulumi.Input[str]] = None,
            connections: Optional[pulumi.Input[pulumi.InputType['EdgeKubernetesConnectionsArgs']]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            force_update: Optional[pulumi.Input[bool]] = None,
            install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
            is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
            key_name: Optional[pulumi.Input[str]] = None,
            kube_config: Optional[pulumi.Input[str]] = None,
            load_balancer_spec: Optional[pulumi.Input[str]] = None,
            log_config: Optional[pulumi.Input[pulumi.InputType['EdgeKubernetesLogConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            nat_gateway_id: Optional[pulumi.Input[str]] = None,
            new_nat_gateway: Optional[pulumi.Input[bool]] = None,
            node_cidr_mask: Optional[pulumi.Input[int]] = None,
            password: Optional[pulumi.Input[str]] = None,
            pod_cidr: Optional[pulumi.Input[str]] = None,
            proxy_mode: Optional[pulumi.Input[str]] = None,
            rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            runtime: Optional[pulumi.Input[pulumi.InputType['EdgeKubernetesRuntimeArgs']]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            service_cidr: Optional[pulumi.Input[str]] = None,
            slb_internet: Optional[pulumi.Input[str]] = None,
            slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
            slb_intranet: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            worker_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesWorkerDataDiskArgs']]]]] = None,
            worker_disk_category: Optional[pulumi.Input[str]] = None,
            worker_disk_performance_level: Optional[pulumi.Input[str]] = None,
            worker_disk_size: Optional[pulumi.Input[int]] = None,
            worker_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
            worker_instance_charge_type: Optional[pulumi.Input[str]] = None,
            worker_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            worker_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesWorkerNodeArgs']]]]] = None,
            worker_number: Optional[pulumi.Input[int]] = None,
            worker_ram_role_name: Optional[pulumi.Input[str]] = None,
            worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'EdgeKubernetes':
        """
        Get an existing EdgeKubernetes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesAddonArgs']]]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[str] availability_zone: The ID of availability zone.
        :param pulumi.Input[pulumi.InputType['EdgeKubernetesCertificateAuthorityArgs']] certificate_authority: Nested attribute containing certificate authority data for your cluster.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
               
               *Removed params*
        :param pulumi.Input[str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard edge clusters.
               * ack.pro.small : Professional edge clusters.
        :param pulumi.Input[pulumi.InputType['EdgeKubernetesConnectionsArgs']] connections: Map of kubernetes cluster connection information.
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] force_update: Default false, when you want to change `vpc_id`, you have to set this field to true, then the cluster will be recreated.
        :param pulumi.Input[bool] install_cloud_monitor: Install cloud monitor agent on ECS. default: `true`.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] kube_config: The path of kube config, like `~/.kube/config`.
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
               ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Worker params*
        :param pulumi.Input[pulumi.InputType['EdgeKubernetesLogConfigArgs']] log_config: A list of one element containing information about the associated log store. See `log_config` below.
        :param pulumi.Input[str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[str] nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[pulumi.InputType['EdgeKubernetesRuntimeArgs']] runtime: The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). Detailed below.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[str] slb_internet: The public ip of load balancer.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
        :param pulumi.Input[str] slb_intranet: The ID of private load balancer where the current cluster master node is located.
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work node.
        :param pulumi.Input[str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        :param pulumi.Input[str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        :param pulumi.Input[str] vpc_id: The ID of VPC where the current cluster is located.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesWorkerDataDiskArgs']]]] worker_data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        :param pulumi.Input[str] worker_disk_category: The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        :param pulumi.Input[str] worker_disk_performance_level: Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[int] worker_disk_size: The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        :param pulumi.Input[str] worker_disk_snapshot_policy_id: Worker node system disk auto snapshot policy.
               
               *Computed params*
               
               You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        :param pulumi.Input[str] worker_instance_charge_type: Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_instance_types: The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKubernetesWorkerNodeArgs']]]] worker_nodes: List of cluster worker nodes.
        :param pulumi.Input[int] worker_number: The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        :param pulumi.Input[str] worker_ram_role_name: The RamRole Name attached to worker node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_vswitch_ids: The vswitches used by workers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeKubernetesState.__new__(_EdgeKubernetesState)

        __props__.__dict__["addons"] = addons
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["client_cert"] = client_cert
        __props__.__dict__["client_key"] = client_key
        __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
        __props__.__dict__["cluster_spec"] = cluster_spec
        __props__.__dict__["connections"] = connections
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["force_update"] = force_update
        __props__.__dict__["install_cloud_monitor"] = install_cloud_monitor
        __props__.__dict__["is_enterprise_security_group"] = is_enterprise_security_group
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["kube_config"] = kube_config
        __props__.__dict__["load_balancer_spec"] = load_balancer_spec
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["new_nat_gateway"] = new_nat_gateway
        __props__.__dict__["node_cidr_mask"] = node_cidr_mask
        __props__.__dict__["password"] = password
        __props__.__dict__["pod_cidr"] = pod_cidr
        __props__.__dict__["proxy_mode"] = proxy_mode
        __props__.__dict__["rds_instances"] = rds_instances
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["retain_resources"] = retain_resources
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["service_cidr"] = service_cidr
        __props__.__dict__["slb_internet"] = slb_internet
        __props__.__dict__["slb_internet_enabled"] = slb_internet_enabled
        __props__.__dict__["slb_intranet"] = slb_intranet
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["worker_data_disks"] = worker_data_disks
        __props__.__dict__["worker_disk_category"] = worker_disk_category
        __props__.__dict__["worker_disk_performance_level"] = worker_disk_performance_level
        __props__.__dict__["worker_disk_size"] = worker_disk_size
        __props__.__dict__["worker_disk_snapshot_policy_id"] = worker_disk_snapshot_policy_id
        __props__.__dict__["worker_instance_charge_type"] = worker_instance_charge_type
        __props__.__dict__["worker_instance_types"] = worker_instance_types
        __props__.__dict__["worker_nodes"] = worker_nodes
        __props__.__dict__["worker_number"] = worker_number
        __props__.__dict__["worker_ram_role_name"] = worker_ram_role_name
        __props__.__dict__["worker_vswitch_ids"] = worker_vswitch_ids
        return EdgeKubernetes(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addons(self) -> pulumi.Output[Optional[Sequence['outputs.EdgeKubernetesAddon']]]:
        """
        The addon you want to install in cluster. See `addons` below.
        """
        return pulumi.get(self, "addons")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Output['outputs.EdgeKubernetesCertificateAuthority']:
        """
        Nested attribute containing certificate authority data for your cluster.
        """
        return pulumi.get(self, "certificate_authority")

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> pulumi.Output[Optional[str]]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> pulumi.Output[Optional[str]]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCert")
    def cluster_ca_cert(self) -> pulumi.Output[Optional[str]]:
        """
        The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> pulumi.Output[str]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Standard edge clusters.
        * ack.pro.small : Professional edge clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @property
    @pulumi.getter
    def connections(self) -> pulumi.Output['outputs.EdgeKubernetesConnections']:
        """
        Map of kubernetes cluster connection information.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> pulumi.Output[Optional[bool]]:
        """
        Default false, when you want to change `vpc_id`, you have to set this field to true, then the cluster will be recreated.
        """
        return pulumi.get(self, "force_update")

    @property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> pulumi.Output[Optional[bool]]:
        """
        Install cloud monitor agent on ECS. default: `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> pulumi.Output[bool]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> pulumi.Output[Optional[str]]:
        """
        The path of kube config, like `~/.kube/config`.
        """
        warnings.warn("""Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource 'alicloud_cs_cluster_credential' manage your cluster's kube config.""", DeprecationWarning)
        pulumi.log.warn("""kube_config is deprecated: Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource 'alicloud_cs_cluster_credential' manage your cluster's kube config.""")

        return pulumi.get(self, "kube_config")

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> pulumi.Output[str]:
        """
        The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.

        *Worker params*
        """
        return pulumi.get(self, "load_balancer_spec")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.EdgeKubernetesLogConfig']]:
        """
        A list of one element containing information about the associated log store. See `log_config` below.
        """
        warnings.warn("""Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""", DeprecationWarning)
        pulumi.log.warn("""log_config is deprecated: Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""")

        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[str]:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        """
        return pulumi.get(self, "new_nat_gateway")

    @property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> pulumi.Output[Optional[int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "retain_resources")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[Optional['outputs.EdgeKubernetesRuntime']]:
        """
        The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). Detailed below.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @property
    @pulumi.getter(name="slbInternet")
    def slb_internet(self) -> pulumi.Output[str]:
        """
        The public ip of load balancer.
        """
        return pulumi.get(self, "slb_internet")

    @property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @property
    @pulumi.getter(name="slbIntranet")
    def slb_intranet(self) -> pulumi.Output[str]:
        """
        The ID of private load balancer where the current cluster master node is located.
        """
        return pulumi.get(self, "slb_intranet")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work node.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="workerDataDisks")
    def worker_data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.EdgeKubernetesWorkerDataDisk']]]:
        """
        The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        """
        return pulumi.get(self, "worker_data_disks")

    @property
    @pulumi.getter(name="workerDiskCategory")
    def worker_disk_category(self) -> pulumi.Output[Optional[str]]:
        """
        The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "worker_disk_category")

    @property
    @pulumi.getter(name="workerDiskPerformanceLevel")
    def worker_disk_performance_level(self) -> pulumi.Output[Optional[str]]:
        """
        Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "worker_disk_performance_level")

    @property
    @pulumi.getter(name="workerDiskSize")
    def worker_disk_size(self) -> pulumi.Output[Optional[int]]:
        """
        The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        """
        return pulumi.get(self, "worker_disk_size")

    @property
    @pulumi.getter(name="workerDiskSnapshotPolicyId")
    def worker_disk_snapshot_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        Worker node system disk auto snapshot policy.

        *Computed params*

        You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        """
        return pulumi.get(self, "worker_disk_snapshot_policy_id")

    @property
    @pulumi.getter(name="workerInstanceChargeType")
    def worker_instance_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        """
        return pulumi.get(self, "worker_instance_charge_type")

    @property
    @pulumi.getter(name="workerInstanceTypes")
    def worker_instance_types(self) -> pulumi.Output[Sequence[str]]:
        """
        The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        """
        return pulumi.get(self, "worker_instance_types")

    @property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> pulumi.Output[Sequence['outputs.EdgeKubernetesWorkerNode']]:
        """
        List of cluster worker nodes.
        """
        return pulumi.get(self, "worker_nodes")

    @property
    @pulumi.getter(name="workerNumber")
    def worker_number(self) -> pulumi.Output[int]:
        """
        The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        """
        return pulumi.get(self, "worker_number")

    @property
    @pulumi.getter(name="workerRamRoleName")
    def worker_ram_role_name(self) -> pulumi.Output[str]:
        """
        The RamRole Name attached to worker node.
        """
        return pulumi.get(self, "worker_ram_role_name")

    @property
    @pulumi.getter(name="workerVswitchIds")
    def worker_vswitch_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The vswitches used by workers.
        """
        return pulumi.get(self, "worker_vswitch_ids")

