# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKubernetesPermissionResult',
    'AwaitableGetKubernetesPermissionResult',
    'get_kubernetes_permission',
    'get_kubernetes_permission_output',
]

@pulumi.output_type
class GetKubernetesPermissionResult:
    """
    A collection of values returned by getKubernetesPermission.
    """
    def __init__(__self__, id=None, permissions=None, uid=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence['outputs.GetKubernetesPermissionPermissionResult']]:
        """
        A list of user permission.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        The ID of the RAM user. If you want to query the permissions of a RAM role, specify the ID of the RAM role.
        """
        return pulumi.get(self, "uid")


class AwaitableGetKubernetesPermissionResult(GetKubernetesPermissionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesPermissionResult(
            id=self.id,
            permissions=self.permissions,
            uid=self.uid)


def get_kubernetes_permission(permissions: Optional[Sequence[pulumi.InputType['GetKubernetesPermissionPermissionArgs']]] = None,
                              uid: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesPermissionResult:
    """
    This data source provides a list of Ram user permissions.

    > **NOTE:** Available in v1.122.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    users_ds = alicloud.ram.get_users(name_regex="your_user_name")
    default = alicloud.cs.get_kubernetes_permission(uid=users_ds.users[0].id)
    pulumi.export("permissions", default.permissions)
    ```


    :param Sequence[pulumi.InputType['GetKubernetesPermissionPermissionArgs']] permissions: A list of user permission.
    :param str uid: The ID of the RAM user. If you want to query the permissions of a RAM role, specify the ID of the RAM role.
    """
    __args__ = dict()
    __args__['permissions'] = permissions
    __args__['uid'] = uid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cs/getKubernetesPermission:getKubernetesPermission', __args__, opts=opts, typ=GetKubernetesPermissionResult).value

    return AwaitableGetKubernetesPermissionResult(
        id=pulumi.get(__ret__, 'id'),
        permissions=pulumi.get(__ret__, 'permissions'),
        uid=pulumi.get(__ret__, 'uid'))


@_utilities.lift_output_func(get_kubernetes_permission)
def get_kubernetes_permission_output(permissions: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetKubernetesPermissionPermissionArgs']]]]] = None,
                                     uid: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKubernetesPermissionResult]:
    """
    This data source provides a list of Ram user permissions.

    > **NOTE:** Available in v1.122.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    users_ds = alicloud.ram.get_users(name_regex="your_user_name")
    default = alicloud.cs.get_kubernetes_permission(uid=users_ds.users[0].id)
    pulumi.export("permissions", default.permissions)
    ```


    :param Sequence[pulumi.InputType['GetKubernetesPermissionPermissionArgs']] permissions: A list of user permission.
    :param str uid: The ID of the RAM user. If you want to query the permissions of a RAM role, specify the ID of the RAM role.
    """
    ...
