# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetKubernetesVersionResult',
    'AwaitableGetKubernetesVersionResult',
    'get_kubernetes_version',
    'get_kubernetes_version_output',
]

@pulumi.output_type
class GetKubernetesVersionResult:
    """
    A collection of values returned by getKubernetesVersion.
    """
    def __init__(__self__, cluster_type=None, id=None, kubernetes_version=None, metadatas=None, profile=None):
        if cluster_type and not isinstance(cluster_type, str):
            raise TypeError("Expected argument 'cluster_type' to be a str")
        pulumi.set(__self__, "cluster_type", cluster_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kubernetes_version and not isinstance(kubernetes_version, str):
            raise TypeError("Expected argument 'kubernetes_version' to be a str")
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if profile and not isinstance(profile, str):
            raise TypeError("Expected argument 'profile' to be a str")
        pulumi.set(__self__, "profile", profile)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> str:
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[str]:
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetKubernetesVersionMetadataResult']:
        """
        A list of metadata of kubernetes version.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def profile(self) -> Optional[str]:
        return pulumi.get(self, "profile")


class AwaitableGetKubernetesVersionResult(GetKubernetesVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesVersionResult(
            cluster_type=self.cluster_type,
            id=self.id,
            kubernetes_version=self.kubernetes_version,
            metadatas=self.metadatas,
            profile=self.profile)


def get_kubernetes_version(cluster_type: Optional[str] = None,
                           kubernetes_version: Optional[str] = None,
                           profile: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesVersionResult:
    """
    This data source provides the details of the Kubernetes version supported by ACK.

    > **NOTE:** Available in 1.170.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Default")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cs.get_kubernetes_version(cluster_type="Kubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Default")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Serverless")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.20.11-aliyunedge.1",
        profile="Edge")
    pulumi.export("metadata", default.metadatas)
    ```


    :param str cluster_type: The type of cluster. Its valid value are `Kubernetes` and `ManagedKubernetes`.
    :param str kubernetes_version: The ACK released kubernetes version.
    :param str profile: The profile of cluster. Its valid value are `Default`, `Serverless` and `Edge`.
    """
    __args__ = dict()
    __args__['clusterType'] = cluster_type
    __args__['kubernetesVersion'] = kubernetes_version
    __args__['profile'] = profile
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cs/getKubernetesVersion:getKubernetesVersion', __args__, opts=opts, typ=GetKubernetesVersionResult).value

    return AwaitableGetKubernetesVersionResult(
        cluster_type=pulumi.get(__ret__, 'cluster_type'),
        id=pulumi.get(__ret__, 'id'),
        kubernetes_version=pulumi.get(__ret__, 'kubernetes_version'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        profile=pulumi.get(__ret__, 'profile'))


@_utilities.lift_output_func(get_kubernetes_version)
def get_kubernetes_version_output(cluster_type: Optional[pulumi.Input[str]] = None,
                                  kubernetes_version: Optional[pulumi.Input[Optional[str]]] = None,
                                  profile: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKubernetesVersionResult]:
    """
    This data source provides the details of the Kubernetes version supported by ACK.

    > **NOTE:** Available in 1.170.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Default")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cs.get_kubernetes_version(cluster_type="Kubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Default")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Serverless")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.20.11-aliyunedge.1",
        profile="Edge")
    pulumi.export("metadata", default.metadatas)
    ```


    :param str cluster_type: The type of cluster. Its valid value are `Kubernetes` and `ManagedKubernetes`.
    :param str kubernetes_version: The ACK released kubernetes version.
    :param str profile: The profile of cluster. Its valid value are `Default`, `Serverless` and `Edge`.
    """
    ...
