# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesArgs', 'Kubernetes']

@pulumi.input_type
class KubernetesArgs:
    def __init__(__self__, *,
                 master_instance_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 master_vswitch_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAddonArgs']]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_domain: Optional[pulumi.Input[str]] = None,
                 custom_san: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_ssh: Optional[pulumi.Input[bool]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 master_auto_renew: Optional[pulumi.Input[bool]] = None,
                 master_auto_renew_period: Optional[pulumi.Input[int]] = None,
                 master_disk_category: Optional[pulumi.Input[str]] = None,
                 master_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 master_disk_size: Optional[pulumi.Input[int]] = None,
                 master_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 master_instance_charge_type: Optional[pulumi.Input[str]] = None,
                 master_period: Optional[pulumi.Input[int]] = None,
                 master_period_unit: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 node_name_mode: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime: Optional[pulumi.Input['KubernetesRuntimeArgs']] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_account_issuer: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_ca: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Kubernetes resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] master_instance_types: The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] master_vswitch_ids: The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesAddonArgs']]] addons: The addon you want to install in cluster. See `addons` below.
               
               *Network params*
        :param pulumi.Input[Sequence[pulumi.Input[str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
               
               *Removed params*
        :param pulumi.Input[str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input[str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] enable_ssh: Enable login to the node through SSH. Default to `false`.
        :param pulumi.Input[str] image_id: Custom Image support. Must based on CentOS7 or AliyunLinux2.
        :param pulumi.Input[bool] install_cloud_monitor: Install cloud monitor agent on ECS. Default to `true`.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        :param pulumi.Input[bool] master_auto_renew: Enable master payment auto-renew, defaults to false.
        :param pulumi.Input[int] master_auto_renew_period: Master payment auto-renew period, it can be one of {1, 2, 3, 6, 12}.
        :param pulumi.Input[str] master_disk_category: The system disk category of master node. Its valid value are `cloud_ssd`, `cloud_essd` and `cloud_efficiency`. Default to `cloud_efficiency`.
        :param pulumi.Input[str] master_disk_performance_level: Master node system disk performance level. When `master_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[int] master_disk_size: The system disk size of master node. Its valid value range [20~500] in GB. Default to 20.
        :param pulumi.Input[str] master_disk_snapshot_policy_id: Master node system disk auto snapshot policy.
               
               *Computed params*
        :param pulumi.Input[str] master_instance_charge_type: Master payment type. or `PostPaid` or `PrePaid`, defaults to `PostPaid`. If value is `PrePaid`, the files `master_period`, `master_period_unit`, `master_auto_renew` and `master_auto_renew_period` are required.
        :param pulumi.Input[int] master_period: Master payment period.Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        :param pulumi.Input[str] master_period_unit: Master payment period unit, the valid value is `Month`.
        :param pulumi.Input[str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Your cluster nodes and applications will have public network access. If there is a NAT gateway in the selected VPC, ACK will use this gateway by default; if there is no NAT gateway in the selected VPC, ACK will create a new NAT gateway for you and automatically configure SNAT rules.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] node_name_mode: Each node name consists of a prefix, an IP substring, and a suffix, the input format is `customized,<prefix>,IPSubStringLen,<suffix>`. For example "customized,aliyun.com-,5,-test", if the node IP address is 192.168.59.176, the prefix is aliyun.com-, IP substring length is 5, and the suffix is -test, the node name will be aliyun.com-59176-test.
        :param pulumi.Input[str] os_type: The operating system of the nodes that run pods, its valid value is either `Linux` or `Windows`. Default to `Linux`.
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] platform: The architecture of the nodes that run pods, its valid value is either `CentOS` or `AliyunLinux`. Default to `CentOS`.
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables | ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input['KubernetesRuntimeArgs'] runtime: The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). Detailed below.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
               
               > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
               If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Master params*
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        :param pulumi.Input[str] timezone: When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        :param pulumi.Input[str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        pulumi.set(__self__, "master_instance_types", master_instance_types)
        pulumi.set(__self__, "master_vswitch_ids", master_vswitch_ids)
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if api_audiences is not None:
            pulumi.set(__self__, "api_audiences", api_audiences)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_domain is not None:
            pulumi.set(__self__, "cluster_domain", cluster_domain)
        if custom_san is not None:
            pulumi.set(__self__, "custom_san", custom_san)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_ssh is not None:
            pulumi.set(__self__, "enable_ssh", enable_ssh)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if install_cloud_monitor is not None:
            pulumi.set(__self__, "install_cloud_monitor", install_cloud_monitor)
        if is_enterprise_security_group is not None:
            pulumi.set(__self__, "is_enterprise_security_group", is_enterprise_security_group)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if master_auto_renew is not None:
            pulumi.set(__self__, "master_auto_renew", master_auto_renew)
        if master_auto_renew_period is not None:
            pulumi.set(__self__, "master_auto_renew_period", master_auto_renew_period)
        if master_disk_category is not None:
            pulumi.set(__self__, "master_disk_category", master_disk_category)
        if master_disk_performance_level is not None:
            pulumi.set(__self__, "master_disk_performance_level", master_disk_performance_level)
        if master_disk_size is not None:
            pulumi.set(__self__, "master_disk_size", master_disk_size)
        if master_disk_snapshot_policy_id is not None:
            pulumi.set(__self__, "master_disk_snapshot_policy_id", master_disk_snapshot_policy_id)
        if master_instance_charge_type is not None:
            pulumi.set(__self__, "master_instance_charge_type", master_instance_charge_type)
        if master_period is not None:
            pulumi.set(__self__, "master_period", master_period)
        if master_period_unit is not None:
            pulumi.set(__self__, "master_period_unit", master_period_unit)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            warnings.warn("""Field 'name_prefix' has been deprecated from provider version 1.75.0.""", DeprecationWarning)
            pulumi.log.warn("""name_prefix is deprecated: Field 'name_prefix' has been deprecated from provider version 1.75.0.""")
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if node_cidr_mask is not None:
            pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        if node_name_mode is not None:
            pulumi.set(__self__, "node_name_mode", node_name_mode)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if pod_vswitch_ids is not None:
            pulumi.set(__self__, "pod_vswitch_ids", pod_vswitch_ids)
        if proxy_mode is not None:
            pulumi.set(__self__, "proxy_mode", proxy_mode)
        if rds_instances is not None:
            pulumi.set(__self__, "rds_instances", rds_instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_account_issuer is not None:
            pulumi.set(__self__, "service_account_issuer", service_account_issuer)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if slb_internet_enabled is not None:
            pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_ca is not None:
            pulumi.set(__self__, "user_ca", user_ca)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="masterInstanceTypes")
    def master_instance_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
        """
        return pulumi.get(self, "master_instance_types")

    @master_instance_types.setter
    def master_instance_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "master_instance_types", value)

    @property
    @pulumi.getter(name="masterVswitchIds")
    def master_vswitch_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
        """
        return pulumi.get(self, "master_vswitch_ids")

    @master_vswitch_ids.setter
    def master_vswitch_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "master_vswitch_ids", value)

    @property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAddonArgs']]]]:
        """
        The addon you want to install in cluster. See `addons` below.

        *Network params*
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @property
    @pulumi.getter(name="apiAudiences")
    def api_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "api_audiences")

    @api_audiences.setter
    def api_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "api_audiences", value)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="clusterCaCert")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        """
        return pulumi.get(self, "cluster_domain")

    @cluster_domain.setter
    def cluster_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_domain", value)

    @property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> Optional[pulumi.Input[str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        """
        return pulumi.get(self, "custom_san")

    @custom_san.setter
    def custom_san(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_san", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="enableSsh")
    def enable_ssh(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable login to the node through SSH. Default to `false`.
        """
        return pulumi.get(self, "enable_ssh")

    @enable_ssh.setter
    def enable_ssh(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ssh", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Image support. Must based on CentOS7 or AliyunLinux2.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> Optional[pulumi.Input[bool]]:
        """
        Install cloud monitor agent on ECS. Default to `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @install_cloud_monitor.setter
    def install_cloud_monitor(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_cloud_monitor", value)

    @property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @is_enterprise_security_group.setter
    def is_enterprise_security_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enterprise_security_group", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[str]]:
        """
        An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @property
    @pulumi.getter(name="masterAutoRenew")
    def master_auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable master payment auto-renew, defaults to false.
        """
        return pulumi.get(self, "master_auto_renew")

    @master_auto_renew.setter
    def master_auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "master_auto_renew", value)

    @property
    @pulumi.getter(name="masterAutoRenewPeriod")
    def master_auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Master payment auto-renew period, it can be one of {1, 2, 3, 6, 12}.
        """
        return pulumi.get(self, "master_auto_renew_period")

    @master_auto_renew_period.setter
    def master_auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_auto_renew_period", value)

    @property
    @pulumi.getter(name="masterDiskCategory")
    def master_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The system disk category of master node. Its valid value are `cloud_ssd`, `cloud_essd` and `cloud_efficiency`. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "master_disk_category")

    @master_disk_category.setter
    def master_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_disk_category", value)

    @property
    @pulumi.getter(name="masterDiskPerformanceLevel")
    def master_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        Master node system disk performance level. When `master_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "master_disk_performance_level")

    @master_disk_performance_level.setter
    def master_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_disk_performance_level", value)

    @property
    @pulumi.getter(name="masterDiskSize")
    def master_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The system disk size of master node. Its valid value range [20~500] in GB. Default to 20.
        """
        return pulumi.get(self, "master_disk_size")

    @master_disk_size.setter
    def master_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_disk_size", value)

    @property
    @pulumi.getter(name="masterDiskSnapshotPolicyId")
    def master_disk_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Master node system disk auto snapshot policy.

        *Computed params*
        """
        return pulumi.get(self, "master_disk_snapshot_policy_id")

    @master_disk_snapshot_policy_id.setter
    def master_disk_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_disk_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="masterInstanceChargeType")
    def master_instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Master payment type. or `PostPaid` or `PrePaid`, defaults to `PostPaid`. If value is `PrePaid`, the files `master_period`, `master_period_unit`, `master_auto_renew` and `master_auto_renew_period` are required.
        """
        return pulumi.get(self, "master_instance_charge_type")

    @master_instance_charge_type.setter
    def master_instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_instance_charge_type", value)

    @property
    @pulumi.getter(name="masterPeriod")
    def master_period(self) -> Optional[pulumi.Input[int]]:
        """
        Master payment period.Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        """
        return pulumi.get(self, "master_period")

    @master_period.setter
    def master_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_period", value)

    @property
    @pulumi.getter(name="masterPeriodUnit")
    def master_period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Master payment period unit, the valid value is `Month`.
        """
        return pulumi.get(self, "master_period_unit")

    @master_period_unit.setter
    def master_period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_period_unit", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        warnings.warn("""Field 'name_prefix' has been deprecated from provider version 1.75.0.""", DeprecationWarning)
        pulumi.log.warn("""name_prefix is deprecated: Field 'name_prefix' has been deprecated from provider version 1.75.0.""")

        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Your cluster nodes and applications will have public network access. If there is a NAT gateway in the selected VPC, ACK will use this gateway by default; if there is no NAT gateway in the selected VPC, ACK will create a new NAT gateway for you and automatically configure SNAT rules.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> Optional[pulumi.Input[int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @node_cidr_mask.setter
    def node_cidr_mask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_cidr_mask", value)

    @property
    @pulumi.getter(name="nodeNameMode")
    def node_name_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Each node name consists of a prefix, an IP substring, and a suffix, the input format is `customized,<prefix>,IPSubStringLen,<suffix>`. For example "customized,aliyun.com-,5,-test", if the node IP address is 192.168.59.176, the prefix is aliyun.com-, IP substring length is 5, and the suffix is -test, the node name will be aliyun.com-59176-test.
        """
        return pulumi.get(self, "node_name_mode")

    @node_name_mode.setter
    def node_name_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_name_mode", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system of the nodes that run pods, its valid value is either `Linux` or `Windows`. Default to `Linux`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The architecture of the nodes that run pods, its valid value is either `CentOS` or `AliyunLinux`. Default to `CentOS`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_cidr", value)

    @property
    @pulumi.getter(name="podVswitchIds")
    def pod_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        """
        return pulumi.get(self, "pod_vswitch_ids")

    @pod_vswitch_ids.setter
    def pod_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pod_vswitch_ids", value)

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables | ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @proxy_mode.setter
    def proxy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_mode", value)

    @property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @rds_instances.setter
    def rds_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rds_instances", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retain_resources", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['KubernetesRuntimeArgs']]:
        """
        The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). Detailed below.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['KubernetesRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="serviceAccountIssuer")
    def service_account_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "service_account_issuer")

    @service_account_issuer.setter
    def service_account_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_issuer", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.

        > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
        If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.

        *Master params*
        """
        return pulumi.get(self, "slb_internet_enabled")

    @slb_internet_enabled.setter
    def slb_internet_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "slb_internet_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="userCa")
    def user_ca(self) -> Optional[pulumi.Input[str]]:
        """
        The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        """
        return pulumi.get(self, "user_ca")

    @user_ca.setter
    def user_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_ca", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _KubernetesState:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAddonArgs']]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 certificate_authority: Optional[pulumi.Input['KubernetesCertificateAuthorityArgs']] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_domain: Optional[pulumi.Input[str]] = None,
                 connections: Optional[pulumi.Input['KubernetesConnectionsArgs']] = None,
                 custom_san: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_ssh: Optional[pulumi.Input[bool]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 master_auto_renew: Optional[pulumi.Input[bool]] = None,
                 master_auto_renew_period: Optional[pulumi.Input[int]] = None,
                 master_disk_category: Optional[pulumi.Input[str]] = None,
                 master_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 master_disk_size: Optional[pulumi.Input[int]] = None,
                 master_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 master_instance_charge_type: Optional[pulumi.Input[str]] = None,
                 master_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 master_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesMasterNodeArgs']]]] = None,
                 master_period: Optional[pulumi.Input[int]] = None,
                 master_period_unit: Optional[pulumi.Input[str]] = None,
                 master_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 node_name_mode: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime: Optional[pulumi.Input['KubernetesRuntimeArgs']] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_account_issuer: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_id: Optional[pulumi.Input[str]] = None,
                 slb_internet: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 slb_intranet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_ca: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 worker_ram_role_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Kubernetes resources.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesAddonArgs']]] addons: The addon you want to install in cluster. See `addons` below.
               
               *Network params*
        :param pulumi.Input[Sequence[pulumi.Input[str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input['KubernetesCertificateAuthorityArgs'] certificate_authority: (Map, Available since v1.105.0) Nested attribute containing certificate authority data for your cluster.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
               
               *Removed params*
        :param pulumi.Input[str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input['KubernetesConnectionsArgs'] connections: (Map) Map of kubernetes cluster connection information.
        :param pulumi.Input[str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] enable_ssh: Enable login to the node through SSH. Default to `false`.
        :param pulumi.Input[str] image_id: Custom Image support. Must based on CentOS7 or AliyunLinux2.
        :param pulumi.Input[bool] install_cloud_monitor: Install cloud monitor agent on ECS. Default to `true`.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        :param pulumi.Input[bool] master_auto_renew: Enable master payment auto-renew, defaults to false.
        :param pulumi.Input[int] master_auto_renew_period: Master payment auto-renew period, it can be one of {1, 2, 3, 6, 12}.
        :param pulumi.Input[str] master_disk_category: The system disk category of master node. Its valid value are `cloud_ssd`, `cloud_essd` and `cloud_efficiency`. Default to `cloud_efficiency`.
        :param pulumi.Input[str] master_disk_performance_level: Master node system disk performance level. When `master_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[int] master_disk_size: The system disk size of master node. Its valid value range [20~500] in GB. Default to 20.
        :param pulumi.Input[str] master_disk_snapshot_policy_id: Master node system disk auto snapshot policy.
               
               *Computed params*
        :param pulumi.Input[str] master_instance_charge_type: Master payment type. or `PostPaid` or `PrePaid`, defaults to `PostPaid`. If value is `PrePaid`, the files `master_period`, `master_period_unit`, `master_auto_renew` and `master_auto_renew_period` are required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] master_instance_types: The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesMasterNodeArgs']]] master_nodes: (Optional) The master nodes. See `master_nodes` below.
        :param pulumi.Input[int] master_period: Master payment period.Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        :param pulumi.Input[str] master_period_unit: Master payment period unit, the valid value is `Month`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] master_vswitch_ids: The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
        :param pulumi.Input[str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[str] nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Your cluster nodes and applications will have public network access. If there is a NAT gateway in the selected VPC, ACK will use this gateway by default; if there is no NAT gateway in the selected VPC, ACK will create a new NAT gateway for you and automatically configure SNAT rules.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] node_name_mode: Each node name consists of a prefix, an IP substring, and a suffix, the input format is `customized,<prefix>,IPSubStringLen,<suffix>`. For example "customized,aliyun.com-,5,-test", if the node IP address is 192.168.59.176, the prefix is aliyun.com-, IP substring length is 5, and the suffix is -test, the node name will be aliyun.com-59176-test.
        :param pulumi.Input[str] os_type: The operating system of the nodes that run pods, its valid value is either `Linux` or `Windows`. Default to `Linux`.
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] platform: The architecture of the nodes that run pods, its valid value is either `CentOS` or `AliyunLinux`. Default to `CentOS`.
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables | ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input['KubernetesRuntimeArgs'] runtime: The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). Detailed below.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[str] slb_id: (Deprecated) The ID of load balancer.
        :param pulumi.Input[str] slb_internet: The public ip of load balancer.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
               
               > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
               If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Master params*
        :param pulumi.Input[str] slb_intranet: The ID of private load balancer where the current cluster master node is located.
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        :param pulumi.Input[str] timezone: When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        :param pulumi.Input[str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        :param pulumi.Input[str] vpc_id: The ID of VPC where the current cluster is located.
        :param pulumi.Input[str] worker_ram_role_name: The RamRole Name attached to worker node.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if api_audiences is not None:
            pulumi.set(__self__, "api_audiences", api_audiences)
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_domain is not None:
            pulumi.set(__self__, "cluster_domain", cluster_domain)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if custom_san is not None:
            pulumi.set(__self__, "custom_san", custom_san)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_ssh is not None:
            pulumi.set(__self__, "enable_ssh", enable_ssh)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if install_cloud_monitor is not None:
            pulumi.set(__self__, "install_cloud_monitor", install_cloud_monitor)
        if is_enterprise_security_group is not None:
            pulumi.set(__self__, "is_enterprise_security_group", is_enterprise_security_group)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if master_auto_renew is not None:
            pulumi.set(__self__, "master_auto_renew", master_auto_renew)
        if master_auto_renew_period is not None:
            pulumi.set(__self__, "master_auto_renew_period", master_auto_renew_period)
        if master_disk_category is not None:
            pulumi.set(__self__, "master_disk_category", master_disk_category)
        if master_disk_performance_level is not None:
            pulumi.set(__self__, "master_disk_performance_level", master_disk_performance_level)
        if master_disk_size is not None:
            pulumi.set(__self__, "master_disk_size", master_disk_size)
        if master_disk_snapshot_policy_id is not None:
            pulumi.set(__self__, "master_disk_snapshot_policy_id", master_disk_snapshot_policy_id)
        if master_instance_charge_type is not None:
            pulumi.set(__self__, "master_instance_charge_type", master_instance_charge_type)
        if master_instance_types is not None:
            pulumi.set(__self__, "master_instance_types", master_instance_types)
        if master_nodes is not None:
            pulumi.set(__self__, "master_nodes", master_nodes)
        if master_period is not None:
            pulumi.set(__self__, "master_period", master_period)
        if master_period_unit is not None:
            pulumi.set(__self__, "master_period_unit", master_period_unit)
        if master_vswitch_ids is not None:
            pulumi.set(__self__, "master_vswitch_ids", master_vswitch_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            warnings.warn("""Field 'name_prefix' has been deprecated from provider version 1.75.0.""", DeprecationWarning)
            pulumi.log.warn("""name_prefix is deprecated: Field 'name_prefix' has been deprecated from provider version 1.75.0.""")
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if node_cidr_mask is not None:
            pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        if node_name_mode is not None:
            pulumi.set(__self__, "node_name_mode", node_name_mode)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if pod_vswitch_ids is not None:
            pulumi.set(__self__, "pod_vswitch_ids", pod_vswitch_ids)
        if proxy_mode is not None:
            pulumi.set(__self__, "proxy_mode", proxy_mode)
        if rds_instances is not None:
            pulumi.set(__self__, "rds_instances", rds_instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_account_issuer is not None:
            pulumi.set(__self__, "service_account_issuer", service_account_issuer)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if slb_id is not None:
            warnings.warn("""Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""slb_id is deprecated: Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""")
        if slb_id is not None:
            pulumi.set(__self__, "slb_id", slb_id)
        if slb_internet is not None:
            pulumi.set(__self__, "slb_internet", slb_internet)
        if slb_internet_enabled is not None:
            pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        if slb_intranet is not None:
            pulumi.set(__self__, "slb_intranet", slb_intranet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_ca is not None:
            pulumi.set(__self__, "user_ca", user_ca)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if worker_ram_role_name is not None:
            pulumi.set(__self__, "worker_ram_role_name", worker_ram_role_name)

    @property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAddonArgs']]]]:
        """
        The addon you want to install in cluster. See `addons` below.

        *Network params*
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @property
    @pulumi.getter(name="apiAudiences")
    def api_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "api_audiences")

    @api_audiences.setter
    def api_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "api_audiences", value)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input['KubernetesCertificateAuthorityArgs']]:
        """
        (Map, Available since v1.105.0) Nested attribute containing certificate authority data for your cluster.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input['KubernetesCertificateAuthorityArgs']]):
        pulumi.set(self, "certificate_authority", value)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="clusterCaCert")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        """
        return pulumi.get(self, "cluster_domain")

    @cluster_domain.setter
    def cluster_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_domain", value)

    @property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input['KubernetesConnectionsArgs']]:
        """
        (Map) Map of kubernetes cluster connection information.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input['KubernetesConnectionsArgs']]):
        pulumi.set(self, "connections", value)

    @property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> Optional[pulumi.Input[str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        """
        return pulumi.get(self, "custom_san")

    @custom_san.setter
    def custom_san(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_san", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="enableSsh")
    def enable_ssh(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable login to the node through SSH. Default to `false`.
        """
        return pulumi.get(self, "enable_ssh")

    @enable_ssh.setter
    def enable_ssh(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ssh", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Image support. Must based on CentOS7 or AliyunLinux2.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> Optional[pulumi.Input[bool]]:
        """
        Install cloud monitor agent on ECS. Default to `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @install_cloud_monitor.setter
    def install_cloud_monitor(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_cloud_monitor", value)

    @property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @is_enterprise_security_group.setter
    def is_enterprise_security_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enterprise_security_group", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[str]]:
        """
        An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @property
    @pulumi.getter(name="masterAutoRenew")
    def master_auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable master payment auto-renew, defaults to false.
        """
        return pulumi.get(self, "master_auto_renew")

    @master_auto_renew.setter
    def master_auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "master_auto_renew", value)

    @property
    @pulumi.getter(name="masterAutoRenewPeriod")
    def master_auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Master payment auto-renew period, it can be one of {1, 2, 3, 6, 12}.
        """
        return pulumi.get(self, "master_auto_renew_period")

    @master_auto_renew_period.setter
    def master_auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_auto_renew_period", value)

    @property
    @pulumi.getter(name="masterDiskCategory")
    def master_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The system disk category of master node. Its valid value are `cloud_ssd`, `cloud_essd` and `cloud_efficiency`. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "master_disk_category")

    @master_disk_category.setter
    def master_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_disk_category", value)

    @property
    @pulumi.getter(name="masterDiskPerformanceLevel")
    def master_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        Master node system disk performance level. When `master_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "master_disk_performance_level")

    @master_disk_performance_level.setter
    def master_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_disk_performance_level", value)

    @property
    @pulumi.getter(name="masterDiskSize")
    def master_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The system disk size of master node. Its valid value range [20~500] in GB. Default to 20.
        """
        return pulumi.get(self, "master_disk_size")

    @master_disk_size.setter
    def master_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_disk_size", value)

    @property
    @pulumi.getter(name="masterDiskSnapshotPolicyId")
    def master_disk_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Master node system disk auto snapshot policy.

        *Computed params*
        """
        return pulumi.get(self, "master_disk_snapshot_policy_id")

    @master_disk_snapshot_policy_id.setter
    def master_disk_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_disk_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="masterInstanceChargeType")
    def master_instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Master payment type. or `PostPaid` or `PrePaid`, defaults to `PostPaid`. If value is `PrePaid`, the files `master_period`, `master_period_unit`, `master_auto_renew` and `master_auto_renew_period` are required.
        """
        return pulumi.get(self, "master_instance_charge_type")

    @master_instance_charge_type.setter
    def master_instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_instance_charge_type", value)

    @property
    @pulumi.getter(name="masterInstanceTypes")
    def master_instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
        """
        return pulumi.get(self, "master_instance_types")

    @master_instance_types.setter
    def master_instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "master_instance_types", value)

    @property
    @pulumi.getter(name="masterNodes")
    def master_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesMasterNodeArgs']]]]:
        """
        (Optional) The master nodes. See `master_nodes` below.
        """
        return pulumi.get(self, "master_nodes")

    @master_nodes.setter
    def master_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesMasterNodeArgs']]]]):
        pulumi.set(self, "master_nodes", value)

    @property
    @pulumi.getter(name="masterPeriod")
    def master_period(self) -> Optional[pulumi.Input[int]]:
        """
        Master payment period.Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        """
        return pulumi.get(self, "master_period")

    @master_period.setter
    def master_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_period", value)

    @property
    @pulumi.getter(name="masterPeriodUnit")
    def master_period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Master payment period unit, the valid value is `Month`.
        """
        return pulumi.get(self, "master_period_unit")

    @master_period_unit.setter
    def master_period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_period_unit", value)

    @property
    @pulumi.getter(name="masterVswitchIds")
    def master_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
        """
        return pulumi.get(self, "master_vswitch_ids")

    @master_vswitch_ids.setter
    def master_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "master_vswitch_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        warnings.warn("""Field 'name_prefix' has been deprecated from provider version 1.75.0.""", DeprecationWarning)
        pulumi.log.warn("""name_prefix is deprecated: Field 'name_prefix' has been deprecated from provider version 1.75.0.""")

        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Your cluster nodes and applications will have public network access. If there is a NAT gateway in the selected VPC, ACK will use this gateway by default; if there is no NAT gateway in the selected VPC, ACK will create a new NAT gateway for you and automatically configure SNAT rules.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> Optional[pulumi.Input[int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @node_cidr_mask.setter
    def node_cidr_mask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_cidr_mask", value)

    @property
    @pulumi.getter(name="nodeNameMode")
    def node_name_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Each node name consists of a prefix, an IP substring, and a suffix, the input format is `customized,<prefix>,IPSubStringLen,<suffix>`. For example "customized,aliyun.com-,5,-test", if the node IP address is 192.168.59.176, the prefix is aliyun.com-, IP substring length is 5, and the suffix is -test, the node name will be aliyun.com-59176-test.
        """
        return pulumi.get(self, "node_name_mode")

    @node_name_mode.setter
    def node_name_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_name_mode", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system of the nodes that run pods, its valid value is either `Linux` or `Windows`. Default to `Linux`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The architecture of the nodes that run pods, its valid value is either `CentOS` or `AliyunLinux`. Default to `CentOS`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_cidr", value)

    @property
    @pulumi.getter(name="podVswitchIds")
    def pod_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        """
        return pulumi.get(self, "pod_vswitch_ids")

    @pod_vswitch_ids.setter
    def pod_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pod_vswitch_ids", value)

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables | ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @proxy_mode.setter
    def proxy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_mode", value)

    @property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @rds_instances.setter
    def rds_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rds_instances", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retain_resources", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['KubernetesRuntimeArgs']]:
        """
        The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). Detailed below.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['KubernetesRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="serviceAccountIssuer")
    def service_account_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "service_account_issuer")

    @service_account_issuer.setter
    def service_account_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_issuer", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="slbId")
    def slb_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Deprecated) The ID of load balancer.
        """
        warnings.warn("""Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""", DeprecationWarning)
        pulumi.log.warn("""slb_id is deprecated: Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""")

        return pulumi.get(self, "slb_id")

    @slb_id.setter
    def slb_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slb_id", value)

    @property
    @pulumi.getter(name="slbInternet")
    def slb_internet(self) -> Optional[pulumi.Input[str]]:
        """
        The public ip of load balancer.
        """
        return pulumi.get(self, "slb_internet")

    @slb_internet.setter
    def slb_internet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slb_internet", value)

    @property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.

        > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
        If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.

        *Master params*
        """
        return pulumi.get(self, "slb_internet_enabled")

    @slb_internet_enabled.setter
    def slb_internet_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "slb_internet_enabled", value)

    @property
    @pulumi.getter(name="slbIntranet")
    def slb_intranet(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of private load balancer where the current cluster master node is located.
        """
        return pulumi.get(self, "slb_intranet")

    @slb_intranet.setter
    def slb_intranet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slb_intranet", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="userCa")
    def user_ca(self) -> Optional[pulumi.Input[str]]:
        """
        The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        """
        return pulumi.get(self, "user_ca")

    @user_ca.setter
    def user_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_ca", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="workerRamRoleName")
    def worker_ram_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The RamRole Name attached to worker node.
        """
        return pulumi.get(self, "worker_ram_role_name")

    @worker_ram_role_name.setter
    def worker_ram_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_ram_role_name", value)


class Kubernetes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubernetesAddonArgs']]]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_domain: Optional[pulumi.Input[str]] = None,
                 custom_san: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_ssh: Optional[pulumi.Input[bool]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 master_auto_renew: Optional[pulumi.Input[bool]] = None,
                 master_auto_renew_period: Optional[pulumi.Input[int]] = None,
                 master_disk_category: Optional[pulumi.Input[str]] = None,
                 master_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 master_disk_size: Optional[pulumi.Input[int]] = None,
                 master_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 master_instance_charge_type: Optional[pulumi.Input[str]] = None,
                 master_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 master_period: Optional[pulumi.Input[int]] = None,
                 master_period_unit: Optional[pulumi.Input[str]] = None,
                 master_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 node_name_mode: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime: Optional[pulumi.Input[pulumi.InputType['KubernetesRuntimeArgs']]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_account_issuer: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_ca: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource will help you to manage a Kubernetes Cluster in Alibaba Cloud Kubernetes Service, see [What is kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-an-ask-cluster-1).

        > **NOTE:** Available since v1.9.0.

        > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Each kubernetes cluster contains 3 master nodes and those number cannot be changed at now.

        > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.

        > **NOTE:** From version 1.9.4, the provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** From version 1.16.0, the provider supports Multiple Availability Zones Kubernetes Cluster. To create a cluster of this kind, you must specify 3 or 5 items in `master_vswitch_ids` and `master_instance_types`.

        > **NOTE:** From version 1.20.0, the provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.

        > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
        Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).

        > **NOTE:** From version 1.75.0, Some parameters have been removed from resource,You can check them below and re-import the cluster if necessary.

        > **NOTE:** From version 1.101.0+, We supported the `professional managed clusters(ack-pro)`, You can create a pro cluster by setting the the value of `cluster_spec`.

        > **NOTE:** From version 1.177.0+, `exclude_autoscaler_nodes`,`worker_number`,`worker_vswitch_ids`,`worker_instance_types`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_port_range`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id` are deprecated.
        We Suggest you using resource **`cs.NodePool`** to manage your cluster worker nodes.

        > **NOTE:** From version 1.212.0, `exclude_autoscaler_nodes`,`worker_number`,`worker_vswitch_ids`,`worker_instance_types`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_port_range`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`kube_config`,`availability_zone` are removed.
        Please use resource **`cs.NodePool`** to manage your cluster worker nodes.

        ## Import

        Kubernetes cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
         $ pulumi import alicloud:cs/kubernetes:Kubernetes main cluster-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubernetesAddonArgs']]]] addons: The addon you want to install in cluster. See `addons` below.
               
               *Network params*
        :param pulumi.Input[Sequence[pulumi.Input[str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
               
               *Removed params*
        :param pulumi.Input[str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input[str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] enable_ssh: Enable login to the node through SSH. Default to `false`.
        :param pulumi.Input[str] image_id: Custom Image support. Must based on CentOS7 or AliyunLinux2.
        :param pulumi.Input[bool] install_cloud_monitor: Install cloud monitor agent on ECS. Default to `true`.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        :param pulumi.Input[bool] master_auto_renew: Enable master payment auto-renew, defaults to false.
        :param pulumi.Input[int] master_auto_renew_period: Master payment auto-renew period, it can be one of {1, 2, 3, 6, 12}.
        :param pulumi.Input[str] master_disk_category: The system disk category of master node. Its valid value are `cloud_ssd`, `cloud_essd` and `cloud_efficiency`. Default to `cloud_efficiency`.
        :param pulumi.Input[str] master_disk_performance_level: Master node system disk performance level. When `master_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[int] master_disk_size: The system disk size of master node. Its valid value range [20~500] in GB. Default to 20.
        :param pulumi.Input[str] master_disk_snapshot_policy_id: Master node system disk auto snapshot policy.
               
               *Computed params*
        :param pulumi.Input[str] master_instance_charge_type: Master payment type. or `PostPaid` or `PrePaid`, defaults to `PostPaid`. If value is `PrePaid`, the files `master_period`, `master_period_unit`, `master_auto_renew` and `master_auto_renew_period` are required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] master_instance_types: The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
        :param pulumi.Input[int] master_period: Master payment period.Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        :param pulumi.Input[str] master_period_unit: Master payment period unit, the valid value is `Month`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] master_vswitch_ids: The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
        :param pulumi.Input[str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Your cluster nodes and applications will have public network access. If there is a NAT gateway in the selected VPC, ACK will use this gateway by default; if there is no NAT gateway in the selected VPC, ACK will create a new NAT gateway for you and automatically configure SNAT rules.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] node_name_mode: Each node name consists of a prefix, an IP substring, and a suffix, the input format is `customized,<prefix>,IPSubStringLen,<suffix>`. For example "customized,aliyun.com-,5,-test", if the node IP address is 192.168.59.176, the prefix is aliyun.com-, IP substring length is 5, and the suffix is -test, the node name will be aliyun.com-59176-test.
        :param pulumi.Input[str] os_type: The operating system of the nodes that run pods, its valid value is either `Linux` or `Windows`. Default to `Linux`.
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] platform: The architecture of the nodes that run pods, its valid value is either `CentOS` or `AliyunLinux`. Default to `CentOS`.
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables | ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[pulumi.InputType['KubernetesRuntimeArgs']] runtime: The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). Detailed below.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
               
               > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
               If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Master params*
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        :param pulumi.Input[str] timezone: When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        :param pulumi.Input[str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource will help you to manage a Kubernetes Cluster in Alibaba Cloud Kubernetes Service, see [What is kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-an-ask-cluster-1).

        > **NOTE:** Available since v1.9.0.

        > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Each kubernetes cluster contains 3 master nodes and those number cannot be changed at now.

        > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.

        > **NOTE:** From version 1.9.4, the provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** From version 1.16.0, the provider supports Multiple Availability Zones Kubernetes Cluster. To create a cluster of this kind, you must specify 3 or 5 items in `master_vswitch_ids` and `master_instance_types`.

        > **NOTE:** From version 1.20.0, the provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.

        > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
        Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).

        > **NOTE:** From version 1.75.0, Some parameters have been removed from resource,You can check them below and re-import the cluster if necessary.

        > **NOTE:** From version 1.101.0+, We supported the `professional managed clusters(ack-pro)`, You can create a pro cluster by setting the the value of `cluster_spec`.

        > **NOTE:** From version 1.177.0+, `exclude_autoscaler_nodes`,`worker_number`,`worker_vswitch_ids`,`worker_instance_types`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_port_range`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id` are deprecated.
        We Suggest you using resource **`cs.NodePool`** to manage your cluster worker nodes.

        > **NOTE:** From version 1.212.0, `exclude_autoscaler_nodes`,`worker_number`,`worker_vswitch_ids`,`worker_instance_types`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_port_range`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`kube_config`,`availability_zone` are removed.
        Please use resource **`cs.NodePool`** to manage your cluster worker nodes.

        ## Import

        Kubernetes cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
         $ pulumi import alicloud:cs/kubernetes:Kubernetes main cluster-id
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubernetesAddonArgs']]]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_domain: Optional[pulumi.Input[str]] = None,
                 custom_san: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_ssh: Optional[pulumi.Input[bool]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 master_auto_renew: Optional[pulumi.Input[bool]] = None,
                 master_auto_renew_period: Optional[pulumi.Input[int]] = None,
                 master_disk_category: Optional[pulumi.Input[str]] = None,
                 master_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 master_disk_size: Optional[pulumi.Input[int]] = None,
                 master_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 master_instance_charge_type: Optional[pulumi.Input[str]] = None,
                 master_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 master_period: Optional[pulumi.Input[int]] = None,
                 master_period_unit: Optional[pulumi.Input[str]] = None,
                 master_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 node_name_mode: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime: Optional[pulumi.Input[pulumi.InputType['KubernetesRuntimeArgs']]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_account_issuer: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_ca: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesArgs.__new__(KubernetesArgs)

            __props__.__dict__["addons"] = addons
            __props__.__dict__["api_audiences"] = api_audiences
            __props__.__dict__["client_cert"] = client_cert
            __props__.__dict__["client_key"] = client_key
            __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
            __props__.__dict__["cluster_domain"] = cluster_domain
            __props__.__dict__["custom_san"] = custom_san
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["enable_ssh"] = enable_ssh
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["install_cloud_monitor"] = install_cloud_monitor
            __props__.__dict__["is_enterprise_security_group"] = is_enterprise_security_group
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["load_balancer_spec"] = load_balancer_spec
            __props__.__dict__["master_auto_renew"] = master_auto_renew
            __props__.__dict__["master_auto_renew_period"] = master_auto_renew_period
            __props__.__dict__["master_disk_category"] = master_disk_category
            __props__.__dict__["master_disk_performance_level"] = master_disk_performance_level
            __props__.__dict__["master_disk_size"] = master_disk_size
            __props__.__dict__["master_disk_snapshot_policy_id"] = master_disk_snapshot_policy_id
            __props__.__dict__["master_instance_charge_type"] = master_instance_charge_type
            if master_instance_types is None and not opts.urn:
                raise TypeError("Missing required property 'master_instance_types'")
            __props__.__dict__["master_instance_types"] = master_instance_types
            __props__.__dict__["master_period"] = master_period
            __props__.__dict__["master_period_unit"] = master_period_unit
            if master_vswitch_ids is None and not opts.urn:
                raise TypeError("Missing required property 'master_vswitch_ids'")
            __props__.__dict__["master_vswitch_ids"] = master_vswitch_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["new_nat_gateway"] = new_nat_gateway
            __props__.__dict__["node_cidr_mask"] = node_cidr_mask
            __props__.__dict__["node_name_mode"] = node_name_mode
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["platform"] = platform
            __props__.__dict__["pod_cidr"] = pod_cidr
            __props__.__dict__["pod_vswitch_ids"] = pod_vswitch_ids
            __props__.__dict__["proxy_mode"] = proxy_mode
            __props__.__dict__["rds_instances"] = rds_instances
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["retain_resources"] = retain_resources
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["service_account_issuer"] = service_account_issuer
            __props__.__dict__["service_cidr"] = service_cidr
            __props__.__dict__["slb_internet_enabled"] = slb_internet_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["user_ca"] = user_ca
            __props__.__dict__["version"] = version
            __props__.__dict__["certificate_authority"] = None
            __props__.__dict__["connections"] = None
            __props__.__dict__["master_nodes"] = None
            __props__.__dict__["nat_gateway_id"] = None
            __props__.__dict__["slb_id"] = None
            __props__.__dict__["slb_internet"] = None
            __props__.__dict__["slb_intranet"] = None
            __props__.__dict__["vpc_id"] = None
            __props__.__dict__["worker_ram_role_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Kubernetes, __self__).__init__(
            'alicloud:cs/kubernetes:Kubernetes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addons: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubernetesAddonArgs']]]]] = None,
            api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            certificate_authority: Optional[pulumi.Input[pulumi.InputType['KubernetesCertificateAuthorityArgs']]] = None,
            client_cert: Optional[pulumi.Input[str]] = None,
            client_key: Optional[pulumi.Input[str]] = None,
            cluster_ca_cert: Optional[pulumi.Input[str]] = None,
            cluster_domain: Optional[pulumi.Input[str]] = None,
            connections: Optional[pulumi.Input[pulumi.InputType['KubernetesConnectionsArgs']]] = None,
            custom_san: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            enable_ssh: Optional[pulumi.Input[bool]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
            is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
            key_name: Optional[pulumi.Input[str]] = None,
            kms_encrypted_password: Optional[pulumi.Input[str]] = None,
            kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            load_balancer_spec: Optional[pulumi.Input[str]] = None,
            master_auto_renew: Optional[pulumi.Input[bool]] = None,
            master_auto_renew_period: Optional[pulumi.Input[int]] = None,
            master_disk_category: Optional[pulumi.Input[str]] = None,
            master_disk_performance_level: Optional[pulumi.Input[str]] = None,
            master_disk_size: Optional[pulumi.Input[int]] = None,
            master_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
            master_instance_charge_type: Optional[pulumi.Input[str]] = None,
            master_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            master_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubernetesMasterNodeArgs']]]]] = None,
            master_period: Optional[pulumi.Input[int]] = None,
            master_period_unit: Optional[pulumi.Input[str]] = None,
            master_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            nat_gateway_id: Optional[pulumi.Input[str]] = None,
            new_nat_gateway: Optional[pulumi.Input[bool]] = None,
            node_cidr_mask: Optional[pulumi.Input[int]] = None,
            node_name_mode: Optional[pulumi.Input[str]] = None,
            os_type: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            platform: Optional[pulumi.Input[str]] = None,
            pod_cidr: Optional[pulumi.Input[str]] = None,
            pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            proxy_mode: Optional[pulumi.Input[str]] = None,
            rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            runtime: Optional[pulumi.Input[pulumi.InputType['KubernetesRuntimeArgs']]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            service_account_issuer: Optional[pulumi.Input[str]] = None,
            service_cidr: Optional[pulumi.Input[str]] = None,
            slb_id: Optional[pulumi.Input[str]] = None,
            slb_internet: Optional[pulumi.Input[str]] = None,
            slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
            slb_intranet: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            user_ca: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            worker_ram_role_name: Optional[pulumi.Input[str]] = None) -> 'Kubernetes':
        """
        Get an existing Kubernetes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubernetesAddonArgs']]]] addons: The addon you want to install in cluster. See `addons` below.
               
               *Network params*
        :param pulumi.Input[Sequence[pulumi.Input[str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[pulumi.InputType['KubernetesCertificateAuthorityArgs']] certificate_authority: (Map, Available since v1.105.0) Nested attribute containing certificate authority data for your cluster.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
               
               *Removed params*
        :param pulumi.Input[str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input[pulumi.InputType['KubernetesConnectionsArgs']] connections: (Map) Map of kubernetes cluster connection information.
        :param pulumi.Input[str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] enable_ssh: Enable login to the node through SSH. Default to `false`.
        :param pulumi.Input[str] image_id: Custom Image support. Must based on CentOS7 or AliyunLinux2.
        :param pulumi.Input[bool] install_cloud_monitor: Install cloud monitor agent on ECS. Default to `true`.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        :param pulumi.Input[bool] master_auto_renew: Enable master payment auto-renew, defaults to false.
        :param pulumi.Input[int] master_auto_renew_period: Master payment auto-renew period, it can be one of {1, 2, 3, 6, 12}.
        :param pulumi.Input[str] master_disk_category: The system disk category of master node. Its valid value are `cloud_ssd`, `cloud_essd` and `cloud_efficiency`. Default to `cloud_efficiency`.
        :param pulumi.Input[str] master_disk_performance_level: Master node system disk performance level. When `master_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[int] master_disk_size: The system disk size of master node. Its valid value range [20~500] in GB. Default to 20.
        :param pulumi.Input[str] master_disk_snapshot_policy_id: Master node system disk auto snapshot policy.
               
               *Computed params*
        :param pulumi.Input[str] master_instance_charge_type: Master payment type. or `PostPaid` or `PrePaid`, defaults to `PostPaid`. If value is `PrePaid`, the files `master_period`, `master_period_unit`, `master_auto_renew` and `master_auto_renew_period` are required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] master_instance_types: The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubernetesMasterNodeArgs']]]] master_nodes: (Optional) The master nodes. See `master_nodes` below.
        :param pulumi.Input[int] master_period: Master payment period.Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        :param pulumi.Input[str] master_period_unit: Master payment period unit, the valid value is `Month`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] master_vswitch_ids: The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
        :param pulumi.Input[str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[str] nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Your cluster nodes and applications will have public network access. If there is a NAT gateway in the selected VPC, ACK will use this gateway by default; if there is no NAT gateway in the selected VPC, ACK will create a new NAT gateway for you and automatically configure SNAT rules.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] node_name_mode: Each node name consists of a prefix, an IP substring, and a suffix, the input format is `customized,<prefix>,IPSubStringLen,<suffix>`. For example "customized,aliyun.com-,5,-test", if the node IP address is 192.168.59.176, the prefix is aliyun.com-, IP substring length is 5, and the suffix is -test, the node name will be aliyun.com-59176-test.
        :param pulumi.Input[str] os_type: The operating system of the nodes that run pods, its valid value is either `Linux` or `Windows`. Default to `Linux`.
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[str] platform: The architecture of the nodes that run pods, its valid value is either `CentOS` or `AliyunLinux`. Default to `CentOS`.
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables | ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[pulumi.InputType['KubernetesRuntimeArgs']] runtime: The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). Detailed below.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[str] slb_id: (Deprecated) The ID of load balancer.
        :param pulumi.Input[str] slb_internet: The public ip of load balancer.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
               
               > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
               If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Master params*
        :param pulumi.Input[str] slb_intranet: The ID of private load balancer where the current cluster master node is located.
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        :param pulumi.Input[str] timezone: When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        :param pulumi.Input[str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        :param pulumi.Input[str] vpc_id: The ID of VPC where the current cluster is located.
        :param pulumi.Input[str] worker_ram_role_name: The RamRole Name attached to worker node.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesState.__new__(_KubernetesState)

        __props__.__dict__["addons"] = addons
        __props__.__dict__["api_audiences"] = api_audiences
        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["client_cert"] = client_cert
        __props__.__dict__["client_key"] = client_key
        __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
        __props__.__dict__["cluster_domain"] = cluster_domain
        __props__.__dict__["connections"] = connections
        __props__.__dict__["custom_san"] = custom_san
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["enable_ssh"] = enable_ssh
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["install_cloud_monitor"] = install_cloud_monitor
        __props__.__dict__["is_enterprise_security_group"] = is_enterprise_security_group
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
        __props__.__dict__["kms_encryption_context"] = kms_encryption_context
        __props__.__dict__["load_balancer_spec"] = load_balancer_spec
        __props__.__dict__["master_auto_renew"] = master_auto_renew
        __props__.__dict__["master_auto_renew_period"] = master_auto_renew_period
        __props__.__dict__["master_disk_category"] = master_disk_category
        __props__.__dict__["master_disk_performance_level"] = master_disk_performance_level
        __props__.__dict__["master_disk_size"] = master_disk_size
        __props__.__dict__["master_disk_snapshot_policy_id"] = master_disk_snapshot_policy_id
        __props__.__dict__["master_instance_charge_type"] = master_instance_charge_type
        __props__.__dict__["master_instance_types"] = master_instance_types
        __props__.__dict__["master_nodes"] = master_nodes
        __props__.__dict__["master_period"] = master_period
        __props__.__dict__["master_period_unit"] = master_period_unit
        __props__.__dict__["master_vswitch_ids"] = master_vswitch_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["new_nat_gateway"] = new_nat_gateway
        __props__.__dict__["node_cidr_mask"] = node_cidr_mask
        __props__.__dict__["node_name_mode"] = node_name_mode
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["password"] = password
        __props__.__dict__["platform"] = platform
        __props__.__dict__["pod_cidr"] = pod_cidr
        __props__.__dict__["pod_vswitch_ids"] = pod_vswitch_ids
        __props__.__dict__["proxy_mode"] = proxy_mode
        __props__.__dict__["rds_instances"] = rds_instances
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["retain_resources"] = retain_resources
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["service_account_issuer"] = service_account_issuer
        __props__.__dict__["service_cidr"] = service_cidr
        __props__.__dict__["slb_id"] = slb_id
        __props__.__dict__["slb_internet"] = slb_internet
        __props__.__dict__["slb_internet_enabled"] = slb_internet_enabled
        __props__.__dict__["slb_intranet"] = slb_intranet
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["user_ca"] = user_ca
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["worker_ram_role_name"] = worker_ram_role_name
        return Kubernetes(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addons(self) -> pulumi.Output[Optional[Sequence['outputs.KubernetesAddon']]]:
        """
        The addon you want to install in cluster. See `addons` below.

        *Network params*
        """
        return pulumi.get(self, "addons")

    @property
    @pulumi.getter(name="apiAudiences")
    def api_audiences(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "api_audiences")

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Output['outputs.KubernetesCertificateAuthority']:
        """
        (Map, Available since v1.105.0) Nested attribute containing certificate authority data for your cluster.
        """
        return pulumi.get(self, "certificate_authority")

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> pulumi.Output[Optional[str]]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> pulumi.Output[Optional[str]]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCert")
    def cluster_ca_cert(self) -> pulumi.Output[Optional[str]]:
        """
        The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> pulumi.Output[Optional[str]]:
        """
        Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        """
        return pulumi.get(self, "cluster_domain")

    @property
    @pulumi.getter
    def connections(self) -> pulumi.Output['outputs.KubernetesConnections']:
        """
        (Map) Map of kubernetes cluster connection information.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> pulumi.Output[Optional[str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        """
        return pulumi.get(self, "custom_san")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="enableSsh")
    def enable_ssh(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable login to the node through SSH. Default to `false`.
        """
        return pulumi.get(self, "enable_ssh")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        Custom Image support. Must based on CentOS7 or AliyunLinux2.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> pulumi.Output[Optional[bool]]:
        """
        Install cloud monitor agent on ECS. Default to `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> pulumi.Output[bool]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> pulumi.Output[Optional[str]]:
        """
        An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> pulumi.Output[Optional[str]]:
        """
        The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        """
        return pulumi.get(self, "load_balancer_spec")

    @property
    @pulumi.getter(name="masterAutoRenew")
    def master_auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable master payment auto-renew, defaults to false.
        """
        return pulumi.get(self, "master_auto_renew")

    @property
    @pulumi.getter(name="masterAutoRenewPeriod")
    def master_auto_renew_period(self) -> pulumi.Output[Optional[int]]:
        """
        Master payment auto-renew period, it can be one of {1, 2, 3, 6, 12}.
        """
        return pulumi.get(self, "master_auto_renew_period")

    @property
    @pulumi.getter(name="masterDiskCategory")
    def master_disk_category(self) -> pulumi.Output[Optional[str]]:
        """
        The system disk category of master node. Its valid value are `cloud_ssd`, `cloud_essd` and `cloud_efficiency`. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "master_disk_category")

    @property
    @pulumi.getter(name="masterDiskPerformanceLevel")
    def master_disk_performance_level(self) -> pulumi.Output[Optional[str]]:
        """
        Master node system disk performance level. When `master_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "master_disk_performance_level")

    @property
    @pulumi.getter(name="masterDiskSize")
    def master_disk_size(self) -> pulumi.Output[Optional[int]]:
        """
        The system disk size of master node. Its valid value range [20~500] in GB. Default to 20.
        """
        return pulumi.get(self, "master_disk_size")

    @property
    @pulumi.getter(name="masterDiskSnapshotPolicyId")
    def master_disk_snapshot_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        Master node system disk auto snapshot policy.

        *Computed params*
        """
        return pulumi.get(self, "master_disk_snapshot_policy_id")

    @property
    @pulumi.getter(name="masterInstanceChargeType")
    def master_instance_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        Master payment type. or `PostPaid` or `PrePaid`, defaults to `PostPaid`. If value is `PrePaid`, the files `master_period`, `master_period_unit`, `master_auto_renew` and `master_auto_renew_period` are required.
        """
        return pulumi.get(self, "master_instance_charge_type")

    @property
    @pulumi.getter(name="masterInstanceTypes")
    def master_instance_types(self) -> pulumi.Output[Sequence[str]]:
        """
        The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
        """
        return pulumi.get(self, "master_instance_types")

    @property
    @pulumi.getter(name="masterNodes")
    def master_nodes(self) -> pulumi.Output[Sequence['outputs.KubernetesMasterNode']]:
        """
        (Optional) The master nodes. See `master_nodes` below.
        """
        return pulumi.get(self, "master_nodes")

    @property
    @pulumi.getter(name="masterPeriod")
    def master_period(self) -> pulumi.Output[Optional[int]]:
        """
        Master payment period.Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        """
        return pulumi.get(self, "master_period")

    @property
    @pulumi.getter(name="masterPeriodUnit")
    def master_period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Master payment period unit, the valid value is `Month`.
        """
        return pulumi.get(self, "master_period_unit")

    @property
    @pulumi.getter(name="masterVswitchIds")
    def master_vswitch_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
        """
        return pulumi.get(self, "master_vswitch_ids")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[str]]:
        warnings.warn("""Field 'name_prefix' has been deprecated from provider version 1.75.0.""", DeprecationWarning)
        pulumi.log.warn("""name_prefix is deprecated: Field 'name_prefix' has been deprecated from provider version 1.75.0.""")

        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[str]:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Your cluster nodes and applications will have public network access. If there is a NAT gateway in the selected VPC, ACK will use this gateway by default; if there is no NAT gateway in the selected VPC, ACK will create a new NAT gateway for you and automatically configure SNAT rules.
        """
        return pulumi.get(self, "new_nat_gateway")

    @property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> pulumi.Output[Optional[int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @property
    @pulumi.getter(name="nodeNameMode")
    def node_name_mode(self) -> pulumi.Output[str]:
        """
        Each node name consists of a prefix, an IP substring, and a suffix, the input format is `customized,<prefix>,IPSubStringLen,<suffix>`. For example "customized,aliyun.com-,5,-test", if the node IP address is 192.168.59.176, the prefix is aliyun.com-, IP substring length is 5, and the suffix is -test, the node name will be aliyun.com-59176-test.
        """
        return pulumi.get(self, "node_name_mode")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[Optional[str]]:
        """
        The operating system of the nodes that run pods, its valid value is either `Linux` or `Windows`. Default to `Linux`.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[str]:
        """
        The architecture of the nodes that run pods, its valid value is either `CentOS` or `AliyunLinux`. Default to `CentOS`.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @property
    @pulumi.getter(name="podVswitchIds")
    def pod_vswitch_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        """
        return pulumi.get(self, "pod_vswitch_ids")

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables | ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "retain_resources")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[Optional['outputs.KubernetesRuntime']]:
        """
        The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). Detailed below.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="serviceAccountIssuer")
    def service_account_issuer(self) -> pulumi.Output[Optional[str]]:
        """
        The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "service_account_issuer")

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @property
    @pulumi.getter(name="slbId")
    def slb_id(self) -> pulumi.Output[str]:
        """
        (Deprecated) The ID of load balancer.
        """
        warnings.warn("""Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""", DeprecationWarning)
        pulumi.log.warn("""slb_id is deprecated: Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""")

        return pulumi.get(self, "slb_id")

    @property
    @pulumi.getter(name="slbInternet")
    def slb_internet(self) -> pulumi.Output[str]:
        """
        The public ip of load balancer.
        """
        return pulumi.get(self, "slb_internet")

    @property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.

        > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
        If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.

        *Master params*
        """
        return pulumi.get(self, "slb_internet_enabled")

    @property
    @pulumi.getter(name="slbIntranet")
    def slb_intranet(self) -> pulumi.Output[str]:
        """
        The ID of private load balancer where the current cluster master node is located.
        """
        return pulumi.get(self, "slb_intranet")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[str]]:
        """
        When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="userCa")
    def user_ca(self) -> pulumi.Output[Optional[str]]:
        """
        The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        """
        return pulumi.get(self, "user_ca")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="workerRamRoleName")
    def worker_ram_role_name(self) -> pulumi.Output[str]:
        """
        The RamRole Name attached to worker node.
        """
        return pulumi.get(self, "worker_ram_role_name")

