# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedKubernetesArgs', 'ManagedKubernetes']

@pulumi.input_type
class ManagedKubernetesArgs:
    def __init__(__self__, *,
                 worker_vswitch_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_domain: Optional[pulumi.Input[str]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 control_plane_log_components: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 control_plane_log_project: Optional[pulumi.Input[str]] = None,
                 control_plane_log_ttl: Optional[pulumi.Input[str]] = None,
                 custom_san: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[bool]] = None,
                 encryption_provider_key: Optional[pulumi.Input[str]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_account_issuer: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_ca: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ManagedKubernetes resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_vswitch_ids: The vswitches used by control plane.  See `worker_vswitch_ids` below.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
        :param pulumi.Input[str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input[str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard managed clusters.
               * ack.pro.small : Professional managed clusters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] control_plane_log_components: List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        :param pulumi.Input[str] control_plane_log_project: Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        :param pulumi.Input[str] control_plane_log_ttl: Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        :param pulumi.Input[str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] enable_rrsa: Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[str] encryption_provider_key: The disk encryption key.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        :param pulumi.Input['ManagedKubernetesMaintenanceWindowArgs'] maintenance_window: The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[str] name: This parameter specifies the name of the component.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
               
               > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
               If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        :param pulumi.Input[str] timezone: When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        :param pulumi.Input[str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[str] version: It specifies the version of the component.
        """
        pulumi.set(__self__, "worker_vswitch_ids", worker_vswitch_ids)
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if api_audiences is not None:
            pulumi.set(__self__, "api_audiences", api_audiences)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_domain is not None:
            pulumi.set(__self__, "cluster_domain", cluster_domain)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if control_plane_log_components is not None:
            pulumi.set(__self__, "control_plane_log_components", control_plane_log_components)
        if control_plane_log_project is not None:
            pulumi.set(__self__, "control_plane_log_project", control_plane_log_project)
        if control_plane_log_ttl is not None:
            pulumi.set(__self__, "control_plane_log_ttl", control_plane_log_ttl)
        if custom_san is not None:
            pulumi.set(__self__, "custom_san", custom_san)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_rrsa is not None:
            pulumi.set(__self__, "enable_rrsa", enable_rrsa)
        if encryption_provider_key is not None:
            pulumi.set(__self__, "encryption_provider_key", encryption_provider_key)
        if is_enterprise_security_group is not None:
            pulumi.set(__self__, "is_enterprise_security_group", is_enterprise_security_group)
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if node_cidr_mask is not None:
            pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if pod_vswitch_ids is not None:
            pulumi.set(__self__, "pod_vswitch_ids", pod_vswitch_ids)
        if proxy_mode is not None:
            pulumi.set(__self__, "proxy_mode", proxy_mode)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_account_issuer is not None:
            pulumi.set(__self__, "service_account_issuer", service_account_issuer)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if slb_internet_enabled is not None:
            pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_ca is not None:
            pulumi.set(__self__, "user_ca", user_ca)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="workerVswitchIds")
    def worker_vswitch_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The vswitches used by control plane.  See `worker_vswitch_ids` below.
        """
        return pulumi.get(self, "worker_vswitch_ids")

    @worker_vswitch_ids.setter
    def worker_vswitch_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "worker_vswitch_ids", value)

    @property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]]:
        """
        The addon you want to install in cluster. See `addons` below.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @property
    @pulumi.getter(name="apiAudiences")
    def api_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "api_audiences")

    @api_audiences.setter
    def api_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "api_audiences", value)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="clusterCaCert")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        """
        return pulumi.get(self, "cluster_domain")

    @cluster_domain.setter
    def cluster_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_domain", value)

    @property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Standard managed clusters.
        * ack.pro.small : Professional managed clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_spec", value)

    @property
    @pulumi.getter(name="controlPlaneLogComponents")
    def control_plane_log_components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        """
        return pulumi.get(self, "control_plane_log_components")

    @control_plane_log_components.setter
    def control_plane_log_components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "control_plane_log_components", value)

    @property
    @pulumi.getter(name="controlPlaneLogProject")
    def control_plane_log_project(self) -> Optional[pulumi.Input[str]]:
        """
        Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        """
        return pulumi.get(self, "control_plane_log_project")

    @control_plane_log_project.setter
    def control_plane_log_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control_plane_log_project", value)

    @property
    @pulumi.getter(name="controlPlaneLogTtl")
    def control_plane_log_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        """
        return pulumi.get(self, "control_plane_log_ttl")

    @control_plane_log_ttl.setter
    def control_plane_log_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control_plane_log_ttl", value)

    @property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> Optional[pulumi.Input[str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        """
        return pulumi.get(self, "custom_san")

    @custom_san.setter
    def custom_san(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_san", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="enableRrsa")
    def enable_rrsa(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        """
        return pulumi.get(self, "enable_rrsa")

    @enable_rrsa.setter
    def enable_rrsa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_rrsa", value)

    @property
    @pulumi.getter(name="encryptionProviderKey")
    def encryption_provider_key(self) -> Optional[pulumi.Input[str]]:
        """
        The disk encryption key.
        """
        return pulumi.get(self, "encryption_provider_key")

    @encryption_provider_key.setter
    def encryption_provider_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_provider_key", value)

    @property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @is_enterprise_security_group.setter
    def is_enterprise_security_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enterprise_security_group", value)

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']]:
        """
        The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter specifies the name of the component.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> Optional[pulumi.Input[int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @node_cidr_mask.setter
    def node_cidr_mask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_cidr_mask", value)

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_cidr", value)

    @property
    @pulumi.getter(name="podVswitchIds")
    def pod_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        """
        return pulumi.get(self, "pod_vswitch_ids")

    @pod_vswitch_ids.setter
    def pod_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pod_vswitch_ids", value)

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @proxy_mode.setter
    def proxy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_mode", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retain_resources", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="serviceAccountIssuer")
    def service_account_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "service_account_issuer")

    @service_account_issuer.setter
    def service_account_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_issuer", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.

        > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
        If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @slb_internet_enabled.setter
    def slb_internet_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "slb_internet_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="userCa")
    def user_ca(self) -> Optional[pulumi.Input[str]]:
        """
        The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        """
        return pulumi.get(self, "user_ca")

    @user_ca.setter
    def user_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_ca", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        It specifies the version of the component.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _ManagedKubernetesState:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 certificate_authority: Optional[pulumi.Input['ManagedKubernetesCertificateAuthorityArgs']] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_domain: Optional[pulumi.Input[str]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 connections: Optional[pulumi.Input['ManagedKubernetesConnectionsArgs']] = None,
                 control_plane_log_components: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 control_plane_log_project: Optional[pulumi.Input[str]] = None,
                 control_plane_log_ttl: Optional[pulumi.Input[str]] = None,
                 custom_san: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[bool]] = None,
                 encryption_provider_key: Optional[pulumi.Input[str]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rrsa_metadata: Optional[pulumi.Input['ManagedKubernetesRrsaMetadataArgs']] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_account_issuer: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_id: Optional[pulumi.Input[str]] = None,
                 slb_internet: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 slb_intranet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_ca: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 worker_ram_role_name: Optional[pulumi.Input[str]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ManagedKubernetes resources.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input['ManagedKubernetesCertificateAuthorityArgs'] certificate_authority: (Available in 1.105.0+) Nested attribute containing certificate authority data for your cluster.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
        :param pulumi.Input[str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input[str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard managed clusters.
               * ack.pro.small : Professional managed clusters.
        :param pulumi.Input['ManagedKubernetesConnectionsArgs'] connections: Map of kubernetes cluster connection information.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] control_plane_log_components: List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        :param pulumi.Input[str] control_plane_log_project: Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        :param pulumi.Input[str] control_plane_log_ttl: Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        :param pulumi.Input[str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] enable_rrsa: Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[str] encryption_provider_key: The disk encryption key.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        :param pulumi.Input['ManagedKubernetesMaintenanceWindowArgs'] maintenance_window: The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[str] name: This parameter specifies the name of the component.
        :param pulumi.Input[str] nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input['ManagedKubernetesRrsaMetadataArgs'] rrsa_metadata: (Optional, Available in v1.185.0+) Nested attribute containing RRSA related data for your cluster.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[str] slb_id: (Deprecated) The ID of load balancer.
        :param pulumi.Input[str] slb_internet: The public ip of load balancer.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
               
               > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
               If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
        :param pulumi.Input[str] slb_intranet: The ID of private load balancer where the current cluster master node is located.
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        :param pulumi.Input[str] timezone: When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        :param pulumi.Input[str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[str] version: It specifies the version of the component.
        :param pulumi.Input[str] vpc_id: The ID of VPC where the current cluster is located.
        :param pulumi.Input[str] worker_ram_role_name: The RamRole Name attached to worker node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_vswitch_ids: The vswitches used by control plane.  See `worker_vswitch_ids` below.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if api_audiences is not None:
            pulumi.set(__self__, "api_audiences", api_audiences)
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_domain is not None:
            pulumi.set(__self__, "cluster_domain", cluster_domain)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if control_plane_log_components is not None:
            pulumi.set(__self__, "control_plane_log_components", control_plane_log_components)
        if control_plane_log_project is not None:
            pulumi.set(__self__, "control_plane_log_project", control_plane_log_project)
        if control_plane_log_ttl is not None:
            pulumi.set(__self__, "control_plane_log_ttl", control_plane_log_ttl)
        if custom_san is not None:
            pulumi.set(__self__, "custom_san", custom_san)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_rrsa is not None:
            pulumi.set(__self__, "enable_rrsa", enable_rrsa)
        if encryption_provider_key is not None:
            pulumi.set(__self__, "encryption_provider_key", encryption_provider_key)
        if is_enterprise_security_group is not None:
            pulumi.set(__self__, "is_enterprise_security_group", is_enterprise_security_group)
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if node_cidr_mask is not None:
            pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if pod_vswitch_ids is not None:
            pulumi.set(__self__, "pod_vswitch_ids", pod_vswitch_ids)
        if proxy_mode is not None:
            pulumi.set(__self__, "proxy_mode", proxy_mode)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if rrsa_metadata is not None:
            pulumi.set(__self__, "rrsa_metadata", rrsa_metadata)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_account_issuer is not None:
            pulumi.set(__self__, "service_account_issuer", service_account_issuer)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if slb_id is not None:
            warnings.warn("""Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""slb_id is deprecated: Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""")
        if slb_id is not None:
            pulumi.set(__self__, "slb_id", slb_id)
        if slb_internet is not None:
            pulumi.set(__self__, "slb_internet", slb_internet)
        if slb_internet_enabled is not None:
            pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        if slb_intranet is not None:
            pulumi.set(__self__, "slb_intranet", slb_intranet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_ca is not None:
            pulumi.set(__self__, "user_ca", user_ca)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if worker_ram_role_name is not None:
            pulumi.set(__self__, "worker_ram_role_name", worker_ram_role_name)
        if worker_vswitch_ids is not None:
            pulumi.set(__self__, "worker_vswitch_ids", worker_vswitch_ids)

    @property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]]:
        """
        The addon you want to install in cluster. See `addons` below.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @property
    @pulumi.getter(name="apiAudiences")
    def api_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "api_audiences")

    @api_audiences.setter
    def api_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "api_audiences", value)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input['ManagedKubernetesCertificateAuthorityArgs']]:
        """
        (Available in 1.105.0+) Nested attribute containing certificate authority data for your cluster.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input['ManagedKubernetesCertificateAuthorityArgs']]):
        pulumi.set(self, "certificate_authority", value)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="clusterCaCert")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        """
        return pulumi.get(self, "cluster_domain")

    @cluster_domain.setter
    def cluster_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_domain", value)

    @property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Standard managed clusters.
        * ack.pro.small : Professional managed clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_spec", value)

    @property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input['ManagedKubernetesConnectionsArgs']]:
        """
        Map of kubernetes cluster connection information.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input['ManagedKubernetesConnectionsArgs']]):
        pulumi.set(self, "connections", value)

    @property
    @pulumi.getter(name="controlPlaneLogComponents")
    def control_plane_log_components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        """
        return pulumi.get(self, "control_plane_log_components")

    @control_plane_log_components.setter
    def control_plane_log_components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "control_plane_log_components", value)

    @property
    @pulumi.getter(name="controlPlaneLogProject")
    def control_plane_log_project(self) -> Optional[pulumi.Input[str]]:
        """
        Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        """
        return pulumi.get(self, "control_plane_log_project")

    @control_plane_log_project.setter
    def control_plane_log_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control_plane_log_project", value)

    @property
    @pulumi.getter(name="controlPlaneLogTtl")
    def control_plane_log_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        """
        return pulumi.get(self, "control_plane_log_ttl")

    @control_plane_log_ttl.setter
    def control_plane_log_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control_plane_log_ttl", value)

    @property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> Optional[pulumi.Input[str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        """
        return pulumi.get(self, "custom_san")

    @custom_san.setter
    def custom_san(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_san", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="enableRrsa")
    def enable_rrsa(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        """
        return pulumi.get(self, "enable_rrsa")

    @enable_rrsa.setter
    def enable_rrsa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_rrsa", value)

    @property
    @pulumi.getter(name="encryptionProviderKey")
    def encryption_provider_key(self) -> Optional[pulumi.Input[str]]:
        """
        The disk encryption key.
        """
        return pulumi.get(self, "encryption_provider_key")

    @encryption_provider_key.setter
    def encryption_provider_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_provider_key", value)

    @property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @is_enterprise_security_group.setter
    def is_enterprise_security_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enterprise_security_group", value)

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']]:
        """
        The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter specifies the name of the component.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> Optional[pulumi.Input[int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @node_cidr_mask.setter
    def node_cidr_mask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_cidr_mask", value)

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_cidr", value)

    @property
    @pulumi.getter(name="podVswitchIds")
    def pod_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        """
        return pulumi.get(self, "pod_vswitch_ids")

    @pod_vswitch_ids.setter
    def pod_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pod_vswitch_ids", value)

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @proxy_mode.setter
    def proxy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_mode", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retain_resources", value)

    @property
    @pulumi.getter(name="rrsaMetadata")
    def rrsa_metadata(self) -> Optional[pulumi.Input['ManagedKubernetesRrsaMetadataArgs']]:
        """
        (Optional, Available in v1.185.0+) Nested attribute containing RRSA related data for your cluster.
        """
        return pulumi.get(self, "rrsa_metadata")

    @rrsa_metadata.setter
    def rrsa_metadata(self, value: Optional[pulumi.Input['ManagedKubernetesRrsaMetadataArgs']]):
        pulumi.set(self, "rrsa_metadata", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="serviceAccountIssuer")
    def service_account_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "service_account_issuer")

    @service_account_issuer.setter
    def service_account_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_issuer", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="slbId")
    def slb_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Deprecated) The ID of load balancer.
        """
        warnings.warn("""Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""", DeprecationWarning)
        pulumi.log.warn("""slb_id is deprecated: Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""")

        return pulumi.get(self, "slb_id")

    @slb_id.setter
    def slb_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slb_id", value)

    @property
    @pulumi.getter(name="slbInternet")
    def slb_internet(self) -> Optional[pulumi.Input[str]]:
        """
        The public ip of load balancer.
        """
        return pulumi.get(self, "slb_internet")

    @slb_internet.setter
    def slb_internet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slb_internet", value)

    @property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.

        > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
        If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @slb_internet_enabled.setter
    def slb_internet_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "slb_internet_enabled", value)

    @property
    @pulumi.getter(name="slbIntranet")
    def slb_intranet(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of private load balancer where the current cluster master node is located.
        """
        return pulumi.get(self, "slb_intranet")

    @slb_intranet.setter
    def slb_intranet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slb_intranet", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="userCa")
    def user_ca(self) -> Optional[pulumi.Input[str]]:
        """
        The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        """
        return pulumi.get(self, "user_ca")

    @user_ca.setter
    def user_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_ca", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        It specifies the version of the component.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="workerRamRoleName")
    def worker_ram_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The RamRole Name attached to worker node.
        """
        return pulumi.get(self, "worker_ram_role_name")

    @worker_ram_role_name.setter
    def worker_ram_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_ram_role_name", value)

    @property
    @pulumi.getter(name="workerVswitchIds")
    def worker_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The vswitches used by control plane.  See `worker_vswitch_ids` below.
        """
        return pulumi.get(self, "worker_vswitch_ids")

    @worker_vswitch_ids.setter
    def worker_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "worker_vswitch_ids", value)


class ManagedKubernetes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedKubernetesAddonArgs']]]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_domain: Optional[pulumi.Input[str]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 control_plane_log_components: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 control_plane_log_project: Optional[pulumi.Input[str]] = None,
                 control_plane_log_ttl: Optional[pulumi.Input[str]] = None,
                 custom_san: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[bool]] = None,
                 encryption_provider_key: Optional[pulumi.Input[str]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[pulumi.InputType['ManagedKubernetesMaintenanceWindowArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_account_issuer: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_ca: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource will help you to manage a ManagedKubernetes Cluster in Alibaba Cloud Kubernetes Service.

        > **NOTE:** Available since v1.26.0.

        > **NOTE:** It is recommended to create a cluster with zero worker nodes, and then use a node pool to manage the cluster nodes.

        > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.

        > **NOTE:** From version 1.9.4, the provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** From version 1.20.0, the provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.

        > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
        Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).

        > **NOTE:** From version 1.72.0, Some parameters have been removed from resource,You can check them below and re-import the cluster if necessary.

        > **NOTE:** From version 1.120.0, Support for cluster migration from Standard cluster to professional.

        > **NOTE:** From version 1.177.0+, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor` are deprecated.
        We Suggest you using resource **`cs.NodePool`** to manage your cluster worker nodes.

        > **NOTE:** From version 1.212.0, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor`,`kube_config`,`availability_zone` are removed.
        Please use resource **`cs.NodePool`** to manage your cluster worker nodes.

        ## Import

        Kubernetes managed cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
         $ pulumi import alicloud:cs/managedKubernetes:ManagedKubernetes main cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedKubernetesAddonArgs']]]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
        :param pulumi.Input[str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input[str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard managed clusters.
               * ack.pro.small : Professional managed clusters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] control_plane_log_components: List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        :param pulumi.Input[str] control_plane_log_project: Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        :param pulumi.Input[str] control_plane_log_ttl: Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        :param pulumi.Input[str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] enable_rrsa: Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[str] encryption_provider_key: The disk encryption key.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        :param pulumi.Input[pulumi.InputType['ManagedKubernetesMaintenanceWindowArgs']] maintenance_window: The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[str] name: This parameter specifies the name of the component.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
               
               > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
               If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        :param pulumi.Input[str] timezone: When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        :param pulumi.Input[str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[str] version: It specifies the version of the component.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_vswitch_ids: The vswitches used by control plane.  See `worker_vswitch_ids` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedKubernetesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource will help you to manage a ManagedKubernetes Cluster in Alibaba Cloud Kubernetes Service.

        > **NOTE:** Available since v1.26.0.

        > **NOTE:** It is recommended to create a cluster with zero worker nodes, and then use a node pool to manage the cluster nodes.

        > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.

        > **NOTE:** From version 1.9.4, the provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** From version 1.20.0, the provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.

        > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
        Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).

        > **NOTE:** From version 1.72.0, Some parameters have been removed from resource,You can check them below and re-import the cluster if necessary.

        > **NOTE:** From version 1.120.0, Support for cluster migration from Standard cluster to professional.

        > **NOTE:** From version 1.177.0+, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor` are deprecated.
        We Suggest you using resource **`cs.NodePool`** to manage your cluster worker nodes.

        > **NOTE:** From version 1.212.0, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor`,`kube_config`,`availability_zone` are removed.
        Please use resource **`cs.NodePool`** to manage your cluster worker nodes.

        ## Import

        Kubernetes managed cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
         $ pulumi import alicloud:cs/managedKubernetes:ManagedKubernetes main cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param ManagedKubernetesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedKubernetesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedKubernetesAddonArgs']]]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[str]] = None,
                 cluster_domain: Optional[pulumi.Input[str]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 control_plane_log_components: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 control_plane_log_project: Optional[pulumi.Input[str]] = None,
                 control_plane_log_ttl: Optional[pulumi.Input[str]] = None,
                 custom_san: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[bool]] = None,
                 encryption_provider_key: Optional[pulumi.Input[str]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[pulumi.InputType['ManagedKubernetesMaintenanceWindowArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[int]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proxy_mode: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 service_account_issuer: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_ca: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedKubernetesArgs.__new__(ManagedKubernetesArgs)

            __props__.__dict__["addons"] = addons
            __props__.__dict__["api_audiences"] = api_audiences
            __props__.__dict__["client_cert"] = client_cert
            __props__.__dict__["client_key"] = client_key
            __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
            __props__.__dict__["cluster_domain"] = cluster_domain
            __props__.__dict__["cluster_spec"] = cluster_spec
            __props__.__dict__["control_plane_log_components"] = control_plane_log_components
            __props__.__dict__["control_plane_log_project"] = control_plane_log_project
            __props__.__dict__["control_plane_log_ttl"] = control_plane_log_ttl
            __props__.__dict__["custom_san"] = custom_san
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["enable_rrsa"] = enable_rrsa
            __props__.__dict__["encryption_provider_key"] = encryption_provider_key
            __props__.__dict__["is_enterprise_security_group"] = is_enterprise_security_group
            __props__.__dict__["load_balancer_spec"] = load_balancer_spec
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["new_nat_gateway"] = new_nat_gateway
            __props__.__dict__["node_cidr_mask"] = node_cidr_mask
            __props__.__dict__["pod_cidr"] = pod_cidr
            __props__.__dict__["pod_vswitch_ids"] = pod_vswitch_ids
            __props__.__dict__["proxy_mode"] = proxy_mode
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["retain_resources"] = retain_resources
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["service_account_issuer"] = service_account_issuer
            __props__.__dict__["service_cidr"] = service_cidr
            __props__.__dict__["slb_internet_enabled"] = slb_internet_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["user_ca"] = user_ca
            __props__.__dict__["version"] = version
            if worker_vswitch_ids is None and not opts.urn:
                raise TypeError("Missing required property 'worker_vswitch_ids'")
            __props__.__dict__["worker_vswitch_ids"] = worker_vswitch_ids
            __props__.__dict__["certificate_authority"] = None
            __props__.__dict__["connections"] = None
            __props__.__dict__["nat_gateway_id"] = None
            __props__.__dict__["rrsa_metadata"] = None
            __props__.__dict__["slb_id"] = None
            __props__.__dict__["slb_internet"] = None
            __props__.__dict__["slb_intranet"] = None
            __props__.__dict__["vpc_id"] = None
            __props__.__dict__["worker_ram_role_name"] = None
        super(ManagedKubernetes, __self__).__init__(
            'alicloud:cs/managedKubernetes:ManagedKubernetes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addons: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedKubernetesAddonArgs']]]]] = None,
            api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            certificate_authority: Optional[pulumi.Input[pulumi.InputType['ManagedKubernetesCertificateAuthorityArgs']]] = None,
            client_cert: Optional[pulumi.Input[str]] = None,
            client_key: Optional[pulumi.Input[str]] = None,
            cluster_ca_cert: Optional[pulumi.Input[str]] = None,
            cluster_domain: Optional[pulumi.Input[str]] = None,
            cluster_spec: Optional[pulumi.Input[str]] = None,
            connections: Optional[pulumi.Input[pulumi.InputType['ManagedKubernetesConnectionsArgs']]] = None,
            control_plane_log_components: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            control_plane_log_project: Optional[pulumi.Input[str]] = None,
            control_plane_log_ttl: Optional[pulumi.Input[str]] = None,
            custom_san: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            enable_rrsa: Optional[pulumi.Input[bool]] = None,
            encryption_provider_key: Optional[pulumi.Input[str]] = None,
            is_enterprise_security_group: Optional[pulumi.Input[bool]] = None,
            load_balancer_spec: Optional[pulumi.Input[str]] = None,
            maintenance_window: Optional[pulumi.Input[pulumi.InputType['ManagedKubernetesMaintenanceWindowArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            nat_gateway_id: Optional[pulumi.Input[str]] = None,
            new_nat_gateway: Optional[pulumi.Input[bool]] = None,
            node_cidr_mask: Optional[pulumi.Input[int]] = None,
            pod_cidr: Optional[pulumi.Input[str]] = None,
            pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            proxy_mode: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rrsa_metadata: Optional[pulumi.Input[pulumi.InputType['ManagedKubernetesRrsaMetadataArgs']]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            service_account_issuer: Optional[pulumi.Input[str]] = None,
            service_cidr: Optional[pulumi.Input[str]] = None,
            slb_id: Optional[pulumi.Input[str]] = None,
            slb_internet: Optional[pulumi.Input[str]] = None,
            slb_internet_enabled: Optional[pulumi.Input[bool]] = None,
            slb_intranet: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            user_ca: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            worker_ram_role_name: Optional[pulumi.Input[str]] = None,
            worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ManagedKubernetes':
        """
        Get an existing ManagedKubernetes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedKubernetesAddonArgs']]]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[pulumi.InputType['ManagedKubernetesCertificateAuthorityArgs']] certificate_authority: (Available in 1.105.0+) Nested attribute containing certificate authority data for your cluster.
        :param pulumi.Input[str] client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param pulumi.Input[str] client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param pulumi.Input[str] cluster_ca_cert: The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
        :param pulumi.Input[str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input[str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard managed clusters.
               * ack.pro.small : Professional managed clusters.
        :param pulumi.Input[pulumi.InputType['ManagedKubernetesConnectionsArgs']] connections: Map of kubernetes cluster connection information.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] control_plane_log_components: List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        :param pulumi.Input[str] control_plane_log_project: Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        :param pulumi.Input[str] control_plane_log_ttl: Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        :param pulumi.Input[str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        :param pulumi.Input[bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[bool] enable_rrsa: Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[str] encryption_provider_key: The disk encryption key.
        :param pulumi.Input[bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        :param pulumi.Input[pulumi.InputType['ManagedKubernetesMaintenanceWindowArgs']] maintenance_window: The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[str] name: This parameter specifies the name of the component.
        :param pulumi.Input[str] nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param pulumi.Input[bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        :param pulumi.Input[str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[pulumi.InputType['ManagedKubernetesRrsaMetadataArgs']] rrsa_metadata: (Optional, Available in v1.185.0+) Nested attribute containing RRSA related data for your cluster.
        :param pulumi.Input[str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[str] slb_id: (Deprecated) The ID of load balancer.
        :param pulumi.Input[str] slb_internet: The public ip of load balancer.
        :param pulumi.Input[bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
               
               > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
               If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
        :param pulumi.Input[str] slb_intranet: The ID of private load balancer where the current cluster master node is located.
        :param pulumi.Input[Mapping[str, Any]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        :param pulumi.Input[str] timezone: When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        :param pulumi.Input[str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[str] version: It specifies the version of the component.
        :param pulumi.Input[str] vpc_id: The ID of VPC where the current cluster is located.
        :param pulumi.Input[str] worker_ram_role_name: The RamRole Name attached to worker node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] worker_vswitch_ids: The vswitches used by control plane.  See `worker_vswitch_ids` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedKubernetesState.__new__(_ManagedKubernetesState)

        __props__.__dict__["addons"] = addons
        __props__.__dict__["api_audiences"] = api_audiences
        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["client_cert"] = client_cert
        __props__.__dict__["client_key"] = client_key
        __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
        __props__.__dict__["cluster_domain"] = cluster_domain
        __props__.__dict__["cluster_spec"] = cluster_spec
        __props__.__dict__["connections"] = connections
        __props__.__dict__["control_plane_log_components"] = control_plane_log_components
        __props__.__dict__["control_plane_log_project"] = control_plane_log_project
        __props__.__dict__["control_plane_log_ttl"] = control_plane_log_ttl
        __props__.__dict__["custom_san"] = custom_san
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["enable_rrsa"] = enable_rrsa
        __props__.__dict__["encryption_provider_key"] = encryption_provider_key
        __props__.__dict__["is_enterprise_security_group"] = is_enterprise_security_group
        __props__.__dict__["load_balancer_spec"] = load_balancer_spec
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["new_nat_gateway"] = new_nat_gateway
        __props__.__dict__["node_cidr_mask"] = node_cidr_mask
        __props__.__dict__["pod_cidr"] = pod_cidr
        __props__.__dict__["pod_vswitch_ids"] = pod_vswitch_ids
        __props__.__dict__["proxy_mode"] = proxy_mode
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["retain_resources"] = retain_resources
        __props__.__dict__["rrsa_metadata"] = rrsa_metadata
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["service_account_issuer"] = service_account_issuer
        __props__.__dict__["service_cidr"] = service_cidr
        __props__.__dict__["slb_id"] = slb_id
        __props__.__dict__["slb_internet"] = slb_internet
        __props__.__dict__["slb_internet_enabled"] = slb_internet_enabled
        __props__.__dict__["slb_intranet"] = slb_intranet
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["user_ca"] = user_ca
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["worker_ram_role_name"] = worker_ram_role_name
        __props__.__dict__["worker_vswitch_ids"] = worker_vswitch_ids
        return ManagedKubernetes(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addons(self) -> pulumi.Output[Optional[Sequence['outputs.ManagedKubernetesAddon']]]:
        """
        The addon you want to install in cluster. See `addons` below.
        """
        return pulumi.get(self, "addons")

    @property
    @pulumi.getter(name="apiAudiences")
    def api_audiences(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "api_audiences")

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Output['outputs.ManagedKubernetesCertificateAuthority']:
        """
        (Available in 1.105.0+) Nested attribute containing certificate authority data for your cluster.
        """
        return pulumi.get(self, "certificate_authority")

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> pulumi.Output[Optional[str]]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> pulumi.Output[Optional[str]]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCert")
    def cluster_ca_cert(self) -> pulumi.Output[Optional[str]]:
        """
        The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
        """
        return pulumi.get(self, "cluster_ca_cert")

    @property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> pulumi.Output[Optional[str]]:
        """
        Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        """
        return pulumi.get(self, "cluster_domain")

    @property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> pulumi.Output[str]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Standard managed clusters.
        * ack.pro.small : Professional managed clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @property
    @pulumi.getter
    def connections(self) -> pulumi.Output['outputs.ManagedKubernetesConnections']:
        """
        Map of kubernetes cluster connection information.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter(name="controlPlaneLogComponents")
    def control_plane_log_components(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        """
        return pulumi.get(self, "control_plane_log_components")

    @property
    @pulumi.getter(name="controlPlaneLogProject")
    def control_plane_log_project(self) -> pulumi.Output[str]:
        """
        Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        """
        return pulumi.get(self, "control_plane_log_project")

    @property
    @pulumi.getter(name="controlPlaneLogTtl")
    def control_plane_log_ttl(self) -> pulumi.Output[str]:
        """
        Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        """
        return pulumi.get(self, "control_plane_log_ttl")

    @property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> pulumi.Output[Optional[str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        """
        return pulumi.get(self, "custom_san")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="enableRrsa")
    def enable_rrsa(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        """
        return pulumi.get(self, "enable_rrsa")

    @property
    @pulumi.getter(name="encryptionProviderKey")
    def encryption_provider_key(self) -> pulumi.Output[Optional[str]]:
        """
        The disk encryption key.
        """
        return pulumi.get(self, "encryption_provider_key")

    @property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> pulumi.Output[bool]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> pulumi.Output[Optional[str]]:
        """
        The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        """
        return pulumi.get(self, "load_balancer_spec")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.ManagedKubernetesMaintenanceWindow']:
        """
        The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        This parameter specifies the name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[str]:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        """
        return pulumi.get(self, "new_nat_gateway")

    @property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> pulumi.Output[Optional[int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @property
    @pulumi.getter(name="podVswitchIds")
    def pod_vswitch_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        [Terway Specific] The vswitches for the pod network when using Terway.Be careful the `pod_vswitch_ids` can not equal to `worker_vswitch_ids` or `master_vswitch_ids` but must be in same availability zones.
        """
        return pulumi.get(self, "pod_vswitch_ids")

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "retain_resources")

    @property
    @pulumi.getter(name="rrsaMetadata")
    def rrsa_metadata(self) -> pulumi.Output['outputs.ManagedKubernetesRrsaMetadata']:
        """
        (Optional, Available in v1.185.0+) Nested attribute containing RRSA related data for your cluster.
        """
        return pulumi.get(self, "rrsa_metadata")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="serviceAccountIssuer")
    def service_account_issuer(self) -> pulumi.Output[Optional[str]]:
        """
        The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "service_account_issuer")

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @property
    @pulumi.getter(name="slbId")
    def slb_id(self) -> pulumi.Output[str]:
        """
        (Deprecated) The ID of load balancer.
        """
        warnings.warn("""Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""", DeprecationWarning)
        pulumi.log.warn("""slb_id is deprecated: Field 'slb_id' has been deprecated from provider version 1.9.2. New field 'slb_internet' replaces it.""")

        return pulumi.get(self, "slb_id")

    @property
    @pulumi.getter(name="slbInternet")
    def slb_internet(self) -> pulumi.Output[str]:
        """
        The public ip of load balancer.
        """
        return pulumi.get(self, "slb_internet")

    @property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.

        > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specific the `pod_vswitch_ids` field and addons with `terway-eniip`.
        If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @property
    @pulumi.getter(name="slbIntranet")
    def slb_intranet(self) -> pulumi.Output[str]:
        """
        The ID of private load balancer where the current cluster master node is located.
        """
        return pulumi.get(self, "slb_intranet")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[str]]:
        """
        When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="userCa")
    def user_ca(self) -> pulumi.Output[Optional[str]]:
        """
        The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        """
        return pulumi.get(self, "user_ca")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        It specifies the version of the component.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="workerRamRoleName")
    def worker_ram_role_name(self) -> pulumi.Output[str]:
        """
        The RamRole Name attached to worker node.
        """
        return pulumi.get(self, "worker_ram_role_name")

    @property
    @pulumi.getter(name="workerVswitchIds")
    def worker_vswitch_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The vswitches used by control plane.  See `worker_vswitch_ids` below.
        """
        return pulumi.get(self, "worker_vswitch_ids")

