# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodePoolArgs', 'NodePool']

@pulumi.input_type
class NodePoolArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 instance_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vswitch_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cis_enabled: Optional[pulumi.Input[bool]] = None,
                 cpu_policy: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 desired_size: Optional[pulumi.Input[int]] = None,
                 format_disk: Optional[pulumi.Input[bool]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 keep_instance_name: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kubelet_configuration: Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]] = None,
                 management: Optional[pulumi.Input['NodePoolManagementArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_name_mode: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 polardb_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 rolling_policy: Optional[pulumi.Input['NodePoolRollingPolicyArgs']] = None,
                 rollout_policy: Optional[pulumi.Input['NodePoolRolloutPolicyArgs']] = None,
                 runtime_name: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 scaling_config: Optional[pulumi.Input['NodePoolScalingConfigArgs']] = None,
                 scaling_policy: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 soc_enabled: Optional[pulumi.Input[bool]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 system_disk_kms_key: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 system_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]] = None,
                 unschedulable: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NodePool resource.
        :param pulumi.Input[str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: The instance type of worker node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: The vswitches used by node pool workers.
        :param pulumi.Input[bool] auto_renew: Enable Node payment auto-renew, default is `false`.
        :param pulumi.Input[int] auto_renew_period: Node payment auto-renew period, one of `1`, `2`, `3`,`6`, `12`.
        :param pulumi.Input[bool] cis_enabled: Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [CIS Reinforcement](https://help.aliyun.com/document_detail/223744.html).
        :param pulumi.Input[str] cpu_policy: Kubelet cpu policy. For Kubernetes 1.12.6 and later, its valid value is either `static` or `none`. Default to `none` and modification is not supported.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]] data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `data_disks` below.
        :param pulumi.Input[str] deployment_set_id: The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        :param pulumi.Input[int] desired_size: The desired size of nodes of the node pool. From version 1.158.0, `desired_size` is not required.
        :param pulumi.Input[bool] format_disk: After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        :param pulumi.Input[str] image_id: Custom Image support. Must based on CentOS7 or AliyunLinux2.
        :param pulumi.Input[str] image_type: The image type, instead of `platform`. This field cannot be modified. One of `AliyunLinux`, `AliyunLinux3`, `AliyunLinux3Arm64`, `AliyunLinuxUEFI`, `CentOS`, `Windows`,`WindowsCore`,`AliyunLinux Qboot`,`ContainerOS`. If you select `Windows` or `WindowsCore`, the `passord` is required.
        :param pulumi.Input[bool] install_cloud_monitor: Install the cloud monitoring plug-in on the node, and you can view the monitoring information of the instance through the cloud monitoring console. Default is `true`.
        :param pulumi.Input[str] instance_charge_type: Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: The instance list. Add existing nodes under the same cluster VPC to the node pool.
        :param pulumi.Input[str] internet_charge_type: The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        :param pulumi.Input[int] internet_max_bandwidth_out: The maximum outbound bandwidth for the public network. Unit: Mbit/s. Valid values: 0 to 100.
        :param pulumi.Input[bool] keep_instance_name: Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields. Only `key_name` is supported in the management node pool.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input['NodePoolKubeletConfigurationArgs'] kubelet_configuration: Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/).
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]] labels: A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        :param pulumi.Input['NodePoolManagementArgs'] management: Managed node pool configuration. When using a managed node pool, the node key must use `key_name`. See `management` below.
        :param pulumi.Input[str] name: The name of node pool.
        :param pulumi.Input[int] node_count: The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        :param pulumi.Input[str] node_name_mode: Each node name consists of a prefix, its private network IP, and a suffix, the input format is `customized,<prefix>,ip,<suffix>`. For example "customized,aliyun.com-,ip,-test", if the node private network IP address is 192.168.59.176, the prefix is aliyun.com-,and the suffix is -test, the node name will be aliyun.com-192.168.59.176-test.
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[int] period: Node payment period. Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        :param pulumi.Input[str] period_unit: Node payment period unit, valid value: `Month`. Default is `Month`.
        :param pulumi.Input[str] platform: The platform. One of `AliyunLinux`, `Windows`, `CentOS`, `WindowsCore`. If you select `Windows` or `WindowsCore`, the `passord` is required. Field `platform` has been deprecated from provider version 1.145.0. New field `image_type` instead.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] polardb_ids: PolarDB id list, You can choose which PolarDB whitelist to add instances to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input['NodePoolRollingPolicyArgs'] rolling_policy: Rolling policy is used to specify the strategy when the node pool is rolling update. This field works when nodepool updating. See `rolling_policy` below.
        :param pulumi.Input['NodePoolRolloutPolicyArgs'] rollout_policy: Rollout policy is used to specify the strategy when the node pool is rolling update. This field works when node pool updating. Please use `rolling_policy` to instead it from provider version 1.185.0. See `rollout_policy` below.
        :param pulumi.Input[str] runtime_name: The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        :param pulumi.Input[str] runtime_version: The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        :param pulumi.Input['NodePoolScalingConfigArgs'] scaling_config: Auto scaling node pool configuration. See `scaling_config` below. With auto-scaling is enabled, the nodes in the node pool will be labeled with `k8s.aliyun.com=true` to prevent system pods such as coredns, metrics-servers from being scheduled to elastic nodes, and to prevent node shrinkage from causing business abnormalities.
        :param pulumi.Input[str] scaling_policy: The scaling mode. Valid values: `release`, `recycle`, default is `release`. Standard mode(release): Create and release ECS instances based on requests.Swift mode(recycle): Create, stop, and restart ECS instances based on needs. New ECS instances are only created when no stopped ECS instance is avalible. This mode further accelerates the scaling process. Apart from ECS instances that use local storage, when an ECS instance is stopped, you are only chatged for storage space.
        :param pulumi.Input[str] security_group_id: The security group id for worker node. Field `security_group_id` has been deprecated from provider version 1.145.0. New field `security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        :param pulumi.Input[bool] soc_enabled: Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).  
               > **NOTE:** It is forbidden to set both `cis_enabled` and `soc_enabled` to `true`at the same time.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]] spot_price_limits: The maximum hourly price of the instance. This parameter takes effect only when `spot_strategy` is set to `SpotWithPriceLimit`. You could enable multiple spot instances by setting this field repeatedly. See `spot_price_limit` below.
        :param pulumi.Input[str] spot_strategy: The preemption policy for the pay-as-you-go instance. This parameter takes effect only when `instance_charge_type` is set to `PostPaid`. Valid value `SpotWithPriceLimit`,`SpotAsPriceGo` and `NoSpot`, default is `NoSpot`.
        :param pulumi.Input[str] system_disk_category: The system disk category of worker node. Its valid value are `cloud_ssd`, `cloud_efficiency` and `cloud_essd`. Default to `cloud_efficiency`.
        :param pulumi.Input[str] system_disk_encrypt_algorithm: The encryption Algorithm for Encrypting System Disk. It takes effect when system_disk_encrypted is true. Valid values `aes-256` and `sm4-128`.
        :param pulumi.Input[bool] system_disk_encrypted: Whether to enable system disk encryption.
        :param pulumi.Input[str] system_disk_kms_key: The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        :param pulumi.Input[str] system_disk_performance_level: The performance of system disk, only valid for ESSD disk. You have to specify one of `PL0` `PL1` `PL2` `PL3` fields.
        :param pulumi.Input[int] system_disk_size: The system disk category of worker node. Its valid value range [40~500] in GB. Default to `120`.
        :param pulumi.Input[str] system_disk_snapshot_policy_id: The system disk snapshot policy id.
        :param pulumi.Input[Mapping[str, Any]] tags: A Map of tags to assign to the resource. It will be applied for ECS instances finally. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]] taints: A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        :param pulumi.Input[bool] unschedulable: Set the newly added node as unschedulable. If you want to open the scheduling option, you can open it in the node list of the console. If you are using an auto-scaling node pool, the setting will not take effect. Default is `false`.
        :param pulumi.Input[str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "instance_types", instance_types)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cis_enabled is not None:
            pulumi.set(__self__, "cis_enabled", cis_enabled)
        if cpu_policy is not None:
            pulumi.set(__self__, "cpu_policy", cpu_policy)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if desired_size is not None:
            pulumi.set(__self__, "desired_size", desired_size)
        if format_disk is not None:
            pulumi.set(__self__, "format_disk", format_disk)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if install_cloud_monitor is not None:
            pulumi.set(__self__, "install_cloud_monitor", install_cloud_monitor)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if keep_instance_name is not None:
            pulumi.set(__self__, "keep_instance_name", keep_instance_name)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if kubelet_configuration is not None:
            pulumi.set(__self__, "kubelet_configuration", kubelet_configuration)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            warnings.warn("""Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""", DeprecationWarning)
            pulumi.log.warn("""node_count is deprecated: Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""")
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_name_mode is not None:
            pulumi.set(__self__, "node_name_mode", node_name_mode)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if platform is not None:
            warnings.warn("""Field 'platform' has been deprecated from provider version 1.145.0. New field 'image_type' instead""", DeprecationWarning)
            pulumi.log.warn("""platform is deprecated: Field 'platform' has been deprecated from provider version 1.145.0. New field 'image_type' instead""")
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if polardb_ids is not None:
            pulumi.set(__self__, "polardb_ids", polardb_ids)
        if rds_instances is not None:
            pulumi.set(__self__, "rds_instances", rds_instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if rolling_policy is not None:
            pulumi.set(__self__, "rolling_policy", rolling_policy)
        if rollout_policy is not None:
            warnings.warn("""Field 'rollout_policy' has been deprecated from provider version 1.184.0. Please use new field 'rolling_policy' instead it to ensure the config takes effect""", DeprecationWarning)
            pulumi.log.warn("""rollout_policy is deprecated: Field 'rollout_policy' has been deprecated from provider version 1.184.0. Please use new field 'rolling_policy' instead it to ensure the config takes effect""")
        if rollout_policy is not None:
            pulumi.set(__self__, "rollout_policy", rollout_policy)
        if runtime_name is not None:
            pulumi.set(__self__, "runtime_name", runtime_name)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if scaling_policy is not None:
            pulumi.set(__self__, "scaling_policy", scaling_policy)
        if security_group_id is not None:
            warnings.warn("""Field 'security_group_id' has been deprecated from provider version 1.145.0. New field 'security_group_ids' instead""", DeprecationWarning)
            pulumi.log.warn("""security_group_id is deprecated: Field 'security_group_id' has been deprecated from provider version 1.145.0. New field 'security_group_ids' instead""")
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if soc_enabled is not None:
            pulumi.set(__self__, "soc_enabled", soc_enabled)
        if spot_price_limits is not None:
            pulumi.set(__self__, "spot_price_limits", spot_price_limits)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_encrypt_algorithm is not None:
            pulumi.set(__self__, "system_disk_encrypt_algorithm", system_disk_encrypt_algorithm)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_kms_key is not None:
            pulumi.set(__self__, "system_disk_kms_key", system_disk_kms_key)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_snapshot_policy_id", system_disk_snapshot_policy_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The instance type of worker node.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The vswitches used by node pool workers.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "vswitch_ids", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Node payment auto-renew, default is `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Node payment auto-renew period, one of `1`, `2`, `3`,`6`, `12`.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="cisEnabled")
    def cis_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [CIS Reinforcement](https://help.aliyun.com/document_detail/223744.html).
        """
        return pulumi.get(self, "cis_enabled")

    @cis_enabled.setter
    def cis_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cis_enabled", value)

    @property
    @pulumi.getter(name="cpuPolicy")
    def cpu_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Kubelet cpu policy. For Kubernetes 1.12.6 and later, its valid value is either `static` or `none`. Default to `none` and modification is not supported.
        """
        return pulumi.get(self, "cpu_policy")

    @cpu_policy.setter
    def cpu_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_policy", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]]:
        """
        The data disk configurations of worker nodes, such as the disk type and disk size. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_set_id", value)

    @property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> Optional[pulumi.Input[int]]:
        """
        The desired size of nodes of the node pool. From version 1.158.0, `desired_size` is not required.
        """
        return pulumi.get(self, "desired_size")

    @desired_size.setter
    def desired_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_size", value)

    @property
    @pulumi.getter(name="formatDisk")
    def format_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        """
        return pulumi.get(self, "format_disk")

    @format_disk.setter
    def format_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "format_disk", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Image support. Must based on CentOS7 or AliyunLinux2.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[str]]:
        """
        The image type, instead of `platform`. This field cannot be modified. One of `AliyunLinux`, `AliyunLinux3`, `AliyunLinux3Arm64`, `AliyunLinuxUEFI`, `CentOS`, `Windows`,`WindowsCore`,`AliyunLinux Qboot`,`ContainerOS`. If you select `Windows` or `WindowsCore`, the `passord` is required.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> Optional[pulumi.Input[bool]]:
        """
        Install the cloud monitoring plug-in on the node, and you can view the monitoring information of the instance through the cloud monitoring console. Default is `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @install_cloud_monitor.setter
    def install_cloud_monitor(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_cloud_monitor", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The instance list. Add existing nodes under the same cluster VPC to the node pool.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum outbound bandwidth for the public network. Unit: Mbit/s. Valid values: 0 to 100.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter(name="keepInstanceName")
    def keep_instance_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        """
        return pulumi.get(self, "keep_instance_name")

    @keep_instance_name.setter
    def keep_instance_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_instance_name", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields. Only `key_name` is supported in the management node pool.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[str]]:
        """
        An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter(name="kubeletConfiguration")
    def kubelet_configuration(self) -> Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']]:
        """
        Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/).
        """
        return pulumi.get(self, "kubelet_configuration")

    @kubelet_configuration.setter
    def kubelet_configuration(self, value: Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']]):
        pulumi.set(self, "kubelet_configuration", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]]:
        """
        A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['NodePoolManagementArgs']]:
        """
        Managed node pool configuration. When using a managed node pool, the node key must use `key_name`. See `management` below.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['NodePoolManagementArgs']]):
        pulumi.set(self, "management", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        """
        warnings.warn("""Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""", DeprecationWarning)
        pulumi.log.warn("""node_count is deprecated: Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""")

        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeNameMode")
    def node_name_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Each node name consists of a prefix, its private network IP, and a suffix, the input format is `customized,<prefix>,ip,<suffix>`. For example "customized,aliyun.com-,ip,-test", if the node private network IP address is 192.168.59.176, the prefix is aliyun.com-,and the suffix is -test, the node name will be aliyun.com-192.168.59.176-test.
        """
        return pulumi.get(self, "node_name_mode")

    @node_name_mode.setter
    def node_name_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_name_mode", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Node payment period. Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Node payment period unit, valid value: `Month`. Default is `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The platform. One of `AliyunLinux`, `Windows`, `CentOS`, `WindowsCore`. If you select `Windows` or `WindowsCore`, the `passord` is required. Field `platform` has been deprecated from provider version 1.145.0. New field `image_type` instead.
        """
        warnings.warn("""Field 'platform' has been deprecated from provider version 1.145.0. New field 'image_type' instead""", DeprecationWarning)
        pulumi.log.warn("""platform is deprecated: Field 'platform' has been deprecated from provider version 1.145.0. New field 'image_type' instead""")

        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="polardbIds")
    def polardb_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        PolarDB id list, You can choose which PolarDB whitelist to add instances to.
        """
        return pulumi.get(self, "polardb_ids")

    @polardb_ids.setter
    def polardb_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "polardb_ids", value)

    @property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @rds_instances.setter
    def rds_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rds_instances", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="rollingPolicy")
    def rolling_policy(self) -> Optional[pulumi.Input['NodePoolRollingPolicyArgs']]:
        """
        Rolling policy is used to specify the strategy when the node pool is rolling update. This field works when nodepool updating. See `rolling_policy` below.
        """
        return pulumi.get(self, "rolling_policy")

    @rolling_policy.setter
    def rolling_policy(self, value: Optional[pulumi.Input['NodePoolRollingPolicyArgs']]):
        pulumi.set(self, "rolling_policy", value)

    @property
    @pulumi.getter(name="rolloutPolicy")
    def rollout_policy(self) -> Optional[pulumi.Input['NodePoolRolloutPolicyArgs']]:
        """
        Rollout policy is used to specify the strategy when the node pool is rolling update. This field works when node pool updating. Please use `rolling_policy` to instead it from provider version 1.185.0. See `rollout_policy` below.
        """
        warnings.warn("""Field 'rollout_policy' has been deprecated from provider version 1.184.0. Please use new field 'rolling_policy' instead it to ensure the config takes effect""", DeprecationWarning)
        pulumi.log.warn("""rollout_policy is deprecated: Field 'rollout_policy' has been deprecated from provider version 1.184.0. Please use new field 'rolling_policy' instead it to ensure the config takes effect""")

        return pulumi.get(self, "rollout_policy")

    @rollout_policy.setter
    def rollout_policy(self, value: Optional[pulumi.Input['NodePoolRolloutPolicyArgs']]):
        pulumi.set(self, "rollout_policy", value)

    @property
    @pulumi.getter(name="runtimeName")
    def runtime_name(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        """
        return pulumi.get(self, "runtime_name")

    @runtime_name.setter
    def runtime_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_name", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['NodePoolScalingConfigArgs']]:
        """
        Auto scaling node pool configuration. See `scaling_config` below. With auto-scaling is enabled, the nodes in the node pool will be labeled with `k8s.aliyun.com=true` to prevent system pods such as coredns, metrics-servers from being scheduled to elastic nodes, and to prevent node shrinkage from causing business abnormalities.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['NodePoolScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The scaling mode. Valid values: `release`, `recycle`, default is `release`. Standard mode(release): Create and release ECS instances based on requests.Swift mode(recycle): Create, stop, and restart ECS instances based on needs. New ECS instances are only created when no stopped ECS instance is avalible. This mode further accelerates the scaling process. Apart from ECS instances that use local storage, when an ECS instance is stopped, you are only chatged for storage space.
        """
        return pulumi.get(self, "scaling_policy")

    @scaling_policy.setter
    def scaling_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_policy", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The security group id for worker node. Field `security_group_id` has been deprecated from provider version 1.145.0. New field `security_group_ids` instead.
        """
        warnings.warn("""Field 'security_group_id' has been deprecated from provider version 1.145.0. New field 'security_group_ids' instead""", DeprecationWarning)
        pulumi.log.warn("""security_group_id is deprecated: Field 'security_group_id' has been deprecated from provider version 1.145.0. New field 'security_group_ids' instead""")

        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="socEnabled")
    def soc_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).  
        > **NOTE:** It is forbidden to set both `cis_enabled` and `soc_enabled` to `true`at the same time.
        """
        return pulumi.get(self, "soc_enabled")

    @soc_enabled.setter
    def soc_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "soc_enabled", value)

    @property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]]:
        """
        The maximum hourly price of the instance. This parameter takes effect only when `spot_strategy` is set to `SpotWithPriceLimit`. You could enable multiple spot instances by setting this field repeatedly. See `spot_price_limit` below.
        """
        return pulumi.get(self, "spot_price_limits")

    @spot_price_limits.setter
    def spot_price_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]]):
        pulumi.set(self, "spot_price_limits", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The preemption policy for the pay-as-you-go instance. This parameter takes effect only when `instance_charge_type` is set to `PostPaid`. Valid value `SpotWithPriceLimit`,`SpotAsPriceGo` and `NoSpot`, default is `NoSpot`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The system disk category of worker node. Its valid value are `cloud_ssd`, `cloud_efficiency` and `cloud_essd`. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_category", value)

    @property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The encryption Algorithm for Encrypting System Disk. It takes effect when system_disk_encrypted is true. Valid values `aes-256` and `sm4-128`.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @system_disk_encrypt_algorithm.setter
    def system_disk_encrypt_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_encrypt_algorithm", value)

    @property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable system disk encryption.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @system_disk_encrypted.setter
    def system_disk_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "system_disk_encrypted", value)

    @property
    @pulumi.getter(name="systemDiskKmsKey")
    def system_disk_kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        """
        return pulumi.get(self, "system_disk_kms_key")

    @system_disk_kms_key.setter
    def system_disk_kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_kms_key", value)

    @property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        The performance of system disk, only valid for ESSD disk. You have to specify one of `PL0` `PL1` `PL2` `PL3` fields.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The system disk category of worker node. Its valid value range [40~500] in GB. Default to `120`.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter(name="systemDiskSnapshotPolicyId")
    def system_disk_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The system disk snapshot policy id.
        """
        return pulumi.get(self, "system_disk_snapshot_policy_id")

    @system_disk_snapshot_policy_id.setter
    def system_disk_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_snapshot_policy_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A Map of tags to assign to the resource. It will be applied for ECS instances finally. Detailed below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]:
        """
        A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def unschedulable(self) -> Optional[pulumi.Input[bool]]:
        """
        Set the newly added node as unschedulable. If you want to open the scheduling option, you can open it in the node list of the console. If you are using an auto-scaling node pool, the setting will not take effect. Default is `false`.
        """
        return pulumi.get(self, "unschedulable")

    @unschedulable.setter
    def unschedulable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unschedulable", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _NodePoolState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cis_enabled: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cpu_policy: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 desired_size: Optional[pulumi.Input[int]] = None,
                 format_disk: Optional[pulumi.Input[bool]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 keep_instance_name: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kubelet_configuration: Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]] = None,
                 management: Optional[pulumi.Input['NodePoolManagementArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_name_mode: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 polardb_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 rolling_policy: Optional[pulumi.Input['NodePoolRollingPolicyArgs']] = None,
                 rollout_policy: Optional[pulumi.Input['NodePoolRolloutPolicyArgs']] = None,
                 runtime_name: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 scaling_config: Optional[pulumi.Input['NodePoolScalingConfigArgs']] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 scaling_policy: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 soc_enabled: Optional[pulumi.Input[bool]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 system_disk_kms_key: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 system_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]] = None,
                 unschedulable: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering NodePool resources.
        :param pulumi.Input[bool] auto_renew: Enable Node payment auto-renew, default is `false`.
        :param pulumi.Input[int] auto_renew_period: Node payment auto-renew period, one of `1`, `2`, `3`,`6`, `12`.
        :param pulumi.Input[bool] cis_enabled: Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [CIS Reinforcement](https://help.aliyun.com/document_detail/223744.html).
        :param pulumi.Input[str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[str] cpu_policy: Kubelet cpu policy. For Kubernetes 1.12.6 and later, its valid value is either `static` or `none`. Default to `none` and modification is not supported.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]] data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `data_disks` below.
        :param pulumi.Input[str] deployment_set_id: The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        :param pulumi.Input[int] desired_size: The desired size of nodes of the node pool. From version 1.158.0, `desired_size` is not required.
        :param pulumi.Input[bool] format_disk: After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        :param pulumi.Input[str] image_id: Custom Image support. Must based on CentOS7 or AliyunLinux2.
        :param pulumi.Input[str] image_type: The image type, instead of `platform`. This field cannot be modified. One of `AliyunLinux`, `AliyunLinux3`, `AliyunLinux3Arm64`, `AliyunLinuxUEFI`, `CentOS`, `Windows`,`WindowsCore`,`AliyunLinux Qboot`,`ContainerOS`. If you select `Windows` or `WindowsCore`, the `passord` is required.
        :param pulumi.Input[bool] install_cloud_monitor: Install the cloud monitoring plug-in on the node, and you can view the monitoring information of the instance through the cloud monitoring console. Default is `true`.
        :param pulumi.Input[str] instance_charge_type: Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: The instance type of worker node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: The instance list. Add existing nodes under the same cluster VPC to the node pool.
        :param pulumi.Input[str] internet_charge_type: The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        :param pulumi.Input[int] internet_max_bandwidth_out: The maximum outbound bandwidth for the public network. Unit: Mbit/s. Valid values: 0 to 100.
        :param pulumi.Input[bool] keep_instance_name: Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields. Only `key_name` is supported in the management node pool.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input['NodePoolKubeletConfigurationArgs'] kubelet_configuration: Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/).
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]] labels: A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        :param pulumi.Input['NodePoolManagementArgs'] management: Managed node pool configuration. When using a managed node pool, the node key must use `key_name`. See `management` below.
        :param pulumi.Input[str] name: The name of node pool.
        :param pulumi.Input[int] node_count: The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        :param pulumi.Input[str] node_name_mode: Each node name consists of a prefix, its private network IP, and a suffix, the input format is `customized,<prefix>,ip,<suffix>`. For example "customized,aliyun.com-,ip,-test", if the node private network IP address is 192.168.59.176, the prefix is aliyun.com-,and the suffix is -test, the node name will be aliyun.com-192.168.59.176-test.
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[int] period: Node payment period. Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        :param pulumi.Input[str] period_unit: Node payment period unit, valid value: `Month`. Default is `Month`.
        :param pulumi.Input[str] platform: The platform. One of `AliyunLinux`, `Windows`, `CentOS`, `WindowsCore`. If you select `Windows` or `WindowsCore`, the `passord` is required. Field `platform` has been deprecated from provider version 1.145.0. New field `image_type` instead.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] polardb_ids: PolarDB id list, You can choose which PolarDB whitelist to add instances to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input['NodePoolRollingPolicyArgs'] rolling_policy: Rolling policy is used to specify the strategy when the node pool is rolling update. This field works when nodepool updating. See `rolling_policy` below.
        :param pulumi.Input['NodePoolRolloutPolicyArgs'] rollout_policy: Rollout policy is used to specify the strategy when the node pool is rolling update. This field works when node pool updating. Please use `rolling_policy` to instead it from provider version 1.185.0. See `rollout_policy` below.
        :param pulumi.Input[str] runtime_name: The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        :param pulumi.Input[str] runtime_version: The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        :param pulumi.Input['NodePoolScalingConfigArgs'] scaling_config: Auto scaling node pool configuration. See `scaling_config` below. With auto-scaling is enabled, the nodes in the node pool will be labeled with `k8s.aliyun.com=true` to prevent system pods such as coredns, metrics-servers from being scheduled to elastic nodes, and to prevent node shrinkage from causing business abnormalities.
        :param pulumi.Input[str] scaling_group_id: The scaling group id.
        :param pulumi.Input[str] scaling_policy: The scaling mode. Valid values: `release`, `recycle`, default is `release`. Standard mode(release): Create and release ECS instances based on requests.Swift mode(recycle): Create, stop, and restart ECS instances based on needs. New ECS instances are only created when no stopped ECS instance is avalible. This mode further accelerates the scaling process. Apart from ECS instances that use local storage, when an ECS instance is stopped, you are only chatged for storage space.
        :param pulumi.Input[str] security_group_id: The security group id for worker node. Field `security_group_id` has been deprecated from provider version 1.145.0. New field `security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        :param pulumi.Input[bool] soc_enabled: Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).  
               > **NOTE:** It is forbidden to set both `cis_enabled` and `soc_enabled` to `true`at the same time.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]] spot_price_limits: The maximum hourly price of the instance. This parameter takes effect only when `spot_strategy` is set to `SpotWithPriceLimit`. You could enable multiple spot instances by setting this field repeatedly. See `spot_price_limit` below.
        :param pulumi.Input[str] spot_strategy: The preemption policy for the pay-as-you-go instance. This parameter takes effect only when `instance_charge_type` is set to `PostPaid`. Valid value `SpotWithPriceLimit`,`SpotAsPriceGo` and `NoSpot`, default is `NoSpot`.
        :param pulumi.Input[str] system_disk_category: The system disk category of worker node. Its valid value are `cloud_ssd`, `cloud_efficiency` and `cloud_essd`. Default to `cloud_efficiency`.
        :param pulumi.Input[str] system_disk_encrypt_algorithm: The encryption Algorithm for Encrypting System Disk. It takes effect when system_disk_encrypted is true. Valid values `aes-256` and `sm4-128`.
        :param pulumi.Input[bool] system_disk_encrypted: Whether to enable system disk encryption.
        :param pulumi.Input[str] system_disk_kms_key: The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        :param pulumi.Input[str] system_disk_performance_level: The performance of system disk, only valid for ESSD disk. You have to specify one of `PL0` `PL1` `PL2` `PL3` fields.
        :param pulumi.Input[int] system_disk_size: The system disk category of worker node. Its valid value range [40~500] in GB. Default to `120`.
        :param pulumi.Input[str] system_disk_snapshot_policy_id: The system disk snapshot policy id.
        :param pulumi.Input[Mapping[str, Any]] tags: A Map of tags to assign to the resource. It will be applied for ECS instances finally. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]] taints: A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        :param pulumi.Input[bool] unschedulable: Set the newly added node as unschedulable. If you want to open the scheduling option, you can open it in the node list of the console. If you are using an auto-scaling node pool, the setting will not take effect. Default is `false`.
        :param pulumi.Input[str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        :param pulumi.Input[str] vpc_id: The VPC of the nodes in the node pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: The vswitches used by node pool workers.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cis_enabled is not None:
            pulumi.set(__self__, "cis_enabled", cis_enabled)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cpu_policy is not None:
            pulumi.set(__self__, "cpu_policy", cpu_policy)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if desired_size is not None:
            pulumi.set(__self__, "desired_size", desired_size)
        if format_disk is not None:
            pulumi.set(__self__, "format_disk", format_disk)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if install_cloud_monitor is not None:
            pulumi.set(__self__, "install_cloud_monitor", install_cloud_monitor)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if keep_instance_name is not None:
            pulumi.set(__self__, "keep_instance_name", keep_instance_name)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if kubelet_configuration is not None:
            pulumi.set(__self__, "kubelet_configuration", kubelet_configuration)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            warnings.warn("""Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""", DeprecationWarning)
            pulumi.log.warn("""node_count is deprecated: Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""")
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_name_mode is not None:
            pulumi.set(__self__, "node_name_mode", node_name_mode)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if platform is not None:
            warnings.warn("""Field 'platform' has been deprecated from provider version 1.145.0. New field 'image_type' instead""", DeprecationWarning)
            pulumi.log.warn("""platform is deprecated: Field 'platform' has been deprecated from provider version 1.145.0. New field 'image_type' instead""")
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if polardb_ids is not None:
            pulumi.set(__self__, "polardb_ids", polardb_ids)
        if rds_instances is not None:
            pulumi.set(__self__, "rds_instances", rds_instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if rolling_policy is not None:
            pulumi.set(__self__, "rolling_policy", rolling_policy)
        if rollout_policy is not None:
            warnings.warn("""Field 'rollout_policy' has been deprecated from provider version 1.184.0. Please use new field 'rolling_policy' instead it to ensure the config takes effect""", DeprecationWarning)
            pulumi.log.warn("""rollout_policy is deprecated: Field 'rollout_policy' has been deprecated from provider version 1.184.0. Please use new field 'rolling_policy' instead it to ensure the config takes effect""")
        if rollout_policy is not None:
            pulumi.set(__self__, "rollout_policy", rollout_policy)
        if runtime_name is not None:
            pulumi.set(__self__, "runtime_name", runtime_name)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if scaling_policy is not None:
            pulumi.set(__self__, "scaling_policy", scaling_policy)
        if security_group_id is not None:
            warnings.warn("""Field 'security_group_id' has been deprecated from provider version 1.145.0. New field 'security_group_ids' instead""", DeprecationWarning)
            pulumi.log.warn("""security_group_id is deprecated: Field 'security_group_id' has been deprecated from provider version 1.145.0. New field 'security_group_ids' instead""")
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if soc_enabled is not None:
            pulumi.set(__self__, "soc_enabled", soc_enabled)
        if spot_price_limits is not None:
            pulumi.set(__self__, "spot_price_limits", spot_price_limits)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_encrypt_algorithm is not None:
            pulumi.set(__self__, "system_disk_encrypt_algorithm", system_disk_encrypt_algorithm)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_kms_key is not None:
            pulumi.set(__self__, "system_disk_kms_key", system_disk_kms_key)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_snapshot_policy_id", system_disk_snapshot_policy_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Node payment auto-renew, default is `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Node payment auto-renew period, one of `1`, `2`, `3`,`6`, `12`.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="cisEnabled")
    def cis_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [CIS Reinforcement](https://help.aliyun.com/document_detail/223744.html).
        """
        return pulumi.get(self, "cis_enabled")

    @cis_enabled.setter
    def cis_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cis_enabled", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="cpuPolicy")
    def cpu_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Kubelet cpu policy. For Kubernetes 1.12.6 and later, its valid value is either `static` or `none`. Default to `none` and modification is not supported.
        """
        return pulumi.get(self, "cpu_policy")

    @cpu_policy.setter
    def cpu_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_policy", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]]:
        """
        The data disk configurations of worker nodes, such as the disk type and disk size. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_set_id", value)

    @property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> Optional[pulumi.Input[int]]:
        """
        The desired size of nodes of the node pool. From version 1.158.0, `desired_size` is not required.
        """
        return pulumi.get(self, "desired_size")

    @desired_size.setter
    def desired_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_size", value)

    @property
    @pulumi.getter(name="formatDisk")
    def format_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        """
        return pulumi.get(self, "format_disk")

    @format_disk.setter
    def format_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "format_disk", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Image support. Must based on CentOS7 or AliyunLinux2.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[str]]:
        """
        The image type, instead of `platform`. This field cannot be modified. One of `AliyunLinux`, `AliyunLinux3`, `AliyunLinux3Arm64`, `AliyunLinuxUEFI`, `CentOS`, `Windows`,`WindowsCore`,`AliyunLinux Qboot`,`ContainerOS`. If you select `Windows` or `WindowsCore`, the `passord` is required.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> Optional[pulumi.Input[bool]]:
        """
        Install the cloud monitoring plug-in on the node, and you can view the monitoring information of the instance through the cloud monitoring console. Default is `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @install_cloud_monitor.setter
    def install_cloud_monitor(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_cloud_monitor", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The instance type of worker node.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The instance list. Add existing nodes under the same cluster VPC to the node pool.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum outbound bandwidth for the public network. Unit: Mbit/s. Valid values: 0 to 100.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter(name="keepInstanceName")
    def keep_instance_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        """
        return pulumi.get(self, "keep_instance_name")

    @keep_instance_name.setter
    def keep_instance_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_instance_name", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields. Only `key_name` is supported in the management node pool.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[str]]:
        """
        An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter(name="kubeletConfiguration")
    def kubelet_configuration(self) -> Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']]:
        """
        Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/).
        """
        return pulumi.get(self, "kubelet_configuration")

    @kubelet_configuration.setter
    def kubelet_configuration(self, value: Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']]):
        pulumi.set(self, "kubelet_configuration", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]]:
        """
        A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['NodePoolManagementArgs']]:
        """
        Managed node pool configuration. When using a managed node pool, the node key must use `key_name`. See `management` below.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['NodePoolManagementArgs']]):
        pulumi.set(self, "management", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        """
        warnings.warn("""Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""", DeprecationWarning)
        pulumi.log.warn("""node_count is deprecated: Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""")

        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeNameMode")
    def node_name_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Each node name consists of a prefix, its private network IP, and a suffix, the input format is `customized,<prefix>,ip,<suffix>`. For example "customized,aliyun.com-,ip,-test", if the node private network IP address is 192.168.59.176, the prefix is aliyun.com-,and the suffix is -test, the node name will be aliyun.com-192.168.59.176-test.
        """
        return pulumi.get(self, "node_name_mode")

    @node_name_mode.setter
    def node_name_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_name_mode", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Node payment period. Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Node payment period unit, valid value: `Month`. Default is `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The platform. One of `AliyunLinux`, `Windows`, `CentOS`, `WindowsCore`. If you select `Windows` or `WindowsCore`, the `passord` is required. Field `platform` has been deprecated from provider version 1.145.0. New field `image_type` instead.
        """
        warnings.warn("""Field 'platform' has been deprecated from provider version 1.145.0. New field 'image_type' instead""", DeprecationWarning)
        pulumi.log.warn("""platform is deprecated: Field 'platform' has been deprecated from provider version 1.145.0. New field 'image_type' instead""")

        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="polardbIds")
    def polardb_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        PolarDB id list, You can choose which PolarDB whitelist to add instances to.
        """
        return pulumi.get(self, "polardb_ids")

    @polardb_ids.setter
    def polardb_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "polardb_ids", value)

    @property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @rds_instances.setter
    def rds_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rds_instances", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="rollingPolicy")
    def rolling_policy(self) -> Optional[pulumi.Input['NodePoolRollingPolicyArgs']]:
        """
        Rolling policy is used to specify the strategy when the node pool is rolling update. This field works when nodepool updating. See `rolling_policy` below.
        """
        return pulumi.get(self, "rolling_policy")

    @rolling_policy.setter
    def rolling_policy(self, value: Optional[pulumi.Input['NodePoolRollingPolicyArgs']]):
        pulumi.set(self, "rolling_policy", value)

    @property
    @pulumi.getter(name="rolloutPolicy")
    def rollout_policy(self) -> Optional[pulumi.Input['NodePoolRolloutPolicyArgs']]:
        """
        Rollout policy is used to specify the strategy when the node pool is rolling update. This field works when node pool updating. Please use `rolling_policy` to instead it from provider version 1.185.0. See `rollout_policy` below.
        """
        warnings.warn("""Field 'rollout_policy' has been deprecated from provider version 1.184.0. Please use new field 'rolling_policy' instead it to ensure the config takes effect""", DeprecationWarning)
        pulumi.log.warn("""rollout_policy is deprecated: Field 'rollout_policy' has been deprecated from provider version 1.184.0. Please use new field 'rolling_policy' instead it to ensure the config takes effect""")

        return pulumi.get(self, "rollout_policy")

    @rollout_policy.setter
    def rollout_policy(self, value: Optional[pulumi.Input['NodePoolRolloutPolicyArgs']]):
        pulumi.set(self, "rollout_policy", value)

    @property
    @pulumi.getter(name="runtimeName")
    def runtime_name(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        """
        return pulumi.get(self, "runtime_name")

    @runtime_name.setter
    def runtime_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_name", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['NodePoolScalingConfigArgs']]:
        """
        Auto scaling node pool configuration. See `scaling_config` below. With auto-scaling is enabled, the nodes in the node pool will be labeled with `k8s.aliyun.com=true` to prevent system pods such as coredns, metrics-servers from being scheduled to elastic nodes, and to prevent node shrinkage from causing business abnormalities.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['NodePoolScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The scaling group id.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The scaling mode. Valid values: `release`, `recycle`, default is `release`. Standard mode(release): Create and release ECS instances based on requests.Swift mode(recycle): Create, stop, and restart ECS instances based on needs. New ECS instances are only created when no stopped ECS instance is avalible. This mode further accelerates the scaling process. Apart from ECS instances that use local storage, when an ECS instance is stopped, you are only chatged for storage space.
        """
        return pulumi.get(self, "scaling_policy")

    @scaling_policy.setter
    def scaling_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_policy", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The security group id for worker node. Field `security_group_id` has been deprecated from provider version 1.145.0. New field `security_group_ids` instead.
        """
        warnings.warn("""Field 'security_group_id' has been deprecated from provider version 1.145.0. New field 'security_group_ids' instead""", DeprecationWarning)
        pulumi.log.warn("""security_group_id is deprecated: Field 'security_group_id' has been deprecated from provider version 1.145.0. New field 'security_group_ids' instead""")

        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="socEnabled")
    def soc_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).  
        > **NOTE:** It is forbidden to set both `cis_enabled` and `soc_enabled` to `true`at the same time.
        """
        return pulumi.get(self, "soc_enabled")

    @soc_enabled.setter
    def soc_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "soc_enabled", value)

    @property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]]:
        """
        The maximum hourly price of the instance. This parameter takes effect only when `spot_strategy` is set to `SpotWithPriceLimit`. You could enable multiple spot instances by setting this field repeatedly. See `spot_price_limit` below.
        """
        return pulumi.get(self, "spot_price_limits")

    @spot_price_limits.setter
    def spot_price_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]]):
        pulumi.set(self, "spot_price_limits", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The preemption policy for the pay-as-you-go instance. This parameter takes effect only when `instance_charge_type` is set to `PostPaid`. Valid value `SpotWithPriceLimit`,`SpotAsPriceGo` and `NoSpot`, default is `NoSpot`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The system disk category of worker node. Its valid value are `cloud_ssd`, `cloud_efficiency` and `cloud_essd`. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_category", value)

    @property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The encryption Algorithm for Encrypting System Disk. It takes effect when system_disk_encrypted is true. Valid values `aes-256` and `sm4-128`.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @system_disk_encrypt_algorithm.setter
    def system_disk_encrypt_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_encrypt_algorithm", value)

    @property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable system disk encryption.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @system_disk_encrypted.setter
    def system_disk_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "system_disk_encrypted", value)

    @property
    @pulumi.getter(name="systemDiskKmsKey")
    def system_disk_kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        """
        return pulumi.get(self, "system_disk_kms_key")

    @system_disk_kms_key.setter
    def system_disk_kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_kms_key", value)

    @property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        The performance of system disk, only valid for ESSD disk. You have to specify one of `PL0` `PL1` `PL2` `PL3` fields.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The system disk category of worker node. Its valid value range [40~500] in GB. Default to `120`.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter(name="systemDiskSnapshotPolicyId")
    def system_disk_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The system disk snapshot policy id.
        """
        return pulumi.get(self, "system_disk_snapshot_policy_id")

    @system_disk_snapshot_policy_id.setter
    def system_disk_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_snapshot_policy_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A Map of tags to assign to the resource. It will be applied for ECS instances finally. Detailed below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]:
        """
        A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def unschedulable(self) -> Optional[pulumi.Input[bool]]:
        """
        Set the newly added node as unschedulable. If you want to open the scheduling option, you can open it in the node list of the console. If you are using an auto-scaling node pool, the setting will not take effect. Default is `false`.
        """
        return pulumi.get(self, "unschedulable")

    @unschedulable.setter
    def unschedulable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unschedulable", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC of the nodes in the node pool.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The vswitches used by node pool workers.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vswitch_ids", value)


class NodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cis_enabled: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cpu_policy: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolDataDiskArgs']]]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 desired_size: Optional[pulumi.Input[int]] = None,
                 format_disk: Optional[pulumi.Input[bool]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 keep_instance_name: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kubelet_configuration: Optional[pulumi.Input[pulumi.InputType['NodePoolKubeletConfigurationArgs']]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolLabelArgs']]]]] = None,
                 management: Optional[pulumi.Input[pulumi.InputType['NodePoolManagementArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_name_mode: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 polardb_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 rolling_policy: Optional[pulumi.Input[pulumi.InputType['NodePoolRollingPolicyArgs']]] = None,
                 rollout_policy: Optional[pulumi.Input[pulumi.InputType['NodePoolRolloutPolicyArgs']]] = None,
                 runtime_name: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 scaling_config: Optional[pulumi.Input[pulumi.InputType['NodePoolScalingConfigArgs']]] = None,
                 scaling_policy: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 soc_enabled: Optional[pulumi.Input[bool]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolSpotPriceLimitArgs']]]]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 system_disk_kms_key: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 system_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTaintArgs']]]]] = None,
                 unschedulable: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## Import

        Cluster nodepool can be imported using the id, e.g. Then complete the nodepool.tf accords to the result of `pulumi preview`.

        ```sh
         $ pulumi import alicloud:cs/nodePool:NodePool custom_nodepool cluster_id:nodepool_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Enable Node payment auto-renew, default is `false`.
        :param pulumi.Input[int] auto_renew_period: Node payment auto-renew period, one of `1`, `2`, `3`,`6`, `12`.
        :param pulumi.Input[bool] cis_enabled: Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [CIS Reinforcement](https://help.aliyun.com/document_detail/223744.html).
        :param pulumi.Input[str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[str] cpu_policy: Kubelet cpu policy. For Kubernetes 1.12.6 and later, its valid value is either `static` or `none`. Default to `none` and modification is not supported.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolDataDiskArgs']]]] data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `data_disks` below.
        :param pulumi.Input[str] deployment_set_id: The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        :param pulumi.Input[int] desired_size: The desired size of nodes of the node pool. From version 1.158.0, `desired_size` is not required.
        :param pulumi.Input[bool] format_disk: After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        :param pulumi.Input[str] image_id: Custom Image support. Must based on CentOS7 or AliyunLinux2.
        :param pulumi.Input[str] image_type: The image type, instead of `platform`. This field cannot be modified. One of `AliyunLinux`, `AliyunLinux3`, `AliyunLinux3Arm64`, `AliyunLinuxUEFI`, `CentOS`, `Windows`,`WindowsCore`,`AliyunLinux Qboot`,`ContainerOS`. If you select `Windows` or `WindowsCore`, the `passord` is required.
        :param pulumi.Input[bool] install_cloud_monitor: Install the cloud monitoring plug-in on the node, and you can view the monitoring information of the instance through the cloud monitoring console. Default is `true`.
        :param pulumi.Input[str] instance_charge_type: Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: The instance type of worker node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: The instance list. Add existing nodes under the same cluster VPC to the node pool.
        :param pulumi.Input[str] internet_charge_type: The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        :param pulumi.Input[int] internet_max_bandwidth_out: The maximum outbound bandwidth for the public network. Unit: Mbit/s. Valid values: 0 to 100.
        :param pulumi.Input[bool] keep_instance_name: Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields. Only `key_name` is supported in the management node pool.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[pulumi.InputType['NodePoolKubeletConfigurationArgs']] kubelet_configuration: Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolLabelArgs']]]] labels: A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        :param pulumi.Input[pulumi.InputType['NodePoolManagementArgs']] management: Managed node pool configuration. When using a managed node pool, the node key must use `key_name`. See `management` below.
        :param pulumi.Input[str] name: The name of node pool.
        :param pulumi.Input[int] node_count: The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        :param pulumi.Input[str] node_name_mode: Each node name consists of a prefix, its private network IP, and a suffix, the input format is `customized,<prefix>,ip,<suffix>`. For example "customized,aliyun.com-,ip,-test", if the node private network IP address is 192.168.59.176, the prefix is aliyun.com-,and the suffix is -test, the node name will be aliyun.com-192.168.59.176-test.
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[int] period: Node payment period. Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        :param pulumi.Input[str] period_unit: Node payment period unit, valid value: `Month`. Default is `Month`.
        :param pulumi.Input[str] platform: The platform. One of `AliyunLinux`, `Windows`, `CentOS`, `WindowsCore`. If you select `Windows` or `WindowsCore`, the `passord` is required. Field `platform` has been deprecated from provider version 1.145.0. New field `image_type` instead.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] polardb_ids: PolarDB id list, You can choose which PolarDB whitelist to add instances to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[pulumi.InputType['NodePoolRollingPolicyArgs']] rolling_policy: Rolling policy is used to specify the strategy when the node pool is rolling update. This field works when nodepool updating. See `rolling_policy` below.
        :param pulumi.Input[pulumi.InputType['NodePoolRolloutPolicyArgs']] rollout_policy: Rollout policy is used to specify the strategy when the node pool is rolling update. This field works when node pool updating. Please use `rolling_policy` to instead it from provider version 1.185.0. See `rollout_policy` below.
        :param pulumi.Input[str] runtime_name: The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        :param pulumi.Input[str] runtime_version: The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        :param pulumi.Input[pulumi.InputType['NodePoolScalingConfigArgs']] scaling_config: Auto scaling node pool configuration. See `scaling_config` below. With auto-scaling is enabled, the nodes in the node pool will be labeled with `k8s.aliyun.com=true` to prevent system pods such as coredns, metrics-servers from being scheduled to elastic nodes, and to prevent node shrinkage from causing business abnormalities.
        :param pulumi.Input[str] scaling_policy: The scaling mode. Valid values: `release`, `recycle`, default is `release`. Standard mode(release): Create and release ECS instances based on requests.Swift mode(recycle): Create, stop, and restart ECS instances based on needs. New ECS instances are only created when no stopped ECS instance is avalible. This mode further accelerates the scaling process. Apart from ECS instances that use local storage, when an ECS instance is stopped, you are only chatged for storage space.
        :param pulumi.Input[str] security_group_id: The security group id for worker node. Field `security_group_id` has been deprecated from provider version 1.145.0. New field `security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        :param pulumi.Input[bool] soc_enabled: Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).  
               > **NOTE:** It is forbidden to set both `cis_enabled` and `soc_enabled` to `true`at the same time.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolSpotPriceLimitArgs']]]] spot_price_limits: The maximum hourly price of the instance. This parameter takes effect only when `spot_strategy` is set to `SpotWithPriceLimit`. You could enable multiple spot instances by setting this field repeatedly. See `spot_price_limit` below.
        :param pulumi.Input[str] spot_strategy: The preemption policy for the pay-as-you-go instance. This parameter takes effect only when `instance_charge_type` is set to `PostPaid`. Valid value `SpotWithPriceLimit`,`SpotAsPriceGo` and `NoSpot`, default is `NoSpot`.
        :param pulumi.Input[str] system_disk_category: The system disk category of worker node. Its valid value are `cloud_ssd`, `cloud_efficiency` and `cloud_essd`. Default to `cloud_efficiency`.
        :param pulumi.Input[str] system_disk_encrypt_algorithm: The encryption Algorithm for Encrypting System Disk. It takes effect when system_disk_encrypted is true. Valid values `aes-256` and `sm4-128`.
        :param pulumi.Input[bool] system_disk_encrypted: Whether to enable system disk encryption.
        :param pulumi.Input[str] system_disk_kms_key: The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        :param pulumi.Input[str] system_disk_performance_level: The performance of system disk, only valid for ESSD disk. You have to specify one of `PL0` `PL1` `PL2` `PL3` fields.
        :param pulumi.Input[int] system_disk_size: The system disk category of worker node. Its valid value range [40~500] in GB. Default to `120`.
        :param pulumi.Input[str] system_disk_snapshot_policy_id: The system disk snapshot policy id.
        :param pulumi.Input[Mapping[str, Any]] tags: A Map of tags to assign to the resource. It will be applied for ECS instances finally. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTaintArgs']]]] taints: A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        :param pulumi.Input[bool] unschedulable: Set the newly added node as unschedulable. If you want to open the scheduling option, you can open it in the node list of the console. If you are using an auto-scaling node pool, the setting will not take effect. Default is `false`.
        :param pulumi.Input[str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: The vswitches used by node pool workers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Cluster nodepool can be imported using the id, e.g. Then complete the nodepool.tf accords to the result of `pulumi preview`.

        ```sh
         $ pulumi import alicloud:cs/nodePool:NodePool custom_nodepool cluster_id:nodepool_id
        ```

        :param str resource_name: The name of the resource.
        :param NodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cis_enabled: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cpu_policy: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolDataDiskArgs']]]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 desired_size: Optional[pulumi.Input[int]] = None,
                 format_disk: Optional[pulumi.Input[bool]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 keep_instance_name: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kubelet_configuration: Optional[pulumi.Input[pulumi.InputType['NodePoolKubeletConfigurationArgs']]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolLabelArgs']]]]] = None,
                 management: Optional[pulumi.Input[pulumi.InputType['NodePoolManagementArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_name_mode: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 polardb_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 rolling_policy: Optional[pulumi.Input[pulumi.InputType['NodePoolRollingPolicyArgs']]] = None,
                 rollout_policy: Optional[pulumi.Input[pulumi.InputType['NodePoolRolloutPolicyArgs']]] = None,
                 runtime_name: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 scaling_config: Optional[pulumi.Input[pulumi.InputType['NodePoolScalingConfigArgs']]] = None,
                 scaling_policy: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 soc_enabled: Optional[pulumi.Input[bool]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolSpotPriceLimitArgs']]]]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 system_disk_kms_key: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 system_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTaintArgs']]]]] = None,
                 unschedulable: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodePoolArgs.__new__(NodePoolArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["cis_enabled"] = cis_enabled
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["cpu_policy"] = cpu_policy
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["deployment_set_id"] = deployment_set_id
            __props__.__dict__["desired_size"] = desired_size
            __props__.__dict__["format_disk"] = format_disk
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["image_type"] = image_type
            __props__.__dict__["install_cloud_monitor"] = install_cloud_monitor
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            if instance_types is None and not opts.urn:
                raise TypeError("Missing required property 'instance_types'")
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["instances"] = instances
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["keep_instance_name"] = keep_instance_name
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["kubelet_configuration"] = kubelet_configuration
            __props__.__dict__["labels"] = labels
            __props__.__dict__["management"] = management
            __props__.__dict__["name"] = name
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["node_name_mode"] = node_name_mode
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["platform"] = platform
            __props__.__dict__["polardb_ids"] = polardb_ids
            __props__.__dict__["rds_instances"] = rds_instances
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["rolling_policy"] = rolling_policy
            __props__.__dict__["rollout_policy"] = rollout_policy
            __props__.__dict__["runtime_name"] = runtime_name
            __props__.__dict__["runtime_version"] = runtime_version
            __props__.__dict__["scaling_config"] = scaling_config
            __props__.__dict__["scaling_policy"] = scaling_policy
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["soc_enabled"] = soc_enabled
            __props__.__dict__["spot_price_limits"] = spot_price_limits
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["system_disk_category"] = system_disk_category
            __props__.__dict__["system_disk_encrypt_algorithm"] = system_disk_encrypt_algorithm
            __props__.__dict__["system_disk_encrypted"] = system_disk_encrypted
            __props__.__dict__["system_disk_kms_key"] = system_disk_kms_key
            __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["system_disk_snapshot_policy_id"] = system_disk_snapshot_policy_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["unschedulable"] = unschedulable
            __props__.__dict__["user_data"] = user_data
            if vswitch_ids is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_ids'")
            __props__.__dict__["vswitch_ids"] = vswitch_ids
            __props__.__dict__["scaling_group_id"] = None
            __props__.__dict__["vpc_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NodePool, __self__).__init__(
            'alicloud:cs/nodePool:NodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            auto_renew_period: Optional[pulumi.Input[int]] = None,
            cis_enabled: Optional[pulumi.Input[bool]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            cpu_policy: Optional[pulumi.Input[str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolDataDiskArgs']]]]] = None,
            deployment_set_id: Optional[pulumi.Input[str]] = None,
            desired_size: Optional[pulumi.Input[int]] = None,
            format_disk: Optional[pulumi.Input[bool]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            image_type: Optional[pulumi.Input[str]] = None,
            install_cloud_monitor: Optional[pulumi.Input[bool]] = None,
            instance_charge_type: Optional[pulumi.Input[str]] = None,
            instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            internet_charge_type: Optional[pulumi.Input[str]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
            keep_instance_name: Optional[pulumi.Input[bool]] = None,
            key_name: Optional[pulumi.Input[str]] = None,
            kms_encrypted_password: Optional[pulumi.Input[str]] = None,
            kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            kubelet_configuration: Optional[pulumi.Input[pulumi.InputType['NodePoolKubeletConfigurationArgs']]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolLabelArgs']]]]] = None,
            management: Optional[pulumi.Input[pulumi.InputType['NodePoolManagementArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            node_name_mode: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            platform: Optional[pulumi.Input[str]] = None,
            polardb_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            rolling_policy: Optional[pulumi.Input[pulumi.InputType['NodePoolRollingPolicyArgs']]] = None,
            rollout_policy: Optional[pulumi.Input[pulumi.InputType['NodePoolRolloutPolicyArgs']]] = None,
            runtime_name: Optional[pulumi.Input[str]] = None,
            runtime_version: Optional[pulumi.Input[str]] = None,
            scaling_config: Optional[pulumi.Input[pulumi.InputType['NodePoolScalingConfigArgs']]] = None,
            scaling_group_id: Optional[pulumi.Input[str]] = None,
            scaling_policy: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            soc_enabled: Optional[pulumi.Input[bool]] = None,
            spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolSpotPriceLimitArgs']]]]] = None,
            spot_strategy: Optional[pulumi.Input[str]] = None,
            system_disk_category: Optional[pulumi.Input[str]] = None,
            system_disk_encrypt_algorithm: Optional[pulumi.Input[str]] = None,
            system_disk_encrypted: Optional[pulumi.Input[bool]] = None,
            system_disk_kms_key: Optional[pulumi.Input[str]] = None,
            system_disk_performance_level: Optional[pulumi.Input[str]] = None,
            system_disk_size: Optional[pulumi.Input[int]] = None,
            system_disk_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTaintArgs']]]]] = None,
            unschedulable: Optional[pulumi.Input[bool]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'NodePool':
        """
        Get an existing NodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Enable Node payment auto-renew, default is `false`.
        :param pulumi.Input[int] auto_renew_period: Node payment auto-renew period, one of `1`, `2`, `3`,`6`, `12`.
        :param pulumi.Input[bool] cis_enabled: Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [CIS Reinforcement](https://help.aliyun.com/document_detail/223744.html).
        :param pulumi.Input[str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[str] cpu_policy: Kubelet cpu policy. For Kubernetes 1.12.6 and later, its valid value is either `static` or `none`. Default to `none` and modification is not supported.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolDataDiskArgs']]]] data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `data_disks` below.
        :param pulumi.Input[str] deployment_set_id: The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        :param pulumi.Input[int] desired_size: The desired size of nodes of the node pool. From version 1.158.0, `desired_size` is not required.
        :param pulumi.Input[bool] format_disk: After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        :param pulumi.Input[str] image_id: Custom Image support. Must based on CentOS7 or AliyunLinux2.
        :param pulumi.Input[str] image_type: The image type, instead of `platform`. This field cannot be modified. One of `AliyunLinux`, `AliyunLinux3`, `AliyunLinux3Arm64`, `AliyunLinuxUEFI`, `CentOS`, `Windows`,`WindowsCore`,`AliyunLinux Qboot`,`ContainerOS`. If you select `Windows` or `WindowsCore`, the `passord` is required.
        :param pulumi.Input[bool] install_cloud_monitor: Install the cloud monitoring plug-in on the node, and you can view the monitoring information of the instance through the cloud monitoring console. Default is `true`.
        :param pulumi.Input[str] instance_charge_type: Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: The instance type of worker node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: The instance list. Add existing nodes under the same cluster VPC to the node pool.
        :param pulumi.Input[str] internet_charge_type: The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        :param pulumi.Input[int] internet_max_bandwidth_out: The maximum outbound bandwidth for the public network. Unit: Mbit/s. Valid values: 0 to 100.
        :param pulumi.Input[bool] keep_instance_name: Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        :param pulumi.Input[str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields. Only `key_name` is supported in the management node pool.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[pulumi.InputType['NodePoolKubeletConfigurationArgs']] kubelet_configuration: Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolLabelArgs']]]] labels: A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        :param pulumi.Input[pulumi.InputType['NodePoolManagementArgs']] management: Managed node pool configuration. When using a managed node pool, the node key must use `key_name`. See `management` below.
        :param pulumi.Input[str] name: The name of node pool.
        :param pulumi.Input[int] node_count: The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        :param pulumi.Input[str] node_name_mode: Each node name consists of a prefix, its private network IP, and a suffix, the input format is `customized,<prefix>,ip,<suffix>`. For example "customized,aliyun.com-,ip,-test", if the node private network IP address is 192.168.59.176, the prefix is aliyun.com-,and the suffix is -test, the node name will be aliyun.com-192.168.59.176-test.
        :param pulumi.Input[str] password: The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[int] period: Node payment period. Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        :param pulumi.Input[str] period_unit: Node payment period unit, valid value: `Month`. Default is `Month`.
        :param pulumi.Input[str] platform: The platform. One of `AliyunLinux`, `Windows`, `CentOS`, `WindowsCore`. If you select `Windows` or `WindowsCore`, the `passord` is required. Field `platform` has been deprecated from provider version 1.145.0. New field `image_type` instead.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] polardb_ids: PolarDB id list, You can choose which PolarDB whitelist to add instances to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[pulumi.InputType['NodePoolRollingPolicyArgs']] rolling_policy: Rolling policy is used to specify the strategy when the node pool is rolling update. This field works when nodepool updating. See `rolling_policy` below.
        :param pulumi.Input[pulumi.InputType['NodePoolRolloutPolicyArgs']] rollout_policy: Rollout policy is used to specify the strategy when the node pool is rolling update. This field works when node pool updating. Please use `rolling_policy` to instead it from provider version 1.185.0. See `rollout_policy` below.
        :param pulumi.Input[str] runtime_name: The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        :param pulumi.Input[str] runtime_version: The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        :param pulumi.Input[pulumi.InputType['NodePoolScalingConfigArgs']] scaling_config: Auto scaling node pool configuration. See `scaling_config` below. With auto-scaling is enabled, the nodes in the node pool will be labeled with `k8s.aliyun.com=true` to prevent system pods such as coredns, metrics-servers from being scheduled to elastic nodes, and to prevent node shrinkage from causing business abnormalities.
        :param pulumi.Input[str] scaling_group_id: The scaling group id.
        :param pulumi.Input[str] scaling_policy: The scaling mode. Valid values: `release`, `recycle`, default is `release`. Standard mode(release): Create and release ECS instances based on requests.Swift mode(recycle): Create, stop, and restart ECS instances based on needs. New ECS instances are only created when no stopped ECS instance is avalible. This mode further accelerates the scaling process. Apart from ECS instances that use local storage, when an ECS instance is stopped, you are only chatged for storage space.
        :param pulumi.Input[str] security_group_id: The security group id for worker node. Field `security_group_id` has been deprecated from provider version 1.145.0. New field `security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        :param pulumi.Input[bool] soc_enabled: Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).  
               > **NOTE:** It is forbidden to set both `cis_enabled` and `soc_enabled` to `true`at the same time.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolSpotPriceLimitArgs']]]] spot_price_limits: The maximum hourly price of the instance. This parameter takes effect only when `spot_strategy` is set to `SpotWithPriceLimit`. You could enable multiple spot instances by setting this field repeatedly. See `spot_price_limit` below.
        :param pulumi.Input[str] spot_strategy: The preemption policy for the pay-as-you-go instance. This parameter takes effect only when `instance_charge_type` is set to `PostPaid`. Valid value `SpotWithPriceLimit`,`SpotAsPriceGo` and `NoSpot`, default is `NoSpot`.
        :param pulumi.Input[str] system_disk_category: The system disk category of worker node. Its valid value are `cloud_ssd`, `cloud_efficiency` and `cloud_essd`. Default to `cloud_efficiency`.
        :param pulumi.Input[str] system_disk_encrypt_algorithm: The encryption Algorithm for Encrypting System Disk. It takes effect when system_disk_encrypted is true. Valid values `aes-256` and `sm4-128`.
        :param pulumi.Input[bool] system_disk_encrypted: Whether to enable system disk encryption.
        :param pulumi.Input[str] system_disk_kms_key: The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        :param pulumi.Input[str] system_disk_performance_level: The performance of system disk, only valid for ESSD disk. You have to specify one of `PL0` `PL1` `PL2` `PL3` fields.
        :param pulumi.Input[int] system_disk_size: The system disk category of worker node. Its valid value range [40~500] in GB. Default to `120`.
        :param pulumi.Input[str] system_disk_snapshot_policy_id: The system disk snapshot policy id.
        :param pulumi.Input[Mapping[str, Any]] tags: A Map of tags to assign to the resource. It will be applied for ECS instances finally. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTaintArgs']]]] taints: A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        :param pulumi.Input[bool] unschedulable: Set the newly added node as unschedulable. If you want to open the scheduling option, you can open it in the node list of the console. If you are using an auto-scaling node pool, the setting will not take effect. Default is `false`.
        :param pulumi.Input[str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        :param pulumi.Input[str] vpc_id: The VPC of the nodes in the node pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: The vswitches used by node pool workers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodePoolState.__new__(_NodePoolState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["cis_enabled"] = cis_enabled
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cpu_policy"] = cpu_policy
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["deployment_set_id"] = deployment_set_id
        __props__.__dict__["desired_size"] = desired_size
        __props__.__dict__["format_disk"] = format_disk
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["install_cloud_monitor"] = install_cloud_monitor
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_types"] = instance_types
        __props__.__dict__["instances"] = instances
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["keep_instance_name"] = keep_instance_name
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
        __props__.__dict__["kms_encryption_context"] = kms_encryption_context
        __props__.__dict__["kubelet_configuration"] = kubelet_configuration
        __props__.__dict__["labels"] = labels
        __props__.__dict__["management"] = management
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["node_name_mode"] = node_name_mode
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["platform"] = platform
        __props__.__dict__["polardb_ids"] = polardb_ids
        __props__.__dict__["rds_instances"] = rds_instances
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["rolling_policy"] = rolling_policy
        __props__.__dict__["rollout_policy"] = rollout_policy
        __props__.__dict__["runtime_name"] = runtime_name
        __props__.__dict__["runtime_version"] = runtime_version
        __props__.__dict__["scaling_config"] = scaling_config
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["scaling_policy"] = scaling_policy
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["soc_enabled"] = soc_enabled
        __props__.__dict__["spot_price_limits"] = spot_price_limits
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["system_disk_category"] = system_disk_category
        __props__.__dict__["system_disk_encrypt_algorithm"] = system_disk_encrypt_algorithm
        __props__.__dict__["system_disk_encrypted"] = system_disk_encrypted
        __props__.__dict__["system_disk_kms_key"] = system_disk_kms_key
        __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["system_disk_snapshot_policy_id"] = system_disk_snapshot_policy_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["unschedulable"] = unschedulable
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_ids"] = vswitch_ids
        return NodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Node payment auto-renew, default is `false`.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[int]]:
        """
        Node payment auto-renew period, one of `1`, `2`, `3`,`6`, `12`.
        """
        return pulumi.get(self, "auto_renew_period")

    @property
    @pulumi.getter(name="cisEnabled")
    def cis_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [CIS Reinforcement](https://help.aliyun.com/document_detail/223744.html).
        """
        return pulumi.get(self, "cis_enabled")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="cpuPolicy")
    def cpu_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Kubelet cpu policy. For Kubernetes 1.12.6 and later, its valid value is either `static` or `none`. Default to `none` and modification is not supported.
        """
        return pulumi.get(self, "cpu_policy")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolDataDisk']]]:
        """
        The data disk configurations of worker nodes, such as the disk type and disk size. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> pulumi.Output[str]:
        """
        The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        """
        return pulumi.get(self, "deployment_set_id")

    @property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> pulumi.Output[int]:
        """
        The desired size of nodes of the node pool. From version 1.158.0, `desired_size` is not required.
        """
        return pulumi.get(self, "desired_size")

    @property
    @pulumi.getter(name="formatDisk")
    def format_disk(self) -> pulumi.Output[bool]:
        """
        After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        """
        return pulumi.get(self, "format_disk")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        Custom Image support. Must based on CentOS7 or AliyunLinux2.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[str]:
        """
        The image type, instead of `platform`. This field cannot be modified. One of `AliyunLinux`, `AliyunLinux3`, `AliyunLinux3Arm64`, `AliyunLinuxUEFI`, `CentOS`, `Windows`,`WindowsCore`,`AliyunLinux Qboot`,`ContainerOS`. If you select `Windows` or `WindowsCore`, the `passord` is required.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> pulumi.Output[Optional[bool]]:
        """
        Install the cloud monitoring plug-in on the node, and you can view the monitoring information of the instance through the cloud monitoring console. Default is `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Sequence[str]]:
        """
        The instance type of worker node.
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The instance list. Add existing nodes under the same cluster VPC to the node pool.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[str]:
        """
        The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[int]:
        """
        The maximum outbound bandwidth for the public network. Unit: Mbit/s. Valid values: 0 to 100.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @property
    @pulumi.getter(name="keepInstanceName")
    def keep_instance_name(self) -> pulumi.Output[bool]:
        """
        Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        """
        return pulumi.get(self, "keep_instance_name")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields. Only `key_name` is supported in the management node pool.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> pulumi.Output[Optional[str]]:
        """
        An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @property
    @pulumi.getter(name="kubeletConfiguration")
    def kubelet_configuration(self) -> pulumi.Output[Optional['outputs.NodePoolKubeletConfiguration']]:
        """
        Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/).
        """
        return pulumi.get(self, "kubelet_configuration")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolLabel']]]:
        """
        A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def management(self) -> pulumi.Output[Optional['outputs.NodePoolManagement']]:
        """
        Managed node pool configuration. When using a managed node pool, the node key must use `key_name`. See `management` below.
        """
        return pulumi.get(self, "management")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[int]:
        """
        The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        """
        warnings.warn("""Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""", DeprecationWarning)
        pulumi.log.warn("""node_count is deprecated: Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""")

        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeNameMode")
    def node_name_mode(self) -> pulumi.Output[str]:
        """
        Each node name consists of a prefix, its private network IP, and a suffix, the input format is `customized,<prefix>,ip,<suffix>`. For example "customized,aliyun.com-,ip,-test", if the node private network IP address is 192.168.59.176, the prefix is aliyun.com-,and the suffix is -test, the node name will be aliyun.com-192.168.59.176-test.
        """
        return pulumi.get(self, "node_name_mode")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Node payment period. Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Node payment period unit, valid value: `Month`. Default is `Month`.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[str]:
        """
        The platform. One of `AliyunLinux`, `Windows`, `CentOS`, `WindowsCore`. If you select `Windows` or `WindowsCore`, the `passord` is required. Field `platform` has been deprecated from provider version 1.145.0. New field `image_type` instead.
        """
        warnings.warn("""Field 'platform' has been deprecated from provider version 1.145.0. New field 'image_type' instead""", DeprecationWarning)
        pulumi.log.warn("""platform is deprecated: Field 'platform' has been deprecated from provider version 1.145.0. New field 'image_type' instead""")

        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="polardbIds")
    def polardb_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        PolarDB id list, You can choose which PolarDB whitelist to add instances to.
        """
        return pulumi.get(self, "polardb_ids")

    @property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="rollingPolicy")
    def rolling_policy(self) -> pulumi.Output[Optional['outputs.NodePoolRollingPolicy']]:
        """
        Rolling policy is used to specify the strategy when the node pool is rolling update. This field works when nodepool updating. See `rolling_policy` below.
        """
        return pulumi.get(self, "rolling_policy")

    @property
    @pulumi.getter(name="rolloutPolicy")
    def rollout_policy(self) -> pulumi.Output[Optional['outputs.NodePoolRolloutPolicy']]:
        """
        Rollout policy is used to specify the strategy when the node pool is rolling update. This field works when node pool updating. Please use `rolling_policy` to instead it from provider version 1.185.0. See `rollout_policy` below.
        """
        warnings.warn("""Field 'rollout_policy' has been deprecated from provider version 1.184.0. Please use new field 'rolling_policy' instead it to ensure the config takes effect""", DeprecationWarning)
        pulumi.log.warn("""rollout_policy is deprecated: Field 'rollout_policy' has been deprecated from provider version 1.184.0. Please use new field 'rolling_policy' instead it to ensure the config takes effect""")

        return pulumi.get(self, "rollout_policy")

    @property
    @pulumi.getter(name="runtimeName")
    def runtime_name(self) -> pulumi.Output[str]:
        """
        The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        """
        return pulumi.get(self, "runtime_name")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Output[str]:
        """
        The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        """
        return pulumi.get(self, "runtime_version")

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> pulumi.Output[Optional['outputs.NodePoolScalingConfig']]:
        """
        Auto scaling node pool configuration. See `scaling_config` below. With auto-scaling is enabled, the nodes in the node pool will be labeled with `k8s.aliyun.com=true` to prevent system pods such as coredns, metrics-servers from being scheduled to elastic nodes, and to prevent node shrinkage from causing business abnormalities.
        """
        return pulumi.get(self, "scaling_config")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[str]:
        """
        The scaling group id.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> pulumi.Output[str]:
        """
        The scaling mode. Valid values: `release`, `recycle`, default is `release`. Standard mode(release): Create and release ECS instances based on requests.Swift mode(recycle): Create, stop, and restart ECS instances based on needs. New ECS instances are only created when no stopped ECS instance is avalible. This mode further accelerates the scaling process. Apart from ECS instances that use local storage, when an ECS instance is stopped, you are only chatged for storage space.
        """
        return pulumi.get(self, "scaling_policy")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        The security group id for worker node. Field `security_group_id` has been deprecated from provider version 1.145.0. New field `security_group_ids` instead.
        """
        warnings.warn("""Field 'security_group_id' has been deprecated from provider version 1.145.0. New field 'security_group_ids' instead""", DeprecationWarning)
        pulumi.log.warn("""security_group_id is deprecated: Field 'security_group_id' has been deprecated from provider version 1.145.0. New field 'security_group_ids' instead""")

        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="socEnabled")
    def soc_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).  
        > **NOTE:** It is forbidden to set both `cis_enabled` and `soc_enabled` to `true`at the same time.
        """
        return pulumi.get(self, "soc_enabled")

    @property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolSpotPriceLimit']]]:
        """
        The maximum hourly price of the instance. This parameter takes effect only when `spot_strategy` is set to `SpotWithPriceLimit`. You could enable multiple spot instances by setting this field repeatedly. See `spot_price_limit` below.
        """
        return pulumi.get(self, "spot_price_limits")

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[str]:
        """
        The preemption policy for the pay-as-you-go instance. This parameter takes effect only when `instance_charge_type` is set to `PostPaid`. Valid value `SpotWithPriceLimit`,`SpotAsPriceGo` and `NoSpot`, default is `NoSpot`.
        """
        return pulumi.get(self, "spot_strategy")

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> pulumi.Output[Optional[str]]:
        """
        The system disk category of worker node. Its valid value are `cloud_ssd`, `cloud_efficiency` and `cloud_essd`. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "system_disk_category")

    @property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        The encryption Algorithm for Encrypting System Disk. It takes effect when system_disk_encrypted is true. Valid values `aes-256` and `sm4-128`.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable system disk encryption.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @property
    @pulumi.getter(name="systemDiskKmsKey")
    def system_disk_kms_key(self) -> pulumi.Output[Optional[str]]:
        """
        The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        """
        return pulumi.get(self, "system_disk_kms_key")

    @property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> pulumi.Output[Optional[str]]:
        """
        The performance of system disk, only valid for ESSD disk. You have to specify one of `PL0` `PL1` `PL2` `PL3` fields.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[Optional[int]]:
        """
        The system disk category of worker node. Its valid value range [40~500] in GB. Default to `120`.
        """
        return pulumi.get(self, "system_disk_size")

    @property
    @pulumi.getter(name="systemDiskSnapshotPolicyId")
    def system_disk_snapshot_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        The system disk snapshot policy id.
        """
        return pulumi.get(self, "system_disk_snapshot_policy_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A Map of tags to assign to the resource. It will be applied for ECS instances finally. Detailed below.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolTaint']]]:
        """
        A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter
    def unschedulable(self) -> pulumi.Output[Optional[bool]]:
        """
        Set the newly added node as unschedulable. If you want to open the scheduling option, you can open it in the node list of the console. If you are using an auto-scaling node pool, the setting will not take effect. Default is `false`.
        """
        return pulumi.get(self, "unschedulable")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC of the nodes in the node pool.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The vswitches used by node pool workers.
        """
        return pulumi.get(self, "vswitch_ids")

