# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationService',
    'ClusterNode',
    'EdgeKubernetesAddon',
    'EdgeKubernetesCertificateAuthority',
    'EdgeKubernetesConnections',
    'EdgeKubernetesLogConfig',
    'EdgeKubernetesRuntime',
    'EdgeKubernetesWorkerDataDisk',
    'EdgeKubernetesWorkerNode',
    'KubernetesAddon',
    'KubernetesAutoscalerNodepool',
    'KubernetesCertificateAuthority',
    'KubernetesConnections',
    'KubernetesMasterNode',
    'KubernetesPermissionPermission',
    'KubernetesRuntime',
    'ManagedKubernetesAddon',
    'ManagedKubernetesCertificateAuthority',
    'ManagedKubernetesConnections',
    'ManagedKubernetesMaintenanceWindow',
    'ManagedKubernetesRrsaMetadata',
    'NodePoolDataDisk',
    'NodePoolKubeletConfiguration',
    'NodePoolLabel',
    'NodePoolManagement',
    'NodePoolRollingPolicy',
    'NodePoolRolloutPolicy',
    'NodePoolScalingConfig',
    'NodePoolSpotPriceLimit',
    'NodePoolTaint',
    'ServerlessKubernetesAddon',
    'ServerlessKubernetesRrsaMetadata',
    'SwarmNode',
    'GetClusterCredentialCertificateAuthorityResult',
    'GetEdgeKubernetesClustersClusterResult',
    'GetEdgeKubernetesClustersClusterConnectionsResult',
    'GetEdgeKubernetesClustersClusterWorkerNodeResult',
    'GetKubernetesAddonsAddonResult',
    'GetKubernetesClustersClusterResult',
    'GetKubernetesClustersClusterConnectionsResult',
    'GetKubernetesClustersClusterLogConfigResult',
    'GetKubernetesClustersClusterMasterNodeResult',
    'GetKubernetesClustersClusterWorkerNodeResult',
    'GetKubernetesPermissionPermissionResult',
    'GetKubernetesVersionMetadataResult',
    'GetKubernetesVersionMetadataRuntimeResult',
    'GetManagedKubernetesClustersClusterResult',
    'GetManagedKubernetesClustersClusterConnectionsResult',
    'GetManagedKubernetesClustersClusterLogConfigResult',
    'GetManagedKubernetesClustersClusterWorkerNodeResult',
    'GetRegistryEnterpriseInstancesInstanceResult',
    'GetRegistryEnterpriseNamespacesNamespaceResult',
    'GetRegistryEnterpriseReposRepoResult',
    'GetRegistryEnterpriseReposRepoTagResult',
    'GetRegistryEnterpriseSyncRulesRuleResult',
    'GetServerlessKubernetesClustersClusterResult',
    'GetServerlessKubernetesClustersClusterConnectionsResult',
]

@pulumi.output_type
class ApplicationService(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 status: Optional[str] = None,
                 version: Optional[str] = None):
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class ClusterNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eip: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip: Optional[str] = None,
                 status: Optional[str] = None):
        if eip is not None:
            pulumi.set(__self__, "eip", eip)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def eip(self) -> Optional[str]:
        return pulumi.get(self, "eip")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


@pulumi.output_type
class EdgeKubernetesAddon(dict):
    def __init__(__self__, *,
                 config: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 name: Optional[str] = None):
        """
        :param str config: The ACK add-on configurations.
        :param bool disabled: Disables the automatic installation of a component. Default is `false`.
               
               The following example is the definition of addons block, The type of this field is list:
        :param str name: Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def config(self) -> Optional[str]:
        """
        The ACK add-on configurations.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Disables the automatic installation of a component. Default is `false`.

        The following example is the definition of addons block, The type of this field is list:
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class EdgeKubernetesCertificateAuthority(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCert":
            suggest = "client_cert"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clusterCert":
            suggest = "cluster_cert"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeKubernetesCertificateAuthority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeKubernetesCertificateAuthority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeKubernetesCertificateAuthority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_cert: Optional[str] = None,
                 client_key: Optional[str] = None,
                 cluster_cert: Optional[str] = None):
        """
        :param str client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param str client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param str cluster_cert: The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_cert is not None:
            pulumi.set(__self__, "cluster_cert", cluster_cert)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[str]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCert")
    def cluster_cert(self) -> Optional[str]:
        """
        The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        return pulumi.get(self, "cluster_cert")


@pulumi.output_type
class EdgeKubernetesConnections(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiServerInternet":
            suggest = "api_server_internet"
        elif key == "apiServerIntranet":
            suggest = "api_server_intranet"
        elif key == "masterPublicIp":
            suggest = "master_public_ip"
        elif key == "serviceDomain":
            suggest = "service_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeKubernetesConnections. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeKubernetesConnections.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeKubernetesConnections.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_server_internet: Optional[str] = None,
                 api_server_intranet: Optional[str] = None,
                 master_public_ip: Optional[str] = None,
                 service_domain: Optional[str] = None):
        """
        :param str api_server_internet: API Server Internet endpoint.
        :param str api_server_intranet: API Server Intranet endpoint.
        :param str master_public_ip: Master node SSH IP address.
        :param str service_domain: Service Access Domain.
        """
        if api_server_internet is not None:
            pulumi.set(__self__, "api_server_internet", api_server_internet)
        if api_server_intranet is not None:
            pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        if master_public_ip is not None:
            pulumi.set(__self__, "master_public_ip", master_public_ip)
        if service_domain is not None:
            pulumi.set(__self__, "service_domain", service_domain)

    @property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> Optional[str]:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> Optional[str]:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> Optional[str]:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")

    @property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> Optional[str]:
        """
        Service Access Domain.
        """
        return pulumi.get(self, "service_domain")


@pulumi.output_type
class EdgeKubernetesLogConfig(dict):
    def __init__(__self__, *,
                 type: str,
                 project: Optional[str] = None):
        """
        :param str type: Type of collecting logs, only `SLS` are supported currently.
        :param str project: Log Service project name, cluster logs will output to this project.
        """
        pulumi.set(__self__, "type", type)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of collecting logs, only `SLS` are supported currently.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        """
        Log Service project name, cluster logs will output to this project.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class EdgeKubernetesRuntime(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param str version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class EdgeKubernetesWorkerDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoSnapshotPolicyId":
            suggest = "auto_snapshot_policy_id"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "performanceLevel":
            suggest = "performance_level"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeKubernetesWorkerDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeKubernetesWorkerDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeKubernetesWorkerDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_snapshot_policy_id: Optional[str] = None,
                 category: Optional[str] = None,
                 device: Optional[str] = None,
                 encrypted: Optional[str] = None,
                 kms_key_id: Optional[str] = None,
                 name: Optional[str] = None,
                 performance_level: Optional[str] = None,
                 size: Optional[str] = None,
                 snapshot_id: Optional[str] = None):
        """
        :param str auto_snapshot_policy_id: Worker node data disk auto snapshot policy.
        :param str category: The type of the data disks. Valid values: `cloud`, `cloud_efficiency`, `cloud_ssd` and `cloud_essd`. Default to `cloud_efficiency`.
        :param str device: The device of the data disks.
        :param str encrypted: Specifies whether to encrypt data disks. Valid values: true and false. Default is `false`.
        :param str kms_key_id: The id of the kms key.
        :param str name: The name of the data disks.
        :param str performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param str size: The size of a data disk, at least 40. Unit: GiB.
        :param str snapshot_id: The id of snapshot.
        """
        if auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> Optional[str]:
        """
        Worker node data disk auto snapshot policy.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        The type of the data disks. Valid values: `cloud`, `cloud_efficiency`, `cloud_ssd` and `cloud_essd`. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def device(self) -> Optional[str]:
        """
        The device of the data disks.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[str]:
        """
        Specifies whether to encrypt data disks. Valid values: true and false. Default is `false`.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The id of the kms key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the data disks.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[str]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The id of snapshot.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class EdgeKubernetesWorkerNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeKubernetesWorkerNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeKubernetesWorkerNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeKubernetesWorkerNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip: Optional[str] = None):
        """
        :param str id: ID of the node.
        :param str name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param str private_ip: The private IP address of node.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class KubernetesAddon(dict):
    def __init__(__self__, *,
                 config: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str config: The ACK add-on configurations.
        :param bool disabled: Disables the automatic installation of a component. Default is `false`.
               
               The following example is the definition of addons block, The type of this field is list:
        :param str name: Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        :param str version: The version of the component.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def config(self) -> Optional[str]:
        """
        The ACK add-on configurations.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Disables the automatic installation of a component. Default is `false`.

        The following example is the definition of addons block, The type of this field is list:
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the component.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class KubernetesAutoscalerNodepool(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 labels: Optional[str] = None,
                 taints: Optional[str] = None):
        """
        :param str id: The scaling group id of the groups configured for cluster-autoscaler.
        :param str labels: The labels for the nodes in scaling group.
        :param str taints: The taints for the nodes in scaling group.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The scaling group id of the groups configured for cluster-autoscaler.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Optional[str]:
        """
        The labels for the nodes in scaling group.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def taints(self) -> Optional[str]:
        """
        The taints for the nodes in scaling group.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class KubernetesCertificateAuthority(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCert":
            suggest = "client_cert"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clusterCert":
            suggest = "cluster_cert"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesCertificateAuthority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesCertificateAuthority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesCertificateAuthority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_cert: Optional[str] = None,
                 client_key: Optional[str] = None,
                 cluster_cert: Optional[str] = None):
        """
        :param str client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param str client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param str cluster_cert: The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_cert is not None:
            pulumi.set(__self__, "cluster_cert", cluster_cert)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[str]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCert")
    def cluster_cert(self) -> Optional[str]:
        """
        The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        return pulumi.get(self, "cluster_cert")


@pulumi.output_type
class KubernetesConnections(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiServerInternet":
            suggest = "api_server_internet"
        elif key == "apiServerIntranet":
            suggest = "api_server_intranet"
        elif key == "masterPublicIp":
            suggest = "master_public_ip"
        elif key == "serviceDomain":
            suggest = "service_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesConnections. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesConnections.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesConnections.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_server_internet: Optional[str] = None,
                 api_server_intranet: Optional[str] = None,
                 master_public_ip: Optional[str] = None,
                 service_domain: Optional[str] = None):
        """
        :param str api_server_internet: API Server Internet endpoint.
        :param str api_server_intranet: API Server Intranet endpoint.
        :param str master_public_ip: Master node SSH IP address.
        :param str service_domain: Service Access Domain.
        """
        if api_server_internet is not None:
            pulumi.set(__self__, "api_server_internet", api_server_internet)
        if api_server_intranet is not None:
            pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        if master_public_ip is not None:
            pulumi.set(__self__, "master_public_ip", master_public_ip)
        if service_domain is not None:
            pulumi.set(__self__, "service_domain", service_domain)

    @property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> Optional[str]:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> Optional[str]:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> Optional[str]:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")

    @property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> Optional[str]:
        """
        Service Access Domain.
        """
        return pulumi.get(self, "service_domain")


@pulumi.output_type
class KubernetesMasterNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesMasterNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesMasterNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesMasterNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip: Optional[str] = None):
        """
        :param str id: ID of the node.
        :param str name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param str private_ip: The private IP address of node.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class KubernetesPermissionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleName":
            suggest = "role_name"
        elif key == "roleType":
            suggest = "role_type"
        elif key == "isCustom":
            suggest = "is_custom"
        elif key == "isRamRole":
            suggest = "is_ram_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesPermissionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesPermissionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesPermissionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster: str,
                 role_name: str,
                 role_type: str,
                 is_custom: Optional[bool] = None,
                 is_ram_role: Optional[bool] = None,
                 namespace: Optional[str] = None):
        """
        :param str cluster: The ID of the cluster that you want to manage.
        :param str role_name: Specifies the predefined role that you want to assign. Valid values `admin`, `ops`, `dev`, `restricted` and the custom cluster roles.
        :param str role_type: The authorization type. Valid values `cluster`, `namespace`.
        :param bool is_custom: Specifies whether to perform a custom authorization. To perform a custom authorization, set `role_name` to a custom cluster role.
        :param bool is_ram_role: Specifies whether the permissions are granted to a RAM role. When `uid` is ram role id, the value of `is_ram_role` must be `true`.
        :param str namespace: The namespace to which the permissions are scoped. This parameter is required only if you set role_type to namespace.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "role_name", role_name)
        pulumi.set(__self__, "role_type", role_type)
        if is_custom is not None:
            pulumi.set(__self__, "is_custom", is_custom)
        if is_ram_role is not None:
            pulumi.set(__self__, "is_ram_role", is_ram_role)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def cluster(self) -> str:
        """
        The ID of the cluster that you want to manage.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> str:
        """
        Specifies the predefined role that you want to assign. Valid values `admin`, `ops`, `dev`, `restricted` and the custom cluster roles.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> str:
        """
        The authorization type. Valid values `cluster`, `namespace`.
        """
        return pulumi.get(self, "role_type")

    @property
    @pulumi.getter(name="isCustom")
    def is_custom(self) -> Optional[bool]:
        """
        Specifies whether to perform a custom authorization. To perform a custom authorization, set `role_name` to a custom cluster role.
        """
        return pulumi.get(self, "is_custom")

    @property
    @pulumi.getter(name="isRamRole")
    def is_ram_role(self) -> Optional[bool]:
        """
        Specifies whether the permissions are granted to a RAM role. When `uid` is ram role id, the value of `is_ram_role` must be `true`.
        """
        return pulumi.get(self, "is_ram_role")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace to which the permissions are scoped. This parameter is required only if you set role_type to namespace.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class KubernetesRuntime(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param str version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ManagedKubernetesAddon(dict):
    def __init__(__self__, *,
                 config: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str config: If this parameter is left empty, no configurations are required.
        :param bool disabled: It specifies whether to disable automatic installation. 
               
               It is a new field since 1.75.0. You can specific network plugin, log component,ingress component and so on.
               
               You can get more information about addons on ACK web console. When you create a ACK cluster. You can get openapi-spec before creating the cluster on submission page.
               
               `logtail-ds` - You can specify `IngressDashboardEnabled` and `sls_project_name` in config. If you switch on `IngressDashboardEnabled` and `sls_project_name`,then logtail-ds would use `sls_project_name` as default log store.
               
               `nginx-ingress-controller` - You can specific `IngressSlbNetworkType` in config. Options: internet|intranet.
               
               The `main.tf`:
               
               
               The `varibales.tf`:
        :param str name: This parameter specifies the name of the component.
        :param str version: It specifies the version of the component.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def config(self) -> Optional[str]:
        """
        If this parameter is left empty, no configurations are required.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        It specifies whether to disable automatic installation. 

        It is a new field since 1.75.0. You can specific network plugin, log component,ingress component and so on.

        You can get more information about addons on ACK web console. When you create a ACK cluster. You can get openapi-spec before creating the cluster on submission page.

        `logtail-ds` - You can specify `IngressDashboardEnabled` and `sls_project_name` in config. If you switch on `IngressDashboardEnabled` and `sls_project_name`,then logtail-ds would use `sls_project_name` as default log store.

        `nginx-ingress-controller` - You can specific `IngressSlbNetworkType` in config. Options: internet|intranet.

        The `main.tf`:


        The `varibales.tf`:
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        This parameter specifies the name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        It specifies the version of the component.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ManagedKubernetesCertificateAuthority(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCert":
            suggest = "client_cert"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clusterCert":
            suggest = "cluster_cert"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedKubernetesCertificateAuthority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedKubernetesCertificateAuthority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedKubernetesCertificateAuthority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_cert: Optional[str] = None,
                 client_key: Optional[str] = None,
                 cluster_cert: Optional[str] = None):
        """
        :param str client_cert: The path of client certificate, like `~/.kube/client-cert.pem`.
        :param str client_key: The path of client key, like `~/.kube/client-key.pem`.
        :param str cluster_cert: The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_cert is not None:
            pulumi.set(__self__, "cluster_cert", cluster_cert)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[str]:
        """
        The path of client certificate, like `~/.kube/client-cert.pem`.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        The path of client key, like `~/.kube/client-key.pem`.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCert")
    def cluster_cert(self) -> Optional[str]:
        """
        The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        return pulumi.get(self, "cluster_cert")


@pulumi.output_type
class ManagedKubernetesConnections(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiServerInternet":
            suggest = "api_server_internet"
        elif key == "apiServerIntranet":
            suggest = "api_server_intranet"
        elif key == "masterPublicIp":
            suggest = "master_public_ip"
        elif key == "serviceDomain":
            suggest = "service_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedKubernetesConnections. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedKubernetesConnections.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedKubernetesConnections.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_server_internet: Optional[str] = None,
                 api_server_intranet: Optional[str] = None,
                 master_public_ip: Optional[str] = None,
                 service_domain: Optional[str] = None):
        """
        :param str api_server_internet: API Server Internet endpoint.
        :param str api_server_intranet: API Server Intranet endpoint.
        :param str master_public_ip: Master node SSH IP address.
        :param str service_domain: Service Access Domain.
        """
        if api_server_internet is not None:
            pulumi.set(__self__, "api_server_internet", api_server_internet)
        if api_server_intranet is not None:
            pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        if master_public_ip is not None:
            pulumi.set(__self__, "master_public_ip", master_public_ip)
        if service_domain is not None:
            pulumi.set(__self__, "service_domain", service_domain)

    @property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> Optional[str]:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> Optional[str]:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> Optional[str]:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")

    @property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> Optional[str]:
        """
        Service Access Domain.
        """
        return pulumi.get(self, "service_domain")


@pulumi.output_type
class ManagedKubernetesMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceTime":
            suggest = "maintenance_time"
        elif key == "weeklyPeriod":
            suggest = "weekly_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedKubernetesMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedKubernetesMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedKubernetesMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 enable: bool,
                 maintenance_time: str,
                 weekly_period: str):
        """
        :param str duration: The maintenance time, values range from 1 to 24,unit is hour. For example: "3h".
        :param bool enable: Whether to open the maintenance window. The following parameters take effect only `enable = true`.
        :param str maintenance_time: Initial maintenance time, For example:"03:00:00Z".
        :param str weekly_period: Maintenance cycle, you can set the values from Monday to Sunday, separated by commas when the values are multiple. The default is Thursday.
               
               for example:
               ```python
               import pulumi
               ```
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_time", maintenance_time)
        pulumi.set(__self__, "weekly_period", weekly_period)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        The maintenance time, values range from 1 to 24,unit is hour. For example: "3h".
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        Whether to open the maintenance window. The following parameters take effect only `enable = true`.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> str:
        """
        Initial maintenance time, For example:"03:00:00Z".
        """
        return pulumi.get(self, "maintenance_time")

    @property
    @pulumi.getter(name="weeklyPeriod")
    def weekly_period(self) -> str:
        """
        Maintenance cycle, you can set the values from Monday to Sunday, separated by commas when the values are multiple. The default is Thursday.

        for example:
        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "weekly_period")


@pulumi.output_type
class ManagedKubernetesRrsaMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ramOidcProviderArn":
            suggest = "ram_oidc_provider_arn"
        elif key == "ramOidcProviderName":
            suggest = "ram_oidc_provider_name"
        elif key == "rrsaOidcIssuerUrl":
            suggest = "rrsa_oidc_issuer_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedKubernetesRrsaMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedKubernetesRrsaMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedKubernetesRrsaMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 ram_oidc_provider_arn: Optional[str] = None,
                 ram_oidc_provider_name: Optional[str] = None,
                 rrsa_oidc_issuer_url: Optional[str] = None):
        """
        :param bool enabled: Whether the RRSA feature has been enabled.
        :param str ram_oidc_provider_arn: The arn of OIDC provider that was registered in RAM.
        :param str ram_oidc_provider_name: The name of OIDC Provider that was registered in RAM.
        :param str rrsa_oidc_issuer_url: The issuer URL of RRSA OIDC Token.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ram_oidc_provider_arn is not None:
            pulumi.set(__self__, "ram_oidc_provider_arn", ram_oidc_provider_arn)
        if ram_oidc_provider_name is not None:
            pulumi.set(__self__, "ram_oidc_provider_name", ram_oidc_provider_name)
        if rrsa_oidc_issuer_url is not None:
            pulumi.set(__self__, "rrsa_oidc_issuer_url", rrsa_oidc_issuer_url)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether the RRSA feature has been enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ramOidcProviderArn")
    def ram_oidc_provider_arn(self) -> Optional[str]:
        """
        The arn of OIDC provider that was registered in RAM.
        """
        return pulumi.get(self, "ram_oidc_provider_arn")

    @property
    @pulumi.getter(name="ramOidcProviderName")
    def ram_oidc_provider_name(self) -> Optional[str]:
        """
        The name of OIDC Provider that was registered in RAM.
        """
        return pulumi.get(self, "ram_oidc_provider_name")

    @property
    @pulumi.getter(name="rrsaOidcIssuerUrl")
    def rrsa_oidc_issuer_url(self) -> Optional[str]:
        """
        The issuer URL of RRSA OIDC Token.
        """
        return pulumi.get(self, "rrsa_oidc_issuer_url")


@pulumi.output_type
class NodePoolDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoSnapshotPolicyId":
            suggest = "auto_snapshot_policy_id"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "performanceLevel":
            suggest = "performance_level"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_snapshot_policy_id: Optional[str] = None,
                 category: Optional[str] = None,
                 device: Optional[str] = None,
                 encrypted: Optional[str] = None,
                 kms_key_id: Optional[str] = None,
                 name: Optional[str] = None,
                 performance_level: Optional[str] = None,
                 size: Optional[int] = None,
                 snapshot_id: Optional[str] = None):
        """
        :param str auto_snapshot_policy_id: The ID of the automatic snapshot policy that you want to apply to the system disk.
        :param str category: The type of the data disks. Valid values:`cloud`, `cloud_efficiency`, `cloud_ssd` and `cloud_essd`.
        :param str device: The mount target of data disk N. Valid values of N: 1 to 16. If you do not specify this parameter, the system automatically assigns a mount target when Auto Scaling creates ECS instances. The name of the mount target ranges from /dev/xvdb to /dev/xvdz.
        :param str encrypted: Specifies whether to encrypt data disks. Valid values: true and false. Default to `false`.
        :param str kms_key_id: The kms key id used to encrypt the data disk. It takes effect when `encrypted` is true.
        :param str name: The name of data disk N. Valid values of N: 1 to 16. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        :param str performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param int size: The size of a data disk, Its valid value range [40~32768] in GB. Default to `40`.
        :param str snapshot_id: The ID of the snapshot that you want to use to create data disk N. Valid values of N: 1 to 16. If you specify this parameter, DataDisk.N.Size is ignored. The size of the disk is the same as the size of the specified snapshot. If you specify a snapshot that is created on or before July 15, 2013, the operation fails and InvalidSnapshot.TooOld is returned.
        """
        if auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> Optional[str]:
        """
        The ID of the automatic snapshot policy that you want to apply to the system disk.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        The type of the data disks. Valid values:`cloud`, `cloud_efficiency`, `cloud_ssd` and `cloud_essd`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def device(self) -> Optional[str]:
        """
        The mount target of data disk N. Valid values of N: 1 to 16. If you do not specify this parameter, the system automatically assigns a mount target when Auto Scaling creates ECS instances. The name of the mount target ranges from /dev/xvdb to /dev/xvdz.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[str]:
        """
        Specifies whether to encrypt data disks. Valid values: true and false. Default to `false`.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The kms key id used to encrypt the data disk. It takes effect when `encrypted` is true.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of data disk N. Valid values of N: 1 to 16. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[str]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        The size of a data disk, Its valid value range [40~32768] in GB. Default to `40`.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The ID of the snapshot that you want to use to create data disk N. Valid values of N: 1 to 16. If you specify this parameter, DataDisk.N.Size is ignored. The size of the disk is the same as the size of the specified snapshot. If you specify a snapshot that is created on or before July 15, 2013, the operation fails and InvalidSnapshot.TooOld is returned.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class NodePoolKubeletConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuManagerPolicy":
            suggest = "cpu_manager_policy"
        elif key == "eventBurst":
            suggest = "event_burst"
        elif key == "eventRecordQps":
            suggest = "event_record_qps"
        elif key == "evictionHard":
            suggest = "eviction_hard"
        elif key == "evictionSoft":
            suggest = "eviction_soft"
        elif key == "evictionSoftGracePeriod":
            suggest = "eviction_soft_grace_period"
        elif key == "kubeApiBurst":
            suggest = "kube_api_burst"
        elif key == "kubeApiQps":
            suggest = "kube_api_qps"
        elif key == "kubeReserved":
            suggest = "kube_reserved"
        elif key == "registryBurst":
            suggest = "registry_burst"
        elif key == "registryPullQps":
            suggest = "registry_pull_qps"
        elif key == "serializeImagePulls":
            suggest = "serialize_image_pulls"
        elif key == "systemReserved":
            suggest = "system_reserved"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolKubeletConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolKubeletConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolKubeletConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_manager_policy: Optional[str] = None,
                 event_burst: Optional[str] = None,
                 event_record_qps: Optional[str] = None,
                 eviction_hard: Optional[Mapping[str, Any]] = None,
                 eviction_soft: Optional[Mapping[str, Any]] = None,
                 eviction_soft_grace_period: Optional[Mapping[str, Any]] = None,
                 kube_api_burst: Optional[str] = None,
                 kube_api_qps: Optional[str] = None,
                 kube_reserved: Optional[Mapping[str, Any]] = None,
                 registry_burst: Optional[str] = None,
                 registry_pull_qps: Optional[str] = None,
                 serialize_image_pulls: Optional[str] = None,
                 system_reserved: Optional[Mapping[str, Any]] = None):
        """
        :param str cpu_manager_policy: Same as cpuManagerPolicy. The name of the policy to use. Requires the CPUManager feature gate to be enabled. Valid value is `none` or `static`.
        :param str event_burst: Same as eventBurst. The maximum size of a burst of event creations, temporarily allows event creations to burst to this number, while still not exceeding `event_record_qps`. It is only used when `event_record_qps` is greater than 0. Valid value is `[0-100]`.
        :param str event_record_qps: Same as eventRecordQPS. The maximum event creations per second. If 0, there is no limit enforced. Valid value is `[0-50]`.
        :param Mapping[str, Any] eviction_hard: Same as evictionHard. The map of signal names to quantities that defines hard eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        :param Mapping[str, Any] eviction_soft: Same as evictionSoft. The map of signal names to quantities that defines soft eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        :param Mapping[str, Any] eviction_soft_grace_period: Same as evictionSoftGracePeriod. The map of signal names to quantities that defines grace periods for each soft eviction signal. For example: `{"memory.available" = "30s"}`.
        :param str kube_api_burst: Same as kubeAPIBurst. The burst to allow while talking with kubernetes api-server. Valid value is `[0-100]`.
        :param str kube_api_qps: Same as kubeAPIQPS. The QPS to use while talking with kubernetes api-server. Valid value is `[0-50]`.
        :param Mapping[str, Any] kube_reserved: Same as kubeReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently, cpu, memory and local storage for root file system are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        :param str registry_burst: Same as registryBurst. The maximum size of burst pulls, temporarily allows pulls to burst to this number, while still not exceeding `registry_pull_qps`. Only used if `registry_pull_qps` is greater than 0. Valid value is `[0-100]`.
        :param str registry_pull_qps: Same as registryPullQPS. The limit of registry pulls per second. Setting it to `0` means no limit. Valid value is `[0-50]`.
        :param str serialize_image_pulls: Same as serializeImagePulls. When enabled, it tells the Kubelet to pull images one at a time. We recommend not changing the default value on nodes that run docker daemon with version < 1.9 or an Aufs storage backend. Valid value is `true` or `false`.
        :param Mapping[str, Any] system_reserved: Same as systemReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently, only cpu and memory are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        """
        if cpu_manager_policy is not None:
            pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)
        if event_burst is not None:
            pulumi.set(__self__, "event_burst", event_burst)
        if event_record_qps is not None:
            pulumi.set(__self__, "event_record_qps", event_record_qps)
        if eviction_hard is not None:
            pulumi.set(__self__, "eviction_hard", eviction_hard)
        if eviction_soft is not None:
            pulumi.set(__self__, "eviction_soft", eviction_soft)
        if eviction_soft_grace_period is not None:
            pulumi.set(__self__, "eviction_soft_grace_period", eviction_soft_grace_period)
        if kube_api_burst is not None:
            pulumi.set(__self__, "kube_api_burst", kube_api_burst)
        if kube_api_qps is not None:
            pulumi.set(__self__, "kube_api_qps", kube_api_qps)
        if kube_reserved is not None:
            pulumi.set(__self__, "kube_reserved", kube_reserved)
        if registry_burst is not None:
            pulumi.set(__self__, "registry_burst", registry_burst)
        if registry_pull_qps is not None:
            pulumi.set(__self__, "registry_pull_qps", registry_pull_qps)
        if serialize_image_pulls is not None:
            pulumi.set(__self__, "serialize_image_pulls", serialize_image_pulls)
        if system_reserved is not None:
            pulumi.set(__self__, "system_reserved", system_reserved)

    @property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> Optional[str]:
        """
        Same as cpuManagerPolicy. The name of the policy to use. Requires the CPUManager feature gate to be enabled. Valid value is `none` or `static`.
        """
        return pulumi.get(self, "cpu_manager_policy")

    @property
    @pulumi.getter(name="eventBurst")
    def event_burst(self) -> Optional[str]:
        """
        Same as eventBurst. The maximum size of a burst of event creations, temporarily allows event creations to burst to this number, while still not exceeding `event_record_qps`. It is only used when `event_record_qps` is greater than 0. Valid value is `[0-100]`.
        """
        return pulumi.get(self, "event_burst")

    @property
    @pulumi.getter(name="eventRecordQps")
    def event_record_qps(self) -> Optional[str]:
        """
        Same as eventRecordQPS. The maximum event creations per second. If 0, there is no limit enforced. Valid value is `[0-50]`.
        """
        return pulumi.get(self, "event_record_qps")

    @property
    @pulumi.getter(name="evictionHard")
    def eviction_hard(self) -> Optional[Mapping[str, Any]]:
        """
        Same as evictionHard. The map of signal names to quantities that defines hard eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        """
        return pulumi.get(self, "eviction_hard")

    @property
    @pulumi.getter(name="evictionSoft")
    def eviction_soft(self) -> Optional[Mapping[str, Any]]:
        """
        Same as evictionSoft. The map of signal names to quantities that defines soft eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        """
        return pulumi.get(self, "eviction_soft")

    @property
    @pulumi.getter(name="evictionSoftGracePeriod")
    def eviction_soft_grace_period(self) -> Optional[Mapping[str, Any]]:
        """
        Same as evictionSoftGracePeriod. The map of signal names to quantities that defines grace periods for each soft eviction signal. For example: `{"memory.available" = "30s"}`.
        """
        return pulumi.get(self, "eviction_soft_grace_period")

    @property
    @pulumi.getter(name="kubeApiBurst")
    def kube_api_burst(self) -> Optional[str]:
        """
        Same as kubeAPIBurst. The burst to allow while talking with kubernetes api-server. Valid value is `[0-100]`.
        """
        return pulumi.get(self, "kube_api_burst")

    @property
    @pulumi.getter(name="kubeApiQps")
    def kube_api_qps(self) -> Optional[str]:
        """
        Same as kubeAPIQPS. The QPS to use while talking with kubernetes api-server. Valid value is `[0-50]`.
        """
        return pulumi.get(self, "kube_api_qps")

    @property
    @pulumi.getter(name="kubeReserved")
    def kube_reserved(self) -> Optional[Mapping[str, Any]]:
        """
        Same as kubeReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently, cpu, memory and local storage for root file system are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        """
        return pulumi.get(self, "kube_reserved")

    @property
    @pulumi.getter(name="registryBurst")
    def registry_burst(self) -> Optional[str]:
        """
        Same as registryBurst. The maximum size of burst pulls, temporarily allows pulls to burst to this number, while still not exceeding `registry_pull_qps`. Only used if `registry_pull_qps` is greater than 0. Valid value is `[0-100]`.
        """
        return pulumi.get(self, "registry_burst")

    @property
    @pulumi.getter(name="registryPullQps")
    def registry_pull_qps(self) -> Optional[str]:
        """
        Same as registryPullQPS. The limit of registry pulls per second. Setting it to `0` means no limit. Valid value is `[0-50]`.
        """
        return pulumi.get(self, "registry_pull_qps")

    @property
    @pulumi.getter(name="serializeImagePulls")
    def serialize_image_pulls(self) -> Optional[str]:
        """
        Same as serializeImagePulls. When enabled, it tells the Kubelet to pull images one at a time. We recommend not changing the default value on nodes that run docker daemon with version < 1.9 or an Aufs storage backend. Valid value is `true` or `false`.
        """
        return pulumi.get(self, "serialize_image_pulls")

    @property
    @pulumi.getter(name="systemReserved")
    def system_reserved(self) -> Optional[Mapping[str, Any]]:
        """
        Same as systemReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently, only cpu and memory are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        """
        return pulumi.get(self, "system_reserved")


@pulumi.output_type
class NodePoolLabel(dict):
    def __init__(__self__, *,
                 key: str,
                 value: Optional[str] = None):
        """
        :param str key: The label key.
        :param str value: The label value.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The label value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NodePoolManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnavailable":
            suggest = "max_unavailable"
        elif key == "autoRepair":
            suggest = "auto_repair"
        elif key == "autoUpgrade":
            suggest = "auto_upgrade"
        elif key == "surgePercentage":
            suggest = "surge_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unavailable: int,
                 auto_repair: Optional[bool] = None,
                 auto_upgrade: Optional[bool] = None,
                 surge: Optional[int] = None,
                 surge_percentage: Optional[int] = None):
        """
        :param int max_unavailable: Max number of unavailable nodes. Default to `1`.
        :param bool auto_repair: Whether automatic repair, Default to `false`.
        :param bool auto_upgrade: Whether auto upgrade, Default to `false`.
        :param int surge: Number of additional nodes. You have to specify one of surge, surge_percentage.
        :param int surge_percentage: Proportion of additional nodes. You have to specify one of surge, surge_percentage.
        """
        pulumi.set(__self__, "max_unavailable", max_unavailable)
        if auto_repair is not None:
            pulumi.set(__self__, "auto_repair", auto_repair)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if surge is not None:
            pulumi.set(__self__, "surge", surge)
        if surge_percentage is not None:
            pulumi.set(__self__, "surge_percentage", surge_percentage)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> int:
        """
        Max number of unavailable nodes. Default to `1`.
        """
        return pulumi.get(self, "max_unavailable")

    @property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> Optional[bool]:
        """
        Whether automatic repair, Default to `false`.
        """
        return pulumi.get(self, "auto_repair")

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[bool]:
        """
        Whether auto upgrade, Default to `false`.
        """
        return pulumi.get(self, "auto_upgrade")

    @property
    @pulumi.getter
    def surge(self) -> Optional[int]:
        """
        Number of additional nodes. You have to specify one of surge, surge_percentage.
        """
        return pulumi.get(self, "surge")

    @property
    @pulumi.getter(name="surgePercentage")
    def surge_percentage(self) -> Optional[int]:
        """
        Proportion of additional nodes. You have to specify one of surge, surge_percentage.
        """
        return pulumi.get(self, "surge_percentage")


@pulumi.output_type
class NodePoolRollingPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxParallelism":
            suggest = "max_parallelism"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolRollingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolRollingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolRollingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_parallelism: Optional[int] = None):
        """
        :param int max_parallelism: Maximum parallel number nodes during rolling upgrade. The value of this field should be greater than `0`, and if it's set to a number less than or equal to `0`, the default setting will be used.
        """
        if max_parallelism is not None:
            pulumi.set(__self__, "max_parallelism", max_parallelism)

    @property
    @pulumi.getter(name="maxParallelism")
    def max_parallelism(self) -> Optional[int]:
        """
        Maximum parallel number nodes during rolling upgrade. The value of this field should be greater than `0`, and if it's set to a number less than or equal to `0`, the default setting will be used.
        """
        return pulumi.get(self, "max_parallelism")


@pulumi.output_type
class NodePoolRolloutPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolRolloutPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolRolloutPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolRolloutPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unavailable: Optional[int] = None):
        """
        :param int max_unavailable: Maximum number of unavailable nodes during rolling upgrade. The value of this field should be greater than `0`, and if it's set to a number less than or equal to `0`, the default setting will be used. Please use `max_parallelism` to instead it from provider version 1.185.0.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[int]:
        """
        Maximum number of unavailable nodes during rolling upgrade. The value of this field should be greater than `0`, and if it's set to a number less than or equal to `0`, the default setting will be used. Please use `max_parallelism` to instead it from provider version 1.185.0.
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class NodePoolScalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "eipBandwidth":
            suggest = "eip_bandwidth"
        elif key == "eipInternetChargeType":
            suggest = "eip_internet_charge_type"
        elif key == "isBondEip":
            suggest = "is_bond_eip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolScalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolScalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolScalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_size: int,
                 min_size: int,
                 eip_bandwidth: Optional[int] = None,
                 eip_internet_charge_type: Optional[str] = None,
                 is_bond_eip: Optional[bool] = None,
                 type: Optional[str] = None):
        """
        :param int max_size: Max number of instances in a auto scaling group, its valid value range [0~1000]. `max_size` has to be greater than `min_size`.
        :param int min_size: Min number of instances in a auto scaling group, its valid value range [0~1000].
        :param int eip_bandwidth: Peak EIP bandwidth. Its valid value range [1~500] in Mbps. Default to `5`.
        :param str eip_internet_charge_type: EIP billing type. `PayByBandwidth`: Charged at fixed bandwidth. `PayByTraffic`: Billed as used traffic. Default: `PayByBandwidth`. Conflict with `internet_charge_type`, EIP and public network IP can only choose one.
        :param bool is_bond_eip: Whether to bind EIP for an instance. Default: `false`.
        :param str type: Instance classification, not required. Vaild value: `cpu`, `gpu`, `gpushare` and `spot`. Default: `cpu`. The actual instance type is determined by `instance_types`.
        """
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if eip_internet_charge_type is not None:
            pulumi.set(__self__, "eip_internet_charge_type", eip_internet_charge_type)
        if is_bond_eip is not None:
            pulumi.set(__self__, "is_bond_eip", is_bond_eip)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> int:
        """
        Max number of instances in a auto scaling group, its valid value range [0~1000]. `max_size` has to be greater than `min_size`.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> int:
        """
        Min number of instances in a auto scaling group, its valid value range [0~1000].
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[int]:
        """
        Peak EIP bandwidth. Its valid value range [1~500] in Mbps. Default to `5`.
        """
        return pulumi.get(self, "eip_bandwidth")

    @property
    @pulumi.getter(name="eipInternetChargeType")
    def eip_internet_charge_type(self) -> Optional[str]:
        """
        EIP billing type. `PayByBandwidth`: Charged at fixed bandwidth. `PayByTraffic`: Billed as used traffic. Default: `PayByBandwidth`. Conflict with `internet_charge_type`, EIP and public network IP can only choose one.
        """
        return pulumi.get(self, "eip_internet_charge_type")

    @property
    @pulumi.getter(name="isBondEip")
    def is_bond_eip(self) -> Optional[bool]:
        """
        Whether to bind EIP for an instance. Default: `false`.
        """
        return pulumi.get(self, "is_bond_eip")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Instance classification, not required. Vaild value: `cpu`, `gpu`, `gpushare` and `spot`. Default: `cpu`. The actual instance type is determined by `instance_types`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NodePoolSpotPriceLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "priceLimit":
            suggest = "price_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolSpotPriceLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolSpotPriceLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolSpotPriceLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[str] = None,
                 price_limit: Optional[str] = None):
        """
        :param str instance_type: Spot instance type.
        :param str price_limit: The maximum hourly price of the spot instance. A maximum of three decimal places are allowed.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if price_limit is not None:
            pulumi.set(__self__, "price_limit", price_limit)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        Spot instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="priceLimit")
    def price_limit(self) -> Optional[str]:
        """
        The maximum hourly price of the spot instance. A maximum of three decimal places are allowed.
        """
        return pulumi.get(self, "price_limit")


@pulumi.output_type
class NodePoolTaint(dict):
    def __init__(__self__, *,
                 key: str,
                 effect: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The key of a taint.
        :param str effect: The scheduling policy.
        :param str value: The value of a taint.
        """
        pulumi.set(__self__, "key", key)
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of a taint.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def effect(self) -> Optional[str]:
        """
        The scheduling policy.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of a taint.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServerlessKubernetesAddon(dict):
    def __init__(__self__, *,
                 config: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 name: Optional[str] = None):
        """
        :param str config: The ACK add-on configurations.
        :param bool disabled: Disables the automatic installation of a component. Default is `false`.
               
               The following example is the definition of addons block, The type of this field is list:
        :param str name: Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def config(self) -> Optional[str]:
        """
        The ACK add-on configurations.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Disables the automatic installation of a component. Default is `false`.

        The following example is the definition of addons block, The type of this field is list:
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServerlessKubernetesRrsaMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ramOidcProviderArn":
            suggest = "ram_oidc_provider_arn"
        elif key == "ramOidcProviderName":
            suggest = "ram_oidc_provider_name"
        elif key == "rrsaOidcIssuerUrl":
            suggest = "rrsa_oidc_issuer_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessKubernetesRrsaMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessKubernetesRrsaMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessKubernetesRrsaMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 ram_oidc_provider_arn: Optional[str] = None,
                 ram_oidc_provider_name: Optional[str] = None,
                 rrsa_oidc_issuer_url: Optional[str] = None):
        """
        :param bool enabled: Whether the RRSA feature has been enabled.
        :param str ram_oidc_provider_arn: The arn of OIDC provider that was registered in RAM.
        :param str ram_oidc_provider_name: The name of OIDC Provider that was registered in RAM.
        :param str rrsa_oidc_issuer_url: The issuer URL of RRSA OIDC Token.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ram_oidc_provider_arn is not None:
            pulumi.set(__self__, "ram_oidc_provider_arn", ram_oidc_provider_arn)
        if ram_oidc_provider_name is not None:
            pulumi.set(__self__, "ram_oidc_provider_name", ram_oidc_provider_name)
        if rrsa_oidc_issuer_url is not None:
            pulumi.set(__self__, "rrsa_oidc_issuer_url", rrsa_oidc_issuer_url)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether the RRSA feature has been enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ramOidcProviderArn")
    def ram_oidc_provider_arn(self) -> Optional[str]:
        """
        The arn of OIDC provider that was registered in RAM.
        """
        return pulumi.get(self, "ram_oidc_provider_arn")

    @property
    @pulumi.getter(name="ramOidcProviderName")
    def ram_oidc_provider_name(self) -> Optional[str]:
        """
        The name of OIDC Provider that was registered in RAM.
        """
        return pulumi.get(self, "ram_oidc_provider_name")

    @property
    @pulumi.getter(name="rrsaOidcIssuerUrl")
    def rrsa_oidc_issuer_url(self) -> Optional[str]:
        """
        The issuer URL of RRSA OIDC Token.
        """
        return pulumi.get(self, "rrsa_oidc_issuer_url")


@pulumi.output_type
class SwarmNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SwarmNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SwarmNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SwarmNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eip: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip: Optional[str] = None,
                 status: Optional[str] = None):
        if eip is not None:
            pulumi.set(__self__, "eip", eip)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def eip(self) -> Optional[str]:
        return pulumi.get(self, "eip")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetClusterCredentialCertificateAuthorityResult(dict):
    def __init__(__self__, *,
                 client_cert: str,
                 client_key: str,
                 cluster_cert: str):
        """
        :param str client_cert: The base64 encoded client certificate data required to communicate with your cluster. Add this to the client-certificate-data section of the kube config file for your cluster.
        :param str client_key: The base64 encoded client key data required to communicate with your cluster. Add this to the client-key-data section of the kube config file for your cluster.
        :param str cluster_cert: The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kube config file for your cluster.
        """
        pulumi.set(__self__, "client_cert", client_cert)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "cluster_cert", cluster_cert)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> str:
        """
        The base64 encoded client certificate data required to communicate with your cluster. Add this to the client-certificate-data section of the kube config file for your cluster.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        The base64 encoded client key data required to communicate with your cluster. Add this to the client-key-data section of the kube config file for your cluster.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCert")
    def cluster_cert(self) -> str:
        """
        The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kube config file for your cluster.
        """
        return pulumi.get(self, "cluster_cert")


@pulumi.output_type
class GetEdgeKubernetesClustersClusterResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 connections: 'outputs.GetEdgeKubernetesClustersClusterConnectionsResult',
                 id: str,
                 name: str,
                 nat_gateway_id: str,
                 security_group_id: str,
                 vpc_id: str,
                 worker_nodes: Sequence['outputs.GetEdgeKubernetesClustersClusterWorkerNodeResult']):
        """
        :param str availability_zone: The ID of availability zone.
        :param 'GetEdgeKubernetesClustersClusterConnectionsArgs' connections: Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
        :param str id: ID of the node.
        :param str name: Node name.
        :param str nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param str security_group_id: The ID of security group where the current cluster worker node is located.
        :param str vpc_id: The ID of VPC where the current cluster is located.
        :param Sequence['GetEdgeKubernetesClustersClusterWorkerNodeArgs'] worker_nodes: List of cluster worker nodes. It contains several attributes to `Block Nodes`.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "worker_nodes", worker_nodes)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def connections(self) -> 'outputs.GetEdgeKubernetesClustersClusterConnectionsResult':
        """
        Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> str:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        The ID of security group where the current cluster worker node is located.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> Sequence['outputs.GetEdgeKubernetesClustersClusterWorkerNodeResult']:
        """
        List of cluster worker nodes. It contains several attributes to `Block Nodes`.
        """
        return pulumi.get(self, "worker_nodes")


@pulumi.output_type
class GetEdgeKubernetesClustersClusterConnectionsResult(dict):
    def __init__(__self__, *,
                 api_server_internet: str,
                 api_server_intranet: str):
        """
        :param str api_server_internet: API Server Internet endpoint.
        :param str api_server_intranet: API Server Intranet endpoint.
        """
        pulumi.set(__self__, "api_server_internet", api_server_internet)
        pulumi.set(__self__, "api_server_intranet", api_server_intranet)

    @property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> str:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> str:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")


@pulumi.output_type
class GetEdgeKubernetesClustersClusterWorkerNodeResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_ip: str):
        """
        :param str id: ID of the node.
        :param str name: Node name.
        :param str private_ip: The private IP address of node.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetKubernetesAddonsAddonResult(dict):
    def __init__(__self__, *,
                 current_config: str,
                 current_version: str,
                 name: str,
                 next_version: str,
                 required: bool):
        """
        :param str current_config: The current custom configuration of the addon. **Note:** Available in v1.166.0+
        :param str current_version: The current version of addon, if this field is an empty string, it means that the addon is not installed.
        :param str name: The name of addon.
        :param str next_version: The next version of this addon can be upgraded to.
        :param bool required: Whether the addon is a system addon.
        """
        pulumi.set(__self__, "current_config", current_config)
        pulumi.set(__self__, "current_version", current_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "next_version", next_version)
        pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter(name="currentConfig")
    def current_config(self) -> str:
        """
        The current custom configuration of the addon. **Note:** Available in v1.166.0+
        """
        return pulumi.get(self, "current_config")

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> str:
        """
        The current version of addon, if this field is an empty string, it means that the addon is not installed.
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of addon.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextVersion")
    def next_version(self) -> str:
        """
        The next version of this addon can be upgraded to.
        """
        return pulumi.get(self, "next_version")

    @property
    @pulumi.getter
    def required(self) -> bool:
        """
        Whether the addon is a system addon.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class GetKubernetesClustersClusterResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 cluster_network_type: str,
                 connections: 'outputs.GetKubernetesClustersClusterConnectionsResult',
                 id: str,
                 image_id: str,
                 key_name: str,
                 log_configs: Sequence['outputs.GetKubernetesClustersClusterLogConfigResult'],
                 master_auto_renew: bool,
                 master_auto_renew_period: int,
                 master_disk_category: str,
                 master_disk_size: int,
                 master_instance_charge_type: str,
                 master_instance_types: Sequence[str],
                 master_nodes: Sequence['outputs.GetKubernetesClustersClusterMasterNodeResult'],
                 master_period: int,
                 master_period_unit: str,
                 name: str,
                 nat_gateway_id: str,
                 node_cidr_mask: int,
                 pod_cidr: str,
                 security_group_id: str,
                 service_cidr: str,
                 slb_internet_enabled: bool,
                 vpc_id: str,
                 vswitch_ids: Sequence[str],
                 worker_auto_renew: bool,
                 worker_auto_renew_period: int,
                 worker_data_disk_category: str,
                 worker_data_disk_size: int,
                 worker_disk_category: str,
                 worker_disk_size: int,
                 worker_instance_charge_type: str,
                 worker_instance_types: Sequence[str],
                 worker_nodes: Sequence['outputs.GetKubernetesClustersClusterWorkerNodeResult'],
                 worker_numbers: Sequence[int],
                 worker_period: int,
                 worker_period_unit: str):
        """
        :param str availability_zone: The ID of availability zone.
        :param 'GetKubernetesClustersClusterConnectionsArgs' connections: Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
        :param str id: ID of the node.
        :param str image_id: The ID of node image.
        :param str key_name: The keypair of ssh login cluster node, you have to create it first.
        :param Sequence['GetKubernetesClustersClusterLogConfigArgs'] log_configs: A list of one element containing information about the associated log store. It contains the following attributes:
        :param str master_disk_category: The system disk category of master node.
        :param int master_disk_size: The system disk size of master node.
        :param Sequence[str] master_instance_types: The instance type of master node.
        :param Sequence['GetKubernetesClustersClusterMasterNodeArgs'] master_nodes: List of cluster master nodes. It contains several attributes to `Block Nodes`.
        :param str name: Node name.
        :param str nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param int node_cidr_mask: The network mask used on pods for each node.
        :param str security_group_id: The ID of security group where the current cluster worker node is located.
        :param bool slb_internet_enabled: Whether internet load balancer for API Server is created
        :param str vpc_id: The ID of VPC where the current cluster is located.
        :param Sequence[str] vswitch_ids: The ID of VSwitches where the current cluster is located.
        :param str worker_data_disk_category: The data disk size of worker node.
        :param int worker_data_disk_size: The data disk category of worker node.
        :param str worker_disk_category: The system disk category of worker node.
        :param int worker_disk_size: The system disk size of worker node.
        :param Sequence[str] worker_instance_types: The instance type of worker node.
        :param Sequence['GetKubernetesClustersClusterWorkerNodeArgs'] worker_nodes: List of cluster worker nodes. It contains several attributes to `Block Nodes`.
        :param Sequence[int] worker_numbers: The ECS instance node number in the current container cluster.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "cluster_network_type", cluster_network_type)
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "log_configs", log_configs)
        pulumi.set(__self__, "master_auto_renew", master_auto_renew)
        pulumi.set(__self__, "master_auto_renew_period", master_auto_renew_period)
        pulumi.set(__self__, "master_disk_category", master_disk_category)
        pulumi.set(__self__, "master_disk_size", master_disk_size)
        pulumi.set(__self__, "master_instance_charge_type", master_instance_charge_type)
        pulumi.set(__self__, "master_instance_types", master_instance_types)
        pulumi.set(__self__, "master_nodes", master_nodes)
        pulumi.set(__self__, "master_period", master_period)
        pulumi.set(__self__, "master_period_unit", master_period_unit)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        pulumi.set(__self__, "pod_cidr", pod_cidr)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "service_cidr", service_cidr)
        pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        pulumi.set(__self__, "worker_auto_renew", worker_auto_renew)
        pulumi.set(__self__, "worker_auto_renew_period", worker_auto_renew_period)
        pulumi.set(__self__, "worker_data_disk_category", worker_data_disk_category)
        pulumi.set(__self__, "worker_data_disk_size", worker_data_disk_size)
        pulumi.set(__self__, "worker_disk_category", worker_disk_category)
        pulumi.set(__self__, "worker_disk_size", worker_disk_size)
        pulumi.set(__self__, "worker_instance_charge_type", worker_instance_charge_type)
        pulumi.set(__self__, "worker_instance_types", worker_instance_types)
        pulumi.set(__self__, "worker_nodes", worker_nodes)
        pulumi.set(__self__, "worker_numbers", worker_numbers)
        pulumi.set(__self__, "worker_period", worker_period)
        pulumi.set(__self__, "worker_period_unit", worker_period_unit)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="clusterNetworkType")
    def cluster_network_type(self) -> str:
        return pulumi.get(self, "cluster_network_type")

    @property
    @pulumi.getter
    def connections(self) -> 'outputs.GetKubernetesClustersClusterConnectionsResult':
        """
        Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The ID of node image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        The keypair of ssh login cluster node, you have to create it first.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="logConfigs")
    def log_configs(self) -> Sequence['outputs.GetKubernetesClustersClusterLogConfigResult']:
        """
        A list of one element containing information about the associated log store. It contains the following attributes:
        """
        return pulumi.get(self, "log_configs")

    @property
    @pulumi.getter(name="masterAutoRenew")
    def master_auto_renew(self) -> bool:
        return pulumi.get(self, "master_auto_renew")

    @property
    @pulumi.getter(name="masterAutoRenewPeriod")
    def master_auto_renew_period(self) -> int:
        return pulumi.get(self, "master_auto_renew_period")

    @property
    @pulumi.getter(name="masterDiskCategory")
    def master_disk_category(self) -> str:
        """
        The system disk category of master node.
        """
        return pulumi.get(self, "master_disk_category")

    @property
    @pulumi.getter(name="masterDiskSize")
    def master_disk_size(self) -> int:
        """
        The system disk size of master node.
        """
        return pulumi.get(self, "master_disk_size")

    @property
    @pulumi.getter(name="masterInstanceChargeType")
    def master_instance_charge_type(self) -> str:
        return pulumi.get(self, "master_instance_charge_type")

    @property
    @pulumi.getter(name="masterInstanceTypes")
    def master_instance_types(self) -> Sequence[str]:
        """
        The instance type of master node.
        """
        return pulumi.get(self, "master_instance_types")

    @property
    @pulumi.getter(name="masterNodes")
    def master_nodes(self) -> Sequence['outputs.GetKubernetesClustersClusterMasterNodeResult']:
        """
        List of cluster master nodes. It contains several attributes to `Block Nodes`.
        """
        return pulumi.get(self, "master_nodes")

    @property
    @pulumi.getter(name="masterPeriod")
    def master_period(self) -> int:
        return pulumi.get(self, "master_period")

    @property
    @pulumi.getter(name="masterPeriodUnit")
    def master_period_unit(self) -> str:
        return pulumi.get(self, "master_period_unit")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> str:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> int:
        """
        The network mask used on pods for each node.
        """
        return pulumi.get(self, "node_cidr_mask")

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> str:
        return pulumi.get(self, "pod_cidr")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        The ID of security group where the current cluster worker node is located.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> str:
        return pulumi.get(self, "service_cidr")

    @property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> bool:
        """
        Whether internet load balancer for API Server is created
        """
        return pulumi.get(self, "slb_internet_enabled")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[str]:
        """
        The ID of VSwitches where the current cluster is located.
        """
        return pulumi.get(self, "vswitch_ids")

    @property
    @pulumi.getter(name="workerAutoRenew")
    def worker_auto_renew(self) -> bool:
        return pulumi.get(self, "worker_auto_renew")

    @property
    @pulumi.getter(name="workerAutoRenewPeriod")
    def worker_auto_renew_period(self) -> int:
        return pulumi.get(self, "worker_auto_renew_period")

    @property
    @pulumi.getter(name="workerDataDiskCategory")
    def worker_data_disk_category(self) -> str:
        """
        The data disk size of worker node.
        """
        return pulumi.get(self, "worker_data_disk_category")

    @property
    @pulumi.getter(name="workerDataDiskSize")
    def worker_data_disk_size(self) -> int:
        """
        The data disk category of worker node.
        """
        return pulumi.get(self, "worker_data_disk_size")

    @property
    @pulumi.getter(name="workerDiskCategory")
    def worker_disk_category(self) -> str:
        """
        The system disk category of worker node.
        """
        return pulumi.get(self, "worker_disk_category")

    @property
    @pulumi.getter(name="workerDiskSize")
    def worker_disk_size(self) -> int:
        """
        The system disk size of worker node.
        """
        return pulumi.get(self, "worker_disk_size")

    @property
    @pulumi.getter(name="workerInstanceChargeType")
    def worker_instance_charge_type(self) -> str:
        return pulumi.get(self, "worker_instance_charge_type")

    @property
    @pulumi.getter(name="workerInstanceTypes")
    def worker_instance_types(self) -> Sequence[str]:
        """
        The instance type of worker node.
        """
        return pulumi.get(self, "worker_instance_types")

    @property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> Sequence['outputs.GetKubernetesClustersClusterWorkerNodeResult']:
        """
        List of cluster worker nodes. It contains several attributes to `Block Nodes`.
        """
        return pulumi.get(self, "worker_nodes")

    @property
    @pulumi.getter(name="workerNumbers")
    def worker_numbers(self) -> Sequence[int]:
        """
        The ECS instance node number in the current container cluster.
        """
        return pulumi.get(self, "worker_numbers")

    @property
    @pulumi.getter(name="workerPeriod")
    def worker_period(self) -> int:
        return pulumi.get(self, "worker_period")

    @property
    @pulumi.getter(name="workerPeriodUnit")
    def worker_period_unit(self) -> str:
        return pulumi.get(self, "worker_period_unit")


@pulumi.output_type
class GetKubernetesClustersClusterConnectionsResult(dict):
    def __init__(__self__, *,
                 api_server_internet: str,
                 api_server_intranet: str,
                 master_public_ip: str,
                 service_domain: str):
        """
        :param str api_server_internet: API Server Internet endpoint.
        :param str api_server_intranet: API Server Intranet endpoint.
        :param str master_public_ip: Master node SSH IP address.
        :param str service_domain: Service Access Domain.
        """
        pulumi.set(__self__, "api_server_internet", api_server_internet)
        pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        pulumi.set(__self__, "master_public_ip", master_public_ip)
        pulumi.set(__self__, "service_domain", service_domain)

    @property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> str:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> str:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> str:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")

    @property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> str:
        """
        Service Access Domain.
        """
        return pulumi.get(self, "service_domain")


@pulumi.output_type
class GetKubernetesClustersClusterLogConfigResult(dict):
    def __init__(__self__, *,
                 project: str,
                 type: str):
        """
        :param str project: Log Service project name.
        :param str type: Type of collecting logs.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Log Service project name.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of collecting logs.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetKubernetesClustersClusterMasterNodeResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_ip: str):
        """
        :param str id: ID of the node.
        :param str name: Node name.
        :param str private_ip: The private IP address of node.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetKubernetesClustersClusterWorkerNodeResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_ip: str):
        """
        :param str id: ID of the node.
        :param str name: Node name.
        :param str private_ip: The private IP address of node.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetKubernetesPermissionPermissionResult(dict):
    def __init__(__self__, *,
                 resource_id: str,
                 resource_type: str,
                 role_name: str,
                 is_owner: Optional[bool] = None,
                 is_ram_role: Optional[bool] = None,
                 role_type: Optional[str] = None):
        """
        :param str resource_id: The permission settings to manage ACK clusters.
        :param str resource_type: The authorization type. Valid values `cluster`, `namespace` and `console`.
        :param str role_name: The name of the predefined role. If a custom role is assigned, the value is the name of the assigined custom role.
        :param bool is_owner: ndicates whether the permissions are granted to the cluster owner. Valid values `0`, `1`.
        :param bool is_ram_role: Indicates whether the permissions are granted to the RAM role. Valid values `0`,`1`.
        :param str role_type: The predefined role. Valid values `admin`,`ops`,`dev`,`restricted` and `custom`.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "role_name", role_name)
        if is_owner is not None:
            pulumi.set(__self__, "is_owner", is_owner)
        if is_ram_role is not None:
            pulumi.set(__self__, "is_ram_role", is_ram_role)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The permission settings to manage ACK clusters.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The authorization type. Valid values `cluster`, `namespace` and `console`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> str:
        """
        The name of the predefined role. If a custom role is assigned, the value is the name of the assigined custom role.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="isOwner")
    def is_owner(self) -> Optional[bool]:
        """
        ndicates whether the permissions are granted to the cluster owner. Valid values `0`, `1`.
        """
        return pulumi.get(self, "is_owner")

    @property
    @pulumi.getter(name="isRamRole")
    def is_ram_role(self) -> Optional[bool]:
        """
        Indicates whether the permissions are granted to the RAM role. Valid values `0`,`1`.
        """
        return pulumi.get(self, "is_ram_role")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[str]:
        """
        The predefined role. Valid values `admin`,`ops`,`dev`,`restricted` and `custom`.
        """
        return pulumi.get(self, "role_type")


@pulumi.output_type
class GetKubernetesVersionMetadataResult(dict):
    def __init__(__self__, *,
                 runtimes: Sequence['outputs.GetKubernetesVersionMetadataRuntimeResult'],
                 version: str):
        """
        :param Sequence['GetKubernetesVersionMetadataRuntimeArgs'] runtimes: The list of supported runtime.
        :param str version: The runtime version.
        """
        pulumi.set(__self__, "runtimes", runtimes)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def runtimes(self) -> Sequence['outputs.GetKubernetesVersionMetadataRuntimeResult']:
        """
        The list of supported runtime.
        """
        return pulumi.get(self, "runtimes")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The runtime version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetKubernetesVersionMetadataRuntimeResult(dict):
    def __init__(__self__, *,
                 name: str,
                 version: str):
        """
        :param str name: The runtime name.
        :param str version: The runtime version.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The runtime name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The runtime version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetManagedKubernetesClustersClusterResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 cluster_network_type: str,
                 connections: 'outputs.GetManagedKubernetesClustersClusterConnectionsResult',
                 id: str,
                 image_id: str,
                 key_name: str,
                 log_configs: Sequence['outputs.GetManagedKubernetesClustersClusterLogConfigResult'],
                 name: str,
                 nat_gateway_id: str,
                 pod_cidr: str,
                 security_group_id: str,
                 service_cidr: str,
                 slb_internet_enabled: bool,
                 vpc_id: str,
                 vswitch_ids: Sequence[str],
                 worker_auto_renew: bool,
                 worker_auto_renew_period: int,
                 worker_data_disk_category: str,
                 worker_data_disk_size: int,
                 worker_disk_category: str,
                 worker_disk_size: int,
                 worker_instance_charge_type: str,
                 worker_instance_types: Sequence[str],
                 worker_nodes: Sequence['outputs.GetManagedKubernetesClustersClusterWorkerNodeResult'],
                 worker_numbers: Sequence[int],
                 worker_period: int,
                 worker_period_unit: str):
        """
        :param str availability_zone: The ID of availability zone.
        :param 'GetManagedKubernetesClustersClusterConnectionsArgs' connections: Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
        :param str id: ID of the node.
        :param str key_name: The keypair of ssh login cluster node, you have to create it first.
        :param Sequence['GetManagedKubernetesClustersClusterLogConfigArgs'] log_configs: A list of one element containing information about the associated log store. It contains the following attributes:
        :param str name: Node name.
        :param str nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param str security_group_id: The ID of security group where the current cluster worker node is located.
        :param str vpc_id: The ID of VPC where the current cluster is located.
        :param Sequence[str] vswitch_ids: The ID of VSwitches where the current cluster is located.
        :param Sequence['GetManagedKubernetesClustersClusterWorkerNodeArgs'] worker_nodes: List of cluster worker nodes. It contains several attributes to `Block Nodes`.
        :param Sequence[int] worker_numbers: The ECS instance node number in the current container cluster.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "cluster_network_type", cluster_network_type)
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "log_configs", log_configs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "pod_cidr", pod_cidr)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "service_cidr", service_cidr)
        pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        pulumi.set(__self__, "worker_auto_renew", worker_auto_renew)
        pulumi.set(__self__, "worker_auto_renew_period", worker_auto_renew_period)
        pulumi.set(__self__, "worker_data_disk_category", worker_data_disk_category)
        pulumi.set(__self__, "worker_data_disk_size", worker_data_disk_size)
        pulumi.set(__self__, "worker_disk_category", worker_disk_category)
        pulumi.set(__self__, "worker_disk_size", worker_disk_size)
        pulumi.set(__self__, "worker_instance_charge_type", worker_instance_charge_type)
        pulumi.set(__self__, "worker_instance_types", worker_instance_types)
        pulumi.set(__self__, "worker_nodes", worker_nodes)
        pulumi.set(__self__, "worker_numbers", worker_numbers)
        pulumi.set(__self__, "worker_period", worker_period)
        pulumi.set(__self__, "worker_period_unit", worker_period_unit)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="clusterNetworkType")
    def cluster_network_type(self) -> str:
        return pulumi.get(self, "cluster_network_type")

    @property
    @pulumi.getter
    def connections(self) -> 'outputs.GetManagedKubernetesClustersClusterConnectionsResult':
        """
        Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        The keypair of ssh login cluster node, you have to create it first.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="logConfigs")
    def log_configs(self) -> Sequence['outputs.GetManagedKubernetesClustersClusterLogConfigResult']:
        """
        A list of one element containing information about the associated log store. It contains the following attributes:
        """
        return pulumi.get(self, "log_configs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> str:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> str:
        return pulumi.get(self, "pod_cidr")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        The ID of security group where the current cluster worker node is located.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> str:
        return pulumi.get(self, "service_cidr")

    @property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> bool:
        return pulumi.get(self, "slb_internet_enabled")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[str]:
        """
        The ID of VSwitches where the current cluster is located.
        """
        return pulumi.get(self, "vswitch_ids")

    @property
    @pulumi.getter(name="workerAutoRenew")
    def worker_auto_renew(self) -> bool:
        return pulumi.get(self, "worker_auto_renew")

    @property
    @pulumi.getter(name="workerAutoRenewPeriod")
    def worker_auto_renew_period(self) -> int:
        return pulumi.get(self, "worker_auto_renew_period")

    @property
    @pulumi.getter(name="workerDataDiskCategory")
    def worker_data_disk_category(self) -> str:
        return pulumi.get(self, "worker_data_disk_category")

    @property
    @pulumi.getter(name="workerDataDiskSize")
    def worker_data_disk_size(self) -> int:
        return pulumi.get(self, "worker_data_disk_size")

    @property
    @pulumi.getter(name="workerDiskCategory")
    def worker_disk_category(self) -> str:
        return pulumi.get(self, "worker_disk_category")

    @property
    @pulumi.getter(name="workerDiskSize")
    def worker_disk_size(self) -> int:
        return pulumi.get(self, "worker_disk_size")

    @property
    @pulumi.getter(name="workerInstanceChargeType")
    def worker_instance_charge_type(self) -> str:
        return pulumi.get(self, "worker_instance_charge_type")

    @property
    @pulumi.getter(name="workerInstanceTypes")
    def worker_instance_types(self) -> Sequence[str]:
        return pulumi.get(self, "worker_instance_types")

    @property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> Sequence['outputs.GetManagedKubernetesClustersClusterWorkerNodeResult']:
        """
        List of cluster worker nodes. It contains several attributes to `Block Nodes`.
        """
        return pulumi.get(self, "worker_nodes")

    @property
    @pulumi.getter(name="workerNumbers")
    def worker_numbers(self) -> Sequence[int]:
        """
        The ECS instance node number in the current container cluster.
        """
        return pulumi.get(self, "worker_numbers")

    @property
    @pulumi.getter(name="workerPeriod")
    def worker_period(self) -> int:
        return pulumi.get(self, "worker_period")

    @property
    @pulumi.getter(name="workerPeriodUnit")
    def worker_period_unit(self) -> str:
        return pulumi.get(self, "worker_period_unit")


@pulumi.output_type
class GetManagedKubernetesClustersClusterConnectionsResult(dict):
    def __init__(__self__, *,
                 api_server_internet: str,
                 api_server_intranet: str,
                 master_public_ip: str,
                 service_domain: str):
        """
        :param str api_server_internet: API Server Internet endpoint.
        :param str api_server_intranet: API Server Intranet endpoint.
        :param str master_public_ip: Master node SSH IP address.
        :param str service_domain: Service Access Domain.
        """
        pulumi.set(__self__, "api_server_internet", api_server_internet)
        pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        pulumi.set(__self__, "master_public_ip", master_public_ip)
        pulumi.set(__self__, "service_domain", service_domain)

    @property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> str:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> str:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> str:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")

    @property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> str:
        """
        Service Access Domain.
        """
        return pulumi.get(self, "service_domain")


@pulumi.output_type
class GetManagedKubernetesClustersClusterLogConfigResult(dict):
    def __init__(__self__, *,
                 project: str,
                 type: str):
        """
        :param str project: Log Service project name.
        :param str type: Type of collecting logs.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Log Service project name.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of collecting logs.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetManagedKubernetesClustersClusterWorkerNodeResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_ip: str):
        """
        :param str id: ID of the node.
        :param str name: Node name.
        :param str private_ip: The private IP address of node.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetRegistryEnterpriseInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 authorization_token: str,
                 id: str,
                 name: str,
                 namespace_quota: str,
                 namespace_usage: str,
                 public_endpoints: Sequence[str],
                 region: str,
                 repo_quota: str,
                 repo_usage: str,
                 specification: str,
                 temp_username: str,
                 vpc_endpoints: Sequence[str]):
        """
        :param str authorization_token: The password that was used to log on to the registry.
        :param str id: ID of Container Registry Enterprise Edition instance.
        :param str name: Name of Container Registry Enterprise Edition instance.
        :param str namespace_quota: The max number of namespaces that an instance can create.
        :param str namespace_usage: The number of namespaces already created.
        :param Sequence[str] public_endpoints: A list of domains for access on internet network.
        :param str region: Region of Container Registry Enterprise Edition instance.
        :param str repo_quota: The max number of repos that an instance can create.
        :param str repo_usage: The number of repos already created.
        :param str specification: Specification of Container Registry Enterprise Edition instance.
        :param str temp_username: The username that was used to log on to the registry.
        :param Sequence[str] vpc_endpoints: A list of domains for access on vpc network.
        """
        pulumi.set(__self__, "authorization_token", authorization_token)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace_quota", namespace_quota)
        pulumi.set(__self__, "namespace_usage", namespace_usage)
        pulumi.set(__self__, "public_endpoints", public_endpoints)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "repo_quota", repo_quota)
        pulumi.set(__self__, "repo_usage", repo_usage)
        pulumi.set(__self__, "specification", specification)
        pulumi.set(__self__, "temp_username", temp_username)
        pulumi.set(__self__, "vpc_endpoints", vpc_endpoints)

    @property
    @pulumi.getter(name="authorizationToken")
    def authorization_token(self) -> str:
        """
        The password that was used to log on to the registry.
        """
        return pulumi.get(self, "authorization_token")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceQuota")
    def namespace_quota(self) -> str:
        """
        The max number of namespaces that an instance can create.
        """
        return pulumi.get(self, "namespace_quota")

    @property
    @pulumi.getter(name="namespaceUsage")
    def namespace_usage(self) -> str:
        """
        The number of namespaces already created.
        """
        return pulumi.get(self, "namespace_usage")

    @property
    @pulumi.getter(name="publicEndpoints")
    def public_endpoints(self) -> Sequence[str]:
        """
        A list of domains for access on internet network.
        """
        return pulumi.get(self, "public_endpoints")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="repoQuota")
    def repo_quota(self) -> str:
        """
        The max number of repos that an instance can create.
        """
        return pulumi.get(self, "repo_quota")

    @property
    @pulumi.getter(name="repoUsage")
    def repo_usage(self) -> str:
        """
        The number of repos already created.
        """
        return pulumi.get(self, "repo_usage")

    @property
    @pulumi.getter
    def specification(self) -> str:
        """
        Specification of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "specification")

    @property
    @pulumi.getter(name="tempUsername")
    def temp_username(self) -> str:
        """
        The username that was used to log on to the registry.
        """
        return pulumi.get(self, "temp_username")

    @property
    @pulumi.getter(name="vpcEndpoints")
    def vpc_endpoints(self) -> Sequence[str]:
        """
        A list of domains for access on vpc network.
        """
        return pulumi.get(self, "vpc_endpoints")


@pulumi.output_type
class GetRegistryEnterpriseNamespacesNamespaceResult(dict):
    def __init__(__self__, *,
                 auto_create: bool,
                 default_visibility: str,
                 id: str,
                 instance_id: str,
                 name: str,
                 namespace_id: str,
                 namespace_name: str):
        """
        :param bool auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param str default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param str id: ID of Container Registry Enterprise Edition namespace. It formats as `<instance_id>:<namespace_name>`. Before 1.161.0, it is a namespace uuid.
        :param str instance_id: ID of Container Registry Enterprise Edition instance.
        :param str name: Name of Container Registry Enterprise Edition namespace.
        :param str namespace_id: Container Registry Enterprise Edition namespace id. It is a uuid.
        :param str namespace_name: Name of Container Registry Enterprise Edition namespace.
        """
        pulumi.set(__self__, "auto_create", auto_create)
        pulumi.set(__self__, "default_visibility", default_visibility)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "namespace_name", namespace_name)

    @property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> bool:
        """
        Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        """
        return pulumi.get(self, "auto_create")

    @property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> str:
        """
        `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        """
        return pulumi.get(self, "default_visibility")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of Container Registry Enterprise Edition namespace. It formats as `<instance_id>:<namespace_name>`. Before 1.161.0, it is a namespace uuid.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        ID of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of Container Registry Enterprise Edition namespace.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> str:
        """
        Container Registry Enterprise Edition namespace id. It is a uuid.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> str:
        """
        Name of Container Registry Enterprise Edition namespace.
        """
        return pulumi.get(self, "namespace_name")


@pulumi.output_type
class GetRegistryEnterpriseReposRepoResult(dict):
    def __init__(__self__, *,
                 id: str,
                 instance_id: str,
                 name: str,
                 namespace: str,
                 repo_type: str,
                 summary: str,
                 tags: Sequence['outputs.GetRegistryEnterpriseReposRepoTagResult']):
        """
        :param str id: ID of Container Registry Enterprise Edition repository.
        :param str instance_id: ID of Container Registry Enterprise Edition instance.
        :param str name: Name of Container Registry Enterprise Edition repository.
        :param str namespace: Name of Container Registry Enterprise Edition namespace where the repositories are located in.
        :param str repo_type: `PUBLIC` or `PRIVATE`, repository's visibility.
        :param str summary: The repository general information.
        :param Sequence['GetRegistryEnterpriseReposRepoTagArgs'] tags: A list of image tags belong to this repository. Each contains several attributes, see `Block Tag`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "summary", summary)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of Container Registry Enterprise Edition repository.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        ID of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of Container Registry Enterprise Edition repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Name of Container Registry Enterprise Edition namespace where the repositories are located in.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> str:
        """
        `PUBLIC` or `PRIVATE`, repository's visibility.
        """
        return pulumi.get(self, "repo_type")

    @property
    @pulumi.getter
    def summary(self) -> str:
        """
        The repository general information.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetRegistryEnterpriseReposRepoTagResult']:
        """
        A list of image tags belong to this repository. Each contains several attributes, see `Block Tag`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetRegistryEnterpriseReposRepoTagResult(dict):
    def __init__(__self__, *,
                 digest: str,
                 image_create: str,
                 image_id: str,
                 image_size: int,
                 image_update: str,
                 status: str,
                 tag: str):
        """
        :param str digest: Digest of this image.
        :param str image_create: Create time of this image, unix time in nanoseconds.
        :param str image_id: Id of this image.
        :param int image_size: Status of this image, in bytes.
        :param str image_update: Last update time of this image, unix time in nanoseconds.
        :param str status: Status of this image.
        :param str tag: Tag of this image.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "image_create", image_create)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_size", image_size)
        pulumi.set(__self__, "image_update", image_update)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def digest(self) -> str:
        """
        Digest of this image.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="imageCreate")
    def image_create(self) -> str:
        """
        Create time of this image, unix time in nanoseconds.
        """
        return pulumi.get(self, "image_create")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        Id of this image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> int:
        """
        Status of this image, in bytes.
        """
        return pulumi.get(self, "image_size")

    @property
    @pulumi.getter(name="imageUpdate")
    def image_update(self) -> str:
        """
        Last update time of this image, unix time in nanoseconds.
        """
        return pulumi.get(self, "image_update")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of this image.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Tag of this image.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetRegistryEnterpriseSyncRulesRuleResult(dict):
    def __init__(__self__, *,
                 id: str,
                 instance_id: str,
                 name: str,
                 namespace_name: str,
                 region_id: str,
                 repo_name: str,
                 sync_direction: str,
                 sync_scope: str,
                 sync_trigger: str,
                 tag_filter: str,
                 target_instance_id: str,
                 target_namespace_name: str,
                 target_region_id: str,
                 target_repo_name: str):
        """
        :param str id: ID of Container Registry Enterprise Edition sync rule.
        :param str instance_id: ID of Container Registry Enterprise Edition local instance.
        :param str name: Name of Container Registry Enterprise Edition sync rule.
        :param str namespace_name: Name of Container Registry Enterprise Edition local namespace.
        :param str region_id: Region of Container Registry Enterprise Edition local instance.
        :param str repo_name: Name of Container Registry Enterprise Edition local repo.
        :param str sync_direction: `FROM` or `TO`, the direction of synchronization. `FROM` indicates that the local instance is the source instance. `TO` indicates that the local instance is the target instance to be synchronized.
        :param str sync_scope: `REPO` or `NAMESPACE`,the scope that the synchronization rule applies.
        :param str sync_trigger: `PASSIVE` or `INITIATIVE`, the policy configured to trigger the synchronization rule.
        :param str tag_filter: The regular expression used to filter image tags for synchronization in the source repository.
        :param str target_instance_id: ID of Container Registry Enterprise Edition target instance.
        :param str target_namespace_name: Name of Container Registry Enterprise Edition target namespace.
        :param str target_region_id: Region of Container Registry Enterprise Edition target instance.
        :param str target_repo_name: Name of Container Registry Enterprise Edition target repo.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "sync_direction", sync_direction)
        pulumi.set(__self__, "sync_scope", sync_scope)
        pulumi.set(__self__, "sync_trigger", sync_trigger)
        pulumi.set(__self__, "tag_filter", tag_filter)
        pulumi.set(__self__, "target_instance_id", target_instance_id)
        pulumi.set(__self__, "target_namespace_name", target_namespace_name)
        pulumi.set(__self__, "target_region_id", target_region_id)
        pulumi.set(__self__, "target_repo_name", target_repo_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of Container Registry Enterprise Edition sync rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        ID of Container Registry Enterprise Edition local instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of Container Registry Enterprise Edition sync rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> str:
        """
        Name of Container Registry Enterprise Edition local namespace.
        """
        return pulumi.get(self, "namespace_name")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        Region of Container Registry Enterprise Edition local instance.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        Name of Container Registry Enterprise Edition local repo.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter(name="syncDirection")
    def sync_direction(self) -> str:
        """
        `FROM` or `TO`, the direction of synchronization. `FROM` indicates that the local instance is the source instance. `TO` indicates that the local instance is the target instance to be synchronized.
        """
        return pulumi.get(self, "sync_direction")

    @property
    @pulumi.getter(name="syncScope")
    def sync_scope(self) -> str:
        """
        `REPO` or `NAMESPACE`,the scope that the synchronization rule applies.
        """
        return pulumi.get(self, "sync_scope")

    @property
    @pulumi.getter(name="syncTrigger")
    def sync_trigger(self) -> str:
        """
        `PASSIVE` or `INITIATIVE`, the policy configured to trigger the synchronization rule.
        """
        return pulumi.get(self, "sync_trigger")

    @property
    @pulumi.getter(name="tagFilter")
    def tag_filter(self) -> str:
        """
        The regular expression used to filter image tags for synchronization in the source repository.
        """
        return pulumi.get(self, "tag_filter")

    @property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> str:
        """
        ID of Container Registry Enterprise Edition target instance.
        """
        return pulumi.get(self, "target_instance_id")

    @property
    @pulumi.getter(name="targetNamespaceName")
    def target_namespace_name(self) -> str:
        """
        Name of Container Registry Enterprise Edition target namespace.
        """
        return pulumi.get(self, "target_namespace_name")

    @property
    @pulumi.getter(name="targetRegionId")
    def target_region_id(self) -> str:
        """
        Region of Container Registry Enterprise Edition target instance.
        """
        return pulumi.get(self, "target_region_id")

    @property
    @pulumi.getter(name="targetRepoName")
    def target_repo_name(self) -> str:
        """
        Name of Container Registry Enterprise Edition target repo.
        """
        return pulumi.get(self, "target_repo_name")


@pulumi.output_type
class GetServerlessKubernetesClustersClusterResult(dict):
    def __init__(__self__, *,
                 connections: 'outputs.GetServerlessKubernetesClustersClusterConnectionsResult',
                 deletion_protection: bool,
                 endpoint_public_access_enabled: bool,
                 id: str,
                 name: str,
                 nat_gateway_id: str,
                 security_group_id: str,
                 tags: Mapping[str, Any],
                 vpc_id: str,
                 vswitch_id: str):
        """
        :param 'GetServerlessKubernetesClustersClusterConnectionsArgs' connections: Map of serverless cluster connection information. It contains several attributes to `Block Connections`.
        :param bool deletion_protection: Whether the cluster support delete protection.
        :param str id: The ID of the container cluster.
        :param str name: The name of the container cluster.
        :param str nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param str security_group_id: The ID of security group where the current cluster  is located.
        :param str vpc_id: The ID of VPC where the current cluster is located.
        :param str vswitch_id: The ID of VSwitch where the current cluster is located.
        """
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "endpoint_public_access_enabled", endpoint_public_access_enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def connections(self) -> 'outputs.GetServerlessKubernetesClustersClusterConnectionsResult':
        """
        Map of serverless cluster connection information. It contains several attributes to `Block Connections`.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        Whether the cluster support delete protection.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="endpointPublicAccessEnabled")
    def endpoint_public_access_enabled(self) -> bool:
        return pulumi.get(self, "endpoint_public_access_enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the container cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the container cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> str:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        The ID of security group where the current cluster  is located.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of VSwitch where the current cluster is located.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetServerlessKubernetesClustersClusterConnectionsResult(dict):
    def __init__(__self__, *,
                 api_server_internet: str,
                 api_server_intranet: str,
                 master_public_ip: str):
        """
        :param str api_server_internet: API Server Internet endpoint.
        :param str api_server_intranet: API Server Intranet endpoint.
        :param str master_public_ip: Master node SSH IP address.
        """
        pulumi.set(__self__, "api_server_internet", api_server_internet)
        pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        pulumi.set(__self__, "master_public_ip", master_public_ip)

    @property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> str:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> str:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> str:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")


