# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RegistryEnterpriseNamespaceArgs', 'RegistryEnterpriseNamespace']

@pulumi.input_type
class RegistryEnterpriseNamespaceArgs:
    def __init__(__self__, *,
                 auto_create: pulumi.Input[bool],
                 default_visibility: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RegistryEnterpriseNamespace resource.
        :param pulumi.Input[bool] auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param pulumi.Input[str] default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param pulumi.Input[str] instance_id: ID of Container Registry Enterprise Edition instance.
        :param pulumi.Input[str] name: Name of Container Registry Enterprise Edition namespace. It can contain 2 to 30 characters.
        """
        pulumi.set(__self__, "auto_create", auto_create)
        pulumi.set(__self__, "default_visibility", default_visibility)
        pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> pulumi.Input[bool]:
        """
        Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        """
        return pulumi.get(self, "auto_create")

    @auto_create.setter
    def auto_create(self, value: pulumi.Input[bool]):
        pulumi.set(self, "auto_create", value)

    @property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> pulumi.Input[str]:
        """
        `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        """
        return pulumi.get(self, "default_visibility")

    @default_visibility.setter
    def default_visibility(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_visibility", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        ID of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Container Registry Enterprise Edition namespace. It can contain 2 to 30 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RegistryEnterpriseNamespaceState:
    def __init__(__self__, *,
                 auto_create: Optional[pulumi.Input[bool]] = None,
                 default_visibility: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RegistryEnterpriseNamespace resources.
        :param pulumi.Input[bool] auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param pulumi.Input[str] default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param pulumi.Input[str] instance_id: ID of Container Registry Enterprise Edition instance.
        :param pulumi.Input[str] name: Name of Container Registry Enterprise Edition namespace. It can contain 2 to 30 characters.
        """
        if auto_create is not None:
            pulumi.set(__self__, "auto_create", auto_create)
        if default_visibility is not None:
            pulumi.set(__self__, "default_visibility", default_visibility)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        """
        return pulumi.get(self, "auto_create")

    @auto_create.setter
    def auto_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_create", value)

    @property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> Optional[pulumi.Input[str]]:
        """
        `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        """
        return pulumi.get(self, "default_visibility")

    @default_visibility.setter
    def default_visibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_visibility", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Container Registry Enterprise Edition namespace. It can contain 2 to 30 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class RegistryEnterpriseNamespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create: Optional[pulumi.Input[bool]] = None,
                 default_visibility: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource will help you to manager Container Registry Enterprise Edition namespaces.

        For information about Container Registry Enterprise Edition namespaces and how to use it, see [Create a Namespace](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createnamespace)

        > **NOTE:** Available since v1.86.0.

        > **NOTE:** You need to set your registry password in Container Registry Enterprise Edition console before use this resource.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example-name"
        example_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("exampleRegistryEnterpriseInstance",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=name)
        example_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("exampleRegistryEnterpriseNamespace",
            instance_id=example_registry_enterprise_instance.id,
            auto_create=False,
            default_visibility="PUBLIC")
        ```

        ## Import

        Container Registry Enterprise Edition namespace can be imported using the `{instance_id}:{namespace}`, e.g.

        ```sh
         $ pulumi import alicloud:cs/registryEnterpriseNamespace:RegistryEnterpriseNamespace default cri-xxx:my-namespace
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param pulumi.Input[str] default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param pulumi.Input[str] instance_id: ID of Container Registry Enterprise Edition instance.
        :param pulumi.Input[str] name: Name of Container Registry Enterprise Edition namespace. It can contain 2 to 30 characters.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryEnterpriseNamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource will help you to manager Container Registry Enterprise Edition namespaces.

        For information about Container Registry Enterprise Edition namespaces and how to use it, see [Create a Namespace](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createnamespace)

        > **NOTE:** Available since v1.86.0.

        > **NOTE:** You need to set your registry password in Container Registry Enterprise Edition console before use this resource.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example-name"
        example_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("exampleRegistryEnterpriseInstance",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=name)
        example_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("exampleRegistryEnterpriseNamespace",
            instance_id=example_registry_enterprise_instance.id,
            auto_create=False,
            default_visibility="PUBLIC")
        ```

        ## Import

        Container Registry Enterprise Edition namespace can be imported using the `{instance_id}:{namespace}`, e.g.

        ```sh
         $ pulumi import alicloud:cs/registryEnterpriseNamespace:RegistryEnterpriseNamespace default cri-xxx:my-namespace
        ```

        :param str resource_name: The name of the resource.
        :param RegistryEnterpriseNamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryEnterpriseNamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create: Optional[pulumi.Input[bool]] = None,
                 default_visibility: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryEnterpriseNamespaceArgs.__new__(RegistryEnterpriseNamespaceArgs)

            if auto_create is None and not opts.urn:
                raise TypeError("Missing required property 'auto_create'")
            __props__.__dict__["auto_create"] = auto_create
            if default_visibility is None and not opts.urn:
                raise TypeError("Missing required property 'default_visibility'")
            __props__.__dict__["default_visibility"] = default_visibility
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
        super(RegistryEnterpriseNamespace, __self__).__init__(
            'alicloud:cs/registryEnterpriseNamespace:RegistryEnterpriseNamespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_create: Optional[pulumi.Input[bool]] = None,
            default_visibility: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'RegistryEnterpriseNamespace':
        """
        Get an existing RegistryEnterpriseNamespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param pulumi.Input[str] default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param pulumi.Input[str] instance_id: ID of Container Registry Enterprise Edition instance.
        :param pulumi.Input[str] name: Name of Container Registry Enterprise Edition namespace. It can contain 2 to 30 characters.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryEnterpriseNamespaceState.__new__(_RegistryEnterpriseNamespaceState)

        __props__.__dict__["auto_create"] = auto_create
        __props__.__dict__["default_visibility"] = default_visibility
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        return RegistryEnterpriseNamespace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> pulumi.Output[bool]:
        """
        Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        """
        return pulumi.get(self, "auto_create")

    @property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> pulumi.Output[str]:
        """
        `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        """
        return pulumi.get(self, "default_visibility")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        ID of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of Container Registry Enterprise Edition namespace. It can contain 2 to 30 characters.
        """
        return pulumi.get(self, "name")

