# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackupPlansResult',
    'AwaitableGetBackupPlansResult',
    'get_backup_plans',
    'get_backup_plans_output',
]

@pulumi.output_type
class GetBackupPlansResult:
    """
    A collection of values returned by getBackupPlans.
    """
    def __init__(__self__, backup_plan_name=None, enable_details=None, id=None, ids=None, name_regex=None, names=None, output_file=None, page_number=None, page_size=None, plans=None, status=None):
        if backup_plan_name and not isinstance(backup_plan_name, str):
            raise TypeError("Expected argument 'backup_plan_name' to be a str")
        pulumi.set(__self__, "backup_plan_name", backup_plan_name)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if plans and not isinstance(plans, list):
            raise TypeError("Expected argument 'plans' to be a list")
        pulumi.set(__self__, "plans", plans)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="backupPlanName")
    def backup_plan_name(self) -> Optional[str]:
        return pulumi.get(self, "backup_plan_name")

    @property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[bool]:
        return pulumi.get(self, "enable_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[int]:
        return pulumi.get(self, "page_number")

    @property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[int]:
        return pulumi.get(self, "page_size")

    @property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetBackupPlansPlanResult']:
        return pulumi.get(self, "plans")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetBackupPlansResult(GetBackupPlansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupPlansResult(
            backup_plan_name=self.backup_plan_name,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            plans=self.plans,
            status=self.status)


def get_backup_plans(backup_plan_name: Optional[str] = None,
                     enable_details: Optional[bool] = None,
                     ids: Optional[Sequence[str]] = None,
                     name_regex: Optional[str] = None,
                     output_file: Optional[str] = None,
                     page_number: Optional[int] = None,
                     page_size: Optional[int] = None,
                     status: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupPlansResult:
    """
    This data source provides the Dbs Backup Plans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.185.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.dbs.get_backup_plans()
    pulumi.export("dbsBackupPlanId1", ids.plans[0].id)
    name_regex = alicloud.dbs.get_backup_plans(name_regex="^my-BackupPlan")
    pulumi.export("dbsBackupPlanId2", name_regex.plans[0].id)
    ```


    :param str backup_plan_name: The name of the resource.
    :param bool enable_details: Default to `true`. Set it to `false` can hide the `payment_type` to output.
    :param Sequence[str] ids: A list of Backup Plan IDs.
    :param str name_regex: A regex string to filter results by Backup Plan name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the resource.
    """
    __args__ = dict()
    __args__['backupPlanName'] = backup_plan_name
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:dbs/getBackupPlans:getBackupPlans', __args__, opts=opts, typ=GetBackupPlansResult).value

    return AwaitableGetBackupPlansResult(
        backup_plan_name=pulumi.get(__ret__, 'backup_plan_name'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        plans=pulumi.get(__ret__, 'plans'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_backup_plans)
def get_backup_plans_output(backup_plan_name: Optional[pulumi.Input[Optional[str]]] = None,
                            enable_details: Optional[pulumi.Input[Optional[bool]]] = None,
                            ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                            output_file: Optional[pulumi.Input[Optional[str]]] = None,
                            page_number: Optional[pulumi.Input[Optional[int]]] = None,
                            page_size: Optional[pulumi.Input[Optional[int]]] = None,
                            status: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBackupPlansResult]:
    """
    This data source provides the Dbs Backup Plans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.185.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.dbs.get_backup_plans()
    pulumi.export("dbsBackupPlanId1", ids.plans[0].id)
    name_regex = alicloud.dbs.get_backup_plans(name_regex="^my-BackupPlan")
    pulumi.export("dbsBackupPlanId2", name_regex.plans[0].id)
    ```


    :param str backup_plan_name: The name of the resource.
    :param bool enable_details: Default to `true`. Set it to `false` can hide the `payment_type` to output.
    :param Sequence[str] ids: A list of Backup Plan IDs.
    :param str name_regex: A regex string to filter results by Backup Plan name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the resource.
    """
    ...
