# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpaDomainsResult',
    'AwaitableGetIpaDomainsResult',
    'get_ipa_domains',
    'get_ipa_domains_output',
]

@pulumi.output_type
class GetIpaDomainsResult:
    """
    A collection of values returned by getIpaDomains.
    """
    def __init__(__self__, domain_name=None, domains=None, enable_details=None, id=None, ids=None, names=None, output_file=None, status=None):
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def domains(self) -> Sequence['outputs.GetIpaDomainsDomainResult']:
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[bool]:
        return pulumi.get(self, "enable_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetIpaDomainsResult(GetIpaDomainsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpaDomainsResult(
            domain_name=self.domain_name,
            domains=self.domains,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            names=self.names,
            output_file=self.output_file,
            status=self.status)


def get_ipa_domains(domain_name: Optional[str] = None,
                    enable_details: Optional[bool] = None,
                    ids: Optional[Sequence[str]] = None,
                    output_file: Optional[str] = None,
                    status: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpaDomainsResult:
    """
    This data source provides the Dcdn Ipa Domains of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.158.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.dcdn.get_ipa_domains(domain_name="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("dcdnIpaDomainId1", ids.domains[0].id)
    status = alicloud.dcdn.get_ipa_domains(status="online")
    pulumi.export("dcdnIpaDomainId2", status.domains[0].id)
    ```


    :param str domain_name: The accelerated domain names.
    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Ipa Domain IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the accelerated domain name.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:dcdn/getIpaDomains:getIpaDomains', __args__, opts=opts, typ=GetIpaDomainsResult).value

    return AwaitableGetIpaDomainsResult(
        domain_name=pulumi.get(__ret__, 'domain_name'),
        domains=pulumi.get(__ret__, 'domains'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_ipa_domains)
def get_ipa_domains_output(domain_name: Optional[pulumi.Input[Optional[str]]] = None,
                           enable_details: Optional[pulumi.Input[Optional[bool]]] = None,
                           ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           output_file: Optional[pulumi.Input[Optional[str]]] = None,
                           status: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpaDomainsResult]:
    """
    This data source provides the Dcdn Ipa Domains of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.158.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.dcdn.get_ipa_domains(domain_name="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("dcdnIpaDomainId1", ids.domains[0].id)
    status = alicloud.dcdn.get_ipa_domains(status="online")
    pulumi.export("dcdnIpaDomainId2", status.domains[0].id)
    ```


    :param str domain_name: The accelerated domain names.
    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Ipa Domain IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the accelerated domain name.
    """
    ...
