# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WafRuleArgs', 'WafRule']

@pulumi.input_type
class WafRuleArgs:
    def __init__(__self__, *,
                 policy_id: pulumi.Input[str],
                 rule_name: pulumi.Input[str],
                 action: Optional[pulumi.Input[str]] = None,
                 cc_status: Optional[pulumi.Input[str]] = None,
                 cn_region_list: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['WafRuleConditionArgs']]]] = None,
                 effect: Optional[pulumi.Input[str]] = None,
                 other_region_list: Optional[pulumi.Input[str]] = None,
                 rate_limit: Optional[pulumi.Input['WafRuleRateLimitArgs']] = None,
                 regular_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 regular_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scenes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 waf_group_ids: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WafRule resource.
        :param pulumi.Input[str] policy_id: The protection policy ID.
        :param pulumi.Input[str] rule_name: The name of the protection rule. The name can be up to 64 characters in length and can contain letters, digits, and underscores (_). **NOTE:** This parameter cannot be modified when policy is of type `region_block`.
        :param pulumi.Input[str] action: Specifies the action of the rule. Valid values: `block`, `monitor`, `js`.
        :param pulumi.Input[str] cc_status: Specifies whether to enable rate limiting. Valid values: `on` and `off`. **NOTE:** This parameter is required when policy is of type `custom_acl`.
        :param pulumi.Input[str] cn_region_list: The blocked regions in the Chinese mainland, separated by commas (,).
        :param pulumi.Input[Sequence[pulumi.Input['WafRuleConditionArgs']]] conditions: Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
        :param pulumi.Input[str] effect: The effective scope of the rate limiting blacklist. If you set ccStatus to on, you must configure this parameter. Valid values: `rule` (takes effect for the current rule) and `service` (takes effect globally).
        :param pulumi.Input[str] other_region_list: Blocked regions outside the Chinese mainland, separated by commas (,).
        :param pulumi.Input['WafRuleRateLimitArgs'] rate_limit: The rules of rate limiting. If you set `cc_status` to on, you must configure this parameter. See `rate_limit` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regular_rules: The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regular_types: Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_addrs: Filter by IP address.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scenes: The types of the protection policies.
        :param pulumi.Input[str] status: The status of the waf rule. Valid values: `on` and `off`. Default value: on.
        :param pulumi.Input[str] waf_group_ids: The id of the waf rule group. The default value is "1012". Multiple rules are separated by commas.
        """
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "rule_name", rule_name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cc_status is not None:
            pulumi.set(__self__, "cc_status", cc_status)
        if cn_region_list is not None:
            pulumi.set(__self__, "cn_region_list", cn_region_list)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if other_region_list is not None:
            pulumi.set(__self__, "other_region_list", other_region_list)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if regular_rules is not None:
            pulumi.set(__self__, "regular_rules", regular_rules)
        if regular_types is not None:
            pulumi.set(__self__, "regular_types", regular_types)
        if remote_addrs is not None:
            pulumi.set(__self__, "remote_addrs", remote_addrs)
        if scenes is not None:
            pulumi.set(__self__, "scenes", scenes)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if waf_group_ids is not None:
            pulumi.set(__self__, "waf_group_ids", waf_group_ids)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[str]:
        """
        The protection policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[str]:
        """
        The name of the protection rule. The name can be up to 64 characters in length and can contain letters, digits, and underscores (_). **NOTE:** This parameter cannot be modified when policy is of type `region_block`.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the action of the rule. Valid values: `block`, `monitor`, `js`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="ccStatus")
    def cc_status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to enable rate limiting. Valid values: `on` and `off`. **NOTE:** This parameter is required when policy is of type `custom_acl`.
        """
        return pulumi.get(self, "cc_status")

    @cc_status.setter
    def cc_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cc_status", value)

    @property
    @pulumi.getter(name="cnRegionList")
    def cn_region_list(self) -> Optional[pulumi.Input[str]]:
        """
        The blocked regions in the Chinese mainland, separated by commas (,).
        """
        return pulumi.get(self, "cn_region_list")

    @cn_region_list.setter
    def cn_region_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cn_region_list", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafRuleConditionArgs']]]]:
        """
        Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input[str]]:
        """
        The effective scope of the rate limiting blacklist. If you set ccStatus to on, you must configure this parameter. Valid values: `rule` (takes effect for the current rule) and `service` (takes effect globally).
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter(name="otherRegionList")
    def other_region_list(self) -> Optional[pulumi.Input[str]]:
        """
        Blocked regions outside the Chinese mainland, separated by commas (,).
        """
        return pulumi.get(self, "other_region_list")

    @other_region_list.setter
    def other_region_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "other_region_list", value)

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input['WafRuleRateLimitArgs']]:
        """
        The rules of rate limiting. If you set `cc_status` to on, you must configure this parameter. See `rate_limit` below.
        """
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input['WafRuleRateLimitArgs']]):
        pulumi.set(self, "rate_limit", value)

    @property
    @pulumi.getter(name="regularRules")
    def regular_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
        """
        return pulumi.get(self, "regular_rules")

    @regular_rules.setter
    def regular_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regular_rules", value)

    @property
    @pulumi.getter(name="regularTypes")
    def regular_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
        """
        return pulumi.get(self, "regular_types")

    @regular_types.setter
    def regular_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regular_types", value)

    @property
    @pulumi.getter(name="remoteAddrs")
    def remote_addrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Filter by IP address.
        """
        return pulumi.get(self, "remote_addrs")

    @remote_addrs.setter
    def remote_addrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_addrs", value)

    @property
    @pulumi.getter
    def scenes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The types of the protection policies.
        """
        return pulumi.get(self, "scenes")

    @scenes.setter
    def scenes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scenes", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the waf rule. Valid values: `on` and `off`. Default value: on.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="wafGroupIds")
    def waf_group_ids(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the waf rule group. The default value is "1012". Multiple rules are separated by commas.
        """
        return pulumi.get(self, "waf_group_ids")

    @waf_group_ids.setter
    def waf_group_ids(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "waf_group_ids", value)


@pulumi.input_type
class _WafRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 cc_status: Optional[pulumi.Input[str]] = None,
                 cn_region_list: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['WafRuleConditionArgs']]]] = None,
                 defense_scene: Optional[pulumi.Input[str]] = None,
                 effect: Optional[pulumi.Input[str]] = None,
                 gmt_modified: Optional[pulumi.Input[str]] = None,
                 other_region_list: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 rate_limit: Optional[pulumi.Input['WafRuleRateLimitArgs']] = None,
                 regular_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 regular_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 scenes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 waf_group_ids: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WafRule resources.
        :param pulumi.Input[str] action: Specifies the action of the rule. Valid values: `block`, `monitor`, `js`.
        :param pulumi.Input[str] cc_status: Specifies whether to enable rate limiting. Valid values: `on` and `off`. **NOTE:** This parameter is required when policy is of type `custom_acl`.
        :param pulumi.Input[str] cn_region_list: The blocked regions in the Chinese mainland, separated by commas (,).
        :param pulumi.Input[Sequence[pulumi.Input['WafRuleConditionArgs']]] conditions: Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
        :param pulumi.Input[str] defense_scene: The type of protection policy. The following scenarios are supported:-waf_group:Web basic protection-custom_acl: Custom protection policy-whitelist: whitelist
        :param pulumi.Input[str] effect: The effective scope of the rate limiting blacklist. If you set ccStatus to on, you must configure this parameter. Valid values: `rule` (takes effect for the current rule) and `service` (takes effect globally).
        :param pulumi.Input[str] gmt_modified: Revised the time. The date format is based on ISO8601 notation and uses UTC +0 time in the format of yyyy-MM-ddTHH:mm:ssZ.
        :param pulumi.Input[str] other_region_list: Blocked regions outside the Chinese mainland, separated by commas (,).
        :param pulumi.Input[str] policy_id: The protection policy ID.
        :param pulumi.Input['WafRuleRateLimitArgs'] rate_limit: The rules of rate limiting. If you set `cc_status` to on, you must configure this parameter. See `rate_limit` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regular_rules: The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regular_types: Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_addrs: Filter by IP address.
        :param pulumi.Input[str] rule_name: The name of the protection rule. The name can be up to 64 characters in length and can contain letters, digits, and underscores (_). **NOTE:** This parameter cannot be modified when policy is of type `region_block`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scenes: The types of the protection policies.
        :param pulumi.Input[str] status: The status of the waf rule. Valid values: `on` and `off`. Default value: on.
        :param pulumi.Input[str] waf_group_ids: The id of the waf rule group. The default value is "1012". Multiple rules are separated by commas.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cc_status is not None:
            pulumi.set(__self__, "cc_status", cc_status)
        if cn_region_list is not None:
            pulumi.set(__self__, "cn_region_list", cn_region_list)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if defense_scene is not None:
            pulumi.set(__self__, "defense_scene", defense_scene)
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if gmt_modified is not None:
            pulumi.set(__self__, "gmt_modified", gmt_modified)
        if other_region_list is not None:
            pulumi.set(__self__, "other_region_list", other_region_list)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if regular_rules is not None:
            pulumi.set(__self__, "regular_rules", regular_rules)
        if regular_types is not None:
            pulumi.set(__self__, "regular_types", regular_types)
        if remote_addrs is not None:
            pulumi.set(__self__, "remote_addrs", remote_addrs)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if scenes is not None:
            pulumi.set(__self__, "scenes", scenes)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if waf_group_ids is not None:
            pulumi.set(__self__, "waf_group_ids", waf_group_ids)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the action of the rule. Valid values: `block`, `monitor`, `js`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="ccStatus")
    def cc_status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to enable rate limiting. Valid values: `on` and `off`. **NOTE:** This parameter is required when policy is of type `custom_acl`.
        """
        return pulumi.get(self, "cc_status")

    @cc_status.setter
    def cc_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cc_status", value)

    @property
    @pulumi.getter(name="cnRegionList")
    def cn_region_list(self) -> Optional[pulumi.Input[str]]:
        """
        The blocked regions in the Chinese mainland, separated by commas (,).
        """
        return pulumi.get(self, "cn_region_list")

    @cn_region_list.setter
    def cn_region_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cn_region_list", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafRuleConditionArgs']]]]:
        """
        Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="defenseScene")
    def defense_scene(self) -> Optional[pulumi.Input[str]]:
        """
        The type of protection policy. The following scenarios are supported:-waf_group:Web basic protection-custom_acl: Custom protection policy-whitelist: whitelist
        """
        return pulumi.get(self, "defense_scene")

    @defense_scene.setter
    def defense_scene(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "defense_scene", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input[str]]:
        """
        The effective scope of the rate limiting blacklist. If you set ccStatus to on, you must configure this parameter. Valid values: `rule` (takes effect for the current rule) and `service` (takes effect globally).
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> Optional[pulumi.Input[str]]:
        """
        Revised the time. The date format is based on ISO8601 notation and uses UTC +0 time in the format of yyyy-MM-ddTHH:mm:ssZ.
        """
        return pulumi.get(self, "gmt_modified")

    @gmt_modified.setter
    def gmt_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gmt_modified", value)

    @property
    @pulumi.getter(name="otherRegionList")
    def other_region_list(self) -> Optional[pulumi.Input[str]]:
        """
        Blocked regions outside the Chinese mainland, separated by commas (,).
        """
        return pulumi.get(self, "other_region_list")

    @other_region_list.setter
    def other_region_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "other_region_list", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The protection policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input['WafRuleRateLimitArgs']]:
        """
        The rules of rate limiting. If you set `cc_status` to on, you must configure this parameter. See `rate_limit` below.
        """
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input['WafRuleRateLimitArgs']]):
        pulumi.set(self, "rate_limit", value)

    @property
    @pulumi.getter(name="regularRules")
    def regular_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
        """
        return pulumi.get(self, "regular_rules")

    @regular_rules.setter
    def regular_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regular_rules", value)

    @property
    @pulumi.getter(name="regularTypes")
    def regular_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
        """
        return pulumi.get(self, "regular_types")

    @regular_types.setter
    def regular_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regular_types", value)

    @property
    @pulumi.getter(name="remoteAddrs")
    def remote_addrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Filter by IP address.
        """
        return pulumi.get(self, "remote_addrs")

    @remote_addrs.setter
    def remote_addrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_addrs", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the protection rule. The name can be up to 64 characters in length and can contain letters, digits, and underscores (_). **NOTE:** This parameter cannot be modified when policy is of type `region_block`.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter
    def scenes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The types of the protection policies.
        """
        return pulumi.get(self, "scenes")

    @scenes.setter
    def scenes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scenes", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the waf rule. Valid values: `on` and `off`. Default value: on.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="wafGroupIds")
    def waf_group_ids(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the waf rule group. The default value is "1012". Multiple rules are separated by commas.
        """
        return pulumi.get(self, "waf_group_ids")

    @waf_group_ids.setter
    def waf_group_ids(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "waf_group_ids", value)


class WafRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 cc_status: Optional[pulumi.Input[str]] = None,
                 cn_region_list: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WafRuleConditionArgs']]]]] = None,
                 effect: Optional[pulumi.Input[str]] = None,
                 other_region_list: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 rate_limit: Optional[pulumi.Input[pulumi.InputType['WafRuleRateLimitArgs']]] = None,
                 regular_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 regular_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 scenes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 waf_group_ids: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Dcdn Waf Rule resource.

        For information about Dcdn Waf Rule and how to use it, see [What is Waf Rule](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-batchcreatedcdnwafrules).

        > **NOTE:** Available since v1.201.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        example_waf_policy = alicloud.dcdn.WafPolicy("exampleWafPolicy",
            defense_scene="waf_group",
            policy_name=name,
            policy_type="custom",
            status="on")
        example_waf_rule = alicloud.dcdn.WafRule("exampleWafRule",
            policy_id=example_waf_policy.id,
            rule_name=name,
            conditions=[
                alicloud.dcdn.WafRuleConditionArgs(
                    key="URI",
                    op_value="ne",
                    values="/login.php",
                ),
                alicloud.dcdn.WafRuleConditionArgs(
                    key="Header",
                    sub_key="a",
                    op_value="eq",
                    values="b",
                ),
            ],
            status="on",
            cc_status="on",
            action="monitor",
            effect="rule",
            rate_limit=alicloud.dcdn.WafRuleRateLimitArgs(
                target="IP",
                interval=5,
                threshold=5,
                ttl=1800,
                status=alicloud.dcdn.WafRuleRateLimitStatusArgs(
                    code="200",
                    ratio=60,
                ),
            ))
        ```

        ## Import

        Dcdn Waf Rule can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dcdn/wafRule:WafRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: Specifies the action of the rule. Valid values: `block`, `monitor`, `js`.
        :param pulumi.Input[str] cc_status: Specifies whether to enable rate limiting. Valid values: `on` and `off`. **NOTE:** This parameter is required when policy is of type `custom_acl`.
        :param pulumi.Input[str] cn_region_list: The blocked regions in the Chinese mainland, separated by commas (,).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WafRuleConditionArgs']]]] conditions: Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
        :param pulumi.Input[str] effect: The effective scope of the rate limiting blacklist. If you set ccStatus to on, you must configure this parameter. Valid values: `rule` (takes effect for the current rule) and `service` (takes effect globally).
        :param pulumi.Input[str] other_region_list: Blocked regions outside the Chinese mainland, separated by commas (,).
        :param pulumi.Input[str] policy_id: The protection policy ID.
        :param pulumi.Input[pulumi.InputType['WafRuleRateLimitArgs']] rate_limit: The rules of rate limiting. If you set `cc_status` to on, you must configure this parameter. See `rate_limit` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regular_rules: The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regular_types: Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_addrs: Filter by IP address.
        :param pulumi.Input[str] rule_name: The name of the protection rule. The name can be up to 64 characters in length and can contain letters, digits, and underscores (_). **NOTE:** This parameter cannot be modified when policy is of type `region_block`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scenes: The types of the protection policies.
        :param pulumi.Input[str] status: The status of the waf rule. Valid values: `on` and `off`. Default value: on.
        :param pulumi.Input[str] waf_group_ids: The id of the waf rule group. The default value is "1012". Multiple rules are separated by commas.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WafRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Dcdn Waf Rule resource.

        For information about Dcdn Waf Rule and how to use it, see [What is Waf Rule](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-batchcreatedcdnwafrules).

        > **NOTE:** Available since v1.201.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        example_waf_policy = alicloud.dcdn.WafPolicy("exampleWafPolicy",
            defense_scene="waf_group",
            policy_name=name,
            policy_type="custom",
            status="on")
        example_waf_rule = alicloud.dcdn.WafRule("exampleWafRule",
            policy_id=example_waf_policy.id,
            rule_name=name,
            conditions=[
                alicloud.dcdn.WafRuleConditionArgs(
                    key="URI",
                    op_value="ne",
                    values="/login.php",
                ),
                alicloud.dcdn.WafRuleConditionArgs(
                    key="Header",
                    sub_key="a",
                    op_value="eq",
                    values="b",
                ),
            ],
            status="on",
            cc_status="on",
            action="monitor",
            effect="rule",
            rate_limit=alicloud.dcdn.WafRuleRateLimitArgs(
                target="IP",
                interval=5,
                threshold=5,
                ttl=1800,
                status=alicloud.dcdn.WafRuleRateLimitStatusArgs(
                    code="200",
                    ratio=60,
                ),
            ))
        ```

        ## Import

        Dcdn Waf Rule can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dcdn/wafRule:WafRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param WafRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WafRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 cc_status: Optional[pulumi.Input[str]] = None,
                 cn_region_list: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WafRuleConditionArgs']]]]] = None,
                 effect: Optional[pulumi.Input[str]] = None,
                 other_region_list: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 rate_limit: Optional[pulumi.Input[pulumi.InputType['WafRuleRateLimitArgs']]] = None,
                 regular_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 regular_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 scenes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 waf_group_ids: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WafRuleArgs.__new__(WafRuleArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["cc_status"] = cc_status
            __props__.__dict__["cn_region_list"] = cn_region_list
            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["effect"] = effect
            __props__.__dict__["other_region_list"] = other_region_list
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["rate_limit"] = rate_limit
            __props__.__dict__["regular_rules"] = regular_rules
            __props__.__dict__["regular_types"] = regular_types
            __props__.__dict__["remote_addrs"] = remote_addrs
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["scenes"] = scenes
            __props__.__dict__["status"] = status
            __props__.__dict__["waf_group_ids"] = waf_group_ids
            __props__.__dict__["defense_scene"] = None
            __props__.__dict__["gmt_modified"] = None
        super(WafRule, __self__).__init__(
            'alicloud:dcdn/wafRule:WafRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            cc_status: Optional[pulumi.Input[str]] = None,
            cn_region_list: Optional[pulumi.Input[str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WafRuleConditionArgs']]]]] = None,
            defense_scene: Optional[pulumi.Input[str]] = None,
            effect: Optional[pulumi.Input[str]] = None,
            gmt_modified: Optional[pulumi.Input[str]] = None,
            other_region_list: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            rate_limit: Optional[pulumi.Input[pulumi.InputType['WafRuleRateLimitArgs']]] = None,
            regular_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            regular_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            remote_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rule_name: Optional[pulumi.Input[str]] = None,
            scenes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            waf_group_ids: Optional[pulumi.Input[str]] = None) -> 'WafRule':
        """
        Get an existing WafRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: Specifies the action of the rule. Valid values: `block`, `monitor`, `js`.
        :param pulumi.Input[str] cc_status: Specifies whether to enable rate limiting. Valid values: `on` and `off`. **NOTE:** This parameter is required when policy is of type `custom_acl`.
        :param pulumi.Input[str] cn_region_list: The blocked regions in the Chinese mainland, separated by commas (,).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WafRuleConditionArgs']]]] conditions: Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
        :param pulumi.Input[str] defense_scene: The type of protection policy. The following scenarios are supported:-waf_group:Web basic protection-custom_acl: Custom protection policy-whitelist: whitelist
        :param pulumi.Input[str] effect: The effective scope of the rate limiting blacklist. If you set ccStatus to on, you must configure this parameter. Valid values: `rule` (takes effect for the current rule) and `service` (takes effect globally).
        :param pulumi.Input[str] gmt_modified: Revised the time. The date format is based on ISO8601 notation and uses UTC +0 time in the format of yyyy-MM-ddTHH:mm:ssZ.
        :param pulumi.Input[str] other_region_list: Blocked regions outside the Chinese mainland, separated by commas (,).
        :param pulumi.Input[str] policy_id: The protection policy ID.
        :param pulumi.Input[pulumi.InputType['WafRuleRateLimitArgs']] rate_limit: The rules of rate limiting. If you set `cc_status` to on, you must configure this parameter. See `rate_limit` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regular_rules: The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regular_types: Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_addrs: Filter by IP address.
        :param pulumi.Input[str] rule_name: The name of the protection rule. The name can be up to 64 characters in length and can contain letters, digits, and underscores (_). **NOTE:** This parameter cannot be modified when policy is of type `region_block`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scenes: The types of the protection policies.
        :param pulumi.Input[str] status: The status of the waf rule. Valid values: `on` and `off`. Default value: on.
        :param pulumi.Input[str] waf_group_ids: The id of the waf rule group. The default value is "1012". Multiple rules are separated by commas.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WafRuleState.__new__(_WafRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["cc_status"] = cc_status
        __props__.__dict__["cn_region_list"] = cn_region_list
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["defense_scene"] = defense_scene
        __props__.__dict__["effect"] = effect
        __props__.__dict__["gmt_modified"] = gmt_modified
        __props__.__dict__["other_region_list"] = other_region_list
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["rate_limit"] = rate_limit
        __props__.__dict__["regular_rules"] = regular_rules
        __props__.__dict__["regular_types"] = regular_types
        __props__.__dict__["remote_addrs"] = remote_addrs
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["scenes"] = scenes
        __props__.__dict__["status"] = status
        __props__.__dict__["waf_group_ids"] = waf_group_ids
        return WafRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the action of the rule. Valid values: `block`, `monitor`, `js`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="ccStatus")
    def cc_status(self) -> pulumi.Output[str]:
        """
        Specifies whether to enable rate limiting. Valid values: `on` and `off`. **NOTE:** This parameter is required when policy is of type `custom_acl`.
        """
        return pulumi.get(self, "cc_status")

    @property
    @pulumi.getter(name="cnRegionList")
    def cn_region_list(self) -> pulumi.Output[Optional[str]]:
        """
        The blocked regions in the Chinese mainland, separated by commas (,).
        """
        return pulumi.get(self, "cn_region_list")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.WafRuleCondition']]]:
        """
        Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="defenseScene")
    def defense_scene(self) -> pulumi.Output[str]:
        """
        The type of protection policy. The following scenarios are supported:-waf_group:Web basic protection-custom_acl: Custom protection policy-whitelist: whitelist
        """
        return pulumi.get(self, "defense_scene")

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Output[Optional[str]]:
        """
        The effective scope of the rate limiting blacklist. If you set ccStatus to on, you must configure this parameter. Valid values: `rule` (takes effect for the current rule) and `service` (takes effect globally).
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> pulumi.Output[str]:
        """
        Revised the time. The date format is based on ISO8601 notation and uses UTC +0 time in the format of yyyy-MM-ddTHH:mm:ssZ.
        """
        return pulumi.get(self, "gmt_modified")

    @property
    @pulumi.getter(name="otherRegionList")
    def other_region_list(self) -> pulumi.Output[Optional[str]]:
        """
        Blocked regions outside the Chinese mainland, separated by commas (,).
        """
        return pulumi.get(self, "other_region_list")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        The protection policy ID.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> pulumi.Output[Optional['outputs.WafRuleRateLimit']]:
        """
        The rules of rate limiting. If you set `cc_status` to on, you must configure this parameter. See `rate_limit` below.
        """
        return pulumi.get(self, "rate_limit")

    @property
    @pulumi.getter(name="regularRules")
    def regular_rules(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
        """
        return pulumi.get(self, "regular_rules")

    @property
    @pulumi.getter(name="regularTypes")
    def regular_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
        """
        return pulumi.get(self, "regular_types")

    @property
    @pulumi.getter(name="remoteAddrs")
    def remote_addrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Filter by IP address.
        """
        return pulumi.get(self, "remote_addrs")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[str]:
        """
        The name of the protection rule. The name can be up to 64 characters in length and can contain letters, digits, and underscores (_). **NOTE:** This parameter cannot be modified when policy is of type `region_block`.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter
    def scenes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The types of the protection policies.
        """
        return pulumi.get(self, "scenes")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the waf rule. Valid values: `on` and `off`. Default value: on.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="wafGroupIds")
    def waf_group_ids(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the waf rule group. The default value is "1012". Multiple rules are separated by commas.
        """
        return pulumi.get(self, "waf_group_ids")

