# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BasicThresholdArgs', 'BasicThreshold']

@pulumi.input_type
class BasicThresholdArgs:
    def __init__(__self__, *,
                 bps: pulumi.Input[int],
                 instance_id: pulumi.Input[str],
                 instance_type: pulumi.Input[str],
                 internet_ip: pulumi.Input[str],
                 pps: pulumi.Input[int]):
        """
        The set of arguments for constructing a BasicThreshold resource.
        :param pulumi.Input[int] bps: Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] instance_type: The type of the Instance. Valid values: `ecs`,`slb`,`eip`.
        :param pulumi.Input[str] internet_ip: The IP address of the public IP address asset.
        :param pulumi.Input[int] pps: The current message number cleaning threshold. Unit: pps.
        """
        pulumi.set(__self__, "bps", bps)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "pps", pps)

    @property
    @pulumi.getter
    def bps(self) -> pulumi.Input[int]:
        """
        Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
        """
        return pulumi.get(self, "bps")

    @bps.setter
    def bps(self, value: pulumi.Input[int]):
        pulumi.set(self, "bps", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        The type of the Instance. Valid values: `ecs`,`slb`,`eip`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> pulumi.Input[str]:
        """
        The IP address of the public IP address asset.
        """
        return pulumi.get(self, "internet_ip")

    @internet_ip.setter
    def internet_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "internet_ip", value)

    @property
    @pulumi.getter
    def pps(self) -> pulumi.Input[int]:
        """
        The current message number cleaning threshold. Unit: pps.
        """
        return pulumi.get(self, "pps")

    @pps.setter
    def pps(self, value: pulumi.Input[int]):
        pulumi.set(self, "pps", value)


@pulumi.input_type
class _BasicThresholdState:
    def __init__(__self__, *,
                 bps: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_ip: Optional[pulumi.Input[str]] = None,
                 max_bps: Optional[pulumi.Input[int]] = None,
                 max_pps: Optional[pulumi.Input[int]] = None,
                 pps: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering BasicThreshold resources.
        :param pulumi.Input[int] bps: Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] instance_type: The type of the Instance. Valid values: `ecs`,`slb`,`eip`.
        :param pulumi.Input[str] internet_ip: The IP address of the public IP address asset.
        :param pulumi.Input[int] max_bps: Maximum flow cleaning threshold. Unit: Mbps.
        :param pulumi.Input[int] max_pps: The maximum number of messages cleaning threshold. Unit: pps.
        :param pulumi.Input[int] pps: The current message number cleaning threshold. Unit: pps.
        """
        if bps is not None:
            pulumi.set(__self__, "bps", bps)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_ip is not None:
            pulumi.set(__self__, "internet_ip", internet_ip)
        if max_bps is not None:
            pulumi.set(__self__, "max_bps", max_bps)
        if max_pps is not None:
            pulumi.set(__self__, "max_pps", max_pps)
        if pps is not None:
            pulumi.set(__self__, "pps", pps)

    @property
    @pulumi.getter
    def bps(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
        """
        return pulumi.get(self, "bps")

    @bps.setter
    def bps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bps", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Instance. Valid values: `ecs`,`slb`,`eip`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the public IP address asset.
        """
        return pulumi.get(self, "internet_ip")

    @internet_ip.setter
    def internet_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_ip", value)

    @property
    @pulumi.getter(name="maxBps")
    def max_bps(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum flow cleaning threshold. Unit: Mbps.
        """
        return pulumi.get(self, "max_bps")

    @max_bps.setter
    def max_bps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bps", value)

    @property
    @pulumi.getter(name="maxPps")
    def max_pps(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of messages cleaning threshold. Unit: pps.
        """
        return pulumi.get(self, "max_pps")

    @max_pps.setter
    def max_pps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pps", value)

    @property
    @pulumi.getter
    def pps(self) -> Optional[pulumi.Input[int]]:
        """
        The current message number cleaning threshold. Unit: pps.
        """
        return pulumi.get(self, "pps")

    @pps.setter
    def pps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pps", value)


class BasicThreshold(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bps: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_ip: Optional[pulumi.Input[str]] = None,
                 pps: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Ddos Basic Threshold resource.

        For information about Ddos Basic Threshold and how to use it, see [What is Threshold](https://www.alibabacloud.com/help/en/ddos-protection/latest/describe-ip-ddosthreshold).

        > **NOTE:** Available since v1.183.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            instance_type_family="ecs.sn1ne")
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            vpc_id=default_network.id,
            cidr_block="192.168.192.0/24",
            zone_id=default_zones.ids[0])
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("defaultInstance",
            image_id=default_images.images[0].id,
            instance_type=default_instance_types.instance_types[0].id,
            instance_name=name,
            security_groups=[__item.id for __item in [default_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=default_zones.zones[0].id,
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=default_switch.id)
        example = alicloud.ddos.BasicThreshold("example",
            instance_type="ecs",
            instance_id=default_instance.id,
            internet_ip=default_instance.public_ip,
            bps=100,
            pps=60000)
        ```

        ## Import

        Ddos Basic Threshold can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ddos/basicThreshold:BasicThreshold example <instance_type>:<instance_id>:<internet_ip>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bps: Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] instance_type: The type of the Instance. Valid values: `ecs`,`slb`,`eip`.
        :param pulumi.Input[str] internet_ip: The IP address of the public IP address asset.
        :param pulumi.Input[int] pps: The current message number cleaning threshold. Unit: pps.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BasicThresholdArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Ddos Basic Threshold resource.

        For information about Ddos Basic Threshold and how to use it, see [What is Threshold](https://www.alibabacloud.com/help/en/ddos-protection/latest/describe-ip-ddosthreshold).

        > **NOTE:** Available since v1.183.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            instance_type_family="ecs.sn1ne")
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            vpc_id=default_network.id,
            cidr_block="192.168.192.0/24",
            zone_id=default_zones.ids[0])
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("defaultInstance",
            image_id=default_images.images[0].id,
            instance_type=default_instance_types.instance_types[0].id,
            instance_name=name,
            security_groups=[__item.id for __item in [default_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=default_zones.zones[0].id,
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=default_switch.id)
        example = alicloud.ddos.BasicThreshold("example",
            instance_type="ecs",
            instance_id=default_instance.id,
            internet_ip=default_instance.public_ip,
            bps=100,
            pps=60000)
        ```

        ## Import

        Ddos Basic Threshold can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ddos/basicThreshold:BasicThreshold example <instance_type>:<instance_id>:<internet_ip>
        ```

        :param str resource_name: The name of the resource.
        :param BasicThresholdArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BasicThresholdArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bps: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_ip: Optional[pulumi.Input[str]] = None,
                 pps: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BasicThresholdArgs.__new__(BasicThresholdArgs)

            if bps is None and not opts.urn:
                raise TypeError("Missing required property 'bps'")
            __props__.__dict__["bps"] = bps
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            if internet_ip is None and not opts.urn:
                raise TypeError("Missing required property 'internet_ip'")
            __props__.__dict__["internet_ip"] = internet_ip
            if pps is None and not opts.urn:
                raise TypeError("Missing required property 'pps'")
            __props__.__dict__["pps"] = pps
            __props__.__dict__["max_bps"] = None
            __props__.__dict__["max_pps"] = None
        super(BasicThreshold, __self__).__init__(
            'alicloud:ddos/basicThreshold:BasicThreshold',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bps: Optional[pulumi.Input[int]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            internet_ip: Optional[pulumi.Input[str]] = None,
            max_bps: Optional[pulumi.Input[int]] = None,
            max_pps: Optional[pulumi.Input[int]] = None,
            pps: Optional[pulumi.Input[int]] = None) -> 'BasicThreshold':
        """
        Get an existing BasicThreshold resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bps: Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] instance_type: The type of the Instance. Valid values: `ecs`,`slb`,`eip`.
        :param pulumi.Input[str] internet_ip: The IP address of the public IP address asset.
        :param pulumi.Input[int] max_bps: Maximum flow cleaning threshold. Unit: Mbps.
        :param pulumi.Input[int] max_pps: The maximum number of messages cleaning threshold. Unit: pps.
        :param pulumi.Input[int] pps: The current message number cleaning threshold. Unit: pps.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BasicThresholdState.__new__(_BasicThresholdState)

        __props__.__dict__["bps"] = bps
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["internet_ip"] = internet_ip
        __props__.__dict__["max_bps"] = max_bps
        __props__.__dict__["max_pps"] = max_pps
        __props__.__dict__["pps"] = pps
        return BasicThreshold(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bps(self) -> pulumi.Output[int]:
        """
        Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
        """
        return pulumi.get(self, "bps")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The type of the Instance. Valid values: `ecs`,`slb`,`eip`.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> pulumi.Output[str]:
        """
        The IP address of the public IP address asset.
        """
        return pulumi.get(self, "internet_ip")

    @property
    @pulumi.getter(name="maxBps")
    def max_bps(self) -> pulumi.Output[int]:
        """
        Maximum flow cleaning threshold. Unit: Mbps.
        """
        return pulumi.get(self, "max_bps")

    @property
    @pulumi.getter(name="maxPps")
    def max_pps(self) -> pulumi.Output[int]:
        """
        The maximum number of messages cleaning threshold. Unit: pps.
        """
        return pulumi.get(self, "max_pps")

    @property
    @pulumi.getter
    def pps(self) -> pulumi.Output[int]:
        """
        The current message number cleaning threshold. Unit: pps.
        """
        return pulumi.get(self, "pps")

