# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['FileSystemArgs', 'FileSystem']

@pulumi.input_type
class FileSystemArgs:
    def __init__(__self__, *,
                 file_system_name: pulumi.Input[str],
                 protocol_type: pulumi.Input[str],
                 space_capacity: pulumi.Input[int],
                 storage_type: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mi_bps: Optional[pulumi.Input[int]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FileSystem resource.
        :param pulumi.Input[str] file_system_name: The name of the File system.
        :param pulumi.Input[str] protocol_type: The protocol type. Valid values: `HDFS`.
        :param pulumi.Input[int] space_capacity: The capacity budget of the File system. **NOTE:** When the actual data storage reaches the file system capacity budget, the data cannot be written. The file system capacity budget does not support shrinking.
        :param pulumi.Input[str] storage_type: The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
        :param pulumi.Input[str] zone_id: The zone ID of the File system.
        :param pulumi.Input[str] description: The description of the File system.
        :param pulumi.Input[int] provisioned_throughput_in_mi_bps: The preset throughput of the File system. Valid values: `1` to `1024`, Unit: MB/s. **NOTE:** Only when `throughput_mode` is `Provisioned`, this param is valid.
        :param pulumi.Input[str] throughput_mode: The throughput mode of the File system. Valid values: `Provisioned`, `Standard`.
        """
        pulumi.set(__self__, "file_system_name", file_system_name)
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "space_capacity", space_capacity)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "zone_id", zone_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if provisioned_throughput_in_mi_bps is not None:
            pulumi.set(__self__, "provisioned_throughput_in_mi_bps", provisioned_throughput_in_mi_bps)
        if throughput_mode is not None:
            pulumi.set(__self__, "throughput_mode", throughput_mode)

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> pulumi.Input[str]:
        """
        The name of the File system.
        """
        return pulumi.get(self, "file_system_name")

    @file_system_name.setter
    def file_system_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_system_name", value)

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Input[str]:
        """
        The protocol type. Valid values: `HDFS`.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol_type", value)

    @property
    @pulumi.getter(name="spaceCapacity")
    def space_capacity(self) -> pulumi.Input[int]:
        """
        The capacity budget of the File system. **NOTE:** When the actual data storage reaches the file system capacity budget, the data cannot be written. The file system capacity budget does not support shrinking.
        """
        return pulumi.get(self, "space_capacity")

    @space_capacity.setter
    def space_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "space_capacity", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[str]:
        """
        The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone ID of the File system.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the File system.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="provisionedThroughputInMiBps")
    def provisioned_throughput_in_mi_bps(self) -> Optional[pulumi.Input[int]]:
        """
        The preset throughput of the File system. Valid values: `1` to `1024`, Unit: MB/s. **NOTE:** Only when `throughput_mode` is `Provisioned`, this param is valid.
        """
        return pulumi.get(self, "provisioned_throughput_in_mi_bps")

    @provisioned_throughput_in_mi_bps.setter
    def provisioned_throughput_in_mi_bps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_throughput_in_mi_bps", value)

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The throughput mode of the File system. Valid values: `Provisioned`, `Standard`.
        """
        return pulumi.get(self, "throughput_mode")

    @throughput_mode.setter
    def throughput_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throughput_mode", value)


@pulumi.input_type
class _FileSystemState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 file_system_name: Optional[pulumi.Input[str]] = None,
                 protocol_type: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mi_bps: Optional[pulumi.Input[int]] = None,
                 space_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FileSystem resources.
        :param pulumi.Input[str] description: The description of the File system.
        :param pulumi.Input[str] file_system_name: The name of the File system.
        :param pulumi.Input[str] protocol_type: The protocol type. Valid values: `HDFS`.
        :param pulumi.Input[int] provisioned_throughput_in_mi_bps: The preset throughput of the File system. Valid values: `1` to `1024`, Unit: MB/s. **NOTE:** Only when `throughput_mode` is `Provisioned`, this param is valid.
        :param pulumi.Input[int] space_capacity: The capacity budget of the File system. **NOTE:** When the actual data storage reaches the file system capacity budget, the data cannot be written. The file system capacity budget does not support shrinking.
        :param pulumi.Input[str] storage_type: The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
        :param pulumi.Input[str] throughput_mode: The throughput mode of the File system. Valid values: `Provisioned`, `Standard`.
        :param pulumi.Input[str] zone_id: The zone ID of the File system.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_name is not None:
            pulumi.set(__self__, "file_system_name", file_system_name)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if provisioned_throughput_in_mi_bps is not None:
            pulumi.set(__self__, "provisioned_throughput_in_mi_bps", provisioned_throughput_in_mi_bps)
        if space_capacity is not None:
            pulumi.set(__self__, "space_capacity", space_capacity)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if throughput_mode is not None:
            pulumi.set(__self__, "throughput_mode", throughput_mode)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the File system.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the File system.
        """
        return pulumi.get(self, "file_system_name")

    @file_system_name.setter
    def file_system_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_name", value)

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol type. Valid values: `HDFS`.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol_type", value)

    @property
    @pulumi.getter(name="provisionedThroughputInMiBps")
    def provisioned_throughput_in_mi_bps(self) -> Optional[pulumi.Input[int]]:
        """
        The preset throughput of the File system. Valid values: `1` to `1024`, Unit: MB/s. **NOTE:** Only when `throughput_mode` is `Provisioned`, this param is valid.
        """
        return pulumi.get(self, "provisioned_throughput_in_mi_bps")

    @provisioned_throughput_in_mi_bps.setter
    def provisioned_throughput_in_mi_bps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_throughput_in_mi_bps", value)

    @property
    @pulumi.getter(name="spaceCapacity")
    def space_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The capacity budget of the File system. **NOTE:** When the actual data storage reaches the file system capacity budget, the data cannot be written. The file system capacity budget does not support shrinking.
        """
        return pulumi.get(self, "space_capacity")

    @space_capacity.setter
    def space_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "space_capacity", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The throughput mode of the File system. Valid values: `Provisioned`, `Standard`.
        """
        return pulumi.get(self, "throughput_mode")

    @throughput_mode.setter
    def throughput_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throughput_mode", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the File system.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class FileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 file_system_name: Optional[pulumi.Input[str]] = None,
                 protocol_type: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mi_bps: Optional[pulumi.Input[int]] = None,
                 space_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a DFS File System resource.

        For information about DFS File System and how to use it, see [What is File System](https://www.alibabacloud.com/help/doc-detail/207144.htm).

        > **NOTE:** Available since v1.140.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.dfs.get_zones()
        default_file_system = alicloud.dfs.FileSystem("defaultFileSystem",
            storage_type=default_zones.zones[0].options[0].storage_type,
            zone_id=default_zones.zones[0].zone_id,
            protocol_type="HDFS",
            description=name,
            file_system_name=name,
            throughput_mode="Standard",
            space_capacity=1024)
        ```

        ## Import

        DFS File System can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dfs/fileSystem:FileSystem example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the File system.
        :param pulumi.Input[str] file_system_name: The name of the File system.
        :param pulumi.Input[str] protocol_type: The protocol type. Valid values: `HDFS`.
        :param pulumi.Input[int] provisioned_throughput_in_mi_bps: The preset throughput of the File system. Valid values: `1` to `1024`, Unit: MB/s. **NOTE:** Only when `throughput_mode` is `Provisioned`, this param is valid.
        :param pulumi.Input[int] space_capacity: The capacity budget of the File system. **NOTE:** When the actual data storage reaches the file system capacity budget, the data cannot be written. The file system capacity budget does not support shrinking.
        :param pulumi.Input[str] storage_type: The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
        :param pulumi.Input[str] throughput_mode: The throughput mode of the File system. Valid values: `Provisioned`, `Standard`.
        :param pulumi.Input[str] zone_id: The zone ID of the File system.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DFS File System resource.

        For information about DFS File System and how to use it, see [What is File System](https://www.alibabacloud.com/help/doc-detail/207144.htm).

        > **NOTE:** Available since v1.140.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.dfs.get_zones()
        default_file_system = alicloud.dfs.FileSystem("defaultFileSystem",
            storage_type=default_zones.zones[0].options[0].storage_type,
            zone_id=default_zones.zones[0].zone_id,
            protocol_type="HDFS",
            description=name,
            file_system_name=name,
            throughput_mode="Standard",
            space_capacity=1024)
        ```

        ## Import

        DFS File System can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dfs/fileSystem:FileSystem example <id>
        ```

        :param str resource_name: The name of the resource.
        :param FileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 file_system_name: Optional[pulumi.Input[str]] = None,
                 protocol_type: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mi_bps: Optional[pulumi.Input[int]] = None,
                 space_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileSystemArgs.__new__(FileSystemArgs)

            __props__.__dict__["description"] = description
            if file_system_name is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_name'")
            __props__.__dict__["file_system_name"] = file_system_name
            if protocol_type is None and not opts.urn:
                raise TypeError("Missing required property 'protocol_type'")
            __props__.__dict__["protocol_type"] = protocol_type
            __props__.__dict__["provisioned_throughput_in_mi_bps"] = provisioned_throughput_in_mi_bps
            if space_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'space_capacity'")
            __props__.__dict__["space_capacity"] = space_capacity
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["throughput_mode"] = None if throughput_mode is None else pulumi.Output.secret(throughput_mode)
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["throughputMode"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FileSystem, __self__).__init__(
            'alicloud:dfs/fileSystem:FileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            file_system_name: Optional[pulumi.Input[str]] = None,
            protocol_type: Optional[pulumi.Input[str]] = None,
            provisioned_throughput_in_mi_bps: Optional[pulumi.Input[int]] = None,
            space_capacity: Optional[pulumi.Input[int]] = None,
            storage_type: Optional[pulumi.Input[str]] = None,
            throughput_mode: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'FileSystem':
        """
        Get an existing FileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the File system.
        :param pulumi.Input[str] file_system_name: The name of the File system.
        :param pulumi.Input[str] protocol_type: The protocol type. Valid values: `HDFS`.
        :param pulumi.Input[int] provisioned_throughput_in_mi_bps: The preset throughput of the File system. Valid values: `1` to `1024`, Unit: MB/s. **NOTE:** Only when `throughput_mode` is `Provisioned`, this param is valid.
        :param pulumi.Input[int] space_capacity: The capacity budget of the File system. **NOTE:** When the actual data storage reaches the file system capacity budget, the data cannot be written. The file system capacity budget does not support shrinking.
        :param pulumi.Input[str] storage_type: The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
        :param pulumi.Input[str] throughput_mode: The throughput mode of the File system. Valid values: `Provisioned`, `Standard`.
        :param pulumi.Input[str] zone_id: The zone ID of the File system.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileSystemState.__new__(_FileSystemState)

        __props__.__dict__["description"] = description
        __props__.__dict__["file_system_name"] = file_system_name
        __props__.__dict__["protocol_type"] = protocol_type
        __props__.__dict__["provisioned_throughput_in_mi_bps"] = provisioned_throughput_in_mi_bps
        __props__.__dict__["space_capacity"] = space_capacity
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["throughput_mode"] = throughput_mode
        __props__.__dict__["zone_id"] = zone_id
        return FileSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the File system.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> pulumi.Output[str]:
        """
        The name of the File system.
        """
        return pulumi.get(self, "file_system_name")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Output[str]:
        """
        The protocol type. Valid values: `HDFS`.
        """
        return pulumi.get(self, "protocol_type")

    @property
    @pulumi.getter(name="provisionedThroughputInMiBps")
    def provisioned_throughput_in_mi_bps(self) -> pulumi.Output[Optional[int]]:
        """
        The preset throughput of the File system. Valid values: `1` to `1024`, Unit: MB/s. **NOTE:** Only when `throughput_mode` is `Provisioned`, this param is valid.
        """
        return pulumi.get(self, "provisioned_throughput_in_mi_bps")

    @property
    @pulumi.getter(name="spaceCapacity")
    def space_capacity(self) -> pulumi.Output[int]:
        """
        The capacity budget of the File system. **NOTE:** When the actual data storage reaches the file system capacity budget, the data cannot be written. The file system capacity budget does not support shrinking.
        """
        return pulumi.get(self, "space_capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[str]:
        """
        The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The throughput mode of the File system. Valid values: `Provisioned`, `Standard`.
        """
        return pulumi.get(self, "throughput_mode")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone ID of the File system.
        """
        return pulumi.get(self, "zone_id")

