# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MailAddressArgs', 'MailAddress']

@pulumi.input_type
class MailAddressArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 sendtype: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 reply_address: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MailAddress resource.
        :param pulumi.Input[str] account_name: The sender address. The email address must be filled in the format of account@domain, and only lowercase letters or numbers can be used.
        :param pulumi.Input[str] sendtype: Account type. Valid values: `batch`, `trigger`.
        :param pulumi.Input[str] password: Account password. The password must be length 10-20 string, contains numbers, uppercase letters, lowercase letters at the same time.
        :param pulumi.Input[str] reply_address: Return address.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "sendtype", sendtype)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if reply_address is not None:
            pulumi.set(__self__, "reply_address", reply_address)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        The sender address. The email address must be filled in the format of account@domain, and only lowercase letters or numbers can be used.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter
    def sendtype(self) -> pulumi.Input[str]:
        """
        Account type. Valid values: `batch`, `trigger`.
        """
        return pulumi.get(self, "sendtype")

    @sendtype.setter
    def sendtype(self, value: pulumi.Input[str]):
        pulumi.set(self, "sendtype", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Account password. The password must be length 10-20 string, contains numbers, uppercase letters, lowercase letters at the same time.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="replyAddress")
    def reply_address(self) -> Optional[pulumi.Input[str]]:
        """
        Return address.
        """
        return pulumi.get(self, "reply_address")

    @reply_address.setter
    def reply_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reply_address", value)


@pulumi.input_type
class _MailAddressState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 reply_address: Optional[pulumi.Input[str]] = None,
                 sendtype: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MailAddress resources.
        :param pulumi.Input[str] account_name: The sender address. The email address must be filled in the format of account@domain, and only lowercase letters or numbers can be used.
        :param pulumi.Input[str] password: Account password. The password must be length 10-20 string, contains numbers, uppercase letters, lowercase letters at the same time.
        :param pulumi.Input[str] reply_address: Return address.
        :param pulumi.Input[str] sendtype: Account type. Valid values: `batch`, `trigger`.
        :param pulumi.Input[str] status: Account Status freeze: 1, normal: 0.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if reply_address is not None:
            pulumi.set(__self__, "reply_address", reply_address)
        if sendtype is not None:
            pulumi.set(__self__, "sendtype", sendtype)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The sender address. The email address must be filled in the format of account@domain, and only lowercase letters or numbers can be used.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Account password. The password must be length 10-20 string, contains numbers, uppercase letters, lowercase letters at the same time.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="replyAddress")
    def reply_address(self) -> Optional[pulumi.Input[str]]:
        """
        Return address.
        """
        return pulumi.get(self, "reply_address")

    @reply_address.setter
    def reply_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reply_address", value)

    @property
    @pulumi.getter
    def sendtype(self) -> Optional[pulumi.Input[str]]:
        """
        Account type. Valid values: `batch`, `trigger`.
        """
        return pulumi.get(self, "sendtype")

    @sendtype.setter
    def sendtype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sendtype", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Account Status freeze: 1, normal: 0.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class MailAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 reply_address: Optional[pulumi.Input[str]] = None,
                 sendtype: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Direct Mail Mail Address resource.

        For information about Direct Mail Mail Address and how to use it, see [What is Mail Address](https://www.alibabacloud.com/help/en/directmail/latest/set-up-sender-addresses).

        > **NOTE:** Available since v1.134.0.

        ## Import

        Direct Mail Mail Address can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:directmail/mailAddress:MailAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: The sender address. The email address must be filled in the format of account@domain, and only lowercase letters or numbers can be used.
        :param pulumi.Input[str] password: Account password. The password must be length 10-20 string, contains numbers, uppercase letters, lowercase letters at the same time.
        :param pulumi.Input[str] reply_address: Return address.
        :param pulumi.Input[str] sendtype: Account type. Valid values: `batch`, `trigger`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MailAddressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Direct Mail Mail Address resource.

        For information about Direct Mail Mail Address and how to use it, see [What is Mail Address](https://www.alibabacloud.com/help/en/directmail/latest/set-up-sender-addresses).

        > **NOTE:** Available since v1.134.0.

        ## Import

        Direct Mail Mail Address can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:directmail/mailAddress:MailAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param MailAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MailAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 reply_address: Optional[pulumi.Input[str]] = None,
                 sendtype: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MailAddressArgs.__new__(MailAddressArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["password"] = password
            __props__.__dict__["reply_address"] = reply_address
            if sendtype is None and not opts.urn:
                raise TypeError("Missing required property 'sendtype'")
            __props__.__dict__["sendtype"] = sendtype
            __props__.__dict__["status"] = None
        super(MailAddress, __self__).__init__(
            'alicloud:directmail/mailAddress:MailAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            reply_address: Optional[pulumi.Input[str]] = None,
            sendtype: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'MailAddress':
        """
        Get an existing MailAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: The sender address. The email address must be filled in the format of account@domain, and only lowercase letters or numbers can be used.
        :param pulumi.Input[str] password: Account password. The password must be length 10-20 string, contains numbers, uppercase letters, lowercase letters at the same time.
        :param pulumi.Input[str] reply_address: Return address.
        :param pulumi.Input[str] sendtype: Account type. Valid values: `batch`, `trigger`.
        :param pulumi.Input[str] status: Account Status freeze: 1, normal: 0.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MailAddressState.__new__(_MailAddressState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["password"] = password
        __props__.__dict__["reply_address"] = reply_address
        __props__.__dict__["sendtype"] = sendtype
        __props__.__dict__["status"] = status
        return MailAddress(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        The sender address. The email address must be filled in the format of account@domain, and only lowercase letters or numbers can be used.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Account password. The password must be length 10-20 string, contains numbers, uppercase letters, lowercase letters at the same time.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="replyAddress")
    def reply_address(self) -> pulumi.Output[Optional[str]]:
        """
        Return address.
        """
        return pulumi.get(self, "reply_address")

    @property
    @pulumi.getter
    def sendtype(self) -> pulumi.Output[str]:
        """
        Account type. Valid values: `batch`, `trigger`.
        """
        return pulumi.get(self, "sendtype")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Account Status freeze: 1, normal: 0.
        """
        return pulumi.get(self, "status")

