# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EnterpriseAuthorityTemplateArgs', 'EnterpriseAuthorityTemplate']

@pulumi.input_type
class EnterpriseAuthorityTemplateArgs:
    def __init__(__self__, *,
                 authority_template_name: pulumi.Input[str],
                 tid: pulumi.Input[int],
                 description: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EnterpriseAuthorityTemplate resource.
        :param pulumi.Input[str] authority_template_name: Permission Template name.
        :param pulumi.Input[int] tid: Tenant ID.
        :param pulumi.Input[str] description: Permission template description information.
        """
        pulumi.set(__self__, "authority_template_name", authority_template_name)
        pulumi.set(__self__, "tid", tid)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="authorityTemplateName")
    def authority_template_name(self) -> pulumi.Input[str]:
        """
        Permission Template name.
        """
        return pulumi.get(self, "authority_template_name")

    @authority_template_name.setter
    def authority_template_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "authority_template_name", value)

    @property
    @pulumi.getter
    def tid(self) -> pulumi.Input[int]:
        """
        Tenant ID.
        """
        return pulumi.get(self, "tid")

    @tid.setter
    def tid(self, value: pulumi.Input[int]):
        pulumi.set(self, "tid", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Permission template description information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _EnterpriseAuthorityTemplateState:
    def __init__(__self__, *,
                 authority_template_id: Optional[pulumi.Input[int]] = None,
                 authority_template_name: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 tid: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering EnterpriseAuthorityTemplate resources.
        :param pulumi.Input[int] authority_template_id: Permission template ID.
        :param pulumi.Input[str] authority_template_name: Permission Template name.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] description: Permission template description information.
        :param pulumi.Input[int] tid: Tenant ID.
        """
        if authority_template_id is not None:
            pulumi.set(__self__, "authority_template_id", authority_template_id)
        if authority_template_name is not None:
            pulumi.set(__self__, "authority_template_name", authority_template_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if tid is not None:
            pulumi.set(__self__, "tid", tid)

    @property
    @pulumi.getter(name="authorityTemplateId")
    def authority_template_id(self) -> Optional[pulumi.Input[int]]:
        """
        Permission template ID.
        """
        return pulumi.get(self, "authority_template_id")

    @authority_template_id.setter
    def authority_template_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "authority_template_id", value)

    @property
    @pulumi.getter(name="authorityTemplateName")
    def authority_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        Permission Template name.
        """
        return pulumi.get(self, "authority_template_name")

    @authority_template_name.setter
    def authority_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authority_template_name", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Permission template description information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def tid(self) -> Optional[pulumi.Input[int]]:
        """
        Tenant ID.
        """
        return pulumi.get(self, "tid")

    @tid.setter
    def tid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tid", value)


class EnterpriseAuthorityTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authority_template_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 tid: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a DMS Enterprise Authority Template resource.

        For information about DMS Enterprise Authority Template and how to use it, see [What is Authority Template](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-createauthoritytemplate).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_user_tenants = alicloud.dms.get_user_tenants(status="ACTIVE")
        default_enterprise_authority_template = alicloud.dms.EnterpriseAuthorityTemplate("defaultEnterpriseAuthorityTemplate",
            tid=default_user_tenants.ids[0],
            authority_template_name=name,
            description=name)
        ```

        ## Import

        DMS Enterprise Authority Template can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dms/enterpriseAuthorityTemplate:EnterpriseAuthorityTemplate example <tid>:<authority_template_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authority_template_name: Permission Template name.
        :param pulumi.Input[str] description: Permission template description information.
        :param pulumi.Input[int] tid: Tenant ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnterpriseAuthorityTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DMS Enterprise Authority Template resource.

        For information about DMS Enterprise Authority Template and how to use it, see [What is Authority Template](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-createauthoritytemplate).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_user_tenants = alicloud.dms.get_user_tenants(status="ACTIVE")
        default_enterprise_authority_template = alicloud.dms.EnterpriseAuthorityTemplate("defaultEnterpriseAuthorityTemplate",
            tid=default_user_tenants.ids[0],
            authority_template_name=name,
            description=name)
        ```

        ## Import

        DMS Enterprise Authority Template can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dms/enterpriseAuthorityTemplate:EnterpriseAuthorityTemplate example <tid>:<authority_template_id>
        ```

        :param str resource_name: The name of the resource.
        :param EnterpriseAuthorityTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnterpriseAuthorityTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authority_template_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 tid: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnterpriseAuthorityTemplateArgs.__new__(EnterpriseAuthorityTemplateArgs)

            if authority_template_name is None and not opts.urn:
                raise TypeError("Missing required property 'authority_template_name'")
            __props__.__dict__["authority_template_name"] = authority_template_name
            __props__.__dict__["description"] = description
            if tid is None and not opts.urn:
                raise TypeError("Missing required property 'tid'")
            __props__.__dict__["tid"] = tid
            __props__.__dict__["authority_template_id"] = None
            __props__.__dict__["create_time"] = None
        super(EnterpriseAuthorityTemplate, __self__).__init__(
            'alicloud:dms/enterpriseAuthorityTemplate:EnterpriseAuthorityTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authority_template_id: Optional[pulumi.Input[int]] = None,
            authority_template_name: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            tid: Optional[pulumi.Input[int]] = None) -> 'EnterpriseAuthorityTemplate':
        """
        Get an existing EnterpriseAuthorityTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] authority_template_id: Permission template ID.
        :param pulumi.Input[str] authority_template_name: Permission Template name.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] description: Permission template description information.
        :param pulumi.Input[int] tid: Tenant ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnterpriseAuthorityTemplateState.__new__(_EnterpriseAuthorityTemplateState)

        __props__.__dict__["authority_template_id"] = authority_template_id
        __props__.__dict__["authority_template_name"] = authority_template_name
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["tid"] = tid
        return EnterpriseAuthorityTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorityTemplateId")
    def authority_template_id(self) -> pulumi.Output[int]:
        """
        Permission template ID.
        """
        return pulumi.get(self, "authority_template_id")

    @property
    @pulumi.getter(name="authorityTemplateName")
    def authority_template_name(self) -> pulumi.Output[str]:
        """
        Permission Template name.
        """
        return pulumi.get(self, "authority_template_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Permission template description information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def tid(self) -> pulumi.Output[int]:
        """
        Tenant ID.
        """
        return pulumi.get(self, "tid")

