# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetEnterpriseProxiesResult',
    'AwaitableGetEnterpriseProxiesResult',
    'get_enterprise_proxies',
    'get_enterprise_proxies_output',
]

@pulumi.output_type
class GetEnterpriseProxiesResult:
    """
    A collection of values returned by getEnterpriseProxies.
    """
    def __init__(__self__, id=None, ids=None, output_file=None, proxies=None, tid=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if proxies and not isinstance(proxies, list):
            raise TypeError("Expected argument 'proxies' to be a list")
        pulumi.set(__self__, "proxies", proxies)
        if tid and not isinstance(tid, str):
            raise TypeError("Expected argument 'tid' to be a str")
        pulumi.set(__self__, "tid", tid)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def proxies(self) -> Sequence['outputs.GetEnterpriseProxiesProxyResult']:
        return pulumi.get(self, "proxies")

    @property
    @pulumi.getter
    def tid(self) -> Optional[str]:
        return pulumi.get(self, "tid")


class AwaitableGetEnterpriseProxiesResult(GetEnterpriseProxiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnterpriseProxiesResult(
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            proxies=self.proxies,
            tid=self.tid)


def get_enterprise_proxies(ids: Optional[Sequence[str]] = None,
                           output_file: Optional[str] = None,
                           tid: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnterpriseProxiesResult:
    """
    This data source provides the Dms Enterprise Proxies of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.188.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.dms.get_enterprise_proxies()
    pulumi.export("dmsEnterpriseProxyId1", ids.proxies[0].id)
    ```


    :param Sequence[str] ids: A list of Proxy IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str tid: The ID of the tenant.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['tid'] = tid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:dms/getEnterpriseProxies:getEnterpriseProxies', __args__, opts=opts, typ=GetEnterpriseProxiesResult).value

    return AwaitableGetEnterpriseProxiesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        proxies=pulumi.get(__ret__, 'proxies'),
        tid=pulumi.get(__ret__, 'tid'))


@_utilities.lift_output_func(get_enterprise_proxies)
def get_enterprise_proxies_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                  output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                  tid: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnterpriseProxiesResult]:
    """
    This data source provides the Dms Enterprise Proxies of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.188.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.dms.get_enterprise_proxies()
    pulumi.export("dmsEnterpriseProxyId1", ids.proxies[0].id)
    ```


    :param Sequence[str] ids: A list of Proxy IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str tid: The ID of the tenant.
    """
    ...
