# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetEnterpriseDatabasesDatabaseResult',
    'GetEnterpriseInstancesInstanceResult',
    'GetEnterpriseLogicDatabasesDatabaseResult',
    'GetEnterpriseProxiesProxyResult',
    'GetEnterpriseProxyAccessesAccessResult',
    'GetEnterpriseUsersUserResult',
    'GetUserTenantsTenantResult',
]

@pulumi.output_type
class GetEnterpriseDatabasesDatabaseResult(dict):
    def __init__(__self__, *,
                 catalog_name: str,
                 database_id: str,
                 db_type: str,
                 dba_id: str,
                 dba_name: str,
                 encoding: str,
                 env_type: str,
                 host: str,
                 id: str,
                 instance_id: str,
                 owner_id_lists: Sequence[str],
                 owner_name_lists: Sequence[str],
                 port: int,
                 schema_name: str,
                 search_name: str,
                 sid: str,
                 state: str):
        """
        :param str catalog_name: The name of the Database Directory.> PG Series databases will display the database name.
        :param str database_id: The ID of the physical library.
        :param str db_type: Database type.
        :param str dba_id: The DBA user ID of the target database.
        :param str dba_name: The DBA nickname of the target Library.
        :param str encoding: Database encoding.
        :param str env_type: The environment type of the database.
        :param str host: The database connection address.
        :param str id: The Database ID, same value as `database_id`.
        :param str instance_id: The instance ID of the target database.
        :param Sequence[str] owner_id_lists: Library Owner User ID list.
        :param Sequence[str] owner_name_lists: Library Owner nickname list.
        :param int port: The connection port of the database.
        :param str schema_name: The name of the database.> PG Series databases will display schema names.
        :param str search_name: Library search name.
        :param str sid: Database SID.> only Oracle Database Display.
        :param str state: Library status, value description:-**NORMAL**: NORMAL-**DISABLE**: Disabled-**OFFLINE**: OFFLINE-**NOT_EXIST**: does not exist
        """
        pulumi.set(__self__, "catalog_name", catalog_name)
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "db_type", db_type)
        pulumi.set(__self__, "dba_id", dba_id)
        pulumi.set(__self__, "dba_name", dba_name)
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "env_type", env_type)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "owner_id_lists", owner_id_lists)
        pulumi.set(__self__, "owner_name_lists", owner_name_lists)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "schema_name", schema_name)
        pulumi.set(__self__, "search_name", search_name)
        pulumi.set(__self__, "sid", sid)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> str:
        """
        The name of the Database Directory.> PG Series databases will display the database name.
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        """
        The ID of the physical library.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="dbType")
    def db_type(self) -> str:
        """
        Database type.
        """
        return pulumi.get(self, "db_type")

    @property
    @pulumi.getter(name="dbaId")
    def dba_id(self) -> str:
        """
        The DBA user ID of the target database.
        """
        return pulumi.get(self, "dba_id")

    @property
    @pulumi.getter(name="dbaName")
    def dba_name(self) -> str:
        """
        The DBA nickname of the target Library.
        """
        return pulumi.get(self, "dba_name")

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        Database encoding.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="envType")
    def env_type(self) -> str:
        """
        The environment type of the database.
        """
        return pulumi.get(self, "env_type")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The database connection address.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Database ID, same value as `database_id`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The instance ID of the target database.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="ownerIdLists")
    def owner_id_lists(self) -> Sequence[str]:
        """
        Library Owner User ID list.
        """
        return pulumi.get(self, "owner_id_lists")

    @property
    @pulumi.getter(name="ownerNameLists")
    def owner_name_lists(self) -> Sequence[str]:
        """
        Library Owner nickname list.
        """
        return pulumi.get(self, "owner_name_lists")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The connection port of the database.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> str:
        """
        The name of the database.> PG Series databases will display schema names.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="searchName")
    def search_name(self) -> str:
        """
        Library search name.
        """
        return pulumi.get(self, "search_name")

    @property
    @pulumi.getter
    def sid(self) -> str:
        """
        Database SID.> only Oracle Database Display.
        """
        return pulumi.get(self, "sid")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Library status, value description:-**NORMAL**: NORMAL-**DISABLE**: Disabled-**OFFLINE**: OFFLINE-**NOT_EXIST**: does not exist
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetEnterpriseInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 data_link_name: str,
                 database_password: str,
                 database_user: str,
                 dba_id: str,
                 dba_nick_name: str,
                 ddl_online: int,
                 ecs_instance_id: str,
                 ecs_region: str,
                 env_type: str,
                 export_timeout: int,
                 host: str,
                 id: str,
                 instance_alias: str,
                 instance_id: str,
                 instance_name: str,
                 instance_source: str,
                 instance_type: str,
                 port: int,
                 query_timeout: int,
                 safe_rule_id: str,
                 sid: str,
                 status: str,
                 use_dsql: int,
                 vpc_id: str):
        """
        :param str data_link_name: The name of the data link for the database instance.
        :param str database_password: The logon password of the database instance.
        :param str database_user: The logon username of the database instance.
        :param str dba_id: The ID of the database administrator (DBA) of the database instance.
        :param str dba_nick_name: The nickname of the DBA.
        :param int ddl_online: Indicates whether the online data description language (DDL) service was enabled for the database instance.
        :param str ecs_instance_id: The ID of the Elastic Compute Service (ECS) instance to which the database instance belongs.
        :param str ecs_region: The region where the database instance resides.
        :param str env_type: The type of the environment to which the database instance belongs.
        :param int export_timeout: The timeout period for exporting the database instance.
        :param str host: The endpoint of the database instance.
        :param str instance_alias: The alias of the database instance.
        :param str instance_id: The ID of the database instance.
        :param str instance_source: The source of the database instance.
        :param str instance_type: The ID of the database instance.
        :param int port: The connection port of the database instance.
        :param int query_timeout: The timeout period for querying the database instance.
        :param str safe_rule_id: The ID of the security rule for the database instance.
        :param str sid: The system ID (SID) of the database instance.
        :param str status: Filter the results by status of the DMS Enterprise Instances. Valid values: `NORMAL`, `UNAVAILABLE`, `UNKNOWN`, `DELETED`, `DISABLE`.
        :param int use_dsql: Indicates whether cross-database query was enabled for the database instance.
        :param str vpc_id: The ID of the Virtual Private Cloud (VPC) to which the database instance belongs.
        """
        pulumi.set(__self__, "data_link_name", data_link_name)
        pulumi.set(__self__, "database_password", database_password)
        pulumi.set(__self__, "database_user", database_user)
        pulumi.set(__self__, "dba_id", dba_id)
        pulumi.set(__self__, "dba_nick_name", dba_nick_name)
        pulumi.set(__self__, "ddl_online", ddl_online)
        pulumi.set(__self__, "ecs_instance_id", ecs_instance_id)
        pulumi.set(__self__, "ecs_region", ecs_region)
        pulumi.set(__self__, "env_type", env_type)
        pulumi.set(__self__, "export_timeout", export_timeout)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_alias", instance_alias)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_source", instance_source)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "query_timeout", query_timeout)
        pulumi.set(__self__, "safe_rule_id", safe_rule_id)
        pulumi.set(__self__, "sid", sid)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "use_dsql", use_dsql)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="dataLinkName")
    def data_link_name(self) -> str:
        """
        The name of the data link for the database instance.
        """
        return pulumi.get(self, "data_link_name")

    @property
    @pulumi.getter(name="databasePassword")
    def database_password(self) -> str:
        """
        The logon password of the database instance.
        """
        return pulumi.get(self, "database_password")

    @property
    @pulumi.getter(name="databaseUser")
    def database_user(self) -> str:
        """
        The logon username of the database instance.
        """
        return pulumi.get(self, "database_user")

    @property
    @pulumi.getter(name="dbaId")
    def dba_id(self) -> str:
        """
        The ID of the database administrator (DBA) of the database instance.
        """
        return pulumi.get(self, "dba_id")

    @property
    @pulumi.getter(name="dbaNickName")
    def dba_nick_name(self) -> str:
        """
        The nickname of the DBA.
        """
        return pulumi.get(self, "dba_nick_name")

    @property
    @pulumi.getter(name="ddlOnline")
    def ddl_online(self) -> int:
        """
        Indicates whether the online data description language (DDL) service was enabled for the database instance.
        """
        return pulumi.get(self, "ddl_online")

    @property
    @pulumi.getter(name="ecsInstanceId")
    def ecs_instance_id(self) -> str:
        """
        The ID of the Elastic Compute Service (ECS) instance to which the database instance belongs.
        """
        return pulumi.get(self, "ecs_instance_id")

    @property
    @pulumi.getter(name="ecsRegion")
    def ecs_region(self) -> str:
        """
        The region where the database instance resides.
        """
        return pulumi.get(self, "ecs_region")

    @property
    @pulumi.getter(name="envType")
    def env_type(self) -> str:
        """
        The type of the environment to which the database instance belongs.
        """
        return pulumi.get(self, "env_type")

    @property
    @pulumi.getter(name="exportTimeout")
    def export_timeout(self) -> int:
        """
        The timeout period for exporting the database instance.
        """
        return pulumi.get(self, "export_timeout")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The endpoint of the database instance.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> str:
        """
        The alias of the database instance.
        """
        return pulumi.get(self, "instance_alias")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the database instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceSource")
    def instance_source(self) -> str:
        """
        The source of the database instance.
        """
        return pulumi.get(self, "instance_source")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ID of the database instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The connection port of the database instance.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="queryTimeout")
    def query_timeout(self) -> int:
        """
        The timeout period for querying the database instance.
        """
        return pulumi.get(self, "query_timeout")

    @property
    @pulumi.getter(name="safeRuleId")
    def safe_rule_id(self) -> str:
        """
        The ID of the security rule for the database instance.
        """
        return pulumi.get(self, "safe_rule_id")

    @property
    @pulumi.getter
    def sid(self) -> str:
        """
        The system ID (SID) of the database instance.
        """
        return pulumi.get(self, "sid")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Filter the results by status of the DMS Enterprise Instances. Valid values: `NORMAL`, `UNAVAILABLE`, `UNKNOWN`, `DELETED`, `DISABLE`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="useDsql")
    def use_dsql(self) -> int:
        """
        Indicates whether cross-database query was enabled for the database instance.
        """
        return pulumi.get(self, "use_dsql")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the Virtual Private Cloud (VPC) to which the database instance belongs.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetEnterpriseLogicDatabasesDatabaseResult(dict):
    def __init__(__self__, *,
                 alias: str,
                 database_ids: Sequence[str],
                 db_type: str,
                 env_type: str,
                 id: str,
                 logic: bool,
                 logic_database_id: str,
                 owner_id_lists: Sequence[str],
                 owner_name_lists: Sequence[str],
                 schema_name: str,
                 search_name: str):
        """
        :param str alias: Logical Library alias.
        :param Sequence[str] database_ids: Sub-Database ID.
        :param str db_type: Database type.
        :param str env_type: Environment type, return value is as follows:-product: production environment-dev: development environment-pre: Advance Environment-test: test environment-sit:SIT environment-uat:UAT environment-pet: Pressure measurement environment-stag:STAG environment
        :param str id: Logic Database ID.
        :param bool logic: Whether it is a logical Library, the return value is true.
        :param str logic_database_id: The ID of the logical Library.
        :param Sequence[str] owner_id_lists: The user ID list of the logical library Owner.
        :param Sequence[str] owner_name_lists: The nickname list of the logical library Owner.
        :param str schema_name: Logical Library name.
        :param str search_name: Logical library search name.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "database_ids", database_ids)
        pulumi.set(__self__, "db_type", db_type)
        pulumi.set(__self__, "env_type", env_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "logic", logic)
        pulumi.set(__self__, "logic_database_id", logic_database_id)
        pulumi.set(__self__, "owner_id_lists", owner_id_lists)
        pulumi.set(__self__, "owner_name_lists", owner_name_lists)
        pulumi.set(__self__, "schema_name", schema_name)
        pulumi.set(__self__, "search_name", search_name)

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        Logical Library alias.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="databaseIds")
    def database_ids(self) -> Sequence[str]:
        """
        Sub-Database ID.
        """
        return pulumi.get(self, "database_ids")

    @property
    @pulumi.getter(name="dbType")
    def db_type(self) -> str:
        """
        Database type.
        """
        return pulumi.get(self, "db_type")

    @property
    @pulumi.getter(name="envType")
    def env_type(self) -> str:
        """
        Environment type, return value is as follows:-product: production environment-dev: development environment-pre: Advance Environment-test: test environment-sit:SIT environment-uat:UAT environment-pet: Pressure measurement environment-stag:STAG environment
        """
        return pulumi.get(self, "env_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Logic Database ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def logic(self) -> bool:
        """
        Whether it is a logical Library, the return value is true.
        """
        return pulumi.get(self, "logic")

    @property
    @pulumi.getter(name="logicDatabaseId")
    def logic_database_id(self) -> str:
        """
        The ID of the logical Library.
        """
        return pulumi.get(self, "logic_database_id")

    @property
    @pulumi.getter(name="ownerIdLists")
    def owner_id_lists(self) -> Sequence[str]:
        """
        The user ID list of the logical library Owner.
        """
        return pulumi.get(self, "owner_id_lists")

    @property
    @pulumi.getter(name="ownerNameLists")
    def owner_name_lists(self) -> Sequence[str]:
        """
        The nickname list of the logical library Owner.
        """
        return pulumi.get(self, "owner_name_lists")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> str:
        """
        Logical Library name.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="searchName")
    def search_name(self) -> str:
        """
        Logical library search name.
        """
        return pulumi.get(self, "search_name")


@pulumi.output_type
class GetEnterpriseProxiesProxyResult(dict):
    def __init__(__self__, *,
                 creator_id: str,
                 creator_name: str,
                 https_port: int,
                 id: str,
                 instance_id: str,
                 private_enable: bool,
                 private_host: str,
                 protocol_port: int,
                 protocol_type: str,
                 proxy_id: str,
                 public_enable: bool,
                 public_host: str):
        """
        :param str creator_id: The ID of the user who enabled the secure access proxy feature.
        :param str creator_name: The nickname of the user who enabled the secure access proxy feature.
        :param int https_port: The port that was used by HTTPS clients to connect to the database instance.
        :param str id: The ID of the Proxy.
        :param str instance_id: The ID of the database instance.
        :param bool private_enable: Indicates whether the internal endpoint is enabled. Default value: true.
        :param str private_host: The internal endpoint.
        :param int protocol_port: Database protocol connection port number.
        :param str protocol_type: Database protocol type, for example, MYSQL.
        :param str proxy_id: The ID of the secure access proxy.
        :param bool public_enable: Indicates whether the public endpoint is enabled.
        :param str public_host: The public endpoint. A public endpoint is returned no matter whether the public endpoint is enabled or disabled. **Note:** When the public network address is in the **true** state, the returned public network address is a valid address with DNS resolution capability. When the public address is in the **false** state, the returned Public address is an invalid address without DNS resolution.
        """
        pulumi.set(__self__, "creator_id", creator_id)
        pulumi.set(__self__, "creator_name", creator_name)
        pulumi.set(__self__, "https_port", https_port)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "private_enable", private_enable)
        pulumi.set(__self__, "private_host", private_host)
        pulumi.set(__self__, "protocol_port", protocol_port)
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "proxy_id", proxy_id)
        pulumi.set(__self__, "public_enable", public_enable)
        pulumi.set(__self__, "public_host", public_host)

    @property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> str:
        """
        The ID of the user who enabled the secure access proxy feature.
        """
        return pulumi.get(self, "creator_id")

    @property
    @pulumi.getter(name="creatorName")
    def creator_name(self) -> str:
        """
        The nickname of the user who enabled the secure access proxy feature.
        """
        return pulumi.get(self, "creator_name")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> int:
        """
        The port that was used by HTTPS clients to connect to the database instance.
        """
        return pulumi.get(self, "https_port")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Proxy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the database instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="privateEnable")
    def private_enable(self) -> bool:
        """
        Indicates whether the internal endpoint is enabled. Default value: true.
        """
        return pulumi.get(self, "private_enable")

    @property
    @pulumi.getter(name="privateHost")
    def private_host(self) -> str:
        """
        The internal endpoint.
        """
        return pulumi.get(self, "private_host")

    @property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> int:
        """
        Database protocol connection port number.
        """
        return pulumi.get(self, "protocol_port")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> str:
        """
        Database protocol type, for example, MYSQL.
        """
        return pulumi.get(self, "protocol_type")

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        The ID of the secure access proxy.
        """
        return pulumi.get(self, "proxy_id")

    @property
    @pulumi.getter(name="publicEnable")
    def public_enable(self) -> bool:
        """
        Indicates whether the public endpoint is enabled.
        """
        return pulumi.get(self, "public_enable")

    @property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> str:
        """
        The public endpoint. A public endpoint is returned no matter whether the public endpoint is enabled or disabled. **Note:** When the public network address is in the **true** state, the returned public network address is a valid address with DNS resolution capability. When the public address is in the **false** state, the returned Public address is an invalid address without DNS resolution.
        """
        return pulumi.get(self, "public_host")


@pulumi.output_type
class GetEnterpriseProxyAccessesAccessResult(dict):
    def __init__(__self__, *,
                 access_id: str,
                 access_secret: str,
                 create_time: str,
                 id: str,
                 indep_account: str,
                 instance_id: str,
                 origin_info: str,
                 proxy_access_id: str,
                 proxy_id: str,
                 user_id: str,
                 user_name: str,
                 user_uid: str):
        """
        :param str access_id: The authorized account of the security agent.
        :param str create_time: The authorization time of the security access agent permission.
        :param str id: Security Protection authorization ID.
        :param str indep_account: Database account.
        :param str instance_id: The ID of the instance.
        :param str origin_info: The source information of the security access agent permission is enabled, and the return value is as follows:**Owner Authorization**: The UID of the owner in parentheses.**Work Order Authorization**: The ticket number in parentheses is the number of the user to apply for permission.
        :param str proxy_access_id: Security Protection authorization ID. After the target user is authorized by the security protection agent, the system automatically generates a security protection authorization ID, which is globally unique.
        :param str proxy_id: The ID of the security agent.
        :param str user_id: The user ID.
        :param str user_name: User nickname.
        :param str user_uid: User UID.
        """
        pulumi.set(__self__, "access_id", access_id)
        pulumi.set(__self__, "access_secret", access_secret)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "indep_account", indep_account)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "origin_info", origin_info)
        pulumi.set(__self__, "proxy_access_id", proxy_access_id)
        pulumi.set(__self__, "proxy_id", proxy_id)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_uid", user_uid)

    @property
    @pulumi.getter(name="accessId")
    def access_id(self) -> str:
        """
        The authorized account of the security agent.
        """
        return pulumi.get(self, "access_id")

    @property
    @pulumi.getter(name="accessSecret")
    def access_secret(self) -> str:
        return pulumi.get(self, "access_secret")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The authorization time of the security access agent permission.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Security Protection authorization ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="indepAccount")
    def indep_account(self) -> str:
        """
        Database account.
        """
        return pulumi.get(self, "indep_account")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="originInfo")
    def origin_info(self) -> str:
        """
        The source information of the security access agent permission is enabled, and the return value is as follows:**Owner Authorization**: The UID of the owner in parentheses.**Work Order Authorization**: The ticket number in parentheses is the number of the user to apply for permission.
        """
        return pulumi.get(self, "origin_info")

    @property
    @pulumi.getter(name="proxyAccessId")
    def proxy_access_id(self) -> str:
        """
        Security Protection authorization ID. After the target user is authorized by the security protection agent, the system automatically generates a security protection authorization ID, which is globally unique.
        """
        return pulumi.get(self, "proxy_access_id")

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        The ID of the security agent.
        """
        return pulumi.get(self, "proxy_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The user ID.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        User nickname.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="userUid")
    def user_uid(self) -> str:
        """
        User UID.
        """
        return pulumi.get(self, "user_uid")


@pulumi.output_type
class GetEnterpriseUsersUserResult(dict):
    def __init__(__self__, *,
                 id: str,
                 mobile: str,
                 nick_name: str,
                 parent_uid: int,
                 role_ids: Sequence[int],
                 role_names: Sequence[str],
                 status: str,
                 uid: str,
                 user_id: str,
                 user_name: str):
        """
        :param str id: The Alibaba Cloud unique ID (UID) of the user.
        :param str mobile: The DingTalk number or mobile number of the user.
        :param str nick_name: The nickname of the user.
        :param int parent_uid: The Alibaba Cloud unique ID (UID) of the parent account if the user corresponds to a Resource Access Management (RAM) user.
        :param Sequence[int] role_ids: The list ids of the role that the user plays.
        :param Sequence[str] role_names: The list names of the role that he user plays.
        :param str status: The status of the user.
        :param str user_id: The ID of the user.
        :param str user_name: The nickname of the user.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mobile", mobile)
        pulumi.set(__self__, "nick_name", nick_name)
        pulumi.set(__self__, "parent_uid", parent_uid)
        pulumi.set(__self__, "role_ids", role_ids)
        pulumi.set(__self__, "role_names", role_names)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "uid", uid)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Alibaba Cloud unique ID (UID) of the user.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mobile(self) -> str:
        """
        The DingTalk number or mobile number of the user.
        """
        return pulumi.get(self, "mobile")

    @property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> str:
        """
        The nickname of the user.
        """
        return pulumi.get(self, "nick_name")

    @property
    @pulumi.getter(name="parentUid")
    def parent_uid(self) -> int:
        """
        The Alibaba Cloud unique ID (UID) of the parent account if the user corresponds to a Resource Access Management (RAM) user.
        """
        return pulumi.get(self, "parent_uid")

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> Sequence[int]:
        """
        The list ids of the role that the user plays.
        """
        return pulumi.get(self, "role_ids")

    @property
    @pulumi.getter(name="roleNames")
    def role_names(self) -> Sequence[str]:
        """
        The list names of the role that he user plays.
        """
        return pulumi.get(self, "role_names")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the user.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def uid(self) -> str:
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        The nickname of the user.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetUserTenantsTenantResult(dict):
    def __init__(__self__, *,
                 id: str,
                 status: str,
                 tenant_name: str,
                 tid: str):
        """
        :param str id: The user tenant id.
        :param str status: The status of the user tenant.
        :param str tenant_name: The name of the user tenant.
        :param str tid: The user tenant id. Same as id.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tenant_name", tenant_name)
        pulumi.set(__self__, "tid", tid)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The user tenant id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the user tenant.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> str:
        """
        The name of the user tenant.
        """
        return pulumi.get(self, "tenant_name")

    @property
    @pulumi.getter
    def tid(self) -> str:
        """
        The user tenant id. Same as id.
        """
        return pulumi.get(self, "tid")


