# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessStrategyArgs', 'AccessStrategy']

@pulumi.input_type
class AccessStrategyArgs:
    def __init__(__self__, *,
                 default_addr_pool_type: pulumi.Input[str],
                 default_addr_pools: pulumi.Input[Sequence[pulumi.Input['AccessStrategyDefaultAddrPoolArgs']]],
                 default_min_available_addr_num: pulumi.Input[int],
                 instance_id: pulumi.Input[str],
                 strategy_mode: pulumi.Input[str],
                 strategy_name: pulumi.Input[str],
                 access_mode: Optional[pulumi.Input[str]] = None,
                 default_latency_optimization: Optional[pulumi.Input[str]] = None,
                 default_lba_strategy: Optional[pulumi.Input[str]] = None,
                 default_max_return_addr_num: Optional[pulumi.Input[int]] = None,
                 failover_addr_pool_type: Optional[pulumi.Input[str]] = None,
                 failover_addr_pools: Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyFailoverAddrPoolArgs']]]] = None,
                 failover_latency_optimization: Optional[pulumi.Input[str]] = None,
                 failover_lba_strategy: Optional[pulumi.Input[str]] = None,
                 failover_max_return_addr_num: Optional[pulumi.Input[int]] = None,
                 failover_min_available_addr_num: Optional[pulumi.Input[int]] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 lines: Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyLineArgs']]]] = None):
        """
        The set of arguments for constructing a AccessStrategy resource.
        :param pulumi.Input[str] default_addr_pool_type: The type of the primary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        :param pulumi.Input[Sequence[pulumi.Input['AccessStrategyDefaultAddrPoolArgs']]] default_addr_pools: List of primary address pool collections. See `default_addr_pools` below for details.
        :param pulumi.Input[int] default_min_available_addr_num: The minimum number of available addresses for the primary address pool set.
        :param pulumi.Input[str] instance_id: The Id of the associated instance.
        :param pulumi.Input[str] strategy_mode: The type of the access policy. Valid values: `GEO` or `LATENCY`. `GEO`: based on geographic location. `LATENCY`: Based on delay.
        :param pulumi.Input[str] strategy_name: The name of the access policy.
        :param pulumi.Input[str] access_mode: The primary/secondary switchover policy for address pool groups. Valid values: `AUTO`, `DEFAULT`, `FAILOVER`.
        :param pulumi.Input[str] default_latency_optimization: Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values: `OPEN`, `CLOSE`.
        :param pulumi.Input[str] default_lba_strategy: The load balancing policy of the primary address pool group. Valid values: `ALL_RR`, `RATIO`. **NOTE:** The `default_lba_strategy` is required under the condition that `strategy_mode` is `GEO`.
        :param pulumi.Input[int] default_max_return_addr_num: The maximum number of addresses returned by the primary address pool set. **NOTE:** The `default_max_return_addr_num` is required under the condition that `strategy_mode` is `LATENCY`.
        :param pulumi.Input[str] failover_addr_pool_type: The type of the secondary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        :param pulumi.Input[Sequence[pulumi.Input['AccessStrategyFailoverAddrPoolArgs']]] failover_addr_pools: List of backup address pool sets. See `failover_addr_pools` below for details.
        :param pulumi.Input[str] failover_latency_optimization: Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values: `OPEN`, `CLOSE`.
        :param pulumi.Input[str] failover_lba_strategy: The load balancing policy of the secondary address pool group. Valid values: `ALL_RR`, `RATIO`.
        :param pulumi.Input[int] failover_max_return_addr_num: The maximum number of returned addresses in the standby address pool.
        :param pulumi.Input[int] failover_min_available_addr_num: The minimum number of available addresses in the standby address pool.
        :param pulumi.Input[str] lang: The lang.
        :param pulumi.Input[Sequence[pulumi.Input['AccessStrategyLineArgs']]] lines: The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
        """
        pulumi.set(__self__, "default_addr_pool_type", default_addr_pool_type)
        pulumi.set(__self__, "default_addr_pools", default_addr_pools)
        pulumi.set(__self__, "default_min_available_addr_num", default_min_available_addr_num)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "strategy_mode", strategy_mode)
        pulumi.set(__self__, "strategy_name", strategy_name)
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if default_latency_optimization is not None:
            pulumi.set(__self__, "default_latency_optimization", default_latency_optimization)
        if default_lba_strategy is not None:
            pulumi.set(__self__, "default_lba_strategy", default_lba_strategy)
        if default_max_return_addr_num is not None:
            pulumi.set(__self__, "default_max_return_addr_num", default_max_return_addr_num)
        if failover_addr_pool_type is not None:
            pulumi.set(__self__, "failover_addr_pool_type", failover_addr_pool_type)
        if failover_addr_pools is not None:
            pulumi.set(__self__, "failover_addr_pools", failover_addr_pools)
        if failover_latency_optimization is not None:
            pulumi.set(__self__, "failover_latency_optimization", failover_latency_optimization)
        if failover_lba_strategy is not None:
            pulumi.set(__self__, "failover_lba_strategy", failover_lba_strategy)
        if failover_max_return_addr_num is not None:
            pulumi.set(__self__, "failover_max_return_addr_num", failover_max_return_addr_num)
        if failover_min_available_addr_num is not None:
            pulumi.set(__self__, "failover_min_available_addr_num", failover_min_available_addr_num)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if lines is not None:
            pulumi.set(__self__, "lines", lines)

    @property
    @pulumi.getter(name="defaultAddrPoolType")
    def default_addr_pool_type(self) -> pulumi.Input[str]:
        """
        The type of the primary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        """
        return pulumi.get(self, "default_addr_pool_type")

    @default_addr_pool_type.setter
    def default_addr_pool_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_addr_pool_type", value)

    @property
    @pulumi.getter(name="defaultAddrPools")
    def default_addr_pools(self) -> pulumi.Input[Sequence[pulumi.Input['AccessStrategyDefaultAddrPoolArgs']]]:
        """
        List of primary address pool collections. See `default_addr_pools` below for details.
        """
        return pulumi.get(self, "default_addr_pools")

    @default_addr_pools.setter
    def default_addr_pools(self, value: pulumi.Input[Sequence[pulumi.Input['AccessStrategyDefaultAddrPoolArgs']]]):
        pulumi.set(self, "default_addr_pools", value)

    @property
    @pulumi.getter(name="defaultMinAvailableAddrNum")
    def default_min_available_addr_num(self) -> pulumi.Input[int]:
        """
        The minimum number of available addresses for the primary address pool set.
        """
        return pulumi.get(self, "default_min_available_addr_num")

    @default_min_available_addr_num.setter
    def default_min_available_addr_num(self, value: pulumi.Input[int]):
        pulumi.set(self, "default_min_available_addr_num", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The Id of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="strategyMode")
    def strategy_mode(self) -> pulumi.Input[str]:
        """
        The type of the access policy. Valid values: `GEO` or `LATENCY`. `GEO`: based on geographic location. `LATENCY`: Based on delay.
        """
        return pulumi.get(self, "strategy_mode")

    @strategy_mode.setter
    def strategy_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "strategy_mode", value)

    @property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> pulumi.Input[str]:
        """
        The name of the access policy.
        """
        return pulumi.get(self, "strategy_name")

    @strategy_name.setter
    def strategy_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "strategy_name", value)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The primary/secondary switchover policy for address pool groups. Valid values: `AUTO`, `DEFAULT`, `FAILOVER`.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="defaultLatencyOptimization")
    def default_latency_optimization(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values: `OPEN`, `CLOSE`.
        """
        return pulumi.get(self, "default_latency_optimization")

    @default_latency_optimization.setter
    def default_latency_optimization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_latency_optimization", value)

    @property
    @pulumi.getter(name="defaultLbaStrategy")
    def default_lba_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancing policy of the primary address pool group. Valid values: `ALL_RR`, `RATIO`. **NOTE:** The `default_lba_strategy` is required under the condition that `strategy_mode` is `GEO`.
        """
        return pulumi.get(self, "default_lba_strategy")

    @default_lba_strategy.setter
    def default_lba_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_lba_strategy", value)

    @property
    @pulumi.getter(name="defaultMaxReturnAddrNum")
    def default_max_return_addr_num(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of addresses returned by the primary address pool set. **NOTE:** The `default_max_return_addr_num` is required under the condition that `strategy_mode` is `LATENCY`.
        """
        return pulumi.get(self, "default_max_return_addr_num")

    @default_max_return_addr_num.setter
    def default_max_return_addr_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_max_return_addr_num", value)

    @property
    @pulumi.getter(name="failoverAddrPoolType")
    def failover_addr_pool_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the secondary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        """
        return pulumi.get(self, "failover_addr_pool_type")

    @failover_addr_pool_type.setter
    def failover_addr_pool_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failover_addr_pool_type", value)

    @property
    @pulumi.getter(name="failoverAddrPools")
    def failover_addr_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyFailoverAddrPoolArgs']]]]:
        """
        List of backup address pool sets. See `failover_addr_pools` below for details.
        """
        return pulumi.get(self, "failover_addr_pools")

    @failover_addr_pools.setter
    def failover_addr_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyFailoverAddrPoolArgs']]]]):
        pulumi.set(self, "failover_addr_pools", value)

    @property
    @pulumi.getter(name="failoverLatencyOptimization")
    def failover_latency_optimization(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values: `OPEN`, `CLOSE`.
        """
        return pulumi.get(self, "failover_latency_optimization")

    @failover_latency_optimization.setter
    def failover_latency_optimization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failover_latency_optimization", value)

    @property
    @pulumi.getter(name="failoverLbaStrategy")
    def failover_lba_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancing policy of the secondary address pool group. Valid values: `ALL_RR`, `RATIO`.
        """
        return pulumi.get(self, "failover_lba_strategy")

    @failover_lba_strategy.setter
    def failover_lba_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failover_lba_strategy", value)

    @property
    @pulumi.getter(name="failoverMaxReturnAddrNum")
    def failover_max_return_addr_num(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of returned addresses in the standby address pool.
        """
        return pulumi.get(self, "failover_max_return_addr_num")

    @failover_max_return_addr_num.setter
    def failover_max_return_addr_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failover_max_return_addr_num", value)

    @property
    @pulumi.getter(name="failoverMinAvailableAddrNum")
    def failover_min_available_addr_num(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of available addresses in the standby address pool.
        """
        return pulumi.get(self, "failover_min_available_addr_num")

    @failover_min_available_addr_num.setter
    def failover_min_available_addr_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failover_min_available_addr_num", value)

    @property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[str]]:
        """
        The lang.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lang", value)

    @property
    @pulumi.getter
    def lines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyLineArgs']]]]:
        """
        The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
        """
        return pulumi.get(self, "lines")

    @lines.setter
    def lines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyLineArgs']]]]):
        pulumi.set(self, "lines", value)


@pulumi.input_type
class _AccessStrategyState:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 default_addr_pool_type: Optional[pulumi.Input[str]] = None,
                 default_addr_pools: Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyDefaultAddrPoolArgs']]]] = None,
                 default_latency_optimization: Optional[pulumi.Input[str]] = None,
                 default_lba_strategy: Optional[pulumi.Input[str]] = None,
                 default_max_return_addr_num: Optional[pulumi.Input[int]] = None,
                 default_min_available_addr_num: Optional[pulumi.Input[int]] = None,
                 failover_addr_pool_type: Optional[pulumi.Input[str]] = None,
                 failover_addr_pools: Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyFailoverAddrPoolArgs']]]] = None,
                 failover_latency_optimization: Optional[pulumi.Input[str]] = None,
                 failover_lba_strategy: Optional[pulumi.Input[str]] = None,
                 failover_max_return_addr_num: Optional[pulumi.Input[int]] = None,
                 failover_min_available_addr_num: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 lines: Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyLineArgs']]]] = None,
                 strategy_mode: Optional[pulumi.Input[str]] = None,
                 strategy_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AccessStrategy resources.
        :param pulumi.Input[str] access_mode: The primary/secondary switchover policy for address pool groups. Valid values: `AUTO`, `DEFAULT`, `FAILOVER`.
        :param pulumi.Input[str] default_addr_pool_type: The type of the primary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        :param pulumi.Input[Sequence[pulumi.Input['AccessStrategyDefaultAddrPoolArgs']]] default_addr_pools: List of primary address pool collections. See `default_addr_pools` below for details.
        :param pulumi.Input[str] default_latency_optimization: Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values: `OPEN`, `CLOSE`.
        :param pulumi.Input[str] default_lba_strategy: The load balancing policy of the primary address pool group. Valid values: `ALL_RR`, `RATIO`. **NOTE:** The `default_lba_strategy` is required under the condition that `strategy_mode` is `GEO`.
        :param pulumi.Input[int] default_max_return_addr_num: The maximum number of addresses returned by the primary address pool set. **NOTE:** The `default_max_return_addr_num` is required under the condition that `strategy_mode` is `LATENCY`.
        :param pulumi.Input[int] default_min_available_addr_num: The minimum number of available addresses for the primary address pool set.
        :param pulumi.Input[str] failover_addr_pool_type: The type of the secondary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        :param pulumi.Input[Sequence[pulumi.Input['AccessStrategyFailoverAddrPoolArgs']]] failover_addr_pools: List of backup address pool sets. See `failover_addr_pools` below for details.
        :param pulumi.Input[str] failover_latency_optimization: Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values: `OPEN`, `CLOSE`.
        :param pulumi.Input[str] failover_lba_strategy: The load balancing policy of the secondary address pool group. Valid values: `ALL_RR`, `RATIO`.
        :param pulumi.Input[int] failover_max_return_addr_num: The maximum number of returned addresses in the standby address pool.
        :param pulumi.Input[int] failover_min_available_addr_num: The minimum number of available addresses in the standby address pool.
        :param pulumi.Input[str] instance_id: The Id of the associated instance.
        :param pulumi.Input[str] lang: The lang.
        :param pulumi.Input[Sequence[pulumi.Input['AccessStrategyLineArgs']]] lines: The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
        :param pulumi.Input[str] strategy_mode: The type of the access policy. Valid values: `GEO` or `LATENCY`. `GEO`: based on geographic location. `LATENCY`: Based on delay.
        :param pulumi.Input[str] strategy_name: The name of the access policy.
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if default_addr_pool_type is not None:
            pulumi.set(__self__, "default_addr_pool_type", default_addr_pool_type)
        if default_addr_pools is not None:
            pulumi.set(__self__, "default_addr_pools", default_addr_pools)
        if default_latency_optimization is not None:
            pulumi.set(__self__, "default_latency_optimization", default_latency_optimization)
        if default_lba_strategy is not None:
            pulumi.set(__self__, "default_lba_strategy", default_lba_strategy)
        if default_max_return_addr_num is not None:
            pulumi.set(__self__, "default_max_return_addr_num", default_max_return_addr_num)
        if default_min_available_addr_num is not None:
            pulumi.set(__self__, "default_min_available_addr_num", default_min_available_addr_num)
        if failover_addr_pool_type is not None:
            pulumi.set(__self__, "failover_addr_pool_type", failover_addr_pool_type)
        if failover_addr_pools is not None:
            pulumi.set(__self__, "failover_addr_pools", failover_addr_pools)
        if failover_latency_optimization is not None:
            pulumi.set(__self__, "failover_latency_optimization", failover_latency_optimization)
        if failover_lba_strategy is not None:
            pulumi.set(__self__, "failover_lba_strategy", failover_lba_strategy)
        if failover_max_return_addr_num is not None:
            pulumi.set(__self__, "failover_max_return_addr_num", failover_max_return_addr_num)
        if failover_min_available_addr_num is not None:
            pulumi.set(__self__, "failover_min_available_addr_num", failover_min_available_addr_num)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if lines is not None:
            pulumi.set(__self__, "lines", lines)
        if strategy_mode is not None:
            pulumi.set(__self__, "strategy_mode", strategy_mode)
        if strategy_name is not None:
            pulumi.set(__self__, "strategy_name", strategy_name)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The primary/secondary switchover policy for address pool groups. Valid values: `AUTO`, `DEFAULT`, `FAILOVER`.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="defaultAddrPoolType")
    def default_addr_pool_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the primary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        """
        return pulumi.get(self, "default_addr_pool_type")

    @default_addr_pool_type.setter
    def default_addr_pool_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_addr_pool_type", value)

    @property
    @pulumi.getter(name="defaultAddrPools")
    def default_addr_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyDefaultAddrPoolArgs']]]]:
        """
        List of primary address pool collections. See `default_addr_pools` below for details.
        """
        return pulumi.get(self, "default_addr_pools")

    @default_addr_pools.setter
    def default_addr_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyDefaultAddrPoolArgs']]]]):
        pulumi.set(self, "default_addr_pools", value)

    @property
    @pulumi.getter(name="defaultLatencyOptimization")
    def default_latency_optimization(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values: `OPEN`, `CLOSE`.
        """
        return pulumi.get(self, "default_latency_optimization")

    @default_latency_optimization.setter
    def default_latency_optimization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_latency_optimization", value)

    @property
    @pulumi.getter(name="defaultLbaStrategy")
    def default_lba_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancing policy of the primary address pool group. Valid values: `ALL_RR`, `RATIO`. **NOTE:** The `default_lba_strategy` is required under the condition that `strategy_mode` is `GEO`.
        """
        return pulumi.get(self, "default_lba_strategy")

    @default_lba_strategy.setter
    def default_lba_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_lba_strategy", value)

    @property
    @pulumi.getter(name="defaultMaxReturnAddrNum")
    def default_max_return_addr_num(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of addresses returned by the primary address pool set. **NOTE:** The `default_max_return_addr_num` is required under the condition that `strategy_mode` is `LATENCY`.
        """
        return pulumi.get(self, "default_max_return_addr_num")

    @default_max_return_addr_num.setter
    def default_max_return_addr_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_max_return_addr_num", value)

    @property
    @pulumi.getter(name="defaultMinAvailableAddrNum")
    def default_min_available_addr_num(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of available addresses for the primary address pool set.
        """
        return pulumi.get(self, "default_min_available_addr_num")

    @default_min_available_addr_num.setter
    def default_min_available_addr_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_min_available_addr_num", value)

    @property
    @pulumi.getter(name="failoverAddrPoolType")
    def failover_addr_pool_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the secondary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        """
        return pulumi.get(self, "failover_addr_pool_type")

    @failover_addr_pool_type.setter
    def failover_addr_pool_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failover_addr_pool_type", value)

    @property
    @pulumi.getter(name="failoverAddrPools")
    def failover_addr_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyFailoverAddrPoolArgs']]]]:
        """
        List of backup address pool sets. See `failover_addr_pools` below for details.
        """
        return pulumi.get(self, "failover_addr_pools")

    @failover_addr_pools.setter
    def failover_addr_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyFailoverAddrPoolArgs']]]]):
        pulumi.set(self, "failover_addr_pools", value)

    @property
    @pulumi.getter(name="failoverLatencyOptimization")
    def failover_latency_optimization(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values: `OPEN`, `CLOSE`.
        """
        return pulumi.get(self, "failover_latency_optimization")

    @failover_latency_optimization.setter
    def failover_latency_optimization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failover_latency_optimization", value)

    @property
    @pulumi.getter(name="failoverLbaStrategy")
    def failover_lba_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancing policy of the secondary address pool group. Valid values: `ALL_RR`, `RATIO`.
        """
        return pulumi.get(self, "failover_lba_strategy")

    @failover_lba_strategy.setter
    def failover_lba_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failover_lba_strategy", value)

    @property
    @pulumi.getter(name="failoverMaxReturnAddrNum")
    def failover_max_return_addr_num(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of returned addresses in the standby address pool.
        """
        return pulumi.get(self, "failover_max_return_addr_num")

    @failover_max_return_addr_num.setter
    def failover_max_return_addr_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failover_max_return_addr_num", value)

    @property
    @pulumi.getter(name="failoverMinAvailableAddrNum")
    def failover_min_available_addr_num(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of available addresses in the standby address pool.
        """
        return pulumi.get(self, "failover_min_available_addr_num")

    @failover_min_available_addr_num.setter
    def failover_min_available_addr_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failover_min_available_addr_num", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[str]]:
        """
        The lang.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lang", value)

    @property
    @pulumi.getter
    def lines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyLineArgs']]]]:
        """
        The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
        """
        return pulumi.get(self, "lines")

    @lines.setter
    def lines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessStrategyLineArgs']]]]):
        pulumi.set(self, "lines", value)

    @property
    @pulumi.getter(name="strategyMode")
    def strategy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the access policy. Valid values: `GEO` or `LATENCY`. `GEO`: based on geographic location. `LATENCY`: Based on delay.
        """
        return pulumi.get(self, "strategy_mode")

    @strategy_mode.setter
    def strategy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "strategy_mode", value)

    @property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the access policy.
        """
        return pulumi.get(self, "strategy_name")

    @strategy_name.setter
    def strategy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "strategy_name", value)


class AccessStrategy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 default_addr_pool_type: Optional[pulumi.Input[str]] = None,
                 default_addr_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyDefaultAddrPoolArgs']]]]] = None,
                 default_latency_optimization: Optional[pulumi.Input[str]] = None,
                 default_lba_strategy: Optional[pulumi.Input[str]] = None,
                 default_max_return_addr_num: Optional[pulumi.Input[int]] = None,
                 default_min_available_addr_num: Optional[pulumi.Input[int]] = None,
                 failover_addr_pool_type: Optional[pulumi.Input[str]] = None,
                 failover_addr_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyFailoverAddrPoolArgs']]]]] = None,
                 failover_latency_optimization: Optional[pulumi.Input[str]] = None,
                 failover_lba_strategy: Optional[pulumi.Input[str]] = None,
                 failover_max_return_addr_num: Optional[pulumi.Input[int]] = None,
                 failover_min_available_addr_num: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 lines: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyLineArgs']]]]] = None,
                 strategy_mode: Optional[pulumi.Input[str]] = None,
                 strategy_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a DNS Access Strategy resource.

        For information about DNS Access Strategy and how to use it, see [What is Access Strategy](https://www.alibabacloud.com/help/doc-detail/189620.html).

        > **NOTE:** Available since v1.152.0.

        ## Import

        DNS Access Strategy can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dns/accessStrategy:AccessStrategy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_mode: The primary/secondary switchover policy for address pool groups. Valid values: `AUTO`, `DEFAULT`, `FAILOVER`.
        :param pulumi.Input[str] default_addr_pool_type: The type of the primary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyDefaultAddrPoolArgs']]]] default_addr_pools: List of primary address pool collections. See `default_addr_pools` below for details.
        :param pulumi.Input[str] default_latency_optimization: Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values: `OPEN`, `CLOSE`.
        :param pulumi.Input[str] default_lba_strategy: The load balancing policy of the primary address pool group. Valid values: `ALL_RR`, `RATIO`. **NOTE:** The `default_lba_strategy` is required under the condition that `strategy_mode` is `GEO`.
        :param pulumi.Input[int] default_max_return_addr_num: The maximum number of addresses returned by the primary address pool set. **NOTE:** The `default_max_return_addr_num` is required under the condition that `strategy_mode` is `LATENCY`.
        :param pulumi.Input[int] default_min_available_addr_num: The minimum number of available addresses for the primary address pool set.
        :param pulumi.Input[str] failover_addr_pool_type: The type of the secondary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyFailoverAddrPoolArgs']]]] failover_addr_pools: List of backup address pool sets. See `failover_addr_pools` below for details.
        :param pulumi.Input[str] failover_latency_optimization: Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values: `OPEN`, `CLOSE`.
        :param pulumi.Input[str] failover_lba_strategy: The load balancing policy of the secondary address pool group. Valid values: `ALL_RR`, `RATIO`.
        :param pulumi.Input[int] failover_max_return_addr_num: The maximum number of returned addresses in the standby address pool.
        :param pulumi.Input[int] failover_min_available_addr_num: The minimum number of available addresses in the standby address pool.
        :param pulumi.Input[str] instance_id: The Id of the associated instance.
        :param pulumi.Input[str] lang: The lang.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyLineArgs']]]] lines: The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
        :param pulumi.Input[str] strategy_mode: The type of the access policy. Valid values: `GEO` or `LATENCY`. `GEO`: based on geographic location. `LATENCY`: Based on delay.
        :param pulumi.Input[str] strategy_name: The name of the access policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessStrategyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DNS Access Strategy resource.

        For information about DNS Access Strategy and how to use it, see [What is Access Strategy](https://www.alibabacloud.com/help/doc-detail/189620.html).

        > **NOTE:** Available since v1.152.0.

        ## Import

        DNS Access Strategy can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dns/accessStrategy:AccessStrategy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AccessStrategyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessStrategyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 default_addr_pool_type: Optional[pulumi.Input[str]] = None,
                 default_addr_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyDefaultAddrPoolArgs']]]]] = None,
                 default_latency_optimization: Optional[pulumi.Input[str]] = None,
                 default_lba_strategy: Optional[pulumi.Input[str]] = None,
                 default_max_return_addr_num: Optional[pulumi.Input[int]] = None,
                 default_min_available_addr_num: Optional[pulumi.Input[int]] = None,
                 failover_addr_pool_type: Optional[pulumi.Input[str]] = None,
                 failover_addr_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyFailoverAddrPoolArgs']]]]] = None,
                 failover_latency_optimization: Optional[pulumi.Input[str]] = None,
                 failover_lba_strategy: Optional[pulumi.Input[str]] = None,
                 failover_max_return_addr_num: Optional[pulumi.Input[int]] = None,
                 failover_min_available_addr_num: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 lines: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyLineArgs']]]]] = None,
                 strategy_mode: Optional[pulumi.Input[str]] = None,
                 strategy_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessStrategyArgs.__new__(AccessStrategyArgs)

            __props__.__dict__["access_mode"] = access_mode
            if default_addr_pool_type is None and not opts.urn:
                raise TypeError("Missing required property 'default_addr_pool_type'")
            __props__.__dict__["default_addr_pool_type"] = default_addr_pool_type
            if default_addr_pools is None and not opts.urn:
                raise TypeError("Missing required property 'default_addr_pools'")
            __props__.__dict__["default_addr_pools"] = default_addr_pools
            __props__.__dict__["default_latency_optimization"] = default_latency_optimization
            __props__.__dict__["default_lba_strategy"] = default_lba_strategy
            __props__.__dict__["default_max_return_addr_num"] = default_max_return_addr_num
            if default_min_available_addr_num is None and not opts.urn:
                raise TypeError("Missing required property 'default_min_available_addr_num'")
            __props__.__dict__["default_min_available_addr_num"] = default_min_available_addr_num
            __props__.__dict__["failover_addr_pool_type"] = failover_addr_pool_type
            __props__.__dict__["failover_addr_pools"] = failover_addr_pools
            __props__.__dict__["failover_latency_optimization"] = failover_latency_optimization
            __props__.__dict__["failover_lba_strategy"] = failover_lba_strategy
            __props__.__dict__["failover_max_return_addr_num"] = failover_max_return_addr_num
            __props__.__dict__["failover_min_available_addr_num"] = failover_min_available_addr_num
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["lang"] = lang
            __props__.__dict__["lines"] = lines
            if strategy_mode is None and not opts.urn:
                raise TypeError("Missing required property 'strategy_mode'")
            __props__.__dict__["strategy_mode"] = strategy_mode
            if strategy_name is None and not opts.urn:
                raise TypeError("Missing required property 'strategy_name'")
            __props__.__dict__["strategy_name"] = strategy_name
        super(AccessStrategy, __self__).__init__(
            'alicloud:dns/accessStrategy:AccessStrategy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_mode: Optional[pulumi.Input[str]] = None,
            default_addr_pool_type: Optional[pulumi.Input[str]] = None,
            default_addr_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyDefaultAddrPoolArgs']]]]] = None,
            default_latency_optimization: Optional[pulumi.Input[str]] = None,
            default_lba_strategy: Optional[pulumi.Input[str]] = None,
            default_max_return_addr_num: Optional[pulumi.Input[int]] = None,
            default_min_available_addr_num: Optional[pulumi.Input[int]] = None,
            failover_addr_pool_type: Optional[pulumi.Input[str]] = None,
            failover_addr_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyFailoverAddrPoolArgs']]]]] = None,
            failover_latency_optimization: Optional[pulumi.Input[str]] = None,
            failover_lba_strategy: Optional[pulumi.Input[str]] = None,
            failover_max_return_addr_num: Optional[pulumi.Input[int]] = None,
            failover_min_available_addr_num: Optional[pulumi.Input[int]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            lang: Optional[pulumi.Input[str]] = None,
            lines: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyLineArgs']]]]] = None,
            strategy_mode: Optional[pulumi.Input[str]] = None,
            strategy_name: Optional[pulumi.Input[str]] = None) -> 'AccessStrategy':
        """
        Get an existing AccessStrategy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_mode: The primary/secondary switchover policy for address pool groups. Valid values: `AUTO`, `DEFAULT`, `FAILOVER`.
        :param pulumi.Input[str] default_addr_pool_type: The type of the primary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyDefaultAddrPoolArgs']]]] default_addr_pools: List of primary address pool collections. See `default_addr_pools` below for details.
        :param pulumi.Input[str] default_latency_optimization: Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values: `OPEN`, `CLOSE`.
        :param pulumi.Input[str] default_lba_strategy: The load balancing policy of the primary address pool group. Valid values: `ALL_RR`, `RATIO`. **NOTE:** The `default_lba_strategy` is required under the condition that `strategy_mode` is `GEO`.
        :param pulumi.Input[int] default_max_return_addr_num: The maximum number of addresses returned by the primary address pool set. **NOTE:** The `default_max_return_addr_num` is required under the condition that `strategy_mode` is `LATENCY`.
        :param pulumi.Input[int] default_min_available_addr_num: The minimum number of available addresses for the primary address pool set.
        :param pulumi.Input[str] failover_addr_pool_type: The type of the secondary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyFailoverAddrPoolArgs']]]] failover_addr_pools: List of backup address pool sets. See `failover_addr_pools` below for details.
        :param pulumi.Input[str] failover_latency_optimization: Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values: `OPEN`, `CLOSE`.
        :param pulumi.Input[str] failover_lba_strategy: The load balancing policy of the secondary address pool group. Valid values: `ALL_RR`, `RATIO`.
        :param pulumi.Input[int] failover_max_return_addr_num: The maximum number of returned addresses in the standby address pool.
        :param pulumi.Input[int] failover_min_available_addr_num: The minimum number of available addresses in the standby address pool.
        :param pulumi.Input[str] instance_id: The Id of the associated instance.
        :param pulumi.Input[str] lang: The lang.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessStrategyLineArgs']]]] lines: The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
        :param pulumi.Input[str] strategy_mode: The type of the access policy. Valid values: `GEO` or `LATENCY`. `GEO`: based on geographic location. `LATENCY`: Based on delay.
        :param pulumi.Input[str] strategy_name: The name of the access policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessStrategyState.__new__(_AccessStrategyState)

        __props__.__dict__["access_mode"] = access_mode
        __props__.__dict__["default_addr_pool_type"] = default_addr_pool_type
        __props__.__dict__["default_addr_pools"] = default_addr_pools
        __props__.__dict__["default_latency_optimization"] = default_latency_optimization
        __props__.__dict__["default_lba_strategy"] = default_lba_strategy
        __props__.__dict__["default_max_return_addr_num"] = default_max_return_addr_num
        __props__.__dict__["default_min_available_addr_num"] = default_min_available_addr_num
        __props__.__dict__["failover_addr_pool_type"] = failover_addr_pool_type
        __props__.__dict__["failover_addr_pools"] = failover_addr_pools
        __props__.__dict__["failover_latency_optimization"] = failover_latency_optimization
        __props__.__dict__["failover_lba_strategy"] = failover_lba_strategy
        __props__.__dict__["failover_max_return_addr_num"] = failover_max_return_addr_num
        __props__.__dict__["failover_min_available_addr_num"] = failover_min_available_addr_num
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["lang"] = lang
        __props__.__dict__["lines"] = lines
        __props__.__dict__["strategy_mode"] = strategy_mode
        __props__.__dict__["strategy_name"] = strategy_name
        return AccessStrategy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Output[str]:
        """
        The primary/secondary switchover policy for address pool groups. Valid values: `AUTO`, `DEFAULT`, `FAILOVER`.
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="defaultAddrPoolType")
    def default_addr_pool_type(self) -> pulumi.Output[str]:
        """
        The type of the primary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        """
        return pulumi.get(self, "default_addr_pool_type")

    @property
    @pulumi.getter(name="defaultAddrPools")
    def default_addr_pools(self) -> pulumi.Output[Sequence['outputs.AccessStrategyDefaultAddrPool']]:
        """
        List of primary address pool collections. See `default_addr_pools` below for details.
        """
        return pulumi.get(self, "default_addr_pools")

    @property
    @pulumi.getter(name="defaultLatencyOptimization")
    def default_latency_optimization(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values: `OPEN`, `CLOSE`.
        """
        return pulumi.get(self, "default_latency_optimization")

    @property
    @pulumi.getter(name="defaultLbaStrategy")
    def default_lba_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        The load balancing policy of the primary address pool group. Valid values: `ALL_RR`, `RATIO`. **NOTE:** The `default_lba_strategy` is required under the condition that `strategy_mode` is `GEO`.
        """
        return pulumi.get(self, "default_lba_strategy")

    @property
    @pulumi.getter(name="defaultMaxReturnAddrNum")
    def default_max_return_addr_num(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of addresses returned by the primary address pool set. **NOTE:** The `default_max_return_addr_num` is required under the condition that `strategy_mode` is `LATENCY`.
        """
        return pulumi.get(self, "default_max_return_addr_num")

    @property
    @pulumi.getter(name="defaultMinAvailableAddrNum")
    def default_min_available_addr_num(self) -> pulumi.Output[int]:
        """
        The minimum number of available addresses for the primary address pool set.
        """
        return pulumi.get(self, "default_min_available_addr_num")

    @property
    @pulumi.getter(name="failoverAddrPoolType")
    def failover_addr_pool_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the secondary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
        """
        return pulumi.get(self, "failover_addr_pool_type")

    @property
    @pulumi.getter(name="failoverAddrPools")
    def failover_addr_pools(self) -> pulumi.Output[Optional[Sequence['outputs.AccessStrategyFailoverAddrPool']]]:
        """
        List of backup address pool sets. See `failover_addr_pools` below for details.
        """
        return pulumi.get(self, "failover_addr_pools")

    @property
    @pulumi.getter(name="failoverLatencyOptimization")
    def failover_latency_optimization(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values: `OPEN`, `CLOSE`.
        """
        return pulumi.get(self, "failover_latency_optimization")

    @property
    @pulumi.getter(name="failoverLbaStrategy")
    def failover_lba_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        The load balancing policy of the secondary address pool group. Valid values: `ALL_RR`, `RATIO`.
        """
        return pulumi.get(self, "failover_lba_strategy")

    @property
    @pulumi.getter(name="failoverMaxReturnAddrNum")
    def failover_max_return_addr_num(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of returned addresses in the standby address pool.
        """
        return pulumi.get(self, "failover_max_return_addr_num")

    @property
    @pulumi.getter(name="failoverMinAvailableAddrNum")
    def failover_min_available_addr_num(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum number of available addresses in the standby address pool.
        """
        return pulumi.get(self, "failover_min_available_addr_num")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The Id of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[str]]:
        """
        The lang.
        """
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter
    def lines(self) -> pulumi.Output[Optional[Sequence['outputs.AccessStrategyLine']]]:
        """
        The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
        """
        return pulumi.get(self, "lines")

    @property
    @pulumi.getter(name="strategyMode")
    def strategy_mode(self) -> pulumi.Output[str]:
        """
        The type of the access policy. Valid values: `GEO` or `LATENCY`. `GEO`: based on geographic location. `LATENCY`: Based on delay.
        """
        return pulumi.get(self, "strategy_mode")

    @property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> pulumi.Output[str]:
        """
        The name of the access policy.
        """
        return pulumi.get(self, "strategy_name")

