# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DdosCooInstanceArgs', 'DdosCooInstance']

@pulumi.input_type
class DdosCooInstanceArgs:
    def __init__(__self__, *,
                 domain_count: pulumi.Input[str],
                 port_count: pulumi.Input[str],
                 address_type: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 bandwidth_mode: Optional[pulumi.Input[str]] = None,
                 base_bandwidth: Optional[pulumi.Input[str]] = None,
                 edition_sale: Optional[pulumi.Input[str]] = None,
                 function_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 normal_bandwidth: Optional[pulumi.Input[str]] = None,
                 normal_qps: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 product_plan: Optional[pulumi.Input[str]] = None,
                 product_type: Optional[pulumi.Input[str]] = None,
                 service_bandwidth: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DdosCooInstance resource.
        :param pulumi.Input[str] domain_count: Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[str] port_count: Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[str] address_type: The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`.
        :param pulumi.Input[str] bandwidth: Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: 30, 60, 100, 300, 400, 500, 600. The unit is Gbps. Only support upgrade.
        :param pulumi.Input[str] bandwidth_mode: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[str] base_bandwidth: Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade.
        :param pulumi.Input[str] edition_sale: The mitigation plan of the instance. Default value: `coop`. Valid values:
        :param pulumi.Input[str] function_version: The function plan of the instance. Valid values:
        :param pulumi.Input[str] name: Name of the instance. This name can have a string of 1 to 63 characters.
        :param pulumi.Input[str] normal_bandwidth: The clean bandwidth provided by the instance.
        :param pulumi.Input[str] normal_qps: The clean QPS provided by the instance.
        :param pulumi.Input[int] period: The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        :param pulumi.Input[str] product_plan: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[str] product_type: The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        :param pulumi.Input[str] service_bandwidth: Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade.
        """
        pulumi.set(__self__, "domain_count", domain_count)
        pulumi.set(__self__, "port_count", port_count)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_mode is not None:
            pulumi.set(__self__, "bandwidth_mode", bandwidth_mode)
        if base_bandwidth is not None:
            pulumi.set(__self__, "base_bandwidth", base_bandwidth)
        if edition_sale is not None:
            pulumi.set(__self__, "edition_sale", edition_sale)
        if function_version is not None:
            pulumi.set(__self__, "function_version", function_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if normal_bandwidth is not None:
            pulumi.set(__self__, "normal_bandwidth", normal_bandwidth)
        if normal_qps is not None:
            pulumi.set(__self__, "normal_qps", normal_qps)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if product_plan is not None:
            pulumi.set(__self__, "product_plan", product_plan)
        if product_type is not None:
            pulumi.set(__self__, "product_type", product_type)
        if service_bandwidth is not None:
            pulumi.set(__self__, "service_bandwidth", service_bandwidth)

    @property
    @pulumi.getter(name="domainCount")
    def domain_count(self) -> pulumi.Input[str]:
        """
        Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "domain_count")

    @domain_count.setter
    def domain_count(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_count", value)

    @property
    @pulumi.getter(name="portCount")
    def port_count(self) -> pulumi.Input[str]:
        """
        Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "port_count")

    @port_count.setter
    def port_count(self, value: pulumi.Input[str]):
        pulumi.set(self, "port_count", value)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_type", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: 30, 60, 100, 300, 400, 500, 600. The unit is Gbps. Only support upgrade.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="bandwidthMode")
    def bandwidth_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "bandwidth_mode")

    @bandwidth_mode.setter
    def bandwidth_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_mode", value)

    @property
    @pulumi.getter(name="baseBandwidth")
    def base_bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade.
        """
        return pulumi.get(self, "base_bandwidth")

    @base_bandwidth.setter
    def base_bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_bandwidth", value)

    @property
    @pulumi.getter(name="editionSale")
    def edition_sale(self) -> Optional[pulumi.Input[str]]:
        """
        The mitigation plan of the instance. Default value: `coop`. Valid values:
        """
        return pulumi.get(self, "edition_sale")

    @edition_sale.setter
    def edition_sale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edition_sale", value)

    @property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> Optional[pulumi.Input[str]]:
        """
        The function plan of the instance. Valid values:
        """
        return pulumi.get(self, "function_version")

    @function_version.setter
    def function_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the instance. This name can have a string of 1 to 63 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="normalBandwidth")
    def normal_bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The clean bandwidth provided by the instance.
        """
        return pulumi.get(self, "normal_bandwidth")

    @normal_bandwidth.setter
    def normal_bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "normal_bandwidth", value)

    @property
    @pulumi.getter(name="normalQps")
    def normal_qps(self) -> Optional[pulumi.Input[str]]:
        """
        The clean QPS provided by the instance.
        """
        return pulumi.get(self, "normal_qps")

    @normal_qps.setter
    def normal_qps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "normal_qps", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="productPlan")
    def product_plan(self) -> Optional[pulumi.Input[str]]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "product_plan")

    @product_plan.setter
    def product_plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_plan", value)

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[pulumi.Input[str]]:
        """
        The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        """
        return pulumi.get(self, "product_type")

    @product_type.setter
    def product_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_type", value)

    @property
    @pulumi.getter(name="serviceBandwidth")
    def service_bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade.
        """
        return pulumi.get(self, "service_bandwidth")

    @service_bandwidth.setter
    def service_bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_bandwidth", value)


@pulumi.input_type
class _DdosCooInstanceState:
    def __init__(__self__, *,
                 address_type: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 bandwidth_mode: Optional[pulumi.Input[str]] = None,
                 base_bandwidth: Optional[pulumi.Input[str]] = None,
                 domain_count: Optional[pulumi.Input[str]] = None,
                 edition_sale: Optional[pulumi.Input[str]] = None,
                 function_version: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 normal_bandwidth: Optional[pulumi.Input[str]] = None,
                 normal_qps: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 port_count: Optional[pulumi.Input[str]] = None,
                 product_plan: Optional[pulumi.Input[str]] = None,
                 product_type: Optional[pulumi.Input[str]] = None,
                 service_bandwidth: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DdosCooInstance resources.
        :param pulumi.Input[str] address_type: The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`.
        :param pulumi.Input[str] bandwidth: Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: 30, 60, 100, 300, 400, 500, 600. The unit is Gbps. Only support upgrade.
        :param pulumi.Input[str] bandwidth_mode: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[str] base_bandwidth: Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade.
        :param pulumi.Input[str] domain_count: Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[str] edition_sale: The mitigation plan of the instance. Default value: `coop`. Valid values:
        :param pulumi.Input[str] function_version: The function plan of the instance. Valid values:
        :param pulumi.Input[str] ip: (Available since v1.212.0) The IP address of the instance.
        :param pulumi.Input[str] name: Name of the instance. This name can have a string of 1 to 63 characters.
        :param pulumi.Input[str] normal_bandwidth: The clean bandwidth provided by the instance.
        :param pulumi.Input[str] normal_qps: The clean QPS provided by the instance.
        :param pulumi.Input[int] period: The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        :param pulumi.Input[str] port_count: Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[str] product_plan: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[str] product_type: The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        :param pulumi.Input[str] service_bandwidth: Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade.
        """
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_mode is not None:
            pulumi.set(__self__, "bandwidth_mode", bandwidth_mode)
        if base_bandwidth is not None:
            pulumi.set(__self__, "base_bandwidth", base_bandwidth)
        if domain_count is not None:
            pulumi.set(__self__, "domain_count", domain_count)
        if edition_sale is not None:
            pulumi.set(__self__, "edition_sale", edition_sale)
        if function_version is not None:
            pulumi.set(__self__, "function_version", function_version)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if normal_bandwidth is not None:
            pulumi.set(__self__, "normal_bandwidth", normal_bandwidth)
        if normal_qps is not None:
            pulumi.set(__self__, "normal_qps", normal_qps)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port_count is not None:
            pulumi.set(__self__, "port_count", port_count)
        if product_plan is not None:
            pulumi.set(__self__, "product_plan", product_plan)
        if product_type is not None:
            pulumi.set(__self__, "product_type", product_type)
        if service_bandwidth is not None:
            pulumi.set(__self__, "service_bandwidth", service_bandwidth)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_type", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: 30, 60, 100, 300, 400, 500, 600. The unit is Gbps. Only support upgrade.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="bandwidthMode")
    def bandwidth_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "bandwidth_mode")

    @bandwidth_mode.setter
    def bandwidth_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_mode", value)

    @property
    @pulumi.getter(name="baseBandwidth")
    def base_bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade.
        """
        return pulumi.get(self, "base_bandwidth")

    @base_bandwidth.setter
    def base_bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_bandwidth", value)

    @property
    @pulumi.getter(name="domainCount")
    def domain_count(self) -> Optional[pulumi.Input[str]]:
        """
        Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "domain_count")

    @domain_count.setter
    def domain_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_count", value)

    @property
    @pulumi.getter(name="editionSale")
    def edition_sale(self) -> Optional[pulumi.Input[str]]:
        """
        The mitigation plan of the instance. Default value: `coop`. Valid values:
        """
        return pulumi.get(self, "edition_sale")

    @edition_sale.setter
    def edition_sale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edition_sale", value)

    @property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> Optional[pulumi.Input[str]]:
        """
        The function plan of the instance. Valid values:
        """
        return pulumi.get(self, "function_version")

    @function_version.setter
    def function_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_version", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Available since v1.212.0) The IP address of the instance.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the instance. This name can have a string of 1 to 63 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="normalBandwidth")
    def normal_bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The clean bandwidth provided by the instance.
        """
        return pulumi.get(self, "normal_bandwidth")

    @normal_bandwidth.setter
    def normal_bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "normal_bandwidth", value)

    @property
    @pulumi.getter(name="normalQps")
    def normal_qps(self) -> Optional[pulumi.Input[str]]:
        """
        The clean QPS provided by the instance.
        """
        return pulumi.get(self, "normal_qps")

    @normal_qps.setter
    def normal_qps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "normal_qps", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="portCount")
    def port_count(self) -> Optional[pulumi.Input[str]]:
        """
        Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "port_count")

    @port_count.setter
    def port_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_count", value)

    @property
    @pulumi.getter(name="productPlan")
    def product_plan(self) -> Optional[pulumi.Input[str]]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "product_plan")

    @product_plan.setter
    def product_plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_plan", value)

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[pulumi.Input[str]]:
        """
        The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        """
        return pulumi.get(self, "product_type")

    @product_type.setter
    def product_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_type", value)

    @property
    @pulumi.getter(name="serviceBandwidth")
    def service_bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade.
        """
        return pulumi.get(self, "service_bandwidth")

    @service_bandwidth.setter
    def service_bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_bandwidth", value)


warnings.warn("""alicloud.dns.DdosCooInstance has been deprecated in favor of alicloud.ddos.DdosCooInstance""", DeprecationWarning)


class DdosCooInstance(pulumi.CustomResource):
    warnings.warn("""alicloud.dns.DdosCooInstance has been deprecated in favor of alicloud.ddos.DdosCooInstance""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_type: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 bandwidth_mode: Optional[pulumi.Input[str]] = None,
                 base_bandwidth: Optional[pulumi.Input[str]] = None,
                 domain_count: Optional[pulumi.Input[str]] = None,
                 edition_sale: Optional[pulumi.Input[str]] = None,
                 function_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 normal_bandwidth: Optional[pulumi.Input[str]] = None,
                 normal_qps: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 port_count: Optional[pulumi.Input[str]] = None,
                 product_plan: Optional[pulumi.Input[str]] = None,
                 product_type: Optional[pulumi.Input[str]] = None,
                 service_bandwidth: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a BGP-line Anti-DDoS Pro(DdosCoo) Instance resource.

        For information about BGP-line Anti-DDoS Pro(DdosCoo) Instance and how to use it, see [What is Anti-DDoS Pro Instance](https://www.alibabacloud.com/help/en/ddos-protection/latest/create-an-anti-ddos-pro-or-anti-ddos-premium-instance-by-calling-an-api-operation).

        > **NOTE:** Available since v1.37.0.

        > **NOTE:** The endpoint of bssopenapi used only support "business.aliyuncs.com" at present.

        > **NOTE:** From version 1.214.0, if `product_type` is set to `ddoscoo` or `ddoscoo_intl`, the provider `region` should be set to `cn-hangzhou`, and if `product_type` is set to `ddosDip`, the provider `region` should be set to `ap-southeast-1`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.ddos.DdosCooInstance("default",
            base_bandwidth="30",
            bandwidth="30",
            service_bandwidth="100",
            port_count="50",
            domain_count="50",
            product_type="ddoscoo",
            period=1)
        ```

        ## Import

        DdosCoo instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dns/ddosCooInstance:DdosCooInstance example ddoscoo-cn-123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_type: The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`.
        :param pulumi.Input[str] bandwidth: Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: 30, 60, 100, 300, 400, 500, 600. The unit is Gbps. Only support upgrade.
        :param pulumi.Input[str] bandwidth_mode: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[str] base_bandwidth: Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade.
        :param pulumi.Input[str] domain_count: Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[str] edition_sale: The mitigation plan of the instance. Default value: `coop`. Valid values:
        :param pulumi.Input[str] function_version: The function plan of the instance. Valid values:
        :param pulumi.Input[str] name: Name of the instance. This name can have a string of 1 to 63 characters.
        :param pulumi.Input[str] normal_bandwidth: The clean bandwidth provided by the instance.
        :param pulumi.Input[str] normal_qps: The clean QPS provided by the instance.
        :param pulumi.Input[int] period: The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        :param pulumi.Input[str] port_count: Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[str] product_plan: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[str] product_type: The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        :param pulumi.Input[str] service_bandwidth: Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DdosCooInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a BGP-line Anti-DDoS Pro(DdosCoo) Instance resource.

        For information about BGP-line Anti-DDoS Pro(DdosCoo) Instance and how to use it, see [What is Anti-DDoS Pro Instance](https://www.alibabacloud.com/help/en/ddos-protection/latest/create-an-anti-ddos-pro-or-anti-ddos-premium-instance-by-calling-an-api-operation).

        > **NOTE:** Available since v1.37.0.

        > **NOTE:** The endpoint of bssopenapi used only support "business.aliyuncs.com" at present.

        > **NOTE:** From version 1.214.0, if `product_type` is set to `ddoscoo` or `ddoscoo_intl`, the provider `region` should be set to `cn-hangzhou`, and if `product_type` is set to `ddosDip`, the provider `region` should be set to `ap-southeast-1`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.ddos.DdosCooInstance("default",
            base_bandwidth="30",
            bandwidth="30",
            service_bandwidth="100",
            port_count="50",
            domain_count="50",
            product_type="ddoscoo",
            period=1)
        ```

        ## Import

        DdosCoo instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dns/ddosCooInstance:DdosCooInstance example ddoscoo-cn-123456
        ```

        :param str resource_name: The name of the resource.
        :param DdosCooInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DdosCooInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_type: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 bandwidth_mode: Optional[pulumi.Input[str]] = None,
                 base_bandwidth: Optional[pulumi.Input[str]] = None,
                 domain_count: Optional[pulumi.Input[str]] = None,
                 edition_sale: Optional[pulumi.Input[str]] = None,
                 function_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 normal_bandwidth: Optional[pulumi.Input[str]] = None,
                 normal_qps: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 port_count: Optional[pulumi.Input[str]] = None,
                 product_plan: Optional[pulumi.Input[str]] = None,
                 product_type: Optional[pulumi.Input[str]] = None,
                 service_bandwidth: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""DdosCooInstance is deprecated: alicloud.dns.DdosCooInstance has been deprecated in favor of alicloud.ddos.DdosCooInstance""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DdosCooInstanceArgs.__new__(DdosCooInstanceArgs)

            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["bandwidth_mode"] = bandwidth_mode
            __props__.__dict__["base_bandwidth"] = base_bandwidth
            if domain_count is None and not opts.urn:
                raise TypeError("Missing required property 'domain_count'")
            __props__.__dict__["domain_count"] = domain_count
            __props__.__dict__["edition_sale"] = edition_sale
            __props__.__dict__["function_version"] = function_version
            __props__.__dict__["name"] = name
            __props__.__dict__["normal_bandwidth"] = normal_bandwidth
            __props__.__dict__["normal_qps"] = normal_qps
            __props__.__dict__["period"] = period
            if port_count is None and not opts.urn:
                raise TypeError("Missing required property 'port_count'")
            __props__.__dict__["port_count"] = port_count
            __props__.__dict__["product_plan"] = product_plan
            __props__.__dict__["product_type"] = product_type
            __props__.__dict__["service_bandwidth"] = service_bandwidth
            __props__.__dict__["ip"] = None
        super(DdosCooInstance, __self__).__init__(
            'alicloud:dns/ddosCooInstance:DdosCooInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_type: Optional[pulumi.Input[str]] = None,
            bandwidth: Optional[pulumi.Input[str]] = None,
            bandwidth_mode: Optional[pulumi.Input[str]] = None,
            base_bandwidth: Optional[pulumi.Input[str]] = None,
            domain_count: Optional[pulumi.Input[str]] = None,
            edition_sale: Optional[pulumi.Input[str]] = None,
            function_version: Optional[pulumi.Input[str]] = None,
            ip: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            normal_bandwidth: Optional[pulumi.Input[str]] = None,
            normal_qps: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            port_count: Optional[pulumi.Input[str]] = None,
            product_plan: Optional[pulumi.Input[str]] = None,
            product_type: Optional[pulumi.Input[str]] = None,
            service_bandwidth: Optional[pulumi.Input[str]] = None) -> 'DdosCooInstance':
        """
        Get an existing DdosCooInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_type: The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`.
        :param pulumi.Input[str] bandwidth: Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: 30, 60, 100, 300, 400, 500, 600. The unit is Gbps. Only support upgrade.
        :param pulumi.Input[str] bandwidth_mode: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[str] base_bandwidth: Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade.
        :param pulumi.Input[str] domain_count: Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[str] edition_sale: The mitigation plan of the instance. Default value: `coop`. Valid values:
        :param pulumi.Input[str] function_version: The function plan of the instance. Valid values:
        :param pulumi.Input[str] ip: (Available since v1.212.0) The IP address of the instance.
        :param pulumi.Input[str] name: Name of the instance. This name can have a string of 1 to 63 characters.
        :param pulumi.Input[str] normal_bandwidth: The clean bandwidth provided by the instance.
        :param pulumi.Input[str] normal_qps: The clean QPS provided by the instance.
        :param pulumi.Input[int] period: The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        :param pulumi.Input[str] port_count: Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[str] product_plan: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[str] product_type: The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        :param pulumi.Input[str] service_bandwidth: Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DdosCooInstanceState.__new__(_DdosCooInstanceState)

        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["bandwidth_mode"] = bandwidth_mode
        __props__.__dict__["base_bandwidth"] = base_bandwidth
        __props__.__dict__["domain_count"] = domain_count
        __props__.__dict__["edition_sale"] = edition_sale
        __props__.__dict__["function_version"] = function_version
        __props__.__dict__["ip"] = ip
        __props__.__dict__["name"] = name
        __props__.__dict__["normal_bandwidth"] = normal_bandwidth
        __props__.__dict__["normal_qps"] = normal_qps
        __props__.__dict__["period"] = period
        __props__.__dict__["port_count"] = port_count
        __props__.__dict__["product_plan"] = product_plan
        __props__.__dict__["product_type"] = product_type
        __props__.__dict__["service_bandwidth"] = service_bandwidth
        return DdosCooInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[str]:
        """
        The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`.
        """
        return pulumi.get(self, "address_type")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[str]:
        """
        Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: 30, 60, 100, 300, 400, 500, 600. The unit is Gbps. Only support upgrade.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="bandwidthMode")
    def bandwidth_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "bandwidth_mode")

    @property
    @pulumi.getter(name="baseBandwidth")
    def base_bandwidth(self) -> pulumi.Output[str]:
        """
        Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade.
        """
        return pulumi.get(self, "base_bandwidth")

    @property
    @pulumi.getter(name="domainCount")
    def domain_count(self) -> pulumi.Output[str]:
        """
        Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "domain_count")

    @property
    @pulumi.getter(name="editionSale")
    def edition_sale(self) -> pulumi.Output[str]:
        """
        The mitigation plan of the instance. Default value: `coop`. Valid values:
        """
        return pulumi.get(self, "edition_sale")

    @property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> pulumi.Output[str]:
        """
        The function plan of the instance. Valid values:
        """
        return pulumi.get(self, "function_version")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[str]:
        """
        (Available since v1.212.0) The IP address of the instance.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the instance. This name can have a string of 1 to 63 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="normalBandwidth")
    def normal_bandwidth(self) -> pulumi.Output[str]:
        """
        The clean bandwidth provided by the instance.
        """
        return pulumi.get(self, "normal_bandwidth")

    @property
    @pulumi.getter(name="normalQps")
    def normal_qps(self) -> pulumi.Output[str]:
        """
        The clean QPS provided by the instance.
        """
        return pulumi.get(self, "normal_qps")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="portCount")
    def port_count(self) -> pulumi.Output[str]:
        """
        Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "port_count")

    @property
    @pulumi.getter(name="productPlan")
    def product_plan(self) -> pulumi.Output[str]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "product_plan")

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> pulumi.Output[Optional[str]]:
        """
        The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        """
        return pulumi.get(self, "product_type")

    @property
    @pulumi.getter(name="serviceBandwidth")
    def service_bandwidth(self) -> pulumi.Output[str]:
        """
        Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade.
        """
        return pulumi.get(self, "service_bandwidth")

