# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAlidnsRecordsResult',
    'AwaitableGetAlidnsRecordsResult',
    'get_alidns_records',
    'get_alidns_records_output',
]

@pulumi.output_type
class GetAlidnsRecordsResult:
    """
    A collection of values returned by getAlidnsRecords.
    """
    def __init__(__self__, direction=None, domain_name=None, group_id=None, id=None, ids=None, key_word=None, lang=None, line=None, order_by=None, output_file=None, records=None, rr_key_word=None, rr_regex=None, search_mode=None, status=None, type=None, type_key_word=None, value_key_word=None, value_regex=None):
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if group_id and not isinstance(group_id, int):
            raise TypeError("Expected argument 'group_id' to be a int")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if key_word and not isinstance(key_word, str):
            raise TypeError("Expected argument 'key_word' to be a str")
        pulumi.set(__self__, "key_word", key_word)
        if lang and not isinstance(lang, str):
            raise TypeError("Expected argument 'lang' to be a str")
        pulumi.set(__self__, "lang", lang)
        if line and not isinstance(line, str):
            raise TypeError("Expected argument 'line' to be a str")
        pulumi.set(__self__, "line", line)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if rr_key_word and not isinstance(rr_key_word, str):
            raise TypeError("Expected argument 'rr_key_word' to be a str")
        pulumi.set(__self__, "rr_key_word", rr_key_word)
        if rr_regex and not isinstance(rr_regex, str):
            raise TypeError("Expected argument 'rr_regex' to be a str")
        pulumi.set(__self__, "rr_regex", rr_regex)
        if search_mode and not isinstance(search_mode, str):
            raise TypeError("Expected argument 'search_mode' to be a str")
        pulumi.set(__self__, "search_mode", search_mode)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if type_key_word and not isinstance(type_key_word, str):
            raise TypeError("Expected argument 'type_key_word' to be a str")
        pulumi.set(__self__, "type_key_word", type_key_word)
        if value_key_word and not isinstance(value_key_word, str):
            raise TypeError("Expected argument 'value_key_word' to be a str")
        pulumi.set(__self__, "value_key_word", value_key_word)
        if value_regex and not isinstance(value_regex, str):
            raise TypeError("Expected argument 'value_regex' to be a str")
        pulumi.set(__self__, "value_regex", value_regex)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        Name of the domain record belongs to.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[int]:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list of record IDs.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="keyWord")
    def key_word(self) -> Optional[str]:
        return pulumi.get(self, "key_word")

    @property
    @pulumi.getter
    def lang(self) -> Optional[str]:
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter
    def line(self) -> Optional[str]:
        """
        ISP line of the record.
        """
        return pulumi.get(self, "line")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[str]:
        return pulumi.get(self, "order_by")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetAlidnsRecordsRecordResult']:
        """
        A list of records. Each element contains the following attributes:
        """
        return pulumi.get(self, "records")

    @property
    @pulumi.getter(name="rrKeyWord")
    def rr_key_word(self) -> Optional[str]:
        return pulumi.get(self, "rr_key_word")

    @property
    @pulumi.getter(name="rrRegex")
    def rr_regex(self) -> Optional[str]:
        return pulumi.get(self, "rr_regex")

    @property
    @pulumi.getter(name="searchMode")
    def search_mode(self) -> Optional[str]:
        return pulumi.get(self, "search_mode")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the record.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the record.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeKeyWord")
    def type_key_word(self) -> Optional[str]:
        return pulumi.get(self, "type_key_word")

    @property
    @pulumi.getter(name="valueKeyWord")
    def value_key_word(self) -> Optional[str]:
        return pulumi.get(self, "value_key_word")

    @property
    @pulumi.getter(name="valueRegex")
    def value_regex(self) -> Optional[str]:
        return pulumi.get(self, "value_regex")


class AwaitableGetAlidnsRecordsResult(GetAlidnsRecordsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlidnsRecordsResult(
            direction=self.direction,
            domain_name=self.domain_name,
            group_id=self.group_id,
            id=self.id,
            ids=self.ids,
            key_word=self.key_word,
            lang=self.lang,
            line=self.line,
            order_by=self.order_by,
            output_file=self.output_file,
            records=self.records,
            rr_key_word=self.rr_key_word,
            rr_regex=self.rr_regex,
            search_mode=self.search_mode,
            status=self.status,
            type=self.type,
            type_key_word=self.type_key_word,
            value_key_word=self.value_key_word,
            value_regex=self.value_regex)


def get_alidns_records(direction: Optional[str] = None,
                       domain_name: Optional[str] = None,
                       group_id: Optional[int] = None,
                       ids: Optional[Sequence[str]] = None,
                       key_word: Optional[str] = None,
                       lang: Optional[str] = None,
                       line: Optional[str] = None,
                       order_by: Optional[str] = None,
                       output_file: Optional[str] = None,
                       rr_key_word: Optional[str] = None,
                       rr_regex: Optional[str] = None,
                       search_mode: Optional[str] = None,
                       status: Optional[str] = None,
                       type: Optional[str] = None,
                       type_key_word: Optional[str] = None,
                       value_key_word: Optional[str] = None,
                       value_regex: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlidnsRecordsResult:
    """
    This data source provides a list of Alidns Domain Records in an Alibaba Cloud account according to the specified filters.

    > **NOTE:**  Available in 1.86.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    records_ds = alicloud.dns.get_alidns_records(domain_name="xiaozhu.top",
        ids=["1978593525779****"],
        output_file="records.txt",
        type="A")
    pulumi.export("firstRecordId", records_ds.records[0].record_id)
    ```


    :param str direction: Sorting direction. Valid values: `DESC`,`ASC`. Default to `AESC`.
    :param str domain_name: The domain name associated to the records.
    :param int group_id: Domain name group ID.
    :param Sequence[str] ids: A list of record IDs.
    :param str key_word: Keywords.
    :param str lang: User language.
    :param str line: ISP line. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/dns-lines)
    :param str order_by: Sort by. Sort from newest to oldest according to the time added by resolution.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str rr_key_word: The keywords recorded by the host are searched according to the `%RRKeyWord%` mode, and are not case sensitive.
    :param str rr_regex: Host record regex.
    :param str search_mode: Search mode, Valid values: `LIKE`, `EXACT`, `ADVANCED`, `LIKE` (fuzzy), `EXACT` (accurate) search supports KeyWord field, `ADVANCED` (advanced) mode supports other fields.
    :param str status: Record status. Valid values: `ENABLE` and `DISABLE`.
    :param str type: Record type. Valid values: `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
    :param str type_key_word: Analyze type keywords, search by full match, not case sensitive.
    :param str value_key_word: The keywords of the recorded value are searched according to the `%ValueKeyWord%` mode, and are not case sensitive.
    :param str value_regex: Host record value regex.
    """
    __args__ = dict()
    __args__['direction'] = direction
    __args__['domainName'] = domain_name
    __args__['groupId'] = group_id
    __args__['ids'] = ids
    __args__['keyWord'] = key_word
    __args__['lang'] = lang
    __args__['line'] = line
    __args__['orderBy'] = order_by
    __args__['outputFile'] = output_file
    __args__['rrKeyWord'] = rr_key_word
    __args__['rrRegex'] = rr_regex
    __args__['searchMode'] = search_mode
    __args__['status'] = status
    __args__['type'] = type
    __args__['typeKeyWord'] = type_key_word
    __args__['valueKeyWord'] = value_key_word
    __args__['valueRegex'] = value_regex
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:dns/getAlidnsRecords:getAlidnsRecords', __args__, opts=opts, typ=GetAlidnsRecordsResult).value

    return AwaitableGetAlidnsRecordsResult(
        direction=pulumi.get(__ret__, 'direction'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        key_word=pulumi.get(__ret__, 'key_word'),
        lang=pulumi.get(__ret__, 'lang'),
        line=pulumi.get(__ret__, 'line'),
        order_by=pulumi.get(__ret__, 'order_by'),
        output_file=pulumi.get(__ret__, 'output_file'),
        records=pulumi.get(__ret__, 'records'),
        rr_key_word=pulumi.get(__ret__, 'rr_key_word'),
        rr_regex=pulumi.get(__ret__, 'rr_regex'),
        search_mode=pulumi.get(__ret__, 'search_mode'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'),
        type_key_word=pulumi.get(__ret__, 'type_key_word'),
        value_key_word=pulumi.get(__ret__, 'value_key_word'),
        value_regex=pulumi.get(__ret__, 'value_regex'))


@_utilities.lift_output_func(get_alidns_records)
def get_alidns_records_output(direction: Optional[pulumi.Input[Optional[str]]] = None,
                              domain_name: Optional[pulumi.Input[str]] = None,
                              group_id: Optional[pulumi.Input[Optional[int]]] = None,
                              ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              key_word: Optional[pulumi.Input[Optional[str]]] = None,
                              lang: Optional[pulumi.Input[Optional[str]]] = None,
                              line: Optional[pulumi.Input[Optional[str]]] = None,
                              order_by: Optional[pulumi.Input[Optional[str]]] = None,
                              output_file: Optional[pulumi.Input[Optional[str]]] = None,
                              rr_key_word: Optional[pulumi.Input[Optional[str]]] = None,
                              rr_regex: Optional[pulumi.Input[Optional[str]]] = None,
                              search_mode: Optional[pulumi.Input[Optional[str]]] = None,
                              status: Optional[pulumi.Input[Optional[str]]] = None,
                              type: Optional[pulumi.Input[Optional[str]]] = None,
                              type_key_word: Optional[pulumi.Input[Optional[str]]] = None,
                              value_key_word: Optional[pulumi.Input[Optional[str]]] = None,
                              value_regex: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlidnsRecordsResult]:
    """
    This data source provides a list of Alidns Domain Records in an Alibaba Cloud account according to the specified filters.

    > **NOTE:**  Available in 1.86.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    records_ds = alicloud.dns.get_alidns_records(domain_name="xiaozhu.top",
        ids=["1978593525779****"],
        output_file="records.txt",
        type="A")
    pulumi.export("firstRecordId", records_ds.records[0].record_id)
    ```


    :param str direction: Sorting direction. Valid values: `DESC`,`ASC`. Default to `AESC`.
    :param str domain_name: The domain name associated to the records.
    :param int group_id: Domain name group ID.
    :param Sequence[str] ids: A list of record IDs.
    :param str key_word: Keywords.
    :param str lang: User language.
    :param str line: ISP line. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/dns-lines)
    :param str order_by: Sort by. Sort from newest to oldest according to the time added by resolution.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str rr_key_word: The keywords recorded by the host are searched according to the `%RRKeyWord%` mode, and are not case sensitive.
    :param str rr_regex: Host record regex.
    :param str search_mode: Search mode, Valid values: `LIKE`, `EXACT`, `ADVANCED`, `LIKE` (fuzzy), `EXACT` (accurate) search supports KeyWord field, `ADVANCED` (advanced) mode supports other fields.
    :param str status: Record status. Valid values: `ENABLE` and `DISABLE`.
    :param str type: Record type. Valid values: `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
    :param str type_key_word: Analyze type keywords, search by full match, not case sensitive.
    :param str value_key_word: The keywords of the recorded value are searched according to the `%ValueKeyWord%` mode, and are not case sensitive.
    :param str value_regex: Host record value regex.
    """
    ...
