# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetGtmInstancesResult',
    'AwaitableGetGtmInstancesResult',
    'get_gtm_instances',
    'get_gtm_instances_output',
]

@pulumi.output_type
class GetGtmInstancesResult:
    """
    A collection of values returned by getGtmInstances.
    """
    def __init__(__self__, id=None, ids=None, instances=None, lang=None, output_file=None, resource_group_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if lang and not isinstance(lang, str):
            raise TypeError("Expected argument 'lang' to be a str")
        pulumi.set(__self__, "lang", lang)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetGtmInstancesInstanceResult']:
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def lang(self) -> Optional[str]:
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> str:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_group_id")


class AwaitableGetGtmInstancesResult(GetGtmInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGtmInstancesResult(
            id=self.id,
            ids=self.ids,
            instances=self.instances,
            lang=self.lang,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id)


def get_gtm_instances(ids: Optional[Sequence[str]] = None,
                      lang: Optional[str] = None,
                      resource_group_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGtmInstancesResult:
    """
    This data source provides the Alidns Gtm Instances of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.151.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.dns.get_gtm_instances()
    pulumi.export("alidnsGtmInstanceId1", ids.instances[0].id)
    ```


    :param Sequence[str] ids: A list of Gtm Instance IDs.
    :param str lang: The lang.
    :param str resource_group_id: The ID of the resource group.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['lang'] = lang
    __args__['resourceGroupId'] = resource_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:dns/getGtmInstances:getGtmInstances', __args__, opts=opts, typ=GetGtmInstancesResult).value

    return AwaitableGetGtmInstancesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instances=pulumi.get(__ret__, 'instances'),
        lang=pulumi.get(__ret__, 'lang'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'))


@_utilities.lift_output_func(get_gtm_instances)
def get_gtm_instances_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                             lang: Optional[pulumi.Input[Optional[str]]] = None,
                             resource_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGtmInstancesResult]:
    """
    This data source provides the Alidns Gtm Instances of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.151.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.dns.get_gtm_instances()
    pulumi.export("alidnsGtmInstanceId1", ids.instances[0].id)
    ```


    :param Sequence[str] ids: A list of Gtm Instance IDs.
    :param str lang: The lang.
    :param str resource_group_id: The ID of the resource group.
    """
    ...
