# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AccessStrategyDefaultAddrPool',
    'AccessStrategyFailoverAddrPool',
    'AccessStrategyLine',
    'AddressPoolAddress',
    'CustomLineIpSegmentList',
    'GtmInstanceAlertConfig',
    'MonitorConfigIspCityNode',
    'GetAccessStrategiesStrategyResult',
    'GetAccessStrategiesStrategyDefaultAddrPoolResult',
    'GetAccessStrategiesStrategyFailoverAddrPoolResult',
    'GetAccessStrategiesStrategyLineResult',
    'GetAddressPoolsPoolResult',
    'GetAddressPoolsPoolAddressResult',
    'GetAlidnsDomainGroupsGroupResult',
    'GetAlidnsDomainsDomainResult',
    'GetAlidnsDomainsDomainRecordLineResult',
    'GetAlidnsInstancesInstanceResult',
    'GetAlidnsRecordsRecordResult',
    'GetCustomLinesLineResult',
    'GetCustomLinesLineIpSegmentListResult',
    'GetDomainGroupsGroupResult',
    'GetDomainRecordsRecordResult',
    'GetDomainsDomainResult',
    'GetDomainsDomainRecordLineResult',
    'GetGroupsGroupResult',
    'GetGtmInstancesInstanceResult',
    'GetGtmInstancesInstanceAlertConfigResult',
    'GetInstancesInstanceResult',
    'GetRecordsRecordResult',
    'GetResolutionLinesLineResult',
]

@pulumi.output_type
class AccessStrategyDefaultAddrPool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addrPoolId":
            suggest = "addr_pool_id"
        elif key == "lbaWeight":
            suggest = "lba_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessStrategyDefaultAddrPool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessStrategyDefaultAddrPool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessStrategyDefaultAddrPool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addr_pool_id: str,
                 lba_weight: Optional[int] = None):
        """
        :param str addr_pool_id: The ID of the address pool in the primary address pool group.
        :param int lba_weight: The weight of the address pool in the primary address pool group.
        """
        pulumi.set(__self__, "addr_pool_id", addr_pool_id)
        if lba_weight is not None:
            pulumi.set(__self__, "lba_weight", lba_weight)

    @property
    @pulumi.getter(name="addrPoolId")
    def addr_pool_id(self) -> str:
        """
        The ID of the address pool in the primary address pool group.
        """
        return pulumi.get(self, "addr_pool_id")

    @property
    @pulumi.getter(name="lbaWeight")
    def lba_weight(self) -> Optional[int]:
        """
        The weight of the address pool in the primary address pool group.
        """
        return pulumi.get(self, "lba_weight")


@pulumi.output_type
class AccessStrategyFailoverAddrPool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addrPoolId":
            suggest = "addr_pool_id"
        elif key == "lbaWeight":
            suggest = "lba_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessStrategyFailoverAddrPool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessStrategyFailoverAddrPool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessStrategyFailoverAddrPool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addr_pool_id: Optional[str] = None,
                 lba_weight: Optional[int] = None):
        """
        :param str addr_pool_id: The ID of the address pool in the secondary address pool group.
        :param int lba_weight: The weight of the address pool in the secondary address pool group.
        """
        if addr_pool_id is not None:
            pulumi.set(__self__, "addr_pool_id", addr_pool_id)
        if lba_weight is not None:
            pulumi.set(__self__, "lba_weight", lba_weight)

    @property
    @pulumi.getter(name="addrPoolId")
    def addr_pool_id(self) -> Optional[str]:
        """
        The ID of the address pool in the secondary address pool group.
        """
        return pulumi.get(self, "addr_pool_id")

    @property
    @pulumi.getter(name="lbaWeight")
    def lba_weight(self) -> Optional[int]:
        """
        The weight of the address pool in the secondary address pool group.
        """
        return pulumi.get(self, "lba_weight")


@pulumi.output_type
class AccessStrategyLine(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lineCode":
            suggest = "line_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessStrategyLine. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessStrategyLine.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessStrategyLine.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 line_code: Optional[str] = None):
        """
        :param str line_code: The line code of the source region.
        """
        if line_code is not None:
            pulumi.set(__self__, "line_code", line_code)

    @property
    @pulumi.getter(name="lineCode")
    def line_code(self) -> Optional[str]:
        """
        The line code of the source region.
        """
        return pulumi.get(self, "line_code")


@pulumi.output_type
class AddressPoolAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeInfo":
            suggest = "attribute_info"
        elif key == "lbaWeight":
            suggest = "lba_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddressPoolAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddressPoolAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddressPoolAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 attribute_info: str,
                 mode: str,
                 lba_weight: Optional[int] = None,
                 remark: Optional[str] = None):
        """
        :param str address: The address that you want to add to the address pool.
        :param str attribute_info: The source region of the address. expressed as a JSON string. The structure is as follows:
        :param str mode: The type of the address. Valid values:`SMART`, `ONLINE` and `OFFLINE`.
        :param int lba_weight: The weight of the address. **NOTE:** The attribute is valid when the attribute `lba_strategy` is `RATIO`.
        :param str remark: The description of the address.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "attribute_info", attribute_info)
        pulumi.set(__self__, "mode", mode)
        if lba_weight is not None:
            pulumi.set(__self__, "lba_weight", lba_weight)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The address that you want to add to the address pool.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="attributeInfo")
    def attribute_info(self) -> str:
        """
        The source region of the address. expressed as a JSON string. The structure is as follows:
        """
        return pulumi.get(self, "attribute_info")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The type of the address. Valid values:`SMART`, `ONLINE` and `OFFLINE`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="lbaWeight")
    def lba_weight(self) -> Optional[int]:
        """
        The weight of the address. **NOTE:** The attribute is valid when the attribute `lba_strategy` is `RATIO`.
        """
        return pulumi.get(self, "lba_weight")

    @property
    @pulumi.getter
    def remark(self) -> Optional[str]:
        """
        The description of the address.
        """
        return pulumi.get(self, "remark")


@pulumi.output_type
class CustomLineIpSegmentList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endIp":
            suggest = "end_ip"
        elif key == "startIp":
            suggest = "start_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomLineIpSegmentList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomLineIpSegmentList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomLineIpSegmentList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_ip: str,
                 start_ip: str):
        """
        :param str end_ip: The end IP address of the CIDR block.
        :param str start_ip: The start IP address of the CIDR block.
        """
        pulumi.set(__self__, "end_ip", end_ip)
        pulumi.set(__self__, "start_ip", start_ip)

    @property
    @pulumi.getter(name="endIp")
    def end_ip(self) -> str:
        """
        The end IP address of the CIDR block.
        """
        return pulumi.get(self, "end_ip")

    @property
    @pulumi.getter(name="startIp")
    def start_ip(self) -> str:
        """
        The start IP address of the CIDR block.
        """
        return pulumi.get(self, "start_ip")


@pulumi.output_type
class GtmInstanceAlertConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dingtalkNotice":
            suggest = "dingtalk_notice"
        elif key == "emailNotice":
            suggest = "email_notice"
        elif key == "noticeType":
            suggest = "notice_type"
        elif key == "smsNotice":
            suggest = "sms_notice"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GtmInstanceAlertConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GtmInstanceAlertConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GtmInstanceAlertConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dingtalk_notice: Optional[bool] = None,
                 email_notice: Optional[bool] = None,
                 notice_type: Optional[str] = None,
                 sms_notice: Optional[bool] = None):
        """
        :param bool dingtalk_notice: Whether to configure DingTalk notifications. Valid values: `true`, `false`.
        :param bool email_notice: Whether to configure mail notification. Valid values: `true`, `false`.
        :param str notice_type: The Alarm Event Type.
        :param bool sms_notice: Whether to configure SMS notification. Valid values: `true`, `false`.
        """
        if dingtalk_notice is not None:
            pulumi.set(__self__, "dingtalk_notice", dingtalk_notice)
        if email_notice is not None:
            pulumi.set(__self__, "email_notice", email_notice)
        if notice_type is not None:
            pulumi.set(__self__, "notice_type", notice_type)
        if sms_notice is not None:
            pulumi.set(__self__, "sms_notice", sms_notice)

    @property
    @pulumi.getter(name="dingtalkNotice")
    def dingtalk_notice(self) -> Optional[bool]:
        """
        Whether to configure DingTalk notifications. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "dingtalk_notice")

    @property
    @pulumi.getter(name="emailNotice")
    def email_notice(self) -> Optional[bool]:
        """
        Whether to configure mail notification. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "email_notice")

    @property
    @pulumi.getter(name="noticeType")
    def notice_type(self) -> Optional[str]:
        """
        The Alarm Event Type.
        """
        return pulumi.get(self, "notice_type")

    @property
    @pulumi.getter(name="smsNotice")
    def sms_notice(self) -> Optional[bool]:
        """
        Whether to configure SMS notification. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "sms_notice")


@pulumi.output_type
class MonitorConfigIspCityNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cityCode":
            suggest = "city_code"
        elif key == "ispCode":
            suggest = "isp_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitorConfigIspCityNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitorConfigIspCityNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitorConfigIspCityNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 city_code: str,
                 isp_code: str):
        """
        :param str city_code: The code of the city node to monitor.
        :param str isp_code: The code of the Internet provider service (ISP) node to monitor.
        """
        pulumi.set(__self__, "city_code", city_code)
        pulumi.set(__self__, "isp_code", isp_code)

    @property
    @pulumi.getter(name="cityCode")
    def city_code(self) -> str:
        """
        The code of the city node to monitor.
        """
        return pulumi.get(self, "city_code")

    @property
    @pulumi.getter(name="ispCode")
    def isp_code(self) -> str:
        """
        The code of the Internet provider service (ISP) node to monitor.
        """
        return pulumi.get(self, "isp_code")


@pulumi.output_type
class GetAccessStrategiesStrategyResult(dict):
    def __init__(__self__, *,
                 access_mode: str,
                 access_strategy_id: str,
                 create_time: str,
                 create_timestamp: str,
                 default_addr_pool_type: str,
                 default_addr_pools: Sequence['outputs.GetAccessStrategiesStrategyDefaultAddrPoolResult'],
                 default_available_addr_num: int,
                 default_latency_optimization: str,
                 default_lba_strategy: str,
                 default_max_return_addr_num: int,
                 default_min_available_addr_num: int,
                 effective_addr_pool_group_type: str,
                 failover_addr_pool_type: str,
                 failover_addr_pools: Sequence['outputs.GetAccessStrategiesStrategyFailoverAddrPoolResult'],
                 failover_available_addr_num: int,
                 failover_latency_optimization: str,
                 failover_lba_strategy: str,
                 failover_max_return_addr_num: int,
                 failover_min_available_addr_num: int,
                 id: str,
                 instance_id: str,
                 lines: Sequence['outputs.GetAccessStrategiesStrategyLineResult'],
                 strategy_mode: str,
                 strategy_name: str):
        """
        :param str access_mode: The primary/secondary switchover policy for address pool groups.
        :param str access_strategy_id: The first ID of the resource.
        :param str create_time: The time when the access policy was created.
        :param str create_timestamp: The timestamp that indicates when the access policy was created.
        :param str default_addr_pool_type: The type of the primary address pool.
        :param Sequence['GetAccessStrategiesStrategyDefaultAddrPoolArgs'] default_addr_pools: The address pools in the primary address pool group.
        :param int default_available_addr_num: The number of addresses currently available in the primary address pool.
        :param str default_latency_optimization: Indicates whether scheduling optimization for latency resolution was enabled for the primary address pool group.
        :param str default_lba_strategy: The load balancing policy of the primary address pool group.
        :param int default_max_return_addr_num: The maximum number of addresses returned by the primary address pool set.
        :param int default_min_available_addr_num: The minimum number of available addresses for the primary address pool set.
        :param str effective_addr_pool_group_type: The type of the active address pool group.
        :param str failover_addr_pool_type: The type of the secondary address pool.
        :param Sequence['GetAccessStrategiesStrategyFailoverAddrPoolArgs'] failover_addr_pools: The address pools in the secondary address pool group.
        :param int failover_available_addr_num: The number of available addresses in the standby address pool.
        :param str failover_latency_optimization: Indicates whether scheduling optimization for latency resolution was enabled for the secondary address pool group.
        :param str failover_lba_strategy: The load balancing policy of the secondary address pool group.
        :param int failover_max_return_addr_num: The maximum number of returned addresses in the standby address pool.
        :param int failover_min_available_addr_num: The minimum number of available addresses in the standby address pool.
        :param str id: The ID of the Access Strategy.
        :param str instance_id: The Id of the associated instance.
        :param Sequence['GetAccessStrategiesStrategyLineArgs'] lines: List of source regions.
        :param str strategy_mode: The type of the access policy.
        :param str strategy_name: The name of the access policy.
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "access_strategy_id", access_strategy_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "create_timestamp", create_timestamp)
        pulumi.set(__self__, "default_addr_pool_type", default_addr_pool_type)
        pulumi.set(__self__, "default_addr_pools", default_addr_pools)
        pulumi.set(__self__, "default_available_addr_num", default_available_addr_num)
        pulumi.set(__self__, "default_latency_optimization", default_latency_optimization)
        pulumi.set(__self__, "default_lba_strategy", default_lba_strategy)
        pulumi.set(__self__, "default_max_return_addr_num", default_max_return_addr_num)
        pulumi.set(__self__, "default_min_available_addr_num", default_min_available_addr_num)
        pulumi.set(__self__, "effective_addr_pool_group_type", effective_addr_pool_group_type)
        pulumi.set(__self__, "failover_addr_pool_type", failover_addr_pool_type)
        pulumi.set(__self__, "failover_addr_pools", failover_addr_pools)
        pulumi.set(__self__, "failover_available_addr_num", failover_available_addr_num)
        pulumi.set(__self__, "failover_latency_optimization", failover_latency_optimization)
        pulumi.set(__self__, "failover_lba_strategy", failover_lba_strategy)
        pulumi.set(__self__, "failover_max_return_addr_num", failover_max_return_addr_num)
        pulumi.set(__self__, "failover_min_available_addr_num", failover_min_available_addr_num)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "lines", lines)
        pulumi.set(__self__, "strategy_mode", strategy_mode)
        pulumi.set(__self__, "strategy_name", strategy_name)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> str:
        """
        The primary/secondary switchover policy for address pool groups.
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="accessStrategyId")
    def access_strategy_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "access_strategy_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the access policy was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createTimestamp")
    def create_timestamp(self) -> str:
        """
        The timestamp that indicates when the access policy was created.
        """
        return pulumi.get(self, "create_timestamp")

    @property
    @pulumi.getter(name="defaultAddrPoolType")
    def default_addr_pool_type(self) -> str:
        """
        The type of the primary address pool.
        """
        return pulumi.get(self, "default_addr_pool_type")

    @property
    @pulumi.getter(name="defaultAddrPools")
    def default_addr_pools(self) -> Sequence['outputs.GetAccessStrategiesStrategyDefaultAddrPoolResult']:
        """
        The address pools in the primary address pool group.
        """
        return pulumi.get(self, "default_addr_pools")

    @property
    @pulumi.getter(name="defaultAvailableAddrNum")
    def default_available_addr_num(self) -> int:
        """
        The number of addresses currently available in the primary address pool.
        """
        return pulumi.get(self, "default_available_addr_num")

    @property
    @pulumi.getter(name="defaultLatencyOptimization")
    def default_latency_optimization(self) -> str:
        """
        Indicates whether scheduling optimization for latency resolution was enabled for the primary address pool group.
        """
        return pulumi.get(self, "default_latency_optimization")

    @property
    @pulumi.getter(name="defaultLbaStrategy")
    def default_lba_strategy(self) -> str:
        """
        The load balancing policy of the primary address pool group.
        """
        return pulumi.get(self, "default_lba_strategy")

    @property
    @pulumi.getter(name="defaultMaxReturnAddrNum")
    def default_max_return_addr_num(self) -> int:
        """
        The maximum number of addresses returned by the primary address pool set.
        """
        return pulumi.get(self, "default_max_return_addr_num")

    @property
    @pulumi.getter(name="defaultMinAvailableAddrNum")
    def default_min_available_addr_num(self) -> int:
        """
        The minimum number of available addresses for the primary address pool set.
        """
        return pulumi.get(self, "default_min_available_addr_num")

    @property
    @pulumi.getter(name="effectiveAddrPoolGroupType")
    def effective_addr_pool_group_type(self) -> str:
        """
        The type of the active address pool group.
        """
        return pulumi.get(self, "effective_addr_pool_group_type")

    @property
    @pulumi.getter(name="failoverAddrPoolType")
    def failover_addr_pool_type(self) -> str:
        """
        The type of the secondary address pool.
        """
        return pulumi.get(self, "failover_addr_pool_type")

    @property
    @pulumi.getter(name="failoverAddrPools")
    def failover_addr_pools(self) -> Sequence['outputs.GetAccessStrategiesStrategyFailoverAddrPoolResult']:
        """
        The address pools in the secondary address pool group.
        """
        return pulumi.get(self, "failover_addr_pools")

    @property
    @pulumi.getter(name="failoverAvailableAddrNum")
    def failover_available_addr_num(self) -> int:
        """
        The number of available addresses in the standby address pool.
        """
        return pulumi.get(self, "failover_available_addr_num")

    @property
    @pulumi.getter(name="failoverLatencyOptimization")
    def failover_latency_optimization(self) -> str:
        """
        Indicates whether scheduling optimization for latency resolution was enabled for the secondary address pool group.
        """
        return pulumi.get(self, "failover_latency_optimization")

    @property
    @pulumi.getter(name="failoverLbaStrategy")
    def failover_lba_strategy(self) -> str:
        """
        The load balancing policy of the secondary address pool group.
        """
        return pulumi.get(self, "failover_lba_strategy")

    @property
    @pulumi.getter(name="failoverMaxReturnAddrNum")
    def failover_max_return_addr_num(self) -> int:
        """
        The maximum number of returned addresses in the standby address pool.
        """
        return pulumi.get(self, "failover_max_return_addr_num")

    @property
    @pulumi.getter(name="failoverMinAvailableAddrNum")
    def failover_min_available_addr_num(self) -> int:
        """
        The minimum number of available addresses in the standby address pool.
        """
        return pulumi.get(self, "failover_min_available_addr_num")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Access Strategy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The Id of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def lines(self) -> Sequence['outputs.GetAccessStrategiesStrategyLineResult']:
        """
        List of source regions.
        """
        return pulumi.get(self, "lines")

    @property
    @pulumi.getter(name="strategyMode")
    def strategy_mode(self) -> str:
        """
        The type of the access policy.
        """
        return pulumi.get(self, "strategy_mode")

    @property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> str:
        """
        The name of the access policy.
        """
        return pulumi.get(self, "strategy_name")


@pulumi.output_type
class GetAccessStrategiesStrategyDefaultAddrPoolResult(dict):
    def __init__(__self__, *,
                 addr_count: int,
                 addr_pool_id: str,
                 lba_weight: int,
                 name: str):
        """
        :param int addr_count: The number of addresses in the address pool.
        :param str addr_pool_id: The ID of the address pool.
        :param int lba_weight: The weight of the address pool.
        :param str name: The name of the address pool.
        """
        pulumi.set(__self__, "addr_count", addr_count)
        pulumi.set(__self__, "addr_pool_id", addr_pool_id)
        pulumi.set(__self__, "lba_weight", lba_weight)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="addrCount")
    def addr_count(self) -> int:
        """
        The number of addresses in the address pool.
        """
        return pulumi.get(self, "addr_count")

    @property
    @pulumi.getter(name="addrPoolId")
    def addr_pool_id(self) -> str:
        """
        The ID of the address pool.
        """
        return pulumi.get(self, "addr_pool_id")

    @property
    @pulumi.getter(name="lbaWeight")
    def lba_weight(self) -> int:
        """
        The weight of the address pool.
        """
        return pulumi.get(self, "lba_weight")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the address pool.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAccessStrategiesStrategyFailoverAddrPoolResult(dict):
    def __init__(__self__, *,
                 addr_count: int,
                 addr_pool_id: str,
                 lba_weight: int,
                 name: str):
        """
        :param int addr_count: The number of addresses in the address pool.
        :param str addr_pool_id: The ID of the address pool.
        :param int lba_weight: The weight of the address pool.
        :param str name: The name of the address pool.
        """
        pulumi.set(__self__, "addr_count", addr_count)
        pulumi.set(__self__, "addr_pool_id", addr_pool_id)
        pulumi.set(__self__, "lba_weight", lba_weight)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="addrCount")
    def addr_count(self) -> int:
        """
        The number of addresses in the address pool.
        """
        return pulumi.get(self, "addr_count")

    @property
    @pulumi.getter(name="addrPoolId")
    def addr_pool_id(self) -> str:
        """
        The ID of the address pool.
        """
        return pulumi.get(self, "addr_pool_id")

    @property
    @pulumi.getter(name="lbaWeight")
    def lba_weight(self) -> int:
        """
        The weight of the address pool.
        """
        return pulumi.get(self, "lba_weight")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the address pool.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAccessStrategiesStrategyLineResult(dict):
    def __init__(__self__, *,
                 group_code: str,
                 group_name: str,
                 line_code: str,
                 line_name: str):
        """
        :param str group_code: The code of the source region group.
        :param str group_name: The name of the source region group.
        :param str line_code: The line code of the source region.
        :param str line_name: The line name of the source region.
        """
        pulumi.set(__self__, "group_code", group_code)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "line_code", line_code)
        pulumi.set(__self__, "line_name", line_name)

    @property
    @pulumi.getter(name="groupCode")
    def group_code(self) -> str:
        """
        The code of the source region group.
        """
        return pulumi.get(self, "group_code")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        The name of the source region group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="lineCode")
    def line_code(self) -> str:
        """
        The line code of the source region.
        """
        return pulumi.get(self, "line_code")

    @property
    @pulumi.getter(name="lineName")
    def line_name(self) -> str:
        """
        The line name of the source region.
        """
        return pulumi.get(self, "line_name")


@pulumi.output_type
class GetAddressPoolsPoolResult(dict):
    def __init__(__self__, *,
                 address_pool_id: str,
                 address_pool_name: str,
                 addresses: Sequence['outputs.GetAddressPoolsPoolAddressResult'],
                 create_time: str,
                 create_timestamp: str,
                 id: str,
                 instance_id: str,
                 lba_strategy: str,
                 monitor_config_id: str,
                 monitor_status: str,
                 type: str,
                 update_time: str,
                 update_timestamp: str):
        """
        :param str address_pool_id: The first ID of the resource.
        :param str address_pool_name: The name of the address pool.
        :param Sequence['GetAddressPoolsPoolAddressArgs'] addresses: The address that you want to add to the address pool.
        :param str create_time: The time when the address pool was created.
        :param str create_timestamp: The timestamp that indicates when the address pool was created.
        :param str id: The ID of the Address Pool.
        :param str instance_id: The id of the instance.
        :param str lba_strategy: The load balancing policy of the address pool.
        :param str monitor_config_id: The ID of the health check task.
        :param str monitor_status: Indicates whether health checks are configured.
        :param str type: The type of the address pool.
        :param str update_time: The time when the address pool was updated.
        :param str update_timestamp: The timestamp that indicates when the address pool was updated.
        """
        pulumi.set(__self__, "address_pool_id", address_pool_id)
        pulumi.set(__self__, "address_pool_name", address_pool_name)
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "create_timestamp", create_timestamp)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "lba_strategy", lba_strategy)
        pulumi.set(__self__, "monitor_config_id", monitor_config_id)
        pulumi.set(__self__, "monitor_status", monitor_status)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "update_timestamp", update_timestamp)

    @property
    @pulumi.getter(name="addressPoolId")
    def address_pool_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "address_pool_id")

    @property
    @pulumi.getter(name="addressPoolName")
    def address_pool_name(self) -> str:
        """
        The name of the address pool.
        """
        return pulumi.get(self, "address_pool_name")

    @property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.GetAddressPoolsPoolAddressResult']:
        """
        The address that you want to add to the address pool.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the address pool was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createTimestamp")
    def create_timestamp(self) -> str:
        """
        The timestamp that indicates when the address pool was created.
        """
        return pulumi.get(self, "create_timestamp")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Address Pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The id of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="lbaStrategy")
    def lba_strategy(self) -> str:
        """
        The load balancing policy of the address pool.
        """
        return pulumi.get(self, "lba_strategy")

    @property
    @pulumi.getter(name="monitorConfigId")
    def monitor_config_id(self) -> str:
        """
        The ID of the health check task.
        """
        return pulumi.get(self, "monitor_config_id")

    @property
    @pulumi.getter(name="monitorStatus")
    def monitor_status(self) -> str:
        """
        Indicates whether health checks are configured.
        """
        return pulumi.get(self, "monitor_status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the address pool.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time when the address pool was updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="updateTimestamp")
    def update_timestamp(self) -> str:
        """
        The timestamp that indicates when the address pool was updated.
        """
        return pulumi.get(self, "update_timestamp")


@pulumi.output_type
class GetAddressPoolsPoolAddressResult(dict):
    def __init__(__self__, *,
                 address: str,
                 attribute_info: str,
                 lba_weight: int,
                 mode: str,
                 remark: str):
        """
        :param str address: The address that you want to add to the address pool.
        :param str attribute_info: The source region of the address.
        :param int lba_weight: The weight of the address.
        :param str mode: The type of the address.
        :param str remark: The description of the address.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "attribute_info", attribute_info)
        pulumi.set(__self__, "lba_weight", lba_weight)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "remark", remark)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The address that you want to add to the address pool.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="attributeInfo")
    def attribute_info(self) -> str:
        """
        The source region of the address.
        """
        return pulumi.get(self, "attribute_info")

    @property
    @pulumi.getter(name="lbaWeight")
    def lba_weight(self) -> int:
        """
        The weight of the address.
        """
        return pulumi.get(self, "lba_weight")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The type of the address.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def remark(self) -> str:
        """
        The description of the address.
        """
        return pulumi.get(self, "remark")


@pulumi.output_type
class GetAlidnsDomainGroupsGroupResult(dict):
    def __init__(__self__, *,
                 domain_count: int,
                 group_id: str,
                 group_name: str,
                 id: str):
        """
        :param int domain_count: Number of domain names in the group.
        :param str group_id: Id of the domain group.
        :param str group_name: The name of the domain group.
        :param str id: Id of the instance.
        """
        pulumi.set(__self__, "domain_count", domain_count)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="domainCount")
    def domain_count(self) -> int:
        """
        Number of domain names in the group.
        """
        return pulumi.get(self, "domain_count")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        Id of the domain group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        The name of the domain group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Id of the instance.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetAlidnsDomainsDomainResult(dict):
    def __init__(__self__, *,
                 ali_domain: bool,
                 available_ttls: Sequence[int],
                 dns_servers: Sequence[str],
                 domain_id: str,
                 domain_name: str,
                 group_id: str,
                 group_name: str,
                 id: str,
                 in_black_hole: bool,
                 in_clean: bool,
                 instance_id: str,
                 line_type: str,
                 min_ttl: int,
                 puny_code: str,
                 record_line_tree_json: str,
                 record_lines: Sequence['outputs.GetAlidnsDomainsDomainRecordLineResult'],
                 region_lines: bool,
                 remark: str,
                 resource_group_id: str,
                 slave_dns: bool,
                 tags: Mapping[str, Any],
                 version_code: str,
                 version_name: str):
        """
        :param bool ali_domain: Specifies whether the domain is from Alibaba Cloud or not.
        :param Sequence[int] available_ttls: List of available TTLs.
        :param Sequence[str] dns_servers: DNS list of domain names in the resolution system.
        :param str domain_id: ID of the domain.
        :param str domain_name: Name of the domain.
        :param str group_id: Domain group ID, if not filled, the default is all groups.
        :param str group_name: Name of group that contains the domain.
        :param str id: The Id of resource.
        :param bool in_black_hole: Whether it is in black hole.
        :param bool in_clean: Whether it is cleaning.
        :param str instance_id: Cloud analysis product ID.
        :param int min_ttl: Minimum TTL.
        :param str puny_code: Punycode of the Chinese domain.
        :param str record_line_tree_json: Tree-like analytical line list.
        :param Sequence['GetAlidnsDomainsDomainRecordLineArgs'] record_lines: Parse the line data list.
        :param bool region_lines: Whether it is a regional route.
        :param str remark: The Id of resource group which the dns belongs.
        :param str resource_group_id: The Id of resource group which the dns belongs.
        :param bool slave_dns: Whether to allow auxiliary dns.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        :param str version_code: Cloud analysis version code.
        """
        pulumi.set(__self__, "ali_domain", ali_domain)
        pulumi.set(__self__, "available_ttls", available_ttls)
        pulumi.set(__self__, "dns_servers", dns_servers)
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "in_black_hole", in_black_hole)
        pulumi.set(__self__, "in_clean", in_clean)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "line_type", line_type)
        pulumi.set(__self__, "min_ttl", min_ttl)
        pulumi.set(__self__, "puny_code", puny_code)
        pulumi.set(__self__, "record_line_tree_json", record_line_tree_json)
        pulumi.set(__self__, "record_lines", record_lines)
        pulumi.set(__self__, "region_lines", region_lines)
        pulumi.set(__self__, "remark", remark)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "slave_dns", slave_dns)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "version_code", version_code)
        pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter(name="aliDomain")
    def ali_domain(self) -> bool:
        """
        Specifies whether the domain is from Alibaba Cloud or not.
        """
        return pulumi.get(self, "ali_domain")

    @property
    @pulumi.getter(name="availableTtls")
    def available_ttls(self) -> Sequence[int]:
        """
        List of available TTLs.
        """
        return pulumi.get(self, "available_ttls")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[str]:
        """
        DNS list of domain names in the resolution system.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        """
        ID of the domain.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        Name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        Domain group ID, if not filled, the default is all groups.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        Name of group that contains the domain.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Id of resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inBlackHole")
    def in_black_hole(self) -> bool:
        """
        Whether it is in black hole.
        """
        return pulumi.get(self, "in_black_hole")

    @property
    @pulumi.getter(name="inClean")
    def in_clean(self) -> bool:
        """
        Whether it is cleaning.
        """
        return pulumi.get(self, "in_clean")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        Cloud analysis product ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="lineType")
    def line_type(self) -> str:
        return pulumi.get(self, "line_type")

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> int:
        """
        Minimum TTL.
        """
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter(name="punyCode")
    def puny_code(self) -> str:
        """
        Punycode of the Chinese domain.
        """
        return pulumi.get(self, "puny_code")

    @property
    @pulumi.getter(name="recordLineTreeJson")
    def record_line_tree_json(self) -> str:
        """
        Tree-like analytical line list.
        """
        return pulumi.get(self, "record_line_tree_json")

    @property
    @pulumi.getter(name="recordLines")
    def record_lines(self) -> Sequence['outputs.GetAlidnsDomainsDomainRecordLineResult']:
        """
        Parse the line data list.
        """
        return pulumi.get(self, "record_lines")

    @property
    @pulumi.getter(name="regionLines")
    def region_lines(self) -> bool:
        """
        Whether it is a regional route.
        """
        return pulumi.get(self, "region_lines")

    @property
    @pulumi.getter
    def remark(self) -> str:
        """
        The Id of resource group which the dns belongs.
        """
        return pulumi.get(self, "remark")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which the dns belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="slaveDns")
    def slave_dns(self) -> bool:
        """
        Whether to allow auxiliary dns.
        """
        return pulumi.get(self, "slave_dns")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> str:
        """
        Cloud analysis version code.
        """
        return pulumi.get(self, "version_code")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> str:
        return pulumi.get(self, "version_name")


@pulumi.output_type
class GetAlidnsDomainsDomainRecordLineResult(dict):
    def __init__(__self__, *,
                 father_code: str,
                 line_code: str,
                 line_display_name: str,
                 line_name: str):
        """
        :param str father_code: The code of the parent line, or empty if there is none.
        :param str line_code: Sub-line Code.
        :param str line_display_name: Parent line display name.
        :param str line_name: Sub-line display name.
        """
        pulumi.set(__self__, "father_code", father_code)
        pulumi.set(__self__, "line_code", line_code)
        pulumi.set(__self__, "line_display_name", line_display_name)
        pulumi.set(__self__, "line_name", line_name)

    @property
    @pulumi.getter(name="fatherCode")
    def father_code(self) -> str:
        """
        The code of the parent line, or empty if there is none.
        """
        return pulumi.get(self, "father_code")

    @property
    @pulumi.getter(name="lineCode")
    def line_code(self) -> str:
        """
        Sub-line Code.
        """
        return pulumi.get(self, "line_code")

    @property
    @pulumi.getter(name="lineDisplayName")
    def line_display_name(self) -> str:
        """
        Parent line display name.
        """
        return pulumi.get(self, "line_display_name")

    @property
    @pulumi.getter(name="lineName")
    def line_name(self) -> str:
        """
        Sub-line display name.
        """
        return pulumi.get(self, "line_name")


@pulumi.output_type
class GetAlidnsInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 dns_security: str,
                 domain: str,
                 domain_numbers: str,
                 id: str,
                 instance_id: str,
                 payment_type: str,
                 version_code: str,
                 version_name: str):
        """
        :param str dns_security: DNS security level.
        :param str domain: (Available in 1.124.1+) The domain name.
        :param str domain_numbers: Number of domain names bound.
        :param str id: Id of the instance.
        :param str instance_id: Id of the instance resource.
        :param str payment_type: (Available in 1.124.1+) The payment type of alidns instance.
        :param str version_code: Paid package version.
        :param str version_name: Paid package version name.
        """
        pulumi.set(__self__, "dns_security", dns_security)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "domain_numbers", domain_numbers)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "version_code", version_code)
        pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter(name="dnsSecurity")
    def dns_security(self) -> str:
        """
        DNS security level.
        """
        return pulumi.get(self, "dns_security")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        (Available in 1.124.1+) The domain name.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainNumbers")
    def domain_numbers(self) -> str:
        """
        Number of domain names bound.
        """
        return pulumi.get(self, "domain_numbers")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Id of the instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        Id of the instance resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        (Available in 1.124.1+) The payment type of alidns instance.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> str:
        """
        Paid package version.
        """
        return pulumi.get(self, "version_code")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> str:
        """
        Paid package version name.
        """
        return pulumi.get(self, "version_name")


@pulumi.output_type
class GetAlidnsRecordsRecordResult(dict):
    def __init__(__self__, *,
                 domain_name: str,
                 id: str,
                 line: str,
                 locked: bool,
                 priority: int,
                 record_id: str,
                 remark: str,
                 rr: str,
                 status: str,
                 ttl: int,
                 type: str,
                 value: str):
        """
        :param str domain_name: The domain name associated to the records.
        :param str id: ID of the resource.
        :param str line: ISP line. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/dns-lines)
        :param bool locked: Indicates whether the record is locked.
        :param int priority: Priority of the `MX` record.
        :param str record_id: ID of the record.
        :param str remark: The remark of the domain record.  **NOTE:** Available in 1.144.0+.
        :param str rr: Host record of the domain.
        :param str status: Record status. Valid values: `ENABLE` and `DISABLE`.
        :param int ttl: TTL of the record.
        :param str type: Record type. Valid values: `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
        :param str value: Host record value of the domain.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "line", line)
        pulumi.set(__self__, "locked", locked)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "record_id", record_id)
        pulumi.set(__self__, "remark", remark)
        pulumi.set(__self__, "rr", rr)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The domain name associated to the records.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def line(self) -> str:
        """
        ISP line. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/dns-lines)
        """
        return pulumi.get(self, "line")

    @property
    @pulumi.getter
    def locked(self) -> bool:
        """
        Indicates whether the record is locked.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Priority of the `MX` record.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="recordId")
    def record_id(self) -> str:
        """
        ID of the record.
        """
        return pulumi.get(self, "record_id")

    @property
    @pulumi.getter
    def remark(self) -> str:
        """
        The remark of the domain record.  **NOTE:** Available in 1.144.0+.
        """
        return pulumi.get(self, "remark")

    @property
    @pulumi.getter
    def rr(self) -> str:
        """
        Host record of the domain.
        """
        return pulumi.get(self, "rr")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Record status. Valid values: `ENABLE` and `DISABLE`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        TTL of the record.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Record type. Valid values: `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Host record value of the domain.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetCustomLinesLineResult(dict):
    def __init__(__self__, *,
                 code: str,
                 custom_line_id: str,
                 custom_line_name: str,
                 domain_name: str,
                 id: str,
                 ip_segment_lists: Sequence['outputs.GetCustomLinesLineIpSegmentListResult']):
        """
        :param str code: The Custom line Code.
        :param str custom_line_id: The first ID of the resource.
        :param str custom_line_name: Line name.
        :param str domain_name: The Domain name.
        :param str id: The ID of the Custom Line.
        :param Sequence['GetCustomLinesLineIpSegmentListArgs'] ip_segment_lists: The IP segment list.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "custom_line_id", custom_line_id)
        pulumi.set(__self__, "custom_line_name", custom_line_name)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_segment_lists", ip_segment_lists)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The Custom line Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="customLineId")
    def custom_line_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "custom_line_id")

    @property
    @pulumi.getter(name="customLineName")
    def custom_line_name(self) -> str:
        """
        Line name.
        """
        return pulumi.get(self, "custom_line_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The Domain name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Custom Line.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipSegmentLists")
    def ip_segment_lists(self) -> Sequence['outputs.GetCustomLinesLineIpSegmentListResult']:
        """
        The IP segment list.
        """
        return pulumi.get(self, "ip_segment_lists")


@pulumi.output_type
class GetCustomLinesLineIpSegmentListResult(dict):
    def __init__(__self__, *,
                 end_ip: str,
                 start_ip: str):
        """
        :param str end_ip: The end IP address of the CIDR block.
        :param str start_ip: The start IP address of the CIDR block.
        """
        pulumi.set(__self__, "end_ip", end_ip)
        pulumi.set(__self__, "start_ip", start_ip)

    @property
    @pulumi.getter(name="endIp")
    def end_ip(self) -> str:
        """
        The end IP address of the CIDR block.
        """
        return pulumi.get(self, "end_ip")

    @property
    @pulumi.getter(name="startIp")
    def start_ip(self) -> str:
        """
        The start IP address of the CIDR block.
        """
        return pulumi.get(self, "start_ip")


@pulumi.output_type
class GetDomainGroupsGroupResult(dict):
    def __init__(__self__, *,
                 group_id: str,
                 group_name: str):
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        return pulumi.get(self, "group_name")


@pulumi.output_type
class GetDomainRecordsRecordResult(dict):
    def __init__(__self__, *,
                 domain_name: str,
                 host_record: str,
                 line: str,
                 locked: bool,
                 priority: int,
                 record_id: str,
                 status: str,
                 ttl: float,
                 type: str,
                 value: str):
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "host_record", host_record)
        pulumi.set(__self__, "line", line)
        pulumi.set(__self__, "locked", locked)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "record_id", record_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="hostRecord")
    def host_record(self) -> str:
        return pulumi.get(self, "host_record")

    @property
    @pulumi.getter
    def line(self) -> str:
        return pulumi.get(self, "line")

    @property
    @pulumi.getter
    def locked(self) -> bool:
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def priority(self) -> int:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="recordId")
    def record_id(self) -> str:
        return pulumi.get(self, "record_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def ttl(self) -> float:
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDomainsDomainResult(dict):
    def __init__(__self__, *,
                 ali_domain: bool,
                 available_ttls: Sequence[int],
                 dns_servers: Sequence[str],
                 domain_id: str,
                 domain_name: str,
                 group_id: str,
                 group_name: str,
                 id: str,
                 in_black_hole: bool,
                 in_clean: bool,
                 instance_id: str,
                 line_type: str,
                 min_ttl: int,
                 puny_code: str,
                 record_line_tree_json: str,
                 record_lines: Sequence['outputs.GetDomainsDomainRecordLineResult'],
                 region_lines: bool,
                 remark: str,
                 resource_group_id: str,
                 slave_dns: bool,
                 tags: Mapping[str, Any],
                 version_code: str,
                 version_name: str):
        """
        :param bool ali_domain: Specifies whether the domain is from Alibaba Cloud or not.
        :param Sequence[str] dns_servers: DNS list of domain names in the resolution system.
        :param str domain_id: ID of the domain.
        :param str domain_name: Name of the domain.
        :param str group_id: Domain group ID, if not filled, the default is all groups.
        :param str group_name: Name of group that contains the domain.
        :param str id: The Id of resource.
        :param bool in_black_hole: Whether it is in black hole.
        :param bool in_clean: Whether it is cleaning.
        :param str instance_id: Cloud analysis product ID.
        :param int min_ttl: Minimum TTL.
        :param str puny_code: Punycode of the Chinese domain.
        :param str record_line_tree_json: Tree-like analytical line list.
        :param bool region_lines: Whether it is a regional route.
        :param str remark: The Id of resource group which the dns belongs.
        :param str resource_group_id: The Id of resource group which the dns belongs.
        :param bool slave_dns: Whether to allow auxiliary dns.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        :param str version_code: Cloud analysis version code.
        """
        pulumi.set(__self__, "ali_domain", ali_domain)
        pulumi.set(__self__, "available_ttls", available_ttls)
        pulumi.set(__self__, "dns_servers", dns_servers)
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "in_black_hole", in_black_hole)
        pulumi.set(__self__, "in_clean", in_clean)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "line_type", line_type)
        pulumi.set(__self__, "min_ttl", min_ttl)
        pulumi.set(__self__, "puny_code", puny_code)
        pulumi.set(__self__, "record_line_tree_json", record_line_tree_json)
        pulumi.set(__self__, "record_lines", record_lines)
        pulumi.set(__self__, "region_lines", region_lines)
        pulumi.set(__self__, "remark", remark)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "slave_dns", slave_dns)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "version_code", version_code)
        pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter(name="aliDomain")
    def ali_domain(self) -> bool:
        """
        Specifies whether the domain is from Alibaba Cloud or not.
        """
        return pulumi.get(self, "ali_domain")

    @property
    @pulumi.getter(name="availableTtls")
    def available_ttls(self) -> Sequence[int]:
        return pulumi.get(self, "available_ttls")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[str]:
        """
        DNS list of domain names in the resolution system.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        """
        ID of the domain.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        Name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        Domain group ID, if not filled, the default is all groups.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        Name of group that contains the domain.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Id of resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inBlackHole")
    def in_black_hole(self) -> bool:
        """
        Whether it is in black hole.
        """
        return pulumi.get(self, "in_black_hole")

    @property
    @pulumi.getter(name="inClean")
    def in_clean(self) -> bool:
        """
        Whether it is cleaning.
        """
        return pulumi.get(self, "in_clean")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        Cloud analysis product ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="lineType")
    def line_type(self) -> str:
        return pulumi.get(self, "line_type")

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> int:
        """
        Minimum TTL.
        """
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter(name="punyCode")
    def puny_code(self) -> str:
        """
        Punycode of the Chinese domain.
        """
        return pulumi.get(self, "puny_code")

    @property
    @pulumi.getter(name="recordLineTreeJson")
    def record_line_tree_json(self) -> str:
        """
        Tree-like analytical line list.
        """
        return pulumi.get(self, "record_line_tree_json")

    @property
    @pulumi.getter(name="recordLines")
    def record_lines(self) -> Sequence['outputs.GetDomainsDomainRecordLineResult']:
        return pulumi.get(self, "record_lines")

    @property
    @pulumi.getter(name="regionLines")
    def region_lines(self) -> bool:
        """
        Whether it is a regional route.
        """
        return pulumi.get(self, "region_lines")

    @property
    @pulumi.getter
    def remark(self) -> str:
        """
        The Id of resource group which the dns belongs.
        """
        return pulumi.get(self, "remark")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which the dns belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="slaveDns")
    def slave_dns(self) -> bool:
        """
        Whether to allow auxiliary dns.
        """
        return pulumi.get(self, "slave_dns")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> str:
        """
        Cloud analysis version code.
        """
        return pulumi.get(self, "version_code")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> str:
        return pulumi.get(self, "version_name")


@pulumi.output_type
class GetDomainsDomainRecordLineResult(dict):
    def __init__(__self__, *,
                 father_code: str,
                 line_code: str,
                 line_display_name: str,
                 line_name: str):
        pulumi.set(__self__, "father_code", father_code)
        pulumi.set(__self__, "line_code", line_code)
        pulumi.set(__self__, "line_display_name", line_display_name)
        pulumi.set(__self__, "line_name", line_name)

    @property
    @pulumi.getter(name="fatherCode")
    def father_code(self) -> str:
        return pulumi.get(self, "father_code")

    @property
    @pulumi.getter(name="lineCode")
    def line_code(self) -> str:
        return pulumi.get(self, "line_code")

    @property
    @pulumi.getter(name="lineDisplayName")
    def line_display_name(self) -> str:
        return pulumi.get(self, "line_display_name")

    @property
    @pulumi.getter(name="lineName")
    def line_name(self) -> str:
        return pulumi.get(self, "line_name")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 group_id: str,
                 group_name: str):
        """
        :param str group_id: Id of the group.
        :param str group_name: Name of the group.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        Id of the group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        Name of the group.
        """
        return pulumi.get(self, "group_name")


@pulumi.output_type
class GetGtmInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 alert_configs: Sequence['outputs.GetGtmInstancesInstanceAlertConfigResult'],
                 alert_groups: Sequence[str],
                 cname_type: str,
                 create_time: str,
                 expire_time: str,
                 id: str,
                 instance_id: str,
                 instance_name: str,
                 package_edition: str,
                 payment_type: str,
                 public_cname_mode: str,
                 public_rr: str,
                 public_user_domain_name: str,
                 public_zone_name: str,
                 resource_group_id: str,
                 strategy_mode: str,
                 ttl: int):
        """
        :param Sequence['GetGtmInstancesInstanceAlertConfigArgs'] alert_configs: The alert notification methods.
        :param Sequence[str] alert_groups: The alert group.
        :param str cname_type: The access type of the CNAME domain name.
        :param str create_time: The CreateTime of the Gtm Instance.
        :param str expire_time: The ExpireTime of the Gtm Instance.
        :param str id: The ID of the Gtm Instance.
        :param str instance_id: The ID of the Gtm Instance.
        :param str instance_name: The name of the Gtm Instance.
        :param str package_edition: The version of the instance.
        :param str payment_type: The paymentype of the resource.
        :param str public_cname_mode: The Public Network domain name access method.
        :param str public_rr: The CNAME access domain name.
        :param str public_user_domain_name: The website domain name that the user uses on the Internet.
        :param str public_zone_name: The domain name that is used to access GTM over the Internet.
        :param str resource_group_id: The ID of the resource group.
        :param str strategy_mode: The type of the access policy.
        :param int ttl: The global time to live.
        """
        pulumi.set(__self__, "alert_configs", alert_configs)
        pulumi.set(__self__, "alert_groups", alert_groups)
        pulumi.set(__self__, "cname_type", cname_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "package_edition", package_edition)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "public_cname_mode", public_cname_mode)
        pulumi.set(__self__, "public_rr", public_rr)
        pulumi.set(__self__, "public_user_domain_name", public_user_domain_name)
        pulumi.set(__self__, "public_zone_name", public_zone_name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "strategy_mode", strategy_mode)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="alertConfigs")
    def alert_configs(self) -> Sequence['outputs.GetGtmInstancesInstanceAlertConfigResult']:
        """
        The alert notification methods.
        """
        return pulumi.get(self, "alert_configs")

    @property
    @pulumi.getter(name="alertGroups")
    def alert_groups(self) -> Sequence[str]:
        """
        The alert group.
        """
        return pulumi.get(self, "alert_groups")

    @property
    @pulumi.getter(name="cnameType")
    def cname_type(self) -> str:
        """
        The access type of the CNAME domain name.
        """
        return pulumi.get(self, "cname_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The CreateTime of the Gtm Instance.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The ExpireTime of the Gtm Instance.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Gtm Instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the Gtm Instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of the Gtm Instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="packageEdition")
    def package_edition(self) -> str:
        """
        The version of the instance.
        """
        return pulumi.get(self, "package_edition")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The paymentype of the resource.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="publicCnameMode")
    def public_cname_mode(self) -> str:
        """
        The Public Network domain name access method.
        """
        return pulumi.get(self, "public_cname_mode")

    @property
    @pulumi.getter(name="publicRr")
    def public_rr(self) -> str:
        """
        The CNAME access domain name.
        """
        return pulumi.get(self, "public_rr")

    @property
    @pulumi.getter(name="publicUserDomainName")
    def public_user_domain_name(self) -> str:
        """
        The website domain name that the user uses on the Internet.
        """
        return pulumi.get(self, "public_user_domain_name")

    @property
    @pulumi.getter(name="publicZoneName")
    def public_zone_name(self) -> str:
        """
        The domain name that is used to access GTM over the Internet.
        """
        return pulumi.get(self, "public_zone_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="strategyMode")
    def strategy_mode(self) -> str:
        """
        The type of the access policy.
        """
        return pulumi.get(self, "strategy_mode")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The global time to live.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetGtmInstancesInstanceAlertConfigResult(dict):
    def __init__(__self__, *,
                 dingtalk_notice: bool,
                 email_notice: bool,
                 notice_type: str,
                 sms_notice: bool):
        """
        :param bool dingtalk_notice: Whether to configure DingTalk notifications.
        :param bool email_notice: Whether to configure mail notification.
        :param str notice_type: The Alarm Event Type.
        :param bool sms_notice: Whether to configure SMS notification.
        """
        pulumi.set(__self__, "dingtalk_notice", dingtalk_notice)
        pulumi.set(__self__, "email_notice", email_notice)
        pulumi.set(__self__, "notice_type", notice_type)
        pulumi.set(__self__, "sms_notice", sms_notice)

    @property
    @pulumi.getter(name="dingtalkNotice")
    def dingtalk_notice(self) -> bool:
        """
        Whether to configure DingTalk notifications.
        """
        return pulumi.get(self, "dingtalk_notice")

    @property
    @pulumi.getter(name="emailNotice")
    def email_notice(self) -> bool:
        """
        Whether to configure mail notification.
        """
        return pulumi.get(self, "email_notice")

    @property
    @pulumi.getter(name="noticeType")
    def notice_type(self) -> str:
        """
        The Alarm Event Type.
        """
        return pulumi.get(self, "notice_type")

    @property
    @pulumi.getter(name="smsNotice")
    def sms_notice(self) -> bool:
        """
        Whether to configure SMS notification.
        """
        return pulumi.get(self, "sms_notice")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 dns_security: str,
                 domain: str,
                 domain_numbers: str,
                 id: str,
                 instance_id: str,
                 payment_type: str,
                 version_code: str,
                 version_name: str):
        """
        :param str dns_security: DNS security level.
        :param str domain_numbers: Number of domain names bound.
        :param str id: Id of the instance.
        :param str instance_id: Id of the instance resource.
        :param str version_code: Paid package version.
        :param str version_name: Paid package version name.
        """
        pulumi.set(__self__, "dns_security", dns_security)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "domain_numbers", domain_numbers)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "version_code", version_code)
        pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter(name="dnsSecurity")
    def dns_security(self) -> str:
        """
        DNS security level.
        """
        return pulumi.get(self, "dns_security")

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainNumbers")
    def domain_numbers(self) -> str:
        """
        Number of domain names bound.
        """
        return pulumi.get(self, "domain_numbers")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Id of the instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        Id of the instance resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> str:
        """
        Paid package version.
        """
        return pulumi.get(self, "version_code")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> str:
        """
        Paid package version name.
        """
        return pulumi.get(self, "version_name")


@pulumi.output_type
class GetRecordsRecordResult(dict):
    def __init__(__self__, *,
                 domain_name: str,
                 host_record: str,
                 line: str,
                 locked: bool,
                 priority: int,
                 record_id: str,
                 status: str,
                 ttl: float,
                 type: str,
                 value: str):
        """
        :param str domain_name: The domain name associated to the records.
        :param str host_record: Host record of the domain.
        :param str line: ISP line. Valid items are `default`, `telecom`, `unicom`, `mobile`, `oversea`, `edu`, `drpeng`, `btvn`, .etc. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/doc-detail/29807.htm)
        :param bool locked: Indicates whether the record is locked.
        :param int priority: Priority of the `MX` record.
        :param str record_id: ID of the record.
        :param str status: Record status. Valid items are `ENABLE` and `DISABLE`.
        :param float ttl: TTL of the record.
        :param str type: Record type. Valid items are `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
        :param str value: Host record value of the domain.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "host_record", host_record)
        pulumi.set(__self__, "line", line)
        pulumi.set(__self__, "locked", locked)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "record_id", record_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The domain name associated to the records.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="hostRecord")
    def host_record(self) -> str:
        """
        Host record of the domain.
        """
        return pulumi.get(self, "host_record")

    @property
    @pulumi.getter
    def line(self) -> str:
        """
        ISP line. Valid items are `default`, `telecom`, `unicom`, `mobile`, `oversea`, `edu`, `drpeng`, `btvn`, .etc. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/doc-detail/29807.htm)
        """
        return pulumi.get(self, "line")

    @property
    @pulumi.getter
    def locked(self) -> bool:
        """
        Indicates whether the record is locked.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Priority of the `MX` record.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="recordId")
    def record_id(self) -> str:
        """
        ID of the record.
        """
        return pulumi.get(self, "record_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Record status. Valid items are `ENABLE` and `DISABLE`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def ttl(self) -> float:
        """
        TTL of the record.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Record type. Valid items are `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Host record value of the domain.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetResolutionLinesLineResult(dict):
    def __init__(__self__, *,
                 line_code: str,
                 line_display_name: str,
                 line_name: str):
        """
        :param str line_display_name: Line display name.
        :param str line_name: Line name.
        """
        pulumi.set(__self__, "line_code", line_code)
        pulumi.set(__self__, "line_display_name", line_display_name)
        pulumi.set(__self__, "line_name", line_name)

    @property
    @pulumi.getter(name="lineCode")
    def line_code(self) -> str:
        return pulumi.get(self, "line_code")

    @property
    @pulumi.getter(name="lineDisplayName")
    def line_display_name(self) -> str:
        """
        Line display name.
        """
        return pulumi.get(self, "line_display_name")

    @property
    @pulumi.getter(name="lineName")
    def line_name(self) -> str:
        """
        Line name.
        """
        return pulumi.get(self, "line_name")


