# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetConsumerChannelsResult',
    'AwaitableGetConsumerChannelsResult',
    'get_consumer_channels',
    'get_consumer_channels_output',
]

@pulumi.output_type
class GetConsumerChannelsResult:
    """
    A collection of values returned by getConsumerChannels.
    """
    def __init__(__self__, channels=None, dts_instance_id=None, id=None, ids=None, output_file=None):
        if channels and not isinstance(channels, list):
            raise TypeError("Expected argument 'channels' to be a list")
        pulumi.set(__self__, "channels", channels)
        if dts_instance_id and not isinstance(dts_instance_id, str):
            raise TypeError("Expected argument 'dts_instance_id' to be a str")
        pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @property
    @pulumi.getter
    def channels(self) -> Sequence['outputs.GetConsumerChannelsChannelResult']:
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> str:
        return pulumi.get(self, "dts_instance_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")


class AwaitableGetConsumerChannelsResult(GetConsumerChannelsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConsumerChannelsResult(
            channels=self.channels,
            dts_instance_id=self.dts_instance_id,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file)


def get_consumer_channels(dts_instance_id: Optional[str] = None,
                          ids: Optional[Sequence[str]] = None,
                          output_file: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConsumerChannelsResult:
    """
    This data source provides the Dts Consumer Channels of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.146.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.dts.get_consumer_channels()
    pulumi.export("dtsConsumerChannelId1", ids.channels[0].id)
    ```


    :param str dts_instance_id: Subscription instance ID.
    :param Sequence[str] ids: A list of Consumer Channel IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['dtsInstanceId'] = dts_instance_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:dts/getConsumerChannels:getConsumerChannels', __args__, opts=opts, typ=GetConsumerChannelsResult).value

    return AwaitableGetConsumerChannelsResult(
        channels=pulumi.get(__ret__, 'channels'),
        dts_instance_id=pulumi.get(__ret__, 'dts_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'))


@_utilities.lift_output_func(get_consumer_channels)
def get_consumer_channels_output(dts_instance_id: Optional[pulumi.Input[str]] = None,
                                 ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConsumerChannelsResult]:
    """
    This data source provides the Dts Consumer Channels of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.146.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.dts.get_consumer_channels()
    pulumi.export("dtsConsumerChannelId1", ids.channels[0].id)
    ```


    :param str dts_instance_id: Subscription instance ID.
    :param Sequence[str] ids: A list of Consumer Channel IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
