# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MigrationInstanceArgs', 'MigrationInstance']

@pulumi.input_type
class MigrationInstanceArgs:
    def __init__(__self__, *,
                 destination_endpoint_engine_name: pulumi.Input[str],
                 destination_endpoint_region: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 source_endpoint_engine_name: pulumi.Input[str],
                 source_endpoint_region: pulumi.Input[str],
                 compute_unit: Optional[pulumi.Input[int]] = None,
                 database_count: Optional[pulumi.Input[int]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 sync_architecture: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a MigrationInstance resource.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[str] sync_architecture: The sync architecture. Valid values: `oneway`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        pulumi.set(__self__, "destination_endpoint_region", destination_endpoint_region)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if compute_unit is not None:
            pulumi.set(__self__, "compute_unit", compute_unit)
        if database_count is not None:
            pulumi.set(__self__, "database_count", database_count)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if sync_architecture is not None:
            pulumi.set(__self__, "sync_architecture", sync_architecture)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> pulumi.Input[str]:
        """
        The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> pulumi.Input[str]:
        """
        The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        """
        return pulumi.get(self, "destination_endpoint_region")

    @destination_endpoint_region.setter
    def destination_endpoint_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_endpoint_region", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> pulumi.Input[str]:
        """
        The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> pulumi.Input[str]:
        """
        The region of source instance.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_endpoint_region", value)

    @property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> Optional[pulumi.Input[int]]:
        """
        [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        """
        return pulumi.get(self, "compute_unit")

    @compute_unit.setter
    def compute_unit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_unit", value)

    @property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        """
        return pulumi.get(self, "database_count")

    @database_count.setter
    def database_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "database_count", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[str]]:
        """
        The instance class. Valid values: `large`, `medium`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> Optional[pulumi.Input[str]]:
        """
        The sync architecture. Valid values: `oneway`.
        """
        return pulumi.get(self, "sync_architecture")

    @sync_architecture.setter
    def sync_architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_architecture", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _MigrationInstanceState:
    def __init__(__self__, *,
                 compute_unit: Optional[pulumi.Input[int]] = None,
                 database_count: Optional[pulumi.Input[int]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[str]] = None,
                 dts_instance_id: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sync_architecture: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Input properties used for looking up and filtering MigrationInstance resources.
        :param pulumi.Input[int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[str] dts_instance_id: The ID of the Migration Instance.
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[str] status: The status.
        :param pulumi.Input[str] sync_architecture: The sync architecture. Valid values: `oneway`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        """
        if compute_unit is not None:
            pulumi.set(__self__, "compute_unit", compute_unit)
        if database_count is not None:
            pulumi.set(__self__, "database_count", database_count)
        if destination_endpoint_engine_name is not None:
            pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        if destination_endpoint_region is not None:
            pulumi.set(__self__, "destination_endpoint_region", destination_endpoint_region)
        if dts_instance_id is not None:
            pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if source_endpoint_engine_name is not None:
            pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        if source_endpoint_region is not None:
            pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sync_architecture is not None:
            pulumi.set(__self__, "sync_architecture", sync_architecture)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> Optional[pulumi.Input[int]]:
        """
        [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        """
        return pulumi.get(self, "compute_unit")

    @compute_unit.setter
    def compute_unit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_unit", value)

    @property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        """
        return pulumi.get(self, "database_count")

    @database_count.setter
    def database_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "database_count", value)

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> Optional[pulumi.Input[str]]:
        """
        The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        """
        return pulumi.get(self, "destination_endpoint_region")

    @destination_endpoint_region.setter
    def destination_endpoint_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_region", value)

    @property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Migration Instance.
        """
        return pulumi.get(self, "dts_instance_id")

    @dts_instance_id.setter
    def dts_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dts_instance_id", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[str]]:
        """
        The instance class. Valid values: `large`, `medium`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> Optional[pulumi.Input[str]]:
        """
        The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of source instance.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> Optional[pulumi.Input[str]]:
        """
        The sync architecture. Valid values: `oneway`.
        """
        return pulumi.get(self, "sync_architecture")

    @sync_architecture.setter
    def sync_architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_architecture", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


class MigrationInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_unit: Optional[pulumi.Input[int]] = None,
                 database_count: Optional[pulumi.Input[int]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[str]] = None,
                 sync_architecture: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        Provides a DTS Migration Instance resource.

        For information about DTS Migration Instance and how to use it, see [What is Synchronization Instance](https://www.alibabacloud.com/help/en/doc-detail/208270.html).

        > **NOTE:** Available since v1.157.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_regions = alicloud.get_regions(current=True)
        default_migration_instance = alicloud.dts.MigrationInstance("defaultMigrationInstance",
            payment_type="PayAsYouGo",
            source_endpoint_engine_name="MySQL",
            source_endpoint_region=default_regions.regions[0].id,
            destination_endpoint_engine_name="MySQL",
            destination_endpoint_region=default_regions.regions[0].id,
            instance_class="small",
            sync_architecture="oneway")
        ```

        ## Import

        DTS Migration Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dts/migrationInstance:MigrationInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[str] sync_architecture: The sync architecture. Valid values: `oneway`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MigrationInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DTS Migration Instance resource.

        For information about DTS Migration Instance and how to use it, see [What is Synchronization Instance](https://www.alibabacloud.com/help/en/doc-detail/208270.html).

        > **NOTE:** Available since v1.157.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_regions = alicloud.get_regions(current=True)
        default_migration_instance = alicloud.dts.MigrationInstance("defaultMigrationInstance",
            payment_type="PayAsYouGo",
            source_endpoint_engine_name="MySQL",
            source_endpoint_region=default_regions.regions[0].id,
            destination_endpoint_engine_name="MySQL",
            destination_endpoint_region=default_regions.regions[0].id,
            instance_class="small",
            sync_architecture="oneway")
        ```

        ## Import

        DTS Migration Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dts/migrationInstance:MigrationInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param MigrationInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MigrationInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_unit: Optional[pulumi.Input[int]] = None,
                 database_count: Optional[pulumi.Input[int]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[str]] = None,
                 sync_architecture: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MigrationInstanceArgs.__new__(MigrationInstanceArgs)

            __props__.__dict__["compute_unit"] = compute_unit
            __props__.__dict__["database_count"] = database_count
            if destination_endpoint_engine_name is None and not opts.urn:
                raise TypeError("Missing required property 'destination_endpoint_engine_name'")
            __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
            if destination_endpoint_region is None and not opts.urn:
                raise TypeError("Missing required property 'destination_endpoint_region'")
            __props__.__dict__["destination_endpoint_region"] = destination_endpoint_region
            __props__.__dict__["instance_class"] = instance_class
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            if source_endpoint_engine_name is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_engine_name'")
            __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
            if source_endpoint_region is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_region'")
            __props__.__dict__["source_endpoint_region"] = source_endpoint_region
            __props__.__dict__["sync_architecture"] = sync_architecture
            __props__.__dict__["tags"] = tags
            __props__.__dict__["dts_instance_id"] = None
            __props__.__dict__["status"] = None
        super(MigrationInstance, __self__).__init__(
            'alicloud:dts/migrationInstance:MigrationInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compute_unit: Optional[pulumi.Input[int]] = None,
            database_count: Optional[pulumi.Input[int]] = None,
            destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
            destination_endpoint_region: Optional[pulumi.Input[str]] = None,
            dts_instance_id: Optional[pulumi.Input[str]] = None,
            instance_class: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
            source_endpoint_region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            sync_architecture: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None) -> 'MigrationInstance':
        """
        Get an existing MigrationInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[str] dts_instance_id: The ID of the Migration Instance.
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[str] status: The status.
        :param pulumi.Input[str] sync_architecture: The sync architecture. Valid values: `oneway`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MigrationInstanceState.__new__(_MigrationInstanceState)

        __props__.__dict__["compute_unit"] = compute_unit
        __props__.__dict__["database_count"] = database_count
        __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
        __props__.__dict__["destination_endpoint_region"] = destination_endpoint_region
        __props__.__dict__["dts_instance_id"] = dts_instance_id
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
        __props__.__dict__["source_endpoint_region"] = source_endpoint_region
        __props__.__dict__["status"] = status
        __props__.__dict__["sync_architecture"] = sync_architecture
        __props__.__dict__["tags"] = tags
        return MigrationInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> pulumi.Output[Optional[int]]:
        """
        [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        """
        return pulumi.get(self, "compute_unit")

    @property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> pulumi.Output[Optional[int]]:
        """
        The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        """
        return pulumi.get(self, "database_count")

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> pulumi.Output[str]:
        """
        The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> pulumi.Output[str]:
        """
        The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        """
        return pulumi.get(self, "destination_endpoint_region")

    @property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the Migration Instance.
        """
        return pulumi.get(self, "dts_instance_id")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[str]:
        """
        The instance class. Valid values: `large`, `medium`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> pulumi.Output[str]:
        """
        The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> pulumi.Output[str]:
        """
        The region of source instance.
        """
        return pulumi.get(self, "source_endpoint_region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> pulumi.Output[Optional[str]]:
        """
        The sync architecture. Valid values: `oneway`.
        """
        return pulumi.get(self, "sync_architecture")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

