# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetConsumerChannelsChannelResult',
    'GetInstancesInstanceResult',
    'GetMigrationJobsJobResult',
    'GetSubscriptionJobsJobResult',
    'GetSubscriptionJobsJobSubscriptionHostResult',
    'GetSynchronizationJobsJobResult',
]

@pulumi.output_type
class GetConsumerChannelsChannelResult(dict):
    def __init__(__self__, *,
                 consumer_group_id: str,
                 consumer_group_name: str,
                 consumer_group_user_name: str,
                 consumption_checkpoint: str,
                 id: str,
                 message_delay: int,
                 unconsumed_data: int):
        """
        :param str consumer_group_id: The ID of the consumer group.
        :param str consumer_group_name: The name of the consumer group.
        :param str consumer_group_user_name: The username of the consumer group.
        :param str consumption_checkpoint: The time point when the client consumed the last message in the subscription channel.
        :param str id: The ID of the Consumer Channel.
        :param int message_delay: The message delay time, for the current time data subscription channel in the earliest time of unconsumed messages of the difference, in Unix timestamp format, which is measured in seconds.
        :param int unconsumed_data: The total number of unconsumed messages.
        """
        pulumi.set(__self__, "consumer_group_id", consumer_group_id)
        pulumi.set(__self__, "consumer_group_name", consumer_group_name)
        pulumi.set(__self__, "consumer_group_user_name", consumer_group_user_name)
        pulumi.set(__self__, "consumption_checkpoint", consumption_checkpoint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message_delay", message_delay)
        pulumi.set(__self__, "unconsumed_data", unconsumed_data)

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> str:
        """
        The ID of the consumer group.
        """
        return pulumi.get(self, "consumer_group_id")

    @property
    @pulumi.getter(name="consumerGroupName")
    def consumer_group_name(self) -> str:
        """
        The name of the consumer group.
        """
        return pulumi.get(self, "consumer_group_name")

    @property
    @pulumi.getter(name="consumerGroupUserName")
    def consumer_group_user_name(self) -> str:
        """
        The username of the consumer group.
        """
        return pulumi.get(self, "consumer_group_user_name")

    @property
    @pulumi.getter(name="consumptionCheckpoint")
    def consumption_checkpoint(self) -> str:
        """
        The time point when the client consumed the last message in the subscription channel.
        """
        return pulumi.get(self, "consumption_checkpoint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Consumer Channel.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="messageDelay")
    def message_delay(self) -> int:
        """
        The message delay time, for the current time data subscription channel in the earliest time of unconsumed messages of the difference, in Unix timestamp format, which is measured in seconds.
        """
        return pulumi.get(self, "message_delay")

    @property
    @pulumi.getter(name="unconsumedData")
    def unconsumed_data(self) -> int:
        """
        The total number of unconsumed messages.
        """
        return pulumi.get(self, "unconsumed_data")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 destination_endpoint_engine_name: str,
                 destination_region: str,
                 dts_instance_id: str,
                 id: str,
                 instance_class: str,
                 instance_name: str,
                 payment_type: str,
                 resource_group_id: str,
                 source_endpoint_engine_name: str,
                 source_region: str,
                 status: str,
                 type: str,
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param str create_time: Instance creation time
        :param str destination_endpoint_engine_name: The target database engine type.
        :param str destination_region: The destination instance region.
        :param str dts_instance_id: The ID of the subscription instance.
        :param str id: The ID of the instance.
        :param str instance_class: The type of the migration or synchronization instance.- The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.- The types of synchronization instances: **large**, **medium**, **small**, **micro**.
        :param str payment_type: The payment type of the resource.
        :param str resource_group_id: Resource Group ID
        :param str source_endpoint_engine_name: Source instance database engine type.
        :param str source_region: The source instance region.
        :param str status: Instance status.
        :param str type: The instance type. Valid values: -**MIGRATION**: MIGRATION.-**SYNC**: synchronization.-**SUBSCRIBE**: SUBSCRIBE.
        :param Mapping[str, Any] tags: The tag value corresponding to the tag key.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        pulumi.set(__self__, "destination_region", destination_region)
        pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_class", instance_class)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        pulumi.set(__self__, "source_region", source_region)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Instance creation time
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> str:
        """
        The target database engine type.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> str:
        """
        The destination instance region.
        """
        return pulumi.get(self, "destination_region")

    @property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> str:
        """
        The ID of the subscription instance.
        """
        return pulumi.get(self, "dts_instance_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> str:
        """
        The type of the migration or synchronization instance.- The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.- The types of synchronization instances: **large**, **medium**, **small**, **micro**.
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        Resource Group ID
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> str:
        """
        Source instance database engine type.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> str:
        """
        The source instance region.
        """
        return pulumi.get(self, "source_region")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Instance status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The instance type. Valid values: -**MIGRATION**: MIGRATION.-**SYNC**: synchronization.-**SUBSCRIBE**: SUBSCRIBE.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        The tag value corresponding to the tag key.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetMigrationJobsJobResult(dict):
    def __init__(__self__, *,
                 data_initialization: bool,
                 data_synchronization: bool,
                 db_list: str,
                 destination_endpoint_data_base_name: str,
                 destination_endpoint_engine_name: str,
                 destination_endpoint_instance_id: str,
                 destination_endpoint_instance_type: str,
                 destination_endpoint_ip: str,
                 destination_endpoint_oracle_sid: str,
                 destination_endpoint_port: str,
                 destination_endpoint_region: str,
                 destination_endpoint_user_name: str,
                 dts_instance_id: str,
                 dts_job_id: str,
                 dts_job_name: str,
                 id: str,
                 payment_type: str,
                 source_endpoint_database_name: str,
                 source_endpoint_engine_name: str,
                 source_endpoint_instance_id: str,
                 source_endpoint_instance_type: str,
                 source_endpoint_ip: str,
                 source_endpoint_oracle_sid: str,
                 source_endpoint_owner_id: str,
                 source_endpoint_port: str,
                 source_endpoint_region: str,
                 source_endpoint_role: str,
                 source_endpoint_user_name: str,
                 status: str,
                 structure_initialization: bool):
        """
        :param bool data_initialization: Whether or not to execute DTS supports schema migration, full data migration, or full-data initialization.
        :param bool data_synchronization: Whether to perform incremental data migration for migration types or synchronization values include:
        :param str db_list: The Migration object, in the format of JSON strings.
        :param str destination_endpoint_data_base_name: The name of migrate the database.
        :param str destination_endpoint_engine_name: The type of destination database.
        :param str destination_endpoint_instance_id: The ID of destination instance.
        :param str destination_endpoint_instance_type: The type of destination instance.
        :param str destination_endpoint_ip: The ip of source endpoint.
        :param str destination_endpoint_oracle_sid: The SID of Oracle database.
        :param str destination_endpoint_port: The port of source endpoint.
        :param str destination_endpoint_region: The region of destination instance.
        :param str destination_endpoint_user_name: The username of database account.
        :param str dts_instance_id: The Migration instance ID. The ID of `dts.MigrationInstance`.
        :param str dts_job_id: The ID of the Migration Job.
        :param str dts_job_name: The name of synchronization job.
        :param str id: The ID of the Migration Job. Its value is same as `dts_job_id`.
        :param str payment_type: The payment type of the Migration Instance.
        :param str source_endpoint_database_name: The name of migrate the database.
        :param str source_endpoint_engine_name: The type of source database.
        :param str source_endpoint_instance_id: The ID of source instance.
        :param str source_endpoint_instance_type: The type of source instance.
        :param str source_endpoint_ip: The ip of source endpoint.
        :param str source_endpoint_oracle_sid: The SID of Oracle database.
        :param str source_endpoint_owner_id: The Alibaba Cloud account ID to which the source instance belongs.
        :param str source_endpoint_port: The port of source endpoint.
        :param str source_endpoint_region: The region of source instance.
        :param str source_endpoint_role: The name of the role configured for the cloud account to which the source instance belongs.
        :param str source_endpoint_user_name: The username of database account.
        :param str status: The status of the resource.
        :param bool structure_initialization: Whether to perform a database table structure to migrate or initialization.
        """
        pulumi.set(__self__, "data_initialization", data_initialization)
        pulumi.set(__self__, "data_synchronization", data_synchronization)
        pulumi.set(__self__, "db_list", db_list)
        pulumi.set(__self__, "destination_endpoint_data_base_name", destination_endpoint_data_base_name)
        pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        pulumi.set(__self__, "destination_endpoint_instance_id", destination_endpoint_instance_id)
        pulumi.set(__self__, "destination_endpoint_instance_type", destination_endpoint_instance_type)
        pulumi.set(__self__, "destination_endpoint_ip", destination_endpoint_ip)
        pulumi.set(__self__, "destination_endpoint_oracle_sid", destination_endpoint_oracle_sid)
        pulumi.set(__self__, "destination_endpoint_port", destination_endpoint_port)
        pulumi.set(__self__, "destination_endpoint_region", destination_endpoint_region)
        pulumi.set(__self__, "destination_endpoint_user_name", destination_endpoint_user_name)
        pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        pulumi.set(__self__, "dts_job_id", dts_job_id)
        pulumi.set(__self__, "dts_job_name", dts_job_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "source_endpoint_database_name", source_endpoint_database_name)
        pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        pulumi.set(__self__, "source_endpoint_instance_id", source_endpoint_instance_id)
        pulumi.set(__self__, "source_endpoint_instance_type", source_endpoint_instance_type)
        pulumi.set(__self__, "source_endpoint_ip", source_endpoint_ip)
        pulumi.set(__self__, "source_endpoint_oracle_sid", source_endpoint_oracle_sid)
        pulumi.set(__self__, "source_endpoint_owner_id", source_endpoint_owner_id)
        pulumi.set(__self__, "source_endpoint_port", source_endpoint_port)
        pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        pulumi.set(__self__, "source_endpoint_role", source_endpoint_role)
        pulumi.set(__self__, "source_endpoint_user_name", source_endpoint_user_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "structure_initialization", structure_initialization)

    @property
    @pulumi.getter(name="dataInitialization")
    def data_initialization(self) -> bool:
        """
        Whether or not to execute DTS supports schema migration, full data migration, or full-data initialization.
        """
        return pulumi.get(self, "data_initialization")

    @property
    @pulumi.getter(name="dataSynchronization")
    def data_synchronization(self) -> bool:
        """
        Whether to perform incremental data migration for migration types or synchronization values include:
        """
        return pulumi.get(self, "data_synchronization")

    @property
    @pulumi.getter(name="dbList")
    def db_list(self) -> str:
        """
        The Migration object, in the format of JSON strings.
        """
        return pulumi.get(self, "db_list")

    @property
    @pulumi.getter(name="destinationEndpointDataBaseName")
    def destination_endpoint_data_base_name(self) -> str:
        """
        The name of migrate the database.
        """
        return pulumi.get(self, "destination_endpoint_data_base_name")

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> str:
        """
        The type of destination database.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @property
    @pulumi.getter(name="destinationEndpointInstanceId")
    def destination_endpoint_instance_id(self) -> str:
        """
        The ID of destination instance.
        """
        return pulumi.get(self, "destination_endpoint_instance_id")

    @property
    @pulumi.getter(name="destinationEndpointInstanceType")
    def destination_endpoint_instance_type(self) -> str:
        """
        The type of destination instance.
        """
        return pulumi.get(self, "destination_endpoint_instance_type")

    @property
    @pulumi.getter(name="destinationEndpointIp")
    def destination_endpoint_ip(self) -> str:
        """
        The ip of source endpoint.
        """
        return pulumi.get(self, "destination_endpoint_ip")

    @property
    @pulumi.getter(name="destinationEndpointOracleSid")
    def destination_endpoint_oracle_sid(self) -> str:
        """
        The SID of Oracle database.
        """
        return pulumi.get(self, "destination_endpoint_oracle_sid")

    @property
    @pulumi.getter(name="destinationEndpointPort")
    def destination_endpoint_port(self) -> str:
        """
        The port of source endpoint.
        """
        return pulumi.get(self, "destination_endpoint_port")

    @property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> str:
        """
        The region of destination instance.
        """
        return pulumi.get(self, "destination_endpoint_region")

    @property
    @pulumi.getter(name="destinationEndpointUserName")
    def destination_endpoint_user_name(self) -> str:
        """
        The username of database account.
        """
        return pulumi.get(self, "destination_endpoint_user_name")

    @property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> str:
        """
        The Migration instance ID. The ID of `dts.MigrationInstance`.
        """
        return pulumi.get(self, "dts_instance_id")

    @property
    @pulumi.getter(name="dtsJobId")
    def dts_job_id(self) -> str:
        """
        The ID of the Migration Job.
        """
        return pulumi.get(self, "dts_job_id")

    @property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> str:
        """
        The name of synchronization job.
        """
        return pulumi.get(self, "dts_job_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Migration Job. Its value is same as `dts_job_id`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of the Migration Instance.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> str:
        """
        The name of migrate the database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> str:
        """
        The type of source database.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> str:
        """
        The ID of source instance.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> str:
        """
        The type of source instance.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> str:
        """
        The ip of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> str:
        """
        The SID of Oracle database.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> str:
        """
        The Alibaba Cloud account ID to which the source instance belongs.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> str:
        """
        The port of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_port")

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> str:
        """
        The region of source instance.
        """
        return pulumi.get(self, "source_endpoint_region")

    @property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> str:
        """
        The name of the role configured for the cloud account to which the source instance belongs.
        """
        return pulumi.get(self, "source_endpoint_role")

    @property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> str:
        """
        The username of database account.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="structureInitialization")
    def structure_initialization(self) -> bool:
        """
        Whether to perform a database table structure to migrate or initialization.
        """
        return pulumi.get(self, "structure_initialization")


@pulumi.output_type
class GetSubscriptionJobsJobResult(dict):
    def __init__(__self__, *,
                 checkpoint: str,
                 create_time: str,
                 db_list: str,
                 dts_instance_id: str,
                 dts_job_id: str,
                 dts_job_name: str,
                 expire_time: str,
                 id: str,
                 payment_type: str,
                 source_endpoint_database_name: str,
                 source_endpoint_engine_name: str,
                 source_endpoint_instance_id: str,
                 source_endpoint_instance_type: str,
                 source_endpoint_ip: str,
                 source_endpoint_oracle_sid: str,
                 source_endpoint_owner_id: str,
                 source_endpoint_port: str,
                 source_endpoint_region: str,
                 source_endpoint_role: str,
                 source_endpoint_user_name: str,
                 status: str,
                 subscription_data_type_ddl: bool,
                 subscription_data_type_dml: bool,
                 subscription_hosts: Sequence['outputs.GetSubscriptionJobsJobSubscriptionHostResult'],
                 subscription_instance_network_type: str,
                 subscription_instance_vpc_id: str,
                 subscription_instance_vswitch_id: str,
                 tags: Mapping[str, Any]):
        """
        :param str checkpoint: Subscription start time in Unix timestamp format.
        :param str create_time: The creation time of subscription job instance.
        :param str db_list: Subscription object, in the format of JSON strings.
        :param str dts_instance_id: The ID of subscription job instance.
        :param str dts_job_id: The ID of subscription job instance.
        :param str dts_job_name: The name of subscription job instance.
        :param str expire_time: The Expiration Time. Formatting with yyyy-MM-ddTHH:mm:ssZ(UTC time).
        :param str id: The ID of the Subscription Job.
        :param str payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param str source_endpoint_database_name: To subscribe to the name of the database.
        :param str source_endpoint_engine_name: The source database type value is MySQL or Oracle.
        :param str source_endpoint_instance_id: The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
        :param str source_endpoint_instance_type: The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
        :param str source_endpoint_ip: The IP of source endpoint.
        :param str source_endpoint_oracle_sid: The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param str source_endpoint_owner_id: The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
        :param str source_endpoint_port: The  port of source database.
        :param str source_endpoint_region: The region of source database.
        :param str source_endpoint_role: Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
        :param str source_endpoint_user_name: The username of source database instance account.
        :param str status: The status of the task. Valid values: `NotStarted`, `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state of `Normal` to start the job, and specify this state of `Abnormal` to stop the job.
        :param bool subscription_data_type_ddl: Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
        :param bool subscription_data_type_dml: Whether to subscribe the DML type of data. Valid values: `true`, `false`.
        :param Sequence['GetSubscriptionJobsJobSubscriptionHostArgs'] subscription_hosts: Network information.
        :param str subscription_instance_network_type: The type of subscription instance network. Valid value: `classic`, `vpc`.
        :param str subscription_instance_vpc_id: The ID of subscription instance vpc.
        :param str subscription_instance_vswitch_id: The ID of subscription instance vswitch.
        :param Mapping[str, Any] tags: The tag of the resource.
        """
        pulumi.set(__self__, "checkpoint", checkpoint)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "db_list", db_list)
        pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        pulumi.set(__self__, "dts_job_id", dts_job_id)
        pulumi.set(__self__, "dts_job_name", dts_job_name)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "source_endpoint_database_name", source_endpoint_database_name)
        pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        pulumi.set(__self__, "source_endpoint_instance_id", source_endpoint_instance_id)
        pulumi.set(__self__, "source_endpoint_instance_type", source_endpoint_instance_type)
        pulumi.set(__self__, "source_endpoint_ip", source_endpoint_ip)
        pulumi.set(__self__, "source_endpoint_oracle_sid", source_endpoint_oracle_sid)
        pulumi.set(__self__, "source_endpoint_owner_id", source_endpoint_owner_id)
        pulumi.set(__self__, "source_endpoint_port", source_endpoint_port)
        pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        pulumi.set(__self__, "source_endpoint_role", source_endpoint_role)
        pulumi.set(__self__, "source_endpoint_user_name", source_endpoint_user_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subscription_data_type_ddl", subscription_data_type_ddl)
        pulumi.set(__self__, "subscription_data_type_dml", subscription_data_type_dml)
        pulumi.set(__self__, "subscription_hosts", subscription_hosts)
        pulumi.set(__self__, "subscription_instance_network_type", subscription_instance_network_type)
        pulumi.set(__self__, "subscription_instance_vpc_id", subscription_instance_vpc_id)
        pulumi.set(__self__, "subscription_instance_vswitch_id", subscription_instance_vswitch_id)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def checkpoint(self) -> str:
        """
        Subscription start time in Unix timestamp format.
        """
        return pulumi.get(self, "checkpoint")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of subscription job instance.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dbList")
    def db_list(self) -> str:
        """
        Subscription object, in the format of JSON strings.
        """
        return pulumi.get(self, "db_list")

    @property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> str:
        """
        The ID of subscription job instance.
        """
        return pulumi.get(self, "dts_instance_id")

    @property
    @pulumi.getter(name="dtsJobId")
    def dts_job_id(self) -> str:
        """
        The ID of subscription job instance.
        """
        return pulumi.get(self, "dts_job_id")

    @property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> str:
        """
        The name of subscription job instance.
        """
        return pulumi.get(self, "dts_job_name")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The Expiration Time. Formatting with yyyy-MM-ddTHH:mm:ssZ(UTC time).
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Subscription Job.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> str:
        """
        To subscribe to the name of the database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> str:
        """
        The source database type value is MySQL or Oracle.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> str:
        """
        The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> str:
        """
        The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> str:
        """
        The IP of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> str:
        """
        The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> str:
        """
        The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> str:
        """
        The  port of source database.
        """
        return pulumi.get(self, "source_endpoint_port")

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> str:
        """
        The region of source database.
        """
        return pulumi.get(self, "source_endpoint_region")

    @property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> str:
        """
        Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
        """
        return pulumi.get(self, "source_endpoint_role")

    @property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> str:
        """
        The username of source database instance account.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the task. Valid values: `NotStarted`, `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state of `Normal` to start the job, and specify this state of `Abnormal` to stop the job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subscriptionDataTypeDdl")
    def subscription_data_type_ddl(self) -> bool:
        """
        Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "subscription_data_type_ddl")

    @property
    @pulumi.getter(name="subscriptionDataTypeDml")
    def subscription_data_type_dml(self) -> bool:
        """
        Whether to subscribe the DML type of data. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "subscription_data_type_dml")

    @property
    @pulumi.getter(name="subscriptionHosts")
    def subscription_hosts(self) -> Sequence['outputs.GetSubscriptionJobsJobSubscriptionHostResult']:
        """
        Network information.
        """
        return pulumi.get(self, "subscription_hosts")

    @property
    @pulumi.getter(name="subscriptionInstanceNetworkType")
    def subscription_instance_network_type(self) -> str:
        """
        The type of subscription instance network. Valid value: `classic`, `vpc`.
        """
        return pulumi.get(self, "subscription_instance_network_type")

    @property
    @pulumi.getter(name="subscriptionInstanceVpcId")
    def subscription_instance_vpc_id(self) -> str:
        """
        The ID of subscription instance vpc.
        """
        return pulumi.get(self, "subscription_instance_vpc_id")

    @property
    @pulumi.getter(name="subscriptionInstanceVswitchId")
    def subscription_instance_vswitch_id(self) -> str:
        """
        The ID of subscription instance vswitch.
        """
        return pulumi.get(self, "subscription_instance_vswitch_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetSubscriptionJobsJobSubscriptionHostResult(dict):
    def __init__(__self__, *,
                 private_host: str,
                 public_host: str,
                 vpc_host: str):
        """
        :param str private_host: Classic network address.
        :param str public_host: Public network address.
        :param str vpc_host: VPC network address.
        """
        pulumi.set(__self__, "private_host", private_host)
        pulumi.set(__self__, "public_host", public_host)
        pulumi.set(__self__, "vpc_host", vpc_host)

    @property
    @pulumi.getter(name="privateHost")
    def private_host(self) -> str:
        """
        Classic network address.
        """
        return pulumi.get(self, "private_host")

    @property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> str:
        """
        Public network address.
        """
        return pulumi.get(self, "public_host")

    @property
    @pulumi.getter(name="vpcHost")
    def vpc_host(self) -> str:
        """
        VPC network address.
        """
        return pulumi.get(self, "vpc_host")


@pulumi.output_type
class GetSynchronizationJobsJobResult(dict):
    def __init__(__self__, *,
                 checkpoint: str,
                 create_time: str,
                 data_initialization: bool,
                 data_synchronization: bool,
                 db_list: str,
                 destination_endpoint_data_base_name: str,
                 destination_endpoint_engine_name: str,
                 destination_endpoint_instance_id: str,
                 destination_endpoint_instance_type: str,
                 destination_endpoint_ip: str,
                 destination_endpoint_oracle_sid: str,
                 destination_endpoint_port: str,
                 destination_endpoint_region: str,
                 destination_endpoint_user_name: str,
                 dts_instance_id: str,
                 dts_job_id: str,
                 dts_job_name: str,
                 expire_time: str,
                 id: str,
                 source_endpoint_database_name: str,
                 source_endpoint_engine_name: str,
                 source_endpoint_instance_id: str,
                 source_endpoint_instance_type: str,
                 source_endpoint_ip: str,
                 source_endpoint_oracle_sid: str,
                 source_endpoint_owner_id: str,
                 source_endpoint_port: str,
                 source_endpoint_region: str,
                 source_endpoint_role: str,
                 source_endpoint_user_name: str,
                 status: str,
                 structure_initialization: bool,
                 synchronization_direction: str):
        """
        :param str checkpoint: Start time in Unix timestamp format.
        :param bool data_initialization: Whether to execute DTS supports schema migration, full data migration, or full-data initialization.
        :param bool data_synchronization: Whether to perform incremental data migration for migration types or synchronization.
        :param str db_list: Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html).
        :param str destination_endpoint_data_base_name: The name of migrate the database.
        :param str destination_endpoint_engine_name: The type of destination database. Valid values: `ADB20`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        :param str destination_endpoint_instance_id: The ID of destination instance.
        :param str destination_endpoint_instance_type: The type of destination instance. Valid values: `ads`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param str destination_endpoint_ip: The ip of source endpoint.
        :param str destination_endpoint_oracle_sid: The SID of Oracle database.
        :param str destination_endpoint_port: The port of source endpoint.
        :param str destination_endpoint_region: The region of destination instance.
        :param str destination_endpoint_user_name: The username of database account.
        :param str dts_job_name: The name of synchronization job.
        :param str id: The ID of synchronizing instance. It's the ID of resource `dts.SynchronizationInstance`.
        :param str source_endpoint_database_name: The name of migrate the database.
        :param str source_endpoint_engine_name: The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        :param str source_endpoint_instance_id: The ID of source instance.
        :param str source_endpoint_instance_type: The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param str source_endpoint_ip: The ip of source endpoint.
        :param str source_endpoint_oracle_sid: The SID of Oracle database.
        :param str source_endpoint_owner_id: The Alibaba Cloud account ID to which the source instance belongs.
        :param str source_endpoint_port: The port of source endpoint.
        :param str source_endpoint_region: The region of source instance.
        :param str source_endpoint_role: The name of the role configured for the cloud account to which the source instance belongs.
        :param str source_endpoint_user_name: The username of database account.
        :param str status: The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
        :param bool structure_initialization: Whether to perform a database table structure to migrate or initialization values include:
        :param str synchronization_direction: Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
        """
        pulumi.set(__self__, "checkpoint", checkpoint)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_initialization", data_initialization)
        pulumi.set(__self__, "data_synchronization", data_synchronization)
        pulumi.set(__self__, "db_list", db_list)
        pulumi.set(__self__, "destination_endpoint_data_base_name", destination_endpoint_data_base_name)
        pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        pulumi.set(__self__, "destination_endpoint_instance_id", destination_endpoint_instance_id)
        pulumi.set(__self__, "destination_endpoint_instance_type", destination_endpoint_instance_type)
        pulumi.set(__self__, "destination_endpoint_ip", destination_endpoint_ip)
        pulumi.set(__self__, "destination_endpoint_oracle_sid", destination_endpoint_oracle_sid)
        pulumi.set(__self__, "destination_endpoint_port", destination_endpoint_port)
        pulumi.set(__self__, "destination_endpoint_region", destination_endpoint_region)
        pulumi.set(__self__, "destination_endpoint_user_name", destination_endpoint_user_name)
        pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        pulumi.set(__self__, "dts_job_id", dts_job_id)
        pulumi.set(__self__, "dts_job_name", dts_job_name)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "source_endpoint_database_name", source_endpoint_database_name)
        pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        pulumi.set(__self__, "source_endpoint_instance_id", source_endpoint_instance_id)
        pulumi.set(__self__, "source_endpoint_instance_type", source_endpoint_instance_type)
        pulumi.set(__self__, "source_endpoint_ip", source_endpoint_ip)
        pulumi.set(__self__, "source_endpoint_oracle_sid", source_endpoint_oracle_sid)
        pulumi.set(__self__, "source_endpoint_owner_id", source_endpoint_owner_id)
        pulumi.set(__self__, "source_endpoint_port", source_endpoint_port)
        pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        pulumi.set(__self__, "source_endpoint_role", source_endpoint_role)
        pulumi.set(__self__, "source_endpoint_user_name", source_endpoint_user_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "structure_initialization", structure_initialization)
        pulumi.set(__self__, "synchronization_direction", synchronization_direction)

    @property
    @pulumi.getter
    def checkpoint(self) -> str:
        """
        Start time in Unix timestamp format.
        """
        return pulumi.get(self, "checkpoint")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataInitialization")
    def data_initialization(self) -> bool:
        """
        Whether to execute DTS supports schema migration, full data migration, or full-data initialization.
        """
        return pulumi.get(self, "data_initialization")

    @property
    @pulumi.getter(name="dataSynchronization")
    def data_synchronization(self) -> bool:
        """
        Whether to perform incremental data migration for migration types or synchronization.
        """
        return pulumi.get(self, "data_synchronization")

    @property
    @pulumi.getter(name="dbList")
    def db_list(self) -> str:
        """
        Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html).
        """
        return pulumi.get(self, "db_list")

    @property
    @pulumi.getter(name="destinationEndpointDataBaseName")
    def destination_endpoint_data_base_name(self) -> str:
        """
        The name of migrate the database.
        """
        return pulumi.get(self, "destination_endpoint_data_base_name")

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> str:
        """
        The type of destination database. Valid values: `ADB20`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @property
    @pulumi.getter(name="destinationEndpointInstanceId")
    def destination_endpoint_instance_id(self) -> str:
        """
        The ID of destination instance.
        """
        return pulumi.get(self, "destination_endpoint_instance_id")

    @property
    @pulumi.getter(name="destinationEndpointInstanceType")
    def destination_endpoint_instance_type(self) -> str:
        """
        The type of destination instance. Valid values: `ads`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "destination_endpoint_instance_type")

    @property
    @pulumi.getter(name="destinationEndpointIp")
    def destination_endpoint_ip(self) -> str:
        """
        The ip of source endpoint.
        """
        return pulumi.get(self, "destination_endpoint_ip")

    @property
    @pulumi.getter(name="destinationEndpointOracleSid")
    def destination_endpoint_oracle_sid(self) -> str:
        """
        The SID of Oracle database.
        """
        return pulumi.get(self, "destination_endpoint_oracle_sid")

    @property
    @pulumi.getter(name="destinationEndpointPort")
    def destination_endpoint_port(self) -> str:
        """
        The port of source endpoint.
        """
        return pulumi.get(self, "destination_endpoint_port")

    @property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> str:
        """
        The region of destination instance.
        """
        return pulumi.get(self, "destination_endpoint_region")

    @property
    @pulumi.getter(name="destinationEndpointUserName")
    def destination_endpoint_user_name(self) -> str:
        """
        The username of database account.
        """
        return pulumi.get(self, "destination_endpoint_user_name")

    @property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> str:
        return pulumi.get(self, "dts_instance_id")

    @property
    @pulumi.getter(name="dtsJobId")
    def dts_job_id(self) -> str:
        return pulumi.get(self, "dts_job_id")

    @property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> str:
        """
        The name of synchronization job.
        """
        return pulumi.get(self, "dts_job_name")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of synchronizing instance. It's the ID of resource `dts.SynchronizationInstance`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> str:
        """
        The name of migrate the database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> str:
        """
        The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> str:
        """
        The ID of source instance.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> str:
        """
        The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> str:
        """
        The ip of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> str:
        """
        The SID of Oracle database.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> str:
        """
        The Alibaba Cloud account ID to which the source instance belongs.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> str:
        """
        The port of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_port")

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> str:
        """
        The region of source instance.
        """
        return pulumi.get(self, "source_endpoint_region")

    @property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> str:
        """
        The name of the role configured for the cloud account to which the source instance belongs.
        """
        return pulumi.get(self, "source_endpoint_role")

    @property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> str:
        """
        The username of database account.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="structureInitialization")
    def structure_initialization(self) -> bool:
        """
        Whether to perform a database table structure to migrate or initialization values include:
        """
        return pulumi.get(self, "structure_initialization")

    @property
    @pulumi.getter(name="synchronizationDirection")
    def synchronization_direction(self) -> str:
        """
        Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
        """
        return pulumi.get(self, "synchronization_direction")


