# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SynchronizationInstanceArgs', 'SynchronizationInstance']

@pulumi.input_type
class SynchronizationInstanceArgs:
    def __init__(__self__, *,
                 destination_endpoint_engine_name: pulumi.Input[str],
                 destination_endpoint_region: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 source_endpoint_engine_name: pulumi.Input[str],
                 source_endpoint_region: pulumi.Input[str],
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_start: Optional[pulumi.Input[str]] = None,
                 compute_unit: Optional[pulumi.Input[int]] = None,
                 database_count: Optional[pulumi.Input[int]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 payment_duration: Optional[pulumi.Input[int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[str]] = None,
                 quantity: Optional[pulumi.Input[int]] = None,
                 sync_architecture: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SynchronizationInstance resource.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[str] auto_pay: Whether to automatically renew when it expires. Valid values: `true`, `false`.
        :param pulumi.Input[str] auto_start: Whether to automatically start the task after the purchase completed. Valid values: `true`, `false`.
        :param pulumi.Input[int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[int] payment_duration: The duration of prepaid instance purchase. this parameter is required When `payment_type` equals `Subscription`.
        :param pulumi.Input[str] payment_duration_unit: The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[int] quantity: The number of instances purchased.
        :param pulumi.Input[str] sync_architecture: The sync architecture. Valid values: `oneway`, `bidirectional`.
        """
        pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        pulumi.set(__self__, "destination_endpoint_region", destination_endpoint_region)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_start is not None:
            pulumi.set(__self__, "auto_start", auto_start)
        if compute_unit is not None:
            pulumi.set(__self__, "compute_unit", compute_unit)
        if database_count is not None:
            pulumi.set(__self__, "database_count", database_count)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if payment_duration is not None:
            pulumi.set(__self__, "payment_duration", payment_duration)
        if payment_duration_unit is not None:
            pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)
        if sync_architecture is not None:
            pulumi.set(__self__, "sync_architecture", sync_architecture)

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> pulumi.Input[str]:
        """
        The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> pulumi.Input[str]:
        """
        The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        """
        return pulumi.get(self, "destination_endpoint_region")

    @destination_endpoint_region.setter
    def destination_endpoint_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_endpoint_region", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> pulumi.Input[str]:
        """
        The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> pulumi.Input[str]:
        """
        The region of source instance.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_endpoint_region", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to automatically renew when it expires. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoStart")
    def auto_start(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to automatically start the task after the purchase completed. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_start")

    @auto_start.setter
    def auto_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_start", value)

    @property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> Optional[pulumi.Input[int]]:
        """
        [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        """
        return pulumi.get(self, "compute_unit")

    @compute_unit.setter
    def compute_unit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_unit", value)

    @property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        """
        return pulumi.get(self, "database_count")

    @database_count.setter
    def database_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "database_count", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[str]]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of prepaid instance purchase. this parameter is required When `payment_type` equals `Subscription`.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "payment_duration", value)

    @property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_duration_unit", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of instances purchased.
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quantity", value)

    @property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> Optional[pulumi.Input[str]]:
        """
        The sync architecture. Valid values: `oneway`, `bidirectional`.
        """
        return pulumi.get(self, "sync_architecture")

    @sync_architecture.setter
    def sync_architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_architecture", value)


@pulumi.input_type
class _SynchronizationInstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_start: Optional[pulumi.Input[str]] = None,
                 compute_unit: Optional[pulumi.Input[int]] = None,
                 database_count: Optional[pulumi.Input[int]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 payment_duration: Optional[pulumi.Input[int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 quantity: Optional[pulumi.Input[int]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sync_architecture: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SynchronizationInstance resources.
        :param pulumi.Input[str] auto_pay: Whether to automatically renew when it expires. Valid values: `true`, `false`.
        :param pulumi.Input[str] auto_start: Whether to automatically start the task after the purchase completed. Valid values: `true`, `false`.
        :param pulumi.Input[int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[int] payment_duration: The duration of prepaid instance purchase. this parameter is required When `payment_type` equals `Subscription`.
        :param pulumi.Input[str] payment_duration_unit: The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[int] quantity: The number of instances purchased.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[str] status: The status.
        :param pulumi.Input[str] sync_architecture: The sync architecture. Valid values: `oneway`, `bidirectional`.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_start is not None:
            pulumi.set(__self__, "auto_start", auto_start)
        if compute_unit is not None:
            pulumi.set(__self__, "compute_unit", compute_unit)
        if database_count is not None:
            pulumi.set(__self__, "database_count", database_count)
        if destination_endpoint_engine_name is not None:
            pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        if destination_endpoint_region is not None:
            pulumi.set(__self__, "destination_endpoint_region", destination_endpoint_region)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if payment_duration is not None:
            pulumi.set(__self__, "payment_duration", payment_duration)
        if payment_duration_unit is not None:
            pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)
        if source_endpoint_engine_name is not None:
            pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        if source_endpoint_region is not None:
            pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sync_architecture is not None:
            pulumi.set(__self__, "sync_architecture", sync_architecture)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to automatically renew when it expires. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoStart")
    def auto_start(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to automatically start the task after the purchase completed. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_start")

    @auto_start.setter
    def auto_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_start", value)

    @property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> Optional[pulumi.Input[int]]:
        """
        [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        """
        return pulumi.get(self, "compute_unit")

    @compute_unit.setter
    def compute_unit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_unit", value)

    @property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        """
        return pulumi.get(self, "database_count")

    @database_count.setter
    def database_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "database_count", value)

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> Optional[pulumi.Input[str]]:
        """
        The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        """
        return pulumi.get(self, "destination_endpoint_region")

    @destination_endpoint_region.setter
    def destination_endpoint_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_region", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[str]]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of prepaid instance purchase. this parameter is required When `payment_type` equals `Subscription`.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "payment_duration", value)

    @property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_duration_unit", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of instances purchased.
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quantity", value)

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> Optional[pulumi.Input[str]]:
        """
        The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of source instance.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> Optional[pulumi.Input[str]]:
        """
        The sync architecture. Valid values: `oneway`, `bidirectional`.
        """
        return pulumi.get(self, "sync_architecture")

    @sync_architecture.setter
    def sync_architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_architecture", value)


class SynchronizationInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_start: Optional[pulumi.Input[str]] = None,
                 compute_unit: Optional[pulumi.Input[int]] = None,
                 database_count: Optional[pulumi.Input[int]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 payment_duration: Optional[pulumi.Input[int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 quantity: Optional[pulumi.Input[int]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[str]] = None,
                 sync_architecture: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a DTS Synchronization Instance resource.

        For information about DTS Synchronization Instance and how to use it, see [What is Synchronization Instance](https://www.alibabacloud.com/help/en/doc-detail/130744.html).

        > **NOTE:** Available since v1.138.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_regions = alicloud.get_regions(current=True)
        default_synchronization_instance = alicloud.dts.SynchronizationInstance("defaultSynchronizationInstance",
            payment_type="PayAsYouGo",
            source_endpoint_engine_name="MySQL",
            source_endpoint_region=default_regions.regions[0].id,
            destination_endpoint_engine_name="MySQL",
            destination_endpoint_region=default_regions.regions[0].id,
            instance_class="small",
            sync_architecture="oneway")
        ```

        ## Import

        DTS Synchronization Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dts/synchronizationInstance:SynchronizationInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_pay: Whether to automatically renew when it expires. Valid values: `true`, `false`.
        :param pulumi.Input[str] auto_start: Whether to automatically start the task after the purchase completed. Valid values: `true`, `false`.
        :param pulumi.Input[int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[int] payment_duration: The duration of prepaid instance purchase. this parameter is required When `payment_type` equals `Subscription`.
        :param pulumi.Input[str] payment_duration_unit: The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[int] quantity: The number of instances purchased.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[str] sync_architecture: The sync architecture. Valid values: `oneway`, `bidirectional`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SynchronizationInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DTS Synchronization Instance resource.

        For information about DTS Synchronization Instance and how to use it, see [What is Synchronization Instance](https://www.alibabacloud.com/help/en/doc-detail/130744.html).

        > **NOTE:** Available since v1.138.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_regions = alicloud.get_regions(current=True)
        default_synchronization_instance = alicloud.dts.SynchronizationInstance("defaultSynchronizationInstance",
            payment_type="PayAsYouGo",
            source_endpoint_engine_name="MySQL",
            source_endpoint_region=default_regions.regions[0].id,
            destination_endpoint_engine_name="MySQL",
            destination_endpoint_region=default_regions.regions[0].id,
            instance_class="small",
            sync_architecture="oneway")
        ```

        ## Import

        DTS Synchronization Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dts/synchronizationInstance:SynchronizationInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SynchronizationInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SynchronizationInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_start: Optional[pulumi.Input[str]] = None,
                 compute_unit: Optional[pulumi.Input[int]] = None,
                 database_count: Optional[pulumi.Input[int]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 payment_duration: Optional[pulumi.Input[int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 quantity: Optional[pulumi.Input[int]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[str]] = None,
                 sync_architecture: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SynchronizationInstanceArgs.__new__(SynchronizationInstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_start"] = auto_start
            __props__.__dict__["compute_unit"] = compute_unit
            __props__.__dict__["database_count"] = database_count
            if destination_endpoint_engine_name is None and not opts.urn:
                raise TypeError("Missing required property 'destination_endpoint_engine_name'")
            __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
            if destination_endpoint_region is None and not opts.urn:
                raise TypeError("Missing required property 'destination_endpoint_region'")
            __props__.__dict__["destination_endpoint_region"] = destination_endpoint_region
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["payment_duration"] = payment_duration
            __props__.__dict__["payment_duration_unit"] = payment_duration_unit
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["quantity"] = quantity
            if source_endpoint_engine_name is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_engine_name'")
            __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
            if source_endpoint_region is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_region'")
            __props__.__dict__["source_endpoint_region"] = source_endpoint_region
            __props__.__dict__["sync_architecture"] = sync_architecture
            __props__.__dict__["status"] = None
        super(SynchronizationInstance, __self__).__init__(
            'alicloud:dts/synchronizationInstance:SynchronizationInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[str]] = None,
            auto_start: Optional[pulumi.Input[str]] = None,
            compute_unit: Optional[pulumi.Input[int]] = None,
            database_count: Optional[pulumi.Input[int]] = None,
            destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
            destination_endpoint_region: Optional[pulumi.Input[str]] = None,
            instance_class: Optional[pulumi.Input[str]] = None,
            payment_duration: Optional[pulumi.Input[int]] = None,
            payment_duration_unit: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            quantity: Optional[pulumi.Input[int]] = None,
            source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
            source_endpoint_region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            sync_architecture: Optional[pulumi.Input[str]] = None) -> 'SynchronizationInstance':
        """
        Get an existing SynchronizationInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_pay: Whether to automatically renew when it expires. Valid values: `true`, `false`.
        :param pulumi.Input[str] auto_start: Whether to automatically start the task after the purchase completed. Valid values: `true`, `false`.
        :param pulumi.Input[int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[int] payment_duration: The duration of prepaid instance purchase. this parameter is required When `payment_type` equals `Subscription`.
        :param pulumi.Input[str] payment_duration_unit: The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[int] quantity: The number of instances purchased.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        :param pulumi.Input[str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[str] status: The status.
        :param pulumi.Input[str] sync_architecture: The sync architecture. Valid values: `oneway`, `bidirectional`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SynchronizationInstanceState.__new__(_SynchronizationInstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_start"] = auto_start
        __props__.__dict__["compute_unit"] = compute_unit
        __props__.__dict__["database_count"] = database_count
        __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
        __props__.__dict__["destination_endpoint_region"] = destination_endpoint_region
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["payment_duration"] = payment_duration
        __props__.__dict__["payment_duration_unit"] = payment_duration_unit
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["quantity"] = quantity
        __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
        __props__.__dict__["source_endpoint_region"] = source_endpoint_region
        __props__.__dict__["status"] = status
        __props__.__dict__["sync_architecture"] = sync_architecture
        return SynchronizationInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to automatically renew when it expires. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoStart")
    def auto_start(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to automatically start the task after the purchase completed. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_start")

    @property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> pulumi.Output[Optional[int]]:
        """
        [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        """
        return pulumi.get(self, "compute_unit")

    @property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> pulumi.Output[Optional[int]]:
        """
        The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        """
        return pulumi.get(self, "database_count")

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> pulumi.Output[str]:
        """
        The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> pulumi.Output[str]:
        """
        The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        """
        return pulumi.get(self, "destination_endpoint_region")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[str]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> pulumi.Output[Optional[int]]:
        """
        The duration of prepaid instance purchase. this parameter is required When `payment_type` equals `Subscription`.
        """
        return pulumi.get(self, "payment_duration")

    @property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> pulumi.Output[Optional[str]]:
        """
        The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        """
        return pulumi.get(self, "payment_duration_unit")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def quantity(self) -> pulumi.Output[Optional[int]]:
        """
        The number of instances purchased.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> pulumi.Output[str]:
        """
        The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help.aliyun.com/document_detail/130744.html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> pulumi.Output[str]:
        """
        The region of source instance.
        """
        return pulumi.get(self, "source_endpoint_region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> pulumi.Output[Optional[str]]:
        """
        The sync architecture. Valid values: `oneway`, `bidirectional`.
        """
        return pulumi.get(self, "sync_architecture")

