# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SynchronizationJobArgs', 'SynchronizationJob']

@pulumi.input_type
class SynchronizationJobArgs:
    def __init__(__self__, *,
                 data_initialization: pulumi.Input[bool],
                 data_synchronization: pulumi.Input[bool],
                 db_list: pulumi.Input[str],
                 destination_endpoint_engine_name: pulumi.Input[str],
                 destination_endpoint_instance_type: pulumi.Input[str],
                 dts_instance_id: pulumi.Input[str],
                 dts_job_name: pulumi.Input[str],
                 source_endpoint_engine_name: pulumi.Input[str],
                 source_endpoint_instance_type: pulumi.Input[str],
                 structure_initialization: pulumi.Input[bool],
                 checkpoint: Optional[pulumi.Input[str]] = None,
                 data_check_configure: Optional[pulumi.Input[str]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[str]] = None,
                 delay_notice: Optional[pulumi.Input[bool]] = None,
                 delay_phone: Optional[pulumi.Input[str]] = None,
                 delay_rule_time: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_database_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_instance_id: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_oracle_sid: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_owner_id: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_password: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_port: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_role: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_user_name: Optional[pulumi.Input[str]] = None,
                 dts_bis_label: Optional[pulumi.Input[str]] = None,
                 error_notice: Optional[pulumi.Input[bool]] = None,
                 error_phone: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 reserve: Optional[pulumi.Input[str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_vswitch_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 synchronization_direction: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SynchronizationJob resource.
        :param pulumi.Input[bool] data_initialization: Whether to perform full data migration or full data initialization. Valid values: `true`, `false`.
        :param pulumi.Input[bool] data_synchronization: Whether to perform incremental data migration or synchronization. Valid values: `true`, `false`.
        :param pulumi.Input[str] db_list: Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html). **NOTE:** From version 1.173.0, `db_list` can be modified.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination database. The default value is MYSQL. For the correspondence between supported target libraries and source libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the target instance is KAFKA or MONGODB, you also need to pass in some information in the reserved parameter `reserve`. For the configuration method, see the description of `reserve` parameters. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        :param pulumi.Input[str] destination_endpoint_instance_type: The type of destination instance. If the target instance is a PolarDB O engine cluster, the target instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. If the target instance is the Kafka version of Message Queuing, the target instance type needs to be `ECS` or `EXPRESS` as a self-built database, and access via ECS or dedicated line. For the correspondence between supported targets and source instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the target instance is a self-built database, you also need to perform corresponding preparations, please refer to the [overview of preparations](https://help.aliyun.com/document_detail/146958.htm). Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[str] dts_instance_id: The ID of synchronization instance, it must be an ID of `dts.SynchronizationInstance`.
        :param pulumi.Input[str] dts_job_name: The name of synchronization job.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source database. The default value is `MySQL`. For the correspondence between supported source libraries and target libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the source instance is `MONGODB`, you also need to pass in some information in the reserved parameter `Reserve`, for the configuration method, see the description of Reserve parameters. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        :param pulumi.Input[str] source_endpoint_instance_type: The type of source instance. If the source instance is a `PolarDB O` engine cluster, the source instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. For the correspondence between supported source and target instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the source instance is a self-built database, you also need to perform corresponding preparations, for details, see [Preparations Overview](https://help.aliyun.com/document_detail/146958.htm). Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[bool] structure_initialization: Whether to perform library table structure migration or initialization. Valid values: `true`, `false`.
        :param pulumi.Input[str] checkpoint: The start point or synchronization point of incremental data migration, the format is Unix timestamp, and the unit is seconds.
        :param pulumi.Input[str] data_check_configure: The data verification task of the migration or synchronization instance, in the format of a JSON string, such as parameter limits or alarm configurations. For more information, see the DataCheckConfigure parameter description [datacheckconfigure-parameter](https://help.aliyun.com/zh/dts/developer-reference/datacheckconfigure-parameter).
        :param pulumi.Input[str] dedicated_cluster_id: When the ID of the dedicated cluster is input, the task is scheduled to the corresponding cluster.
        :param pulumi.Input[bool] delay_notice: The delay notice. Valid values: `true`, `false`.
        :param pulumi.Input[str] delay_phone: The delay phone. The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[str] delay_rule_time: The delay rule time. When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        :param pulumi.Input[str] destination_endpoint_database_name: The name of the database to which the migration object belongs in the target instance. Note: when the target instance or target database type is PolarDB O engine, AnalyticDB PostgreSQL, PostgreSQL, MongoDB database, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_instance_id: The ID of destination instance. If the target instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the target instance is a self-built database, the value of this parameter changes according to the value of `destination_endpoint_instance_type`. For example, the value of `destination_endpoint_instance_type` is:
               ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
               ** `DG`, then this parameter needs to be passed into the ID of database gateway.
               ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        :param pulumi.Input[str] destination_endpoint_ip: The IP of source endpoint. When `destination_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_oracle_sid: The SID of Oracle database. Note: when the value of DestinationEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_owner_id: The ID of the Alibaba Cloud account to which the target RDS MySQL instance belongs. can be configured only when the target instance is RDS MySQL. This parameter is used to migrate or synchronize data across Alibaba Cloud accounts. You also need to enter the **destinationendpointrle** parameter.
        :param pulumi.Input[str] destination_endpoint_password: The password of database account.
        :param pulumi.Input[str] destination_endpoint_port: The port of source endpoint. When the target instance is a self-built database, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. For the target instance region, please refer to the [list of supported regions](https://help.aliyun.com/document_detail/141033.htm). Note: if the target is an Alibaba Cloud database, this parameter must be passed in.
        :param pulumi.Input[str] destination_endpoint_role: The role name of the Alibaba Cloud account to which the target instance belongs. This parameter must be entered when data migration or synchronization across Alibaba Cloud accounts is performed. For the permissions and authorization methods required by this role.
        :param pulumi.Input[str] destination_endpoint_user_name: The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        :param pulumi.Input[str] dts_bis_label: The environment label of the DTS instance. The value is: **normal**, **online**.
               
               > **NOTE:** From the status of `NotStarted` to `Synchronizing`, the resource goes through the `Prechecking` and `Initializing` phases. Because of the `Initializing` phase takes too long, and once the resource passes to the status of `Prechecking`, it can be considered that the task can be executed normally. Therefore, we treat the status of `Initializing` as an equivalent to `Synchronizing`.
               
               > **NOTE:** If you want to upgrade the synchronization job specifications by the property `instance_class`, you must also modify the property `instance_class` of it's instance to keep them consistent.
        :param pulumi.Input[bool] error_notice: The error notice. Valid values: `true`, `false`.
        :param pulumi.Input[str] error_phone: The error phone. The mobile phone number of the contact who error the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[str] reserve: DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter [description of the Reserve parameter](https://help.aliyun.com/document_detail/273111.html).
        :param pulumi.Input[str] source_endpoint_database_name: The name of the database to which the migration object belongs in the source instance. Note: this parameter is only available and must be passed in when the source instance, or the database type of the source instance is PolarDB O engine, PostgreSQL, or MongoDB database.
        :param pulumi.Input[str] source_endpoint_instance_id: The ID of source instance. If the source instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the source instance is a self-built database, the value of this parameter changes according to the value of `source_endpoint_instance_type`. For example, the value of `source_endpoint_instance_type` is:
               ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
               ** `DG`, then this parameter needs to be passed into the ID of database gateway.
               ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        :param pulumi.Input[str] source_endpoint_ip: The IP of source endpoint. When `source_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_oracle_sid: The SID of Oracle database. When the value of SourceEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_owner_id: The ID of Alibaba Cloud account to which the source instance belongs. Note: passing in this parameter means performing data migration or synchronization across Alibaba Cloud accounts, and you also need to pass in the `source_endpoint_role` parameter.
        :param pulumi.Input[str] source_endpoint_password: The password of database account.
        :param pulumi.Input[str] source_endpoint_port: The port of source endpoint. When the source instance is a self-built database, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_region: Source instance area, please refer to the [list of supported areas](https://help.aliyun.com/document_detail/141033.htm) for details. Note if the source is an Alibaba Cloud database, this parameter must be passed in.
        :param pulumi.Input[str] source_endpoint_role: The name of the role configured for the cloud account to which the source instance belongs. Note: this parameter must be passed in when performing cross Alibaba Cloud account data migration or synchronization. For the permissions and authorization methods required by this role, please refer to [How to configure RAM authorization when cross-Alibaba Cloud account data migration or synchronization](https://help.aliyun.com/document_detail/48468.htm).
        :param pulumi.Input[str] source_endpoint_user_name: The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        :param pulumi.Input[str] source_endpoint_vswitch_id: Data Delivery link switch instance id
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
        :param pulumi.Input[str] synchronization_direction: Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
        """
        pulumi.set(__self__, "data_initialization", data_initialization)
        pulumi.set(__self__, "data_synchronization", data_synchronization)
        pulumi.set(__self__, "db_list", db_list)
        pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        pulumi.set(__self__, "destination_endpoint_instance_type", destination_endpoint_instance_type)
        pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        pulumi.set(__self__, "dts_job_name", dts_job_name)
        pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        pulumi.set(__self__, "source_endpoint_instance_type", source_endpoint_instance_type)
        pulumi.set(__self__, "structure_initialization", structure_initialization)
        if checkpoint is not None:
            pulumi.set(__self__, "checkpoint", checkpoint)
        if data_check_configure is not None:
            pulumi.set(__self__, "data_check_configure", data_check_configure)
        if dedicated_cluster_id is not None:
            pulumi.set(__self__, "dedicated_cluster_id", dedicated_cluster_id)
        if delay_notice is not None:
            pulumi.set(__self__, "delay_notice", delay_notice)
        if delay_phone is not None:
            pulumi.set(__self__, "delay_phone", delay_phone)
        if delay_rule_time is not None:
            pulumi.set(__self__, "delay_rule_time", delay_rule_time)
        if destination_endpoint_database_name is not None:
            pulumi.set(__self__, "destination_endpoint_database_name", destination_endpoint_database_name)
        if destination_endpoint_instance_id is not None:
            pulumi.set(__self__, "destination_endpoint_instance_id", destination_endpoint_instance_id)
        if destination_endpoint_ip is not None:
            pulumi.set(__self__, "destination_endpoint_ip", destination_endpoint_ip)
        if destination_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "destination_endpoint_oracle_sid", destination_endpoint_oracle_sid)
        if destination_endpoint_owner_id is not None:
            pulumi.set(__self__, "destination_endpoint_owner_id", destination_endpoint_owner_id)
        if destination_endpoint_password is not None:
            pulumi.set(__self__, "destination_endpoint_password", destination_endpoint_password)
        if destination_endpoint_port is not None:
            pulumi.set(__self__, "destination_endpoint_port", destination_endpoint_port)
        if destination_endpoint_region is not None:
            pulumi.set(__self__, "destination_endpoint_region", destination_endpoint_region)
        if destination_endpoint_role is not None:
            pulumi.set(__self__, "destination_endpoint_role", destination_endpoint_role)
        if destination_endpoint_user_name is not None:
            pulumi.set(__self__, "destination_endpoint_user_name", destination_endpoint_user_name)
        if dts_bis_label is not None:
            pulumi.set(__self__, "dts_bis_label", dts_bis_label)
        if error_notice is not None:
            pulumi.set(__self__, "error_notice", error_notice)
        if error_phone is not None:
            pulumi.set(__self__, "error_phone", error_phone)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if reserve is not None:
            pulumi.set(__self__, "reserve", reserve)
        if source_endpoint_database_name is not None:
            pulumi.set(__self__, "source_endpoint_database_name", source_endpoint_database_name)
        if source_endpoint_instance_id is not None:
            pulumi.set(__self__, "source_endpoint_instance_id", source_endpoint_instance_id)
        if source_endpoint_ip is not None:
            pulumi.set(__self__, "source_endpoint_ip", source_endpoint_ip)
        if source_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "source_endpoint_oracle_sid", source_endpoint_oracle_sid)
        if source_endpoint_owner_id is not None:
            pulumi.set(__self__, "source_endpoint_owner_id", source_endpoint_owner_id)
        if source_endpoint_password is not None:
            pulumi.set(__self__, "source_endpoint_password", source_endpoint_password)
        if source_endpoint_port is not None:
            pulumi.set(__self__, "source_endpoint_port", source_endpoint_port)
        if source_endpoint_region is not None:
            pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if source_endpoint_role is not None:
            pulumi.set(__self__, "source_endpoint_role", source_endpoint_role)
        if source_endpoint_user_name is not None:
            pulumi.set(__self__, "source_endpoint_user_name", source_endpoint_user_name)
        if source_endpoint_vswitch_id is not None:
            pulumi.set(__self__, "source_endpoint_vswitch_id", source_endpoint_vswitch_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if synchronization_direction is not None:
            pulumi.set(__self__, "synchronization_direction", synchronization_direction)

    @property
    @pulumi.getter(name="dataInitialization")
    def data_initialization(self) -> pulumi.Input[bool]:
        """
        Whether to perform full data migration or full data initialization. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "data_initialization")

    @data_initialization.setter
    def data_initialization(self, value: pulumi.Input[bool]):
        pulumi.set(self, "data_initialization", value)

    @property
    @pulumi.getter(name="dataSynchronization")
    def data_synchronization(self) -> pulumi.Input[bool]:
        """
        Whether to perform incremental data migration or synchronization. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "data_synchronization")

    @data_synchronization.setter
    def data_synchronization(self, value: pulumi.Input[bool]):
        pulumi.set(self, "data_synchronization", value)

    @property
    @pulumi.getter(name="dbList")
    def db_list(self) -> pulumi.Input[str]:
        """
        Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html). **NOTE:** From version 1.173.0, `db_list` can be modified.
        """
        return pulumi.get(self, "db_list")

    @db_list.setter
    def db_list(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_list", value)

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> pulumi.Input[str]:
        """
        The type of destination database. The default value is MYSQL. For the correspondence between supported target libraries and source libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the target instance is KAFKA or MONGODB, you also need to pass in some information in the reserved parameter `reserve`. For the configuration method, see the description of `reserve` parameters. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="destinationEndpointInstanceType")
    def destination_endpoint_instance_type(self) -> pulumi.Input[str]:
        """
        The type of destination instance. If the target instance is a PolarDB O engine cluster, the target instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. If the target instance is the Kafka version of Message Queuing, the target instance type needs to be `ECS` or `EXPRESS` as a self-built database, and access via ECS or dedicated line. For the correspondence between supported targets and source instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the target instance is a self-built database, you also need to perform corresponding preparations, please refer to the [overview of preparations](https://help.aliyun.com/document_detail/146958.htm). Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "destination_endpoint_instance_type")

    @destination_endpoint_instance_type.setter
    def destination_endpoint_instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_endpoint_instance_type", value)

    @property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> pulumi.Input[str]:
        """
        The ID of synchronization instance, it must be an ID of `dts.SynchronizationInstance`.
        """
        return pulumi.get(self, "dts_instance_id")

    @dts_instance_id.setter
    def dts_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dts_instance_id", value)

    @property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> pulumi.Input[str]:
        """
        The name of synchronization job.
        """
        return pulumi.get(self, "dts_job_name")

    @dts_job_name.setter
    def dts_job_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "dts_job_name", value)

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> pulumi.Input[str]:
        """
        The type of source database. The default value is `MySQL`. For the correspondence between supported source libraries and target libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the source instance is `MONGODB`, you also need to pass in some information in the reserved parameter `Reserve`, for the configuration method, see the description of Reserve parameters. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> pulumi.Input[str]:
        """
        The type of source instance. If the source instance is a `PolarDB O` engine cluster, the source instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. For the correspondence between supported source and target instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the source instance is a self-built database, you also need to perform corresponding preparations, for details, see [Preparations Overview](https://help.aliyun.com/document_detail/146958.htm). Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @source_endpoint_instance_type.setter
    def source_endpoint_instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_endpoint_instance_type", value)

    @property
    @pulumi.getter(name="structureInitialization")
    def structure_initialization(self) -> pulumi.Input[bool]:
        """
        Whether to perform library table structure migration or initialization. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "structure_initialization")

    @structure_initialization.setter
    def structure_initialization(self, value: pulumi.Input[bool]):
        pulumi.set(self, "structure_initialization", value)

    @property
    @pulumi.getter
    def checkpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The start point or synchronization point of incremental data migration, the format is Unix timestamp, and the unit is seconds.
        """
        return pulumi.get(self, "checkpoint")

    @checkpoint.setter
    def checkpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checkpoint", value)

    @property
    @pulumi.getter(name="dataCheckConfigure")
    def data_check_configure(self) -> Optional[pulumi.Input[str]]:
        """
        The data verification task of the migration or synchronization instance, in the format of a JSON string, such as parameter limits or alarm configurations. For more information, see the DataCheckConfigure parameter description [datacheckconfigure-parameter](https://help.aliyun.com/zh/dts/developer-reference/datacheckconfigure-parameter).
        """
        return pulumi.get(self, "data_check_configure")

    @data_check_configure.setter
    def data_check_configure(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_check_configure", value)

    @property
    @pulumi.getter(name="dedicatedClusterId")
    def dedicated_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        When the ID of the dedicated cluster is input, the task is scheduled to the corresponding cluster.
        """
        return pulumi.get(self, "dedicated_cluster_id")

    @dedicated_cluster_id.setter
    def dedicated_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_cluster_id", value)

    @property
    @pulumi.getter(name="delayNotice")
    def delay_notice(self) -> Optional[pulumi.Input[bool]]:
        """
        The delay notice. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "delay_notice")

    @delay_notice.setter
    def delay_notice(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delay_notice", value)

    @property
    @pulumi.getter(name="delayPhone")
    def delay_phone(self) -> Optional[pulumi.Input[str]]:
        """
        The delay phone. The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "delay_phone")

    @delay_phone.setter
    def delay_phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delay_phone", value)

    @property
    @pulumi.getter(name="delayRuleTime")
    def delay_rule_time(self) -> Optional[pulumi.Input[str]]:
        """
        The delay rule time. When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        """
        return pulumi.get(self, "delay_rule_time")

    @delay_rule_time.setter
    def delay_rule_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delay_rule_time", value)

    @property
    @pulumi.getter(name="destinationEndpointDatabaseName")
    def destination_endpoint_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database to which the migration object belongs in the target instance. Note: when the target instance or target database type is PolarDB O engine, AnalyticDB PostgreSQL, PostgreSQL, MongoDB database, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_database_name")

    @destination_endpoint_database_name.setter
    def destination_endpoint_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_database_name", value)

    @property
    @pulumi.getter(name="destinationEndpointInstanceId")
    def destination_endpoint_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of destination instance. If the target instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the target instance is a self-built database, the value of this parameter changes according to the value of `destination_endpoint_instance_type`. For example, the value of `destination_endpoint_instance_type` is:
        ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
        ** `DG`, then this parameter needs to be passed into the ID of database gateway.
        ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        """
        return pulumi.get(self, "destination_endpoint_instance_id")

    @destination_endpoint_instance_id.setter
    def destination_endpoint_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_instance_id", value)

    @property
    @pulumi.getter(name="destinationEndpointIp")
    def destination_endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP of source endpoint. When `destination_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_ip")

    @destination_endpoint_ip.setter
    def destination_endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_ip", value)

    @property
    @pulumi.getter(name="destinationEndpointOracleSid")
    def destination_endpoint_oracle_sid(self) -> Optional[pulumi.Input[str]]:
        """
        The SID of Oracle database. Note: when the value of DestinationEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_oracle_sid")

    @destination_endpoint_oracle_sid.setter
    def destination_endpoint_oracle_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_oracle_sid", value)

    @property
    @pulumi.getter(name="destinationEndpointOwnerId")
    def destination_endpoint_owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Alibaba Cloud account to which the target RDS MySQL instance belongs. can be configured only when the target instance is RDS MySQL. This parameter is used to migrate or synchronize data across Alibaba Cloud accounts. You also need to enter the **destinationendpointrle** parameter.
        """
        return pulumi.get(self, "destination_endpoint_owner_id")

    @destination_endpoint_owner_id.setter
    def destination_endpoint_owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_owner_id", value)

    @property
    @pulumi.getter(name="destinationEndpointPassword")
    def destination_endpoint_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "destination_endpoint_password")

    @destination_endpoint_password.setter
    def destination_endpoint_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_password", value)

    @property
    @pulumi.getter(name="destinationEndpointPort")
    def destination_endpoint_port(self) -> Optional[pulumi.Input[str]]:
        """
        The port of source endpoint. When the target instance is a self-built database, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_port")

    @destination_endpoint_port.setter
    def destination_endpoint_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_port", value)

    @property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of destination instance. For the target instance region, please refer to the [list of supported regions](https://help.aliyun.com/document_detail/141033.htm). Note: if the target is an Alibaba Cloud database, this parameter must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_region")

    @destination_endpoint_region.setter
    def destination_endpoint_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_region", value)

    @property
    @pulumi.getter(name="destinationEndpointRole")
    def destination_endpoint_role(self) -> Optional[pulumi.Input[str]]:
        """
        The role name of the Alibaba Cloud account to which the target instance belongs. This parameter must be entered when data migration or synchronization across Alibaba Cloud accounts is performed. For the permissions and authorization methods required by this role.
        """
        return pulumi.get(self, "destination_endpoint_role")

    @destination_endpoint_role.setter
    def destination_endpoint_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_role", value)

    @property
    @pulumi.getter(name="destinationEndpointUserName")
    def destination_endpoint_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        """
        return pulumi.get(self, "destination_endpoint_user_name")

    @destination_endpoint_user_name.setter
    def destination_endpoint_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_user_name", value)

    @property
    @pulumi.getter(name="dtsBisLabel")
    def dts_bis_label(self) -> Optional[pulumi.Input[str]]:
        """
        The environment label of the DTS instance. The value is: **normal**, **online**.

        > **NOTE:** From the status of `NotStarted` to `Synchronizing`, the resource goes through the `Prechecking` and `Initializing` phases. Because of the `Initializing` phase takes too long, and once the resource passes to the status of `Prechecking`, it can be considered that the task can be executed normally. Therefore, we treat the status of `Initializing` as an equivalent to `Synchronizing`.

        > **NOTE:** If you want to upgrade the synchronization job specifications by the property `instance_class`, you must also modify the property `instance_class` of it's instance to keep them consistent.
        """
        return pulumi.get(self, "dts_bis_label")

    @dts_bis_label.setter
    def dts_bis_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dts_bis_label", value)

    @property
    @pulumi.getter(name="errorNotice")
    def error_notice(self) -> Optional[pulumi.Input[bool]]:
        """
        The error notice. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "error_notice")

    @error_notice.setter
    def error_notice(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "error_notice", value)

    @property
    @pulumi.getter(name="errorPhone")
    def error_phone(self) -> Optional[pulumi.Input[str]]:
        """
        The error phone. The mobile phone number of the contact who error the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "error_phone")

    @error_phone.setter
    def error_phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_phone", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[str]]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter
    def reserve(self) -> Optional[pulumi.Input[str]]:
        """
        DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter [description of the Reserve parameter](https://help.aliyun.com/document_detail/273111.html).
        """
        return pulumi.get(self, "reserve")

    @reserve.setter
    def reserve(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserve", value)

    @property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database to which the migration object belongs in the source instance. Note: this parameter is only available and must be passed in when the source instance, or the database type of the source instance is PolarDB O engine, PostgreSQL, or MongoDB database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @source_endpoint_database_name.setter
    def source_endpoint_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_database_name", value)

    @property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of source instance. If the source instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the source instance is a self-built database, the value of this parameter changes according to the value of `source_endpoint_instance_type`. For example, the value of `source_endpoint_instance_type` is:
        ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
        ** `DG`, then this parameter needs to be passed into the ID of database gateway.
        ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @source_endpoint_instance_id.setter
    def source_endpoint_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_instance_id", value)

    @property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP of source endpoint. When `source_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @source_endpoint_ip.setter
    def source_endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_ip", value)

    @property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> Optional[pulumi.Input[str]]:
        """
        The SID of Oracle database. When the value of SourceEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @source_endpoint_oracle_sid.setter
    def source_endpoint_oracle_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_oracle_sid", value)

    @property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of Alibaba Cloud account to which the source instance belongs. Note: passing in this parameter means performing data migration or synchronization across Alibaba Cloud accounts, and you also need to pass in the `source_endpoint_role` parameter.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @source_endpoint_owner_id.setter
    def source_endpoint_owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_owner_id", value)

    @property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "source_endpoint_password")

    @source_endpoint_password.setter
    def source_endpoint_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_password", value)

    @property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> Optional[pulumi.Input[str]]:
        """
        The port of source endpoint. When the source instance is a self-built database, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_port")

    @source_endpoint_port.setter
    def source_endpoint_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_port", value)

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> Optional[pulumi.Input[str]]:
        """
        Source instance area, please refer to the [list of supported areas](https://help.aliyun.com/document_detail/141033.htm) for details. Note if the source is an Alibaba Cloud database, this parameter must be passed in.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_region", value)

    @property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role configured for the cloud account to which the source instance belongs. Note: this parameter must be passed in when performing cross Alibaba Cloud account data migration or synchronization. For the permissions and authorization methods required by this role, please refer to [How to configure RAM authorization when cross-Alibaba Cloud account data migration or synchronization](https://help.aliyun.com/document_detail/48468.htm).
        """
        return pulumi.get(self, "source_endpoint_role")

    @source_endpoint_role.setter
    def source_endpoint_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_role", value)

    @property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @source_endpoint_user_name.setter
    def source_endpoint_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_user_name", value)

    @property
    @pulumi.getter(name="sourceEndpointVswitchId")
    def source_endpoint_vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data Delivery link switch instance id
        """
        return pulumi.get(self, "source_endpoint_vswitch_id")

    @source_endpoint_vswitch_id.setter
    def source_endpoint_vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_vswitch_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="synchronizationDirection")
    def synchronization_direction(self) -> Optional[pulumi.Input[str]]:
        """
        Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
        """
        return pulumi.get(self, "synchronization_direction")

    @synchronization_direction.setter
    def synchronization_direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "synchronization_direction", value)


@pulumi.input_type
class _SynchronizationJobState:
    def __init__(__self__, *,
                 checkpoint: Optional[pulumi.Input[str]] = None,
                 data_check_configure: Optional[pulumi.Input[str]] = None,
                 data_initialization: Optional[pulumi.Input[bool]] = None,
                 data_synchronization: Optional[pulumi.Input[bool]] = None,
                 db_list: Optional[pulumi.Input[str]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[str]] = None,
                 delay_notice: Optional[pulumi.Input[bool]] = None,
                 delay_phone: Optional[pulumi.Input[str]] = None,
                 delay_rule_time: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_database_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_instance_id: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_instance_type: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_oracle_sid: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_owner_id: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_password: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_port: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_role: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_user_name: Optional[pulumi.Input[str]] = None,
                 dts_bis_label: Optional[pulumi.Input[str]] = None,
                 dts_instance_id: Optional[pulumi.Input[str]] = None,
                 dts_job_name: Optional[pulumi.Input[str]] = None,
                 error_notice: Optional[pulumi.Input[bool]] = None,
                 error_phone: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 reserve: Optional[pulumi.Input[str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_vswitch_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 structure_initialization: Optional[pulumi.Input[bool]] = None,
                 synchronization_direction: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SynchronizationJob resources.
        :param pulumi.Input[str] checkpoint: The start point or synchronization point of incremental data migration, the format is Unix timestamp, and the unit is seconds.
        :param pulumi.Input[str] data_check_configure: The data verification task of the migration or synchronization instance, in the format of a JSON string, such as parameter limits or alarm configurations. For more information, see the DataCheckConfigure parameter description [datacheckconfigure-parameter](https://help.aliyun.com/zh/dts/developer-reference/datacheckconfigure-parameter).
        :param pulumi.Input[bool] data_initialization: Whether to perform full data migration or full data initialization. Valid values: `true`, `false`.
        :param pulumi.Input[bool] data_synchronization: Whether to perform incremental data migration or synchronization. Valid values: `true`, `false`.
        :param pulumi.Input[str] db_list: Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html). **NOTE:** From version 1.173.0, `db_list` can be modified.
        :param pulumi.Input[str] dedicated_cluster_id: When the ID of the dedicated cluster is input, the task is scheduled to the corresponding cluster.
        :param pulumi.Input[bool] delay_notice: The delay notice. Valid values: `true`, `false`.
        :param pulumi.Input[str] delay_phone: The delay phone. The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[str] delay_rule_time: The delay rule time. When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        :param pulumi.Input[str] destination_endpoint_database_name: The name of the database to which the migration object belongs in the target instance. Note: when the target instance or target database type is PolarDB O engine, AnalyticDB PostgreSQL, PostgreSQL, MongoDB database, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination database. The default value is MYSQL. For the correspondence between supported target libraries and source libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the target instance is KAFKA or MONGODB, you also need to pass in some information in the reserved parameter `reserve`. For the configuration method, see the description of `reserve` parameters. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        :param pulumi.Input[str] destination_endpoint_instance_id: The ID of destination instance. If the target instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the target instance is a self-built database, the value of this parameter changes according to the value of `destination_endpoint_instance_type`. For example, the value of `destination_endpoint_instance_type` is:
               ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
               ** `DG`, then this parameter needs to be passed into the ID of database gateway.
               ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        :param pulumi.Input[str] destination_endpoint_instance_type: The type of destination instance. If the target instance is a PolarDB O engine cluster, the target instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. If the target instance is the Kafka version of Message Queuing, the target instance type needs to be `ECS` or `EXPRESS` as a self-built database, and access via ECS or dedicated line. For the correspondence between supported targets and source instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the target instance is a self-built database, you also need to perform corresponding preparations, please refer to the [overview of preparations](https://help.aliyun.com/document_detail/146958.htm). Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[str] destination_endpoint_ip: The IP of source endpoint. When `destination_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_oracle_sid: The SID of Oracle database. Note: when the value of DestinationEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_owner_id: The ID of the Alibaba Cloud account to which the target RDS MySQL instance belongs. can be configured only when the target instance is RDS MySQL. This parameter is used to migrate or synchronize data across Alibaba Cloud accounts. You also need to enter the **destinationendpointrle** parameter.
        :param pulumi.Input[str] destination_endpoint_password: The password of database account.
        :param pulumi.Input[str] destination_endpoint_port: The port of source endpoint. When the target instance is a self-built database, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. For the target instance region, please refer to the [list of supported regions](https://help.aliyun.com/document_detail/141033.htm). Note: if the target is an Alibaba Cloud database, this parameter must be passed in.
        :param pulumi.Input[str] destination_endpoint_role: The role name of the Alibaba Cloud account to which the target instance belongs. This parameter must be entered when data migration or synchronization across Alibaba Cloud accounts is performed. For the permissions and authorization methods required by this role.
        :param pulumi.Input[str] destination_endpoint_user_name: The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        :param pulumi.Input[str] dts_bis_label: The environment label of the DTS instance. The value is: **normal**, **online**.
               
               > **NOTE:** From the status of `NotStarted` to `Synchronizing`, the resource goes through the `Prechecking` and `Initializing` phases. Because of the `Initializing` phase takes too long, and once the resource passes to the status of `Prechecking`, it can be considered that the task can be executed normally. Therefore, we treat the status of `Initializing` as an equivalent to `Synchronizing`.
               
               > **NOTE:** If you want to upgrade the synchronization job specifications by the property `instance_class`, you must also modify the property `instance_class` of it's instance to keep them consistent.
        :param pulumi.Input[str] dts_instance_id: The ID of synchronization instance, it must be an ID of `dts.SynchronizationInstance`.
        :param pulumi.Input[str] dts_job_name: The name of synchronization job.
        :param pulumi.Input[bool] error_notice: The error notice. Valid values: `true`, `false`.
        :param pulumi.Input[str] error_phone: The error phone. The mobile phone number of the contact who error the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[str] reserve: DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter [description of the Reserve parameter](https://help.aliyun.com/document_detail/273111.html).
        :param pulumi.Input[str] source_endpoint_database_name: The name of the database to which the migration object belongs in the source instance. Note: this parameter is only available and must be passed in when the source instance, or the database type of the source instance is PolarDB O engine, PostgreSQL, or MongoDB database.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source database. The default value is `MySQL`. For the correspondence between supported source libraries and target libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the source instance is `MONGODB`, you also need to pass in some information in the reserved parameter `Reserve`, for the configuration method, see the description of Reserve parameters. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        :param pulumi.Input[str] source_endpoint_instance_id: The ID of source instance. If the source instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the source instance is a self-built database, the value of this parameter changes according to the value of `source_endpoint_instance_type`. For example, the value of `source_endpoint_instance_type` is:
               ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
               ** `DG`, then this parameter needs to be passed into the ID of database gateway.
               ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        :param pulumi.Input[str] source_endpoint_instance_type: The type of source instance. If the source instance is a `PolarDB O` engine cluster, the source instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. For the correspondence between supported source and target instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the source instance is a self-built database, you also need to perform corresponding preparations, for details, see [Preparations Overview](https://help.aliyun.com/document_detail/146958.htm). Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[str] source_endpoint_ip: The IP of source endpoint. When `source_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_oracle_sid: The SID of Oracle database. When the value of SourceEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_owner_id: The ID of Alibaba Cloud account to which the source instance belongs. Note: passing in this parameter means performing data migration or synchronization across Alibaba Cloud accounts, and you also need to pass in the `source_endpoint_role` parameter.
        :param pulumi.Input[str] source_endpoint_password: The password of database account.
        :param pulumi.Input[str] source_endpoint_port: The port of source endpoint. When the source instance is a self-built database, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_region: Source instance area, please refer to the [list of supported areas](https://help.aliyun.com/document_detail/141033.htm) for details. Note if the source is an Alibaba Cloud database, this parameter must be passed in.
        :param pulumi.Input[str] source_endpoint_role: The name of the role configured for the cloud account to which the source instance belongs. Note: this parameter must be passed in when performing cross Alibaba Cloud account data migration or synchronization. For the permissions and authorization methods required by this role, please refer to [How to configure RAM authorization when cross-Alibaba Cloud account data migration or synchronization](https://help.aliyun.com/document_detail/48468.htm).
        :param pulumi.Input[str] source_endpoint_user_name: The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        :param pulumi.Input[str] source_endpoint_vswitch_id: Data Delivery link switch instance id
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
        :param pulumi.Input[bool] structure_initialization: Whether to perform library table structure migration or initialization. Valid values: `true`, `false`.
        :param pulumi.Input[str] synchronization_direction: Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
        """
        if checkpoint is not None:
            pulumi.set(__self__, "checkpoint", checkpoint)
        if data_check_configure is not None:
            pulumi.set(__self__, "data_check_configure", data_check_configure)
        if data_initialization is not None:
            pulumi.set(__self__, "data_initialization", data_initialization)
        if data_synchronization is not None:
            pulumi.set(__self__, "data_synchronization", data_synchronization)
        if db_list is not None:
            pulumi.set(__self__, "db_list", db_list)
        if dedicated_cluster_id is not None:
            pulumi.set(__self__, "dedicated_cluster_id", dedicated_cluster_id)
        if delay_notice is not None:
            pulumi.set(__self__, "delay_notice", delay_notice)
        if delay_phone is not None:
            pulumi.set(__self__, "delay_phone", delay_phone)
        if delay_rule_time is not None:
            pulumi.set(__self__, "delay_rule_time", delay_rule_time)
        if destination_endpoint_database_name is not None:
            pulumi.set(__self__, "destination_endpoint_database_name", destination_endpoint_database_name)
        if destination_endpoint_engine_name is not None:
            pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        if destination_endpoint_instance_id is not None:
            pulumi.set(__self__, "destination_endpoint_instance_id", destination_endpoint_instance_id)
        if destination_endpoint_instance_type is not None:
            pulumi.set(__self__, "destination_endpoint_instance_type", destination_endpoint_instance_type)
        if destination_endpoint_ip is not None:
            pulumi.set(__self__, "destination_endpoint_ip", destination_endpoint_ip)
        if destination_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "destination_endpoint_oracle_sid", destination_endpoint_oracle_sid)
        if destination_endpoint_owner_id is not None:
            pulumi.set(__self__, "destination_endpoint_owner_id", destination_endpoint_owner_id)
        if destination_endpoint_password is not None:
            pulumi.set(__self__, "destination_endpoint_password", destination_endpoint_password)
        if destination_endpoint_port is not None:
            pulumi.set(__self__, "destination_endpoint_port", destination_endpoint_port)
        if destination_endpoint_region is not None:
            pulumi.set(__self__, "destination_endpoint_region", destination_endpoint_region)
        if destination_endpoint_role is not None:
            pulumi.set(__self__, "destination_endpoint_role", destination_endpoint_role)
        if destination_endpoint_user_name is not None:
            pulumi.set(__self__, "destination_endpoint_user_name", destination_endpoint_user_name)
        if dts_bis_label is not None:
            pulumi.set(__self__, "dts_bis_label", dts_bis_label)
        if dts_instance_id is not None:
            pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        if dts_job_name is not None:
            pulumi.set(__self__, "dts_job_name", dts_job_name)
        if error_notice is not None:
            pulumi.set(__self__, "error_notice", error_notice)
        if error_phone is not None:
            pulumi.set(__self__, "error_phone", error_phone)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if reserve is not None:
            pulumi.set(__self__, "reserve", reserve)
        if source_endpoint_database_name is not None:
            pulumi.set(__self__, "source_endpoint_database_name", source_endpoint_database_name)
        if source_endpoint_engine_name is not None:
            pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        if source_endpoint_instance_id is not None:
            pulumi.set(__self__, "source_endpoint_instance_id", source_endpoint_instance_id)
        if source_endpoint_instance_type is not None:
            pulumi.set(__self__, "source_endpoint_instance_type", source_endpoint_instance_type)
        if source_endpoint_ip is not None:
            pulumi.set(__self__, "source_endpoint_ip", source_endpoint_ip)
        if source_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "source_endpoint_oracle_sid", source_endpoint_oracle_sid)
        if source_endpoint_owner_id is not None:
            pulumi.set(__self__, "source_endpoint_owner_id", source_endpoint_owner_id)
        if source_endpoint_password is not None:
            pulumi.set(__self__, "source_endpoint_password", source_endpoint_password)
        if source_endpoint_port is not None:
            pulumi.set(__self__, "source_endpoint_port", source_endpoint_port)
        if source_endpoint_region is not None:
            pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if source_endpoint_role is not None:
            pulumi.set(__self__, "source_endpoint_role", source_endpoint_role)
        if source_endpoint_user_name is not None:
            pulumi.set(__self__, "source_endpoint_user_name", source_endpoint_user_name)
        if source_endpoint_vswitch_id is not None:
            pulumi.set(__self__, "source_endpoint_vswitch_id", source_endpoint_vswitch_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if structure_initialization is not None:
            pulumi.set(__self__, "structure_initialization", structure_initialization)
        if synchronization_direction is not None:
            pulumi.set(__self__, "synchronization_direction", synchronization_direction)

    @property
    @pulumi.getter
    def checkpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The start point or synchronization point of incremental data migration, the format is Unix timestamp, and the unit is seconds.
        """
        return pulumi.get(self, "checkpoint")

    @checkpoint.setter
    def checkpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checkpoint", value)

    @property
    @pulumi.getter(name="dataCheckConfigure")
    def data_check_configure(self) -> Optional[pulumi.Input[str]]:
        """
        The data verification task of the migration or synchronization instance, in the format of a JSON string, such as parameter limits or alarm configurations. For more information, see the DataCheckConfigure parameter description [datacheckconfigure-parameter](https://help.aliyun.com/zh/dts/developer-reference/datacheckconfigure-parameter).
        """
        return pulumi.get(self, "data_check_configure")

    @data_check_configure.setter
    def data_check_configure(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_check_configure", value)

    @property
    @pulumi.getter(name="dataInitialization")
    def data_initialization(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to perform full data migration or full data initialization. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "data_initialization")

    @data_initialization.setter
    def data_initialization(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_initialization", value)

    @property
    @pulumi.getter(name="dataSynchronization")
    def data_synchronization(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to perform incremental data migration or synchronization. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "data_synchronization")

    @data_synchronization.setter
    def data_synchronization(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_synchronization", value)

    @property
    @pulumi.getter(name="dbList")
    def db_list(self) -> Optional[pulumi.Input[str]]:
        """
        Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html). **NOTE:** From version 1.173.0, `db_list` can be modified.
        """
        return pulumi.get(self, "db_list")

    @db_list.setter
    def db_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_list", value)

    @property
    @pulumi.getter(name="dedicatedClusterId")
    def dedicated_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        When the ID of the dedicated cluster is input, the task is scheduled to the corresponding cluster.
        """
        return pulumi.get(self, "dedicated_cluster_id")

    @dedicated_cluster_id.setter
    def dedicated_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_cluster_id", value)

    @property
    @pulumi.getter(name="delayNotice")
    def delay_notice(self) -> Optional[pulumi.Input[bool]]:
        """
        The delay notice. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "delay_notice")

    @delay_notice.setter
    def delay_notice(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delay_notice", value)

    @property
    @pulumi.getter(name="delayPhone")
    def delay_phone(self) -> Optional[pulumi.Input[str]]:
        """
        The delay phone. The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "delay_phone")

    @delay_phone.setter
    def delay_phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delay_phone", value)

    @property
    @pulumi.getter(name="delayRuleTime")
    def delay_rule_time(self) -> Optional[pulumi.Input[str]]:
        """
        The delay rule time. When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        """
        return pulumi.get(self, "delay_rule_time")

    @delay_rule_time.setter
    def delay_rule_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delay_rule_time", value)

    @property
    @pulumi.getter(name="destinationEndpointDatabaseName")
    def destination_endpoint_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database to which the migration object belongs in the target instance. Note: when the target instance or target database type is PolarDB O engine, AnalyticDB PostgreSQL, PostgreSQL, MongoDB database, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_database_name")

    @destination_endpoint_database_name.setter
    def destination_endpoint_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_database_name", value)

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> Optional[pulumi.Input[str]]:
        """
        The type of destination database. The default value is MYSQL. For the correspondence between supported target libraries and source libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the target instance is KAFKA or MONGODB, you also need to pass in some information in the reserved parameter `reserve`. For the configuration method, see the description of `reserve` parameters. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="destinationEndpointInstanceId")
    def destination_endpoint_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of destination instance. If the target instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the target instance is a self-built database, the value of this parameter changes according to the value of `destination_endpoint_instance_type`. For example, the value of `destination_endpoint_instance_type` is:
        ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
        ** `DG`, then this parameter needs to be passed into the ID of database gateway.
        ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        """
        return pulumi.get(self, "destination_endpoint_instance_id")

    @destination_endpoint_instance_id.setter
    def destination_endpoint_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_instance_id", value)

    @property
    @pulumi.getter(name="destinationEndpointInstanceType")
    def destination_endpoint_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of destination instance. If the target instance is a PolarDB O engine cluster, the target instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. If the target instance is the Kafka version of Message Queuing, the target instance type needs to be `ECS` or `EXPRESS` as a self-built database, and access via ECS or dedicated line. For the correspondence between supported targets and source instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the target instance is a self-built database, you also need to perform corresponding preparations, please refer to the [overview of preparations](https://help.aliyun.com/document_detail/146958.htm). Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "destination_endpoint_instance_type")

    @destination_endpoint_instance_type.setter
    def destination_endpoint_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_instance_type", value)

    @property
    @pulumi.getter(name="destinationEndpointIp")
    def destination_endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP of source endpoint. When `destination_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_ip")

    @destination_endpoint_ip.setter
    def destination_endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_ip", value)

    @property
    @pulumi.getter(name="destinationEndpointOracleSid")
    def destination_endpoint_oracle_sid(self) -> Optional[pulumi.Input[str]]:
        """
        The SID of Oracle database. Note: when the value of DestinationEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_oracle_sid")

    @destination_endpoint_oracle_sid.setter
    def destination_endpoint_oracle_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_oracle_sid", value)

    @property
    @pulumi.getter(name="destinationEndpointOwnerId")
    def destination_endpoint_owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Alibaba Cloud account to which the target RDS MySQL instance belongs. can be configured only when the target instance is RDS MySQL. This parameter is used to migrate or synchronize data across Alibaba Cloud accounts. You also need to enter the **destinationendpointrle** parameter.
        """
        return pulumi.get(self, "destination_endpoint_owner_id")

    @destination_endpoint_owner_id.setter
    def destination_endpoint_owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_owner_id", value)

    @property
    @pulumi.getter(name="destinationEndpointPassword")
    def destination_endpoint_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "destination_endpoint_password")

    @destination_endpoint_password.setter
    def destination_endpoint_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_password", value)

    @property
    @pulumi.getter(name="destinationEndpointPort")
    def destination_endpoint_port(self) -> Optional[pulumi.Input[str]]:
        """
        The port of source endpoint. When the target instance is a self-built database, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_port")

    @destination_endpoint_port.setter
    def destination_endpoint_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_port", value)

    @property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of destination instance. For the target instance region, please refer to the [list of supported regions](https://help.aliyun.com/document_detail/141033.htm). Note: if the target is an Alibaba Cloud database, this parameter must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_region")

    @destination_endpoint_region.setter
    def destination_endpoint_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_region", value)

    @property
    @pulumi.getter(name="destinationEndpointRole")
    def destination_endpoint_role(self) -> Optional[pulumi.Input[str]]:
        """
        The role name of the Alibaba Cloud account to which the target instance belongs. This parameter must be entered when data migration or synchronization across Alibaba Cloud accounts is performed. For the permissions and authorization methods required by this role.
        """
        return pulumi.get(self, "destination_endpoint_role")

    @destination_endpoint_role.setter
    def destination_endpoint_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_role", value)

    @property
    @pulumi.getter(name="destinationEndpointUserName")
    def destination_endpoint_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        """
        return pulumi.get(self, "destination_endpoint_user_name")

    @destination_endpoint_user_name.setter
    def destination_endpoint_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_user_name", value)

    @property
    @pulumi.getter(name="dtsBisLabel")
    def dts_bis_label(self) -> Optional[pulumi.Input[str]]:
        """
        The environment label of the DTS instance. The value is: **normal**, **online**.

        > **NOTE:** From the status of `NotStarted` to `Synchronizing`, the resource goes through the `Prechecking` and `Initializing` phases. Because of the `Initializing` phase takes too long, and once the resource passes to the status of `Prechecking`, it can be considered that the task can be executed normally. Therefore, we treat the status of `Initializing` as an equivalent to `Synchronizing`.

        > **NOTE:** If you want to upgrade the synchronization job specifications by the property `instance_class`, you must also modify the property `instance_class` of it's instance to keep them consistent.
        """
        return pulumi.get(self, "dts_bis_label")

    @dts_bis_label.setter
    def dts_bis_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dts_bis_label", value)

    @property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of synchronization instance, it must be an ID of `dts.SynchronizationInstance`.
        """
        return pulumi.get(self, "dts_instance_id")

    @dts_instance_id.setter
    def dts_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dts_instance_id", value)

    @property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of synchronization job.
        """
        return pulumi.get(self, "dts_job_name")

    @dts_job_name.setter
    def dts_job_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dts_job_name", value)

    @property
    @pulumi.getter(name="errorNotice")
    def error_notice(self) -> Optional[pulumi.Input[bool]]:
        """
        The error notice. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "error_notice")

    @error_notice.setter
    def error_notice(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "error_notice", value)

    @property
    @pulumi.getter(name="errorPhone")
    def error_phone(self) -> Optional[pulumi.Input[str]]:
        """
        The error phone. The mobile phone number of the contact who error the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "error_phone")

    @error_phone.setter
    def error_phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_phone", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[str]]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter
    def reserve(self) -> Optional[pulumi.Input[str]]:
        """
        DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter [description of the Reserve parameter](https://help.aliyun.com/document_detail/273111.html).
        """
        return pulumi.get(self, "reserve")

    @reserve.setter
    def reserve(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserve", value)

    @property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database to which the migration object belongs in the source instance. Note: this parameter is only available and must be passed in when the source instance, or the database type of the source instance is PolarDB O engine, PostgreSQL, or MongoDB database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @source_endpoint_database_name.setter
    def source_endpoint_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_database_name", value)

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> Optional[pulumi.Input[str]]:
        """
        The type of source database. The default value is `MySQL`. For the correspondence between supported source libraries and target libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the source instance is `MONGODB`, you also need to pass in some information in the reserved parameter `Reserve`, for the configuration method, see the description of Reserve parameters. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of source instance. If the source instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the source instance is a self-built database, the value of this parameter changes according to the value of `source_endpoint_instance_type`. For example, the value of `source_endpoint_instance_type` is:
        ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
        ** `DG`, then this parameter needs to be passed into the ID of database gateway.
        ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @source_endpoint_instance_id.setter
    def source_endpoint_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_instance_id", value)

    @property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of source instance. If the source instance is a `PolarDB O` engine cluster, the source instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. For the correspondence between supported source and target instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the source instance is a self-built database, you also need to perform corresponding preparations, for details, see [Preparations Overview](https://help.aliyun.com/document_detail/146958.htm). Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @source_endpoint_instance_type.setter
    def source_endpoint_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_instance_type", value)

    @property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP of source endpoint. When `source_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @source_endpoint_ip.setter
    def source_endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_ip", value)

    @property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> Optional[pulumi.Input[str]]:
        """
        The SID of Oracle database. When the value of SourceEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @source_endpoint_oracle_sid.setter
    def source_endpoint_oracle_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_oracle_sid", value)

    @property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of Alibaba Cloud account to which the source instance belongs. Note: passing in this parameter means performing data migration or synchronization across Alibaba Cloud accounts, and you also need to pass in the `source_endpoint_role` parameter.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @source_endpoint_owner_id.setter
    def source_endpoint_owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_owner_id", value)

    @property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "source_endpoint_password")

    @source_endpoint_password.setter
    def source_endpoint_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_password", value)

    @property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> Optional[pulumi.Input[str]]:
        """
        The port of source endpoint. When the source instance is a self-built database, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_port")

    @source_endpoint_port.setter
    def source_endpoint_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_port", value)

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> Optional[pulumi.Input[str]]:
        """
        Source instance area, please refer to the [list of supported areas](https://help.aliyun.com/document_detail/141033.htm) for details. Note if the source is an Alibaba Cloud database, this parameter must be passed in.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_region", value)

    @property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role configured for the cloud account to which the source instance belongs. Note: this parameter must be passed in when performing cross Alibaba Cloud account data migration or synchronization. For the permissions and authorization methods required by this role, please refer to [How to configure RAM authorization when cross-Alibaba Cloud account data migration or synchronization](https://help.aliyun.com/document_detail/48468.htm).
        """
        return pulumi.get(self, "source_endpoint_role")

    @source_endpoint_role.setter
    def source_endpoint_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_role", value)

    @property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @source_endpoint_user_name.setter
    def source_endpoint_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_user_name", value)

    @property
    @pulumi.getter(name="sourceEndpointVswitchId")
    def source_endpoint_vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data Delivery link switch instance id
        """
        return pulumi.get(self, "source_endpoint_vswitch_id")

    @source_endpoint_vswitch_id.setter
    def source_endpoint_vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_vswitch_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="structureInitialization")
    def structure_initialization(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to perform library table structure migration or initialization. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "structure_initialization")

    @structure_initialization.setter
    def structure_initialization(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "structure_initialization", value)

    @property
    @pulumi.getter(name="synchronizationDirection")
    def synchronization_direction(self) -> Optional[pulumi.Input[str]]:
        """
        Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
        """
        return pulumi.get(self, "synchronization_direction")

    @synchronization_direction.setter
    def synchronization_direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "synchronization_direction", value)


class SynchronizationJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint: Optional[pulumi.Input[str]] = None,
                 data_check_configure: Optional[pulumi.Input[str]] = None,
                 data_initialization: Optional[pulumi.Input[bool]] = None,
                 data_synchronization: Optional[pulumi.Input[bool]] = None,
                 db_list: Optional[pulumi.Input[str]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[str]] = None,
                 delay_notice: Optional[pulumi.Input[bool]] = None,
                 delay_phone: Optional[pulumi.Input[str]] = None,
                 delay_rule_time: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_database_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_instance_id: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_instance_type: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_oracle_sid: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_owner_id: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_password: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_port: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_role: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_user_name: Optional[pulumi.Input[str]] = None,
                 dts_bis_label: Optional[pulumi.Input[str]] = None,
                 dts_instance_id: Optional[pulumi.Input[str]] = None,
                 dts_job_name: Optional[pulumi.Input[str]] = None,
                 error_notice: Optional[pulumi.Input[bool]] = None,
                 error_phone: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 reserve: Optional[pulumi.Input[str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_vswitch_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 structure_initialization: Optional[pulumi.Input[bool]] = None,
                 synchronization_direction: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a DTS Synchronization Job resource.

        For information about DTS Synchronization Job and how to use it, see [What is Synchronization Job](https://www.alibabacloud.com/product/data-transmission-service).

        > **NOTE:** Available since v1.138.0.

        ## Notice

        1. The expiration time cannot be changed after the work of the annual and monthly subscription suspended;
        2. After the pay-as-you-go type job suspended, your job configuration fee will still be charged;
        3. If the task suspended for more than 6 hours, the task will not start successfully.
        4. Suspending the task will only stop writing to the target library, but will still continue to obtain the incremental log of the source, so that the task can be quickly resumed after the suspension is canceled. Therefore, some resources of the source library, such as bandwidth resources, will continue to be occupied during the period.
        5. Charges will continue during the task suspension period. If you need to stop charging, please release the instance
        6. When a DTS instance suspended for more than 7 days, the instance cannot be resumed, and the status will change from suspended to failed.

        ## Import

        DTS Synchronization Job can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dts/synchronizationJob:SynchronizationJob example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] checkpoint: The start point or synchronization point of incremental data migration, the format is Unix timestamp, and the unit is seconds.
        :param pulumi.Input[str] data_check_configure: The data verification task of the migration or synchronization instance, in the format of a JSON string, such as parameter limits or alarm configurations. For more information, see the DataCheckConfigure parameter description [datacheckconfigure-parameter](https://help.aliyun.com/zh/dts/developer-reference/datacheckconfigure-parameter).
        :param pulumi.Input[bool] data_initialization: Whether to perform full data migration or full data initialization. Valid values: `true`, `false`.
        :param pulumi.Input[bool] data_synchronization: Whether to perform incremental data migration or synchronization. Valid values: `true`, `false`.
        :param pulumi.Input[str] db_list: Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html). **NOTE:** From version 1.173.0, `db_list` can be modified.
        :param pulumi.Input[str] dedicated_cluster_id: When the ID of the dedicated cluster is input, the task is scheduled to the corresponding cluster.
        :param pulumi.Input[bool] delay_notice: The delay notice. Valid values: `true`, `false`.
        :param pulumi.Input[str] delay_phone: The delay phone. The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[str] delay_rule_time: The delay rule time. When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        :param pulumi.Input[str] destination_endpoint_database_name: The name of the database to which the migration object belongs in the target instance. Note: when the target instance or target database type is PolarDB O engine, AnalyticDB PostgreSQL, PostgreSQL, MongoDB database, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination database. The default value is MYSQL. For the correspondence between supported target libraries and source libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the target instance is KAFKA or MONGODB, you also need to pass in some information in the reserved parameter `reserve`. For the configuration method, see the description of `reserve` parameters. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        :param pulumi.Input[str] destination_endpoint_instance_id: The ID of destination instance. If the target instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the target instance is a self-built database, the value of this parameter changes according to the value of `destination_endpoint_instance_type`. For example, the value of `destination_endpoint_instance_type` is:
               ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
               ** `DG`, then this parameter needs to be passed into the ID of database gateway.
               ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        :param pulumi.Input[str] destination_endpoint_instance_type: The type of destination instance. If the target instance is a PolarDB O engine cluster, the target instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. If the target instance is the Kafka version of Message Queuing, the target instance type needs to be `ECS` or `EXPRESS` as a self-built database, and access via ECS or dedicated line. For the correspondence between supported targets and source instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the target instance is a self-built database, you also need to perform corresponding preparations, please refer to the [overview of preparations](https://help.aliyun.com/document_detail/146958.htm). Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[str] destination_endpoint_ip: The IP of source endpoint. When `destination_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_oracle_sid: The SID of Oracle database. Note: when the value of DestinationEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_owner_id: The ID of the Alibaba Cloud account to which the target RDS MySQL instance belongs. can be configured only when the target instance is RDS MySQL. This parameter is used to migrate or synchronize data across Alibaba Cloud accounts. You also need to enter the **destinationendpointrle** parameter.
        :param pulumi.Input[str] destination_endpoint_password: The password of database account.
        :param pulumi.Input[str] destination_endpoint_port: The port of source endpoint. When the target instance is a self-built database, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. For the target instance region, please refer to the [list of supported regions](https://help.aliyun.com/document_detail/141033.htm). Note: if the target is an Alibaba Cloud database, this parameter must be passed in.
        :param pulumi.Input[str] destination_endpoint_role: The role name of the Alibaba Cloud account to which the target instance belongs. This parameter must be entered when data migration or synchronization across Alibaba Cloud accounts is performed. For the permissions and authorization methods required by this role.
        :param pulumi.Input[str] destination_endpoint_user_name: The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        :param pulumi.Input[str] dts_bis_label: The environment label of the DTS instance. The value is: **normal**, **online**.
               
               > **NOTE:** From the status of `NotStarted` to `Synchronizing`, the resource goes through the `Prechecking` and `Initializing` phases. Because of the `Initializing` phase takes too long, and once the resource passes to the status of `Prechecking`, it can be considered that the task can be executed normally. Therefore, we treat the status of `Initializing` as an equivalent to `Synchronizing`.
               
               > **NOTE:** If you want to upgrade the synchronization job specifications by the property `instance_class`, you must also modify the property `instance_class` of it's instance to keep them consistent.
        :param pulumi.Input[str] dts_instance_id: The ID of synchronization instance, it must be an ID of `dts.SynchronizationInstance`.
        :param pulumi.Input[str] dts_job_name: The name of synchronization job.
        :param pulumi.Input[bool] error_notice: The error notice. Valid values: `true`, `false`.
        :param pulumi.Input[str] error_phone: The error phone. The mobile phone number of the contact who error the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[str] reserve: DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter [description of the Reserve parameter](https://help.aliyun.com/document_detail/273111.html).
        :param pulumi.Input[str] source_endpoint_database_name: The name of the database to which the migration object belongs in the source instance. Note: this parameter is only available and must be passed in when the source instance, or the database type of the source instance is PolarDB O engine, PostgreSQL, or MongoDB database.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source database. The default value is `MySQL`. For the correspondence between supported source libraries and target libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the source instance is `MONGODB`, you also need to pass in some information in the reserved parameter `Reserve`, for the configuration method, see the description of Reserve parameters. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        :param pulumi.Input[str] source_endpoint_instance_id: The ID of source instance. If the source instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the source instance is a self-built database, the value of this parameter changes according to the value of `source_endpoint_instance_type`. For example, the value of `source_endpoint_instance_type` is:
               ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
               ** `DG`, then this parameter needs to be passed into the ID of database gateway.
               ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        :param pulumi.Input[str] source_endpoint_instance_type: The type of source instance. If the source instance is a `PolarDB O` engine cluster, the source instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. For the correspondence between supported source and target instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the source instance is a self-built database, you also need to perform corresponding preparations, for details, see [Preparations Overview](https://help.aliyun.com/document_detail/146958.htm). Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[str] source_endpoint_ip: The IP of source endpoint. When `source_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_oracle_sid: The SID of Oracle database. When the value of SourceEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_owner_id: The ID of Alibaba Cloud account to which the source instance belongs. Note: passing in this parameter means performing data migration or synchronization across Alibaba Cloud accounts, and you also need to pass in the `source_endpoint_role` parameter.
        :param pulumi.Input[str] source_endpoint_password: The password of database account.
        :param pulumi.Input[str] source_endpoint_port: The port of source endpoint. When the source instance is a self-built database, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_region: Source instance area, please refer to the [list of supported areas](https://help.aliyun.com/document_detail/141033.htm) for details. Note if the source is an Alibaba Cloud database, this parameter must be passed in.
        :param pulumi.Input[str] source_endpoint_role: The name of the role configured for the cloud account to which the source instance belongs. Note: this parameter must be passed in when performing cross Alibaba Cloud account data migration or synchronization. For the permissions and authorization methods required by this role, please refer to [How to configure RAM authorization when cross-Alibaba Cloud account data migration or synchronization](https://help.aliyun.com/document_detail/48468.htm).
        :param pulumi.Input[str] source_endpoint_user_name: The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        :param pulumi.Input[str] source_endpoint_vswitch_id: Data Delivery link switch instance id
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
        :param pulumi.Input[bool] structure_initialization: Whether to perform library table structure migration or initialization. Valid values: `true`, `false`.
        :param pulumi.Input[str] synchronization_direction: Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SynchronizationJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DTS Synchronization Job resource.

        For information about DTS Synchronization Job and how to use it, see [What is Synchronization Job](https://www.alibabacloud.com/product/data-transmission-service).

        > **NOTE:** Available since v1.138.0.

        ## Notice

        1. The expiration time cannot be changed after the work of the annual and monthly subscription suspended;
        2. After the pay-as-you-go type job suspended, your job configuration fee will still be charged;
        3. If the task suspended for more than 6 hours, the task will not start successfully.
        4. Suspending the task will only stop writing to the target library, but will still continue to obtain the incremental log of the source, so that the task can be quickly resumed after the suspension is canceled. Therefore, some resources of the source library, such as bandwidth resources, will continue to be occupied during the period.
        5. Charges will continue during the task suspension period. If you need to stop charging, please release the instance
        6. When a DTS instance suspended for more than 7 days, the instance cannot be resumed, and the status will change from suspended to failed.

        ## Import

        DTS Synchronization Job can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:dts/synchronizationJob:SynchronizationJob example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SynchronizationJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SynchronizationJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint: Optional[pulumi.Input[str]] = None,
                 data_check_configure: Optional[pulumi.Input[str]] = None,
                 data_initialization: Optional[pulumi.Input[bool]] = None,
                 data_synchronization: Optional[pulumi.Input[bool]] = None,
                 db_list: Optional[pulumi.Input[str]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[str]] = None,
                 delay_notice: Optional[pulumi.Input[bool]] = None,
                 delay_phone: Optional[pulumi.Input[str]] = None,
                 delay_rule_time: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_database_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_instance_id: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_instance_type: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_oracle_sid: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_owner_id: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_password: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_port: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_role: Optional[pulumi.Input[str]] = None,
                 destination_endpoint_user_name: Optional[pulumi.Input[str]] = None,
                 dts_bis_label: Optional[pulumi.Input[str]] = None,
                 dts_instance_id: Optional[pulumi.Input[str]] = None,
                 dts_job_name: Optional[pulumi.Input[str]] = None,
                 error_notice: Optional[pulumi.Input[bool]] = None,
                 error_phone: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 reserve: Optional[pulumi.Input[str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[str]] = None,
                 source_endpoint_vswitch_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 structure_initialization: Optional[pulumi.Input[bool]] = None,
                 synchronization_direction: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SynchronizationJobArgs.__new__(SynchronizationJobArgs)

            __props__.__dict__["checkpoint"] = checkpoint
            __props__.__dict__["data_check_configure"] = data_check_configure
            if data_initialization is None and not opts.urn:
                raise TypeError("Missing required property 'data_initialization'")
            __props__.__dict__["data_initialization"] = data_initialization
            if data_synchronization is None and not opts.urn:
                raise TypeError("Missing required property 'data_synchronization'")
            __props__.__dict__["data_synchronization"] = data_synchronization
            if db_list is None and not opts.urn:
                raise TypeError("Missing required property 'db_list'")
            __props__.__dict__["db_list"] = db_list
            __props__.__dict__["dedicated_cluster_id"] = dedicated_cluster_id
            __props__.__dict__["delay_notice"] = delay_notice
            __props__.__dict__["delay_phone"] = delay_phone
            __props__.__dict__["delay_rule_time"] = delay_rule_time
            __props__.__dict__["destination_endpoint_database_name"] = destination_endpoint_database_name
            if destination_endpoint_engine_name is None and not opts.urn:
                raise TypeError("Missing required property 'destination_endpoint_engine_name'")
            __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
            __props__.__dict__["destination_endpoint_instance_id"] = destination_endpoint_instance_id
            if destination_endpoint_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'destination_endpoint_instance_type'")
            __props__.__dict__["destination_endpoint_instance_type"] = destination_endpoint_instance_type
            __props__.__dict__["destination_endpoint_ip"] = destination_endpoint_ip
            __props__.__dict__["destination_endpoint_oracle_sid"] = destination_endpoint_oracle_sid
            __props__.__dict__["destination_endpoint_owner_id"] = destination_endpoint_owner_id
            __props__.__dict__["destination_endpoint_password"] = destination_endpoint_password
            __props__.__dict__["destination_endpoint_port"] = destination_endpoint_port
            __props__.__dict__["destination_endpoint_region"] = destination_endpoint_region
            __props__.__dict__["destination_endpoint_role"] = destination_endpoint_role
            __props__.__dict__["destination_endpoint_user_name"] = destination_endpoint_user_name
            __props__.__dict__["dts_bis_label"] = dts_bis_label
            if dts_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'dts_instance_id'")
            __props__.__dict__["dts_instance_id"] = dts_instance_id
            if dts_job_name is None and not opts.urn:
                raise TypeError("Missing required property 'dts_job_name'")
            __props__.__dict__["dts_job_name"] = dts_job_name
            __props__.__dict__["error_notice"] = error_notice
            __props__.__dict__["error_phone"] = error_phone
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["reserve"] = reserve
            __props__.__dict__["source_endpoint_database_name"] = source_endpoint_database_name
            if source_endpoint_engine_name is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_engine_name'")
            __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
            __props__.__dict__["source_endpoint_instance_id"] = source_endpoint_instance_id
            if source_endpoint_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_instance_type'")
            __props__.__dict__["source_endpoint_instance_type"] = source_endpoint_instance_type
            __props__.__dict__["source_endpoint_ip"] = source_endpoint_ip
            __props__.__dict__["source_endpoint_oracle_sid"] = source_endpoint_oracle_sid
            __props__.__dict__["source_endpoint_owner_id"] = source_endpoint_owner_id
            __props__.__dict__["source_endpoint_password"] = source_endpoint_password
            __props__.__dict__["source_endpoint_port"] = source_endpoint_port
            __props__.__dict__["source_endpoint_region"] = source_endpoint_region
            __props__.__dict__["source_endpoint_role"] = source_endpoint_role
            __props__.__dict__["source_endpoint_user_name"] = source_endpoint_user_name
            __props__.__dict__["source_endpoint_vswitch_id"] = source_endpoint_vswitch_id
            __props__.__dict__["status"] = status
            if structure_initialization is None and not opts.urn:
                raise TypeError("Missing required property 'structure_initialization'")
            __props__.__dict__["structure_initialization"] = structure_initialization
            __props__.__dict__["synchronization_direction"] = synchronization_direction
        super(SynchronizationJob, __self__).__init__(
            'alicloud:dts/synchronizationJob:SynchronizationJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checkpoint: Optional[pulumi.Input[str]] = None,
            data_check_configure: Optional[pulumi.Input[str]] = None,
            data_initialization: Optional[pulumi.Input[bool]] = None,
            data_synchronization: Optional[pulumi.Input[bool]] = None,
            db_list: Optional[pulumi.Input[str]] = None,
            dedicated_cluster_id: Optional[pulumi.Input[str]] = None,
            delay_notice: Optional[pulumi.Input[bool]] = None,
            delay_phone: Optional[pulumi.Input[str]] = None,
            delay_rule_time: Optional[pulumi.Input[str]] = None,
            destination_endpoint_database_name: Optional[pulumi.Input[str]] = None,
            destination_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
            destination_endpoint_instance_id: Optional[pulumi.Input[str]] = None,
            destination_endpoint_instance_type: Optional[pulumi.Input[str]] = None,
            destination_endpoint_ip: Optional[pulumi.Input[str]] = None,
            destination_endpoint_oracle_sid: Optional[pulumi.Input[str]] = None,
            destination_endpoint_owner_id: Optional[pulumi.Input[str]] = None,
            destination_endpoint_password: Optional[pulumi.Input[str]] = None,
            destination_endpoint_port: Optional[pulumi.Input[str]] = None,
            destination_endpoint_region: Optional[pulumi.Input[str]] = None,
            destination_endpoint_role: Optional[pulumi.Input[str]] = None,
            destination_endpoint_user_name: Optional[pulumi.Input[str]] = None,
            dts_bis_label: Optional[pulumi.Input[str]] = None,
            dts_instance_id: Optional[pulumi.Input[str]] = None,
            dts_job_name: Optional[pulumi.Input[str]] = None,
            error_notice: Optional[pulumi.Input[bool]] = None,
            error_phone: Optional[pulumi.Input[str]] = None,
            instance_class: Optional[pulumi.Input[str]] = None,
            reserve: Optional[pulumi.Input[str]] = None,
            source_endpoint_database_name: Optional[pulumi.Input[str]] = None,
            source_endpoint_engine_name: Optional[pulumi.Input[str]] = None,
            source_endpoint_instance_id: Optional[pulumi.Input[str]] = None,
            source_endpoint_instance_type: Optional[pulumi.Input[str]] = None,
            source_endpoint_ip: Optional[pulumi.Input[str]] = None,
            source_endpoint_oracle_sid: Optional[pulumi.Input[str]] = None,
            source_endpoint_owner_id: Optional[pulumi.Input[str]] = None,
            source_endpoint_password: Optional[pulumi.Input[str]] = None,
            source_endpoint_port: Optional[pulumi.Input[str]] = None,
            source_endpoint_region: Optional[pulumi.Input[str]] = None,
            source_endpoint_role: Optional[pulumi.Input[str]] = None,
            source_endpoint_user_name: Optional[pulumi.Input[str]] = None,
            source_endpoint_vswitch_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            structure_initialization: Optional[pulumi.Input[bool]] = None,
            synchronization_direction: Optional[pulumi.Input[str]] = None) -> 'SynchronizationJob':
        """
        Get an existing SynchronizationJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] checkpoint: The start point or synchronization point of incremental data migration, the format is Unix timestamp, and the unit is seconds.
        :param pulumi.Input[str] data_check_configure: The data verification task of the migration or synchronization instance, in the format of a JSON string, such as parameter limits or alarm configurations. For more information, see the DataCheckConfigure parameter description [datacheckconfigure-parameter](https://help.aliyun.com/zh/dts/developer-reference/datacheckconfigure-parameter).
        :param pulumi.Input[bool] data_initialization: Whether to perform full data migration or full data initialization. Valid values: `true`, `false`.
        :param pulumi.Input[bool] data_synchronization: Whether to perform incremental data migration or synchronization. Valid values: `true`, `false`.
        :param pulumi.Input[str] db_list: Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html). **NOTE:** From version 1.173.0, `db_list` can be modified.
        :param pulumi.Input[str] dedicated_cluster_id: When the ID of the dedicated cluster is input, the task is scheduled to the corresponding cluster.
        :param pulumi.Input[bool] delay_notice: The delay notice. Valid values: `true`, `false`.
        :param pulumi.Input[str] delay_phone: The delay phone. The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[str] delay_rule_time: The delay rule time. When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        :param pulumi.Input[str] destination_endpoint_database_name: The name of the database to which the migration object belongs in the target instance. Note: when the target instance or target database type is PolarDB O engine, AnalyticDB PostgreSQL, PostgreSQL, MongoDB database, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_engine_name: The type of destination database. The default value is MYSQL. For the correspondence between supported target libraries and source libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the target instance is KAFKA or MONGODB, you also need to pass in some information in the reserved parameter `reserve`. For the configuration method, see the description of `reserve` parameters. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        :param pulumi.Input[str] destination_endpoint_instance_id: The ID of destination instance. If the target instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the target instance is a self-built database, the value of this parameter changes according to the value of `destination_endpoint_instance_type`. For example, the value of `destination_endpoint_instance_type` is:
               ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
               ** `DG`, then this parameter needs to be passed into the ID of database gateway.
               ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        :param pulumi.Input[str] destination_endpoint_instance_type: The type of destination instance. If the target instance is a PolarDB O engine cluster, the target instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. If the target instance is the Kafka version of Message Queuing, the target instance type needs to be `ECS` or `EXPRESS` as a self-built database, and access via ECS or dedicated line. For the correspondence between supported targets and source instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the target instance is a self-built database, you also need to perform corresponding preparations, please refer to the [overview of preparations](https://help.aliyun.com/document_detail/146958.htm). Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[str] destination_endpoint_ip: The IP of source endpoint. When `destination_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_oracle_sid: The SID of Oracle database. Note: when the value of DestinationEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_owner_id: The ID of the Alibaba Cloud account to which the target RDS MySQL instance belongs. can be configured only when the target instance is RDS MySQL. This parameter is used to migrate or synchronize data across Alibaba Cloud accounts. You also need to enter the **destinationendpointrle** parameter.
        :param pulumi.Input[str] destination_endpoint_password: The password of database account.
        :param pulumi.Input[str] destination_endpoint_port: The port of source endpoint. When the target instance is a self-built database, this parameter is available and must be passed in.
        :param pulumi.Input[str] destination_endpoint_region: The region of destination instance. For the target instance region, please refer to the [list of supported regions](https://help.aliyun.com/document_detail/141033.htm). Note: if the target is an Alibaba Cloud database, this parameter must be passed in.
        :param pulumi.Input[str] destination_endpoint_role: The role name of the Alibaba Cloud account to which the target instance belongs. This parameter must be entered when data migration or synchronization across Alibaba Cloud accounts is performed. For the permissions and authorization methods required by this role.
        :param pulumi.Input[str] destination_endpoint_user_name: The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        :param pulumi.Input[str] dts_bis_label: The environment label of the DTS instance. The value is: **normal**, **online**.
               
               > **NOTE:** From the status of `NotStarted` to `Synchronizing`, the resource goes through the `Prechecking` and `Initializing` phases. Because of the `Initializing` phase takes too long, and once the resource passes to the status of `Prechecking`, it can be considered that the task can be executed normally. Therefore, we treat the status of `Initializing` as an equivalent to `Synchronizing`.
               
               > **NOTE:** If you want to upgrade the synchronization job specifications by the property `instance_class`, you must also modify the property `instance_class` of it's instance to keep them consistent.
        :param pulumi.Input[str] dts_instance_id: The ID of synchronization instance, it must be an ID of `dts.SynchronizationInstance`.
        :param pulumi.Input[str] dts_job_name: The name of synchronization job.
        :param pulumi.Input[bool] error_notice: The error notice. Valid values: `true`, `false`.
        :param pulumi.Input[str] error_phone: The error phone. The mobile phone number of the contact who error the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        :param pulumi.Input[str] reserve: DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter [description of the Reserve parameter](https://help.aliyun.com/document_detail/273111.html).
        :param pulumi.Input[str] source_endpoint_database_name: The name of the database to which the migration object belongs in the source instance. Note: this parameter is only available and must be passed in when the source instance, or the database type of the source instance is PolarDB O engine, PostgreSQL, or MongoDB database.
        :param pulumi.Input[str] source_endpoint_engine_name: The type of source database. The default value is `MySQL`. For the correspondence between supported source libraries and target libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the source instance is `MONGODB`, you also need to pass in some information in the reserved parameter `Reserve`, for the configuration method, see the description of Reserve parameters. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        :param pulumi.Input[str] source_endpoint_instance_id: The ID of source instance. If the source instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the source instance is a self-built database, the value of this parameter changes according to the value of `source_endpoint_instance_type`. For example, the value of `source_endpoint_instance_type` is:
               ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
               ** `DG`, then this parameter needs to be passed into the ID of database gateway.
               ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        :param pulumi.Input[str] source_endpoint_instance_type: The type of source instance. If the source instance is a `PolarDB O` engine cluster, the source instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. For the correspondence between supported source and target instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the source instance is a self-built database, you also need to perform corresponding preparations, for details, see [Preparations Overview](https://help.aliyun.com/document_detail/146958.htm). Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[str] source_endpoint_ip: The IP of source endpoint. When `source_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_oracle_sid: The SID of Oracle database. When the value of SourceEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_owner_id: The ID of Alibaba Cloud account to which the source instance belongs. Note: passing in this parameter means performing data migration or synchronization across Alibaba Cloud accounts, and you also need to pass in the `source_endpoint_role` parameter.
        :param pulumi.Input[str] source_endpoint_password: The password of database account.
        :param pulumi.Input[str] source_endpoint_port: The port of source endpoint. When the source instance is a self-built database, this parameter is available and must be passed in.
        :param pulumi.Input[str] source_endpoint_region: Source instance area, please refer to the [list of supported areas](https://help.aliyun.com/document_detail/141033.htm) for details. Note if the source is an Alibaba Cloud database, this parameter must be passed in.
        :param pulumi.Input[str] source_endpoint_role: The name of the role configured for the cloud account to which the source instance belongs. Note: this parameter must be passed in when performing cross Alibaba Cloud account data migration or synchronization. For the permissions and authorization methods required by this role, please refer to [How to configure RAM authorization when cross-Alibaba Cloud account data migration or synchronization](https://help.aliyun.com/document_detail/48468.htm).
        :param pulumi.Input[str] source_endpoint_user_name: The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        :param pulumi.Input[str] source_endpoint_vswitch_id: Data Delivery link switch instance id
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
        :param pulumi.Input[bool] structure_initialization: Whether to perform library table structure migration or initialization. Valid values: `true`, `false`.
        :param pulumi.Input[str] synchronization_direction: Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SynchronizationJobState.__new__(_SynchronizationJobState)

        __props__.__dict__["checkpoint"] = checkpoint
        __props__.__dict__["data_check_configure"] = data_check_configure
        __props__.__dict__["data_initialization"] = data_initialization
        __props__.__dict__["data_synchronization"] = data_synchronization
        __props__.__dict__["db_list"] = db_list
        __props__.__dict__["dedicated_cluster_id"] = dedicated_cluster_id
        __props__.__dict__["delay_notice"] = delay_notice
        __props__.__dict__["delay_phone"] = delay_phone
        __props__.__dict__["delay_rule_time"] = delay_rule_time
        __props__.__dict__["destination_endpoint_database_name"] = destination_endpoint_database_name
        __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
        __props__.__dict__["destination_endpoint_instance_id"] = destination_endpoint_instance_id
        __props__.__dict__["destination_endpoint_instance_type"] = destination_endpoint_instance_type
        __props__.__dict__["destination_endpoint_ip"] = destination_endpoint_ip
        __props__.__dict__["destination_endpoint_oracle_sid"] = destination_endpoint_oracle_sid
        __props__.__dict__["destination_endpoint_owner_id"] = destination_endpoint_owner_id
        __props__.__dict__["destination_endpoint_password"] = destination_endpoint_password
        __props__.__dict__["destination_endpoint_port"] = destination_endpoint_port
        __props__.__dict__["destination_endpoint_region"] = destination_endpoint_region
        __props__.__dict__["destination_endpoint_role"] = destination_endpoint_role
        __props__.__dict__["destination_endpoint_user_name"] = destination_endpoint_user_name
        __props__.__dict__["dts_bis_label"] = dts_bis_label
        __props__.__dict__["dts_instance_id"] = dts_instance_id
        __props__.__dict__["dts_job_name"] = dts_job_name
        __props__.__dict__["error_notice"] = error_notice
        __props__.__dict__["error_phone"] = error_phone
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["reserve"] = reserve
        __props__.__dict__["source_endpoint_database_name"] = source_endpoint_database_name
        __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
        __props__.__dict__["source_endpoint_instance_id"] = source_endpoint_instance_id
        __props__.__dict__["source_endpoint_instance_type"] = source_endpoint_instance_type
        __props__.__dict__["source_endpoint_ip"] = source_endpoint_ip
        __props__.__dict__["source_endpoint_oracle_sid"] = source_endpoint_oracle_sid
        __props__.__dict__["source_endpoint_owner_id"] = source_endpoint_owner_id
        __props__.__dict__["source_endpoint_password"] = source_endpoint_password
        __props__.__dict__["source_endpoint_port"] = source_endpoint_port
        __props__.__dict__["source_endpoint_region"] = source_endpoint_region
        __props__.__dict__["source_endpoint_role"] = source_endpoint_role
        __props__.__dict__["source_endpoint_user_name"] = source_endpoint_user_name
        __props__.__dict__["source_endpoint_vswitch_id"] = source_endpoint_vswitch_id
        __props__.__dict__["status"] = status
        __props__.__dict__["structure_initialization"] = structure_initialization
        __props__.__dict__["synchronization_direction"] = synchronization_direction
        return SynchronizationJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def checkpoint(self) -> pulumi.Output[str]:
        """
        The start point or synchronization point of incremental data migration, the format is Unix timestamp, and the unit is seconds.
        """
        return pulumi.get(self, "checkpoint")

    @property
    @pulumi.getter(name="dataCheckConfigure")
    def data_check_configure(self) -> pulumi.Output[Optional[str]]:
        """
        The data verification task of the migration or synchronization instance, in the format of a JSON string, such as parameter limits or alarm configurations. For more information, see the DataCheckConfigure parameter description [datacheckconfigure-parameter](https://help.aliyun.com/zh/dts/developer-reference/datacheckconfigure-parameter).
        """
        return pulumi.get(self, "data_check_configure")

    @property
    @pulumi.getter(name="dataInitialization")
    def data_initialization(self) -> pulumi.Output[bool]:
        """
        Whether to perform full data migration or full data initialization. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "data_initialization")

    @property
    @pulumi.getter(name="dataSynchronization")
    def data_synchronization(self) -> pulumi.Output[bool]:
        """
        Whether to perform incremental data migration or synchronization. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "data_synchronization")

    @property
    @pulumi.getter(name="dbList")
    def db_list(self) -> pulumi.Output[str]:
        """
        Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html). **NOTE:** From version 1.173.0, `db_list` can be modified.
        """
        return pulumi.get(self, "db_list")

    @property
    @pulumi.getter(name="dedicatedClusterId")
    def dedicated_cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        When the ID of the dedicated cluster is input, the task is scheduled to the corresponding cluster.
        """
        return pulumi.get(self, "dedicated_cluster_id")

    @property
    @pulumi.getter(name="delayNotice")
    def delay_notice(self) -> pulumi.Output[Optional[bool]]:
        """
        The delay notice. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "delay_notice")

    @property
    @pulumi.getter(name="delayPhone")
    def delay_phone(self) -> pulumi.Output[Optional[str]]:
        """
        The delay phone. The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "delay_phone")

    @property
    @pulumi.getter(name="delayRuleTime")
    def delay_rule_time(self) -> pulumi.Output[Optional[str]]:
        """
        The delay rule time. When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        """
        return pulumi.get(self, "delay_rule_time")

    @property
    @pulumi.getter(name="destinationEndpointDatabaseName")
    def destination_endpoint_database_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the database to which the migration object belongs in the target instance. Note: when the target instance or target database type is PolarDB O engine, AnalyticDB PostgreSQL, PostgreSQL, MongoDB database, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_database_name")

    @property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> pulumi.Output[str]:
        """
        The type of destination database. The default value is MYSQL. For the correspondence between supported target libraries and source libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the target instance is KAFKA or MONGODB, you also need to pass in some information in the reserved parameter `reserve`. For the configuration method, see the description of `reserve` parameters. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @property
    @pulumi.getter(name="destinationEndpointInstanceId")
    def destination_endpoint_instance_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of destination instance. If the target instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the target instance is a self-built database, the value of this parameter changes according to the value of `destination_endpoint_instance_type`. For example, the value of `destination_endpoint_instance_type` is:
        ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
        ** `DG`, then this parameter needs to be passed into the ID of database gateway.
        ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        """
        return pulumi.get(self, "destination_endpoint_instance_id")

    @property
    @pulumi.getter(name="destinationEndpointInstanceType")
    def destination_endpoint_instance_type(self) -> pulumi.Output[str]:
        """
        The type of destination instance. If the target instance is a PolarDB O engine cluster, the target instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. If the target instance is the Kafka version of Message Queuing, the target instance type needs to be `ECS` or `EXPRESS` as a self-built database, and access via ECS or dedicated line. For the correspondence between supported targets and source instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the target instance is a self-built database, you also need to perform corresponding preparations, please refer to the [overview of preparations](https://help.aliyun.com/document_detail/146958.htm). Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "destination_endpoint_instance_type")

    @property
    @pulumi.getter(name="destinationEndpointIp")
    def destination_endpoint_ip(self) -> pulumi.Output[Optional[str]]:
        """
        The IP of source endpoint. When `destination_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_ip")

    @property
    @pulumi.getter(name="destinationEndpointOracleSid")
    def destination_endpoint_oracle_sid(self) -> pulumi.Output[Optional[str]]:
        """
        The SID of Oracle database. Note: when the value of DestinationEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_oracle_sid")

    @property
    @pulumi.getter(name="destinationEndpointOwnerId")
    def destination_endpoint_owner_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the Alibaba Cloud account to which the target RDS MySQL instance belongs. can be configured only when the target instance is RDS MySQL. This parameter is used to migrate or synchronize data across Alibaba Cloud accounts. You also need to enter the **destinationendpointrle** parameter.
        """
        return pulumi.get(self, "destination_endpoint_owner_id")

    @property
    @pulumi.getter(name="destinationEndpointPassword")
    def destination_endpoint_password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "destination_endpoint_password")

    @property
    @pulumi.getter(name="destinationEndpointPort")
    def destination_endpoint_port(self) -> pulumi.Output[Optional[str]]:
        """
        The port of source endpoint. When the target instance is a self-built database, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_port")

    @property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> pulumi.Output[Optional[str]]:
        """
        The region of destination instance. For the target instance region, please refer to the [list of supported regions](https://help.aliyun.com/document_detail/141033.htm). Note: if the target is an Alibaba Cloud database, this parameter must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_region")

    @property
    @pulumi.getter(name="destinationEndpointRole")
    def destination_endpoint_role(self) -> pulumi.Output[Optional[str]]:
        """
        The role name of the Alibaba Cloud account to which the target instance belongs. This parameter must be entered when data migration or synchronization across Alibaba Cloud accounts is performed. For the permissions and authorization methods required by this role.
        """
        return pulumi.get(self, "destination_endpoint_role")

    @property
    @pulumi.getter(name="destinationEndpointUserName")
    def destination_endpoint_user_name(self) -> pulumi.Output[Optional[str]]:
        """
        The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        """
        return pulumi.get(self, "destination_endpoint_user_name")

    @property
    @pulumi.getter(name="dtsBisLabel")
    def dts_bis_label(self) -> pulumi.Output[Optional[str]]:
        """
        The environment label of the DTS instance. The value is: **normal**, **online**.

        > **NOTE:** From the status of `NotStarted` to `Synchronizing`, the resource goes through the `Prechecking` and `Initializing` phases. Because of the `Initializing` phase takes too long, and once the resource passes to the status of `Prechecking`, it can be considered that the task can be executed normally. Therefore, we treat the status of `Initializing` as an equivalent to `Synchronizing`.

        > **NOTE:** If you want to upgrade the synchronization job specifications by the property `instance_class`, you must also modify the property `instance_class` of it's instance to keep them consistent.
        """
        return pulumi.get(self, "dts_bis_label")

    @property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> pulumi.Output[str]:
        """
        The ID of synchronization instance, it must be an ID of `dts.SynchronizationInstance`.
        """
        return pulumi.get(self, "dts_instance_id")

    @property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> pulumi.Output[str]:
        """
        The name of synchronization job.
        """
        return pulumi.get(self, "dts_job_name")

    @property
    @pulumi.getter(name="errorNotice")
    def error_notice(self) -> pulumi.Output[Optional[bool]]:
        """
        The error notice. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "error_notice")

    @property
    @pulumi.getter(name="errorPhone")
    def error_phone(self) -> pulumi.Output[Optional[str]]:
        """
        The error phone. The mobile phone number of the contact who error the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "error_phone")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[str]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter
    def reserve(self) -> pulumi.Output[str]:
        """
        DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter [description of the Reserve parameter](https://help.aliyun.com/document_detail/273111.html).
        """
        return pulumi.get(self, "reserve")

    @property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the database to which the migration object belongs in the source instance. Note: this parameter is only available and must be passed in when the source instance, or the database type of the source instance is PolarDB O engine, PostgreSQL, or MongoDB database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> pulumi.Output[str]:
        """
        The type of source database. The default value is `MySQL`. For the correspondence between supported source libraries and target libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the source instance is `MONGODB`, you also need to pass in some information in the reserved parameter `Reserve`, for the configuration method, see the description of Reserve parameters. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of source instance. If the source instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the source instance is a self-built database, the value of this parameter changes according to the value of `source_endpoint_instance_type`. For example, the value of `source_endpoint_instance_type` is:
        ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
        ** `DG`, then this parameter needs to be passed into the ID of database gateway.
        ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> pulumi.Output[str]:
        """
        The type of source instance. If the source instance is a `PolarDB O` engine cluster, the source instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. For the correspondence between supported source and target instances, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the source instance is a self-built database, you also need to perform corresponding preparations, for details, see [Preparations Overview](https://help.aliyun.com/document_detail/146958.htm). Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> pulumi.Output[Optional[str]]:
        """
        The IP of source endpoint. When `source_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> pulumi.Output[Optional[str]]:
        """
        The SID of Oracle database. When the value of SourceEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of Alibaba Cloud account to which the source instance belongs. Note: passing in this parameter means performing data migration or synchronization across Alibaba Cloud accounts, and you also need to pass in the `source_endpoint_role` parameter.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "source_endpoint_password")

    @property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> pulumi.Output[Optional[str]]:
        """
        The port of source endpoint. When the source instance is a self-built database, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_port")

    @property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> pulumi.Output[Optional[str]]:
        """
        Source instance area, please refer to the [list of supported areas](https://help.aliyun.com/document_detail/141033.htm) for details. Note if the source is an Alibaba Cloud database, this parameter must be passed in.
        """
        return pulumi.get(self, "source_endpoint_region")

    @property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the role configured for the cloud account to which the source instance belongs. Note: this parameter must be passed in when performing cross Alibaba Cloud account data migration or synchronization. For the permissions and authorization methods required by this role, please refer to [How to configure RAM authorization when cross-Alibaba Cloud account data migration or synchronization](https://help.aliyun.com/document_detail/48468.htm).
        """
        return pulumi.get(self, "source_endpoint_role")

    @property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> pulumi.Output[Optional[str]]:
        """
        The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help.aliyun.com/document_detail/175878.htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @property
    @pulumi.getter(name="sourceEndpointVswitchId")
    def source_endpoint_vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        Data Delivery link switch instance id
        """
        return pulumi.get(self, "source_endpoint_vswitch_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="structureInitialization")
    def structure_initialization(self) -> pulumi.Output[bool]:
        """
        Whether to perform library table structure migration or initialization. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "structure_initialization")

    @property
    @pulumi.getter(name="synchronizationDirection")
    def synchronization_direction(self) -> pulumi.Output[str]:
        """
        Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
        """
        return pulumi.get(self, "synchronization_direction")

