# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DiskReplicaGroupArgs', 'DiskReplicaGroup']

@pulumi.input_type
class DiskReplicaGroupArgs:
    def __init__(__self__, *,
                 destination_region_id: pulumi.Input[str],
                 destination_zone_id: pulumi.Input[str],
                 source_region_id: pulumi.Input[str],
                 source_zone_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 rpo: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a DiskReplicaGroup resource.
        :param pulumi.Input[str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[str] source_region_id: The ID of the region to which the production site belongs.
        :param pulumi.Input[str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[str] description: The description of the consistent replication group.
        :param pulumi.Input[str] group_name: Consistent replication group name.
        :param pulumi.Input[int] rpo: The recovery point objective (RPO) of the replication pair-consistent group. Unit: seconds.
        """
        pulumi.set(__self__, "destination_region_id", destination_region_id)
        pulumi.set(__self__, "destination_zone_id", destination_zone_id)
        pulumi.set(__self__, "source_region_id", source_region_id)
        pulumi.set(__self__, "source_zone_id", source_zone_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if rpo is not None:
            pulumi.set(__self__, "rpo", rpo)

    @property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> pulumi.Input[str]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @destination_region_id.setter
    def destination_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_region_id", value)

    @property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> pulumi.Input[str]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @destination_zone_id.setter
    def destination_zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_zone_id", value)

    @property
    @pulumi.getter(name="sourceRegionId")
    def source_region_id(self) -> pulumi.Input[str]:
        """
        The ID of the region to which the production site belongs.
        """
        return pulumi.get(self, "source_region_id")

    @source_region_id.setter
    def source_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_region_id", value)

    @property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> pulumi.Input[str]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @source_zone_id.setter
    def source_zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_zone_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the consistent replication group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Consistent replication group name.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter
    def rpo(self) -> Optional[pulumi.Input[int]]:
        """
        The recovery point objective (RPO) of the replication pair-consistent group. Unit: seconds.
        """
        return pulumi.get(self, "rpo")

    @rpo.setter
    def rpo(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rpo", value)


@pulumi.input_type
class _DiskReplicaGroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_region_id: Optional[pulumi.Input[str]] = None,
                 destination_zone_id: Optional[pulumi.Input[str]] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 rpo: Optional[pulumi.Input[int]] = None,
                 source_region_id: Optional[pulumi.Input[str]] = None,
                 source_zone_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DiskReplicaGroup resources.
        :param pulumi.Input[str] description: The description of the consistent replication group.
        :param pulumi.Input[str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[str] group_name: Consistent replication group name.
        :param pulumi.Input[int] rpo: The recovery point objective (RPO) of the replication pair-consistent group. Unit: seconds.
        :param pulumi.Input[str] source_region_id: The ID of the region to which the production site belongs.
        :param pulumi.Input[str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[str] status: The status of the consistent replication group.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_region_id is not None:
            pulumi.set(__self__, "destination_region_id", destination_region_id)
        if destination_zone_id is not None:
            pulumi.set(__self__, "destination_zone_id", destination_zone_id)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if rpo is not None:
            pulumi.set(__self__, "rpo", rpo)
        if source_region_id is not None:
            pulumi.set(__self__, "source_region_id", source_region_id)
        if source_zone_id is not None:
            pulumi.set(__self__, "source_zone_id", source_zone_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the consistent replication group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @destination_region_id.setter
    def destination_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_region_id", value)

    @property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @destination_zone_id.setter
    def destination_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_zone_id", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Consistent replication group name.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter
    def rpo(self) -> Optional[pulumi.Input[int]]:
        """
        The recovery point objective (RPO) of the replication pair-consistent group. Unit: seconds.
        """
        return pulumi.get(self, "rpo")

    @rpo.setter
    def rpo(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rpo", value)

    @property
    @pulumi.getter(name="sourceRegionId")
    def source_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the region to which the production site belongs.
        """
        return pulumi.get(self, "source_region_id")

    @source_region_id.setter
    def source_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_region_id", value)

    @property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @source_zone_id.setter
    def source_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_zone_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the consistent replication group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class DiskReplicaGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_region_id: Optional[pulumi.Input[str]] = None,
                 destination_zone_id: Optional[pulumi.Input[str]] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 rpo: Optional[pulumi.Input[int]] = None,
                 source_region_id: Optional[pulumi.Input[str]] = None,
                 source_zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a EBS Disk Replica Group resource.

        For information about EBS Disk Replica Group and how to use it, see [What is Disk Replica Group](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/creatediskreplicagroup).

        > **NOTE:** Available since v1.187.0.

        ## Import

        EBS Disk Replica Group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ebs/diskReplicaGroup:DiskReplicaGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the consistent replication group.
        :param pulumi.Input[str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[str] group_name: Consistent replication group name.
        :param pulumi.Input[int] rpo: The recovery point objective (RPO) of the replication pair-consistent group. Unit: seconds.
        :param pulumi.Input[str] source_region_id: The ID of the region to which the production site belongs.
        :param pulumi.Input[str] source_zone_id: The ID of the zone to which the production site belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiskReplicaGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a EBS Disk Replica Group resource.

        For information about EBS Disk Replica Group and how to use it, see [What is Disk Replica Group](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/creatediskreplicagroup).

        > **NOTE:** Available since v1.187.0.

        ## Import

        EBS Disk Replica Group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ebs/diskReplicaGroup:DiskReplicaGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DiskReplicaGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiskReplicaGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_region_id: Optional[pulumi.Input[str]] = None,
                 destination_zone_id: Optional[pulumi.Input[str]] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 rpo: Optional[pulumi.Input[int]] = None,
                 source_region_id: Optional[pulumi.Input[str]] = None,
                 source_zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiskReplicaGroupArgs.__new__(DiskReplicaGroupArgs)

            __props__.__dict__["description"] = description
            if destination_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_region_id'")
            __props__.__dict__["destination_region_id"] = destination_region_id
            if destination_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_zone_id'")
            __props__.__dict__["destination_zone_id"] = destination_zone_id
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["rpo"] = rpo
            if source_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_region_id'")
            __props__.__dict__["source_region_id"] = source_region_id
            if source_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_zone_id'")
            __props__.__dict__["source_zone_id"] = source_zone_id
            __props__.__dict__["status"] = None
        super(DiskReplicaGroup, __self__).__init__(
            'alicloud:ebs/diskReplicaGroup:DiskReplicaGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            destination_region_id: Optional[pulumi.Input[str]] = None,
            destination_zone_id: Optional[pulumi.Input[str]] = None,
            group_name: Optional[pulumi.Input[str]] = None,
            rpo: Optional[pulumi.Input[int]] = None,
            source_region_id: Optional[pulumi.Input[str]] = None,
            source_zone_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'DiskReplicaGroup':
        """
        Get an existing DiskReplicaGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the consistent replication group.
        :param pulumi.Input[str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[str] group_name: Consistent replication group name.
        :param pulumi.Input[int] rpo: The recovery point objective (RPO) of the replication pair-consistent group. Unit: seconds.
        :param pulumi.Input[str] source_region_id: The ID of the region to which the production site belongs.
        :param pulumi.Input[str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[str] status: The status of the consistent replication group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiskReplicaGroupState.__new__(_DiskReplicaGroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination_region_id"] = destination_region_id
        __props__.__dict__["destination_zone_id"] = destination_zone_id
        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["rpo"] = rpo
        __props__.__dict__["source_region_id"] = source_region_id
        __props__.__dict__["source_zone_id"] = source_zone_id
        __props__.__dict__["status"] = status
        return DiskReplicaGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the consistent replication group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> pulumi.Output[str]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> pulumi.Output[str]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[Optional[str]]:
        """
        Consistent replication group name.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def rpo(self) -> pulumi.Output[int]:
        """
        The recovery point objective (RPO) of the replication pair-consistent group. Unit: seconds.
        """
        return pulumi.get(self, "rpo")

    @property
    @pulumi.getter(name="sourceRegionId")
    def source_region_id(self) -> pulumi.Output[str]:
        """
        The ID of the region to which the production site belongs.
        """
        return pulumi.get(self, "source_region_id")

    @property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> pulumi.Output[str]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the consistent replication group.
        """
        return pulumi.get(self, "status")

