# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DiskReplicaPairArgs', 'DiskReplicaPair']

@pulumi.input_type
class DiskReplicaPairArgs:
    def __init__(__self__, *,
                 destination_disk_id: pulumi.Input[str],
                 destination_region_id: pulumi.Input[str],
                 destination_zone_id: pulumi.Input[str],
                 disk_id: pulumi.Input[str],
                 source_zone_id: pulumi.Input[str],
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 pair_name: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 replica_pair_id: Optional[pulumi.Input[str]] = None,
                 rpo: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DiskReplicaPair resource.
        :param pulumi.Input[str] destination_disk_id: The ID of the standby disk.
        :param pulumi.Input[str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[str] disk_id: The ID of the primary disk.
        :param pulumi.Input[str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[str] bandwidth: The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        :param pulumi.Input[str] description: The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        :param pulumi.Input[str] pair_name: The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        :param pulumi.Input[str] payment_type: The payment type of the resource
        :param pulumi.Input[str] period: The length of the purchase for the asynchronous replication relationship. When ChargeType=PrePay, this parameter is mandatory. The unit of duration is specified by PeriodUnit and takes on a range of values. When PeriodUnit=Week, this parameter takes values in the range `1`, `2`, `3` and `4`. When PeriodUnit=Month, the parameter takes on the values `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
        :param pulumi.Input[str] period_unit: The units of asynchronous replication relationship purchase length. Valid values: `Week` and `Month`. Default value: `Month`.
        :param pulumi.Input[str] replica_pair_id: The first ID of the resource.
        :param pulumi.Input[str] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        """
        pulumi.set(__self__, "destination_disk_id", destination_disk_id)
        pulumi.set(__self__, "destination_region_id", destination_region_id)
        pulumi.set(__self__, "destination_zone_id", destination_zone_id)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "source_zone_id", source_zone_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if pair_name is not None:
            pulumi.set(__self__, "pair_name", pair_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if replica_pair_id is not None:
            pulumi.set(__self__, "replica_pair_id", replica_pair_id)
        if rpo is not None:
            pulumi.set(__self__, "rpo", rpo)

    @property
    @pulumi.getter(name="destinationDiskId")
    def destination_disk_id(self) -> pulumi.Input[str]:
        """
        The ID of the standby disk.
        """
        return pulumi.get(self, "destination_disk_id")

    @destination_disk_id.setter
    def destination_disk_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_disk_id", value)

    @property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> pulumi.Input[str]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @destination_region_id.setter
    def destination_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_region_id", value)

    @property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> pulumi.Input[str]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @destination_zone_id.setter
    def destination_zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_zone_id", value)

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Input[str]:
        """
        The ID of the primary disk.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "disk_id", value)

    @property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> pulumi.Input[str]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @source_zone_id.setter
    def source_zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_zone_id", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="pairName")
    def pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        """
        return pulumi.get(self, "pair_name")

    @pair_name.setter
    def pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pair_name", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        The length of the purchase for the asynchronous replication relationship. When ChargeType=PrePay, this parameter is mandatory. The unit of duration is specified by PeriodUnit and takes on a range of values. When PeriodUnit=Week, this parameter takes values in the range `1`, `2`, `3` and `4`. When PeriodUnit=Month, the parameter takes on the values `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The units of asynchronous replication relationship purchase length. Valid values: `Week` and `Month`. Default value: `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="replicaPairId")
    def replica_pair_id(self) -> Optional[pulumi.Input[str]]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "replica_pair_id")

    @replica_pair_id.setter
    def replica_pair_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_pair_id", value)

    @property
    @pulumi.getter
    def rpo(self) -> Optional[pulumi.Input[str]]:
        """
        The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        """
        return pulumi.get(self, "rpo")

    @rpo.setter
    def rpo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rpo", value)


@pulumi.input_type
class _DiskReplicaPairState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_disk_id: Optional[pulumi.Input[str]] = None,
                 destination_region_id: Optional[pulumi.Input[str]] = None,
                 destination_zone_id: Optional[pulumi.Input[str]] = None,
                 disk_id: Optional[pulumi.Input[str]] = None,
                 pair_name: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 replica_pair_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 rpo: Optional[pulumi.Input[str]] = None,
                 source_zone_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DiskReplicaPair resources.
        :param pulumi.Input[str] bandwidth: The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        :param pulumi.Input[str] create_time: The creation time of the resource
        :param pulumi.Input[str] description: The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        :param pulumi.Input[str] destination_disk_id: The ID of the standby disk.
        :param pulumi.Input[str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[str] disk_id: The ID of the primary disk.
        :param pulumi.Input[str] pair_name: The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        :param pulumi.Input[str] payment_type: The payment type of the resource
        :param pulumi.Input[str] period: The length of the purchase for the asynchronous replication relationship. When ChargeType=PrePay, this parameter is mandatory. The unit of duration is specified by PeriodUnit and takes on a range of values. When PeriodUnit=Week, this parameter takes values in the range `1`, `2`, `3` and `4`. When PeriodUnit=Month, the parameter takes on the values `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
        :param pulumi.Input[str] period_unit: The units of asynchronous replication relationship purchase length. Valid values: `Week` and `Month`. Default value: `Month`.
        :param pulumi.Input[str] replica_pair_id: The first ID of the resource.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group
        :param pulumi.Input[str] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        :param pulumi.Input[str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[str] status: The status of the resource
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_disk_id is not None:
            pulumi.set(__self__, "destination_disk_id", destination_disk_id)
        if destination_region_id is not None:
            pulumi.set(__self__, "destination_region_id", destination_region_id)
        if destination_zone_id is not None:
            pulumi.set(__self__, "destination_zone_id", destination_zone_id)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if pair_name is not None:
            pulumi.set(__self__, "pair_name", pair_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if replica_pair_id is not None:
            pulumi.set(__self__, "replica_pair_id", replica_pair_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if rpo is not None:
            pulumi.set(__self__, "rpo", rpo)
        if source_zone_id is not None:
            pulumi.set(__self__, "source_zone_id", source_zone_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationDiskId")
    def destination_disk_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the standby disk.
        """
        return pulumi.get(self, "destination_disk_id")

    @destination_disk_id.setter
    def destination_disk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_disk_id", value)

    @property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @destination_region_id.setter
    def destination_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_region_id", value)

    @property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @destination_zone_id.setter
    def destination_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_zone_id", value)

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the primary disk.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_id", value)

    @property
    @pulumi.getter(name="pairName")
    def pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        """
        return pulumi.get(self, "pair_name")

    @pair_name.setter
    def pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pair_name", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        The length of the purchase for the asynchronous replication relationship. When ChargeType=PrePay, this parameter is mandatory. The unit of duration is specified by PeriodUnit and takes on a range of values. When PeriodUnit=Week, this parameter takes values in the range `1`, `2`, `3` and `4`. When PeriodUnit=Month, the parameter takes on the values `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The units of asynchronous replication relationship purchase length. Valid values: `Week` and `Month`. Default value: `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="replicaPairId")
    def replica_pair_id(self) -> Optional[pulumi.Input[str]]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "replica_pair_id")

    @replica_pair_id.setter
    def replica_pair_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_pair_id", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def rpo(self) -> Optional[pulumi.Input[str]]:
        """
        The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        """
        return pulumi.get(self, "rpo")

    @rpo.setter
    def rpo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rpo", value)

    @property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @source_zone_id.setter
    def source_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_zone_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class DiskReplicaPair(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_disk_id: Optional[pulumi.Input[str]] = None,
                 destination_region_id: Optional[pulumi.Input[str]] = None,
                 destination_zone_id: Optional[pulumi.Input[str]] = None,
                 disk_id: Optional[pulumi.Input[str]] = None,
                 pair_name: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 replica_pair_id: Optional[pulumi.Input[str]] = None,
                 rpo: Optional[pulumi.Input[str]] = None,
                 source_zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Ebs Disk Replica Pair resource.

        For information about Ebs Disk Replica Pair and how to use it, see [What is Disk Replica Pair](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/CreateDiskReplicaPair).

        > **NOTE:** Available since v1.196.0.

        ## Import

        Ebs Disk Replica Pair can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ebs/diskReplicaPair:DiskReplicaPair example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bandwidth: The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        :param pulumi.Input[str] description: The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        :param pulumi.Input[str] destination_disk_id: The ID of the standby disk.
        :param pulumi.Input[str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[str] disk_id: The ID of the primary disk.
        :param pulumi.Input[str] pair_name: The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        :param pulumi.Input[str] payment_type: The payment type of the resource
        :param pulumi.Input[str] period: The length of the purchase for the asynchronous replication relationship. When ChargeType=PrePay, this parameter is mandatory. The unit of duration is specified by PeriodUnit and takes on a range of values. When PeriodUnit=Week, this parameter takes values in the range `1`, `2`, `3` and `4`. When PeriodUnit=Month, the parameter takes on the values `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
        :param pulumi.Input[str] period_unit: The units of asynchronous replication relationship purchase length. Valid values: `Week` and `Month`. Default value: `Month`.
        :param pulumi.Input[str] replica_pair_id: The first ID of the resource.
        :param pulumi.Input[str] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        :param pulumi.Input[str] source_zone_id: The ID of the zone to which the production site belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiskReplicaPairArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Ebs Disk Replica Pair resource.

        For information about Ebs Disk Replica Pair and how to use it, see [What is Disk Replica Pair](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/CreateDiskReplicaPair).

        > **NOTE:** Available since v1.196.0.

        ## Import

        Ebs Disk Replica Pair can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ebs/diskReplicaPair:DiskReplicaPair example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DiskReplicaPairArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiskReplicaPairArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_disk_id: Optional[pulumi.Input[str]] = None,
                 destination_region_id: Optional[pulumi.Input[str]] = None,
                 destination_zone_id: Optional[pulumi.Input[str]] = None,
                 disk_id: Optional[pulumi.Input[str]] = None,
                 pair_name: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 replica_pair_id: Optional[pulumi.Input[str]] = None,
                 rpo: Optional[pulumi.Input[str]] = None,
                 source_zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiskReplicaPairArgs.__new__(DiskReplicaPairArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["description"] = description
            if destination_disk_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_disk_id'")
            __props__.__dict__["destination_disk_id"] = destination_disk_id
            if destination_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_region_id'")
            __props__.__dict__["destination_region_id"] = destination_region_id
            if destination_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_zone_id'")
            __props__.__dict__["destination_zone_id"] = destination_zone_id
            if disk_id is None and not opts.urn:
                raise TypeError("Missing required property 'disk_id'")
            __props__.__dict__["disk_id"] = disk_id
            __props__.__dict__["pair_name"] = pair_name
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["replica_pair_id"] = replica_pair_id
            __props__.__dict__["rpo"] = rpo
            if source_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_zone_id'")
            __props__.__dict__["source_zone_id"] = source_zone_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["resource_group_id"] = None
            __props__.__dict__["status"] = None
        super(DiskReplicaPair, __self__).__init__(
            'alicloud:ebs/diskReplicaPair:DiskReplicaPair',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            destination_disk_id: Optional[pulumi.Input[str]] = None,
            destination_region_id: Optional[pulumi.Input[str]] = None,
            destination_zone_id: Optional[pulumi.Input[str]] = None,
            disk_id: Optional[pulumi.Input[str]] = None,
            pair_name: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[str]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            replica_pair_id: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            rpo: Optional[pulumi.Input[str]] = None,
            source_zone_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'DiskReplicaPair':
        """
        Get an existing DiskReplicaPair resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bandwidth: The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        :param pulumi.Input[str] create_time: The creation time of the resource
        :param pulumi.Input[str] description: The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        :param pulumi.Input[str] destination_disk_id: The ID of the standby disk.
        :param pulumi.Input[str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[str] disk_id: The ID of the primary disk.
        :param pulumi.Input[str] pair_name: The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        :param pulumi.Input[str] payment_type: The payment type of the resource
        :param pulumi.Input[str] period: The length of the purchase for the asynchronous replication relationship. When ChargeType=PrePay, this parameter is mandatory. The unit of duration is specified by PeriodUnit and takes on a range of values. When PeriodUnit=Week, this parameter takes values in the range `1`, `2`, `3` and `4`. When PeriodUnit=Month, the parameter takes on the values `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
        :param pulumi.Input[str] period_unit: The units of asynchronous replication relationship purchase length. Valid values: `Week` and `Month`. Default value: `Month`.
        :param pulumi.Input[str] replica_pair_id: The first ID of the resource.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group
        :param pulumi.Input[str] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        :param pulumi.Input[str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[str] status: The status of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiskReplicaPairState.__new__(_DiskReplicaPairState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_disk_id"] = destination_disk_id
        __props__.__dict__["destination_region_id"] = destination_region_id
        __props__.__dict__["destination_zone_id"] = destination_zone_id
        __props__.__dict__["disk_id"] = disk_id
        __props__.__dict__["pair_name"] = pair_name
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["replica_pair_id"] = replica_pair_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["rpo"] = rpo
        __props__.__dict__["source_zone_id"] = source_zone_id
        __props__.__dict__["status"] = status
        return DiskReplicaPair(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[str]:
        """
        The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationDiskId")
    def destination_disk_id(self) -> pulumi.Output[str]:
        """
        The ID of the standby disk.
        """
        return pulumi.get(self, "destination_disk_id")

    @property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> pulumi.Output[str]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> pulumi.Output[str]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Output[str]:
        """
        The ID of the primary disk.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="pairName")
    def pair_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        """
        return pulumi.get(self, "pair_name")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[Optional[str]]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[str]]:
        """
        The length of the purchase for the asynchronous replication relationship. When ChargeType=PrePay, this parameter is mandatory. The unit of duration is specified by PeriodUnit and takes on a range of values. When PeriodUnit=Week, this parameter takes values in the range `1`, `2`, `3` and `4`. When PeriodUnit=Month, the parameter takes on the values `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        The units of asynchronous replication relationship purchase length. Valid values: `Week` and `Month`. Default value: `Month`.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="replicaPairId")
    def replica_pair_id(self) -> pulumi.Output[str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "replica_pair_id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def rpo(self) -> pulumi.Output[str]:
        """
        The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        """
        return pulumi.get(self, "rpo")

    @property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> pulumi.Output[str]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

