# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDiskReplicaGroupsResult',
    'AwaitableGetDiskReplicaGroupsResult',
    'get_disk_replica_groups',
    'get_disk_replica_groups_output',
]

@pulumi.output_type
class GetDiskReplicaGroupsResult:
    """
    A collection of values returned by getDiskReplicaGroups.
    """
    def __init__(__self__, groups=None, id=None, ids=None, output_file=None):
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetDiskReplicaGroupsGroupResult']:
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")


class AwaitableGetDiskReplicaGroupsResult(GetDiskReplicaGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiskReplicaGroupsResult(
            groups=self.groups,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file)


def get_disk_replica_groups(ids: Optional[Sequence[str]] = None,
                            output_file: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiskReplicaGroupsResult:
    """
    This data source provides the Ebs Disk Replica Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.187.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ebs.get_disk_replica_groups(ids=["example_id"])
    pulumi.export("ebsDiskReplicaGroupId1", ids.groups[0].id)
    ```


    :param Sequence[str] ids: A list of Disk Replica Group IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ebs/getDiskReplicaGroups:getDiskReplicaGroups', __args__, opts=opts, typ=GetDiskReplicaGroupsResult).value

    return AwaitableGetDiskReplicaGroupsResult(
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'))


@_utilities.lift_output_func(get_disk_replica_groups)
def get_disk_replica_groups_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                   output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDiskReplicaGroupsResult]:
    """
    This data source provides the Ebs Disk Replica Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.187.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ebs.get_disk_replica_groups(ids=["example_id"])
    pulumi.export("ebsDiskReplicaGroupId1", ids.groups[0].id)
    ```


    :param Sequence[str] ids: A list of Disk Replica Group IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
