# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ContainerGroupAcrRegistryInfoArgs',
    'ContainerGroupContainerArgs',
    'ContainerGroupContainerEnvironmentVarArgs',
    'ContainerGroupContainerLivenessProbeArgs',
    'ContainerGroupContainerLivenessProbeExecArgs',
    'ContainerGroupContainerLivenessProbeHttpGetArgs',
    'ContainerGroupContainerLivenessProbeTcpSocketArgs',
    'ContainerGroupContainerPortArgs',
    'ContainerGroupContainerReadinessProbeArgs',
    'ContainerGroupContainerReadinessProbeExecArgs',
    'ContainerGroupContainerReadinessProbeHttpGetArgs',
    'ContainerGroupContainerReadinessProbeTcpSocketArgs',
    'ContainerGroupContainerVolumeMountArgs',
    'ContainerGroupDnsConfigArgs',
    'ContainerGroupDnsConfigOptionArgs',
    'ContainerGroupEciSecurityContextArgs',
    'ContainerGroupEciSecurityContextSysctlArgs',
    'ContainerGroupHostAliasArgs',
    'ContainerGroupImageRegistryCredentialArgs',
    'ContainerGroupInitContainerArgs',
    'ContainerGroupInitContainerEnvironmentVarArgs',
    'ContainerGroupInitContainerPortArgs',
    'ContainerGroupInitContainerVolumeMountArgs',
    'ContainerGroupVolumeArgs',
    'ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs',
    'ImageCacheImageRegistryCredentialArgs',
    'OpenApiImageCacheImageRegistryCredentialArgs',
    'VirtualNodeTaintArgs',
]

@pulumi.input_type
class ContainerGroupAcrRegistryInfoArgs:
    def __init__(__self__, *,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: The domain name of the ACR Enterprise Edition instance. Defaults to all domain names of the corresponding instance. Support specifying individual domain names, multiple separated by half comma.
        :param pulumi.Input[str] instance_id: The ACR enterprise edition example ID.
        :param pulumi.Input[str] instance_name: The name of the ACR enterprise edition instance.
        :param pulumi.Input[str] region_id: The ACR enterprise edition instance belongs to the region.
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The domain name of the ACR Enterprise Edition instance. Defaults to all domain names of the corresponding instance. Support specifying individual domain names, multiple separated by half comma.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ACR enterprise edition example ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ACR enterprise edition instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ACR enterprise edition instance belongs to the region.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_id", value)


@pulumi.input_type
class ContainerGroupContainerArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 name: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cpu: Optional[pulumi.Input[float]] = None,
                 environment_vars: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerEnvironmentVarArgs']]]] = None,
                 gpu: Optional[pulumi.Input[int]] = None,
                 image_pull_policy: Optional[pulumi.Input[str]] = None,
                 liveness_probes: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeArgs']]]] = None,
                 memory: Optional[pulumi.Input[float]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerPortArgs']]]] = None,
                 readiness_probes: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeArgs']]]] = None,
                 ready: Optional[pulumi.Input[bool]] = None,
                 restart_count: Optional[pulumi.Input[int]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerVolumeMountArgs']]]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] image: The image of the container.
        :param pulumi.Input[str] name: The name of the mounted volume.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: The arguments passed to the commands.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Commands to be executed inside the container when performing health checks using the command line method.
        :param pulumi.Input[float] cpu: The amount of CPU resources allocated to the container. Default value: `0`.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerEnvironmentVarArgs']]] environment_vars: The structure of environmentVars. See `environment_vars` below.
        :param pulumi.Input[int] gpu: The number GPUs. Default value: `0`.
        :param pulumi.Input[str] image_pull_policy: The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeArgs']]] liveness_probes: The health check of the container. See `liveness_probe` below.
        :param pulumi.Input[float] memory: The amount of memory resources allocated to the container. Default value: `0`.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerPortArgs']]] ports: The structure of port. See `ports` below.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeArgs']]] readiness_probes: The health check of the container. See `readiness_probe` below.
        :param pulumi.Input[bool] ready: Indicates whether the container passed the readiness probe.
        :param pulumi.Input[int] restart_count: The number of times that the container restarted.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerVolumeMountArgs']]] volume_mounts: The structure of volumeMounts. See `volume_mounts` below.
        :param pulumi.Input[str] working_dir: The working directory of the container.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if liveness_probes is not None:
            pulumi.set(__self__, "liveness_probes", liveness_probes)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probes is not None:
            pulumi.set(__self__, "readiness_probes", readiness_probes)
        if ready is not None:
            pulumi.set(__self__, "ready", ready)
        if restart_count is not None:
            pulumi.set(__self__, "restart_count", restart_count)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The arguments passed to the commands.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Commands to be executed inside the container when performing health checks using the command line method.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of CPU resources allocated to the container. Default value: `0`.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerEnvironmentVarArgs']]]]:
        """
        The structure of environmentVars. See `environment_vars` below.
        """
        return pulumi.get(self, "environment_vars")

    @environment_vars.setter
    def environment_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerEnvironmentVarArgs']]]]):
        pulumi.set(self, "environment_vars", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[int]]:
        """
        The number GPUs. Default value: `0`.
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
        """
        return pulumi.get(self, "image_pull_policy")

    @image_pull_policy.setter
    def image_pull_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_pull_policy", value)

    @property
    @pulumi.getter(name="livenessProbes")
    def liveness_probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeArgs']]]]:
        """
        The health check of the container. See `liveness_probe` below.
        """
        return pulumi.get(self, "liveness_probes")

    @liveness_probes.setter
    def liveness_probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeArgs']]]]):
        pulumi.set(self, "liveness_probes", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of memory resources allocated to the container. Default value: `0`.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerPortArgs']]]]:
        """
        The structure of port. See `ports` below.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="readinessProbes")
    def readiness_probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeArgs']]]]:
        """
        The health check of the container. See `readiness_probe` below.
        """
        return pulumi.get(self, "readiness_probes")

    @readiness_probes.setter
    def readiness_probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeArgs']]]]):
        pulumi.set(self, "readiness_probes", value)

    @property
    @pulumi.getter
    def ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the container passed the readiness probe.
        """
        return pulumi.get(self, "ready")

    @ready.setter
    def ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ready", value)

    @property
    @pulumi.getter(name="restartCount")
    def restart_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times that the container restarted.
        """
        return pulumi.get(self, "restart_count")

    @restart_count.setter
    def restart_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "restart_count", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerVolumeMountArgs']]]]:
        """
        The structure of volumeMounts. See `volume_mounts` below.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class ContainerGroupContainerEnvironmentVarArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The name of the variable. The name can be 1 to 128 characters in length and can contain letters, digits, and underscores (_). It cannot start with a digit.
        :param pulumi.Input[str] value: The value of the variable. The value can be 0 to 256 characters in length.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the variable. The name can be 1 to 128 characters in length and can contain letters, digits, and underscores (_). It cannot start with a digit.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the variable. The value can be 0 to 256 characters in length.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContainerGroupContainerLivenessProbeArgs:
    def __init__(__self__, *,
                 execs: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeExecArgs']]]] = None,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 http_gets: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeHttpGetArgs']]]] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 tcp_sockets: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeTcpSocketArgs']]]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeExecArgs']]] execs: Health check using command line method. See `exec` below.
        :param pulumi.Input[int] failure_threshold: Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeHttpGetArgs']]] http_gets: Health check using HTTP request method. See `http_get` below.
        :param pulumi.Input[int] initial_delay_seconds: Check the time to start execution, calculated from the completion of container startup.
        :param pulumi.Input[int] period_seconds: Buffer time for the program to handle operations before closing.
        :param pulumi.Input[int] success_threshold: The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeTcpSocketArgs']]] tcp_sockets: Health check using TCP socket method. See `tcp_socket` below.
        :param pulumi.Input[int] timeout_seconds: Check the timeout, the default is 1 second, the minimum is 1 second.
        """
        if execs is not None:
            pulumi.set(__self__, "execs", execs)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_gets is not None:
            pulumi.set(__self__, "http_gets", http_gets)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if tcp_sockets is not None:
            pulumi.set(__self__, "tcp_sockets", tcp_sockets)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def execs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeExecArgs']]]]:
        """
        Health check using command line method. See `exec` below.
        """
        return pulumi.get(self, "execs")

    @execs.setter
    def execs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeExecArgs']]]]):
        pulumi.set(self, "execs", value)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="httpGets")
    def http_gets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeHttpGetArgs']]]]:
        """
        Health check using HTTP request method. See `http_get` below.
        """
        return pulumi.get(self, "http_gets")

    @http_gets.setter
    def http_gets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeHttpGetArgs']]]]):
        pulumi.set(self, "http_gets", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Check the time to start execution, calculated from the completion of container startup.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Buffer time for the program to handle operations before closing.
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter(name="tcpSockets")
    def tcp_sockets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeTcpSocketArgs']]]]:
        """
        Health check using TCP socket method. See `tcp_socket` below.
        """
        return pulumi.get(self, "tcp_sockets")

    @tcp_sockets.setter
    def tcp_sockets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerLivenessProbeTcpSocketArgs']]]]):
        pulumi.set(self, "tcp_sockets", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Check the timeout, the default is 1 second, the minimum is 1 second.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class ContainerGroupContainerLivenessProbeExecArgs:
    def __init__(__self__, *,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Commands to be executed inside the container when performing health checks using the command line method.
        """
        if commands is not None:
            pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Commands to be executed inside the container when performing health checks using the command line method.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)


@pulumi.input_type
class ContainerGroupContainerLivenessProbeHttpGetArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 scheme: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] path: The path of HTTP Get request detection when setting the postStart callback function using the HTTP request method.
        :param pulumi.Input[int] port: When using the HTTP request method for health check, the port number for HTTP Get request detection.
        :param pulumi.Input[str] scheme: The protocol type corresponding to the HTTP Get request when using the HTTP request method for health checks. Valid values: `HTTP`, `HTTPS`.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of HTTP Get request detection when setting the postStart callback function using the HTTP request method.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        When using the HTTP request method for health check, the port number for HTTP Get request detection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol type corresponding to the HTTP Get request when using the HTTP request method for health checks. Valid values: `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheme", value)


@pulumi.input_type
class ContainerGroupContainerLivenessProbeTcpSocketArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] port: When using the HTTP request method for health check, the port number for HTTP Get request detection.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        When using the HTTP request method for health check, the port number for HTTP Get request detection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ContainerGroupContainerPortArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: When using the HTTP request method for health check, the port number for HTTP Get request detection.
        :param pulumi.Input[str] protocol: The type of the protocol. Valid values: `TCP` and `UDP`.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        When using the HTTP request method for health check, the port number for HTTP Get request detection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the protocol. Valid values: `TCP` and `UDP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class ContainerGroupContainerReadinessProbeArgs:
    def __init__(__self__, *,
                 execs: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeExecArgs']]]] = None,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 http_gets: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeHttpGetArgs']]]] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 tcp_sockets: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeTcpSocketArgs']]]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeExecArgs']]] execs: Health check using command line method. See `exec` below.
        :param pulumi.Input[int] failure_threshold: Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeHttpGetArgs']]] http_gets: Health check using HTTP request method. See `http_get` below.
        :param pulumi.Input[int] initial_delay_seconds: Check the time to start execution, calculated from the completion of container startup.
        :param pulumi.Input[int] period_seconds: Buffer time for the program to handle operations before closing.
        :param pulumi.Input[int] success_threshold: The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeTcpSocketArgs']]] tcp_sockets: Health check using TCP socket method. See `tcp_socket` below.
        :param pulumi.Input[int] timeout_seconds: Check the timeout, the default is 1 second, the minimum is 1 second.
        """
        if execs is not None:
            pulumi.set(__self__, "execs", execs)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_gets is not None:
            pulumi.set(__self__, "http_gets", http_gets)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if tcp_sockets is not None:
            pulumi.set(__self__, "tcp_sockets", tcp_sockets)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def execs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeExecArgs']]]]:
        """
        Health check using command line method. See `exec` below.
        """
        return pulumi.get(self, "execs")

    @execs.setter
    def execs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeExecArgs']]]]):
        pulumi.set(self, "execs", value)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="httpGets")
    def http_gets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeHttpGetArgs']]]]:
        """
        Health check using HTTP request method. See `http_get` below.
        """
        return pulumi.get(self, "http_gets")

    @http_gets.setter
    def http_gets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeHttpGetArgs']]]]):
        pulumi.set(self, "http_gets", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Check the time to start execution, calculated from the completion of container startup.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Buffer time for the program to handle operations before closing.
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter(name="tcpSockets")
    def tcp_sockets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeTcpSocketArgs']]]]:
        """
        Health check using TCP socket method. See `tcp_socket` below.
        """
        return pulumi.get(self, "tcp_sockets")

    @tcp_sockets.setter
    def tcp_sockets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerReadinessProbeTcpSocketArgs']]]]):
        pulumi.set(self, "tcp_sockets", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Check the timeout, the default is 1 second, the minimum is 1 second.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class ContainerGroupContainerReadinessProbeExecArgs:
    def __init__(__self__, *,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Commands to be executed inside the container when performing health checks using the command line method.
        """
        if commands is not None:
            pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Commands to be executed inside the container when performing health checks using the command line method.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)


@pulumi.input_type
class ContainerGroupContainerReadinessProbeHttpGetArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 scheme: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] path: The path of HTTP Get request detection when setting the postStart callback function using the HTTP request method.
        :param pulumi.Input[int] port: When using the HTTP request method for health check, the port number for HTTP Get request detection.
        :param pulumi.Input[str] scheme: The protocol type corresponding to the HTTP Get request when using the HTTP request method for health checks. Valid values: `HTTP`, `HTTPS`.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of HTTP Get request detection when setting the postStart callback function using the HTTP request method.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        When using the HTTP request method for health check, the port number for HTTP Get request detection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol type corresponding to the HTTP Get request when using the HTTP request method for health checks. Valid values: `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheme", value)


@pulumi.input_type
class ContainerGroupContainerReadinessProbeTcpSocketArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] port: When using the HTTP request method for health check, the port number for HTTP Get request detection.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        When using the HTTP request method for health check, the port number for HTTP Get request detection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ContainerGroupContainerVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] mount_path: The directory of the mounted volume. Data under this directory will be overwritten by the data in the volume.
        :param pulumi.Input[str] name: The name of the mounted volume.
        :param pulumi.Input[bool] read_only: Specifies whether the volume is read-only. Default value: `false`.
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        The directory of the mounted volume. Data under this directory will be overwritten by the data in the volume.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the volume is read-only. Default value: `false`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class ContainerGroupDnsConfigArgs:
    def __init__(__self__, *,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDnsConfigOptionArgs']]]] = None,
                 searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] name_servers: The list of DNS server IP addresses.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupDnsConfigOptionArgs']]] options: The structure of options. See `options` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] searches: The list of DNS lookup domains.
        """
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if searches is not None:
            pulumi.set(__self__, "searches", searches)

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of DNS server IP addresses.
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "name_servers", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDnsConfigOptionArgs']]]]:
        """
        The structure of options. See `options` below.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDnsConfigOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def searches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of DNS lookup domains.
        """
        return pulumi.get(self, "searches")

    @searches.setter
    def searches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "searches", value)


@pulumi.input_type
class ContainerGroupDnsConfigOptionArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the mounted volume.
        :param pulumi.Input[str] value: The value of the variable. The value can be 0 to 256 characters in length.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the variable. The value can be 0 to 256 characters in length.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContainerGroupEciSecurityContextArgs:
    def __init__(__self__, *,
                 sysctls: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupEciSecurityContextSysctlArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupEciSecurityContextSysctlArgs']]] sysctls: Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctls` below.
        """
        if sysctls is not None:
            pulumi.set(__self__, "sysctls", sysctls)

    @property
    @pulumi.getter
    def sysctls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupEciSecurityContextSysctlArgs']]]]:
        """
        Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctls` below.
        """
        return pulumi.get(self, "sysctls")

    @sysctls.setter
    def sysctls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupEciSecurityContextSysctlArgs']]]]):
        pulumi.set(self, "sysctls", value)


@pulumi.input_type
class ContainerGroupEciSecurityContextSysctlArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the mounted volume.
        :param pulumi.Input[str] value: The value of the variable. The value can be 0 to 256 characters in length.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the variable. The value can be 0 to 256 characters in length.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContainerGroupHostAliasArgs:
    def __init__(__self__, *,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: The information about the host.
        :param pulumi.Input[str] ip: The IP address of the host.
        """
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The information about the host.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the host.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class ContainerGroupImageRegistryCredentialArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 server: pulumi.Input[str],
                 user_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: The password used to log on to the image repository. It is required when `image_registry_credential` is configured.
        :param pulumi.Input[str] server: The address of the image repository. It is required when `image_registry_credential` is configured.
        :param pulumi.Input[str] user_name: The username used to log on to the image repository. It is required when `image_registry_credential` is configured.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password used to log on to the image repository. It is required when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[str]:
        """
        The address of the image repository. It is required when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        The username used to log on to the image repository. It is required when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class ContainerGroupInitContainerArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cpu: Optional[pulumi.Input[float]] = None,
                 environment_vars: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerEnvironmentVarArgs']]]] = None,
                 gpu: Optional[pulumi.Input[int]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 image_pull_policy: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerPortArgs']]]] = None,
                 ready: Optional[pulumi.Input[bool]] = None,
                 restart_count: Optional[pulumi.Input[int]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerVolumeMountArgs']]]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: The arguments passed to the commands.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: The commands run by the init container.
        :param pulumi.Input[float] cpu: The amount of CPU resources allocated to the container. Default value: `0`.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerEnvironmentVarArgs']]] environment_vars: The structure of environmentVars. See `environment_vars` below.
        :param pulumi.Input[int] gpu: The number GPUs. Default value: `0`.
        :param pulumi.Input[str] image: The image of the container.
        :param pulumi.Input[str] image_pull_policy: The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
        :param pulumi.Input[float] memory: The amount of memory resources allocated to the container. Default value: `0`.
        :param pulumi.Input[str] name: The name of the mounted volume.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerPortArgs']]] ports: The structure of port. See `ports` below.
        :param pulumi.Input[bool] ready: Indicates whether the container passed the readiness probe.
        :param pulumi.Input[int] restart_count: The number of times that the container restarted.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerVolumeMountArgs']]] volume_mounts: The structure of volumeMounts. See `volume_mounts` below.
        :param pulumi.Input[str] working_dir: The working directory of the container.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if ready is not None:
            pulumi.set(__self__, "ready", ready)
        if restart_count is not None:
            pulumi.set(__self__, "restart_count", restart_count)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The arguments passed to the commands.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The commands run by the init container.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of CPU resources allocated to the container. Default value: `0`.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerEnvironmentVarArgs']]]]:
        """
        The structure of environmentVars. See `environment_vars` below.
        """
        return pulumi.get(self, "environment_vars")

    @environment_vars.setter
    def environment_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerEnvironmentVarArgs']]]]):
        pulumi.set(self, "environment_vars", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[int]]:
        """
        The number GPUs. Default value: `0`.
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
        """
        return pulumi.get(self, "image_pull_policy")

    @image_pull_policy.setter
    def image_pull_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_pull_policy", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of memory resources allocated to the container. Default value: `0`.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerPortArgs']]]]:
        """
        The structure of port. See `ports` below.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the container passed the readiness probe.
        """
        return pulumi.get(self, "ready")

    @ready.setter
    def ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ready", value)

    @property
    @pulumi.getter(name="restartCount")
    def restart_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times that the container restarted.
        """
        return pulumi.get(self, "restart_count")

    @restart_count.setter
    def restart_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "restart_count", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerVolumeMountArgs']]]]:
        """
        The structure of volumeMounts. See `volume_mounts` below.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class ContainerGroupInitContainerEnvironmentVarArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The name of the variable. The name can be 1 to 128 characters in length and can contain letters, digits, and underscores (_). It cannot start with a digit.
        :param pulumi.Input[str] value: The value of the variable. The value can be 0 to 256 characters in length.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the variable. The name can be 1 to 128 characters in length and can contain letters, digits, and underscores (_). It cannot start with a digit.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the variable. The value can be 0 to 256 characters in length.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContainerGroupInitContainerPortArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: When using the HTTP request method for health check, the port number for HTTP Get request detection.
        :param pulumi.Input[str] protocol: The type of the protocol. Valid values: `TCP` and `UDP`.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        When using the HTTP request method for health check, the port number for HTTP Get request detection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the protocol. Valid values: `TCP` and `UDP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class ContainerGroupInitContainerVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] mount_path: The directory of the mounted volume. Data under this directory will be overwritten by the data in the volume.
        :param pulumi.Input[str] name: The name of the mounted volume.
        :param pulumi.Input[bool] read_only: Specifies whether the volume is read-only. Default value: `false`.
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        The directory of the mounted volume. Data under this directory will be overwritten by the data in the volume.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the volume is read-only. Default value: `false`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class ContainerGroupVolumeArgs:
    def __init__(__self__, *,
                 config_file_volume_config_file_to_paths: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs']]]] = None,
                 disk_volume_disk_id: Optional[pulumi.Input[str]] = None,
                 disk_volume_fs_type: Optional[pulumi.Input[str]] = None,
                 flex_volume_driver: Optional[pulumi.Input[str]] = None,
                 flex_volume_fs_type: Optional[pulumi.Input[str]] = None,
                 flex_volume_options: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nfs_volume_path: Optional[pulumi.Input[str]] = None,
                 nfs_volume_read_only: Optional[pulumi.Input[bool]] = None,
                 nfs_volume_server: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs']]] config_file_volume_config_file_to_paths: The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
               > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
        :param pulumi.Input[str] disk_volume_disk_id: The ID of DiskVolume.
        :param pulumi.Input[str] disk_volume_fs_type: The system type of DiskVolume.
        :param pulumi.Input[str] flex_volume_driver: The name of the FlexVolume driver.
        :param pulumi.Input[str] flex_volume_fs_type: The type of the mounted file system. The default value is determined by the script of FlexVolume.
        :param pulumi.Input[str] flex_volume_options: The list of FlexVolume objects. Each object is a key-value pair contained in a JSON string.
        :param pulumi.Input[str] name: The name of the volume.
        :param pulumi.Input[str] nfs_volume_path: The path to the NFS volume.
        :param pulumi.Input[bool] nfs_volume_read_only: The nfs volume read only. Default value: `false`.
        :param pulumi.Input[str] nfs_volume_server: The address of the NFS server.
        :param pulumi.Input[str] type: The type of the volume.
        """
        if config_file_volume_config_file_to_paths is not None:
            pulumi.set(__self__, "config_file_volume_config_file_to_paths", config_file_volume_config_file_to_paths)
        if disk_volume_disk_id is not None:
            pulumi.set(__self__, "disk_volume_disk_id", disk_volume_disk_id)
        if disk_volume_fs_type is not None:
            pulumi.set(__self__, "disk_volume_fs_type", disk_volume_fs_type)
        if flex_volume_driver is not None:
            pulumi.set(__self__, "flex_volume_driver", flex_volume_driver)
        if flex_volume_fs_type is not None:
            pulumi.set(__self__, "flex_volume_fs_type", flex_volume_fs_type)
        if flex_volume_options is not None:
            pulumi.set(__self__, "flex_volume_options", flex_volume_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_volume_path is not None:
            pulumi.set(__self__, "nfs_volume_path", nfs_volume_path)
        if nfs_volume_read_only is not None:
            pulumi.set(__self__, "nfs_volume_read_only", nfs_volume_read_only)
        if nfs_volume_server is not None:
            pulumi.set(__self__, "nfs_volume_server", nfs_volume_server)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="configFileVolumeConfigFileToPaths")
    def config_file_volume_config_file_to_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs']]]]:
        """
        The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
        > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
        """
        return pulumi.get(self, "config_file_volume_config_file_to_paths")

    @config_file_volume_config_file_to_paths.setter
    def config_file_volume_config_file_to_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs']]]]):
        pulumi.set(self, "config_file_volume_config_file_to_paths", value)

    @property
    @pulumi.getter(name="diskVolumeDiskId")
    def disk_volume_disk_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_disk_id")

    @disk_volume_disk_id.setter
    def disk_volume_disk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_volume_disk_id", value)

    @property
    @pulumi.getter(name="diskVolumeFsType")
    def disk_volume_fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        The system type of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_fs_type")

    @disk_volume_fs_type.setter
    def disk_volume_fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_volume_fs_type", value)

    @property
    @pulumi.getter(name="flexVolumeDriver")
    def flex_volume_driver(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the FlexVolume driver.
        """
        return pulumi.get(self, "flex_volume_driver")

    @flex_volume_driver.setter
    def flex_volume_driver(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flex_volume_driver", value)

    @property
    @pulumi.getter(name="flexVolumeFsType")
    def flex_volume_fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the mounted file system. The default value is determined by the script of FlexVolume.
        """
        return pulumi.get(self, "flex_volume_fs_type")

    @flex_volume_fs_type.setter
    def flex_volume_fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flex_volume_fs_type", value)

    @property
    @pulumi.getter(name="flexVolumeOptions")
    def flex_volume_options(self) -> Optional[pulumi.Input[str]]:
        """
        The list of FlexVolume objects. Each object is a key-value pair contained in a JSON string.
        """
        return pulumi.get(self, "flex_volume_options")

    @flex_volume_options.setter
    def flex_volume_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flex_volume_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nfsVolumePath")
    def nfs_volume_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the NFS volume.
        """
        return pulumi.get(self, "nfs_volume_path")

    @nfs_volume_path.setter
    def nfs_volume_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nfs_volume_path", value)

    @property
    @pulumi.getter(name="nfsVolumeReadOnly")
    def nfs_volume_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        The nfs volume read only. Default value: `false`.
        """
        return pulumi.get(self, "nfs_volume_read_only")

    @nfs_volume_read_only.setter
    def nfs_volume_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nfs_volume_read_only", value)

    @property
    @pulumi.getter(name="nfsVolumeServer")
    def nfs_volume_server(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the NFS server.
        """
        return pulumi.get(self, "nfs_volume_server")

    @nfs_volume_server.setter
    def nfs_volume_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nfs_volume_server", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the volume.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content: The content of the configuration file. Maximum size: 32 KB.
        :param pulumi.Input[str] path: The path of HTTP Get request detection when setting the postStart callback function using the HTTP request method.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the configuration file. Maximum size: 32 KB.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of HTTP Get request detection when setting the postStart callback function using the HTTP request method.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class ImageCacheImageRegistryCredentialArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] password: The password of the Image Registry.
        :param pulumi.Input[str] server: The address of Image Registry without `http://` or `https://`.
        :param pulumi.Input[str] user_name: The user name of Image Registry.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the Image Registry.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        The address of Image Registry without `http://` or `https://`.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user name of Image Registry.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class OpenApiImageCacheImageRegistryCredentialArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class VirtualNodeTaintArgs:
    def __init__(__self__, *,
                 effect: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] effect: The effect of the taint. Valid values: `NoSchedule`, `NoExecute` and `PreferNoSchedule`.
        :param pulumi.Input[str] key: The key of the taint.
        :param pulumi.Input[str] value: The value of the taint.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input[str]]:
        """
        The effect of the taint. Valid values: `NoSchedule`, `NoExecute` and `PreferNoSchedule`.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key of the taint.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the taint.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


