# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetImageCachesResult',
    'AwaitableGetImageCachesResult',
    'get_image_caches',
    'get_image_caches_output',
]

@pulumi.output_type
class GetImageCachesResult:
    """
    A collection of values returned by getImageCaches.
    """
    def __init__(__self__, caches=None, id=None, ids=None, image=None, image_cache_name=None, name_regex=None, names=None, output_file=None, snapshot_id=None, status=None):
        if caches and not isinstance(caches, list):
            raise TypeError("Expected argument 'caches' to be a list")
        pulumi.set(__self__, "caches", caches)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if image and not isinstance(image, str):
            raise TypeError("Expected argument 'image' to be a str")
        pulumi.set(__self__, "image", image)
        if image_cache_name and not isinstance(image_cache_name, str):
            raise TypeError("Expected argument 'image_cache_name' to be a str")
        pulumi.set(__self__, "image_cache_name", image_cache_name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if snapshot_id and not isinstance(snapshot_id, str):
            raise TypeError("Expected argument 'snapshot_id' to be a str")
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def caches(self) -> Sequence['outputs.GetImageCachesCachResult']:
        """
        A list of caches. Each element contains the following attributes:
        """
        return pulumi.get(self, "caches")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list ids of ECI Image Cache.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imageCacheName")
    def image_cache_name(self) -> Optional[str]:
        """
        The name of the ECI Image Cache.
        """
        return pulumi.get(self, "image_cache_name")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of ECI Image Cache names.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The id of snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of ECI Image Cache.
        """
        return pulumi.get(self, "status")


class AwaitableGetImageCachesResult(GetImageCachesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageCachesResult(
            caches=self.caches,
            id=self.id,
            ids=self.ids,
            image=self.image,
            image_cache_name=self.image_cache_name,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            snapshot_id=self.snapshot_id,
            status=self.status)


def get_image_caches(ids: Optional[Sequence[str]] = None,
                     image: Optional[str] = None,
                     image_cache_name: Optional[str] = None,
                     name_regex: Optional[str] = None,
                     output_file: Optional[str] = None,
                     snapshot_id: Optional[str] = None,
                     status: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageCachesResult:
    """
    Provides a collection of ECI Image Cache to the specified filters.

    > **NOTE:** Available in 1.90.0+.


    :param Sequence[str] ids: A list ids of ECI Image Cache.
    :param str image: Find the mirror cache containing it according to the image name.
    :param str image_cache_name: The name of ECI Image Cache.
    :param str name_regex: A regex string to filter results by the image cache name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str snapshot_id: The id of snapshot.
    :param str status: The status of ECI Image Cache.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['image'] = image
    __args__['imageCacheName'] = image_cache_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['snapshotId'] = snapshot_id
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:eci/getImageCaches:getImageCaches', __args__, opts=opts, typ=GetImageCachesResult).value

    return AwaitableGetImageCachesResult(
        caches=pulumi.get(__ret__, 'caches'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        image=pulumi.get(__ret__, 'image'),
        image_cache_name=pulumi.get(__ret__, 'image_cache_name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        snapshot_id=pulumi.get(__ret__, 'snapshot_id'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_image_caches)
def get_image_caches_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            image: Optional[pulumi.Input[Optional[str]]] = None,
                            image_cache_name: Optional[pulumi.Input[Optional[str]]] = None,
                            name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                            output_file: Optional[pulumi.Input[Optional[str]]] = None,
                            snapshot_id: Optional[pulumi.Input[Optional[str]]] = None,
                            status: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetImageCachesResult]:
    """
    Provides a collection of ECI Image Cache to the specified filters.

    > **NOTE:** Available in 1.90.0+.


    :param Sequence[str] ids: A list ids of ECI Image Cache.
    :param str image: Find the mirror cache containing it according to the image name.
    :param str image_cache_name: The name of ECI Image Cache.
    :param str name_regex: A regex string to filter results by the image cache name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str snapshot_id: The id of snapshot.
    :param str status: The status of ECI Image Cache.
    """
    ...
