# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[str],
                 instance_type: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 vswitch_id: pulumi.Input[str],
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 resolution: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vnc_password: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] image_id: The ID Of The Image.
        :param pulumi.Input[str] instance_type: Instance Type.
        :param pulumi.Input[str] security_group_id: The ID of the security group. The security group is the same as that of the
               ECS instance.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        :param pulumi.Input[bool] auto_pay: The auto pay.
        :param pulumi.Input[bool] auto_renew: The auto renew.
        :param pulumi.Input[str] description: Description of the instance. 2 to 256 English or Chinese characters in length and cannot
               start with `http://` and `https`.
        :param pulumi.Input[int] eip_bandwidth: The eip bandwidth.
        :param pulumi.Input[bool] force: The force.
        :param pulumi.Input[str] instance_name: The name of the instance. It must be 2 to 128 characters in length and must start with an
               uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
               half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
               the instance.
        :param pulumi.Input[str] key_pair_name: The name of the key pair of the mobile phone instance.
        :param pulumi.Input[str] payment_type: The payment type.Valid values: `PayAsYouGo`,`Subscription`
        :param pulumi.Input[str] period: The period. It is valid when `period_unit` is 'Year'. Valid value: `1`, `2`, `3`, `4`, `5`. It
               is valid when `period_unit` is 'Month'. Valid value: `1`, `2`, `3`, `5`
        :param pulumi.Input[str] period_unit: The duration unit that you will buy the resource. Valid value: `Year`,`Month`. Default
               to `Month`.
        :param pulumi.Input[str] resolution: The selected resolution for the cloud mobile phone instance.
        :param pulumi.Input[str] status: Instance status. Valid values: `Running`, `Stopped`.
        :param pulumi.Input[str] vnc_password: Cloud mobile phone VNC password. The password must be six characters in length and must
               contain only uppercase, lowercase English letters and Arabic numerals.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vnc_password is not None:
            pulumi.set(__self__, "vnc_password", vnc_password)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        The ID Of The Image.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Instance Type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        The ID of the security group. The security group is the same as that of the
        ECS instance.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[bool]]:
        """
        The auto pay.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        The auto renew.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the instance. 2 to 256 English or Chinese characters in length and cannot
        start with `http://` and `https`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The eip bandwidth.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[bool]]:
        """
        The force.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance. It must be 2 to 128 characters in length and must start with an
        uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
        half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
        the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the key pair of the mobile phone instance.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type.Valid values: `PayAsYouGo`,`Subscription`
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        The period. It is valid when `period_unit` is 'Year'. Valid value: `1`, `2`, `3`, `4`, `5`. It
        is valid when `period_unit` is 'Month'. Valid value: `1`, `2`, `3`, `5`
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The duration unit that you will buy the resource. Valid value: `Year`,`Month`. Default
        to `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def resolution(self) -> Optional[pulumi.Input[str]]:
        """
        The selected resolution for the cloud mobile phone instance.
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolution", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Instance status. Valid values: `Running`, `Stopped`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vncPassword")
    def vnc_password(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud mobile phone VNC password. The password must be six characters in length and must
        contain only uppercase, lowercase English letters and Arabic numerals.
        """
        return pulumi.get(self, "vnc_password")

    @vnc_password.setter
    def vnc_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnc_password", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 resolution: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vnc_password: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[bool] auto_pay: The auto pay.
        :param pulumi.Input[bool] auto_renew: The auto renew.
        :param pulumi.Input[str] description: Description of the instance. 2 to 256 English or Chinese characters in length and cannot
               start with `http://` and `https`.
        :param pulumi.Input[int] eip_bandwidth: The eip bandwidth.
        :param pulumi.Input[bool] force: The force.
        :param pulumi.Input[str] image_id: The ID Of The Image.
        :param pulumi.Input[str] instance_name: The name of the instance. It must be 2 to 128 characters in length and must start with an
               uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
               half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
               the instance.
        :param pulumi.Input[str] instance_type: Instance Type.
        :param pulumi.Input[str] key_pair_name: The name of the key pair of the mobile phone instance.
        :param pulumi.Input[str] payment_type: The payment type.Valid values: `PayAsYouGo`,`Subscription`
        :param pulumi.Input[str] period: The period. It is valid when `period_unit` is 'Year'. Valid value: `1`, `2`, `3`, `4`, `5`. It
               is valid when `period_unit` is 'Month'. Valid value: `1`, `2`, `3`, `5`
        :param pulumi.Input[str] period_unit: The duration unit that you will buy the resource. Valid value: `Year`,`Month`. Default
               to `Month`.
        :param pulumi.Input[str] resolution: The selected resolution for the cloud mobile phone instance.
        :param pulumi.Input[str] security_group_id: The ID of the security group. The security group is the same as that of the
               ECS instance.
        :param pulumi.Input[str] status: Instance status. Valid values: `Running`, `Stopped`.
        :param pulumi.Input[str] vnc_password: Cloud mobile phone VNC password. The password must be six characters in length and must
               contain only uppercase, lowercase English letters and Arabic numerals.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vnc_password is not None:
            pulumi.set(__self__, "vnc_password", vnc_password)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[bool]]:
        """
        The auto pay.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        The auto renew.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the instance. 2 to 256 English or Chinese characters in length and cannot
        start with `http://` and `https`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The eip bandwidth.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[bool]]:
        """
        The force.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID Of The Image.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance. It must be 2 to 128 characters in length and must start with an
        uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
        half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
        the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance Type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the key pair of the mobile phone instance.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type.Valid values: `PayAsYouGo`,`Subscription`
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        The period. It is valid when `period_unit` is 'Year'. Valid value: `1`, `2`, `3`, `4`, `5`. It
        is valid when `period_unit` is 'Month'. Valid value: `1`, `2`, `3`, `5`
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The duration unit that you will buy the resource. Valid value: `Year`,`Month`. Default
        to `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def resolution(self) -> Optional[pulumi.Input[str]]:
        """
        The selected resolution for the cloud mobile phone instance.
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolution", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group. The security group is the same as that of the
        ECS instance.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Instance status. Valid values: `Running`, `Stopped`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vncPassword")
    def vnc_password(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud mobile phone VNC password. The password must be six characters in length and must
        contain only uppercase, lowercase English letters and Arabic numerals.
        """
        return pulumi.get(self, "vnc_password")

    @vnc_password.setter
    def vnc_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnc_password", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 resolution: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vnc_password: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Elastic Cloud Phone (ECP) Instance resource.

        For information about Elastic Cloud Phone (ECP) Instance and how to use it,
        see [What is Instance](https://www.alibabacloud.com/help/en/cloudphone/latest/api-cloudphone-2020-12-30-runinstances).

        > **NOTE:** Available since v1.158.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.ecp.get_zones()
        default_instance_types = alicloud.ecp.get_instance_types()
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].zone_id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_key_pair = alicloud.ecp.KeyPair("defaultKeyPair",
            key_pair_name=name,
            public_key_body="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
        default_instance = alicloud.ecp.Instance("defaultInstance",
            instance_name=name,
            description=name,
            key_pair_name=default_key_pair.key_pair_name,
            security_group_id=default_security_group.id,
            vswitch_id=default_switch.id,
            image_id="android_9_0_0_release_2851157_20211201.vhd",
            instance_type=default_instance_types.instance_types[1].instance_type,
            vnc_password="Ecp123",
            payment_type="PayAsYouGo")
        ```

        ## Import

        Elastic Cloud Phone (ECP) Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecp/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_pay: The auto pay.
        :param pulumi.Input[bool] auto_renew: The auto renew.
        :param pulumi.Input[str] description: Description of the instance. 2 to 256 English or Chinese characters in length and cannot
               start with `http://` and `https`.
        :param pulumi.Input[int] eip_bandwidth: The eip bandwidth.
        :param pulumi.Input[bool] force: The force.
        :param pulumi.Input[str] image_id: The ID Of The Image.
        :param pulumi.Input[str] instance_name: The name of the instance. It must be 2 to 128 characters in length and must start with an
               uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
               half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
               the instance.
        :param pulumi.Input[str] instance_type: Instance Type.
        :param pulumi.Input[str] key_pair_name: The name of the key pair of the mobile phone instance.
        :param pulumi.Input[str] payment_type: The payment type.Valid values: `PayAsYouGo`,`Subscription`
        :param pulumi.Input[str] period: The period. It is valid when `period_unit` is 'Year'. Valid value: `1`, `2`, `3`, `4`, `5`. It
               is valid when `period_unit` is 'Month'. Valid value: `1`, `2`, `3`, `5`
        :param pulumi.Input[str] period_unit: The duration unit that you will buy the resource. Valid value: `Year`,`Month`. Default
               to `Month`.
        :param pulumi.Input[str] resolution: The selected resolution for the cloud mobile phone instance.
        :param pulumi.Input[str] security_group_id: The ID of the security group. The security group is the same as that of the
               ECS instance.
        :param pulumi.Input[str] status: Instance status. Valid values: `Running`, `Stopped`.
        :param pulumi.Input[str] vnc_password: Cloud mobile phone VNC password. The password must be six characters in length and must
               contain only uppercase, lowercase English letters and Arabic numerals.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Elastic Cloud Phone (ECP) Instance resource.

        For information about Elastic Cloud Phone (ECP) Instance and how to use it,
        see [What is Instance](https://www.alibabacloud.com/help/en/cloudphone/latest/api-cloudphone-2020-12-30-runinstances).

        > **NOTE:** Available since v1.158.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.ecp.get_zones()
        default_instance_types = alicloud.ecp.get_instance_types()
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].zone_id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_key_pair = alicloud.ecp.KeyPair("defaultKeyPair",
            key_pair_name=name,
            public_key_body="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
        default_instance = alicloud.ecp.Instance("defaultInstance",
            instance_name=name,
            description=name,
            key_pair_name=default_key_pair.key_pair_name,
            security_group_id=default_security_group.id,
            vswitch_id=default_switch.id,
            image_id="android_9_0_0_release_2851157_20211201.vhd",
            instance_type=default_instance_types.instance_types[1].instance_type,
            vnc_password="Ecp123",
            payment_type="PayAsYouGo")
        ```

        ## Import

        Elastic Cloud Phone (ECP) Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecp/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 resolution: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vnc_password: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["description"] = description
            __props__.__dict__["eip_bandwidth"] = eip_bandwidth
            __props__.__dict__["force"] = force
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_name"] = instance_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["resolution"] = resolution
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["status"] = status
            __props__.__dict__["vnc_password"] = None if vnc_password is None else pulumi.Output.secret(vnc_password)
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["vncPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'alicloud:ecp/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[bool]] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            eip_bandwidth: Optional[pulumi.Input[int]] = None,
            force: Optional[pulumi.Input[bool]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            key_pair_name: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[str]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            resolution: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            vnc_password: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_pay: The auto pay.
        :param pulumi.Input[bool] auto_renew: The auto renew.
        :param pulumi.Input[str] description: Description of the instance. 2 to 256 English or Chinese characters in length and cannot
               start with `http://` and `https`.
        :param pulumi.Input[int] eip_bandwidth: The eip bandwidth.
        :param pulumi.Input[bool] force: The force.
        :param pulumi.Input[str] image_id: The ID Of The Image.
        :param pulumi.Input[str] instance_name: The name of the instance. It must be 2 to 128 characters in length and must start with an
               uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
               half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
               the instance.
        :param pulumi.Input[str] instance_type: Instance Type.
        :param pulumi.Input[str] key_pair_name: The name of the key pair of the mobile phone instance.
        :param pulumi.Input[str] payment_type: The payment type.Valid values: `PayAsYouGo`,`Subscription`
        :param pulumi.Input[str] period: The period. It is valid when `period_unit` is 'Year'. Valid value: `1`, `2`, `3`, `4`, `5`. It
               is valid when `period_unit` is 'Month'. Valid value: `1`, `2`, `3`, `5`
        :param pulumi.Input[str] period_unit: The duration unit that you will buy the resource. Valid value: `Year`,`Month`. Default
               to `Month`.
        :param pulumi.Input[str] resolution: The selected resolution for the cloud mobile phone instance.
        :param pulumi.Input[str] security_group_id: The ID of the security group. The security group is the same as that of the
               ECS instance.
        :param pulumi.Input[str] status: Instance status. Valid values: `Running`, `Stopped`.
        :param pulumi.Input[str] vnc_password: Cloud mobile phone VNC password. The password must be six characters in length and must
               contain only uppercase, lowercase English letters and Arabic numerals.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["description"] = description
        __props__.__dict__["eip_bandwidth"] = eip_bandwidth
        __props__.__dict__["force"] = force
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["resolution"] = resolution
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vnc_password"] = vnc_password
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[bool]]:
        """
        The auto pay.
        """
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        The auto renew.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the instance. 2 to 256 English or Chinese characters in length and cannot
        start with `http://` and `https`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        The eip bandwidth.
        """
        return pulumi.get(self, "eip_bandwidth")

    @property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[bool]]:
        """
        The force.
        """
        return pulumi.get(self, "force")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The ID Of The Image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the instance. It must be 2 to 128 characters in length and must start with an
        uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
        half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
        the instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        Instance Type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the key pair of the mobile phone instance.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[Optional[str]]:
        """
        The payment type.Valid values: `PayAsYouGo`,`Subscription`
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[str]]:
        """
        The period. It is valid when `period_unit` is 'Year'. Valid value: `1`, `2`, `3`, `4`, `5`. It
        is valid when `period_unit` is 'Month'. Valid value: `1`, `2`, `3`, `5`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        The duration unit that you will buy the resource. Valid value: `Year`,`Month`. Default
        to `Month`.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def resolution(self) -> pulumi.Output[str]:
        """
        The selected resolution for the cloud mobile phone instance.
        """
        return pulumi.get(self, "resolution")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the security group. The security group is the same as that of the
        ECS instance.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Instance status. Valid values: `Running`, `Stopped`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vncPassword")
    def vnc_password(self) -> pulumi.Output[Optional[str]]:
        """
        Cloud mobile phone VNC password. The password must be six characters in length and must
        contain only uppercase, lowercase English letters and Arabic numerals.
        """
        return pulumi.get(self, "vnc_password")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

