# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AutoProvisioningGroupLaunchTemplateConfigArgs',
    'DedicatedHostNetworkAttributeArgs',
    'EcsInstanceSetDataDiskArgs',
    'EcsInstanceSetExcludeInstanceFilterArgs',
    'EcsInstanceSetNetworkInterfaceArgs',
    'EcsLaunchTemplateDataDiskArgs',
    'EcsLaunchTemplateNetworkInterfacesArgs',
    'EcsLaunchTemplateSystemDiskArgs',
    'EcsPrefixListEntryArgs',
    'ImageDiskDeviceMappingArgs',
    'ImageImportDiskDeviceMappingArgs',
    'InstanceDataDiskArgs',
    'InstanceMaintenanceTimeArgs',
    'InstanceNetworkInterfacesArgs',
    'LaunchTemplateDataDiskArgs',
    'LaunchTemplateNetworkInterfacesArgs',
    'LaunchTemplateSystemDiskArgs',
    'ReservedInstanceOperationLockArgs',
    'GetDedicatedHostsOperationLockArgs',
    'GetDisksOperationLockArgs',
    'GetEcsDisksOperationLockArgs',
]

@pulumi.input_type
class AutoProvisioningGroupLaunchTemplateConfigArgs:
    def __init__(__self__, *,
                 max_price: pulumi.Input[str],
                 vswitch_id: pulumi.Input[str],
                 weighted_capacity: pulumi.Input[str],
                 instance_type: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] max_price: The maximum price of the instance type specified in the Nth extended configurations of the launch template.
        :param pulumi.Input[str] vswitch_id: The ID of the VSwitch in the Nth extended configurations of the launch template.
        :param pulumi.Input[str] weighted_capacity: The weight of the instance type specified in the Nth extended configurations of the launch template.
        :param pulumi.Input[str] instance_type: The instance type of the Nth extended configurations of the launch template.
        :param pulumi.Input[str] priority: The priority of the instance type specified in the Nth extended configurations of the launch template. A value of 0 indicates the highest priority.
        """
        pulumi.set(__self__, "max_price", max_price)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "weighted_capacity", weighted_capacity)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter(name="maxPrice")
    def max_price(self) -> pulumi.Input[str]:
        """
        The maximum price of the instance type specified in the Nth extended configurations of the launch template.
        """
        return pulumi.get(self, "max_price")

    @max_price.setter
    def max_price(self, value: pulumi.Input[str]):
        pulumi.set(self, "max_price", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The ID of the VSwitch in the Nth extended configurations of the launch template.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> pulumi.Input[str]:
        """
        The weight of the instance type specified in the Nth extended configurations of the launch template.
        """
        return pulumi.get(self, "weighted_capacity")

    @weighted_capacity.setter
    def weighted_capacity(self, value: pulumi.Input[str]):
        pulumi.set(self, "weighted_capacity", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type of the Nth extended configurations of the launch template.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        """
        The priority of the instance type specified in the Nth extended configurations of the launch template. A value of 0 indicates the highest priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)


@pulumi.input_type
class DedicatedHostNetworkAttributeArgs:
    def __init__(__self__, *,
                 slb_udp_timeout: Optional[pulumi.Input[int]] = None,
                 udp_timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] slb_udp_timeout: The timeout period for a UDP session between Server Load Balancer (SLB) and the dedicated host. Unit: seconds. Valid values: 15 to 310.
        :param pulumi.Input[int] udp_timeout: The timeout period for a UDP session between a user and an Alibaba Cloud service on the dedicated host. Unit: seconds. Valid values: 15 to 310.
        """
        if slb_udp_timeout is not None:
            pulumi.set(__self__, "slb_udp_timeout", slb_udp_timeout)
        if udp_timeout is not None:
            pulumi.set(__self__, "udp_timeout", udp_timeout)

    @property
    @pulumi.getter(name="slbUdpTimeout")
    def slb_udp_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout period for a UDP session between Server Load Balancer (SLB) and the dedicated host. Unit: seconds. Valid values: 15 to 310.
        """
        return pulumi.get(self, "slb_udp_timeout")

    @slb_udp_timeout.setter
    def slb_udp_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "slb_udp_timeout", value)

    @property
    @pulumi.getter(name="udpTimeout")
    def udp_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout period for a UDP session between a user and an Alibaba Cloud service on the dedicated host. Unit: seconds. Valid values: 15 to 310.
        """
        return pulumi.get(self, "udp_timeout")

    @udp_timeout.setter
    def udp_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "udp_timeout", value)


@pulumi.input_type
class EcsInstanceSetDataDiskArgs:
    def __init__(__self__, *,
                 disk_size: pulumi.Input[int],
                 auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 disk_category: Optional[pulumi.Input[str]] = None,
                 disk_description: Optional[pulumi.Input[str]] = None,
                 disk_name: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_level: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] disk_size: The size of the data disk. Unit: GiB.
               - When `disk_category` is `cloud_efficiency`, Valid values: `20` to `32768`.
               - When `disk_category` is `cloud_ssd`, Valid values: `20` to `32768`.
               - When `disk_category` is `cloud_essd`, Valid values: `20` to `32768`.
               - When `disk_category` is `cloud`, Valid values: `5` to `200`.
        :param pulumi.Input[str] auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param pulumi.Input[str] disk_category: The category of the disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
        :param pulumi.Input[str] disk_description: The description of the data disk.
        :param pulumi.Input[str] disk_name: The name of the data disk.
        :param pulumi.Input[bool] encrypted: Encrypted the data in this disk. Default value: `false`.
        :param pulumi.Input[str] kms_key_id: The KMS key ID corresponding to the data disk.
        :param pulumi.Input[str] performance_level: The performance level of the ESSD used as data disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
        :param pulumi.Input[str] snapshot_id: The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        pulumi.set(__self__, "disk_size", disk_size)
        if auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        if disk_category is not None:
            pulumi.set(__self__, "disk_category", disk_category)
        if disk_description is not None:
            pulumi.set(__self__, "disk_description", disk_description)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Input[int]:
        """
        The size of the data disk. Unit: GiB.
        - When `disk_category` is `cloud_efficiency`, Valid values: `20` to `32768`.
        - When `disk_category` is `cloud_ssd`, Valid values: `20` to `32768`.
        - When `disk_category` is `cloud_essd`, Valid values: `20` to `32768`.
        - When `disk_category` is `cloud`, Valid values: `5` to `200`.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the automatic snapshot policy applied to the system disk.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @auto_snapshot_policy_id.setter
    def auto_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="diskCategory")
    def disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
        """
        return pulumi.get(self, "disk_category")

    @disk_category.setter
    def disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_category", value)

    @property
    @pulumi.getter(name="diskDescription")
    def disk_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "disk_description")

    @disk_description.setter
    def disk_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_description", value)

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "disk_name")

    @disk_name.setter
    def disk_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_name", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypted the data in this disk. Default value: `false`.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The KMS key ID corresponding to the data disk.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        The performance level of the ESSD used as data disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_level", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)


@pulumi.input_type
class EcsInstanceSetExcludeInstanceFilterArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] key: The type of the excluded. Valid values: `InstanceId`, `InstanceName`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The value of the excluded. The identification of the excluded instances. It is a list of instance Ids or names.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The type of the excluded. Valid values: `InstanceId`, `InstanceName`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The value of the excluded. The identification of the excluded instances. It is a list of instance Ids or names.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class EcsInstanceSetNetworkInterfaceArgs:
    def __init__(__self__, *,
                 security_group_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 network_interface_name: Optional[pulumi.Input[str]] = None,
                 primary_ip_address: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] security_group_id: The ID of the security group to which to assign secondary ENI.
        :param pulumi.Input[str] description: The description of ENI.
        :param pulumi.Input[str] network_interface_name: The name of ENI.
        :param pulumi.Input[str] primary_ip_address: The primary private IP address of ENI.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch to which to connect ENI.
        """
        pulumi.set(__self__, "security_group_id", security_group_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if network_interface_name is not None:
            pulumi.set(__self__, "network_interface_name", network_interface_name)
        if primary_ip_address is not None:
            pulumi.set(__self__, "primary_ip_address", primary_ip_address)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        The ID of the security group to which to assign secondary ENI.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of ENI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="networkInterfaceName")
    def network_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of ENI.
        """
        return pulumi.get(self, "network_interface_name")

    @network_interface_name.setter
    def network_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_interface_name", value)

    @property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The primary private IP address of ENI.
        """
        return pulumi.get(self, "primary_ip_address")

    @primary_ip_address.setter
    def primary_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ip_address", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the vSwitch to which to connect ENI.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class EcsLaunchTemplateDataDiskArgs:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_level: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] category: The category of the disk.
        :param pulumi.Input[bool] delete_with_instance: Indicates whether the data disk is released with the instance.
        :param pulumi.Input[str] description: The description of the data disk.
        :param pulumi.Input[bool] encrypted: Encrypted the data in this disk.
        :param pulumi.Input[str] name: The name of the data disk.
        :param pulumi.Input[str] performance_level: The performance level of the ESSD used as the data disk.
        :param pulumi.Input[int] size: The size of the data disk.
        :param pulumi.Input[str] snapshot_id: The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the disk.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the data disk is released with the instance.
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypted the data in this disk.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        The performance level of the ESSD used as the data disk.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_level", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the data disk.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)


@pulumi.input_type
class EcsLaunchTemplateNetworkInterfacesArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_ip: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: The ENI description.
        :param pulumi.Input[str] name: The ENI name.
        :param pulumi.Input[str] primary_ip: The primary private IP address of the ENI.
        :param pulumi.Input[str] security_group_id: The security group ID must be one in the same VPC.
        :param pulumi.Input[str] vswitch_id: The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_ip is not None:
            pulumi.set(__self__, "primary_ip", primary_ip)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The ENI description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ENI name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryIp")
    def primary_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The primary private IP address of the ENI.
        """
        return pulumi.get(self, "primary_ip")

    @primary_ip.setter
    def primary_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ip", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The security group ID must be one in the same VPC.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class EcsLaunchTemplateSystemDiskArgs:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_level: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] category: The category of the system disk. System disk type. Valid values: `all`, `cloud`, `ephemeral_ssd`, `cloud_essd`, `cloud_efficiency`, `cloud_ssd`, `local_disk`.
        :param pulumi.Input[bool] delete_with_instance: Specifies whether to release the system disk when the instance is released. Default to `true`.
        :param pulumi.Input[str] description: System disk description. It cannot begin with http:// or https://.
        :param pulumi.Input[bool] encrypted: Specifies whether the system disk is encrypted.
        :param pulumi.Input[str] iops: The Iops.
        :param pulumi.Input[str] name: System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[str] performance_level: The performance level of the ESSD used as the system disk. Valid Values: `PL0`, `PL1`, `PL2`, and `PL3`. Default to: `PL0`.
        :param pulumi.Input[int] size: Size of the system disk, measured in GB. Value range: [20, 500].
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the system disk. System disk type. Valid values: `all`, `cloud`, `ephemeral_ssd`, `cloud_essd`, `cloud_efficiency`, `cloud_ssd`, `local_disk`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to release the system disk when the instance is released. Default to `true`.
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        System disk description. It cannot begin with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the system disk is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[str]]:
        """
        The Iops.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        The performance level of the ESSD used as the system disk. Valid Values: `PL0`, `PL1`, `PL2`, and `PL3`. Default to: `PL0`.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_level", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the system disk, measured in GB. Value range: [20, 500].
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class EcsPrefixListEntryArgs:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cidr: The CIDR block in entry. This parameter is empty by default.  Take note of the following items:
               * The total number of entries must not exceed the `max_entries` value.
               * CIDR block types are determined by the IP address family. You cannot combine `IPv4` and `IPv6` CIDR blocks in a single entry.
               * CIDR blocks must be unique across all entries in a prefix list. For example, you cannot specify 192.168.1.0/24 twice in the entries of the prefix list.
               * IP addresses are supported. The system converts IP addresses into CIDR blocks. For example, if you specify 192.168.1.100, the system converts it into the 192.168.1.100/32 CIDR block.
               * If an IPv6 CIDR block is used, the system converts it to the zero compression format and changes uppercase letters into lowercase ones. For example, if you specify 2001:0DB8:0000:0000:0000:0000:0000:0000/32, the system converts it into 2001:db8::/32.
               * For more information about CIDR blocks, see the "What is CIDR block?" section of the [Network FAQ](https://www.alibabacloud.com/help/doc-detail/40637.htm) topic.  * The total number of entries must not exceed the `max_entries` value.
        :param pulumi.Input[str] description: The description in entry. The description must be 2 to 32 characters in length and cannot start with `http://` or `https://`.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block in entry. This parameter is empty by default.  Take note of the following items:
        * The total number of entries must not exceed the `max_entries` value.
        * CIDR block types are determined by the IP address family. You cannot combine `IPv4` and `IPv6` CIDR blocks in a single entry.
        * CIDR blocks must be unique across all entries in a prefix list. For example, you cannot specify 192.168.1.0/24 twice in the entries of the prefix list.
        * IP addresses are supported. The system converts IP addresses into CIDR blocks. For example, if you specify 192.168.1.100, the system converts it into the 192.168.1.100/32 CIDR block.
        * If an IPv6 CIDR block is used, the system converts it to the zero compression format and changes uppercase letters into lowercase ones. For example, if you specify 2001:0DB8:0000:0000:0000:0000:0000:0000/32, the system converts it into 2001:db8::/32.
        * For more information about CIDR blocks, see the "What is CIDR block?" section of the [Network FAQ](https://www.alibabacloud.com/help/doc-detail/40637.htm) topic.  * The total number of entries must not exceed the `max_entries` value.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description in entry. The description must be 2 to 32 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ImageDiskDeviceMappingArgs:
    def __init__(__self__, *,
                 device: Optional[pulumi.Input[str]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] device: Specifies the name of a disk in the combined custom image. Value range: /dev/xvda to /dev/xvdz.
        :param pulumi.Input[str] disk_type: Specifies the type of a disk in the combined custom image. If you specify this parameter, you can use a data disk snapshot as the data source of a system disk for creating an image. If it is not specified, the disk type is determined by the corresponding snapshot. Valid values: `system`, `data`,
        :param pulumi.Input[int] size: Specifies the size of a disk in the combined custom image, in GiB. Value range: 5 to 2000.
        :param pulumi.Input[str] snapshot_id: Specifies a snapshot that is used to create a combined custom image.
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a disk in the combined custom image. Value range: /dev/xvda to /dev/xvdz.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of a disk in the combined custom image. If you specify this parameter, you can use a data disk snapshot as the data source of a system disk for creating an image. If it is not specified, the disk type is determined by the corresponding snapshot. Valid values: `system`, `data`,
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of a disk in the combined custom image, in GiB. Value range: 5 to 2000.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a snapshot that is used to create a combined custom image.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)


@pulumi.input_type
class ImageImportDiskDeviceMappingArgs:
    def __init__(__self__, *,
                 device: Optional[pulumi.Input[str]] = None,
                 disk_image_size: Optional[pulumi.Input[int]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 oss_bucket: Optional[pulumi.Input[str]] = None,
                 oss_object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] device: The name of disk N in the custom image.
        :param pulumi.Input[int] disk_image_size: Resolution size. You must ensure that the system disk space ≥ file system space. Ranges: When n = 1, the system disk: 5 ~ 500GiB, When n = 2 ~ 17, that is, data disk: 5 ~ 1000GiB, When temporary is introduced, the system automatically detects the size, which is subject to the detection result.
        :param pulumi.Input[str] format: Image format. Value range: When the `RAW`, `VHD`, `qcow2` is imported into the image, the system automatically detects the image format, whichever comes first.
        :param pulumi.Input[str] oss_bucket: Save the exported OSS bucket.
        :param pulumi.Input[str] oss_object: The file name of your OSS Object.
               
               > **NOTE:** The disk_device_mapping is a list and it's first item will be used to system disk and other items are used to data disks.
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disk_image_size is not None:
            pulumi.set(__self__, "disk_image_size", disk_image_size)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if oss_bucket is not None:
            pulumi.set(__self__, "oss_bucket", oss_bucket)
        if oss_object is not None:
            pulumi.set(__self__, "oss_object", oss_object)

    @property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[str]]:
        """
        The name of disk N in the custom image.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter(name="diskImageSize")
    def disk_image_size(self) -> Optional[pulumi.Input[int]]:
        """
        Resolution size. You must ensure that the system disk space ≥ file system space. Ranges: When n = 1, the system disk: 5 ~ 500GiB, When n = 2 ~ 17, that is, data disk: 5 ~ 1000GiB, When temporary is introduced, the system automatically detects the size, which is subject to the detection result.
        """
        return pulumi.get(self, "disk_image_size")

    @disk_image_size.setter
    def disk_image_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_image_size", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Image format. Value range: When the `RAW`, `VHD`, `qcow2` is imported into the image, the system automatically detects the image format, whichever comes first.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="ossBucket")
    def oss_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Save the exported OSS bucket.
        """
        return pulumi.get(self, "oss_bucket")

    @oss_bucket.setter
    def oss_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oss_bucket", value)

    @property
    @pulumi.getter(name="ossObject")
    def oss_object(self) -> Optional[pulumi.Input[str]]:
        """
        The file name of your OSS Object.

        > **NOTE:** The disk_device_mapping is a list and it's first item will be used to system disk and other items are used to data disks.
        """
        return pulumi.get(self, "oss_object")

    @oss_object.setter
    def oss_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oss_object", value)


@pulumi.input_type
class InstanceDataDiskArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_level: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] size: The size of the data disk.
               - cloud：[5, 2000]
               - cloud_efficiency：[20, 32768]
               - cloud_ssd：[20, 32768]
               - cloud_essd：[20, 32768]
               - ephemeral_ssd: [5, 800]
        :param pulumi.Input[str] auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param pulumi.Input[str] category: The category of the disk:
        :param pulumi.Input[bool] delete_with_instance: Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_essd, cloud_ssd disk. If the category of this data disk was ephemeral_ssd, please don't set this param. Default value: `true`.
        :param pulumi.Input[str] description: The description of the data disk.
        :param pulumi.Input[str] device: The mount point of the data disk.
        :param pulumi.Input[bool] encrypted: Encrypted the data in this disk. Default value: `false`.
        :param pulumi.Input[str] kms_key_id: The KMS key ID corresponding to the Nth data disk.
        :param pulumi.Input[str] name: The name of the data disk.
        :param pulumi.Input[str] performance_level: The performance level of the ESSD used as data disk:
        :param pulumi.Input[str] snapshot_id: The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        pulumi.set(__self__, "size", size)
        if auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the data disk.
        - cloud：[5, 2000]
        - cloud_efficiency：[20, 32768]
        - cloud_ssd：[20, 32768]
        - cloud_essd：[20, 32768]
        - ephemeral_ssd: [5, 800]
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the automatic snapshot policy applied to the system disk.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @auto_snapshot_policy_id.setter
    def auto_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_snapshot_policy_id", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the disk:
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_essd, cloud_ssd disk. If the category of this data disk was ephemeral_ssd, please don't set this param. Default value: `true`.
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[str]]:
        """
        The mount point of the data disk.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypted the data in this disk. Default value: `false`.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The KMS key ID corresponding to the Nth data disk.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        The performance level of the ESSD used as data disk:
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_level", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)


@pulumi.input_type
class InstanceMaintenanceTimeArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end_time: The end time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
        :param pulumi.Input[str] start_time: The start time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The end time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class InstanceNetworkInterfacesArgs:
    def __init__(__self__, *,
                 network_interface_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] network_interface_id: The ID of the secondary ENI.
        """
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the secondary ENI.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_interface_id", value)


@pulumi.input_type
class LaunchTemplateDataDiskArgs:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_level: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] category: The category of the disk:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
               
               Default to `cloud_efficiency`.
        :param pulumi.Input[bool] delete_with_instance: Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
               
               Default to true
        :param pulumi.Input[str] description: The description of the data disk.
        :param pulumi.Input[bool] encrypted: Encrypted the data in this disk.
               
               Default to false
        :param pulumi.Input[str] name: The name of the data disk.
        :param pulumi.Input[int] size: The size of the data disk.
               - cloud：[5, 2000]
               - cloud_efficiency：[20, 32768]
               - cloud_ssd：[20, 32768]
               - cloud_essd：[20, 32768]
               - ephemeral_ssd: [5, 800]
        :param pulumi.Input[str] snapshot_id: The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the disk:
        - cloud: Basic cloud disk.
        - cloud_efficiency: Ultra cloud disk.
        - cloud_ssd: SSD cloud Disks.
        - ephemeral_ssd: local SSD Disks
        - cloud_essd: ESSD cloud Disks.

        Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.

        Default to true
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypted the data in this disk.

        Default to false
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_level", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the data disk.
        - cloud：[5, 2000]
        - cloud_efficiency：[20, 32768]
        - cloud_ssd：[20, 32768]
        - cloud_essd：[20, 32768]
        - ephemeral_ssd: [5, 800]
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)


@pulumi.input_type
class LaunchTemplateNetworkInterfacesArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_ip: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: The description of the data disk.
        :param pulumi.Input[str] name: The name of the data disk.
        :param pulumi.Input[str] primary_ip: The primary private IP address of the ENI.
        :param pulumi.Input[str] security_group_id: The security group ID must be one in the same VPC.
        :param pulumi.Input[str] vswitch_id: The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_ip is not None:
            pulumi.set(__self__, "primary_ip", primary_ip)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryIp")
    def primary_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The primary private IP address of the ENI.
        """
        return pulumi.get(self, "primary_ip")

    @primary_ip.setter
    def primary_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ip", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The security group ID must be one in the same VPC.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class LaunchTemplateSystemDiskArgs:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_level: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] category: The category of the disk:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
               
               Default to `cloud_efficiency`.
        :param pulumi.Input[bool] delete_with_instance: Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
               
               Default to true
        :param pulumi.Input[str] description: The description of the data disk.
        :param pulumi.Input[bool] encrypted: Encrypted the data in this disk.
               
               Default to false
        :param pulumi.Input[str] name: The name of the data disk.
        :param pulumi.Input[int] size: The size of the data disk.
               - cloud：[5, 2000]
               - cloud_efficiency：[20, 32768]
               - cloud_ssd：[20, 32768]
               - cloud_essd：[20, 32768]
               - ephemeral_ssd: [5, 800]
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the disk:
        - cloud: Basic cloud disk.
        - cloud_efficiency: Ultra cloud disk.
        - cloud_ssd: SSD cloud Disks.
        - ephemeral_ssd: local SSD Disks
        - cloud_essd: ESSD cloud Disks.

        Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.

        Default to true
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypted the data in this disk.

        Default to false
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_level", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the data disk.
        - cloud：[5, 2000]
        - cloud_efficiency：[20, 32768]
        - cloud_ssd：[20, 32768]
        - cloud_essd：[20, 32768]
        - ephemeral_ssd: [5, 800]
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class ReservedInstanceOperationLockArgs:
    def __init__(__self__, *,
                 lock_reason: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] lock_reason: The reason why the reserved instance was locked.
        """
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason why the reserved instance was locked.
        """
        return pulumi.get(self, "lock_reason")

    @lock_reason.setter
    def lock_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lock_reason", value)


@pulumi.input_type
class GetDedicatedHostsOperationLockArgs:
    def __init__(__self__, *,
                 lock_reason: Optional[str] = None):
        """
        :param str lock_reason: The reason why the dedicated host resource is locked.
        """
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[str]:
        """
        The reason why the dedicated host resource is locked.
        """
        return pulumi.get(self, "lock_reason")

    @lock_reason.setter
    def lock_reason(self, value: Optional[str]):
        pulumi.set(self, "lock_reason", value)


@pulumi.input_type
class GetDisksOperationLockArgs:
    def __init__(__self__, *,
                 lock_reason: Optional[str] = None):
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[str]:
        return pulumi.get(self, "lock_reason")

    @lock_reason.setter
    def lock_reason(self, value: Optional[str]):
        pulumi.set(self, "lock_reason", value)


@pulumi.input_type
class GetEcsDisksOperationLockArgs:
    def __init__(__self__, *,
                 lock_reason: Optional[str] = None):
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[str]:
        return pulumi.get(self, "lock_reason")

    @lock_reason.setter
    def lock_reason(self, value: Optional[str]):
        pulumi.set(self, "lock_reason", value)


