# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ActivationArgs', 'Activation']

@pulumi.input_type
class ActivationArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 ip_address_range: Optional[pulumi.Input[str]] = None,
                 time_to_live_in_hours: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Activation resource.
        :param pulumi.Input[str] description: The description of the activation code. The description can be 1 to 100 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[int] instance_count: The maximum number of times that the activation code can be used to register managed instances. Valid values: `1` to `1000`. Default value: `10`.
        :param pulumi.Input[str] instance_name: The default instance name prefix. The instance name prefix must be 1 to 50 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The instance name prefix can contain only letters, digits, periods (.), underscores (_), hyphens (-), and colons (:).
               - If you use the activation code created by the CreateActivation operation to register managed instances, the instances are assigned sequential names that are prefixed by the value of this parameter. You can also specify a new instance name to override the assigned sequential name when you register a managed instance.
               - If you specify InstanceName when you register a managed instance, an instance name in the format of `<InstanceName>-<Number>` is generated. The number of digits in the <Number> value is determined by that in the InstanceCount value. Example: 001. If you do not specify InstanceName, the hostname (Hostname) is used as the instance name.
        :param pulumi.Input[str] ip_address_range: The IP addresses of hosts that are allowed to use the activation code. The value can be IPv4 addresses, IPv6 addresses, or CIDR blocks.
        :param pulumi.Input[int] time_to_live_in_hours: The validity period of the activation code. The activation code cannot be used to register new instances after the validity period expires. Unit: hours. Valid values: `1` to `24`. Default value: `4`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if ip_address_range is not None:
            pulumi.set(__self__, "ip_address_range", ip_address_range)
        if time_to_live_in_hours is not None:
            pulumi.set(__self__, "time_to_live_in_hours", time_to_live_in_hours)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the activation code. The description can be 1 to 100 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of times that the activation code can be used to register managed instances. Valid values: `1` to `1000`. Default value: `10`.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The default instance name prefix. The instance name prefix must be 1 to 50 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The instance name prefix can contain only letters, digits, periods (.), underscores (_), hyphens (-), and colons (:).
        - If you use the activation code created by the CreateActivation operation to register managed instances, the instances are assigned sequential names that are prefixed by the value of this parameter. You can also specify a new instance name to override the assigned sequential name when you register a managed instance.
        - If you specify InstanceName when you register a managed instance, an instance name in the format of `<InstanceName>-<Number>` is generated. The number of digits in the <Number> value is determined by that in the InstanceCount value. Example: 001. If you do not specify InstanceName, the hostname (Hostname) is used as the instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> Optional[pulumi.Input[str]]:
        """
        The IP addresses of hosts that are allowed to use the activation code. The value can be IPv4 addresses, IPv6 addresses, or CIDR blocks.
        """
        return pulumi.get(self, "ip_address_range")

    @ip_address_range.setter
    def ip_address_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address_range", value)

    @property
    @pulumi.getter(name="timeToLiveInHours")
    def time_to_live_in_hours(self) -> Optional[pulumi.Input[int]]:
        """
        The validity period of the activation code. The activation code cannot be used to register new instances after the validity period expires. Unit: hours. Valid values: `1` to `24`. Default value: `4`.
        """
        return pulumi.get(self, "time_to_live_in_hours")

    @time_to_live_in_hours.setter
    def time_to_live_in_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_to_live_in_hours", value)


@pulumi.input_type
class _ActivationState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 ip_address_range: Optional[pulumi.Input[str]] = None,
                 time_to_live_in_hours: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Activation resources.
        :param pulumi.Input[str] description: The description of the activation code. The description can be 1 to 100 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[int] instance_count: The maximum number of times that the activation code can be used to register managed instances. Valid values: `1` to `1000`. Default value: `10`.
        :param pulumi.Input[str] instance_name: The default instance name prefix. The instance name prefix must be 1 to 50 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The instance name prefix can contain only letters, digits, periods (.), underscores (_), hyphens (-), and colons (:).
               - If you use the activation code created by the CreateActivation operation to register managed instances, the instances are assigned sequential names that are prefixed by the value of this parameter. You can also specify a new instance name to override the assigned sequential name when you register a managed instance.
               - If you specify InstanceName when you register a managed instance, an instance name in the format of `<InstanceName>-<Number>` is generated. The number of digits in the <Number> value is determined by that in the InstanceCount value. Example: 001. If you do not specify InstanceName, the hostname (Hostname) is used as the instance name.
        :param pulumi.Input[str] ip_address_range: The IP addresses of hosts that are allowed to use the activation code. The value can be IPv4 addresses, IPv6 addresses, or CIDR blocks.
        :param pulumi.Input[int] time_to_live_in_hours: The validity period of the activation code. The activation code cannot be used to register new instances after the validity period expires. Unit: hours. Valid values: `1` to `24`. Default value: `4`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if ip_address_range is not None:
            pulumi.set(__self__, "ip_address_range", ip_address_range)
        if time_to_live_in_hours is not None:
            pulumi.set(__self__, "time_to_live_in_hours", time_to_live_in_hours)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the activation code. The description can be 1 to 100 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of times that the activation code can be used to register managed instances. Valid values: `1` to `1000`. Default value: `10`.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The default instance name prefix. The instance name prefix must be 1 to 50 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The instance name prefix can contain only letters, digits, periods (.), underscores (_), hyphens (-), and colons (:).
        - If you use the activation code created by the CreateActivation operation to register managed instances, the instances are assigned sequential names that are prefixed by the value of this parameter. You can also specify a new instance name to override the assigned sequential name when you register a managed instance.
        - If you specify InstanceName when you register a managed instance, an instance name in the format of `<InstanceName>-<Number>` is generated. The number of digits in the <Number> value is determined by that in the InstanceCount value. Example: 001. If you do not specify InstanceName, the hostname (Hostname) is used as the instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> Optional[pulumi.Input[str]]:
        """
        The IP addresses of hosts that are allowed to use the activation code. The value can be IPv4 addresses, IPv6 addresses, or CIDR blocks.
        """
        return pulumi.get(self, "ip_address_range")

    @ip_address_range.setter
    def ip_address_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address_range", value)

    @property
    @pulumi.getter(name="timeToLiveInHours")
    def time_to_live_in_hours(self) -> Optional[pulumi.Input[int]]:
        """
        The validity period of the activation code. The activation code cannot be used to register new instances after the validity period expires. Unit: hours. Valid values: `1` to `24`. Default value: `4`.
        """
        return pulumi.get(self, "time_to_live_in_hours")

    @time_to_live_in_hours.setter
    def time_to_live_in_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_to_live_in_hours", value)


class Activation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 ip_address_range: Optional[pulumi.Input[str]] = None,
                 time_to_live_in_hours: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a ECS Activation resource.

        For information about ECS Activation and how to use it, see [What is Activation](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createactivation#doc-api-Ecs-CreateActivation).

        > **NOTE:** Available in v1.177.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ecs.Activation("example",
            description="terraform-example",
            instance_count=10,
            instance_name="terraform-example",
            ip_address_range="0.0.0.0/0",
            time_to_live_in_hours=4)
        ```

        ## Import

        ECS Activation can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/activation:Activation example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the activation code. The description can be 1 to 100 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[int] instance_count: The maximum number of times that the activation code can be used to register managed instances. Valid values: `1` to `1000`. Default value: `10`.
        :param pulumi.Input[str] instance_name: The default instance name prefix. The instance name prefix must be 1 to 50 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The instance name prefix can contain only letters, digits, periods (.), underscores (_), hyphens (-), and colons (:).
               - If you use the activation code created by the CreateActivation operation to register managed instances, the instances are assigned sequential names that are prefixed by the value of this parameter. You can also specify a new instance name to override the assigned sequential name when you register a managed instance.
               - If you specify InstanceName when you register a managed instance, an instance name in the format of `<InstanceName>-<Number>` is generated. The number of digits in the <Number> value is determined by that in the InstanceCount value. Example: 001. If you do not specify InstanceName, the hostname (Hostname) is used as the instance name.
        :param pulumi.Input[str] ip_address_range: The IP addresses of hosts that are allowed to use the activation code. The value can be IPv4 addresses, IPv6 addresses, or CIDR blocks.
        :param pulumi.Input[int] time_to_live_in_hours: The validity period of the activation code. The activation code cannot be used to register new instances after the validity period expires. Unit: hours. Valid values: `1` to `24`. Default value: `4`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ActivationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Activation resource.

        For information about ECS Activation and how to use it, see [What is Activation](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createactivation#doc-api-Ecs-CreateActivation).

        > **NOTE:** Available in v1.177.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ecs.Activation("example",
            description="terraform-example",
            instance_count=10,
            instance_name="terraform-example",
            ip_address_range="0.0.0.0/0",
            time_to_live_in_hours=4)
        ```

        ## Import

        ECS Activation can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/activation:Activation example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ActivationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActivationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 ip_address_range: Optional[pulumi.Input[str]] = None,
                 time_to_live_in_hours: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActivationArgs.__new__(ActivationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["instance_count"] = instance_count
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["ip_address_range"] = ip_address_range
            __props__.__dict__["time_to_live_in_hours"] = time_to_live_in_hours
        super(Activation, __self__).__init__(
            'alicloud:ecs/activation:Activation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            instance_count: Optional[pulumi.Input[int]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            ip_address_range: Optional[pulumi.Input[str]] = None,
            time_to_live_in_hours: Optional[pulumi.Input[int]] = None) -> 'Activation':
        """
        Get an existing Activation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the activation code. The description can be 1 to 100 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[int] instance_count: The maximum number of times that the activation code can be used to register managed instances. Valid values: `1` to `1000`. Default value: `10`.
        :param pulumi.Input[str] instance_name: The default instance name prefix. The instance name prefix must be 1 to 50 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The instance name prefix can contain only letters, digits, periods (.), underscores (_), hyphens (-), and colons (:).
               - If you use the activation code created by the CreateActivation operation to register managed instances, the instances are assigned sequential names that are prefixed by the value of this parameter. You can also specify a new instance name to override the assigned sequential name when you register a managed instance.
               - If you specify InstanceName when you register a managed instance, an instance name in the format of `<InstanceName>-<Number>` is generated. The number of digits in the <Number> value is determined by that in the InstanceCount value. Example: 001. If you do not specify InstanceName, the hostname (Hostname) is used as the instance name.
        :param pulumi.Input[str] ip_address_range: The IP addresses of hosts that are allowed to use the activation code. The value can be IPv4 addresses, IPv6 addresses, or CIDR blocks.
        :param pulumi.Input[int] time_to_live_in_hours: The validity period of the activation code. The activation code cannot be used to register new instances after the validity period expires. Unit: hours. Valid values: `1` to `24`. Default value: `4`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActivationState.__new__(_ActivationState)

        __props__.__dict__["description"] = description
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["ip_address_range"] = ip_address_range
        __props__.__dict__["time_to_live_in_hours"] = time_to_live_in_hours
        return Activation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the activation code. The description can be 1 to 100 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[int]:
        """
        The maximum number of times that the activation code can be used to register managed instances. Valid values: `1` to `1000`. Default value: `10`.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The default instance name prefix. The instance name prefix must be 1 to 50 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The instance name prefix can contain only letters, digits, periods (.), underscores (_), hyphens (-), and colons (:).
        - If you use the activation code created by the CreateActivation operation to register managed instances, the instances are assigned sequential names that are prefixed by the value of this parameter. You can also specify a new instance name to override the assigned sequential name when you register a managed instance.
        - If you specify InstanceName when you register a managed instance, an instance name in the format of `<InstanceName>-<Number>` is generated. The number of digits in the <Number> value is determined by that in the InstanceCount value. Example: 001. If you do not specify InstanceName, the hostname (Hostname) is used as the instance name.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> pulumi.Output[str]:
        """
        The IP addresses of hosts that are allowed to use the activation code. The value can be IPv4 addresses, IPv6 addresses, or CIDR blocks.
        """
        return pulumi.get(self, "ip_address_range")

    @property
    @pulumi.getter(name="timeToLiveInHours")
    def time_to_live_in_hours(self) -> pulumi.Output[int]:
        """
        The validity period of the activation code. The activation code cannot be used to register new instances after the validity period expires. Unit: hours. Valid values: `1` to `24`. Default value: `4`.
        """
        return pulumi.get(self, "time_to_live_in_hours")

