# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AutoSnapshotPolicyArgs', 'AutoSnapshotPolicy']

@pulumi.input_type
class AutoSnapshotPolicyArgs:
    def __init__(__self__, *,
                 repeat_weekdays: pulumi.Input[Sequence[pulumi.Input[str]]],
                 retention_days: pulumi.Input[int],
                 time_points: pulumi.Input[Sequence[pulumi.Input[str]]],
                 copied_snapshots_retention_days: Optional[pulumi.Input[int]] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AutoSnapshotPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] repeat_weekdays: The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
               - A maximum of seven time points can be selected.
               - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        :param pulumi.Input[int] retention_days: The snapshot retention time, and the unit of measurement is day. Optional values:
               - -1: The automatic snapshots are retained permanently.
               - [1, 65536]: The number of days retained.
               Default value: -1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] time_points: The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
               - A maximum of 24 time points can be selected.
               - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        :param pulumi.Input[int] copied_snapshots_retention_days: The retention period of the snapshot copied across regions.
               - -1: The snapshot is permanently retained.
               - [1, 65535]: The automatic snapshot is retained for the specified number of days.
               Default value: -1.
        :param pulumi.Input[bool] enable_cross_region_copy: Specifies whether to enable the system to automatically copy snapshots across regions.
        :param pulumi.Input[str] name: The snapshot policy name.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_copy_regions: The destination region to which the snapshot is copied. You can set a destination region.
        """
        pulumi.set(__self__, "repeat_weekdays", repeat_weekdays)
        pulumi.set(__self__, "retention_days", retention_days)
        pulumi.set(__self__, "time_points", time_points)
        if copied_snapshots_retention_days is not None:
            pulumi.set(__self__, "copied_snapshots_retention_days", copied_snapshots_retention_days)
        if enable_cross_region_copy is not None:
            pulumi.set(__self__, "enable_cross_region_copy", enable_cross_region_copy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_copy_regions is not None:
            pulumi.set(__self__, "target_copy_regions", target_copy_regions)

    @property
    @pulumi.getter(name="repeatWeekdays")
    def repeat_weekdays(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
        - A maximum of seven time points can be selected.
        - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        """
        return pulumi.get(self, "repeat_weekdays")

    @repeat_weekdays.setter
    def repeat_weekdays(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "repeat_weekdays", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Input[int]:
        """
        The snapshot retention time, and the unit of measurement is day. Optional values:
        - -1: The automatic snapshots are retained permanently.
        - [1, 65536]: The number of days retained.
        Default value: -1.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: pulumi.Input[int]):
        pulumi.set(self, "retention_days", value)

    @property
    @pulumi.getter(name="timePoints")
    def time_points(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
        - A maximum of 24 time points can be selected.
        - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        return pulumi.get(self, "time_points")

    @time_points.setter
    def time_points(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "time_points", value)

    @property
    @pulumi.getter(name="copiedSnapshotsRetentionDays")
    def copied_snapshots_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The retention period of the snapshot copied across regions.
        - -1: The snapshot is permanently retained.
        - [1, 65535]: The automatic snapshot is retained for the specified number of days.
        Default value: -1.
        """
        return pulumi.get(self, "copied_snapshots_retention_days")

    @copied_snapshots_retention_days.setter
    def copied_snapshots_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "copied_snapshots_retention_days", value)

    @property
    @pulumi.getter(name="enableCrossRegionCopy")
    def enable_cross_region_copy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the system to automatically copy snapshots across regions.
        """
        return pulumi.get(self, "enable_cross_region_copy")

    @enable_cross_region_copy.setter
    def enable_cross_region_copy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_cross_region_copy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The snapshot policy name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetCopyRegions")
    def target_copy_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The destination region to which the snapshot is copied. You can set a destination region.
        """
        return pulumi.get(self, "target_copy_regions")

    @target_copy_regions.setter
    def target_copy_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_copy_regions", value)


@pulumi.input_type
class _AutoSnapshotPolicyState:
    def __init__(__self__, *,
                 copied_snapshots_retention_days: Optional[pulumi.Input[int]] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_points: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AutoSnapshotPolicy resources.
        :param pulumi.Input[int] copied_snapshots_retention_days: The retention period of the snapshot copied across regions.
               - -1: The snapshot is permanently retained.
               - [1, 65535]: The automatic snapshot is retained for the specified number of days.
               Default value: -1.
        :param pulumi.Input[bool] enable_cross_region_copy: Specifies whether to enable the system to automatically copy snapshots across regions.
        :param pulumi.Input[str] name: The snapshot policy name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] repeat_weekdays: The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
               - A maximum of seven time points can be selected.
               - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        :param pulumi.Input[int] retention_days: The snapshot retention time, and the unit of measurement is day. Optional values:
               - -1: The automatic snapshots are retained permanently.
               - [1, 65536]: The number of days retained.
               Default value: -1.
        :param pulumi.Input[str] status: The status of Auto Snapshot Policy.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_copy_regions: The destination region to which the snapshot is copied. You can set a destination region.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] time_points: The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
               - A maximum of 24 time points can be selected.
               - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        if copied_snapshots_retention_days is not None:
            pulumi.set(__self__, "copied_snapshots_retention_days", copied_snapshots_retention_days)
        if enable_cross_region_copy is not None:
            pulumi.set(__self__, "enable_cross_region_copy", enable_cross_region_copy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repeat_weekdays is not None:
            pulumi.set(__self__, "repeat_weekdays", repeat_weekdays)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_copy_regions is not None:
            pulumi.set(__self__, "target_copy_regions", target_copy_regions)
        if time_points is not None:
            pulumi.set(__self__, "time_points", time_points)

    @property
    @pulumi.getter(name="copiedSnapshotsRetentionDays")
    def copied_snapshots_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The retention period of the snapshot copied across regions.
        - -1: The snapshot is permanently retained.
        - [1, 65535]: The automatic snapshot is retained for the specified number of days.
        Default value: -1.
        """
        return pulumi.get(self, "copied_snapshots_retention_days")

    @copied_snapshots_retention_days.setter
    def copied_snapshots_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "copied_snapshots_retention_days", value)

    @property
    @pulumi.getter(name="enableCrossRegionCopy")
    def enable_cross_region_copy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the system to automatically copy snapshots across regions.
        """
        return pulumi.get(self, "enable_cross_region_copy")

    @enable_cross_region_copy.setter
    def enable_cross_region_copy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_cross_region_copy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The snapshot policy name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="repeatWeekdays")
    def repeat_weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
        - A maximum of seven time points can be selected.
        - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        """
        return pulumi.get(self, "repeat_weekdays")

    @repeat_weekdays.setter
    def repeat_weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "repeat_weekdays", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The snapshot retention time, and the unit of measurement is day. Optional values:
        - -1: The automatic snapshots are retained permanently.
        - [1, 65536]: The number of days retained.
        Default value: -1.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_days", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of Auto Snapshot Policy.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetCopyRegions")
    def target_copy_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The destination region to which the snapshot is copied. You can set a destination region.
        """
        return pulumi.get(self, "target_copy_regions")

    @target_copy_regions.setter
    def target_copy_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_copy_regions", value)

    @property
    @pulumi.getter(name="timePoints")
    def time_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
        - A maximum of 24 time points can be selected.
        - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        return pulumi.get(self, "time_points")

    @time_points.setter
    def time_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "time_points", value)


class AutoSnapshotPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copied_snapshots_retention_days: Optional[pulumi.Input[int]] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_points: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a ECS Auto Snapshot Policy resource.

        For information about ECS Auto Snapshot Policy and how to use it, see [What is Auto Snapshot Policy](https://www.alibabacloud.com/help/en/doc-detail/25527.htm).

        > **NOTE:** Available in v1.117.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ecs.AutoSnapshotPolicy("example",
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        ```

        ## Import

        ECS Auto Snapshot Policy can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/autoSnapshotPolicy:AutoSnapshotPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] copied_snapshots_retention_days: The retention period of the snapshot copied across regions.
               - -1: The snapshot is permanently retained.
               - [1, 65535]: The automatic snapshot is retained for the specified number of days.
               Default value: -1.
        :param pulumi.Input[bool] enable_cross_region_copy: Specifies whether to enable the system to automatically copy snapshots across regions.
        :param pulumi.Input[str] name: The snapshot policy name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] repeat_weekdays: The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
               - A maximum of seven time points can be selected.
               - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        :param pulumi.Input[int] retention_days: The snapshot retention time, and the unit of measurement is day. Optional values:
               - -1: The automatic snapshots are retained permanently.
               - [1, 65536]: The number of days retained.
               Default value: -1.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_copy_regions: The destination region to which the snapshot is copied. You can set a destination region.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] time_points: The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
               - A maximum of 24 time points can be selected.
               - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutoSnapshotPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Auto Snapshot Policy resource.

        For information about ECS Auto Snapshot Policy and how to use it, see [What is Auto Snapshot Policy](https://www.alibabacloud.com/help/en/doc-detail/25527.htm).

        > **NOTE:** Available in v1.117.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ecs.AutoSnapshotPolicy("example",
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        ```

        ## Import

        ECS Auto Snapshot Policy can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/autoSnapshotPolicy:AutoSnapshotPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AutoSnapshotPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutoSnapshotPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copied_snapshots_retention_days: Optional[pulumi.Input[int]] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_points: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutoSnapshotPolicyArgs.__new__(AutoSnapshotPolicyArgs)

            __props__.__dict__["copied_snapshots_retention_days"] = copied_snapshots_retention_days
            __props__.__dict__["enable_cross_region_copy"] = enable_cross_region_copy
            __props__.__dict__["name"] = name
            if repeat_weekdays is None and not opts.urn:
                raise TypeError("Missing required property 'repeat_weekdays'")
            __props__.__dict__["repeat_weekdays"] = repeat_weekdays
            if retention_days is None and not opts.urn:
                raise TypeError("Missing required property 'retention_days'")
            __props__.__dict__["retention_days"] = retention_days
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_copy_regions"] = target_copy_regions
            if time_points is None and not opts.urn:
                raise TypeError("Missing required property 'time_points'")
            __props__.__dict__["time_points"] = time_points
            __props__.__dict__["status"] = None
        super(AutoSnapshotPolicy, __self__).__init__(
            'alicloud:ecs/autoSnapshotPolicy:AutoSnapshotPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            copied_snapshots_retention_days: Optional[pulumi.Input[int]] = None,
            enable_cross_region_copy: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            retention_days: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            time_points: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AutoSnapshotPolicy':
        """
        Get an existing AutoSnapshotPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] copied_snapshots_retention_days: The retention period of the snapshot copied across regions.
               - -1: The snapshot is permanently retained.
               - [1, 65535]: The automatic snapshot is retained for the specified number of days.
               Default value: -1.
        :param pulumi.Input[bool] enable_cross_region_copy: Specifies whether to enable the system to automatically copy snapshots across regions.
        :param pulumi.Input[str] name: The snapshot policy name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] repeat_weekdays: The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
               - A maximum of seven time points can be selected.
               - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        :param pulumi.Input[int] retention_days: The snapshot retention time, and the unit of measurement is day. Optional values:
               - -1: The automatic snapshots are retained permanently.
               - [1, 65536]: The number of days retained.
               Default value: -1.
        :param pulumi.Input[str] status: The status of Auto Snapshot Policy.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_copy_regions: The destination region to which the snapshot is copied. You can set a destination region.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] time_points: The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
               - A maximum of 24 time points can be selected.
               - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutoSnapshotPolicyState.__new__(_AutoSnapshotPolicyState)

        __props__.__dict__["copied_snapshots_retention_days"] = copied_snapshots_retention_days
        __props__.__dict__["enable_cross_region_copy"] = enable_cross_region_copy
        __props__.__dict__["name"] = name
        __props__.__dict__["repeat_weekdays"] = repeat_weekdays
        __props__.__dict__["retention_days"] = retention_days
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_copy_regions"] = target_copy_regions
        __props__.__dict__["time_points"] = time_points
        return AutoSnapshotPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="copiedSnapshotsRetentionDays")
    def copied_snapshots_retention_days(self) -> pulumi.Output[Optional[int]]:
        """
        The retention period of the snapshot copied across regions.
        - -1: The snapshot is permanently retained.
        - [1, 65535]: The automatic snapshot is retained for the specified number of days.
        Default value: -1.
        """
        return pulumi.get(self, "copied_snapshots_retention_days")

    @property
    @pulumi.getter(name="enableCrossRegionCopy")
    def enable_cross_region_copy(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the system to automatically copy snapshots across regions.
        """
        return pulumi.get(self, "enable_cross_region_copy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The snapshot policy name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="repeatWeekdays")
    def repeat_weekdays(self) -> pulumi.Output[Sequence[str]]:
        """
        The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
        - A maximum of seven time points can be selected.
        - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        """
        return pulumi.get(self, "repeat_weekdays")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Output[int]:
        """
        The snapshot retention time, and the unit of measurement is day. Optional values:
        - -1: The automatic snapshots are retained permanently.
        - [1, 65536]: The number of days retained.
        Default value: -1.
        """
        return pulumi.get(self, "retention_days")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of Auto Snapshot Policy.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetCopyRegions")
    def target_copy_regions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The destination region to which the snapshot is copied. You can set a destination region.
        """
        return pulumi.get(self, "target_copy_regions")

    @property
    @pulumi.getter(name="timePoints")
    def time_points(self) -> pulumi.Output[Sequence[str]]:
        """
        The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
        - A maximum of 24 time points can be selected.
        - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        return pulumi.get(self, "time_points")

