# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CapacityReservationArgs', 'CapacityReservation']

@pulumi.input_type
class CapacityReservationArgs:
    def __init__(__self__, *,
                 instance_amount: pulumi.Input[int],
                 instance_type: pulumi.Input[str],
                 zone_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 capacity_reservation_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 end_time_type: Optional[pulumi.Input[str]] = None,
                 match_criteria: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a CapacityReservation resource.
        :param pulumi.Input[int] instance_amount: The total number of instances that need to be reserved within the capacity reservation.
        :param pulumi.Input[str] instance_type: Instance type. Currently, you can only set the capacity reservation service for one instance type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
        :param pulumi.Input[str] capacity_reservation_name: Capacity reservation service name.
        :param pulumi.Input[str] description: description of the capacity reservation instance.
        :param pulumi.Input[bool] dry_run: Specifies whether to pre-check the API request. Valid values: `true` and `false`.
        :param pulumi.Input[str] end_time: end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
        :param pulumi.Input[str] end_time_type: Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
        :param pulumi.Input[str] match_criteria: The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
        :param pulumi.Input[str] platform: platform of the capacity reservation, value range `windows`, `linux`.
        :param pulumi.Input[str] resource_group_id: The resource group id.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        """
        pulumi.set(__self__, "instance_amount", instance_amount)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "zone_ids", zone_ids)
        if capacity_reservation_name is not None:
            pulumi.set(__self__, "capacity_reservation_name", capacity_reservation_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if end_time_type is not None:
            pulumi.set(__self__, "end_time_type", end_time_type)
        if match_criteria is not None:
            pulumi.set(__self__, "match_criteria", match_criteria)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="instanceAmount")
    def instance_amount(self) -> pulumi.Input[int]:
        """
        The total number of instances that need to be reserved within the capacity reservation.
        """
        return pulumi.get(self, "instance_amount")

    @instance_amount.setter
    def instance_amount(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_amount", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Instance type. Currently, you can only set the capacity reservation service for one instance type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
        """
        return pulumi.get(self, "zone_ids")

    @zone_ids.setter
    def zone_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "zone_ids", value)

    @property
    @pulumi.getter(name="capacityReservationName")
    def capacity_reservation_name(self) -> Optional[pulumi.Input[str]]:
        """
        Capacity reservation service name.
        """
        return pulumi.get(self, "capacity_reservation_name")

    @capacity_reservation_name.setter
    def capacity_reservation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_reservation_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        description of the capacity reservation instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to pre-check the API request. Valid values: `true` and `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="endTimeType")
    def end_time_type(self) -> Optional[pulumi.Input[str]]:
        """
        Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
        """
        return pulumi.get(self, "end_time_type")

    @end_time_type.setter
    def end_time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time_type", value)

    @property
    @pulumi.getter(name="matchCriteria")
    def match_criteria(self) -> Optional[pulumi.Input[str]]:
        """
        The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
        """
        return pulumi.get(self, "match_criteria")

    @match_criteria.setter
    def match_criteria(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_criteria", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        platform of the capacity reservation, value range `windows`, `linux`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CapacityReservationState:
    def __init__(__self__, *,
                 capacity_reservation_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 end_time_type: Optional[pulumi.Input[str]] = None,
                 instance_amount: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 match_criteria: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 start_time_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_slot: Optional[pulumi.Input[str]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering CapacityReservation resources.
        :param pulumi.Input[str] capacity_reservation_name: Capacity reservation service name.
        :param pulumi.Input[str] description: description of the capacity reservation instance.
        :param pulumi.Input[bool] dry_run: Specifies whether to pre-check the API request. Valid values: `true` and `false`.
        :param pulumi.Input[str] end_time: end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
        :param pulumi.Input[str] end_time_type: Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
        :param pulumi.Input[int] instance_amount: The total number of instances that need to be reserved within the capacity reservation.
        :param pulumi.Input[str] instance_type: Instance type. Currently, you can only set the capacity reservation service for one instance type.
        :param pulumi.Input[str] match_criteria: The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
        :param pulumi.Input[str] payment_type: The payment type of the resource
        :param pulumi.Input[str] platform: platform of the capacity reservation, value range `windows`, `linux`.
        :param pulumi.Input[str] resource_group_id: The resource group id.
        :param pulumi.Input[str] start_time: time of the capacity reservation which become active.
        :param pulumi.Input[str] start_time_type: The capacity is scheduled to take effect. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        :param pulumi.Input[str] status: The status of the capacity reservation.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        :param pulumi.Input[str] time_slot: This parameter is under test and is not yet open for use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
        """
        if capacity_reservation_name is not None:
            pulumi.set(__self__, "capacity_reservation_name", capacity_reservation_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if end_time_type is not None:
            pulumi.set(__self__, "end_time_type", end_time_type)
        if instance_amount is not None:
            pulumi.set(__self__, "instance_amount", instance_amount)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if match_criteria is not None:
            pulumi.set(__self__, "match_criteria", match_criteria)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if start_time_type is not None:
            pulumi.set(__self__, "start_time_type", start_time_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_slot is not None:
            pulumi.set(__self__, "time_slot", time_slot)
        if zone_ids is not None:
            pulumi.set(__self__, "zone_ids", zone_ids)

    @property
    @pulumi.getter(name="capacityReservationName")
    def capacity_reservation_name(self) -> Optional[pulumi.Input[str]]:
        """
        Capacity reservation service name.
        """
        return pulumi.get(self, "capacity_reservation_name")

    @capacity_reservation_name.setter
    def capacity_reservation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_reservation_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        description of the capacity reservation instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to pre-check the API request. Valid values: `true` and `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="endTimeType")
    def end_time_type(self) -> Optional[pulumi.Input[str]]:
        """
        Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
        """
        return pulumi.get(self, "end_time_type")

    @end_time_type.setter
    def end_time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time_type", value)

    @property
    @pulumi.getter(name="instanceAmount")
    def instance_amount(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of instances that need to be reserved within the capacity reservation.
        """
        return pulumi.get(self, "instance_amount")

    @instance_amount.setter
    def instance_amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_amount", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type. Currently, you can only set the capacity reservation service for one instance type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="matchCriteria")
    def match_criteria(self) -> Optional[pulumi.Input[str]]:
        """
        The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
        """
        return pulumi.get(self, "match_criteria")

    @match_criteria.setter
    def match_criteria(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_criteria", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        platform of the capacity reservation, value range `windows`, `linux`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        time of the capacity reservation which become active.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="startTimeType")
    def start_time_type(self) -> Optional[pulumi.Input[str]]:
        """
        The capacity is scheduled to take effect. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        """
        return pulumi.get(self, "start_time_type")

    @start_time_type.setter
    def start_time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the capacity reservation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeSlot")
    def time_slot(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter is under test and is not yet open for use.
        """
        return pulumi.get(self, "time_slot")

    @time_slot.setter
    def time_slot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_slot", value)

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
        """
        return pulumi.get(self, "zone_ids")

    @zone_ids.setter
    def zone_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zone_ids", value)


class CapacityReservation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_reservation_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 end_time_type: Optional[pulumi.Input[str]] = None,
                 instance_amount: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 match_criteria: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Ecs Capacity Reservation resource.

        For information about Ecs Capacity Reservation and how to use it, see [What is Capacity Reservation](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createcapacityreservation).

        > **NOTE:** Available in v1.195.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_instance_types = alicloud.ecs.get_instance_types(instance_type_family="ecs.g5")
        default_zones = alicloud.get_zones(available_resource_creation="Instance",
            available_instance_type=default_instance_types.ids[0])
        default_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_capacity_reservation = alicloud.ecs.CapacityReservation("defaultCapacityReservation",
            description="terraform-example",
            platform="linux",
            capacity_reservation_name="terraform-example",
            end_time_type="Unlimited",
            resource_group_id=default_resource_groups.ids[0],
            instance_amount=1,
            instance_type=default_instance_types.ids[0],
            match_criteria="Open",
            tags={
                "Created": "terraform-example",
            },
            zone_ids=[default_zones.zones[0].id])
        ```

        ## Import

        Ecs Capacity Reservation can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/capacityReservation:CapacityReservation example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] capacity_reservation_name: Capacity reservation service name.
        :param pulumi.Input[str] description: description of the capacity reservation instance.
        :param pulumi.Input[bool] dry_run: Specifies whether to pre-check the API request. Valid values: `true` and `false`.
        :param pulumi.Input[str] end_time: end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
        :param pulumi.Input[str] end_time_type: Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
        :param pulumi.Input[int] instance_amount: The total number of instances that need to be reserved within the capacity reservation.
        :param pulumi.Input[str] instance_type: Instance type. Currently, you can only set the capacity reservation service for one instance type.
        :param pulumi.Input[str] match_criteria: The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
        :param pulumi.Input[str] platform: platform of the capacity reservation, value range `windows`, `linux`.
        :param pulumi.Input[str] resource_group_id: The resource group id.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CapacityReservationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Ecs Capacity Reservation resource.

        For information about Ecs Capacity Reservation and how to use it, see [What is Capacity Reservation](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createcapacityreservation).

        > **NOTE:** Available in v1.195.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_instance_types = alicloud.ecs.get_instance_types(instance_type_family="ecs.g5")
        default_zones = alicloud.get_zones(available_resource_creation="Instance",
            available_instance_type=default_instance_types.ids[0])
        default_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_capacity_reservation = alicloud.ecs.CapacityReservation("defaultCapacityReservation",
            description="terraform-example",
            platform="linux",
            capacity_reservation_name="terraform-example",
            end_time_type="Unlimited",
            resource_group_id=default_resource_groups.ids[0],
            instance_amount=1,
            instance_type=default_instance_types.ids[0],
            match_criteria="Open",
            tags={
                "Created": "terraform-example",
            },
            zone_ids=[default_zones.zones[0].id])
        ```

        ## Import

        Ecs Capacity Reservation can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/capacityReservation:CapacityReservation example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CapacityReservationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CapacityReservationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_reservation_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 end_time_type: Optional[pulumi.Input[str]] = None,
                 instance_amount: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 match_criteria: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CapacityReservationArgs.__new__(CapacityReservationArgs)

            __props__.__dict__["capacity_reservation_name"] = capacity_reservation_name
            __props__.__dict__["description"] = description
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["end_time_type"] = end_time_type
            if instance_amount is None and not opts.urn:
                raise TypeError("Missing required property 'instance_amount'")
            __props__.__dict__["instance_amount"] = instance_amount
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["match_criteria"] = match_criteria
            __props__.__dict__["platform"] = platform
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            if zone_ids is None and not opts.urn:
                raise TypeError("Missing required property 'zone_ids'")
            __props__.__dict__["zone_ids"] = zone_ids
            __props__.__dict__["payment_type"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["start_time_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["time_slot"] = None
        super(CapacityReservation, __self__).__init__(
            'alicloud:ecs/capacityReservation:CapacityReservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity_reservation_name: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dry_run: Optional[pulumi.Input[bool]] = None,
            end_time: Optional[pulumi.Input[str]] = None,
            end_time_type: Optional[pulumi.Input[str]] = None,
            instance_amount: Optional[pulumi.Input[int]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            match_criteria: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            platform: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            start_time: Optional[pulumi.Input[str]] = None,
            start_time_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_slot: Optional[pulumi.Input[str]] = None,
            zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'CapacityReservation':
        """
        Get an existing CapacityReservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] capacity_reservation_name: Capacity reservation service name.
        :param pulumi.Input[str] description: description of the capacity reservation instance.
        :param pulumi.Input[bool] dry_run: Specifies whether to pre-check the API request. Valid values: `true` and `false`.
        :param pulumi.Input[str] end_time: end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
        :param pulumi.Input[str] end_time_type: Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
        :param pulumi.Input[int] instance_amount: The total number of instances that need to be reserved within the capacity reservation.
        :param pulumi.Input[str] instance_type: Instance type. Currently, you can only set the capacity reservation service for one instance type.
        :param pulumi.Input[str] match_criteria: The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
        :param pulumi.Input[str] payment_type: The payment type of the resource
        :param pulumi.Input[str] platform: platform of the capacity reservation, value range `windows`, `linux`.
        :param pulumi.Input[str] resource_group_id: The resource group id.
        :param pulumi.Input[str] start_time: time of the capacity reservation which become active.
        :param pulumi.Input[str] start_time_type: The capacity is scheduled to take effect. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        :param pulumi.Input[str] status: The status of the capacity reservation.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        :param pulumi.Input[str] time_slot: This parameter is under test and is not yet open for use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CapacityReservationState.__new__(_CapacityReservationState)

        __props__.__dict__["capacity_reservation_name"] = capacity_reservation_name
        __props__.__dict__["description"] = description
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["end_time_type"] = end_time_type
        __props__.__dict__["instance_amount"] = instance_amount
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["match_criteria"] = match_criteria
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["platform"] = platform
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["start_time_type"] = start_time_type
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_slot"] = time_slot
        __props__.__dict__["zone_ids"] = zone_ids
        return CapacityReservation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="capacityReservationName")
    def capacity_reservation_name(self) -> pulumi.Output[str]:
        """
        Capacity reservation service name.
        """
        return pulumi.get(self, "capacity_reservation_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        description of the capacity reservation instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to pre-check the API request. Valid values: `true` and `false`.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[str]:
        """
        end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="endTimeType")
    def end_time_type(self) -> pulumi.Output[str]:
        """
        Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
        """
        return pulumi.get(self, "end_time_type")

    @property
    @pulumi.getter(name="instanceAmount")
    def instance_amount(self) -> pulumi.Output[int]:
        """
        The total number of instances that need to be reserved within the capacity reservation.
        """
        return pulumi.get(self, "instance_amount")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        Instance type. Currently, you can only set the capacity reservation service for one instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="matchCriteria")
    def match_criteria(self) -> pulumi.Output[str]:
        """
        The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
        """
        return pulumi.get(self, "match_criteria")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[str]:
        """
        platform of the capacity reservation, value range `windows`, `linux`.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        time of the capacity reservation which become active.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="startTimeType")
    def start_time_type(self) -> pulumi.Output[str]:
        """
        The capacity is scheduled to take effect. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        """
        return pulumi.get(self, "start_time_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the capacity reservation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeSlot")
    def time_slot(self) -> pulumi.Output[str]:
        """
        This parameter is under test and is not yet open for use.
        """
        return pulumi.get(self, "time_slot")

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
        """
        return pulumi.get(self, "zone_ids")

